/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import sun.swing.CachedPainter;

public class MetalUtils {
    static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        MetalUtils.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    static void drawActiveButtonBorder(Graphics g, int x, int y, int w, int h) {
        MetalUtils.drawFlush3DBorder(g, x, y, w, h);
        g.setColor(MetalLookAndFeel.getPrimaryControl());
        g.drawLine(x + 1, y + 1, x + 1, h - 3);
        g.drawLine(x + 1, y + 1, w - 3, x + 1);
        g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        g.drawLine(x + 2, h - 2, w - 2, h - 2);
        g.drawLine(w - 2, y + 2, w - 2, h - 2);
    }

    static boolean drawGradient(Component c, Graphics g, String key, int x, int y, int w, int h, boolean vertical) {
        List gradient = (List)UIManager.get(key);
        if (gradient == null || !(g instanceof Graphics2D)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(c, (Graphics2D)g, gradient, x, y, w, h, vertical);
        return true;
    }

    private static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int w;
        private int h;

        GradientPainter(int count) {
            super(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component c, Graphics2D g, List gradient, int x, int y, int w, int h, boolean isVertical) {
            int imageHeight;
            int imageWidth;
            if (isVertical) {
                imageWidth = 64;
                imageHeight = h;
            } else {
                imageWidth = w;
                imageHeight = 64;
            }
            Object object = c.getTreeLock();
            synchronized (object) {
                this.w = w;
                this.h = h;
                this.paint(c, (Graphics)g, x, y, imageWidth, imageHeight, gradient, isVertical);
            }
        }

        @Override
        protected void paintToImage(Component c, Image image, Graphics g, int w, int h, Object[] args) {
            Graphics2D g2 = (Graphics2D)g;
            List gradient = (List)args[0];
            boolean isVertical = (Boolean)args[1];
            if (isVertical) {
                this.drawVerticalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h);
            } else {
                this.drawHorizontalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h);
            }
        }

        @Override
        protected void paintImage(Component c, Graphics g, int x, int y, int imageW, int imageH, Image image, Object[] args) {
            boolean isVertical = (Boolean)args[1];
            g.translate(x, y);
            if (isVertical) {
                for (int counter = 0; counter < this.w; counter += 64) {
                    int tileSize = Math.min(64, this.w - counter);
                    g.drawImage(image, counter, 0, counter + tileSize, this.h, 0, 0, tileSize, this.h, null);
                }
            } else {
                for (int counter = 0; counter < this.h; counter += 64) {
                    int tileSize = Math.min(64, this.h - counter);
                    g.drawImage(image, 0, counter, this.w, counter + tileSize, 0, 0, this.w, tileSize, null);
                }
            }
            g.translate(-x, -y);
        }

        private void drawVerticalGradient(Graphics2D g, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h) {
            int mid = (int)(ratio1 * (float)h);
            int mid2 = (int)(ratio2 * (float)h);
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, 0.0f, c1, 0.0f, mid, c2));
                g.fillRect(0, 0, w, mid);
            }
            if (mid2 > 0) {
                g.setColor(c2);
                g.fillRect(0, mid, w, mid2);
            }
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, (float)mid + (float)mid2, c2, 0.0f, (float)mid * 2.0f + (float)mid2, c1));
                g.fillRect(0, mid + mid2, w, mid);
            }
            if (h - mid * 2 - mid2 > 0) {
                g.setPaint(this.getGradient(0.0f, (float)mid * 2.0f + (float)mid2, c1, 0.0f, h, c3));
                g.fillRect(0, mid * 2 + mid2, w, h - mid * 2 - mid2);
            }
        }

        private void drawHorizontalGradient(Graphics2D g, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h) {
            int mid = (int)(ratio1 * (float)w);
            int mid2 = (int)(ratio2 * (float)w);
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, 0.0f, c1, mid, 0.0f, c2));
                g.fillRect(0, 0, mid, h);
            }
            if (mid2 > 0) {
                g.setColor(c2);
                g.fillRect(mid, 0, mid2, h);
            }
            if (mid > 0) {
                g.setPaint(this.getGradient((float)mid + (float)mid2, 0.0f, c2, (float)mid * 2.0f + (float)mid2, 0.0f, c1));
                g.fillRect(mid + mid2, 0, mid, h);
            }
            if (w - mid * 2 - mid2 > 0) {
                g.setPaint(this.getGradient((float)mid * 2.0f + (float)mid2, 0.0f, c1, w, 0.0f, c3));
                g.fillRect(mid * 2 + mid2, 0, w - mid * 2 - mid2, h);
            }
        }

        private GradientPaint getGradient(float x1, float y1, Color c1, float x2, float y2, Color c2) {
            return new GradientPaint(x1, y1, c1, x2, y2, c2, true);
        }
    }
}

