/*
 * Copyright (C) 2000-2022 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */
#ifndef HAVE_XITK_TABS_H
#define HAVE_XITK_TABS_H

#define MAX_TABS 64

typedef struct {
  xitk_new_widget_t      nw;
  int                    num_entries;
  const char * const    *entries;
  xitk_int_callback_t  callback;
} xitk_tabs_widget_t;

/** */
xitk_widget_t *xitk_noskin_tabs_create (const xitk_tabs_widget_t *t, int x, int y, int width, const char *font_name);
/** */
#define xitk_tabs_get_current_selected(_w) xitk_widget_select (_w, XITK_INT_KEEP)
/** */
#define xitk_tabs_set_current_selected(_w,index) xitk_widget_select (_w, index)

#endif
