// (C) by Immanuel Halupczok <xblast@karimmi.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#macro frameDefaults()
  #declare playerDamaged = 0;
  #declare playerHeight = 1.0;
  #declare playerLocation = z*-2.667;
  #declare bodyAngle = <0, 0, 0>;
  #declare FrontWind = <0, 0, 0>;
#end




#if (playerWinning)
  #local c=playerAnimationClock;
  frameDefaults()
  #switch (c)
    #case (2)
      #declare playerHeight = 3.0;
      #declare FrontWind = 0.1*x;
      #declare bodyAngle = 20*x;
    #break
    #case (1)
      #declare playerHeight = 4.2;
      #declare FrontWind = 0.2*x;
      #declare bodyAngle = 30*x;
    #break
    #case (0)
      #declare playerHeight = 4.6;
      #declare FrontWind = 0.3*x;
      #declare bodyAngle = 35*x;
    #break
  #end 

#end


#if (playerLosing)
  #local c=playerAnimationClock;
  frameDefaults()

  #switch (c)
     #case (0) 
       #declare bodyAngle          = <  -10,   0,  0>;
     #break
     #case (1) 
       #declare bodyAngle          = <  -10,  15,  0>;
     #break
     #case (2) 
       #declare bodyAngle          = <  -10, -15,  0>;
     #break
  #end
#end


#if (playerKilled)
  frameDefaults()
  #declare playerDamaged = 1;
  #declare bodyAngle          = 15 * x;
#end


#if (playerWalking)
  #local c=playerAnimationClock;
  frameDefaults()

  #switch (c)
     #case (0) 
       #declare playerHeight = 1.0;
       #declare FrontWind = <0, -0.2, 0.4>;
     #break
     #case (1) 
       #declare playerHeight = 2.2;
       #declare FrontWind = <0, 0.4, 0.4>;
     #break
     #case (2) 
       #declare playerHeight = 2.6;
       #declare FrontWind = <0, 0, 0.4>;
     #break
     #case (3) 
       #declare playerHeight = 2.2;
       #declare FrontWind = <0, -0.4, 0.4>;
     #break
  #end
#end




#if (playerStanding)
  frameDefaults()
  #declare bodyAngle = < 5, 0, 0 >;
#end

