/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Molecule;
import org.jmol.shape.ShapeRenderer;

public class BallsRenderer
extends ShapeRenderer {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    protected void render() {
        int n;
        int n2;
        int n3;
        int n4;
        Point3f point3f;
        boolean bl = !this.viewer.getWireframeRotation() || !this.viewer.getInMotion();
        boolean bl2 = this.viewer.getSlabEnabled();
        boolean bl3 = this.modelSet.getAtomCount() > 0 && this.viewer.getShowNavigationPoint() && this.exportType == 0 && this.g3d.setColix((short)4);
        Point3f point3f2 = point3f = bl3 ? new Point3f(this.viewer.getNavigationOffset()) : null;
        if (bl2) {
            this.minZ = this.g3d.getSlab();
            this.maxZ = this.g3d.getDepth();
        }
        if (bl3) {
            this.minX = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxY = Integer.MIN_VALUE;
        }
        Atom[] atomArray = this.modelSet.atoms;
        int n5 = this.modelSet.getAtomCount();
        BitSet bitSet = new BitSet();
        int n6 = n5;
        while (--n6 >= 0) {
            Atom atom = atomArray[n6];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            bitSet.set(n6);
            atom.transform(this.viewer);
        }
        n6 = this.viewer.getSlabByMolecule() ? 1 : 0;
        boolean bl4 = this.viewer.getSlabByAtom();
        if (n6 != 0 && bl2) {
            Molecule[] moleculeArray = this.modelSet.getMolecules();
            int n7 = this.modelSet.getMoleculeCountInModel(-1);
            for (n4 = 0; n4 < n7; ++n4) {
                Molecule molecule = moleculeArray[n4];
                n3 = 0;
                n2 = molecule.firstAtomIndex;
                if (!bitSet.get(n2)) continue;
                while (n3 < molecule.nAtoms && !this.g3d.isClippedZ(atomArray[n2].screenZ - (atomArray[n2].screenDiameter >> 1))) {
                    ++n3;
                    ++n2;
                }
                if (n3 == molecule.nAtoms) continue;
                n2 = molecule.firstAtomIndex;
                for (n = 0; n < molecule.nAtoms; ++n) {
                    bitSet.clear(n2);
                    atomArray[n2++].screenZ = 0;
                }
            }
        }
        int n8 = n5;
        while (--n8 >= 0) {
            if (!bitSet.get(n8)) continue;
            Atom atom = atomArray[n8];
            if (bl2 && this.g3d.isClippedZ(atom.screenZ - (bl4 ? atomArray[n8].screenDiameter >> 1 : 0))) {
                atom.setClickable(0);
                n4 = (bl4 ? -1 : 1) * atom.screenDiameter / 2;
                if (atom.screenZ + n4 < this.minZ || atom.screenZ - n4 > this.maxZ || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) continue;
            }
            if (!bl || atom.screenDiameter <= 0 || (atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || !this.g3d.setColix(atom.getColix())) continue;
            if (bl3) {
                if (atom.screenX < this.minX) {
                    this.minX = atom.screenX;
                }
                if (atom.screenX > this.maxX) {
                    this.maxX = atom.screenX;
                }
                if (atom.screenY < this.minY) {
                    this.minY = atom.screenY;
                }
                if (atom.screenY > this.maxY) {
                    this.maxY = atom.screenY;
                }
            }
            this.g3d.drawAtom(atom);
        }
        if (bl3) {
            n8 = this.g3d.isAntialiased() ? 1 : 0;
            float f = this.viewer.getNavigationDepthPercent();
            this.g3d.setColix((short)(f < 0.0f ? 10 : (f > 100.0f ? 11 : 23)));
            n4 = Math.max(Math.min(this.viewer.getScreenWidth(), (int)point3f.x), 0);
            int n9 = Math.max(Math.min(this.viewer.getScreenHeight(), (int)point3f.y), 0);
            n3 = (int)point3f.z + 1;
            n2 = n8 != 0 ? 8 : 4;
            n = n8 != 0 ? 20 : 10;
            int n10 = n8 != 0 ? 2 : 1;
            this.g3d.drawRect(n4 - n2, n9, n3, 0, n, n10);
            this.g3d.drawRect(n4, n9 - n2, n3, 0, n10, n);
            this.g3d.drawRect(n4 - n2, n9 - n2, n3, 0, n, n);
            n2 = n;
            this.g3d.setColix((float)this.maxX < point3f.x ? (short)21 : 11);
            this.g3d.drawRect(n4 - n2, n9, n3, 0, n >>= 1, n10);
            this.g3d.setColix((float)this.minX > point3f.x ? (short)21 : 11);
            this.g3d.drawRect(n4 + n, n9, n3, 0, n, n10);
            this.g3d.setColix((float)this.maxY < point3f.y ? (short)21 : 11);
            this.g3d.drawRect(n4, n9 - n2, n3, 0, n10, n);
            this.g3d.setColix((float)this.minY > point3f.y ? (short)21 : 11);
            this.g3d.drawRect(n4, n9 + n, n3, 0, n10, n);
        }
    }
}

