/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.InputStream;
import rene.gui.Global;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;

class LogoWindow
extends Window
implements Runnable {
    ZirkelFrame ZF;
    Image I;

    public LogoWindow(ZirkelFrame zirkelFrame) {
        super(zirkelFrame);
        this.setSize(400, 300);
        Dimension dimension = this.getSize();
        String string = "zirkelframe";
        int n = Global.getParameter(string + ".x", 100);
        int n2 = Global.getParameter(string + ".y", 100);
        int n3 = Global.getParameter(string + ".w", 600);
        int n4 = Global.getParameter(string + ".h", 600);
        this.setLocation(n + n3 / 2 - dimension.width / 2, n2 + n4 / 2 - dimension.height / 2);
        this.loadLogo();
        this.setVisible(true);
        new Thread(this).start();
    }

    public void loadLogo() {
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream("/rene/zirkel/logowindow.gif");
            int n2 = 0;
            int n3 = inputStream.available();
            byte[] byArray = new byte[200000];
            while (n3 > 0 && (n = inputStream.read(byArray, n2, n3)) >= 0) {
                n2 += n;
                n3 = inputStream.available();
            }
            inputStream.close();
            this.I = Toolkit.getDefaultToolkit().createImage(byArray, 0, n2);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.I, 0);
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            this.setVisible(false);
            this.I = null;
        }
    }

    public void paint(Graphics graphics) {
        if (this.I == null) {
            return;
        }
        graphics.drawImage(this.I, 0, 0, this);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setFont(new Font("Dialog", 1, 14));
        String string = Zirkel.name("version") + " " + Zirkel.name("program.version");
        graphics.setColor(Color.black);
        graphics.drawString(string, 45, 270);
    }

    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
    }
}

