/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.shape.Object2d;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class ScriptEvaluator {
    public static final String SCRIPT_COMPLETED = "Script completed";
    private boolean tQuiet;
    protected boolean isSyntaxCheck;
    private boolean isCmdLine_C_Option;
    protected boolean isCmdLine_c_or_C_Option;
    private boolean historyDisabled;
    protected boolean logMessages;
    private boolean debugScript;
    private boolean interruptExecution;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean isExecuting;
    private long timeBeginExecution;
    private long timeEndExecution;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    private static final int scriptLevelMax = 10;
    private Thread currentThread;
    protected Viewer viewer;
    protected ScriptCompiler compiler;
    private Hashtable definedAtomSets;
    private StringBuffer outputBuffer;
    private ScriptContext[] stack = new ScriptContext[10];
    private String contextPath = "";
    private String filename;
    private String functionName;
    private boolean isStateScript;
    private int scriptLevel;
    private int scriptReportingLevel = 0;
    private int commandHistoryLevelMax = 0;
    private Token[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private Hashtable contextVariables;
    private String script;
    protected int pc;
    private String thisCommand;
    private String fullCommand;
    private Token[] statement;
    private int statementLength;
    private int iToken;
    private int lineEnd;
    private int pcEnd;
    private String scriptExtensions;
    private boolean error;
    private String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    static final int ERROR_endOfStatementUnexpected = 13;
    static final int ERROR_expressionExpected = 14;
    static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    static final int ERROR_fileNotFoundException = 17;
    static final int ERROR_incompatibleArguments = 18;
    static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    static final int ERROR_invalidArgument = 22;
    static final int ERROR_invalidParameterOrder = 23;
    static final int ERROR_keywordExpected = 24;
    static final int ERROR_moCoefficients = 25;
    static final int ERROR_moIndex = 26;
    static final int ERROR_moModelError = 27;
    static final int ERROR_moOccupancy = 28;
    static final int ERROR_moOnlyOne = 29;
    static final int ERROR_multipleModelsNotOK = 30;
    static final int ERROR_noData = 31;
    static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    static final int ERROR_what = 53;
    static final int ERROR_writeWhat = 54;
    private Token[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private int theTok;
    private Token theToken;
    private boolean coordinatesAreFractional;
    private Object[] data;

    public ScriptEvaluator(Viewer viewer) {
        this.viewer = viewer;
        this.compiler = viewer.compiler;
        this.definedAtomSets = viewer.definedAtomSets;
    }

    public boolean compileScriptString(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = "[script]";
        return this.compileScript(null, string, this.debugScript);
    }

    public boolean compileScriptFile(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = string;
        return this.compileScriptFileInternal(string, null, null, null);
    }

    public void evaluateCompiledScript(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = bl2;
        this.viewer.pushHoldRepaint("runEval");
        this.executionPaused = false;
        this.interruptExecution = false;
        this.executionStepping = false;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isCmdLine_c_or_C_Option = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = bl3;
        this.setErrorMessage(null);
        try {
            try {
                this.setScriptExtensions();
                this.instructionDispatchLoop(bl4);
                String string = this.viewer.getInterruptScript();
                if (string != "") {
                    this.runScript(string, null);
                }
            }
            catch (Error error) {
                this.viewer.handleError(error, false);
                this.setErrorMessage("" + error + " " + this.viewer.getShapeErrorState());
                this.errorMessageUntranslated = "" + error;
                this.scriptStatusOrBuffer(this.errorMessage);
            }
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            this.errorMessageUntranslated = scriptException.getErrorMessageUntranslated();
            this.scriptStatusOrBuffer(this.errorMessage);
            this.viewer.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.isCmdLine_C_Option = bl5;
        if (this.errorMessage == null && this.interruptExecution) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus(SCRIPT_COMPLETED);
        }
        bl3 = false;
        bl = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint("runEval");
    }

    public void runScript(String string, StringBuffer stringBuffer) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = stringBuffer;
        if (this.compileScript(null, string + "\u0001## EDITOR_IGNORE ##", false)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext();
    }

    public ScriptContext checkScriptSilent(String string) {
        ScriptContext scriptContext = this.compiler.compile(null, string, false, true, false, true);
        if (scriptContext.errorType != null) {
            return scriptContext;
        }
        this.getScriptContext(scriptContext, false);
        this.isSyntaxCheck = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            scriptContext = this.getScriptContext();
        }
        this.isSyntaxCheck = false;
        return scriptContext;
    }

    public void setDebugging() {
        this.debugScript = this.viewer.getDebugScript();
        this.logMessages = this.debugScript && Logger.debugging;
    }

    public int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    public void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = true;
    }

    public void pauseExecution() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.delay(-100L);
        this.viewer.popHoldRepaint("pauseExecution");
        this.executionStepping = false;
        this.executionPaused = true;
    }

    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    public boolean isScriptExecuting() {
        return this.isExecuting && !this.interruptExecution;
    }

    public boolean isExecutionPaused() {
        return this.executionPaused;
    }

    public boolean isExecutionStepping() {
        return this.executionStepping;
    }

    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, this.statementAsString(this.aatoken[this.pc], -9999)) : "";
    }

    private String getCommand(int n, boolean bl, boolean bl2) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        if (bl) {
            int n2 = -1;
            int n3 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[n]) {
                    if (n2 < 0) {
                        n2 = this.lineIndices[i][0];
                    }
                    n3 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[n]) break;
            }
            if (n3 == this.script.length() - 1 && this.script.endsWith("}")) {
                ++n3;
            }
            return n2 == this.script.length() || n3 < n2 ? "" : this.script.substring(Math.max(n2, 0), Math.min(this.script.length(), n3));
        }
        int n4 = this.lineIndices[n][0];
        int n5 = this.lineIndices[n][1];
        String string = "";
        if (n4 < 0 || n5 <= n4 || n5 > this.script.length()) {
            return "";
        }
        try {
            string = this.script.substring(n4, n5);
            if (string.indexOf("\\\n") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\n", "  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\r", "  ");
            }
            if (string.length() > 0 && !string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n4 + " ichEnd=" + n5 + " len = " + this.script.length() + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(int n) {
        if (this.logMessages) {
            if (this.statement.length > 0) {
                Logger.debug(this.statement[0].toString());
            }
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug(this.statement[i].toString());
            }
        }
        this.iToken = -9999;
        if (this.logMessages) {
            StringBuffer stringBuffer = new StringBuffer(80);
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            stringBuffer.append(string).append(this.statementAsString(this.statement, this.iToken));
            this.viewer.scriptStatus(stringBuffer.toString());
        } else {
            String string = this.getCommand(this.pc, false, false);
            this.viewer.scriptStatus(string);
        }
    }

    public static Object evaluateExpression(Viewer viewer, Object object) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator(viewer);
        try {
            if (object instanceof String) {
                if (scriptEvaluator.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    scriptEvaluator.contextVariables = viewer.getContextVariables();
                    scriptEvaluator.setStatement(0);
                    return scriptEvaluator.parameterExpression(2, 0, "", false);
                }
            } else if (object instanceof Token[]) {
                scriptEvaluator.contextVariables = viewer.getContextVariables();
                return scriptEvaluator.expression((Token[])object, 0, 0, true, false, true, false);
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + object + "\n" + exception);
        }
        return "ERROR";
    }

    public static BitSet getAtomBitSet(ScriptEvaluator scriptEvaluator, Object object) {
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        BitSet bitSet = new BitSet();
        try {
            scriptEvaluator.pushContext(null);
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters(string, "\n\r", "),(");
            string = TextFormat.simpleReplace(string, "()", "(none)");
            if (scriptEvaluator.compileScript(null, string, false)) {
                scriptEvaluator.statement = scriptEvaluator.aatoken[0];
                bitSet = scriptEvaluator.expression(scriptEvaluator.statement, 1, 0, false, false, true, true);
            }
            scriptEvaluator.popContext();
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bitSet;
    }

    public static Vector getAtomBitSetVector(ScriptEvaluator scriptEvaluator, int n, Object object) {
        Vector<Integer> vector = new Vector<Integer>();
        BitSet bitSet = ScriptEvaluator.getAtomBitSet(scriptEvaluator, object);
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            vector.addElement(new Integer(n2));
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return vector;
    }

    private Object parameterExpression(int n, int n2, String string, boolean bl) throws ScriptException {
        return this.parameterExpression(n, n2, string, bl, -1, false, null, null);
    }

    private Object parameterExpression(int n, int n2, String string, boolean bl, int n3, boolean bl2, Hashtable hashtable, String string2) throws ScriptException {
        ScriptVariable scriptVariable;
        boolean bl3;
        boolean bl4 = string2 != null;
        boolean bl5 = n < 0;
        boolean bl6 = string == null;
        boolean bl7 = bl3 = string != null && string.length() == 0;
        if (bl5) {
            n = -n;
        }
        int n4 = 0;
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, bl2, bl);
        if (n == 0 && n2 == 0) {
            n = 2;
        }
        if (n2 < n) {
            n2 = this.statementLength;
        }
        block25: for (int i = n; i < n2; ++i) {
            Object object = null;
            int n5 = this.getToken((int)i).tok;
            if (bl4 && this.tokAt(i + 1) != 0x100008) {
                ScriptVariable scriptVariable2;
                ScriptVariable scriptVariable3 = scriptVariable2 = hashtable != null && hashtable.containsKey(this.theToken.value) ? null : this.getBitsetPropertySelector(i, false);
                if (scriptVariable2 != null) {
                    scriptMathProcessor.addX((ScriptVariable)hashtable.get(string2));
                    if (!scriptMathProcessor.addOp(scriptVariable2)) {
                        this.error(22);
                    }
                    if (scriptVariable2.intValue == 135368708 && this.tokAt(this.iToken + 1) != 0x10100010) {
                        scriptMathProcessor.addOp(Token.tokenLeftParen);
                        scriptMathProcessor.addOp(Token.tokenRightParen);
                    }
                    i = this.iToken;
                    continue;
                }
            }
            switch (n5) {
                case 135369225: {
                    if (this.getToken((int)(++i)).tok != 0x10100010) {
                        this.error(22);
                    }
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, ScriptVariable>();
                    }
                    Object object2 = this.parameterExpression(++i, -1, null, false, -1, false, hashtable, string2);
                    boolean bl8 = (Boolean)object2;
                    int n6 = this.iToken;
                    if (this.getToken((int)n6++).tok != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(n6, -1, null, false);
                    int n7 = this.iToken;
                    if (this.tokAt(n7++) != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(-n7, -1, null, false, 1, false, hashtable, string2);
                    int n8 = this.iToken;
                    if (this.tokAt(n8) != 0x10100011) {
                        this.error(22);
                    }
                    object = this.parameterExpression(bl8 ? n6 : n7, bl8 ? n7 : n8, "XXX", false, 1, false, hashtable, string2);
                    i = n8;
                    break;
                }
                case 135280129: 
                case 135369224: {
                    int n9;
                    int n10;
                    String string3;
                    boolean bl9;
                    Object object2;
                    boolean bl10 = n > 0;
                    boolean bl11 = bl9 = bl10 && n5 == 135369224;
                    if (bl10) {
                        if (this.getToken((int)(++i)).tok != 0x10100010 || !Token.tokAttr(this.getToken((int)(++i)).tok, 0x40000000)) {
                            this.error(22);
                        }
                        string3 = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x10000F) {
                            this.error(22);
                        }
                    } else {
                        string3 = "_x";
                    }
                    if (!((object = this.tokenSetting((int)(-(++i))).value) instanceof BitSet)) {
                        this.error(22);
                    }
                    BitSet bitSet = (BitSet)object;
                    i = this.iToken;
                    if (bl10 && this.getToken((int)i++).tok != 0x10000F) {
                        this.error(22);
                    }
                    BitSet bitSet2 = new BitSet();
                    BitSet bitSet3 = new BitSet();
                    String[] stringArray = bl9 ? new String[BitSetUtil.cardinalityOf(bitSet)] : null;
                    ScriptVariable scriptVariable4 = null;
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    bitSet3.set(0);
                    scriptVariable4 = ScriptVariable.getVariableSelected(0, bitSet3).setName(string3);
                    hashtable.put(string3, scriptVariable4);
                    int n11 = -1;
                    if (bl10) {
                        n11 = i - 1;
                        n10 = 0;
                        while (n10 >= 0 && ++n11 < n2) {
                            n9 = this.tokAt(n11);
                            if (n9 == 0x10100011) {
                                --n10;
                                continue;
                            }
                            if (n9 != 0x10100010) continue;
                            ++n10;
                        }
                    }
                    n10 = 0;
                    n9 = 0;
                    int n12 = bitSet.nextSetBit(0);
                    if (n12 < 0) {
                        this.iToken = n11 - 1;
                    } else if (!this.isSyntaxCheck) {
                        while (n12 >= 0) {
                            if (n9 >= 0) {
                                bitSet3.clear(n9);
                            }
                            n9 = n12;
                            bitSet3.set(n12);
                            scriptVariable4.index = n12;
                            object2 = this.parameterExpression(i, n11, bl9 ? "XXX" : null, bl9, n12, false, hashtable, bl10 ? null : string3);
                            if (bl9) {
                                if (object2 == null || ((Vector)object2).size() == 0) {
                                    this.error(22);
                                }
                                stringArray[n10++] = ScriptVariable.sValue((ScriptVariable)((Vector)object2).elementAt(0));
                            } else if (((Boolean)object2).booleanValue()) {
                                bitSet2.set(n12);
                            }
                            n12 = bitSet.nextSetBit(n12 + 1);
                        }
                    }
                    if (bl9) {
                        object = stringArray;
                    } else if (bl10) {
                        object = bitSet2;
                    } else {
                        return this.bitsetVariableVector(bitSet2);
                    }
                    i = this.iToken + 1;
                    break;
                }
                case 0x10000F: {
                    break block25;
                }
                case 3: {
                    scriptMathProcessor.addXNum(ScriptVariable.getVariable(this.theToken.value));
                    break;
                }
                case 2: 
                case 1048614: {
                    scriptMathProcessor.addXNum(ScriptVariable.intVariable(this.theToken.intValue));
                    break;
                }
                case 135266313: {
                    if (this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (scriptMathProcessor.addOp(this.theToken, true)) break;
                        this.error(22);
                        break;
                    }
                    scriptMathProcessor.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 0x100004: 
                case 0x100006: 
                case 0x10000C: 
                case 0x10000D: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087375361: 
                case 1087375362: 
                case 1087375365: 
                case 1095761934: 
                case 1095761938: 
                case 1095766028: 
                case 1104154627: 
                case 1679429641: {
                    scriptMathProcessor.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 0x100007: {
                    scriptMathProcessor.addX(new ScriptVariable(7, this.centerParameter(i)));
                    i = this.iToken;
                    break;
                }
                case 0x10000A: {
                    object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    if (this.tokAt(i + 1) == 0x100003 && this.tokAt(i + 2) == 0x100002) {
                        n5 = 0x100003;
                        this.iToken += 2;
                    }
                }
                case 0x100003: {
                    object = n5 == 0x100003 ? this.viewer.getModelAtomBitSet(-1, true) : this.expression(this.statement, i, 0, true, true, true, true);
                    i = this.iToken++;
                    if (n4 != 0 || !bl5) break;
                    return this.bitsetVariableVector(object);
                }
                case 0x100002: {
                    ++i;
                    break block25;
                }
                case 0x10000E: {
                    this.error(22);
                    break;
                }
                case 0x10100030: {
                    if (scriptMathProcessor.addOp(this.theToken)) break;
                    this.error(22);
                    break;
                }
                case 0x100008: {
                    ScriptVariable scriptVariable5 = this.getBitsetPropertySelector(i + 1, false);
                    if (scriptVariable5 == null) {
                        this.error(22);
                    }
                    boolean bl12 = scriptVariable5.intValue == 135368708;
                    boolean bl13 = true;
                    int n13 = this.tokAt(this.iToken + 2);
                    if (this.tokAt(this.iToken + 1) == 0x100008) {
                        switch (n13) {
                            case 0x100003: {
                                n13 = 480;
                                if (this.tokAt(this.iToken + 3) == 0x100008 && this.tokAt(this.iToken + 4) == 1276118529) {
                                    n13 = 224;
                                }
                            }
                            case 32: 
                            case 64: 
                            case 96: 
                            case 128: 
                            case 160: 
                            case 192: {
                                bl13 = bl12 || n13 == 480 || n13 == 224;
                                scriptVariable5.intValue |= n13;
                                this.getToken(this.iToken + 2);
                            }
                        }
                    }
                    if (!scriptMathProcessor.addOp(scriptVariable5, bl13 &= this.tokAt(this.iToken + 1) == 0x10100010 || bl12)) {
                        this.error(22);
                    }
                    i = this.iToken;
                    if (scriptVariable5.intValue != 135368708 || this.tokAt(i + 1) == 0x10100010) break;
                    scriptMathProcessor.addOp(Token.tokenLeftParen);
                    scriptMathProcessor.addOp(Token.tokenRightParen);
                    break;
                }
                default: {
                    if (Token.tokAttr(this.theTok, 0x10100000) || Token.tokAttr(this.theTok, 0x8100000)) {
                        if (!scriptMathProcessor.addOp(this.theToken)) {
                            if (n3 >= 0) break block25;
                            this.error(22);
                        }
                        if (this.theTok == 0x10100010) {
                            ++n4;
                            break;
                        }
                        if (this.theTok != 0x10100011 || --n4 != 0 || !bl5) break;
                        ++this.iToken;
                        break block25;
                    }
                    if (Token.tokAttr(this.theTok, 0x40000000) && this.viewer.isFunction((String)this.theToken.value)) {
                        if (!scriptMathProcessor.addOp(new ScriptVariable(135368708, this.theToken.value))) {
                            this.error(22);
                        }
                        if (this.tokAt(i + 1) == 0x10100010) break;
                        scriptMathProcessor.addOp(Token.tokenLeftParen);
                        scriptMathProcessor.addOp(Token.tokenRightParen);
                        break;
                    }
                    String string4 = this.parameterAsString(i).toLowerCase();
                    if (this.isSyntaxCheck) {
                        object = string4;
                        break;
                    }
                    if (hashtable != null && (object = hashtable.get(string4)) != null || (object = this.getContextVariableAsVariable(string4)) != null) break;
                    scriptMathProcessor.addX(this.viewer.getOrSetNewVariable(string4, false));
                    break;
                }
            }
            if (object == null) continue;
            if (object instanceof BitSet) {
                scriptMathProcessor.addX((BitSet)object);
                continue;
            }
            scriptMathProcessor.addX(object);
        }
        if ((scriptVariable = scriptMathProcessor.getResult(false, string)) == null) {
            if (!this.isSyntaxCheck) {
                scriptMathProcessor.dumpStacks("null result");
            }
            this.error(13);
        }
        if (scriptVariable.tok == 135233) {
            return scriptVariable.value;
        }
        if (bl6) {
            return ScriptVariable.bValue(scriptVariable);
        }
        if (bl3) {
            if (scriptVariable.tok == 4) {
                scriptVariable.intValue = Integer.MAX_VALUE;
            }
            return ScriptVariable.sValue(scriptVariable);
        }
        switch (scriptVariable.tok) {
            case 0x10000C: 
            case 0x10000D: {
                return scriptVariable.intValue == 1;
            }
            case 2: {
                return new Integer(scriptVariable.intValue);
            }
        }
        return scriptVariable.value;
    }

    Object bitsetVariableVector(Object object) {
        Vector<ScriptVariable> vector = new Vector<ScriptVariable>();
        if (object instanceof BitSet) {
            vector.addElement(new ScriptVariable(9, object));
        }
        return vector;
    }

    Object getBitsetIdent(BitSet bitSet, String stringArray, Object object, boolean bl, int n, boolean bl2) {
        int n2;
        Hashtable hashtable;
        int[] nArray;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = !(object instanceof Bond.BondSet);
        if (bl4) {
            if (stringArray == null) {
                stringArray = this.viewer.getStandardLabelFormat();
            } else if (stringArray.length() == 0) {
                stringArray = "%[label]";
            }
        }
        int n3 = stringArray == null ? -1 : stringArray.indexOf("%");
        boolean bl6 = bl3 = n != Integer.MAX_VALUE;
        if (bitSet == null || this.isSyntaxCheck || bl4 && n3 < 0) {
            String[] stringArray2;
            if (stringArray == null) {
                stringArray = "";
            }
            if (bl2) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = stringArray;
            } else {
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        ModelSet modelSet = this.viewer.getModelSet();
        int n4 = 0;
        int[] nArray2 = nArray = bl4 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && stringArray != null && stringArray.indexOf("%D") > 0) {
            nArray = this.viewer.getAtomIndices(bitSet);
        }
        boolean bl7 = stringArray == null || stringArray.length() == 0;
        Hashtable hashtable2 = hashtable = bl4 || bl7 ? null : LabelToken.getBondLabelValues();
        LabelToken[] labelTokenArray = bl7 ? null : (bl4 ? LabelToken.compile(this.viewer, (String)stringArray, '\u0000', null) : LabelToken.compile(this.viewer, (String)stringArray, '\u0001', hashtable));
        int n5 = bl3 ? 1 : BitSetUtil.cardinalityOf(bitSet);
        String[] stringArray4 = new String[n5];
        int n6 = n2 = bl3 ? n : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            String string;
            if (bl4) {
                string = bl7 ? modelSet.getAtomAt(n2).getInfo() : LabelToken.formatLabel(this.viewer, modelSet.getAtomAt(n2), null, labelTokenArray, '\u0000', nArray);
            } else {
                Bond bond = modelSet.getBondAt(n2);
                string = bl7 ? bond.getIdentity() : LabelToken.formatLabel(this.viewer, bond, labelTokenArray, hashtable, nArray);
            }
            string = TextFormat.formatString(string, "#", n4 + 1);
            stringArray4[n4++] = string;
            if (bl3) break;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n5 == 1 && !bl2 ? stringArray4[0] : stringArray4;
    }

    private ScriptVariable getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)n).tok;
        String string = null;
        switch (n2) {
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 1716520973: {
                break;
            }
            default: {
                if (Token.tokAttrOr(n2, 0x40500000, 0x44100000)) break;
                if (!Token.tokAttr(n2, 0x40000000)) {
                    return null;
                }
                String string2 = this.parameterAsString(n);
                if (!bl && this.viewer.isFunction(string2)) {
                    n2 = 135368708;
                    break;
                }
                return null;
            }
        }
        if (bl && !Token.tokAttr(n2, 2048)) {
            return null;
        }
        if (string == null) {
            string = this.parameterAsString(n).toLowerCase();
        }
        return new ScriptVariable(0x101000C1, n2, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getBitsetProperty(BitSet bitSet, int n, Point3f point3f, Point4f point4f, Object object, Object object2, boolean bl, int n2, boolean bl2) throws ScriptException {
        int n3;
        int n4;
        Vector<Object> vector;
        block129: {
            int n5;
            int n6;
            boolean bl3;
            block128: {
                double d;
                double d2;
                float f;
                int n7;
                int n8;
                Point3f point3f2;
                boolean bl4;
                int n9;
                block127: {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    block124: {
                        ModelSet modelSet;
                        Point3f point3f3;
                        block126: {
                            int n10;
                            int n11;
                            float[] fArray;
                            ScriptVariable scriptVariable;
                            BitSet bitSet2;
                            Vector vector2;
                            String string;
                            boolean bl8;
                            block125: {
                                bl8 = n2 != Integer.MAX_VALUE;
                                boolean bl9 = bl8 || !(object instanceof Bond.BondSet);
                                n9 = n & 0x1E0;
                                bl7 = n9 == 224;
                                boolean bl10 = bl6 = n9 == 480 || bl7;
                                if ((n &= 0xFFFFFE1F) == 0) {
                                    n = bl9 ? 0x44100001 : 1678770178;
                                }
                                bl3 = false;
                                bl4 = false;
                                bl5 = false;
                                switch (n) {
                                    case 1146093580: 
                                    case 1146095626: 
                                    case 1146095627: 
                                    case 1146095629: 
                                    case 1632638983: {
                                        bl3 = true;
                                        break;
                                    }
                                    case 135368708: 
                                    case 1276118018: {
                                        break;
                                    }
                                    default: {
                                        bl4 = Token.tokAttr(n, 1095761920) && !Token.tokAttr(n, 1112539136);
                                        bl5 = !bl4 && Token.tokAttr(n, 0x40D00000);
                                    }
                                }
                                Point3f point3f4 = point3f2 = bl3 || !bl9 ? new Point3f() : null;
                                if (bl5 || bl6) {
                                    n9 = 0x100003;
                                }
                                vector = n9 == 0x100003 ? new Vector<Object>() : null;
                                BitSet bitSet3 = null;
                                string = null;
                                vector2 = null;
                                bitSet2 = null;
                                scriptVariable = null;
                                point3f3 = null;
                                fArray = null;
                                switch (n) {
                                    case 0x44100001: 
                                    case 1678770178: {
                                        int n12;
                                        if (this.isSyntaxCheck) {
                                            return bitSet;
                                        }
                                        bitSet3 = n == 0x44100001 ? (bl9 ? bitSet : this.viewer.getAtomBits(1678770178, bitSet)) : (bl9 ? new Bond.BondSet(this.viewer.getBondsForSelectedAtoms(bitSet)) : bitSet);
                                        switch (n9) {
                                            case 32: {
                                                n12 = bitSet3.nextSetBit(0);
                                                break;
                                            }
                                            case 64: {
                                                n12 = bitSet3.length() - 1;
                                                break;
                                            }
                                            case 128: 
                                            case 160: 
                                            case 192: {
                                                return new Float(Float.NaN);
                                            }
                                            default: {
                                                return bitSet3;
                                            }
                                        }
                                        bitSet3.clear();
                                        if (n12 < 0) return bitSet3;
                                        bitSet3.set(n12);
                                        return bitSet3;
                                    }
                                    case 1087373321: {
                                        switch (n9) {
                                            case 0: 
                                            case 0x100003: {
                                                return this.getBitsetIdent(bitSet, null, object, bl, n2, bl6);
                                            }
                                        }
                                        return "";
                                    }
                                    case 135368708: {
                                        string = (String)((Object[])object2)[0];
                                        vector2 = (Vector)((Object[])object2)[1];
                                        bitSet2 = new BitSet();
                                        scriptVariable = new ScriptVariable(9, bitSet2);
                                        break;
                                    }
                                    case 1112539151: 
                                    case 1112539152: {
                                        this.viewer.autoCalculate(n);
                                        break;
                                    }
                                    case 1276118018: {
                                        if (point3f != null || point4f != null) break;
                                        return new Point3f();
                                    }
                                    case 1632638983: {
                                        point3f3 = new Point3f();
                                        break;
                                    }
                                    case 1716520973: {
                                        fArray = this.viewer.getDataFloat((String)object2);
                                        break;
                                    }
                                }
                                n8 = 0;
                                n11 = 0;
                                n7 = 0;
                                f = 0.0f;
                                d2 = 0.0;
                                d = 0.0;
                                switch (n9) {
                                    case 32: {
                                        n7 = Integer.MAX_VALUE;
                                        f = Float.MAX_VALUE;
                                        break;
                                    }
                                    case 64: {
                                        n7 = Integer.MIN_VALUE;
                                        f = -3.4028235E38f;
                                        break;
                                    }
                                }
                                modelSet = this.viewer.getModelSet();
                                int n13 = bl3 ? 3 : (bl5 ? 2 : (n6 = bl4 ? 1 : 0));
                                if (bl9) break block125;
                                n4 = bitSet == null ? 1 : 0;
                                n10 = n4 != 0 ? 0 : bitSet.nextSetBit(0);
                                n3 = this.viewer.getBondCount();
                                n5 = n10;
                                break block126;
                            }
                            n4 = bitSet != null ? 1 : 0;
                            n10 = -1;
                            if (bl8) {
                                n3 = n2;
                                n5 = n2 + 1;
                            } else if (n4 != 0) {
                                n3 = bitSet.nextSetBit(0);
                                n5 = Math.min(this.viewer.getAtomCount(), bitSet.length());
                            } else {
                                n3 = 0;
                                n5 = this.viewer.getAtomCount();
                            }
                            if (this.isSyntaxCheck) {
                                n5 = 0;
                            }
                            int n14 = n3;
                            while (n14 >= 0 && n14 < n5) {
                                block123: {
                                    ++n8;
                                    Atom atom = modelSet.getAtomAt(n14);
                                    switch (n6) {
                                        case 0: {
                                            float f2 = Float.MAX_VALUE;
                                            switch (n) {
                                                case 135368708: {
                                                    bitSet2.set(n14);
                                                    f2 = ScriptVariable.fValue(this.getFunctionReturn(string, vector2, scriptVariable));
                                                    bitSet2.clear(n14);
                                                    break;
                                                }
                                                case 1716520973: {
                                                    f2 = fArray == null ? 0.0f : fArray[n14];
                                                    break;
                                                }
                                                case 1276118018: {
                                                    if (point4f != null) {
                                                        f2 = Measure.distanceToPlane(point4f, atom);
                                                        break;
                                                    }
                                                    f2 = atom.distance(point3f);
                                                    break;
                                                }
                                                default: {
                                                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                                                }
                                            }
                                            if (f2 == Float.MAX_VALUE || Float.isNaN(f2) && n9 != 0x100003) {
                                                --n8;
                                                break block123;
                                            } else {
                                                switch (n9) {
                                                    case 32: {
                                                        if (!(f2 < f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 64: {
                                                        if (!(f2 > f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 0x100003: {
                                                        vector.add(new Float(f2));
                                                        break;
                                                    }
                                                    case 160: 
                                                    case 192: {
                                                        d += (double)f2 * (double)f2;
                                                    }
                                                    default: {
                                                        d2 += (double)f2;
                                                        break;
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                        case 1: {
                                            Serializable serializable;
                                            int n15 = 0;
                                            switch (n) {
                                                case 1297090050: {
                                                    if (atom.getModelIndex() != n10) {
                                                        n10 = atom.getModelIndex();
                                                    }
                                                    serializable = atom.getAtomSymmetry();
                                                    int n16 = 0;
                                                    switch (n9) {
                                                        case 32: {
                                                            n11 = Integer.MAX_VALUE;
                                                            break;
                                                        }
                                                        case 64: {
                                                            n11 = Integer.MIN_VALUE;
                                                            break;
                                                        }
                                                    }
                                                    int n17 = ((BitSet)serializable).nextSetBit(0);
                                                    while (n17 >= 0) {
                                                        n15 += n17 + 1;
                                                        switch (n9) {
                                                            case 32: {
                                                                n11 = Math.min(n11, n17 + 1);
                                                                break;
                                                            }
                                                            case 64: {
                                                                n11 = Math.max(n11, n17 + 1);
                                                                break;
                                                            }
                                                        }
                                                        ++n16;
                                                        n17 = ((BitSet)serializable).nextSetBit(n17 + 1);
                                                    }
                                                    switch (n9) {
                                                        case 32: 
                                                        case 64: {
                                                            n15 = n11;
                                                            break;
                                                        }
                                                    }
                                                    n8 += n16 - 1;
                                                    break;
                                                }
                                                case 1095761925: 
                                                case 1095766022: {
                                                    this.error(45, Token.nameOf(n));
                                                }
                                                default: {
                                                    n15 = Atom.atomPropertyInt(atom, n);
                                                }
                                            }
                                            switch (n9) {
                                                case 32: {
                                                    if (n15 >= n7) break;
                                                    n7 = n15;
                                                    break;
                                                }
                                                case 64: {
                                                    if (n15 <= n7) break;
                                                    n7 = n15;
                                                    break;
                                                }
                                                case 0x100003: {
                                                    vector.add(new Integer(n15));
                                                    break;
                                                }
                                                case 160: 
                                                case 192: {
                                                    d += (double)n15 * (double)n15;
                                                }
                                                default: {
                                                    d2 += (double)n15;
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                        case 2: {
                                            vector.add(Atom.atomPropertyString(atom, n));
                                            break;
                                        }
                                        case 3: {
                                            Serializable serializable = Atom.atomPropertyTuple(atom, n);
                                            if (serializable == null) {
                                                this.error(45, Token.nameOf(n));
                                            }
                                            point3f2.add((Tuple3f)serializable);
                                            if (n9 != 0x100003) break;
                                            vector.add(new Point3f(point3f2));
                                            point3f2.set(0.0f, 0.0f, 0.0f);
                                        }
                                    }
                                    if (bl8) break block124;
                                }
                                n14 = n4 != 0 ? bitSet.nextSetBit(n14 + 1) : n14 + 1;
                            }
                            break block124;
                        }
                        while (n5 >= 0 && n5 < n3) {
                            ++n8;
                            Bond bond = modelSet.getBondAt(n5);
                            block63 : switch (n) {
                                case 1141899267: {
                                    float f3 = bond.getAtom1().distance(bond.getAtom2());
                                    switch (n9) {
                                        case 32: {
                                            if (!(f3 < f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 64: {
                                            if (!(f3 > f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 0x100003: {
                                            vector.add(new Float(f3));
                                            break;
                                        }
                                        case 160: 
                                        case 192: {
                                            d += (double)f3 * (double)f3;
                                        }
                                        default: {
                                            d2 += (double)f3;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 1146095626: {
                                    switch (n9) {
                                        case 0x100003: {
                                            point3f2.set(bond.getAtom1());
                                            point3f2.add(bond.getAtom2());
                                            point3f2.scale(0.5f);
                                            vector.add(new Point3f(point3f2));
                                            break block63;
                                        }
                                    }
                                    point3f2.add(bond.getAtom1());
                                    point3f2.add(bond.getAtom2());
                                    ++n8;
                                    break;
                                }
                                case 1632638983: {
                                    Graphics3D.colorPointFromInt(this.viewer.getColorArgbOrGray(bond.getColix()), point3f3);
                                    switch (n9) {
                                        case 0x100003: {
                                            vector.add(new Point3f(point3f3));
                                            break block63;
                                        }
                                    }
                                    point3f2.add(point3f3);
                                    break;
                                }
                                default: {
                                    this.error(46, Token.nameOf(n));
                                }
                            }
                            n5 = n4 != 0 ? n5 + 1 : bitSet.nextSetBit(n5 + 1);
                        }
                    }
                    if (n9 != 0x100003) break block127;
                    if (bl2) {
                        return vector;
                    }
                    n4 = vector.size();
                    if (bl5 && !bl6 && n4 == 1) {
                        return vector.get(0);
                    }
                    if (n == 1087373320) {
                        StringBuffer stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < n4) {
                            stringBuffer.append((String)vector.get(n3));
                            ++n3;
                        }
                        return stringBuffer.toString();
                    }
                    if (bl7) break block128;
                    break block129;
                }
                if (bl3) {
                    Point3f point3f5;
                    if (n8 == 0) {
                        point3f5 = point3f2;
                        return point3f5;
                    }
                    point3f5 = new Point3f(point3f2.x / (float)n8, point3f2.y / (float)n8, point3f2.z / (float)n8);
                    return point3f5;
                }
                if (n8 == 0) return new Float(Float.NaN);
                if (n8 == 1 && n9 == 192) {
                    return new Float(Float.NaN);
                }
                if (bl4) {
                    switch (n9) {
                        case 32: 
                        case 64: {
                            return new Integer(n7);
                        }
                    }
                }
                switch (n9) {
                    case 32: 
                    case 64: {
                        d2 = f;
                        return new Float(d2);
                    }
                    case 128: {
                        return new Float(d2);
                    }
                    case 160: {
                        d2 = d;
                        return new Float(d2);
                    }
                    case 192: {
                        d2 = Math.sqrt((d - d2 * d2 / (double)n8) / (double)(n8 - 1));
                        return new Float(d2);
                    }
                }
                d2 /= (double)n8;
                return new Float(d2);
            }
            Float[] floatArray = new Float[n4];
            Point3f point3f6 = n4 > 0 && bl3 ? new Point3f() : null;
            n5 = n4;
            block99: while (--n5 >= 0) {
                Object e = vector.get(n5);
                switch (n6) {
                    case 0: {
                        floatArray[n5] = (Float)e;
                        break;
                    }
                    case 1: {
                        floatArray[n5] = new Float(((Integer)e).floatValue());
                        break;
                    }
                    case 2: {
                        floatArray[n5] = new Float(Parser.parseFloat((String)e));
                        break;
                    }
                    case 3: {
                        floatArray[n5] = new Float(((Point3f)e).distance(point3f6));
                        continue block99;
                    }
                }
            }
            return floatArray;
        }
        String[] stringArray = new String[n4];
        n3 = n4;
        while (--n3 >= 0) {
            Object e = vector.get(n3);
            if (e instanceof Point3f) {
                stringArray[n3] = Escape.escape((Point3f)e);
                continue;
            }
            stringArray[n3] = "" + vector.get(n3);
        }
        return stringArray;
    }

    private void setBitsetProperty(BitSet bitSet, int n, int n2, float f, Token token) throws ScriptException {
        if (this.isSyntaxCheck || BitSetUtil.cardinalityOf(bitSet) == 0) {
            return;
        }
        String[] stringArray = null;
        String string = null;
        float[] fArray = null;
        switch (n) {
            case 1146095626: 
            case 1146095627: 
            case 1146095629: {
                if (token.tok == 7) {
                    this.viewer.setAtomCoord(bitSet, n, token.value);
                } else if (token.tok == 6) {
                    stringArray = (String[])token.value;
                    int n3 = stringArray.length;
                    if (n3 == 0) {
                        return;
                    }
                    Point3f[] point3fArray = new Point3f[n3];
                    int n4 = n3;
                    while (--n4 >= 0) {
                        Object object = Escape.unescapePoint(stringArray[n4]);
                        if (!(object instanceof Point3f)) {
                            this.error(50, "ARRAY", stringArray[n4]);
                        }
                        point3fArray[n4] = (Point3f)object;
                    }
                    this.viewer.setAtomCoord(bitSet, n, point3fArray);
                }
                return;
            }
            case 1632638983: {
                if (token.tok == 7) {
                    n2 = Graphics3D.colorPtToInt((Point3f)token.value);
                } else if (token.tok == 6) {
                    stringArray = (String[])token.value;
                    int n5 = stringArray.length;
                    if (n5 == 0) {
                        return;
                    }
                    int[] nArray = new int[n5];
                    int n6 = n5;
                    while (--n6 >= 0) {
                        Object object = Escape.unescapePoint(stringArray[n6]);
                        nArray[n6] = object instanceof Point3f ? Graphics3D.colorPtToInt((Point3f)object) : Graphics3D.getArgbFromString(stringArray[n6]);
                        if (nArray[n6] != 0 || (nArray[n6] = Parser.parseInt(stringArray[n6])) != Integer.MIN_VALUE) continue;
                        this.error(50, "ARRAY", stringArray[n6]);
                    }
                    this.viewer.setShapeProperty(0, "colorValues", nArray, bitSet);
                    return;
                }
                this.viewer.setShapeProperty(0, "color", token.tok == 4 ? token.value : new Integer(n2), bitSet);
                return;
            }
            case 1288701954: 
            case 1826248707: {
                if (token.tok == 6) {
                    stringArray = (String[])token.value;
                } else {
                    string = ScriptVariable.sValue(token);
                }
                this.viewer.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
                return;
            }
            case 1087375365: 
            case 1095763976: {
                this.clearDefinedVariableAtomSets();
            }
        }
        if (token.tok == 6 || token.tok == 4) {
            stringArray = token.tok == 6 ? (String[])token.value : Parser.getTokens(ScriptVariable.sValue(token));
            int n7 = stringArray.length;
            if (n7 == 0) {
                return;
            }
            fArray = new float[n7];
            int n8 = n7;
            while (--n8 >= 0) {
                fArray[n8] = n == 1087375365 ? (float)JmolConstants.elementNumberFromSymbol(stringArray[n8]) : Parser.parseFloat(stringArray[n8]);
            }
            if (token.tok == 4 && n7 == 1) {
                f = fArray[0];
                n2 = (int)f;
                string = stringArray[0];
                stringArray = null;
                fArray = null;
            }
        }
        this.viewer.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
    }

    public Hashtable getContextVariables() {
        return this.contextVariables;
    }

    public String getScript() {
        return this.script;
    }

    private boolean compileScript(String string, String string2, boolean bl) {
        this.filename = string;
        string2 = this.fixScriptPath(string2, string);
        this.getScriptContext(this.compiler.compile(string, string2, false, false, bl, false), false);
        this.isStateScript = this.script.indexOf("# Jmol state version ") >= 0;
        String string3 = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.isSyntaxCheck && this.viewer.isScriptEditorVisible() && string2.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.viewer.scriptStatus("");
        }
        this.script = string3;
        return !this.error;
    }

    private String fixScriptPath(String string, String string2) {
        if (string2 != null && string.indexOf("$SCRIPT_PATH$") >= 0) {
            String string3 = string2;
            int n = Math.max(string2.lastIndexOf("|"), string2.lastIndexOf("/"));
            string3 = string3.substring(0, n + 1);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$/", string3);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$", string3);
        }
        return string;
    }

    private int setScriptExtensions() {
        String string = this.scriptExtensions;
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("##SCRIPT_STEP");
        if (n >= 0) {
            this.executionStepping = true;
        }
        if ((n = string.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((n = Parser.parseInt(string.substring(n + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= n && this.lineIndices[this.pc][1] < n) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > n) {
            --this.pc;
        }
        return this.pc;
    }

    private void runScript(String string) throws ScriptException {
        if (!this.viewer.isPreviewOnly()) {
            this.runScript(string, this.outputBuffer);
        }
    }

    private boolean compileScriptFileInternal(String string, String string2, String string3, String string4) {
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(string, this.viewer.jsEval(string.substring(11)), this.debugScript);
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        if (!this.viewer.getFileAsString(stringArray, Integer.MAX_VALUE, false)) {
            this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
            return false;
        }
        this.filename = string;
        String string5 = this.fixScriptPath(stringArray[1], stringArray[0]);
        if (string4 == null) {
            string4 = this.viewer.getFullPath(string);
            string4 = string4.substring(0, string4.lastIndexOf("/"));
        }
        string5 = FileManager.setScriptFileReferences(string5, string2, string3, string4);
        return this.compileScript(string, string5, this.debugScript);
    }

    private Object getParameter(String string, boolean bl) {
        Object object = this.getContextVariableAsVariable(string);
        if (object == null) {
            object = this.viewer.getParameter(string);
        }
        if (bl) {
            return object instanceof ScriptVariable ? (ScriptVariable)object : ScriptVariable.getVariable(object);
        }
        return object instanceof ScriptVariable ? ScriptVariable.oValue((ScriptVariable)object) : object;
    }

    private String getParameterEscaped(String string) {
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        return scriptVariable == null ? "" + this.viewer.getParameterEscaped(string) : Escape.escape(scriptVariable.value);
    }

    private String getStringParameter(String string, boolean bl) {
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        if (scriptVariable != null) {
            return ScriptVariable.sValue(scriptVariable);
        }
        String string2 = "" + this.viewer.getParameter(string);
        return string2.length() == 0 && bl ? string : string2;
    }

    private Object getNumericParameter(String string) {
        if (string.equalsIgnoreCase("_modelNumber")) {
            int n = this.viewer.getCurrentModelIndex();
            return new Integer(n < 0 ? 0 : this.viewer.getModelFileNumber(n));
        }
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        if (scriptVariable == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            scriptVariable = new ScriptVariable(4, object);
        }
        return ScriptVariable.nValue(scriptVariable);
    }

    private ScriptVariable getContextVariableAsVariable(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        string = string.toLowerCase();
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return (ScriptVariable)this.contextVariables.get(string);
        }
        int n = this.scriptLevel;
        while (--n >= 0) {
            if (this.stack[n].contextVariables == null || !this.stack[n].contextVariables.containsKey(string)) continue;
            return (ScriptVariable)this.stack[n].contextVariables.get(string);
        }
        return null;
    }

    private Object getStringObjectAsVariable(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = ScriptVariable.unescapePointOrBitsetAsVariable(string);
        if (object instanceof String && string2 != null) {
            object = this.viewer.setUserVariable(string2, new ScriptVariable(4, (String)object));
        }
        return object;
    }

    private boolean loadFunction(String string, Vector vector) {
        ScriptFunction scriptFunction = this.viewer.getFunction(string);
        if (scriptFunction == null) {
            return false;
        }
        this.aatoken = scriptFunction.aatoken;
        this.lineNumbers = scriptFunction.lineNumbers;
        this.lineIndices = scriptFunction.lineIndices;
        this.script = scriptFunction.script;
        this.pc = 0;
        if (scriptFunction.names != null) {
            this.contextVariables = new Hashtable();
            scriptFunction.setVariables(this.contextVariables, vector);
        }
        this.functionName = string;
        return true;
    }

    protected ScriptVariable getFunctionReturn(String string, Vector vector, ScriptVariable scriptVariable) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> function " + string;
        this.loadFunction(string, vector);
        if (scriptVariable != null) {
            this.contextVariables.put("_x", scriptVariable);
        }
        this.instructionDispatchLoop(false);
        ScriptVariable scriptVariable2 = this.getContextVariableAsVariable("_retval");
        this.popContext();
        return scriptVariable2;
    }

    private void clearDefinedVariableAtomSets() {
        this.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String string;
        int n;
        if (!this.definedAtomSets.containsKey("# static")) {
            for (n = 0; n < JmolConstants.predefinedStatic.length; ++n) {
                this.defineAtomSet(JmolConstants.predefinedStatic[n]);
            }
            this.defineAtomSet("# static");
        }
        if (this.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (n = 0; n < JmolConstants.predefinedVariable.length; ++n) {
            this.defineAtomSet(JmolConstants.predefinedVariable[n]);
        }
        n = 4;
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            string = "@" + JmolConstants.elementNameFromNumber(n2) + " _e=" + n2;
            this.defineAtomSet(string);
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            string = "@_" + JmolConstants.elementSymbolFromNumber(n2) + " " + JmolConstants.elementNameFromNumber(n2);
            this.defineAtomSet(string);
        }
        n2 = n;
        while (--n2 >= 0) {
            string = "@" + JmolConstants.altElementNameFromIndex(n2) + " _e=" + JmolConstants.altElementNumberFromIndex(n2);
            this.defineAtomSet(string);
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= n) {
            string = " element=" + JmolConstants.altElementNumberFromIndex(n2);
            String string2 = "@_" + JmolConstants.altElementSymbolFromIndex(n2);
            this.defineAtomSet(string2 + string);
            string2 = "@_" + JmolConstants.altIsotopeSymbolFromIndex(n2);
            this.defineAtomSet(string2 + string);
            string2 = "@" + JmolConstants.altElementNameFromIndex(n2);
            if (string2.length() <= 1) continue;
            this.defineAtomSet(string2 + string);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String string) {
        if (string.indexOf("#") == 0) {
            this.definedAtomSets.put(string, Boolean.TRUE);
            return;
        }
        ScriptContext scriptContext = this.compiler.compile("#predefine", string, true, false, false, false);
        if (scriptContext.errorType != null) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + scriptContext.errorMessageUntranslated);
            return;
        }
        if (scriptContext.aatoken.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        Token[] tokenArray = scriptContext.aatoken[0];
        if (tokenArray.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        this.iToken = 1;
        int n = tokenArray[1].tok;
        if (!Token.tokAttr(n, 0x40000000) && !Token.tokAttr(n, 0x300000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        this.definedAtomSets.put(tokenArray[1].value, tokenArray);
    }

    private BitSet lookupIdentifierValue(String string) throws ScriptException {
        BitSet bitSet = this.lookupValue(string, false);
        if (bitSet != null) {
            return BitSetUtil.copy(bitSet);
        }
        bitSet = this.getAtomBits(0x40000000, string);
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet lookupValue(String string, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        this.defineSets();
        Object v = this.definedAtomSets.get(string);
        boolean bl2 = false;
        if (v == null) {
            v = this.definedAtomSets.get("!" + string);
            boolean bl3 = bl2 = v != null;
        }
        if (v instanceof BitSet) {
            return (BitSet)v;
        }
        if (v instanceof Token[]) {
            this.pushContext(null);
            BitSet bitSet = this.expression((Token[])v, -2, 0, true, false, true, true);
            this.popContext();
            if (!bl2) {
                this.definedAtomSets.put(string, bitSet);
            }
            return bitSet;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    public void deleteAtomsInVariables(BitSet bitSet) {
        Enumeration enumeration = this.definedAtomSets.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.definedAtomSets.get(string);
            if (!(v instanceof BitSet)) continue;
            BitSetUtil.deleteBits((BitSet)v, bitSet);
        }
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.statement = this.aatoken[n];
        this.statementLength = this.statement.length;
        if (this.statementLength == 0) {
            return true;
        }
        for (n2 = 1; n2 < this.statementLength && this.statement[n2].tok != 1060866; ++n2) {
        }
        if (n2 == this.statementLength) {
            return n2 == this.statementLength;
        }
        Token[] tokenArray = new Token[this.statementLength];
        tokenArray[0] = this.statement[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            int n4 = this.getToken((int)n2).tok;
            switch (n4) {
                case 1060866: {
                    boolean bl2;
                    Object object;
                    Object object2;
                    boolean bl3;
                    String string = this.parameterAsString(++n2);
                    boolean bl4 = bl3 = this.tokAt(n2) == 0x100001;
                    if (bl3) {
                        Vector vector;
                        if ((vector = (Vector)this.parameterExpression(++n2, 0, "_var", true)) == null || vector.size() == 0) {
                            this.error(22);
                        }
                        n2 = this.iToken;
                        object2 = (String[])vector.elementAt(0);
                        object = object2.tok == 6 ? object2 : ScriptVariable.oValue((ScriptVariable)object2);
                    } else {
                        object = this.getParameter(string, false);
                    }
                    n4 = this.tokAt(0);
                    boolean bl5 = bl2 = Token.tokAttr(n4, 20480) || n4 == 135271426 || n4 == 135271428;
                    if (object instanceof ScriptVariable) {
                        tokenArray[n3] = (Token)object;
                        if (bl && tokenArray[n3].tok == 6) {
                            tokenArray[n3] = new ScriptVariable(9, ScriptEvaluator.getAtomBitSet(this, ScriptVariable.sValue((ScriptVariable)tokenArray[n3])));
                        }
                    } else if (object instanceof Boolean) {
                        tokenArray[n3] = (Boolean)object != false ? Token.tokenOn : Token.tokenOff;
                    } else if (object instanceof Integer) {
                        tokenArray[n3] = new Token(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tokenArray[n3] = new Token(3, JmolConstants.modelValue("" + object), object);
                    } else if (object instanceof String) {
                        if ((object = this.getStringObjectAsVariable((String)object, null)) instanceof ScriptVariable) {
                            tokenArray[n3] = (Token)object;
                        } else {
                            String string2 = (String)object;
                            if (bl) {
                                tokenArray[n3] = new Token(9, ScriptEvaluator.getAtomBitSet(this, string2));
                            } else {
                                n4 = bl3 || bl2 || string2.indexOf(".") >= 0 || string2.indexOf(" ") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf(";") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 0x40000000;
                                tokenArray[n3] = new Token(n4, object);
                            }
                        }
                    } else if (object instanceof BitSet) {
                        tokenArray[n3] = new Token(9, object);
                    } else if (object instanceof Point3f) {
                        tokenArray[n3] = new Token(7, object);
                    } else if (object instanceof Point4f) {
                        tokenArray[n3] = new Token(8, object);
                    } else if (object instanceof Matrix3f) {
                        tokenArray[n3] = new Token(10, object);
                    } else if (object instanceof Matrix4f) {
                        tokenArray[n3] = new Token(11, object);
                    } else if (object instanceof String[]) {
                        object2 = (String[])object;
                        tokenArray[n3] = ((String[])object2).length > 0 && object2[1].startsWith("{") && !(Escape.unescapePoint(object2[1]) instanceof String) ? new Token(6, object2) : new Token(4, Escape.escape(object2, true));
                    } else {
                        object2 = this.getObjectCenter(string, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        if (object2 == null) {
                            this.error(22);
                        }
                        tokenArray[n3] = new Token(7, object2);
                    }
                    if (n3 != 1 || this.statement[0].tok != 1085443 || tokenArray[n3].tok == 0x40000000) break;
                    this.error(22);
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    bl = n4 == 0x100001;
                    tokenArray[n3] = this.statement[n2];
                    break;
                }
                default: {
                    tokenArray[n3] = this.statement[n2];
                }
            }
            ++n3;
        }
        this.statement = tokenArray;
        for (n2 = n3; n2 < this.statement.length; ++n2) {
            this.statement[n2] = null;
        }
        this.statementLength = n3;
        return true;
    }

    private void clearState(boolean bl) {
        int n = 10;
        while (--n >= 0) {
            this.stack[n] = null;
        }
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = bl;
    }

    private void pushContext(ScriptFunction scriptFunction) throws ScriptException {
        if (this.scriptLevel == 10) {
            this.error(44);
        }
        ScriptContext scriptContext = this.getScriptContext();
        this.stack[this.scriptLevel++] = scriptContext;
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>-------------".substring(0, this.scriptLevel + 5) + this.filename);
        }
    }

    public ScriptContext getScriptContext() {
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.contextPath = this.contextPath;
        scriptContext.filename = this.filename;
        scriptContext.functionName = this.functionName;
        scriptContext.script = this.script;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.aatoken = this.aatoken;
        scriptContext.statement = this.statement;
        scriptContext.statementLength = this.statementLength;
        scriptContext.pc = this.pc;
        scriptContext.lineEnd = this.lineEnd;
        scriptContext.pcEnd = this.pcEnd;
        scriptContext.iToken = this.iToken;
        scriptContext.outputBuffer = this.outputBuffer;
        scriptContext.contextVariables = this.contextVariables;
        scriptContext.isStateScript = this.isStateScript;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorType = this.errorType;
        scriptContext.iCommandError = this.iCommandError;
        scriptContext.stack = this.stack;
        scriptContext.scriptLevel = this.scriptLevel;
        scriptContext.isSyntaxCheck = this.isSyntaxCheck;
        scriptContext.executionStepping = this.executionStepping;
        scriptContext.executionPaused = this.executionPaused;
        scriptContext.scriptExtensions = this.scriptExtensions;
        return scriptContext;
    }

    private void getScriptContext(ScriptContext scriptContext, boolean bl) {
        this.script = scriptContext.script;
        this.lineNumbers = scriptContext.lineNumbers;
        this.lineIndices = scriptContext.lineIndices;
        this.aatoken = scriptContext.aatoken;
        this.contextVariables = scriptContext.contextVariables;
        this.scriptExtensions = scriptContext.scriptExtensions;
        if (!bl) {
            this.error = scriptContext.errorType != null;
            this.errorMessage = scriptContext.errorMessage;
            this.errorMessageUntranslated = scriptContext.errorMessageUntranslated;
            this.iCommandError = scriptContext.iCommandError;
            this.errorType = scriptContext.errorType;
            return;
        }
        this.contextPath = scriptContext.contextPath;
        this.filename = scriptContext.filename;
        this.functionName = scriptContext.functionName;
        this.statement = scriptContext.statement;
        this.statementLength = scriptContext.statementLength;
        this.pc = scriptContext.pc;
        this.lineEnd = scriptContext.lineEnd;
        this.pcEnd = scriptContext.pcEnd;
        this.iToken = scriptContext.iToken;
        this.outputBuffer = scriptContext.outputBuffer;
        this.isStateScript = scriptContext.isStateScript;
    }

    private void popContext() {
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, this.scriptLevel + 5) + this.filename);
        }
        if (this.scriptLevel == 0) {
            return;
        }
        ScriptContext scriptContext = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.getScriptContext(scriptContext, true);
    }

    private String getContext(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.scriptLevel; ++i) {
            if (bl) {
                if (this.stack[i].contextVariables == null) continue;
                stringBuffer.append(this.getScriptID(this.stack[i]));
                stringBuffer.append(StateManager.getVariableList(this.stack[i].contextVariables, 80));
                continue;
            }
            stringBuffer.append(ScriptEvaluator.setErrorLineMessage(this.stack[i].functionName, this.stack[i].filename, this.getLinenumber(this.stack[i]), this.stack[i].pc, this.statementAsString(this.stack[i].statement, -9999)));
        }
        if (bl) {
            if (this.contextVariables != null) {
                stringBuffer.append(this.getScriptID(null));
                stringBuffer.append(StateManager.getVariableList(this.contextVariables, 80));
            }
        } else {
            stringBuffer.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, this.statementAsString(this.statement, -9999)));
        }
        return stringBuffer.toString();
    }

    private int getLinenumber(ScriptContext scriptContext) {
        return scriptContext == null ? this.lineNumbers[this.pc] : scriptContext.lineNumbers[scriptContext.pc];
    }

    private String getScriptID(ScriptContext scriptContext) {
        String string = scriptContext == null ? this.functionName : "function " + scriptContext.functionName;
        String string2 = scriptContext == null ? this.filename : scriptContext.filename;
        return "\n# " + string + " (file " + string2 + ")\n";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    private void setErrorMessage(String string) {
        this.errorMessageUntranslated = null;
        if (string == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    private void planeExpected() throws ScriptException {
        this.error(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
    }

    private void integerOutOfRange(int n, int n2) throws ScriptException {
        this.error(21, "" + n, "" + n2);
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.error(36, "" + f, "" + f2);
    }

    void error(int n) throws ScriptException {
        this.error(n, null, null, null, false);
    }

    void error(int n, String string) throws ScriptException {
        this.error(n, string, null, null, false);
    }

    void error(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, null, false);
    }

    void error(int n, String string, String string2, String string3) throws ScriptException {
        this.error(n, string, string2, string3, false);
    }

    private void warning(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, null, true);
    }

    void error(int n, String string, String string2, String string3, boolean bl) throws ScriptException {
        String string4;
        String string5 = this.ignoreError ? null : ScriptEvaluator.errorString(n, string, string2, string3, true);
        String string6 = string4 = !this.ignoreError && GT.getDoTranslate() ? ScriptEvaluator.errorString(n, string, string2, string3, false) : null;
        if (!bl) {
            this.evalError(string5, string4);
        }
        this.showString(string5);
    }

    void evalError(String string, String string2) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(0);
            this.viewer.setBooleanProperty("refreshing", true);
        }
        throw new ScriptException(string, string2);
    }

    static String errorString(int n, String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string4 = "Unknown error message number: " + n;
                break;
            }
            case 0: {
                string4 = GT._("x y z axis expected");
                break;
            }
            case 1: {
                string4 = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                string4 = GT._("bad argument count");
                break;
            }
            case 3: {
                string4 = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                string4 = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                string4 = GT._("boolean expected");
                break;
            }
            case 6: {
                string4 = GT._("boolean or number expected");
                break;
            }
            case 7: {
                string4 = GT._("boolean, number, or {0} expected");
                break;
            }
            case 8: {
                string4 = GT._("color expected");
                break;
            }
            case 9: {
                string4 = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                string4 = GT._("command expected");
                break;
            }
            case 11: {
                string4 = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                string4 = GT._("draw object not defined");
                break;
            }
            case 13: {
                string4 = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                string4 = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                string4 = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                string4 = GT._("filename expected");
                break;
            }
            case 17: {
                string4 = GT._("file not found");
                break;
            }
            case 18: {
                string4 = GT._("incompatible arguments");
                break;
            }
            case 19: {
                string4 = GT._("insufficient arguments");
                break;
            }
            case 20: {
                string4 = GT._("integer expected");
                break;
            }
            case 21: {
                string4 = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                string4 = GT._("invalid argument");
                break;
            }
            case 23: {
                string4 = GT._("invalid parameter order");
                break;
            }
            case 24: {
                string4 = GT._("keyword expected");
                break;
            }
            case 25: {
                string4 = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                string4 = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                string4 = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                string4 = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                string4 = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                string4 = GT._("{0} require that only one model be displayed");
                break;
            }
            case 31: {
                string4 = GT._("No data available");
                break;
            }
            case 32: {
                string4 = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                string4 = GT._("No unit cell");
                break;
            }
            case 34: {
                string4 = GT._("number expected");
                break;
            }
            case 35: {
                string4 = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                string4 = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                string4 = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                string4 = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                string4 = GT._("property name expected");
                break;
            }
            case 40: {
                string4 = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                string4 = GT._("quoted string expected");
                break;
            }
            case 42: {
                string4 = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                string4 = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                string4 = GT._("too many script levels");
                break;
            }
            case 45: {
                string4 = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                string4 = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                string4 = GT._("unrecognized command");
                break;
            }
            case 48: {
                string4 = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                string4 = GT._("unrecognized object");
                break;
            }
            case 50: {
                string4 = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                string4 = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                string4 = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                string4 = "{0}";
                break;
            }
            case 54: {
                string4 = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (string4.indexOf("{0}") < 0) {
            if (string != null) {
                string4 = string4 + ": " + string;
            }
        } else {
            if ((string4 = TextFormat.simpleReplace(string4, "{0}", string)).indexOf("{1}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{1}", string2);
            } else if (string2 != null) {
                string4 = string4 + ": " + string2;
            }
            if (string4.indexOf("{2}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{2}", string2);
            }
        }
        if (bl2) {
            GT.setDoTranslate(true);
        }
        return string4;
    }

    String contextTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, this.statementAsString(this.statement, this.iToken)));
            if (this.scriptLevel <= 0) break;
            this.popContext();
        }
        return stringBuffer.toString();
    }

    static String setErrorLineMessage(String string, String string2, int n, int n2, String string3) {
        String string4 = "\n----";
        if (string2 != null || string != null) {
            string4 = string4 + "line " + n + " command " + (n2 + 1) + " of " + (string == null ? string2 : "function " + string) + ":";
        }
        string4 = string4 + "\n         " + string3;
        return string4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eval\n pc:");
        stringBuffer.append(this.pc);
        stringBuffer.append("\n");
        stringBuffer.append(this.aatoken.length);
        stringBuffer.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            stringBuffer.append("----\n");
            Token[] tokenArray = this.aatoken[i];
            for (int j = 0; j < tokenArray.length; ++j) {
                stringBuffer.append(tokenArray[j]);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }

    private String statementAsString(Token[] tokenArray, int n) {
        if (tokenArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = tokenArray[0].tok;
        switch (n2) {
            case 0: {
                String string = (String)tokenArray[0].value;
                return (string.startsWith("/") ? "/" : "#") + string;
            }
            case 0x119009: {
                if (tokenArray.length != 2 || tokenArray[1].tok != 135368708) break;
                return ((ScriptFunction)tokenArray[1].value).toString();
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = n2 == 1085443 && (String)tokenArray[0].value == "" && tokenArray[0].intValue == 61 && this.tokAt(1) != 0x100001;
        int n3 = tokenArray.length;
        block29: for (int i = 0; i < n3; ++i) {
            Token token = tokenArray[i];
            if (token == null) {
                n3 = i;
                break;
            }
            if (n == i - 1) {
                stringBuffer.append(" <<");
            }
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if (i == 2 && bl4) {
                bl4 = false;
                if (token.tok != 269484420) {
                    stringBuffer.append("= ");
                }
            }
            if (n == i && token.tok != 0x100002) {
                stringBuffer.append(">> ");
            }
            switch (token.tok) {
                case 0x100001: {
                    if (!bl) continue block29;
                    stringBuffer.append("{");
                    continue block29;
                }
                case 0x100002: {
                    if (bl3 && i == this.statementLength - 1) {
                        bl = false;
                    }
                    if (!bl) continue block29;
                    stringBuffer.append("}");
                    continue block29;
                }
                case 0x10100040: 
                case 0x10100041: {
                    break;
                }
                case 0x10000A: 
                case 0x10000E: {
                    bl2 = token.tok == 0x10000A;
                    break;
                }
                case 1060866: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    stringBuffer.append("@");
                    if (this.tokAt(i + 1) != 0x100001) continue block29;
                    if (!bl) {
                        bl3 = true;
                    }
                    bl = true;
                    continue block29;
                }
                case 0x10000D: {
                    stringBuffer.append("true");
                    continue block29;
                }
                case 0x10000C: {
                    stringBuffer.append("false");
                    continue block29;
                }
                case 135280129: {
                    break;
                }
                case 2: {
                    stringBuffer.append(token.intValue);
                    continue block29;
                }
                case 7: 
                case 8: 
                case 9: {
                    stringBuffer.append(ScriptVariable.sValue(token));
                    continue block29;
                }
                case 5: {
                    stringBuffer.append('^');
                    continue block29;
                }
                case 1048615: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                    } else {
                        stringBuffer.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    }
                    token = tokenArray[++i];
                    stringBuffer.append(' ');
                    stringBuffer.append(bl2 ? "-" : "- ");
                }
                case 1048614: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                        continue block29;
                    }
                    stringBuffer.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    continue block29;
                }
                case 0x100021: {
                    stringBuffer.append("*:");
                    stringBuffer.append((char)token.intValue);
                    continue block29;
                }
                case 0x10001F: {
                    stringBuffer.append("*%");
                    if (token.value == null) continue block29;
                    stringBuffer.append(token.value.toString());
                    continue block29;
                }
                case 0x100022: {
                    stringBuffer.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        stringBuffer.append(Escape.escapeModelFileNumber(token.intValue));
                        continue block29;
                    }
                    stringBuffer.append("" + token.value);
                    continue block29;
                }
                case 1048613: {
                    stringBuffer.append('[');
                    stringBuffer.append(Group.getGroup3((short)token.intValue));
                    stringBuffer.append(']');
                    continue block29;
                }
                case 1048612: {
                    stringBuffer.append('[');
                    stringBuffer.append(token.value);
                    stringBuffer.append(']');
                    continue block29;
                }
                case 0x100020: {
                    stringBuffer.append("*.");
                    break;
                }
                case 1095761925: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f point3f = (Point3f)token.value;
                    stringBuffer.append("cell={").append(point3f.x).append(" ").append(point3f.y).append(" ").append(point3f.z).append("}");
                    continue block29;
                }
                case 4: {
                    stringBuffer.append("\"").append(token.value).append("\"");
                    continue block29;
                }
                case 0x10100180: 
                case 0x10100181: 
                case 269484418: 
                case 269484419: 
                case 269484420: 
                case 269484421: {
                    if (token.intValue == 1716520973) {
                        stringBuffer.append((String)tokenArray[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    stringBuffer.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                default: {
                    if (Token.tokAttr(token.tok, 0x40000000) || !this.logMessages) break;
                    stringBuffer.append('\n').append(token.toString()).append('\n');
                    continue block29;
                }
            }
            if (token.value == null) continue;
            stringBuffer.append(token.value.toString());
        }
        if (n >= n3 - 1) {
            stringBuffer.append(" <<");
        }
        return stringBuffer.toString();
    }

    private void setShapeProperty(int n, String string, Object object) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(n, string, object);
        }
    }

    private void setShapeSize(int n, int n2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeSize(n, n2, null);
        }
    }

    private void setShapeSize(int n, RadiusData radiusData) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeSize(n, radiusData, null);
        }
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private boolean setIntProperty(String string, int n) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(string, n);
        }
        return true;
    }

    private boolean setFloatProperty(String string, float f) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(string, f);
        }
        return true;
    }

    private void setStringProperty(String string, String string2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    private void showString(String string) {
        this.showString(string, false);
    }

    private void showString(String string, boolean bl) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
        } else {
            this.viewer.showString(string, bl);
        }
    }

    private void scriptStatusOrBuffer(String string) {
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    private BitSet expression(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(2);
        }
        return this.expression(this.statement, n, 0, true, false, true, true);
    }

    private BitSet expression(Token[] tokenArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ScriptException {
        this.isBondSet = false;
        if (tokenArray != this.statement) {
            this.tempStatement = this.statement;
            this.statement = tokenArray;
        }
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, false, false);
        int n3 = Integer.MAX_VALUE;
        boolean bl5 = false;
        this.iToken = 1000;
        boolean bl6 = n < 0;
        boolean bl7 = false;
        int n4 = 0;
        int n5 = this.viewer.getAtomCount();
        if (bl6) {
            n = -n;
        }
        bl6 |= this.isSyntaxCheck;
        if (n2 == 0 && tokenArray.length > n) {
            n2 = n + 1;
        }
        block34: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            Token token = tokenArray[i];
            if (token == null) break;
            Object object = token.value;
            switch (token.tok) {
                case 0x100001: {
                    n = i;
                    n2 = tokenArray.length;
                    ++n4;
                    continue block34;
                }
                case 0x100002: {
                    if (--n4 <= 0) break block34;
                    continue block34;
                }
                case 0x10000A: {
                    Serializable serializable;
                    if (!this.isPoint3f(i) || (serializable = this.getPoint3f(i, true)) == null) continue block34;
                    scriptMathProcessor.addX((Point3f)serializable);
                    i = this.iToken;
                    continue block34;
                }
                case 0x10000E: {
                    continue block34;
                }
                case 0x10100040: {
                    bl7 = true;
                    scriptMathProcessor.addOp(token);
                    continue block34;
                }
                case 0x10100041: {
                    bl7 = false;
                    scriptMathProcessor.addOp(token);
                    continue block34;
                }
                case 1060866: {
                    scriptMathProcessor.addX(ScriptEvaluator.getAtomBitSet(this, (String)object));
                    continue block34;
                }
                case 135267842: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(new ScriptVariable(8, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block34;
                }
                case 135266313: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(new ScriptVariable(8, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block34;
                }
                case 0x100006: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block34;
                }
                case 4: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    if (!((String)object).equals("hkl")) continue block34;
                    scriptMathProcessor.addX(new ScriptVariable(8, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block34;
                }
                case 135266317: 
                case 135266318: 
                case 135266817: 
                case 0x10100030: {
                    scriptMathProcessor.addOp(token);
                    continue block34;
                }
                case 0x100003: {
                    scriptMathProcessor.addX(this.viewer.getModelAtomBitSet(-1, true));
                    continue block34;
                }
                case 0x10000B: {
                    scriptMathProcessor.addX(new BitSet());
                    continue block34;
                }
                case 0x10000C: 
                case 0x10000D: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    continue block34;
                }
                case 1114638350: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getSelectionSet()));
                    continue block34;
                }
                case 0x303007: {
                    Serializable serializable = this.viewer.getSelectionSubset();
                    scriptMathProcessor.addX(serializable == null ? this.viewer.getModelAtomBitSet(-1, true) : BitSetUtil.copy(serializable));
                    continue block34;
                }
                case 3145752: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getHiddenSet()));
                    continue block34;
                }
                case 3145751: {
                    scriptMathProcessor.addX(BitSetUtil.copyInvert(this.viewer.getHiddenSet(), n5));
                    continue block34;
                }
                case 3145755: {
                    if (!this.isSyntaxCheck && !bl5) {
                        this.viewer.setModelVisibility();
                    }
                    bl5 = true;
                    scriptMathProcessor.addX(this.viewer.getVisibleSet());
                    continue block34;
                }
                case 3145750: {
                    if (!this.isSyntaxCheck && bl) {
                        this.refresh();
                    }
                    scriptMathProcessor.addX(this.viewer.getClickableSet());
                    continue block34;
                }
                case 0x100009: 
                case 0x10001F: 
                case 0x100020: 
                case 1048612: 
                case 0x300002: 
                case 0x300005: 
                case 0x300006: 
                case 0x300007: 
                case 0x300008: 
                case 0x300009: 
                case 3145749: 
                case 3145753: 
                case 1089470477: 
                case 0x60300003: 
                case 1614417984: {
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, (String)object));
                    continue block34;
                }
                case 0x100022: 
                case 1048611: {
                    int n6 = token.intValue;
                    if (n6 == Integer.MAX_VALUE && object instanceof Integer) {
                        n6 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            scriptMathProcessor.addX(this.getAtomBits(0x100022, new Integer(n6)));
                            continue block34;
                        }
                        n6 = n6 < 1000 ? (n6 *= 1000000) : n6 / 1000 * 1000000 + n6 % 1000;
                    }
                    scriptMathProcessor.addX(this.bitSetForModelFileNumber(n6));
                    continue block34;
                }
                case 0x100021: 
                case 1048613: {
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, new Integer(token.intValue)));
                    continue block34;
                }
                case 1048614: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(token.intValue));
                        continue block34;
                    }
                    scriptMathProcessor.addX(this.getAtomBits(1048614, new Integer(ScriptEvaluator.getSeqCode(token))));
                    continue block34;
                }
                case 1048615: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(token.intValue));
                        scriptMathProcessor.addX(Token.tokenMinus);
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(tokenArray[++i].intValue));
                        continue block34;
                    }
                    int n7 = i + 3 < tokenArray.length && tokenArray[i + 2].tok == 0x10100060 && tokenArray[i + 3].tok == 0x100021 ? tokenArray[i + 3].intValue : 9;
                    scriptMathProcessor.addX(this.getAtomBits(1048615, new int[]{ScriptEvaluator.getSeqCode(token), ScriptEvaluator.getSeqCode(tokenArray[++i]), n7}));
                    if (n7 == 9) continue block34;
                    i += 2;
                    continue block34;
                }
                case 1095761925: {
                    Point3f point3f = (Point3f)object;
                    scriptMathProcessor.addX(this.getAtomBits(1095761925, new int[]{(int)(point3f.x * 1000.0f), (int)(point3f.y * 1000.0f), (int)(point3f.z * 1000.0f)}));
                    continue block34;
                }
                case 0x30000E: {
                    scriptMathProcessor.addX(this.viewer.getModelAtomBitSet(this.viewer.getCurrentModelIndex(), true));
                    continue block34;
                }
                case 0x300001: 
                case 0x30000C: 
                case 0x30000D: 
                case 137363471: 
                case 1115297793: 
                case 1613758468: 
                case 1613758475: {
                    scriptMathProcessor.addX(this.lookupIdentifierValue((String)object));
                    continue block34;
                }
                case 0x10100180: 
                case 0x10100181: 
                case 269484418: 
                case 269484419: 
                case 269484420: 
                case 269484421: {
                    float[] fArray;
                    boolean bl8;
                    String string;
                    Object object2 = tokenArray[++i].value;
                    int n8 = token.tok;
                    int n9 = token.intValue;
                    String string2 = string = n9 == 1716520973 ? (String)object2 : null;
                    if (string != null) {
                        object2 = tokenArray[++i].value;
                    }
                    if (n9 == 1095766022 && n8 != 269484420) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        scriptMathProcessor.addX(new BitSet());
                        continue block34;
                    }
                    boolean bl9 = n9 == 1095766028;
                    boolean bl10 = Token.tokAttr(n9, 1095761920);
                    boolean bl11 = Token.tokAttr(n9, 1112539136);
                    boolean bl12 = bl10 && bl11;
                    boolean bl13 = bl8 = !bl10 && Token.tokAttr(n9, 0x40D00000);
                    if (n9 == 1087375365) {
                        bl8 = false;
                        bl10 = !false;
                    }
                    int n10 = tokenArray[i].tok;
                    n3 = tokenArray[i].intValue;
                    float f = Float.NaN;
                    if (object2 instanceof Point3f) {
                        if (n9 == 1632638983) {
                            n3 = Graphics3D.colorPtToInt((Point3f)object2);
                            n10 = 2;
                            bl10 = true;
                        }
                    } else if (object2 instanceof String) {
                        if (n9 == 1632638983) {
                            n3 = Graphics3D.getArgbFromString((String)object2);
                            if (n3 == 0 && Token.tokAttr(n10, 0x40000000)) {
                                n3 = ((String)(object2 = this.getStringParameter((String)object2, true))).startsWith("{") ? ((object2 = Escape.unescapePoint((String)object2)) instanceof Point3f ? Graphics3D.colorPtToInt((Point3f)object2) : 0) : Graphics3D.getArgbFromString((String)object2);
                            }
                            n10 = 2;
                            bl10 = true;
                        } else if (bl8) {
                            if (Token.tokAttr(n10, 0x40000000)) {
                                object2 = this.getStringParameter((String)object2, true);
                            }
                        } else {
                            if (Token.tokAttr(n10, 0x40000000)) {
                                object2 = this.getNumericParameter((String)object2);
                            }
                            if (object2 instanceof String) {
                                if (n9 == 1104154627 || n9 == 1087375365) {
                                    bl10 = n3 != Integer.MAX_VALUE;
                                    bl8 = !bl10;
                                } else {
                                    object2 = ScriptVariable.nValue(tokenArray[i]);
                                }
                            }
                            if (object2 instanceof Integer) {
                                n3 = (Integer)object2;
                                f = n3;
                            } else if (object2 instanceof Float && bl9) {
                                n3 = ModelCollection.modelFileNumberFromFloat(((Float)object2).floatValue());
                            }
                        }
                    }
                    if (bl8 && !(object2 instanceof String)) {
                        object2 = "" + object2;
                    }
                    if (object2 instanceof Integer || n10 == 2) {
                        if (bl9) {
                            if (n3 >= 1000000) {
                                n9 = -1095766028;
                            }
                        } else if (bl12) {
                            bl11 = false;
                        } else if (bl11) {
                            f = n3;
                        }
                    } else if (object2 instanceof Float) {
                        if (bl9) {
                            n9 = -1095766028;
                        } else {
                            f = ((Float)object2).floatValue();
                            if (bl12) {
                                bl10 = false;
                            } else if (bl10) {
                                n3 = (int)f;
                            }
                        }
                    } else if (!bl8) {
                        ++this.iToken;
                        this.error(22);
                    }
                    if (bl9 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n9 = 1229984263;
                        bl9 = false;
                    }
                    if (n9 == -1095766028 && n8 == 269484420) {
                        scriptMathProcessor.addX(this.bitSetForModelFileNumber(n3));
                        continue block34;
                    }
                    if (object != null && ((String)object).indexOf("-") >= 0) {
                        if (bl10) {
                            n3 = -n3;
                        } else if (!Float.isNaN(f)) {
                            f = -f;
                        }
                    }
                    float[] fArray2 = fArray = n9 == 1716520973 ? this.viewer.getDataFloat(string) : null;
                    scriptMathProcessor.addX(bl10 ? this.compareInt(n9, fArray, n8, n3) : (bl8 ? this.compareString(n9, n8, (String)object2) : this.compareFloat(n9, fArray, n8, f)));
                    continue block34;
                }
                case 7: 
                case 8: 
                case 9: {
                    scriptMathProcessor.addX(object);
                    continue block34;
                }
                case 2: 
                case 3: {
                    scriptMathProcessor.addXNum(new ScriptVariable(token));
                    continue block34;
                }
                default: {
                    Object object2;
                    if (Token.tokAttr(token.tok, 0x10100000)) {
                        scriptMathProcessor.addOp(token);
                        continue block34;
                    }
                    if (token.tok == 0x40000000) {
                        object2 = this.getParameter((String)object, false);
                        if (object2 instanceof String) {
                            object2 = this.getStringObjectAsVariable((String)object2, null);
                        }
                        if (object2 instanceof String || object2 instanceof String[]) {
                            object2 = this.lookupIdentifierValue((String)object);
                        }
                        scriptMathProcessor.addX(object2);
                        continue block34;
                    }
                    this.error(48);
                }
            }
        }
        this.expressionResult = scriptMathProcessor.getResult(bl2, null);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                scriptMathProcessor.dumpStacks("after getResult");
            }
            this.error(13);
        }
        this.expressionResult = ((ScriptVariable)this.expressionResult).value;
        if (this.expressionResult instanceof String && (bl3 || ((String)this.expressionResult).startsWith("({"))) {
            Object object = this.expressionResult = this.isSyntaxCheck ? new BitSet() : ScriptEvaluator.getAtomBitSet(this, (String)this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : new BitSet();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        if (!this.isBondSet) {
            this.viewer.excludeAtoms(bitSet, bl6);
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bitSet;
    }

    private BitSet compareFloat(int n, float[] fArray, int n2, float f) {
        BitSet bitSet = new BitSet();
        int n3 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        float f2 = 0.0f;
        this.viewer.autoCalculate(n);
        block3: for (int i = 0; i < n3; ++i) {
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                    break;
                }
                case 1716520973: {
                    if (fArray == null || fArray.length <= i) continue block3;
                    f2 = fArray[i];
                }
            }
            bl = ScriptEvaluator.compareFloat(n2, f2, f);
            if (!bl) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private BitSet compareString(int n, int n2, String string) throws ScriptException {
        boolean bl;
        BitSet bitSet = new BitSet();
        Atom[] atomArray = this.viewer.getModelSet().atoms;
        int n3 = this.viewer.getAtomCount();
        boolean bl2 = bl = n == 0x40D00004 && this.viewer.getChainCaseSensitive();
        if (!bl) {
            string = string.toLowerCase();
        }
        for (int i = 0; i < n3; ++i) {
            String string2 = Atom.atomPropertyString(atomArray[i], n);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (!this.compareString(n2, string2, string)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    protected BitSet compareInt(int n, float[] fArray, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        BitSet bitSet = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        switch (n) {
            case 1297090050: {
                switch (n5) {
                    case 0x10100180: 
                    case 0x10100181: {
                        n8 = Integer.MAX_VALUE;
                    }
                }
                break;
            }
            case 1095761923: {
                switch (n2) {
                    case 269484419: {
                        return BitSetUtil.newBitSet(0, n3);
                    }
                    case 269484418: {
                        return BitSetUtil.newBitSet(0, n3 + 1);
                    }
                    case 0x10100181: {
                        return BitSetUtil.newBitSet(n3, n7);
                    }
                    case 0x10100180: {
                        return BitSetUtil.newBitSet(n3 + 1, n7);
                    }
                    case 269484420: {
                        return n3 < n7 ? BitSetUtil.newBitSet(n3, n3 + 1) : new BitSet();
                    }
                }
                BitSet bitSet2 = BitSetUtil.setAll(n7);
                if (n3 >= 0) {
                    bitSet2.clear(n3);
                }
                return bitSet2;
            }
        }
        BitSet bitSet3 = new BitSet();
        block26: for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = Atom.atomPropertyInt(atom, n);
                    break;
                }
                case 1095766022: {
                    return BitSetUtil.copy(this.viewer.getConformation(-1, n3 - 1, false));
                }
                case 1297090050: {
                    int n12;
                    bitSet = atom.getAtomSymmetry();
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if (n6 >= 200) {
                        if (nArray == null) continue block26;
                        n3 = n6 % 1000;
                        n12 = n6 / 1000 - 1;
                        if (n12 < 0) {
                            bl = true;
                        } else if (n11 == 0 || n12 >= 0 && !(bl = bitSet.get(n12))) continue block26;
                        n5 = 0x10000B;
                        n4 = n12 < 0 ? atom.getCellTranslation(n3, nArray, n11) : atom.getSymmetryTranslation(n12, nArray, n11);
                    } else if (n11 > 0) {
                        if (n3 > n11 && n5 != 269484419 && n5 != 269484418) continue block26;
                        if (n5 == 269484421) {
                            if (n3 <= 0 || n3 > n11 || bitSet.get(n3)) continue block26;
                            bitSet3.set(i);
                            continue block26;
                        }
                    }
                    switch (n5) {
                        case 269484419: {
                            n8 = n3 - 1;
                            break;
                        }
                        case 269484418: {
                            n8 = n3;
                            break;
                        }
                        case 0x10100181: {
                            n9 = n3 - 1;
                            break;
                        }
                        case 0x10100180: {
                            n9 = n3;
                            break;
                        }
                        case 269484420: {
                            n8 = n3;
                            n9 = n3 - 1;
                            break;
                        }
                        case 269484421: {
                            boolean bl2 = bl = !bitSet.get(n3);
                        }
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n9 < n8 && (n12 = bitSet.nextSetBit(n9)) >= 0 && n12 < n8) {
                        bl = true;
                    }
                    if (bl && n4 != Integer.MAX_VALUE) break;
                    n2 = 0x10000B;
                }
            }
            if (n2 != 0x10000B) {
                bl = ScriptEvaluator.compareInt(n2, n4, n3);
            }
            if (!bl) continue;
            bitSet3.set(i);
        }
        return bitSet3;
    }

    private boolean compareString(int n, String string, String string2) throws ScriptException {
        switch (n) {
            case 269484420: 
            case 269484421: {
                return TextFormat.isMatch(string, string2, true, true) == (n == 269484420);
            }
        }
        this.error(22);
        return false;
    }

    private static boolean compareInt(int n, int n2, int n3) {
        switch (n) {
            case 269484419: {
                return n2 < n3;
            }
            case 269484418: {
                return n2 <= n3;
            }
            case 0x10100181: {
                return n2 >= n3;
            }
            case 0x10100180: {
                return n2 > n3;
            }
            case 269484420: {
                return n2 == n3;
            }
            case 269484421: {
                return n2 != n3;
            }
        }
        return false;
    }

    private static boolean compareFloat(int n, float f, float f2) {
        switch (n) {
            case 269484419: {
                return f < f2;
            }
            case 269484418: {
                return f <= f2;
            }
            case 0x10100181: {
                return f >= f2;
            }
            case 0x10100180: {
                return f > f2;
            }
            case 269484420: {
                return f == f2;
            }
            case 269484421: {
                return f != f2;
            }
        }
        return false;
    }

    private BitSet getAtomBits(int n, Object object) {
        return this.isSyntaxCheck ? new BitSet() : this.viewer.getAtomBits(n, object);
    }

    private static int getSeqCode(Token token) {
        return token.intValue != Integer.MAX_VALUE ? Group.getSeqcode(token.intValue, ' ') : (Integer)token.value;
    }

    private int checkLast(int n) throws ScriptException {
        return this.checkLength(n + 1) - 1;
    }

    private int checkLength(int n) throws ScriptException {
        if (n >= 0) {
            return this.checkLength(n, 0);
        }
        if (this.statementLength > -n) {
            this.iToken = -n;
            this.error(2);
        }
        return this.statementLength;
    }

    private int checkLength(int n, int n2) throws ScriptException {
        if (this.statementLength != n) {
            this.iToken = n2 > 0 ? n2 : this.statementLength;
            this.error(n2 > 0 ? 22 : 2);
        }
        return this.statementLength;
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != 2 && this.statementLength != 3) {
            this.error(2);
        }
        return this.statementLength;
    }

    private int checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != 3 && this.statementLength != 4) {
            this.error(2);
        }
        return this.statementLength;
    }

    private Token getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(13);
        }
        this.theToken = this.statement[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int n) {
        return n < this.statementLength ? this.statement[n].tok : 0;
    }

    private int tokAt(int n, Token[] tokenArray) {
        return n < tokenArray.length ? tokenArray[n].tok : 0;
    }

    private Token tokenAt(int n, Token[] tokenArray) {
        return n < tokenArray.length ? tokenArray[n] : null;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.statementLength;
    }

    private int modelNumberParameter(int n) throws ScriptException {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.getToken((int)n).intValue;
                break;
            }
            default: {
                this.error(22);
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl, true);
    }

    private String optParameterAsString(int n) throws ScriptException {
        if (n >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(n);
    }

    private String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.error(13);
        }
        return this.theTok == 2 ? "" + this.theToken.intValue : "" + this.theToken.value;
    }

    private int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    private int intParameter(int n, int n2, int n3) throws ScriptException {
        int n4 = this.intParameter(n);
        if (n4 < n2 || n4 > n3) {
            this.integerOutOfRange(n2, n3);
        }
        return n4;
    }

    private boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameter(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatParameter(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 1048615: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    private float[] floatParameterSet(int n, int n2, int n3) throws ScriptException {
        Object object;
        int n4 = this.tokAt(n);
        boolean bl = n4 == 0x10000A;
        boolean bl2 = n4 == 0x10100040;
        float[] fArray = null;
        Vector<Float> vector = new Vector<Float>();
        int n5 = 0;
        if (bl || bl2) {
            ++n;
        }
        if (this.tokAt(n) == 4) {
            object = this.stringParameter(n);
            object = TextFormat.replaceAllCharacters((String)object, "{},[]\"'", ' ');
            fArray = Parser.parseFloatArray((String)object);
            n5 = fArray.length;
        } else {
            while (n5 < n3) {
                n4 = this.tokAt(n);
                if (bl && n4 == 0x10000E || bl2 && n4 == 0x10100041) break;
                switch (n4) {
                    case 0x10000A: 
                    case 0x10000E: 
                    case 0x10100030: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 7: {
                        Point3f point3f = this.getPoint3f(n, false);
                        vector.add(new Float(point3f.x));
                        vector.add(new Float(point3f.y));
                        vector.add(new Float(point3f.z));
                        n5 += 3;
                        break;
                    }
                    case 8: {
                        object = this.getPoint4f(n);
                        vector.add(new Float(((Point4f)object).x));
                        vector.add(new Float(((Point4f)object).y));
                        vector.add(new Float(((Point4f)object).z));
                        vector.add(new Float(((Point4f)object).w));
                        n5 += 4;
                        break;
                    }
                    default: {
                        vector.add(new Float(this.floatParameter(n)));
                        ++n5;
                    }
                }
                ++n;
            }
        }
        if (bl && this.tokAt(n++) != 0x10000E || bl2 && this.tokAt(n++) != 0x10100041) {
            this.error(22);
        }
        this.iToken = n - 1;
        if (n5 < n2 || n5 > n3) {
            this.error(22);
        }
        if (fArray == null) {
            fArray = new float[n5];
            for (int i = 0; i < n5; ++i) {
                fArray[i] = ((Float)vector.get(i)).floatValue();
            }
        }
        return fArray;
    }

    private String stringParameter(int n) throws ScriptException {
        if (!this.checkToken(n) || this.getToken((int)n).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    private String[] stringParameterSet(int n) throws ScriptException {
        int n2;
        switch (this.tokAt(n)) {
            case 4: {
                Object object;
                String string = this.stringParameter(n);
                if (string.startsWith("[\"") && (object = this.viewer.evaluateExpression(string)) instanceof String) {
                    return TextFormat.split((String)object, '\n');
                }
                return new String[]{string};
            }
            case 0x10100040: {
                ++n;
                break;
            }
            default: {
                this.error(22);
            }
        }
        Vector<String> vector = new Vector<String>();
        while ((n2 = this.tokAt(n)) != 0x10100041) {
            switch (n2) {
                case 0x10100030: {
                    break;
                }
                case 4: {
                    vector.add(this.stringParameter(n));
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            ++n;
        }
        this.iToken = n;
        int n3 = vector.size();
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    private String objectNameParameter(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(37);
        }
        return this.parameterAsString(n);
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.statementLength == n) {
            return true;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
        }
        this.error(5);
        return false;
    }

    private Point3f atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 9: 
            case 0x100001: {
                BitSet bitSet = this.expression(this.statement, n, 0, true, false, false, true);
                if (bitSet != null) {
                    return this.viewer.getAtomSetCenter(bitSet);
                }
                if (this.expressionResult instanceof Point3f) {
                    return (Point3f)this.expressionResult;
                }
                this.error(22);
                break;
            }
            case 7: 
            case 0x10000A: {
                return this.getPoint3f(n, true);
            }
        }
        this.error(22);
        return null;
    }

    private boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x100007 || n2 == 0x10000A || n2 == 0x100001 || n2 == 7 || n2 == 9;
    }

    private Point3f centerParameter(int n) throws ScriptException {
        return this.centerParameter(n, Integer.MIN_VALUE);
    }

    private Point3f centerParameter(int n, int n2) throws ScriptException {
        Point3f point3f = null;
        this.expressionResult = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    int n3 = Integer.MIN_VALUE;
                    if (this.tokAt(n + 1) == 0x10100040) {
                        n3 = this.intParameter(n + 2);
                        if (this.getToken((int)(n + 3)).tok != 0x10100041) {
                            this.error(22);
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    point3f = this.getObjectCenter(string, n3, n2);
                    if (point3f != null) break;
                    this.error(12, string);
                    break;
                }
                case 7: 
                case 9: 
                case 0x100001: 
                case 0x10000A: {
                    point3f = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (point3f == null) {
            this.error(11);
        }
        return point3f;
    }

    private Point4f planeParameter(int n) throws ScriptException {
        boolean bl;
        Tuple4f tuple4f;
        block28: {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            tuple4f = null;
            boolean bl2 = bl = this.tokAt(n) == 0x10100090;
            if (bl) {
                ++n;
            }
            if (n >= this.statementLength) break block28;
            switch (this.getToken((int)n).tok) {
                case 8: {
                    tuple4f = (Point4f)this.theToken.value;
                    break;
                }
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int n2 = this.viewer.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 22: {
                            this.setShapeProperty(22, "thisID", string);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(22, "vertices");
                            if (point3fArray != null && point3fArray.length >= 3 && point3fArray[0] != null && point3fArray[1] != null) {
                                if (point3fArray[2] == null) break;
                                tuple4f = Measure.getPlaneThroughPoints(point3fArray[0], point3fArray[1], point3fArray[2], new Vector3f(), vector3f, vector3f2);
                                break;
                            }
                            break block28;
                        }
                        case 23: {
                            this.setShapeProperty(23, "thisID", string);
                            tuple4f = (Point4f)this.viewer.getShapeProperty(23, "plane");
                        }
                    }
                    break;
                }
                case 1112541210: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484420) {
                        this.evalError("x=?", null);
                    }
                    tuple4f = new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541211: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484420) {
                        this.evalError("y=?", null);
                    }
                    tuple4f = new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541212: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484420) {
                        this.evalError("z=?", null);
                    }
                    tuple4f = new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                    break;
                }
                case 4: 
                case 0x40000000: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    break;
                }
                case 0x10000A: {
                    if (!this.isPoint3f(n)) {
                        tuple4f = this.getPoint4f(n);
                        break;
                    }
                }
                case 9: 
                case 0x100001: {
                    Point3f point3f = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f point3f2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f point3f3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    Vector3f vector3f3 = new Vector3f();
                    float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f3, vector3f, vector3f2);
                    tuple4f = new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                    if (this.isSyntaxCheck || !Logger.debugging) break;
                    Logger.debug("points: " + point3f + point3f2 + point3f3 + " defined plane: " + tuple4f);
                }
            }
        }
        if (tuple4f == null) {
            this.planeExpected();
        }
        if (bl) {
            tuple4f.scale(-1.0f);
        }
        return tuple4f;
    }

    private Point4f hklParameter(int n) throws ScriptException {
        Point3f point3f;
        Point4f point4f;
        if (!this.isSyntaxCheck && this.viewer.getCurrentUnitCell() == null) {
            this.error(33);
        }
        if ((point4f = this.getHklPlane(point3f = (Point3f)this.getPointOrPlane(n, false, true, false, true, 3, 3))) == null) {
            this.error(3);
        }
        if (!this.isSyntaxCheck && Logger.debugging) {
            Logger.info("defined plane: " + point4f);
        }
        return point4f;
    }

    protected Point4f getHklPlane(Point3f point3f) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f2 = new Point3f(point3f.x == 0.0f ? 1.0f : 1.0f / point3f.x, 0.0f, 0.0f);
        Point3f point3f3 = new Point3f(0.0f, point3f.y == 0.0f ? 1.0f : 1.0f / point3f.y, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, 0.0f, point3f.z == 0.0f ? 1.0f : 1.0f / point3f.z);
        if (point3f.x == 0.0f && point3f.y == 0.0f && point3f.z == 0.0f) {
            return null;
        }
        if (point3f.x == 0.0f && point3f.y == 0.0f) {
            point3f2.set(1.0f, 0.0f, point3f4.z);
            point3f3.set(0.0f, 1.0f, point3f4.z);
        } else if (point3f.y == 0.0f && point3f.z == 0.0f) {
            point3f3.set(point3f2.x, 0.0f, 1.0f);
            point3f4.set(point3f2.x, 1.0f, 0.0f);
        } else if (point3f.z == 0.0f && point3f.x == 0.0f) {
            point3f4.set(0.0f, point3f3.y, 1.0f);
            point3f2.set(1.0f, point3f3.y, 0.0f);
        } else if (point3f.x == 0.0f) {
            point3f2.set(1.0f, point3f3.y, 0.0f);
        } else if (point3f.y == 0.0f) {
            point3f3.set(0.0f, 1.0f, point3f4.z);
        } else if (point3f.z == 0.0f) {
            point3f4.set(point3f2.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(point3f2);
        this.viewer.toCartesian(point3f3);
        this.viewer.toCartesian(point3f4);
        Vector3f vector3f3 = new Vector3f();
        float f = Measure.getNormalThroughPoints(point3f2, point3f3, point3f4, vector3f3, vector3f, vector3f2);
        return new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
    }

    private int getMadParameter() throws ScriptException {
        int n = 1;
        switch (this.getToken((int)1).tok) {
            case 1073741958: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                n = 0;
                break;
            }
            case 2: {
                int n2 = this.intParameter(1, 0, 750);
                n = n2 * 4 * 2;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1, 0.0f, 3.0f) * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.error(6);
            }
        }
        return n;
    }

    private int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.statementLength) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 1073741880: {
                return -1;
            }
            case 2: {
                return this.intParameter(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameter(n, 0.0f, 2.0f);
                return (int)(f * 1000.0f * 2.0f);
            }
        }
        this.error(7, "\"DOTTED\"");
        return 0;
    }

    private boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x10100040 || n2 == 7 || this.isPoint3f(n) || (n2 == 4 || Token.tokAttr(n2, 0x40000000)) && Graphics3D.getArgbFromString((String)this.statement[n].value) != 0;
    }

    private int getArgbParam(int n) throws ScriptException {
        return this.getArgbParam(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParam(n, bl);
        this.checkLast(this.iToken);
        return n2;
    }

    private int getArgbParam(int n, boolean bl) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                default: {
                    if (this.theTok != 4 && !Token.tokAttr(this.theTok, 0x40000000)) break;
                    return Graphics3D.getArgbFromString(this.parameterAsString(n));
                }
                case 0x10100040: {
                    return this.getColorTriad(++n);
                }
                case 7: {
                    point3f = (Point3f)this.theToken.value;
                    break;
                }
                case 0x10000A: {
                    point3f = this.getPoint3f(n, false);
                    break;
                }
                case 0x10000B: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (point3f == null) {
            this.error(8);
        }
        return Graphics3D.colorPtToInt(point3f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int n) throws ScriptException {
        Point3f point3f;
        String string;
        int n2;
        block22: {
            float[] fArray = new float[3];
            n2 = 0;
            string = "";
            this.getToken(n);
            point3f = null;
            float f = 0.0f;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1048614: {
                    break;
                }
                case 7: {
                    point3f = (Point3f)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    string = this.parameterAsString(n);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (n < this.statementLength) {
                block23: {
                    switch (this.getToken((int)n).tok) {
                        case 0x10100030: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n2 != 1 || fArray[0] != 0.0f) {
                                this.error(4);
                            }
                            string = "0" + this.parameterAsString(n);
                            break block22;
                        }
                        case 3: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.floatParameter(n);
                            break;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10100041: {
                            if (n2 != 3) {
                                this.error(4);
                            }
                            --n;
                            point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    fArray[n2++] = f;
                }
                ++n;
            }
            this.error(4);
        }
        if (this.getToken((int)(++n)).tok != 0x10100041) {
            this.error(4);
        }
        if (point3f != null) {
            return Graphics3D.colorPtToInt(point3f);
        }
        n2 = Graphics3D.getArgbFromString("[" + string + "]");
        if (n2 == 0) {
            this.error(4);
        }
        return n2;
    }

    private boolean isPoint3f(int n) {
        boolean bl = this.tokAt(n) == 7;
        if (bl || this.tokAt(n) == 8 || this.isFloatParameter(n + 1) && this.isFloatParameter(n + 2) && this.isFloatParameter(n + 3) && this.isFloatParameter(n + 4)) {
            return bl;
        }
        this.ignoreError = true;
        int n2 = this.iToken;
        bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    private Point3f getPoint3f(int n, boolean bl) throws ScriptException {
        return (Point3f)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    private Point4f getPoint4f(int n) throws ScriptException {
        return (Point4f)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 7) {
            if (n2 <= 3 && n3 >= 3) {
                return (Point3f)this.getToken((int)n).value;
            }
            this.error(22);
        }
        if (this.tokAt(n) == 8) {
            if (n2 <= 4 && n3 >= 4) {
                return (Point4f)this.getToken((int)n).value;
            }
            this.error(22);
        }
        int n5 = 1;
        block10: for (int i = n; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000A: 
                case 0x10100030: 
                case 0x10100060: {
                    continue block10;
                }
                case 0x10000E: {
                    break block10;
                }
                case 0x10100090: {
                    n5 = -1;
                    continue block10;
                }
                case 1048615: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block10;
                }
                case 2: 
                case 1048614: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block10;
                }
                case 0x101000A0: {
                    this.getToken(++i);
                }
                case 0x100022: {
                    if (--n4 < 0 || bl) {
                        this.error(22);
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block10;
                }
                case 3: 
                case 1048611: {
                    if (bl) {
                        this.error(22);
                    }
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block10;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.error(22);
        }
        if (n4 == 3) {
            Point3f point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3 && !this.isSyntaxCheck) {
                this.viewer.toCartesian(point3f);
            }
            return point3f;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.error(22);
            }
            Point4f point4f = new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
            return point4f;
        }
        return fArray;
    }

    private Point3f xypParameter(int n) throws ScriptException {
        boolean bl;
        if (this.tokAt(n) != 0x10100040 || !this.isFloatParameter(++n)) {
            return null;
        }
        Point3f point3f = new Point3f();
        point3f.x = this.floatParameter(n);
        if (this.tokAt(++n) == 0x10100030) {
            ++n;
        }
        if (!this.isFloatParameter(n)) {
            return null;
        }
        point3f.y = this.floatParameter(n);
        boolean bl2 = bl = this.tokAt(++n) == 269484194;
        if (bl) {
            ++n;
        }
        if (this.tokAt(n) != 0x10100041) {
            return null;
        }
        this.iToken = n;
        point3f.z = (float)(bl ? -1 : 1) * Float.MAX_VALUE;
        return point3f;
    }

    private int intSetting(int n, int n2, int n3, int n4) throws ScriptException {
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.intSetting(n);
        }
        if (n2 != Integer.MIN_VALUE && n2 < n3 || n2 > n4) {
            this.integerOutOfRange(n3, n4);
        }
        return n2;
    }

    private int intSetting(int n) throws ScriptException {
        if (n == this.statementLength) {
            return Integer.MIN_VALUE;
        }
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.iValue((ScriptVariable)vector.elementAt(0));
    }

    private float floatSetting(int n, float f, float f2) throws ScriptException {
        if (n == this.statementLength) {
            return Float.NaN;
        }
        float f3 = this.floatSetting(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.fValue((ScriptVariable)vector.elementAt(0));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.statementLength == n + 1) {
            return this.parameterAsString(n);
        }
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.sValue((ScriptVariable)vector.elementAt(0));
    }

    private ScriptVariable tokenSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(22);
        }
        return (ScriptVariable)vector.elementAt(0);
    }

    private boolean isCommandDisplayable(int n) {
        if (n >= this.aatoken.length || n >= this.pcEnd || this.aatoken[n] == null) {
            return false;
        }
        return this.lineIndices[n][1] > this.lineIndices[n][0];
    }

    private boolean checkContinue() {
        if (this.interruptExecution) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.viewer.scriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        Logger.info("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        try {
            while (this.executionPaused) {
                this.viewer.popHoldRepaint("pause");
                Thread.sleep(100L);
                this.refresh();
                String string = this.viewer.getInterruptScript();
                if (string != "") {
                    this.resumePausedExecution();
                    this.setErrorMessage(null);
                    --this.pc;
                    try {
                        this.runScript(string);
                    }
                    catch (Exception exception) {
                        this.setErrorMessage("" + exception);
                    }
                    catch (Error error) {
                        this.setErrorMessage("" + error);
                    }
                    if (this.error) {
                        this.popContext();
                        this.scriptStatusOrBuffer(this.errorMessage);
                        this.setErrorMessage(null);
                    }
                    ++this.pc;
                    this.pauseExecution();
                }
                this.viewer.pushHoldRepaint("pause");
            }
            if (!(this.isSyntaxCheck || this.interruptExecution || this.executionStepping)) {
                this.viewer.scriptStatus("script execution " + (this.error || this.interruptExecution ? "interrupted" : "resumed"));
            }
        }
        catch (Exception exception) {
            this.viewer.pushHoldRepaint("pause");
        }
        Logger.debug("script execution resumed");
        return !this.error && !this.interruptExecution;
    }

    private void instructionDispatchLoop(boolean bl) throws ScriptException {
        long l = 0L;
        boolean bl2 = false;
        this.logMessages = false;
        this.debugScript = false;
        if (!this.isSyntaxCheck) {
            this.setDebugging();
        }
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + l);
            this.viewer.scriptStatus(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        String string = "";
        if (this.aatoken == null) {
            return;
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && (this.isSyntaxCheck || this.checkContinue()) && this.lineNumbers[this.pc] <= this.lineEnd) {
            block105: {
                Token token;
                block107: {
                    block106: {
                        String string2;
                        block104: {
                            Token token2 = token = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                            if (!(this.historyDisabled || this.isSyntaxCheck || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
                                string2 = this.getCommand(this.pc, true, true);
                                if (!(token == null || string2.length() <= 0 || string2.equals(string) || token.tok != 135368708 && Token.tokAttr(token.tok, 102400))) {
                                    string = string2;
                                    this.viewer.addCommand(string);
                                }
                            }
                            if (this.setStatement(this.pc)) break block104;
                            Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                            break block105;
                        }
                        this.thisCommand = this.getCommand(this.pc, false, true);
                        this.fullCommand = this.thisCommand + this.getNextComment();
                        this.iToken = 0;
                        string2 = this.viewer.getInterruptScript();
                        if (string2 != "") {
                            this.runScript(string2);
                        }
                        if (bl || !this.isSyntaxCheck) {
                            int n = this.viewer.getScriptDelay();
                            if (bl || n > 0 && this.scriptLevel > 0) {
                                if (n > 0) {
                                    this.delay(-((long)n));
                                }
                                this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                            }
                        }
                        if (!this.isSyntaxCheck) break block106;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.statementLength != 1 || this.statement[0].tok == 135368708) break block107;
                        break block105;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.scriptLevel == 0 && this.viewer.logCommands()) {
                        this.viewer.log(this.thisCommand);
                    }
                    if (this.logMessages && token != null) {
                        Logger.debug(token.toString());
                    }
                }
                if (token != null) {
                    if (Token.tokAttr(token.tok, 135168)) {
                        this.processShapeCommand(token.tok);
                    } else {
                        switch (token.tok) {
                            case 0: {
                                break;
                            }
                            case 20503: 
                            case 102402: 
                            case 102406: 
                            case 102407: 
                            case 102408: 
                            case 364547: 
                            case 364548: 
                            case 528415: 
                            case 0x119009: 
                            case 135369224: 
                            case 135369225: {
                                bl2 = this.flowControl(token.tok, bl2);
                                break;
                            }
                            case 4098: {
                                this.animation();
                                break;
                            }
                            case 1610616835: {
                                this.background(1);
                                break;
                            }
                            case 4100: {
                                this.bind();
                                break;
                            }
                            case 4101: {
                                this.bondorder();
                                break;
                            }
                            case 4102: {
                                this.calculate();
                                break;
                            }
                            case 1069063: {
                                this.cd();
                                break;
                            }
                            case 12289: {
                                this.center(1);
                                break;
                            }
                            case 4104: {
                                this.centerAt();
                                break;
                            }
                            case 1632638983: {
                                this.color();
                                break;
                            }
                            case 4105: {
                                this.compare();
                                break;
                            }
                            case 1095766022: {
                                this.configuration();
                                break;
                            }
                            case 4106: {
                                this.connect(1);
                                break;
                            }
                            case 528395: {
                                this.console();
                                break;
                            }
                            case 0x8101008: {
                                this.data();
                                break;
                            }
                            case 1060866: {
                                this.define();
                                break;
                            }
                            case 528396: {
                                this.delay();
                                break;
                            }
                            case 12291: {
                                this.delete();
                                break;
                            }
                            case 528397: {
                                this.slab(true);
                                break;
                            }
                            case 1610625028: {
                                this.display(true);
                                break;
                            }
                            case 266257: 
                            case 266281: {
                                if (this.isSyntaxCheck) break;
                                if (this.pc > 0 && token.tok == 266257) {
                                    this.viewer.clearScriptQueue();
                                }
                                this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue();
                                break;
                            }
                            case 266258: {
                                if (this.isSyntaxCheck || this.viewer.isApplet()) {
                                    return;
                                }
                                this.viewer.exitJmol();
                                break;
                            }
                            case 1229984263: {
                                this.file();
                                break;
                            }
                            case 4115: {
                                this.font(-1, 0.0f);
                                break;
                            }
                            case 4116: 
                            case 1095766028: {
                                this.frame(1);
                                break;
                            }
                            case 135368708: {
                                this.function();
                                break;
                            }
                            case 135270405: {
                                this.getProperty();
                                break;
                            }
                            case 20482: {
                                this.help();
                                break;
                            }
                            case 12293: {
                                this.display(false);
                                break;
                            }
                            case 1612189721: {
                                this.hbond(true);
                                break;
                            }
                            case 1610616858: {
                                this.history(1);
                                break;
                            }
                            case 544771: {
                                this.hover();
                                break;
                            }
                            case 266267: {
                                this.viewer.initialize();
                                break;
                            }
                            case 4124: {
                                this.invertSelected();
                                break;
                            }
                            case 135287298: {
                                this.script(135287298);
                                break;
                            }
                            case 135271426: {
                                this.load();
                                break;
                            }
                            case 36869: {
                                this.log();
                                break;
                            }
                            case 20485: {
                                this.message();
                                break;
                            }
                            case 4128: {
                                this.minimize();
                                break;
                            }
                            case 4131: {
                                this.move();
                                break;
                            }
                            case 4132: {
                                this.moveto();
                                break;
                            }
                            case 4133: {
                                this.navigate();
                                break;
                            }
                            case 20486: {
                                this.pause();
                                break;
                            }
                            case 36865: {
                                this.print();
                                break;
                            }
                            case 135270411: {
                                this.dataFrame(1);
                                break;
                            }
                            case 1052714: {
                                this.dataFrame(0);
                                break;
                            }
                            case 266283: {
                                this.refresh();
                                break;
                            }
                            case 4140: {
                                this.reset();
                                break;
                            }
                            case 4141: {
                                this.restore();
                                break;
                            }
                            case 12294: {
                                this.restrict();
                                break;
                            }
                            case 266286: {
                                if (this.isSyntaxCheck) break;
                                this.resumePausedExecution();
                                break;
                            }
                            case 36866: {
                                this.returnCmd();
                                break;
                            }
                            case 528432: {
                                this.rotate(false, false);
                                break;
                            }
                            case 4145: {
                                this.rotate(false, true);
                                break;
                            }
                            case 4146: {
                                this.save();
                                break;
                            }
                            case 1085443: {
                                this.set();
                                break;
                            }
                            case 135271428: {
                                this.script(135271428);
                                break;
                            }
                            case 135280129: {
                                this.select(1);
                                break;
                            }
                            case 1611141171: {
                                this.selectionHalo(1);
                                break;
                            }
                            case 4148: {
                                this.show();
                                break;
                            }
                            case 528437: {
                                this.slab(false);
                                break;
                            }
                            case 1611141175: {
                                this.rotate(true, false);
                                break;
                            }
                            case 1611141176: {
                                this.ssbond();
                                break;
                            }
                            case 1577017: {
                                this.struts();
                                break;
                            }
                            case 266298: {
                                if (!this.pause()) break;
                                this.stepPausedExecution();
                                break;
                            }
                            case 528443: {
                                this.stereo();
                                break;
                            }
                            case 1104154627: {
                                this.structure();
                                break;
                            }
                            case 0x303007: {
                                this.subset();
                                break;
                            }
                            case 4156: {
                                this.sync();
                                break;
                            }
                            case 536875070: {
                                this.timeout(1);
                                break;
                            }
                            case 4160: {
                                this.translate(false);
                                break;
                            }
                            case 4162: {
                                this.translate(true);
                                break;
                            }
                            case 4164: {
                                this.unbind();
                                break;
                            }
                            case 4166: {
                                this.vibration();
                                break;
                            }
                            case 135270406: {
                                this.write(null);
                                break;
                            }
                            case 1060872: {
                                this.zap(true);
                                break;
                            }
                            case 4168: {
                                this.zoom(false);
                                break;
                            }
                            case 4170: {
                                this.zoom(true);
                                break;
                            }
                            default: {
                                this.error(47);
                            }
                        }
                    }
                    if (!this.isSyntaxCheck && !this.tQuiet) {
                        this.viewer.setCursor(0);
                    }
                    if (this.executionStepping) {
                        this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                    }
                }
            }
            ++this.pc;
        }
    }

    private void processShapeCommand(int n) throws ScriptException {
        int n2;
        switch (n) {
            case 1611272194: {
                n2 = 29;
                break;
            }
            case 1115297793: {
                n2 = 9;
                break;
            }
            case 1679429641: {
                n2 = 30;
                break;
            }
            case 1113200642: {
                n2 = 11;
                break;
            }
            case 135182: {
                n2 = 17;
                break;
            }
            case 1113198595: {
                n2 = 16;
                break;
            }
            case 135184: {
                n2 = 22;
                break;
            }
            case 537022465: {
                n2 = 28;
                break;
            }
            case 1113198596: {
                n2 = 20;
                break;
            }
            case 1611272213: {
                n2 = 33;
                break;
            }
            case 1113198597: {
                n2 = 19;
                break;
            }
            case 1113200646: {
                n2 = 8;
                break;
            }
            case 135197: {
                n2 = 23;
                break;
            }
            case 1826248707: {
                n2 = 5;
                break;
            }
            case 135198: {
                n2 = 24;
                break;
            }
            case 537006111: 
            case 1746538503: {
                n2 = 6;
                break;
            }
            case 1113200647: {
                n2 = 13;
                break;
            }
            case 0x121021: {
                n2 = 25;
                break;
            }
            case 135207: {
                n2 = 27;
                break;
            }
            case 135206: {
                n2 = 26;
                break;
            }
            case 135208: {
                n2 = 21;
                break;
            }
            case 1113200649: {
                n2 = 14;
                break;
            }
            case 1113200650: {
                n2 = 15;
                break;
            }
            case 1113200651: {
                n2 = 0;
                break;
            }
            case 1113200652: {
                n2 = 7;
                break;
            }
            case 1650071565: {
                n2 = 12;
                break;
            }
            case 1113200654: {
                n2 = 10;
                break;
            }
            case 1614417984: {
                n2 = 31;
                break;
            }
            case 135233: {
                n2 = 18;
                break;
            }
            case 659523: {
                n2 = 1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n2 < 0) {
            this.error(47);
        }
        switch (n) {
            case 1611272194: {
                this.axes(1);
                break;
            }
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                this.proteinShape(n2);
                break;
            }
            case 1679429641: {
                this.boundbox(1);
                break;
            }
            case 135182: {
                this.dipole();
                break;
            }
            case 1113198595: 
            case 1113198597: {
                this.dots(n2);
                break;
            }
            case 135184: {
                this.draw();
                break;
            }
            case 537022465: {
                this.echo(1, false);
                break;
            }
            case 1113198596: {
                this.ellipsoid();
                break;
            }
            case 1611272213: {
                this.frank(1);
                break;
            }
            case 1113200646: 
            case 1113200651: 
            case 1113200652: {
                this.setAtomShapeSize(n2, n == 1113200646 ? 0.2f : 1.0f);
                break;
            }
            case 135197: 
            case 135206: 
            case 135207: {
                this.isosurface(n2);
                break;
            }
            case 1826248707: {
                this.label(1);
                break;
            }
            case 135198: {
                this.lcaoCartoon();
                break;
            }
            case 537006111: 
            case 1746538503: {
                this.measure();
                break;
            }
            case 0x121021: {
                this.mo(false);
                break;
            }
            case 135208: {
                this.polyhedra();
                break;
            }
            case 1614417984: {
                this.unitcell(1);
                break;
            }
            case 135233: {
                this.vector();
                break;
            }
            case 659523: {
                this.wireframe();
            }
        }
    }

    private boolean flowControl(int n, boolean bl) throws ScriptException {
        switch (n) {
            case 20503: {
                String string = this.parameterAsString(this.checkLast(1));
                int n2 = -1;
                for (int i = 0; i < this.aatoken.length; ++i) {
                    Token[] tokenArray = this.aatoken[i];
                    if (tokenArray[0].tok != 20485 && tokenArray[0].tok != 0 || !tokenArray[tokenArray.length - 1].value.toString().equalsIgnoreCase(string)) continue;
                    n2 = i;
                    break;
                }
                if (n2 < 0) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.pc = n2 - 1;
                }
                return bl;
            }
            case 528415: {
                this.delay();
                if (!this.isSyntaxCheck) {
                    this.pc = -1;
                }
                return bl;
            }
        }
        int n3 = this.statement[0].intValue;
        boolean bl2 = n3 < 0 && !this.isSyntaxCheck;
        boolean bl3 = true;
        int n4 = 0;
        switch (n) {
            case 102402: 
            case 135369225: {
                boolean bl4 = bl3 = !bl2 && this.ifCmd();
                if (this.isSyntaxCheck) break;
                n4 = Math.abs(this.aatoken[Math.abs((int)n3)][0].intValue);
                this.aatoken[Math.abs((int)n3)][0].intValue = n4 = bl2 || bl3 ? -n4 : n4;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (n3 >= 0 || this.isSyntaxCheck) break;
                this.pc = -n3 - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 0x119009: {
                if (this.getToken((int)this.checkLast((int)1)).tok == 135368708) {
                    this.viewer.addFunction((ScriptFunction)this.theToken.value);
                    return bl;
                }
                bl = this.theTok == 135369224;
                bl3 = this.theTok == 135369225;
                break;
            }
            case 102406: {
                bl = false;
                if (this.ifCmd() || this.isSyntaxCheck) break;
                this.pc = n3;
                break;
            }
            case 102407: {
                if (!this.isSyntaxCheck) {
                    this.pc = this.aatoken[n3][0].intValue;
                }
                if (this.statementLength <= 1) break;
                this.intParameter(this.checkLast(1));
                break;
            }
            case 102408: {
                bl = true;
                if (!this.isSyntaxCheck) {
                    this.pc = n3 - 1;
                }
                if (this.statementLength <= 1) break;
                this.intParameter(this.checkLast(1));
                break;
            }
            case 135369224: {
                int[] nArray = new int[2];
                int n5 = 0;
                BitSet bitSet = null;
                int n6 = 0;
                block20: for (int i = 1; i < this.statementLength && n5 < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x10000F: {
                            if (n6 > 0) {
                                --n6;
                                continue block20;
                            }
                            nArray[n5++] = i;
                            continue block20;
                        }
                        case 1073742040: {
                            n6 -= 2;
                            bitSet = this.expression(++i);
                            i = this.iToken;
                            continue block20;
                        }
                        case 135280129: {
                            n6 += 2;
                        }
                    }
                }
                if (bl) {
                    n5 = nArray[1] + 1;
                    bl = false;
                } else {
                    n5 = 2;
                    if (this.tokAt(n5) == 36868) {
                        ++n5;
                    }
                }
                String string = this.parameterAsString(n5);
                int n7 = n6 = string.equals("--") || string.equals("++") ? 1 : 0;
                if (n6 != 0) {
                    string = this.parameterAsString(++n5);
                }
                if (Token.tokAttr(this.tokAt(n5), 0x40000000) || this.getContextVariableAsVariable(string) != null) {
                    if (bitSet == null && n6 == 0 && this.getToken((int)(++n5)).tok != 269484420) {
                        this.error(22);
                    }
                    if (bitSet == null) {
                        if (n6 != 0) {
                            n5 -= 2;
                        }
                        this.setVariable(++n5, this.statementLength - 1, string, 0);
                    } else {
                        this.setVariable(n5 + 2, this.statementLength - 1, string + "_set", 0);
                        this.setVariable(n5 + 2, this.statementLength - 1, string, 0);
                    }
                }
                bl3 = (Boolean)this.parameterExpression(nArray[0] + 1, nArray[1], null, false);
                ++n3;
            }
        }
        if (!bl3 && !this.isSyntaxCheck) {
            this.pc = Math.abs(n3) - 1;
        }
        return bl;
    }

    private boolean ifCmd() throws ScriptException {
        return (Boolean)this.parameterExpression(1, 0, null, false);
    }

    private void returnCmd() throws ScriptException {
        Vector vector;
        ScriptVariable scriptVariable = this.getContextVariableAsVariable("_retval");
        if (scriptVariable == null) {
            if (!this.isSyntaxCheck) {
                this.interruptExecution = true;
            }
            return;
        }
        Vector vector2 = vector = this.statementLength == 1 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        ScriptVariable scriptVariable2 = vector == null || vector.size() == 0 ? ScriptVariable.intVariable(0) : (ScriptVariable)vector.get(0);
        scriptVariable.value = scriptVariable2.value;
        scriptVariable.intValue = scriptVariable2.intValue;
        scriptVariable.tok = scriptVariable2.tok;
        this.pcEnd = this.pc;
    }

    private void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(1);
        int n = 0;
        if (string.toLowerCase().startsWith("mouse") && (n = string.indexOf(" ")) >= 0 && n == string.lastIndexOf(" ")) {
            this.showString(this.viewer.getBindingInfo(string.substring(n + 1)));
            return;
        }
        Token token = Token.getTokenFromName(string);
        if (token != null && (token.tok & 0x1000) != 0) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        if (this.statementLength > 11) {
            this.error(2);
        }
        Vector3f vector3f = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        Vector3f vector3f2 = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(vector3f, f, vector3f2, f2, f3, n);
    }

    private void moveto() throws ScriptException {
        if (this.statementLength == 2 && this.tokAt(1) == 1073742008) {
            if (!this.isSyntaxCheck) {
                this.viewer.stopMotion();
            }
            return;
        }
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f, null, JmolConstants.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Vector3f vector3f = new Vector3f(Float.NaN, 0.0f, 0.0f);
        Point3f point3f = null;
        int n = 1;
        float f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f2 = 90.0f;
        BitSet bitSet = null;
        switch (this.getToken((int)n).tok) {
            case 135270411: {
                Quaternion quaternion;
                boolean bl = false;
                if (this.tokAt(++n) == 1073741937) {
                    bl = true;
                    ++n;
                }
                if (this.tokAt(n) == 9 || this.tokAt(n) == 0x100001) {
                    bl = true;
                    point3f = this.centerParameter(n);
                    if (!(this.expressionResult instanceof BitSet)) {
                        this.error(22);
                    }
                    bitSet = (BitSet)this.expressionResult;
                    quaternion = this.isSyntaxCheck ? new Quaternion() : this.viewer.getAtomQuaternion(bitSet.nextSetBit(0));
                } else {
                    quaternion = new Quaternion(this.getPoint4f(n));
                }
                n = this.iToken + 1;
                if (quaternion == null) {
                    this.error(22);
                }
                AxisAngle4f axisAngle4f = quaternion.toAxisAngle4f();
                vector3f.set(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z);
                f2 = (float)(bl ? -1 : 1) * (float)((double)axisAngle4f.angle * 180.0 / Math.PI);
                break;
            }
            case 7: 
            case 8: 
            case 0x10000A: {
                if (this.isPoint3f(n)) {
                    vector3f.set(this.getPoint3f(n, true));
                    n = this.iToken + 1;
                    f2 = this.floatParameter(n++);
                    break;
                }
                Point4f point4f = this.getPoint4f(n);
                n = this.iToken + 1;
                vector3f.set(point4f.x, point4f.y, point4f.z);
                f2 = point4f.x == 0.0f && point4f.y == 0.0f && point4f.z == 0.0f ? Float.NaN : point4f.w;
                break;
            }
            case 0x40000047: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                f2 = 0.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741842: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                f2 = 180.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741919: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741989: {
                vector3f.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1074790589: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741847: {
                vector3f.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            default: {
                vector3f = new Vector3f(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f2 = this.floatParameter(n++);
            }
        }
        if (Float.isNaN(vector3f.x) || Float.isNaN(vector3f.y) || Float.isNaN(vector3f.z)) {
            vector3f.set(0.0f, 0.0f, 0.0f);
        } else if (vector3f.length() == 0.0f && f2 == 0.0f) {
            f2 = Float.NaN;
        }
        boolean bl = !this.viewer.isInPosition(vector3f, f2);
        float f3 = this.isFloatParameter(n) ? this.floatParameter(n++) : Float.NaN;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.isFloatParameter(n) && !this.isCenterParameter(n)) {
            f4 = this.floatParameter(n++);
            f5 = this.floatParameter(n++);
            if (!bl && Math.abs(f4 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f5 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        if (bitSet == null && n != this.statementLength) {
            point3f = this.centerParameter(n);
            if (this.expressionResult instanceof BitSet) {
                bitSet = (BitSet)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        float f6 = Float.NaN;
        float f7 = this.viewer.getZoomSetting();
        if (point3f != null) {
            if (!bl && (double)point3f.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n)) {
                f6 = this.floatParameter(n++);
            }
            if (!this.isCenterParameter(n)) {
                if ((f6 == 0.0f || Float.isNaN(f6)) && (f3 == 0.0f || Float.isNaN(f3))) {
                    float f8 = Math.abs(this.getZoom(n, bitSet, f3 == 0.0f ? 0.0f : f7));
                    n = this.iToken + 1;
                    f3 = f8;
                } else if (!bl && (double)Math.abs(f6 - this.viewer.getRotationRadius()) >= 0.1) {
                    bl = true;
                }
            }
        }
        if (f3 == 0.0f || Float.isNaN(f3)) {
            f3 = 100.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (!bl && Math.abs(f3 - f7) >= 1.0f) {
            bl = true;
        }
        Point3f point3f2 = null;
        float f9 = Float.NaN;
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        if (n != this.statementLength) {
            point3f2 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.statementLength) {
                f9 = this.floatParameter(n++);
                f10 = this.floatParameter(n++);
            }
            if (n != this.statementLength) {
                f11 = this.floatParameter(n++);
            }
        }
        if (n != this.statementLength) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!bl) {
            f = 0.0f;
        }
        if (f > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(f, point3f, vector3f, f2, null, f3, f4, f5, f6, point3f2, f9, f10, f11);
    }

    private void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setObjectMad(29, "axes", 1);
                    this.setShapeProperty(29, "position", new Point3f(50.0f, 50.0f, Float.MAX_VALUE));
                    this.setBooleanProperty("navigationMode", true);
                    this.viewer.setNavOn(this.theTok == 0x10000D);
                    return;
                }
                case 1073742008: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 7: {
                    break;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block27: for (int i = 1; i < this.statementLength; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.error(22);
            }
            if (!this.isSyntaxCheck && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 7: 
                case 0x10000A: {
                    Point3f point3f = this.getPoint3f(i, true);
                    ++this.iToken;
                    if (this.iToken != this.statementLength) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setNavXYZ(point3f.x, point3f.y, point3f.z);
                    return;
                }
                case 528397: {
                    float f3 = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.setNavigationDepthPercent(f, f3);
                    continue block27;
                }
                case 12289: {
                    Point3f point3f = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navigate(f, point3f);
                    continue block27;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541210: {
                            vector3f.set(1.0f, 0.0f, 0.0f);
                            break;
                        }
                        case 1112541211: {
                            vector3f.set(0.0f, 1.0f, 0.0f);
                            break;
                        }
                        case 1112541212: {
                            vector3f.set(0.0f, 0.0f, 1.0f);
                            break;
                        }
                        case 0x40000000: {
                            this.error(22);
                            break;
                        }
                        case 7: 
                        case 0x10000A: {
                            vector3f.set(this.getPoint3f(i, true));
                            i = this.iToken + 1;
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navigate(f, vector3f, f4);
                    continue block27;
                }
                case 4160: {
                    Point3f point3f;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else {
                        switch (this.tokAt(i)) {
                            case 1112541210: {
                                f5 = this.floatParameter(++i);
                                break;
                            }
                            case 1112541211: {
                                f6 = this.floatParameter(++i);
                                break;
                            }
                            default: {
                                point3f = this.centerParameter(i);
                                i = this.iToken;
                                if (this.isSyntaxCheck) continue block27;
                                this.viewer.navTranslate(f, point3f);
                                continue block27;
                            }
                        }
                    }
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navTranslatePercent(f, f5, f6);
                    continue block27;
                }
                case 0x101000A0: {
                    continue block27;
                }
                case 1113200654: {
                    Vector vector = new Vector();
                    BitSet bitSet = this.expression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bitSet, vector);
                    int n = vector.size();
                    if (n <= 0) continue block27;
                    Point3f[][] point3fArray = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        point3fArray[j] = (Point3f[])vector.get(j);
                    }
                    this.viewer.navigate(f, point3fArray);
                    continue block27;
                }
                case 0x30000D: {
                    if (i != 1) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.navigateSurface(f, this.optParameterAsString(2));
                    continue block27;
                }
                case 1073741964: {
                    int n;
                    Object object;
                    float[] fArray = null;
                    if (this.getToken((int)(i + 1)).tok == 0x100007) {
                        ++i;
                        object = this.objectNameParameter(++i);
                        if (this.isSyntaxCheck) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", object);
                        Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(22, "vertices");
                        this.refresh();
                        if (point3fArray == null) {
                            this.error(22);
                        }
                        n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                        int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                        if (this.isSyntaxCheck) continue block27;
                        this.viewer.navigate(f, point3fArray, fArray, n, n2);
                        continue block27;
                    }
                    object = new Vector();
                    while (this.isCenterParameter(i + 1)) {
                        ((Vector)object).addElement(this.centerParameter(++i));
                        i = this.iToken;
                    }
                    if (((Vector)object).size() > 0) {
                        Point3f[] point3fArray = new Point3f[((Vector)object).size()];
                        for (n = 0; n < ((Vector)object).size(); ++n) {
                            point3fArray[n] = (Point3f)((Vector)object).get(n);
                        }
                        if (this.isSyntaxCheck) continue block27;
                        this.viewer.navigate(f, point3fArray, fArray, 0, Integer.MAX_VALUE);
                        continue block27;
                    }
                }
                default: {
                    this.error(22);
                }
            }
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                n = JmolConstants.getBondOrderFromFloat(this.floatParameter(1));
                if (n != 131071) break;
                this.error(22);
                break;
            }
            default: {
                n = JmolConstants.getBondOrderFromString(this.parameterAsString(1));
                if (n == 131071) {
                    this.error(22);
                }
                if (n != 33 || this.tokAt(2) != 3) break;
                n = JmolConstants.getPartialBondOrderFromInteger(this.statement[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", new Integer(n));
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x10000D: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                this.viewer.clearConsole();
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 0x40000001: {
                string = "absolute";
                break;
            }
            case 96: {
                string = "average";
                break;
            }
            case 1679429641: {
                string = "boundbox";
                break;
            }
            default: {
                this.error(22);
            }
        }
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            point3f.x = this.floatParameter(2);
            point3f.y = this.floatParameter(3);
            point3f.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            point3f = this.centerParameter(2);
            this.checkLast(this.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(string, point3f);
        }
    }

    private void stereo() throws ScriptException {
        int n = 1;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = null;
        int n2 = 0;
        block6: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (n2 > 1) {
                    this.error(2);
                }
                if (n2 == 0) {
                    nArray = new int[2];
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n2] = this.getArgbParam(i);
                if (n2++ == 0) {
                    nArray[1] = ~nArray[0];
                }
                i = this.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    this.iToken = 1;
                    this.checkLast(1);
                    this.iToken = 1;
                    continue block6;
                }
                case 0x10000C: {
                    this.iToken = 1;
                    this.checkLast(1);
                    n = 0;
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!bl) {
                        f = 3.0f;
                    }
                    if ((n = JmolConstants.getStereoMode(this.parameterAsString(i))) != -1) continue block6;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setStereoMode(nArray, n, f);
    }

    private void compare() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Quaternion[] quaternionArray = null;
        Quaternion[] quaternionArray2 = null;
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        Vector<BitSet[]> vector = null;
        Vector<Object[]> vector2 = null;
        BitSet bitSet3 = this.expression(1);
        BitSet bitSet4 = this.expression(++this.iToken);
        BitSet bitSet5 = null;
        block10: for (int i = this.iToken + 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10100030: {
                    continue block10;
                }
                case 0x303007: {
                    bitSet5 = this.expression(++i);
                    i = this.iToken;
                    continue block10;
                }
                case 9: 
                case 0x100001: {
                    if (vector2 != null) {
                        this.error(22);
                    }
                    bitSet = this.expression(this.iToken);
                    int n = this.tokAt(this.iToken + 1);
                    bitSet2 = n == 9 || n == 0x100001 ? this.expression(++this.iToken) : BitSetUtil.copy(bitSet);
                    bitSet.and(bitSet3);
                    bitSet2.and(bitSet4);
                    if (bitSet5 != null) {
                        bitSet.and(bitSet5);
                        bitSet2.and(bitSet5);
                    }
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(new BitSet[]{bitSet, bitSet2});
                    i = this.iToken;
                    continue block10;
                }
                case 6: {
                    if (vector != null) {
                        this.error(22);
                    }
                    bl = true;
                    quaternionArray = ScriptMathProcessor.getQuaternionArray((Object[])this.theToken.value);
                    this.getToken(++i);
                    quaternionArray2 = ScriptMathProcessor.getQuaternionArray((Object[])this.theToken.value);
                    if (vector2 == null) {
                        vector2 = new Vector<Object[]>();
                    }
                    vector2.add(new Object[]{quaternionArray, quaternionArray2});
                    continue block10;
                }
                case 1073741961: {
                    bl = true;
                    continue block10;
                }
                case 0x44100001: {
                    bl = false;
                    continue block10;
                }
                case 528432: {
                    bl2 = true;
                    continue block10;
                }
                case 4160: {
                    bl3 = true;
                    continue block10;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        float[] fArray = new float[2];
        Quaternion quaternion = null;
        Vector<Quaternion> vector3 = new Vector<Quaternion>();
        Point3f[][] point3fArray = null;
        if (bl) {
            int n;
            if (vector == null && vector2 == null) {
                vector = new Vector<BitSet[]>();
                vector.add(new BitSet[]{bitSet3, bitSet4});
            }
            if (vector2 == null) {
                for (n = 0; n < vector.size(); ++n) {
                    BitSet[] bitSetArray = (BitSet[])vector.get(n);
                    quaternionArray = this.viewer.getAtomGroupQuaternions(bitSetArray[0], Integer.MAX_VALUE);
                    quaternionArray2 = this.viewer.getAtomGroupQuaternions(bitSetArray[1], Integer.MAX_VALUE);
                    for (int i = 0; i < quaternionArray.length && i < quaternionArray2.length; ++i) {
                        vector3.add(quaternionArray2[i].div(quaternionArray[i]));
                    }
                }
            } else {
                for (n = 0; n < quaternionArray.length && n < quaternionArray2.length; ++n) {
                    vector3.add(quaternionArray2[n].div(quaternionArray[n]));
                }
            }
            fArray[0] = 0.0f;
            quaternionArray = new Quaternion[vector3.size()];
            n = vector3.size();
            while (--n >= 0) {
                quaternionArray[n] = (Quaternion)vector3.get(n);
            }
            quaternion = Quaternion.sphereMean(quaternionArray, fArray, 1.0E-4f);
            this.showString("RMSD = " + fArray[0] + " degrees");
        } else {
            if (bitSet == null) {
                bitSet = this.viewer.getAtomBitSet("spine");
                bitSet2 = BitSetUtil.copy(bitSet);
                bitSet.and(bitSet3);
                bitSet2.and(bitSet4);
                vector = new Vector();
                vector.add(new BitSet[]{bitSet, bitSet2});
            }
            point3fArray = this.viewer.getCenterAndPoints(vector, true);
            quaternion = this.viewer.calculateQuaternionRotation(point3fArray, fArray);
            this.showString("RMSD " + fArray[1] + " --> " + fArray[0] + " Angstroms");
        }
        Point3f point3f = new Point3f();
        if (point3fArray == null) {
            point3fArray = this.viewer.getCenterAndPoints(vector, true);
        }
        if (bl2) {
            if (quaternion == null) {
                this.evalError("option not implemented", null);
            }
            point3f.set(point3fArray[0][0]);
            point3f.add(quaternion.getNormal());
            float f = quaternion.getTheta();
            this.viewer.rotateAboutPointsInternal(point3fArray[0][0], point3f, f, Float.MAX_VALUE, false, bitSet3);
        }
        if (bl3) {
            point3f.set(point3fArray[1][0]);
            point3f.sub(point3fArray[0][0]);
            this.viewer.setAtomCoordRelative(point3f, bitSet3);
        }
    }

    private void connect(int n) throws ScriptException {
        Object object;
        int n2;
        float[] fArray = new float[2];
        BitSet[] bitSetArray = new BitSet[2];
        bitSetArray[0] = bitSetArray[1] = this.viewer.getSelectionSet();
        float f = Float.NaN;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 131071;
        int n6 = 1073741935;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n7 = 0;
        int n8 = 0;
        BitSet bitSet = new BitSet();
        boolean bl5 = false;
        int n9 = 0;
        int n10 = 0;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block17: for (n2 = n; n2 < this.statementLength; ++n2) {
            switch (this.getToken((int)n2).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int n11;
                    if (n7 > 0) {
                        if (bl2 || bl4) {
                            this.error(23);
                        }
                        if ((n11 = JmolConstants.getBondOrderFromFloat(this.floatParameter(n2))) == 131071) {
                            this.error(22);
                        }
                        n5 = n11;
                        bl2 = true;
                        break;
                    }
                    if (++n8 > 2) {
                        this.error(2);
                    }
                    float f3 = this.floatParameter(n2);
                    if (this.tokAt(n2 + 1) == 269484194) {
                        f3 = -f3 / 100.0f;
                        ++n2;
                    }
                    fArray[n4++] = f3;
                    break;
                }
                case 9: 
                case 0x100001: {
                    int n12;
                    int n13;
                    if (n7 > 2 || bl5 && n7 > 0) {
                        this.error(2);
                    }
                    if (bl2 || bl4) {
                        this.error(23);
                    }
                    bitSetArray[n7++] = this.expression(n2);
                    bl5 = this.isBondSet;
                    if (n7 == 2) {
                        n13 = this.iToken;
                        for (n12 = n2; n12 < n13; ++n12) {
                            if (this.tokAt(n12) != 0x40000000 || !this.parameterAsString(n12).equals("_1")) continue;
                            n9 = n2;
                            break;
                        }
                        this.iToken = n13;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1632638983: {
                    int n13 = this.tokAt(n2 + 1);
                    if (n13 == 0x400000C4 || n13 == 1073741959) continue block17;
                    n10 = n2 + 1;
                    continue block17;
                }
                case 1073741959: 
                case 0x400000C4: {
                    if (string != null) {
                        this.error(22);
                    }
                    bl4 = true;
                    string = this.parameterAsString(n2);
                    if (this.theTok == 0x400000C4 && this.isFloatParameter(n2 + 1)) {
                        f2 = this.getTranslucentLevel(++n2);
                    }
                    n10 = n2 + 1;
                    break;
                }
                case 1074790541: {
                    int n12 = this.tokAt(2) == 0x4000000E ? 1 : 0;
                    this.checkLength(n12 != 0 ? 3 : 2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setPdbConectBonding(n12 != 0);
                    }
                    return;
                }
                case 0x40000003: 
                case 0x4000000E: 
                case 1073741864: 
                case 1073741934: 
                case 1073741935: {
                    bl3 = true;
                    if (++n2 != this.statementLength) {
                        this.error(23);
                    }
                    n6 = this.theTok;
                    if (this.theTok != 0x4000000E || n5 == 131071 || n5 == 2048 || n5 == 515) break;
                    this.error(22);
                    break;
                }
                case 1577017: {
                    if (!bl4) {
                        n3 = 0xFFFFFF;
                        string = "translucent";
                        f2 = 0.5f;
                        f = this.viewer.getStrutDefaultRadius();
                        bl4 = true;
                    }
                    if (!bl3) {
                        n6 = 1073741935;
                    }
                    bl3 = true;
                }
                case 0x40000000: 
                case 1076887563: 
                case 1612189721: {
                    if (n10 == n2) break;
                    if (this.isColorParam(n2)) {
                        n10 = -n2;
                        break;
                    }
                    object = this.parameterAsString(n2);
                    int n11 = JmolConstants.getBondOrderFromString((String)object);
                    if (n11 == 131071) {
                        this.error(22);
                    }
                    if (bl2) {
                        this.error(18);
                    }
                    bl2 = true;
                    if (n11 == 33) {
                        switch (this.tokAt(n2 + 1)) {
                            case 3: {
                                n11 = JmolConstants.getPartialBondOrderFromInteger(this.statement[++n2].intValue);
                                break;
                            }
                            case 2: {
                                n11 = (short)this.intParameter(++n2);
                            }
                        }
                    }
                    n5 = n11;
                    break;
                }
                case 1666189313: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    break;
                }
                case 12291: 
                case 0x10000B: {
                    if (++n2 != this.statementLength) {
                        this.error(23);
                    }
                    n6 = 0;
                    bl = true;
                    bl4 = false;
                    break;
                }
                default: {
                    n10 = n2;
                }
            }
            if (n10 == -n2 || n10 == n2 && this.isColorParam(n2)) {
                n3 = this.getArgbParam(n2);
                n2 = this.iToken;
                bl4 = true;
                continue;
            }
            if (n10 != n2) continue;
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 < 2) {
            if (n4 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n3 != Integer.MIN_VALUE) {
            if (!bl2) {
                n5 = 65535;
            }
            if (!bl3) {
                n6 = 1073741934;
            }
        }
        n2 = 0;
        int n14 = 0;
        if (n9 > 0) {
            BitSet bitSet2 = new BitSet();
            this.definedAtomSets.put("_1", bitSet2);
            object = bitSetArray[0];
            int n15 = ((BitSet)object).nextSetBit(0);
            while (n15 >= 0) {
                bitSet2.set(n15);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bitSet2, this.expression(n9), bitSet, bl5);
                n2 += nArray[0];
                n14 += nArray[1];
                bitSet2.clear(n15);
                n15 = ((BitSet)object).nextSetBit(n15 + 1);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bitSetArray[0], bitSetArray[1], bitSet, bl5);
            n2 += nArray[0];
            n14 += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatusOrBuffer(GT._("{0} connections deleted", n14));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bitSet);
            if (!Float.isNaN(f)) {
                this.viewer.setShapeSize(1, (int)(f * 2000.0f), bitSet);
            }
            if (n3 != Integer.MIN_VALUE) {
                this.viewer.setShapeProperty(1, "color", new Integer(n3), bitSet);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getDefaultTranslucent();
                }
                this.viewer.setShapeProperty(1, "translucentLevel", new Float(f2));
                this.viewer.setShapeProperty(1, "translucency", string, bitSet);
            }
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} new bonds; {1} modified", new Object[]{new Integer(n2), new Integer(n14)}));
        }
    }

    private float getTranslucentLevel(int n) throws ScriptException {
        float f = this.floatParameter(n);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private void getProperty() throws ScriptException {
        BitSet bitSet;
        if (this.isSyntaxCheck) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = string2;
        if (string3.indexOf(".") >= 0) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.indexOf("[") >= 0) {
            string3 = string3.substring(0, string3.indexOf("["));
        }
        int n = PropertyManager.getPropertyNumber(string3);
        String string4 = this.optParameterAsString(2);
        int n2 = this.tokAt(2);
        BitSet bitSet2 = bitSet = n2 == 0x100001 || n2 == 9 ? this.expression(2) : null;
        if (string2.length() > 0 && n < 0) {
            string2 = "";
            string4 = "";
        } else if (n >= 0 && this.statementLength < 3) {
            string4 = PropertyManager.getDefaultParam(n);
            if (string4.equals("(visible)")) {
                this.viewer.setModelVisibility();
                bitSet = this.viewer.getVisibleSet();
            }
        } else if (n == 3) {
            for (int i = 3; i < this.statementLength; ++i) {
                string4 = string4 + this.parameterAsString(i);
            }
        }
        string = (String)this.viewer.getProperty("readable", string2, bitSet == null ? string4 : bitSet);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.theTok == 0x40000055) {
            String string = this.parameterAsString(this.checkLast(++n));
            if (this.isSyntaxCheck) {
                return;
            }
            Hashtable hashtable = new Hashtable();
            Object object = null;
            if (!string.equalsIgnoreCase("none") && string.length() > 0) {
                object = this.viewer.getFileAsImage(string, hashtable);
            }
            if (object instanceof String) {
                this.evalError((String)object, null);
            }
            this.viewer.setBackgroundImage((String)hashtable.get("fullPathName"), (Image)object);
            return;
        }
        if (this.isColorParam(n) || this.theTok == 0x10000B) {
            int n2 = this.getArgbParamLast(n, true);
            if (this.isSyntaxCheck) {
                return;
            }
            this.viewer.setObjectArgb("background", n2);
            this.viewer.setBackgroundImage(null, null);
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f point3f = this.centerParameter(n);
        if (point3f == null) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(point3f);
        }
    }

    private String setObjectProperty() throws ScriptException {
        String string = "";
        String string2 = this.getShapeNameParameter(2);
        Object[] objectArray = new Object[]{string2, null};
        if (this.isSyntaxCheck) {
            return "";
        }
        int n = this.iToken;
        int n2 = this.tokAt(0);
        boolean bl = TextFormat.isWild(string2);
        int n3 = 17;
        do {
            if (n3 != 25 && this.viewer.getShapeProperty(n3, "checkID", objectArray)) {
                this.setShapeProperty(n3, "thisID", string2);
                switch (n2) {
                    case 12291: {
                        this.setShapeProperty(n3, "delete", null);
                        break;
                    }
                    case 12293: 
                    case 1610625028: {
                        this.setShapeProperty(n3, "hidden", n2 == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 4148: {
                        if (n3 == 23 && !bl) {
                            return this.getIsosurfaceJvxl(false, 23);
                        }
                        if (n3 == 26 && !bl) {
                            return this.getIsosurfaceJvxl(true, 26);
                        }
                        string = string + (String)this.viewer.getShapeProperty(n3, "command") + "\n";
                    }
                    case 1632638983: {
                        this.colorShape(n3, n + 1, false);
                    }
                }
                if (!bl) break;
            }
            if (n3 != 17) continue;
            n3 = 29;
        } while (--n3 >= 22);
        return string;
    }

    private void color() throws ScriptException {
        int n = 1;
        if (this.isColorParam(1)) {
            this.theTok = 0x44100001;
        } else {
            int n2 = 0;
            n = 2;
            switch (this.getToken((int)1).tok) {
                case 0x100007: {
                    this.setObjectProperty();
                    return;
                }
                case 0x10000B: 
                case 0x300001: 
                case 0x40000043: 
                case 1073741917: 
                case 1073741938: 
                case 1073741959: 
                case 1073741983: 
                case 1073741998: 
                case 0x400000C4: 
                case 1073742023: 
                case 1087373315: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373322: 
                case 1095761934: 
                case 1104154627: 
                case 1112539151: 
                case 1112539152: 
                case 1112541194: 
                case 1112541201: 
                case 1112541205: 
                case 1113200651: 
                case 1297090050: 
                case 1632634889: 
                case 1716520973: {
                    this.theTok = 0x44100001;
                    n = 1;
                    break;
                }
                case 4: {
                    boolean bl;
                    String string = this.stringParameter(1);
                    boolean bl2 = bl = this.tokAt(2) == 0x400000C4;
                    if (!this.isSyntaxCheck) {
                        this.viewer.setPropertyColorScheme(string, bl, true);
                    }
                    int n3 = n = bl ? 3 : 2;
                    if (this.tokAt(n) == 1073741982 || this.tokAt(n) == 0x40000001) {
                        float f = this.floatParameter(++n);
                        float f2 = this.floatParameter(++n);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setCurrentColorRange(f, f2);
                        }
                    }
                    return;
                }
                case 0x40000001: 
                case 1073741982: {
                    float f = this.floatParameter(2);
                    float f3 = this.floatParameter(this.checkLast(3));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(f, f3);
                    }
                    return;
                }
                case 1610616835: {
                    n2 = this.getArgbParamLast(2, true);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setObjectArgb("background", n2);
                    }
                    return;
                }
                case 9: 
                case 0x100001: {
                    n = -1;
                    this.theTok = 0x44100001;
                    break;
                }
                case 1073741993: {
                    n2 = this.getArgbParamLast(2, false);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setRubberbandArgb(n2);
                    }
                    return;
                }
                case 1611141171: {
                    n = 2;
                    if (this.tokAt(2) == 1073741959) {
                        ++n;
                    }
                    n2 = this.getArgbParamLast(n, true);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.loadShape(8);
                    this.setShapeProperty(8, "argbSelection", new Integer(n2));
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1613758468: 
                case 1614417984: 
                case 1679429641: {
                    String string = this.parameterAsString(1);
                    if (this.checkToken(2)) {
                        switch (this.getToken((int)2).tok) {
                            case 1073741983: {
                                n2 = 1073741983;
                                break;
                            }
                            case 0x10000B: 
                            case 1073741917: {
                                n2 = 1073741917;
                                break;
                            }
                            default: {
                                n2 = this.getArgbParam(2);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (string.equalsIgnoreCase("axes")) {
                        this.setStringProperty("axesColor", Escape.escapeColor(n2));
                        return;
                    }
                    if (StateManager.getObjectIdFromName(string) >= 0) {
                        if (!this.isSyntaxCheck) {
                            this.viewer.setObjectArgb(string, n2);
                        }
                        return;
                    }
                    if (this.changeElementColor(string, n2)) {
                        return;
                    }
                    this.error(22);
                }
                case 135197: {
                    this.setShapeProperty(23, "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), n, false);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.elementNameFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.altElementNameFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + JmolConstants.elementSymbolFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + JmolConstants.altElementSymbolFromIndex(n2))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + JmolConstants.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        String string = null;
        Number number = null;
        BitSet bitSet = null;
        String string2 = "";
        boolean bl2 = false;
        int n3 = 0;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bitSet = this.expression(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                n = 1;
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 1610616835;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        }
        if (!this.isSyntaxCheck && n == 25 && !this.mo(true)) {
            return;
        }
        if (this.theTok == 0x400000C4 || this.theTok == 1073741959) {
            string = this.parameterAsString(n2++);
            if (this.theTok == 0x400000C4 && this.isFloatParameter(n2)) {
                f = this.getTranslucentLevel(n2++);
            }
        }
        int n4 = 0;
        if (n2 < this.statementLength && this.tokAt(n2) != 0x10000D && this.tokAt(n2) != 0x10000C) {
            bl2 = true;
            n4 = this.getToken((int)n2).tok;
            if (this.isColorParam(n2)) {
                int n5 = this.getArgbParam(n2, false);
                Integer n6 = number = n5 == 0 ? null : new Integer(n5);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    if (string == null && (this.theTok == 0x400000C4 || this.theTok == 1073741959)) {
                        string = this.parameterAsString(n2);
                        if (this.theTok == 0x400000C4 && this.isFloatParameter(n2 + 1)) {
                            f = this.getTranslucentLevel(++n2);
                        }
                    }
                }
            } else if (n == 24) {
                --this.iToken;
            } else {
                Object object;
                int n7;
                boolean bl3;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl4 = string3.indexOf("byelement") == 0;
                boolean bl5 = bl3 = bl4 || string3.indexOf("byresidue") == 0;
                int n8 = bl3 || n == 23 ? 84 : (n7 = n4 == 1113200651 ? 1 : (int)JmolConstants.getPaletteID(string3));
                if (n7 == -1 || (n7 == 18 || n7 == 19) && n != 2) {
                    this.error(22);
                }
                Object object2 = null;
                if (n7 == 84) {
                    if (bl3) {
                        if (!this.isSyntaxCheck) {
                            object2 = this.getBitsetProperty(null, (bl4 ? 1095763976 : 1095761930) | 0x1E0, null, null, null, null, false, Integer.MAX_VALUE, false);
                        }
                    } else {
                        if (!bl3 && n != 23) {
                            ++n2;
                        }
                        if (string3.equals("property") && Token.tokAttr(n4 = this.getToken((int)n2).tok, 0x40500000) && !Token.tokAttr(n4, 0x40D00000) && !this.isSyntaxCheck) {
                            object2 = this.getBitsetProperty(null, this.getToken((int)n2++).tok | 0x1E0, null, null, null, null, false, Integer.MAX_VALUE, false);
                        }
                    }
                    if (object2 != null && !(object2 instanceof float[])) {
                        if (object2 instanceof String[]) {
                            object = new float[((String[])object2).length];
                            Parser.parseFloatArray((String[])object2, null, (float[])object);
                            object2 = object;
                        } else {
                            this.error(22);
                        }
                    }
                } else if (n7 == 85) {
                    int n9 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n9);
                    object2 = new float[this.viewer.getAtomCount()];
                    Parser.parseFloatArray("" + this.getParameter(string3, false), null, object2);
                    n7 = 84;
                }
                if (n7 == 84) {
                    Object object3 = object = this.tokAt(n2) == 4 ? this.parameterAsString(n2++).toLowerCase() : null;
                    if (object != null) {
                        this.setStringProperty("propertyColorScheme", (String)object);
                        bl3 = ((String)object).indexOf("byelement") == 0 || ((String)object).indexOf("byresidue") == 0;
                    }
                    float f2 = 0.0f;
                    float f3 = Float.MAX_VALUE;
                    if (!(bl3 || this.tokAt(n2) != 0x40000001 && this.tokAt(n2) != 1073741982)) {
                        f2 = this.floatParameter(n2 + 1);
                        f3 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (f2 == f3 && n == 23) {
                            float[] fArray = (float[])this.viewer.getShapeProperty(n, "dataRange");
                            if (fArray != null) {
                                f2 = fArray[0];
                                f3 = fArray[1];
                            }
                        } else if (f2 == f3) {
                            f3 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        if (n != 23 && f3 != -3.4028235E38f) {
                            if (object2 == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRange((float[])object2, null);
                            }
                        }
                        if (f3 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange(f2, f3);
                        }
                    }
                    if (n == 23) {
                        string2 = "remap";
                    }
                } else {
                    ++n2;
                }
                number = new Byte((byte)n7);
                this.checkLength(n2);
            }
        }
        if (this.isSyntaxCheck || n < 0) {
            return;
        }
        int n10 = n == 4 ? 32768 : (n == 2 ? 30720 : (n == 3 ? 256 : (n3 = n == 1 ? 1023 : 0)));
        if (n3 == 0) {
            this.viewer.loadShape(n);
            if (n == 5) {
                this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bitSet != null) {
                this.viewer.selectBonds(bitSet);
                bitSet = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", new Integer(n3));
        }
        if (bl2) {
            switch (n4) {
                case 1112539151: 
                case 1112539152: {
                    this.viewer.autoCalculate(n4);
                    break;
                }
                case 1112541201: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 1087373318: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 1073741938: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 1095761934: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            if (bitSet == null) {
                this.viewer.setShapeProperty(n, string2 + "color", number);
            } else {
                this.viewer.setShapeProperty(n, string2 + "color", number, bitSet);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f, bitSet);
        }
        if (n3 != 0) {
            this.viewer.setShapeProperty(1, "type", new Integer(1023));
        }
    }

    private void colorShape(int n, int n2, int n3, String string, float f, BitSet bitSet) {
        if (n2 != 0) {
            n = 1;
            this.setShapeProperty(1, "type", new Integer(n2));
        }
        this.viewer.setShapeProperty(n, "color", new Integer(n3), bitSet);
        if (string != null) {
            this.setShapeTranslucency(n, "", string, f, bitSet);
        }
        if (n2 != 0) {
            this.viewer.setShapeProperty(1, "type", new Integer(1023));
        }
    }

    private void setShapeTranslucency(int n, String string, String string2, float f, BitSet bitSet) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(n, "translucentLevel", new Float(f));
        if (string == null) {
            return;
        }
        if (bitSet == null) {
            this.setShapeProperty(n, string + "translucency", string2);
        } else if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(n, string + "translucency", string2, bitSet);
        }
    }

    private void cd() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.statementLength == 1 ? null : this.parameterAsString(1);
        this.showString(this.viewer.cd(string));
    }

    private void data() throws ScriptException {
        int n;
        int n2;
        boolean bl;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int n3 = string2.indexOf("@");
                if (n3 >= 0) {
                    string = "" + this.getParameter(string2.substring(n3 + 1), false);
                    string2 = string2.substring(0, n3).trim();
                    break;
                }
                if (string != null || (n3 = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n3 + 1).trim();
                string2 = string2.substring(0, n3).trim();
                bl2 = true;
                break;
            }
            default: {
                this.error(2);
            }
        }
        string2 = string2.toLowerCase();
        String string3 = string2 + " ";
        boolean bl3 = string2.indexOf("(default)") >= 0;
        string3 = string3.substring(0, string3.indexOf(" "));
        boolean bl4 = string3.equals("model");
        boolean bl5 = string3.equals("append");
        boolean bl6 = bl = !(!bl4 && !bl5 || this.isSyntaxCheck && !this.isCmdLine_C_Option);
        if ((bl4 || bl5) && string == null) {
            this.error(22);
        }
        int n4 = -1;
        if (bl) {
            n2 = this.viewer.getInlineChar();
            if (string.length() > 0 && string.charAt(0) != n2) {
                n2 = 0;
            }
            int n5 = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
            n = this.viewer.getAppendNew();
            this.viewer.loadInline(string, (char)n2, bl5);
            if (bl5 && n != 0) {
                this.viewer.setAnimationRange(-1, -1);
                this.viewer.setCurrentModelIndex(n5);
            }
        }
        if (this.isSyntaxCheck && !bl) {
            return;
        }
        this.data = new Object[3];
        if (string3.equals("element_vdw")) {
            this.data[0] = string3;
            this.data[1] = string.replace(';', '\n');
            n2 = JmolConstants.elementNumberMax;
            int[] nArray = new int[n2 + '\u0001'];
            for (n = 1; n <= n2; ++n) {
                nArray[n] = n;
            }
            this.data[2] = nArray;
            this.viewer.setData("element_vdw", this.data, n2, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data2d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray2d(string);
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data3d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray3d(string);
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        String[] stringArray = Parser.getTokens(string2);
        if (!(string3.indexOf("property_") != 0 || stringArray.length == 2 && stringArray[1].equals("set"))) {
            int n6;
            BitSet bitSet = this.viewer.getSelectionSet();
            this.data[0] = string3;
            n = bl2 ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
            int n7 = bl2 ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberColumnCount");
            int n8 = bl2 ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
            int n9 = n6 = bl2 ? 0 : (Integer)this.viewer.getParameter("propertyDataColumnCount");
            if (!bl2 && string2.indexOf(" ") >= 0) {
                if (stringArray.length == 3) {
                    string2 = stringArray[0];
                    n = Parser.parseInt(stringArray[1]);
                    n8 = Parser.parseInt(stringArray[2]);
                }
                if (stringArray.length == 5) {
                    string2 = stringArray[0];
                    n = Parser.parseInt(stringArray[1]);
                    n7 = Parser.parseInt(stringArray[2]);
                    n8 = Parser.parseInt(stringArray[3]);
                    n6 = Parser.parseInt(stringArray[4]);
                }
            }
            if (n < 0) {
                n = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            int n10 = this.viewer.getAtomCount();
            int[] nArray = null;
            BitSet bitSet2 = new BitSet(n10);
            if (n > 0) {
                int n11;
                nArray = new int[n10 + 2];
                for (n11 = 0; n11 <= n10; ++n11) {
                    nArray[n11] = -1;
                }
                n11 = bitSet.nextSetBit(0);
                while (n11 >= 0) {
                    int n12 = this.viewer.getAtomNumber(n11);
                    if (n12 <= n10 + 1 && n12 >= 0 && !bitSet2.get(n12)) {
                        bitSet2.set(n12);
                        nArray[n12] = n11;
                    }
                    n11 = bitSet.nextSetBit(n11 + 1);
                }
                this.data[2] = nArray;
            } else {
                this.data[2] = BitSetUtil.copy(bitSet);
            }
            this.data[1] = string;
            this.viewer.setData(string3, this.data, n10, n, n7, n8, n6);
            return;
        }
        n4 = AtomCollection.getUserSettableType(string3);
        if (n4 >= 0) {
            this.viewer.setAtomData(n4, string3, string, bl3);
            return;
        }
        this.data[0] = string2;
        this.data[1] = string;
        this.viewer.setData(string3, this.data, 0, 0, 0, 0, 0);
    }

    private void define() throws ScriptException {
        boolean bl;
        String string = (String)this.getToken((int)1).value;
        BitSet bitSet = this.expression(2);
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = bl = string.indexOf("dynamic_") == 0;
        if (bl) {
            Token[] tokenArray = new Token[this.statementLength];
            int n = this.statementLength;
            while (--n >= 0) {
                tokenArray[n] = this.statement[n];
            }
            this.definedAtomSets.put("!" + string.substring(8), tokenArray);
            this.viewer.addStateScript(this.thisCommand, false, true);
        } else {
            this.definedAtomSets.put(string, bitSet);
            this.setStringProperty("@" + string, Escape.escape(bitSet));
        }
    }

    private void echo(int n, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            if (bl) {
                Hashtable hashtable = new Hashtable();
                Object object = this.viewer.getFileAsImage(string, hashtable);
                if (object instanceof String) {
                    string = (String)object;
                } else {
                    this.setShapeProperty(28, "text", hashtable.get("fullPathName"));
                    this.setShapeProperty(28, "image", object);
                    string = null;
                }
            } else if (string.startsWith("\u0001")) {
                string = string.substring(1);
                bl = true;
            }
            if (string != null) {
                this.setShapeProperty(28, "text", string);
            }
        }
        if (!bl && this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string));
        }
    }

    private void message() throws ScriptException {
        String string = this.parameterAsString(this.checkLast(1));
        if (this.isSyntaxCheck) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            this.viewer.showMessage(string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatusOrBuffer(string2);
        }
    }

    private void log() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        String string = (String)this.parameterExpression(1, 0, "", false);
        if (this.tokAt(1) == 0x10000C) {
            this.setStringProperty("logFile", "");
        } else {
            this.viewer.log(string);
        }
    }

    private void print() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        this.showString((String)this.parameterExpression(1, 0, "", false), true);
    }

    private boolean pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return false;
        }
        String string = this.optParameterAsString(1);
        if (!this.viewer.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.viewer.autoExit || !this.viewer.haveDisplay) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.viewer.scriptStatus("nothing to pause: " + string);
            return false;
        }
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.pauseExecution();
        this.viewer.scriptStatus("script execution paused" + string, "script paused for RESUME");
        return true;
    }

    private void label(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.loadShape(5);
        String string = null;
        switch (this.getToken((int)n).tok) {
            case 0x10000D: {
                string = this.viewer.getStandardLabelFormat();
                break;
            }
            case 0x10000C: {
                break;
            }
            case 12293: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            default: {
                string = this.parameterAsString(n);
            }
        }
        this.viewer.setLabel(string);
    }

    private void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.setHoverLabel(string);
    }

    private void load() throws ScriptException {
        String string;
        Object object;
        int n;
        boolean bl = false;
        Vector<Object> vector = null;
        int n2 = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        boolean bl2 = this.viewer.getAppendNew();
        StringBuffer stringBuffer = new StringBuffer("load");
        int n3 = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n4 = 1;
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n5 = 0;
        boolean bl3 = !this.isSyntaxCheck || this.isCmdLine_C_Option;
        String string4 = null;
        String string5 = "";
        if (this.statementLength == 1) {
            n4 = 0;
        } else {
            string2 = this.parameterAsString(n4);
            n = this.tokAt(n4);
            if (string2.equalsIgnoreCase("data")) {
                string2 = this.stringParameter(++n4);
                if (!this.isSyntaxCheck) {
                    hashtable.put("parameterData", this.viewer.getFileAsString(string2));
                }
                stringBuffer.append(" data /*file*/").append(string2).append(Escape.escape(string2));
                n = this.tokAt(++n4);
                string2 = this.parameterAsString(n4);
            }
            if (n == 0x40000000 || string2.equalsIgnoreCase("fileset")) {
                if (string2.equals("menu")) {
                    String string6 = this.parameterAsString(this.checkLast(2));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setMenu(string6, true);
                    }
                    return;
                }
                ++n4;
                stringBuffer.append(" " + string2);
                bl = string2.equalsIgnoreCase("append");
                int n6 = n5 = Parser.isOneOf(string2.toLowerCase(), "xyz;vxyz;vibration;temperature;occupancy;partialcharge") ? Token.getTokenFromName((String)string2.toLowerCase()).tok : 0;
                if (n5 > 0) {
                    hashtable.put("atomDataOnly", Boolean.TRUE);
                    hashtable.put("modelNumber", new Integer(1));
                    if (n5 == 4166) {
                        n5 = 1146095629;
                    }
                    stringArray2 = this.viewer.getFileInfo();
                }
                if (bl && ((string3 = this.optParameterAsString(n4)).equalsIgnoreCase("trajectory") || string3.equalsIgnoreCase("models"))) {
                    string2 = string3;
                    stringBuffer.append(" " + string2);
                    ++n4;
                }
                if (n5 > 0) {
                    bl = true;
                }
                if (string2.equalsIgnoreCase("trajectory") || string2.equalsIgnoreCase("models")) {
                    Serializable serializable;
                    if (string2.equalsIgnoreCase("trajectory")) {
                        hashtable.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(n4)) {
                        serializable = this.getPoint3f(n4, false);
                        n4 = this.iToken + 1;
                        hashtable.put("firstLastStep", new int[]{(int)serializable.x, (int)serializable.y, (int)serializable.z});
                        stringBuffer.append(" " + Escape.escape(serializable));
                    } else if (this.tokAt(n4) == 9) {
                        serializable = (BitSet)this.getToken((int)n4++).value;
                        hashtable.put("bsModels", serializable);
                        stringBuffer.append(" " + Escape.escape((BitSet)serializable));
                    } else {
                        hashtable.put("firstLastStep", new int[]{0, -1, 1});
                    }
                }
            } else {
                string2 = "fileset";
            }
            if (this.getToken((int)n4).tok != 4) {
                this.error(16);
            }
        }
        int n7 = n4;
        String string7 = null;
        if (this.tokAt(n7 + 1) == 1073742125) {
            string7 = this.stringParameter(n4 + 2);
            n4 += 2;
        }
        if (this.statementLength == n4 + 1) {
            if (n4 == 0 || (string3 = this.parameterAsString(n7)).length() == 0) {
                string3 = this.viewer.getFullPathName();
            }
            if (string3 == null) {
                this.zap(false);
                return;
            }
            if (string3.indexOf("[]") >= 0) {
                return;
            }
        } else if (this.getToken((int)(n4 + 1)).tok == 0x10000A || this.theTok == 7 || this.theTok == 2 || this.theTok == 0x40000066 || this.theTok == 1073741962 || this.theTok == 0x40000040 && this.tokAt(n4 + 3) != 0x100006 || this.theTok == 0x40000000 && this.tokAt(n4 + 3) != 0x100006) {
            string3 = this.parameterAsString(n7);
            if (string3.length() == 0) {
                string3 = this.viewer.getFullPathName();
            }
            if (n7 == n4) {
                ++n4;
            }
            if (string3 == null) {
                this.zap(false);
                return;
            }
            if (string3.indexOf("[]") >= 0) {
                return;
            }
            n = this.tokAt(n4);
            if (n == 0x40000066) {
                object = this.stringParameter(++n4);
                hashtable.put("manifest", object);
                string5 = string5 + " MANIFEST " + Escape.escape((String)object);
                n = this.tokAt(++n4);
            }
            if (n == 2) {
                int n8 = this.intParameter(n4);
                string5 = string5 + " " + n8;
                if (n8 < 0) {
                    hashtable.put("vibrationNumber", new Integer(-n8));
                } else {
                    hashtable.put("modelNumber", new Integer(n8));
                }
                n = this.tokAt(++n4);
            }
            object = null;
            if (n == 0x10000A || n == 7) {
                object = this.getPoint3f(n4, false);
                n4 = this.iToken + 1;
                n = this.tokAt(n4);
            }
            boolean bl4 = false;
            if (n == 1073741962) {
                if (object == null) {
                    object = new Point3f(555.0f, 555.0f, -1.0f);
                }
                bl4 = true;
                ++this.iToken;
                ++n4;
            }
            if (object != null) {
                n4 = this.iToken + 1;
                hashtable.put("lattice", object);
                string5 = string5 + " {" + (int)((Point3f)object).x + " " + (int)((Point3f)object).y + " " + (int)((Point3f)object).z + "}";
                if (bl4) {
                    hashtable.put("packed", Boolean.TRUE);
                    string5 = string5 + " PACKED";
                }
                float f = 0.0f;
                if (this.tokAt(n4) == 1073741982) {
                    int n9 = ++n4;
                    ++n4;
                    f = this.floatParameter(n9);
                    string5 = string5 + " range " + f;
                }
                hashtable.put("symmetryRange", new Float(f));
                String string8 = null;
                float[] fArray = null;
                int n10 = Integer.MIN_VALUE;
                if (this.tokAt(n4) == 1073742003) {
                    int n11 = ++n4;
                    ++n4;
                    string8 = TextFormat.simpleReplace(this.parameterAsString(n11), "''", "\"");
                    string5 = string5 + " spacegroup " + Escape.escape(string8);
                }
                if (this.tokAt(n4) == 1614417984) {
                    fArray = this.floatParameterSet(++n4, 6, 6);
                    n4 = this.iToken;
                    string5 = string5 + " unitcell {";
                    for (int i = 0; i < 6; ++i) {
                        string5 = string5 + (i == 0 ? "" : " ") + fArray[i];
                    }
                    string5 = string5 + "}";
                    hashtable.put("unitcell", fArray);
                }
                if (string8 != null) {
                    if (string8.equalsIgnoreCase("ignoreOperators")) {
                        n10 = -999;
                    } else {
                        if (string8.indexOf(",") >= 0 && ((Point3f)object).x < 9.0f && ((Point3f)object).y < 9.0f && ((Point3f)object).z == 0.0f) {
                            string8 = string8 + "#doNormalize=0";
                        }
                        n10 = -2;
                        hashtable.put("spaceGroupName", string8);
                    }
                }
                if (fArray != null && n10 == Integer.MIN_VALUE) {
                    n10 = -1;
                }
                if (n10 != Integer.MIN_VALUE) {
                    hashtable.put("spaceGroupIndex", new Integer(n10));
                }
            }
            if (this.tokAt(n4) == 0x40000040) {
                String string9 = this.stringParameter(++n4);
                hashtable.put("filter", string9);
                string5 = string5 + " FILTER " + Escape.escape(string9);
            }
        } else {
            if (n4 != 2) {
                string2 = this.parameterAsString(n4++);
                stringBuffer.append(" ").append(Escape.escape(string2));
            }
            object = null;
            BitSet bitSet = null;
            Vector<String> vector2 = new Vector<String>();
            block8: while (n4 < this.statementLength) {
                switch (this.tokAt(n4)) {
                    case 0x40000040: {
                        String string10 = this.stringParameter(++n4);
                        hashtable.put("filter", string10);
                        stringBuffer.append(" FILTER ").append(Escape.escape(string10));
                        ++n4;
                        continue block8;
                    }
                    case 0x100006: {
                        hashtable.remove("isTrajectory");
                        if (vector == null) {
                            vector = new Vector<Object>();
                            object = new Point3f(0.0f, -1.0f, 1.0f);
                        }
                        if (this.isPoint3f(++n4)) {
                            object = this.getPoint3f(n4, false);
                            n4 = this.iToken + 1;
                            break;
                        }
                        if (this.tokAt(n4) != 9) break;
                        bitSet = (BitSet)this.getToken((int)n4).value;
                        object = null;
                        n4 = this.iToken + 1;
                        break;
                    }
                    case 0x40000000: {
                        this.error(22);
                    }
                }
                string3 = this.parameterAsString(n4++);
                vector2.add(string3);
                if (object != null) {
                    vector.addElement(new int[]{(int)((Point3f)object).x, (int)((Point3f)object).y, (int)((Point3f)object).z});
                    stringBuffer.append(" COORD " + Escape.escape((Tuple3f)object));
                } else if (bitSet != null) {
                    vector.addElement(bitSet);
                    stringBuffer.append(" COORD " + Escape.escape(bitSet));
                }
                stringBuffer.append(" /*file*/").append(Escape.escape(string3));
            }
            if (vector != null) {
                hashtable.put("firstLastSteps", vector);
            }
            n3 = vector2.size();
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = (String)vector2.get(i);
            }
            string3 = string2;
        }
        if (!bl3) {
            return;
        }
        if (stringArray == null && string3.startsWith("@") && string3.length() > 1) {
            hashtable.put("fileData", this.getStringParameter(string3.substring(1), false));
            string3 = "string";
        }
        object = null;
        if (string7 != null) {
            object = this.viewer.getOutputStream(string7);
            if (object == null) {
                Logger.error("Could not create output stream for " + string7);
            } else {
                hashtable.put("OutputStream", object);
            }
        }
        string4 = this.viewer.loadModelFromFile(string3, stringArray, bl, hashtable, n5);
        if (object != null) {
            try {
                Logger.info(GT._("file {0} created", string7));
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                Logger.error("error closing file " + iOException.getMessage());
            }
        }
        if (n5 > 0) {
            this.viewer.setFileInfo(stringArray2);
            if (string4 != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(string4, null);
            }
            return;
        }
        if (stringArray == null) {
            stringBuffer.append(" ");
            if (!string3.equals("string") && !string3.equals("string[]")) {
                stringBuffer.append("/*file*/");
            }
            if (string7 != null) {
                string7 = this.viewer.getFullPath(string7);
            }
            stringBuffer.append(Escape.escape(string7 != null ? string7 : (string2 = (String)hashtable.get("fullPathName"))));
            stringBuffer.append(string5);
        }
        this.viewer.addLoadScript(stringBuffer.toString());
        if (string4 != null && !this.isCmdLine_c_or_C_Option) {
            if (string4.indexOf("NOTE: file recognized as a script file:") == 0) {
                this.viewer.addLoadScript("-");
                string4 = TextFormat.trim(string4, "\n");
                this.runScript("script \"" + string4.substring(40) + "\"");
                return;
            }
            this.evalError(string4, null);
        }
        if (bl && (bl2 || n3 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n2);
        }
        if (this.logMessages) {
            this.scriptStatusOrBuffer("Successfully loaded:" + string2);
        }
        String string11 = this.viewer.getDefaultLoadScript();
        String string12 = "";
        if (string11.length() > 0) {
            string12 = string12 + "\nUsing defaultLoadScript: " + string11;
        }
        if ((string = (String)this.viewer.getModelSetAuxiliaryInfo("jmolscript")) != null && this.viewer.getAllowEmbeddedScripts()) {
            string12 = string12 + "\nAdding embedded #jmolscript: " + string;
            string11 = string11 + ";" + string;
            string11 = "allowEmbeddedScripts = false;" + string11 + ";allowEmbeddedScripts = true;";
        }
        if (string12.length() > 0) {
            Logger.info(string12);
        }
        if (string11.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(string11);
        }
    }

    private String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.isSyntaxCheck || this.isCmdLine_C_Option ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.error(22);
        }
        return string;
    }

    private void dataFrame(int n) throws ScriptException {
        String string;
        boolean bl = false;
        boolean bl2 = this.tokAt(0) == 135184;
        int n2 = bl2 ? 1 : 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.statementLength - 1;
        String string2 = this.optParameterAsString(n3).toLowerCase();
        switch (n) {
            case 0: {
                if (string2.equalsIgnoreCase("draw")) {
                    bl2 = true;
                    string2 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl5 = n3 > n2 && string2.startsWith("r");
                string2 = "ramachandran" + (bl5 ? " r" : "") + (bl2 ? " draw" : "");
                break;
            }
            case 1: {
                bl = true;
                if (string2.equalsIgnoreCase("draw")) {
                    bl2 = true;
                    string2 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl3 = string2.startsWith("deriv") || string2.startsWith("diff");
                boolean bl6 = bl4 = bl3 && string2.indexOf("2") > 0;
                if (bl3) {
                    --n3;
                }
                if (string2.equalsIgnoreCase("helix") || string2.equalsIgnoreCase("axis")) {
                    bl2 = true;
                    bl3 = true;
                    n3 = -1;
                }
                if ((string2 = ((n3 <= n2 ? "" : this.optParameterAsString(n3)) + "w").substring(0, 1)).equals("a") || string2.equals("r")) {
                    bl3 = true;
                }
                if (!Parser.isOneOf(string2, "w;x;y;z;r;a")) {
                    this.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                string2 = "quaternion " + string2 + (bl3 ? " difference" : "") + (bl4 ? "2" : "") + (bl2 ? " draw" : "");
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        int n4 = this.viewer.getCurrentModelIndex();
        if (n4 < 0) {
            this.error(30, string2);
        }
        n4 = this.viewer.getJmolDataSourceFrame(n4);
        if (bl2) {
            this.runScript(this.viewer.getPdbData(n4, string2));
            return;
        }
        int n5 = this.viewer.getJmolDataFrameIndex(n4, string2);
        if (n5 > 0) {
            this.viewer.setCurrentModelIndex(n5, true);
            return;
        }
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl7 = this.viewer.getAppendNew();
        this.viewer.setAppendNew(true);
        String string3 = this.viewer.getPdbData(n4, string2);
        boolean bl8 = string3 != null && this.viewer.loadInline(string3, true) == null;
        this.viewer.setAppendNew(bl7);
        this.viewer.setFileInfo(stringArray);
        if (!bl8) {
            return;
        }
        ModelCollection.StateScript stateScript = this.viewer.addStateScript(string2, true, false);
        int n6 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string2, n4, n6 - 1);
        switch (n) {
            default: {
                this.viewer.setFrameTitle(n6 - 1, string2 + " plot for model " + this.viewer.getModelNumberDotted(n4));
                string = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + n6 + " {200 0 0} {-200 0 0} \"phi\";" + "draw ramaAxisY" + n6 + " {0 200 0} {0 -200 0} \"psi\";";
                break;
            }
            case 1: {
                this.viewer.setFrameTitle(n6 - 1, string2 + " for model " + this.viewer.getModelNumberDotted(n4));
                String string4 = Graphics3D.getHexCode(this.viewer.getColixBackgroundContrast());
                string = "frame 0.0; frame last; reset;select visible; wireframe 0; isosurface quatSphere" + n6 + " resolution 1.0 color " + string4 + " sphere 10.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + n6 + "X {10 0 0} {-10 0 0} color red \"x\";" + "draw quatAxis" + n6 + "Y {0 10 0} {0 -10 0} color green \"y\";" + "draw quatAxis" + n6 + "Z {0 0 10} {0 0 -10} color blue \"z\";" + "color structure;" + "draw quatCenter" + n6 + "{0 0 0} scale 0.02";
            }
        }
        this.runScript(string);
        stateScript.setModelIndex(this.viewer.getCurrentModelIndex());
        this.viewer.setRotationRadius(bl ? 12.5f : 260.0f, true);
        this.viewer.loadShape(28);
        this.showString("frame " + this.viewer.getModelNumberDotted(n6 - 1) + " created: " + string2);
    }

    private void measure() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.hideMeasurements(false);
            return;
        }
        switch (this.statementLength) {
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(false);
                        }
                        return;
                    }
                    case 0x10000C: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(true);
                        }
                        return;
                    }
                    case 12291: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.setMeasurementFormats(this.stringParameter(1));
                        }
                        return;
                    }
                }
                this.error(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                if (this.getToken((int)1).tok != 12291) break;
                if (this.getToken((int)2).tok == 0x100003) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.clearAllMeasurements();
                    }
                } else {
                    int n = this.intParameter(2) - 1;
                    if (!this.isSyntaxCheck) {
                        this.viewer.deleteMeasurement(n);
                    }
                }
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray = new int[5];
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        int n6 = 269484114;
        String string = null;
        Vector<Point3f> vector = new Vector<Point3f>();
        BitSet bitSet = new BitSet();
        Serializable serializable = null;
        TickInfo tickInfo = null;
        block30: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000000: {
                    this.error(24, "ALL, ALLCONNECTED, DELETE");
                }
                default: {
                    this.error(15);
                }
                case 0x10100070: {
                    if (this.tokAt(i + 1) != 135266318) {
                        this.error(22);
                    }
                    ++i;
                    bl3 = true;
                    continue block30;
                }
                case 0x100003: 
                case 135266318: 
                case 0x40000005: {
                    bl2 = this.theTok == 0x40000005;
                    n4 = -1;
                    bl = true;
                    if (!bl2 || !bl3) continue block30;
                    this.error(22);
                    continue block30;
                }
                case 3: {
                    bl = true;
                    bl4 = true;
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = this.floatParameter(i);
                    continue block30;
                }
                case 12291: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 12291;
                    continue block30;
                }
                case 2: {
                    int n7 = this.intParameter(i);
                    if (bl) {
                        bl4 = true;
                        n5 = (n5 + 1) % 2;
                        fArray[n5] = n7;
                        continue block30;
                    }
                    n4 = this.viewer.getAtomIndexFromAtomNumber(n7);
                    if (!this.isSyntaxCheck && n4 < 0) {
                        return;
                    }
                    if (serializable != null) {
                        this.error(22);
                    }
                    if ((nArray[0] = ++n) > 4) {
                        this.error(2);
                    }
                    nArray[n] = n4;
                    continue block30;
                }
                case 1095761933: {
                    n3 = this.intParameter(++i);
                    continue block30;
                }
                case 0x10000C: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000C;
                    continue block30;
                }
                case 0x10000D: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000D;
                    continue block30;
                }
                case 1073741982: {
                    bl = true;
                    bl4 = true;
                    n4 = -1;
                    continue block30;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block30;
                }
                case 1073742009: {
                    tickInfo = this.checkTicks(i);
                    i = this.iToken;
                    n6 = 1060866;
                    continue block30;
                }
                case 7: 
                case 9: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (n4 >= 0) {
                        this.error(22);
                    }
                    this.expressionResult = Boolean.FALSE;
                    serializable = this.centerParameter(i);
                    if (this.expressionResult instanceof BitSet) {
                        bitSet = (BitSet)this.expressionResult;
                        serializable = bitSet;
                        if (!this.isSyntaxCheck && bitSet.length() == 0) {
                            return;
                        }
                    }
                    if (serializable instanceof Point3f) {
                        Point3fi point3fi = new Point3fi();
                        point3fi.set((Tuple3f)serializable);
                        point3fi.modelIndex = (short)n3;
                        serializable = point3fi;
                    }
                    if ((n = ++n2) > 4) {
                        this.error(2);
                    }
                    vector.addElement((Point3f)serializable);
                    i = this.iToken;
                }
            }
        }
        if (n < 2 && (tickInfo == null || n == 1)) {
            this.error(2);
        }
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl4 && fArray[1] < fArray[0]) {
            fArray[1] = fArray[0];
            float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (serializable != null || tickInfo != null) {
            if (serializable == null) {
                tickInfo.id = "default";
            }
            this.setShapeProperty(6, "measure", new MeasurementData(vector, n6, fArray, string, null, tickInfo, bl2, bl3, bl));
            return;
        }
        switch (n6) {
            case 12291: {
                this.viewer.deleteMeasurement(nArray);
                break;
            }
            case 0x10000D: {
                this.viewer.showMeasurement(nArray, true);
                break;
            }
            case 0x10000C: {
                this.viewer.showMeasurement(nArray, false);
                break;
            }
            default: {
                this.viewer.toggleMeasurement(nArray, string);
            }
        }
    }

    private void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        this.checkLength(-2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset();
            return;
        }
        switch (this.tokAt(1)) {
            case 135368708: {
                this.viewer.clearFunctions();
                return;
            }
            case 1112541205: {
                this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1076887563: {
                this.viewer.resetAromatic();
                return;
            }
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.error(22);
        }
        this.viewer.unsetProperty(string);
    }

    private void restrict() throws ScriptException {
        boolean bl = this.tokAt(1) == 1678770178;
        this.select(bl ? 2 : 1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.restrictSelected(bl, true);
    }

    private void restrictSelected(boolean bl, boolean bl2) {
        BitSet bitSet = BitSetUtil.copy(this.viewer.getSelectionSet());
        if (bl2) {
            this.viewer.invertSelection();
        }
        BitSet bitSet2 = this.viewer.getSelectionSubset();
        if (bl2 && bitSet2 != null) {
            bitSet = BitSetUtil.copy(this.viewer.getSelectionSet());
            bitSet.and(bitSet2);
            this.viewer.setSelectionSet(bitSet);
            BitSetUtil.invertInPlace(bitSet, this.viewer.getAtomCount());
            bitSet.and(bitSet2);
        }
        BitSetUtil.andNot(bitSet, this.viewer.getDeletedAtoms());
        boolean bl3 = this.viewer.getBondSelectionModeOr();
        if (!bl) {
            this.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSize(1, 0);
        this.setShapeProperty(1, "type", new Integer(32768));
        this.setShapeSize(1, 0);
        this.setShapeProperty(1, "type", new Integer(1023));
        int n = 21;
        while (--n >= 0) {
            if (n == 6) continue;
            this.setShapeSize(n, 0);
        }
        this.setShapeProperty(21, "delete", null);
        this.viewer.setLabel(null);
        if (!bl) {
            this.setBooleanProperty("bondModeOr", bl3);
        }
        this.viewer.setSelectionSet(bitSet);
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000D: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x10000C: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BitSet bitSet = null;
        float f = Float.MIN_VALUE;
        int n = 0;
        float f2 = Float.MAX_VALUE;
        boolean bl3 = false;
        Point3f[] point3fArray = new Point3f[2];
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        int n2 = 1;
        boolean bl4 = this.viewer.getAxesOrientationRasmol();
        block19: for (int i = 1; i < this.statementLength; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 1611141175: {
                    bl = true;
                    continue block19;
                }
                case 0x10100090: {
                    n2 = -1;
                    continue block19;
                }
                case 135270411: {
                    ++i;
                }
                case 8: {
                    Quaternion quaternion = new Quaternion(this.getPoint4f(i));
                    vector3f.set(quaternion.getNormal());
                    f = quaternion.getTheta();
                    break;
                }
                case 135266316: {
                    if (this.isPoint3f(++i)) {
                        vector3f.set(this.centerParameter(i));
                        break;
                    }
                    Point4f point4f = this.getPoint4f(i);
                    vector3f.set(point4f.x, point4f.y, point4f.z);
                    f = point4f.w;
                    break;
                }
                case 1073741914: 
                case 1073741937: {
                    bl3 = true;
                    continue block19;
                }
                case 1112541210: {
                    vector3f.set(n2, 0.0f, 0.0f);
                    continue block19;
                }
                case 1112541211: {
                    vector3f.set(0.0f, bl4 && !bl3 ? -n2 : n2, 0.0f);
                    continue block19;
                }
                case 1112541212: {
                    vector3f.set(0.0f, 0.0f, n2);
                    continue block19;
                }
                case 0x100004: {
                    int n4 = this.expression(++i).nextSetBit(0);
                    int n5 = this.expression(++this.iToken).nextSetBit(0);
                    if (n4 < 0 || n5 < 0) {
                        return;
                    }
                    bitSet = this.viewer.getBranchBitSet(n5, n4);
                    bl3 = true;
                    point3fArray[0] = this.viewer.getAtomPoint3f(n4);
                    point3fArray[1] = this.viewer.getAtomPoint3f(n5);
                    n = 2;
                    i = this.iToken;
                    break;
                }
                case 7: 
                case 9: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (n == 2) {
                        this.error(43);
                    }
                    Point3f point3f = this.centerParameter(i, this.viewer.getCurrentModelIndex());
                    if (!this.isSyntaxCheck && n3 == 0x100007 && this.tokAt(i + 2) != 0x10100040) {
                        bl3 = true;
                        vector3f = this.getDrawObjectAxis(this.objectNameParameter(++i), this.viewer.getCurrentModelIndex());
                    }
                    point3fArray[n++] = point3f;
                    break;
                }
                case 0x10100030: {
                    continue block19;
                }
                case 2: 
                case 3: {
                    if (f == Float.MIN_VALUE) {
                        f = this.floatParameter(i);
                        continue block19;
                    }
                    f2 = f;
                    if (f2 * (f = this.floatParameter(i)) < 0.0f) {
                        f = -f2 / f;
                    }
                    bl = true;
                    continue block19;
                }
                default: {
                    this.error(22);
                }
            }
            i = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == Float.MIN_VALUE) {
            f = 10.0f;
        }
        if (bl2 && bitSet == null) {
            bitSet = this.viewer.getSelectionSet();
        }
        if (n < 2) {
            if (!bl3) {
                this.viewer.rotateAxisAngleAtCenter(point3fArray[0], vector3f, f, f2, bl, bitSet);
                return;
            }
            if (n == 0) {
                point3fArray[0] = new Point3f();
            }
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].add(vector3f);
        }
        if (point3fArray[0].distance(point3fArray[1]) == 0.0f) {
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].y = (float)((double)point3fArray[1].y + 1.0);
        }
        this.viewer.rotateAboutPointsInternal(point3fArray[0], point3fArray[1], f, f2, bl, bitSet);
    }

    private Point3f getObjectCenter(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        return this.viewer.getShapeProperty(22, "getCenter", objectArray) || this.viewer.getShapeProperty(23, "getCenter", objectArray) ? (Point3f)objectArray[2] : null;
    }

    private Point3f[] getObjectBoundingBox(String string) {
        Object[] objectArray = new Object[]{string, null, null};
        return this.viewer.getShapeProperty(23, "getBoundingBox", objectArray) ? (Point3f[])objectArray[2] : null;
    }

    private Vector3f getDrawObjectAxis(String string, int n) {
        Object[] objectArray = new Object[]{string, new Integer(n), null};
        return this.viewer.getShapeProperty(22, "getSpinAxis", objectArray) ? (Vector3f)objectArray[2] : null;
    }

    private void script(int n) throws ScriptException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        String string = this.parameterAsString(1);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (n == 135287298) {
            this.checkLength(2);
            if (!this.isSyntaxCheck) {
                this.viewer.jsEval(string);
            }
            return;
        }
        n = this.tokAt(1);
        if (n != 4) {
            this.error(16);
        }
        if ((string2 = this.parameterAsString(1)).equalsIgnoreCase("applet")) {
            String string6 = this.parameterAsString(2);
            string = this.parameterExpression(3, 0, "_script", false).toString();
            this.checkLast(this.iToken);
            if (this.isSyntaxCheck) {
                return;
            }
            if (string6.length() == 0 || string6.equals("all")) {
                string6 = "*";
            }
            if (!string6.equals(".")) {
                this.viewer.jsEval(string6 + "\u0001" + string);
                if (!string6.equals("*")) {
                    return;
                }
            }
        } else {
            string = null;
            n = this.tokAt(this.statementLength - 1);
            boolean bl4 = bl3 = n == 266298;
            if (string2.equalsIgnoreCase("inline")) {
                string = this.parameterExpression(2, bl3 ? this.statementLength - 1 : 0, "_script", false).toString();
                n6 = this.iToken + 1;
            }
            while (string2.equalsIgnoreCase("localPath") || string2.equalsIgnoreCase("remotePath") || string2.equalsIgnoreCase("scriptPath")) {
                if (string2.equalsIgnoreCase("localPath")) {
                    string3 = this.parameterAsString(n6++);
                } else if (string2.equalsIgnoreCase("scriptPath")) {
                    string5 = this.parameterAsString(n6++);
                } else {
                    string4 = this.parameterAsString(n6++);
                }
                string2 = this.parameterAsString(n6++);
            }
            n = this.tokAt(n6);
            if (n == 1073741850) {
                bl2 = true;
                n = this.tokAt(++n6);
            }
            if (n == 1073741947) {
                bl = false;
                n = this.tokAt(++n6);
            }
            if (n == 0x40000060 || n == 0x44100004) {
                int n7 = ++n6;
                n4 = n2 = Math.max(this.intParameter(n7), 0);
                if (this.checkToken(++n6) && (n4 = this.getToken((int)n6).tok == 0x10100090 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                    this.error(22);
                }
            } else if (n == 1073741857 || n == 0x40000022) {
                int n8 = ++n6;
                n3 = Math.max(this.intParameter(n8) - 1, 0);
                n5 = n3 + 1;
                if (this.checkToken(++n6) && (n5 = this.getToken((int)n6).tok == 0x10100090 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                    this.error(22);
                }
            }
            this.checkLength(bl3 ? n6 + 1 : n6);
        }
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            bl2 = true;
        }
        boolean bl5 = this.isSyntaxCheck;
        boolean bl6 = this.isCmdLine_c_or_C_Option;
        if (bl2) {
            this.isCmdLine_c_or_C_Option = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> " + string2;
        if (string == null ? this.compileScriptFileInternal(string2, string3, string4, string5) : this.compileScript(null, string, false)) {
            this.pcEnd = n5;
            this.lineEnd = n4;
            while (n3 < this.lineNumbers.length && this.lineNumbers[n3] < n2) {
                ++n3;
            }
            this.pc = n3;
            boolean bl7 = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= bl;
            this.executionStepping |= bl3;
            this.instructionDispatchLoop(bl2);
            if (this.debugScript && this.viewer.getMessageStyleChime()) {
                this.viewer.scriptStatus("script <exiting>");
            }
            this.isCmdLine_C_Option = bl7;
            this.popContext();
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext();
            if (bl6) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.isSyntaxCheck = bl5;
        this.isCmdLine_c_or_C_Option = bl6;
    }

    private void function() throws ScriptException {
        Vector vector;
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (!this.viewer.isFunction(string)) {
            this.error(10);
        }
        Vector vector2 = vector = this.statementLength == 1 || this.statementLength == 3 && this.tokAt(1) == 0x10100010 && this.tokAt(2) == 0x10100011 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> function " + string;
        this.loadFunction(string, vector);
        this.instructionDispatchLoop(false);
        this.popContext();
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String string = "";
        String string2 = "";
        switch (this.statementLength) {
            case 1: {
                string2 = "*";
                string = "ON";
                break;
            }
            case 2: {
                string2 = this.parameterAsString(1);
                if (string2.indexOf("jmolApplet") == 0 || Parser.isOneOf(string2, "*;.;^")) {
                    string = "ON";
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(string, string2);
                    }
                    string2 = ".";
                    break;
                }
                string = string2;
                string2 = "*";
                break;
            }
            case 3: {
                string2 = this.parameterAsString(1);
                String string3 = string = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.parameterAsString(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.syncScript(string, string2);
    }

    private void history(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            int n2 = this.intParameter(this.checkLast(2));
            if (n2 < 0) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 0x10000D: 
            case 1073741852: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.error(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        BitSet bitSet;
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl) {
            this.viewer.display(bitSet, this.tQuiet);
        } else {
            this.viewer.hide(bitSet, this.tQuiet);
        }
    }

    private void delete() throws ScriptException {
        if (this.statementLength == 1) {
            this.zap(true);
            return;
        }
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BitSet bitSet = this.expression(this.statement, 1, 0, true, false, true, false);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
    }

    private void minimize() throws ScriptException {
        BitSet bitSet = null;
        int n = Integer.MAX_VALUE;
        float f = 0.0f;
        boolean bl = false;
        MinimizerInterface minimizerInterface = this.viewer.getMinimizer(false);
        block11: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1073741852: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty("clear", null);
                    return;
                }
                case 1073741859: {
                    if (i != 1) {
                        this.error(22);
                    }
                    int n2 = 0;
                    float f2 = 0.0f;
                    int[] nArray = new int[5];
                    if (this.tokAt(++i) == 1073741852) {
                        this.checkLength(2);
                    } else {
                        while (n2 < 4 && !this.isFloatParameter(i)) {
                            nArray[++n2] = this.expression(i).nextSetBit(0);
                            i = this.iToken + 1;
                        }
                        nArray[0] = n2;
                        f2 = this.floatParameter(this.checkLast(i));
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("constraint", new Object[]{nArray, new int[n2], new Float(f2)});
                    }
                    return;
                }
                case 1073742008: 
                case 0x400000D0: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty(this.parameterAsString(i), null);
                    return;
                }
                case 0x40000042: 
                case 1073742034: {
                    BitSet bitSet2;
                    if (i != 1) {
                        this.error(22);
                    }
                    if ((bitSet2 = this.expression(++i)).nextSetBit(0) < 0) {
                        bitSet2 = null;
                    }
                    this.checkLength(this.iToken + 1, 1);
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("fixed", bitSet2);
                    }
                    return;
                }
                case 0x400000D4: {
                    n = 0;
                    continue block11;
                }
                case 0x40000002: {
                    bl = true;
                    continue block11;
                }
                case 266298: 
                case 1073742007: {
                    n = this.intParameter(++i);
                    continue block11;
                }
                case 1073742038: {
                    f = this.floatParameter(++i);
                    continue block11;
                }
                case 135280129: {
                    bitSet = this.expression(++i);
                    i = this.iToken;
                    continue block11;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.minimize(n, f, bitSet, bl);
        }
    }

    private void select(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.select(null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.statementLength == 2 && this.tokAt(1) == 1073741958) {
            return;
        }
        this.viewer.setNoneSelected(this.statementLength == 4 && this.tokAt(2) == 0x10000B);
        if (this.tokAt(2) == 9 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 1678770178 && this.getToken((int)3).tok == 9) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        if (this.getToken((int)2).tok == 1746538503) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 9) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(6, "select", this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        BitSet bitSet = null;
        if (this.getToken((int)1).intValue == 0) {
            Object object = this.tokenSetting((int)0).value;
            if (!(object instanceof BitSet)) {
                this.error(22);
            }
            this.checkLast(this.iToken);
            bitSet = (BitSet)object;
        } else {
            bitSet = this.expression(n);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds(bitSet);
        } else {
            this.viewer.select(bitSet, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.expression(-1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setSelectionSubset(bitSet);
    }

    private void invertSelected() throws ScriptException {
        Point3f point3f = null;
        Point4f point4f = null;
        if (this.statementLength == 1) {
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bitSet = this.viewer.getSelectionSet();
            point3f = this.viewer.getAtomSetCenter(bitSet);
            this.viewer.invertSelected(point3f, bitSet);
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("point")) {
            point3f = this.centerParameter(2);
        } else if (string.equalsIgnoreCase("plane")) {
            point4f = this.planeParameter(2);
        } else if (string.equalsIgnoreCase("hkl")) {
            point4f = this.hklParameter(2);
        }
        this.checkLength(this.iToken + 1, 1);
        if (point4f == null && point3f == null) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.invertSelected(point3f, point4f);
    }

    private void translate(boolean bl) throws ScriptException {
        char c;
        BitSet bitSet = null;
        if (this.isPoint3f(1)) {
            Point3f point3f = this.getPoint3f(1, true);
            bitSet = !bl && this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.isSyntaxCheck) {
                this.viewer.setAtomCoordRelative(point3f, bitSet);
            }
            return;
        }
        float f = this.floatParameter(2);
        if (f == 0.0f) {
            return;
        }
        switch (this.tokAt(3)) {
            case 0: 
            case 9: 
            case 0x100001: {
                c = '\u0000';
                break;
            }
            default: {
                c = (this.optParameterAsString(3).toLowerCase() + '\u0000').charAt(0);
            }
        }
        int n = this.iToken = c == '\u0000' ? 2 : 3;
        bitSet = bl ? this.viewer.getSelectionSet() : (this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (this.getToken((int)1).tok == 1112541210 || this.theTok == 1112541211 || this.theTok == 1112541212) {
            if (this.isSyntaxCheck) {
                return;
            }
            this.viewer.translate(this.parameterAsString(1).charAt(0), f, c, bitSet);
            return;
        }
        this.error(0);
    }

    private void zap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.statementLength == 1 || !bl) {
            this.viewer.zap(true, bl && !this.isStateScript);
            this.refresh();
            return;
        }
        BitSet bitSet = this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, true);
        boolean bl3 = bl2 = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!bl2) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
        this.viewer.select(null, bl2);
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.statementLength > 1 ? this.getToken((int)1).tok : 0x10000D;
            switch (n) {
                case 1073742040: 
                case 1073742042: {
                    break;
                }
                case 0x10000C: 
                case 0x10000D: {
                    if (this.statementLength > 2) {
                        this.error(2);
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", n == 0x10000D);
                    }
                    return;
                }
            }
        }
        Point3f point3f = null;
        Point3f point3f2 = this.viewer.getRotationCenter();
        int n = 1;
        float f2 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            --n;
            f = 0.0f;
        }
        int n2 = 0;
        BitSet bitSet = null;
        if (this.isCenterParameter(n)) {
            n2 = n;
            point3f = this.centerParameter(n);
            if (this.expressionResult instanceof BitSet) {
                bitSet = (BitSet)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        boolean bl2 = false;
        float f3 = this.viewer.getZoomSetting();
        float f4 = this.getZoom(n, bitSet, f3);
        n = this.iToken + 1;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (n != this.statementLength) {
            f5 = this.floatParameter(n++);
            f6 = this.floatParameter(n++);
        }
        if (n != this.statementLength) {
            this.error(22);
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            if (bl) {
                if (this.statementLength == 1 || bl2) {
                    f4 *= 2.0f;
                } else if (point3f == null) {
                    f4 /= 2.0f;
                }
            }
        }
        float f7 = this.viewer.getMaxZoomPercent();
        if (f4 < 5.0f || f4 > f7) {
            this.numberOutOfRange(5.0f, f7);
        }
        if (!this.viewer.isWindowCentered()) {
            if (point3f != null) {
                BitSet bitSet2 = this.expression(n2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bitSet2, false);
                }
            }
            point3f = this.viewer.getRotationCenter();
            if (Float.isNaN(f5)) {
                f5 = this.viewer.getTranslationXPercent();
            }
            if (Float.isNaN(f6)) {
                f6 = this.viewer.getTranslationYPercent();
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (Float.isNaN(f5)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (bl2 && Math.abs(f3 - f4) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(f, point3f, JmolConstants.center, Float.NaN, null, f4, f5, f6, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN);
    }

    private float getZoom(int n, BitSet bitSet, float f) throws ScriptException {
        float f2;
        float f3 = f2 = this.isFloatParameter(n) ? this.floatParameter(n++) : Float.NaN;
        if (f2 == 0.0f || f == 0.0f) {
            if (bitSet == null) {
                this.error(22);
            }
            float f4 = this.viewer.calcRotationRadius(bitSet);
            f = this.viewer.getRotationRadius() / f4 * 100.0f;
            f2 = Float.NaN;
        }
        if (f2 < 0.0f) {
            f2 += f;
        } else if (Float.isNaN(f2)) {
            int n2 = this.tokAt(n);
            switch (n2) {
                case 1073742040: 
                case 1073742042: {
                    f2 = f * (n2 == 1073742042 ? 0.5f : 2.0f);
                    ++n;
                    break;
                }
                case 0x10100091: 
                case 0x101000A0: 
                case 0x101000A1: {
                    float f5 = this.floatParameter(++n);
                    ++n;
                    switch (n2) {
                        case 0x101000A0: {
                            f2 = f / f5;
                            break;
                        }
                        case 0x101000A1: {
                            f2 = f * f5;
                            break;
                        }
                        case 0x10100091: {
                            f2 = f + f5;
                        }
                    }
                    break;
                }
                default: {
                    f2 = bitSet == null ? -f : f;
                }
            }
        }
        this.iToken = n - 1;
        return f2;
    }

    private void delay() throws ScriptException {
        long l = 0L;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                l = 1L;
                break;
            }
            case 2: {
                l = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                l = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(l);
        }
    }

    private void delay(long l) {
        long l2 = System.currentTimeMillis();
        this.refresh();
        if (l < 0L) {
            l = -l;
        } else {
            int n = this.viewer.getDelayMaximum();
            if (n > 0 && l > (long)n) {
                l = n;
            }
        }
        int n = (int)(l -= System.currentTimeMillis() - l2) / 1000;
        if ((l -= (long)(n * 1000)) <= 0L) {
            l = 1L;
        }
        while (n >= 0 && l > 0L && !this.interruptExecution && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint("delay");
            try {
                Thread.sleep(n-- > 0 ? 1000L : l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint("delay");
        }
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        Point4f point4f = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 8) {
            point4f = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int n = this.intParameter(this.checkLast(1));
                    if (!this.isSyntaxCheck) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 0x10000D: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4140: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 1085443: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x10100090: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        point4f = this.planeParameter(3);
                    }
                    if (point4f == null) {
                        this.error(22);
                    }
                    point4f.scale(-1.0f);
                    break;
                }
                case 135266313: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000B: {
                            break block0;
                        }
                    }
                    point4f = this.planeParameter(2);
                    break;
                }
                case 135267842: {
                    point4f = this.getToken((int)2).tok == 0x10000B ? null : this.hklParameter(2);
                    break;
                }
                case 0x400000A0: {
                    return;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.slabInternal(point4f, bl);
        }
    }

    private void ellipsoid() throws ScriptException {
        int n = 0;
        int n2 = 1;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = 50;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            case 0x101000A1: 
            case 0x40000000: 
            case 1074790483: {
                this.viewer.loadShape(20);
                if (this.theTok == 1074790483) {
                    ++n2;
                }
                this.setShapeId(20, n2, false);
                n2 = this.iToken;
                block16: while (++n2 < this.statementLength) {
                    String string = this.parameterAsString(n2);
                    Object object = null;
                    switch (this.tokAt(n2)) {
                        case 1611272194: {
                            Vector3f[] vector3fArray = new Vector3f[3];
                            for (int i = 0; i < 3; ++i) {
                                vector3fArray[i] = new Vector3f();
                                vector3fArray[i].set(this.centerParameter(++n2));
                                n2 = this.iToken;
                            }
                            object = vector3fArray;
                            break;
                        }
                        case 12289: {
                            object = this.centerParameter(++n2);
                            n2 = this.iToken;
                            break;
                        }
                        case 1632638983: {
                            float f = Float.NaN;
                            this.theTok = this.tokAt(++n2);
                            if (this.theTok == 0x400000C4) {
                                object = "translucent";
                                f = this.isFloatParameter(++n2) ? this.getTranslucentLevel(n2++) : this.viewer.getDefaultTranslucent();
                            } else if (this.theTok == 1073741959) {
                                object = "opaque";
                                ++n2;
                            }
                            if (this.isColorParam(n2)) {
                                this.setShapeProperty(20, "color", new Integer(this.getArgbParam(n2)));
                                n2 = this.iToken;
                            }
                            if (object == null) continue block16;
                            if (!Float.isNaN(f)) {
                                this.setShapeProperty(20, "translucentLevel", new Float(f));
                            }
                            string = "translucency";
                            break;
                        }
                        case 12291: {
                            object = Boolean.TRUE;
                            this.checkLength(3);
                            break;
                        }
                        case 1095761933: {
                            object = new Integer(this.intParameter(++n2));
                            break;
                        }
                        case 0x10000D: {
                            object = Boolean.TRUE;
                            break;
                        }
                        case 0x10000C: {
                            string = "on";
                            object = Boolean.FALSE;
                            break;
                        }
                        case 1073741995: {
                            object = new Float(this.floatParameter(++n2));
                        }
                    }
                    if (object == null) {
                        this.error(22);
                    }
                    this.setShapeProperty(20, string.toLowerCase(), object);
                }
                this.setShapeProperty(20, "thisID", null);
                return;
            }
            default: {
                this.error(22);
            }
        }
        this.setShapeSize(20, n);
    }

    private String getShapeNameParameter(int n) throws ScriptException {
        String string = this.parameterAsString(n);
        boolean bl = string.equals("*");
        if (string.length() == 0) {
            this.error(22);
        }
        if (bl) {
            switch (this.tokAt(n + 1)) {
                case 0: 
                case 12291: 
                case 0x10000C: 
                case 0x10000D: 
                case 3145751: 
                case 3145752: 
                case 1632638983: {
                    break;
                }
                default: {
                    string = string + this.optParameterAsString(++n);
                }
            }
        }
        if (this.tokAt(n + 1) == 0x101000A1) {
            string = string + this.parameterAsString(++n);
        }
        this.iToken = n;
        return string;
    }

    private String setShapeId(int n, int n2, boolean bl) throws ScriptException {
        if (bl) {
            this.error(22);
        }
        String string = this.getShapeNameParameter(n2).toLowerCase();
        this.setShapeProperty(n, "thisID", string);
        return string;
    }

    private void setAtomShapeSize(int n, float f) throws ScriptException {
        RadiusData radiusData = null;
        int n2 = this.tokAt(1);
        switch (n2) {
            case 1073741958: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            default: {
                radiusData = this.encodeRadiusParameter(1);
                if (!Float.isNaN(radiusData.value)) break;
                this.error(22);
            }
        }
        if (radiusData == null) {
            radiusData = new RadiusData(f, 2, 8);
        }
        this.setShapeSize(n, radiusData);
    }

    private RadiusData encodeRadiusParameter(int n) throws ScriptException {
        float f = Float.NaN;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getToken((int)n).tok;
        switch (n4) {
            case 1112539137: 
            case 1112539138: 
            case 1112541193: 
            case 1112541201: 
            case 1112541205: {
                f = 1.0f;
                n2 = 2;
                n3 = n4 == 1112541205 ? 0 : n4;
                n4 = this.tokAt(++n);
            }
        }
        switch (n4) {
            case 0x4000000E: 
            case 0x40000010: 
            case 0x40000011: 
            case 1073741917: 
            case 1073741983: {
                f = 1.0f;
                n2 = 2;
                --n;
                break;
            }
            case 3: 
            case 0x10100091: {
                if (n4 == 0x10100091) {
                    ++n;
                    n2 = 1;
                } else {
                    n2 = 0;
                    n3 = Integer.MAX_VALUE;
                }
                f = this.floatParameter(n, 0.0f, 16.0f);
                break;
            }
            case 2: {
                f = this.intParameter(n);
                if (this.tokAt(n + 1) == 269484194) {
                    ++n;
                    n2 = 2;
                    if (f < 0.0f || f > 200.0f) {
                        this.integerOutOfRange(0, 200);
                    }
                    f /= 100.0f;
                    break;
                }
                if (f > 749.0f || f < -200.0f) {
                    this.integerOutOfRange(-200, 749);
                }
                if (f > 0.0f) {
                    f /= 250.0f;
                    n2 = 0;
                    break;
                }
                f /= -100.0f;
                n2 = 2;
                break;
            }
            default: {
                if (f != 1.0f) break;
                --n;
            }
        }
        if (n3 == 0) {
            this.iToken = n++;
            n3 = JmolConstants.getVdwType(this.optParameterAsString(n));
            if (n3 < 0) {
                n3 = JmolConstants.getVdwType("auto");
            } else {
                this.iToken = n;
            }
        }
        return new RadiusData(f, n2, n3);
    }

    private void structure() throws ScriptException {
        String string = this.parameterAsString(1).toLowerCase();
        byte by = 0;
        BitSet bitSet = null;
        if (string.equals("helix")) {
            by = 3;
        } else if (string.equals("sheet")) {
            by = 2;
        } else if (string.equals("turn")) {
            by = 1;
        } else if (string.equals("none")) {
            by = 0;
        } else {
            this.error(22);
        }
        switch (this.tokAt(2)) {
            case 9: 
            case 0x100001: {
                bitSet = this.expression(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.viewer.setProteinType(by, bitSet);
    }

    private void wireframe() throws ScriptException {
        int n = this.getMadParameter();
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", new Integer(1023));
        this.setShapeSize(1, n);
    }

    private void ssbond() throws ScriptException {
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", new Integer(256));
        this.setShapeSize(1, n);
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void struts() throws ScriptException {
        boolean bl = this.tokAt(1) == 1073741958 || this.tokAt(1) == 0x10000D || this.statementLength == 1;
        int n = this.getMadParameter();
        if (bl) {
            n = (int)(this.viewer.getStrutDefaultRadius() * 2000.0f);
        }
        this.setShapeProperty(1, "type", new Integer(32768));
        this.setShapeSize(1, n);
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void hbond(boolean bl) throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 4102) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null);
            this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", n));
            return;
        }
        if (this.statementLength == 2 && this.getToken((int)1).tok == 12291) {
            if (this.isSyntaxCheck) {
                return;
            }
            this.connect(0);
            return;
        }
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", new Integer(30720));
        this.setShapeSize(1, n);
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void configuration() throws ScriptException {
        int n;
        BitSet bitSet;
        if (this.statementLength == 1) {
            bitSet = this.viewer.setConformation();
            this.viewer.addStateScript("select", null, this.viewer.getSelectionSet(), null, "configuration", true, false);
        } else {
            n = this.intParameter(this.checkLast(1));
            if (this.isSyntaxCheck) {
                return;
            }
            bitSet = this.viewer.getConformation(this.viewer.getCurrentModelIndex(), n - 1, true);
            this.viewer.addStateScript("configuration " + n + ";", true, false);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = this.viewer.hasCalculatedHBonds(bitSet) ? 1 : 0;
        this.setShapeProperty(1, "type", new Integer(30720));
        this.viewer.setShapeSize(1, 0, bitSet);
        if (n != 0) {
            this.viewer.autoHbond(bitSet, bitSet, null, 0.0f, 0.0f);
        }
        this.viewer.select(bitSet, this.tQuiet);
    }

    private void vector() throws ScriptException {
        int n = 3;
        float f = 1.0f;
        this.checkLength(-3);
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        break block0;
                    }
                    case 0x10000C: {
                        f = 0.0f;
                        break block0;
                    }
                    case 2: {
                        n = 3;
                        f = this.intParameter(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        n = 0;
                        f = this.floatParameter(1, 0.0f, 3.0f);
                        break block0;
                    }
                }
                this.error(6);
                break;
            }
            case 3: {
                if (this.tokAt(1) != 1073741995) break;
                this.setFloatProperty("vectorScale", this.floatParameter(2, -100.0f, 100.0f));
                return;
            }
        }
        this.setShapeSize(18, new RadiusData(f, n, 0));
    }

    private void dipole() throws ScriptException {
        String string = null;
        Serializable serializable = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.viewer.loadShape(17);
        if (this.tokAt(1) == 6 && this.listIsosurface(17)) {
            return;
        }
        this.setShapeProperty(17, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(17, "thisID", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            string = null;
            serializable = null;
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    string = "on";
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 12291: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    serializable = new Float(this.floatParameter(i));
                    break;
                }
                case 9: {
                    string = "atomBitset";
                }
                case 0x100001: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    serializable = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: 
                case 0x10000A: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    serializable = point3f;
                    bl2 = true;
                    break;
                }
                case 1678770178: {
                    string = "bonds";
                    break;
                }
                case 4102: {
                    string = "calculate";
                    break;
                }
                case 1074790483: {
                    this.setShapeId(17, ++i, bl3);
                    i = this.iToken;
                    break;
                }
                case 135267329: {
                    string = "cross";
                    serializable = Boolean.TRUE;
                    break;
                }
                case 1073741941: {
                    string = "cross";
                    serializable = Boolean.FALSE;
                    break;
                }
                case 1073741955: {
                    float f = this.floatParameter(++i);
                    if (this.theTok == 2) {
                        string = "offsetPercent";
                        serializable = new Integer((int)f);
                        break;
                    }
                    string = "offset";
                    serializable = new Float(f);
                    break;
                }
                case 0x40000084: {
                    string = "offsetSide";
                    serializable = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073742024: {
                    string = "value";
                    serializable = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073742030: {
                    string = "width";
                    serializable = new Float(this.floatParameter(++i));
                    break;
                }
                default: {
                    if (this.theTok == 0x101000A1 || Token.tokAttr(this.theTok, 0x40000000)) {
                        this.setShapeId(17, i, bl3);
                        i = this.iToken;
                        break;
                    }
                    this.error(22);
                }
            }
            boolean bl4 = bl3 = this.theTok != 12291 && this.theTok != 4102;
            if (string == null) continue;
            this.setShapeProperty(17, string, serializable);
        }
        if (bl2 || bl) {
            this.setShapeProperty(17, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.statementLength > 5) {
            this.error(2);
        }
        int n = 0;
        switch (this.getToken((int)2).tok) {
            case 528415: {
                n = 1;
                break;
            }
            case 1073741957: {
                f2 = 0.0f;
                f = 0.0f;
                break;
            }
            case 1073741963: {
                n = 2;
                break;
            }
            case 0x40000000: {
                this.error(22);
            }
        }
        if (this.statementLength >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.statementLength == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(n, f, f2);
        }
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                this.checkLength(2);
                f = this.viewer.getVibrationPeriod();
                break;
            }
            case 0x10000C: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1073741995: {
                this.setFloatProperty("vibrationScale", this.floatParameter(2, -10.0f, 10.0f));
                return;
            }
            case 1073741967: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.error(22);
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void animationDirection() throws ScriptException {
        int n = 2;
        int n2 = 0;
        switch (this.tokAt(n)) {
            case 0x10100090: {
                n2 = -this.intParameter(++n);
                break;
            }
            case 0x10100091: {
                n2 = this.intParameter(++n);
                break;
            }
            case 2: {
                n2 = this.intParameter(n);
                if (n2 <= 0) break;
                n2 = 0;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.checkLength(++n);
        if (n2 != 1 && n2 != -1) {
            this.error(35, "-1", "1");
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(n2);
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 1112539151: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateStraightness();
                        this.viewer.addStateScript(this.thisCommand, false, true);
                    }
                    return;
                }
                case 1613758468: {
                    BitSet bitSet = this.statementLength == 2 ? null : this.expression(2);
                    this.checkLast(this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.addHydrogens(bitSet);
                    return;
                }
                case 1073741974: {
                    this.pointGroup();
                    return;
                }
                case 0x30000D: {
                    bl = true;
                }
                case 1112539152: {
                    boolean bl2 = false;
                    switch (this.tokAt(2)) {
                        case 135266317: {
                            ++this.iToken;
                            break;
                        }
                        case 0: {
                            bl2 = !bl;
                            break;
                        }
                        case 0x40000046: {
                            bl2 = true;
                            ++this.iToken;
                            break;
                        }
                        default: {
                            bl2 = true;
                        }
                    }
                    BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : this.viewer.getSelectionSet();
                    this.checkLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.calculateSurface(bitSet, bl2 ? Float.MAX_VALUE : -1.0f);
                    return;
                }
                case 1577017: {
                    BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
                    BitSet bitSet2 = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
                    this.checkLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    int n = this.viewer.calculateStruts(bitSet, bitSet2);
                    if (n > 0) {
                        this.colorShape(4, 32768, 0xFFFFFF, "translucent", 0.5f, null);
                    }
                    this.showString(GT._("{0} struts added", n));
                    return;
                }
                case 1313866247: {
                    if (this.isSyntaxCheck) break;
                    float f = this.viewer.getVolume(null, null);
                    this.showString("" + (float)Math.round(f * 10.0f) / 10.0f + " A^3; " + (float)Math.round((double)f * 6.02) / 10.0f + " cm^3/mole (VDW " + this.viewer.getDefaultVdwTypeNameOrData(Integer.MIN_VALUE) + ")");
                    return;
                }
                case 1076887563: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 1612189721: {
                    if (this.statementLength == 2) {
                        if (!this.isSyntaxCheck) {
                            this.viewer.autoHbond(null);
                        }
                        return;
                    }
                    BitSet bitSet = this.expression(2);
                    BitSet bitSet3 = this.expression(this.iToken + 1);
                    if (!this.isSyntaxCheck) {
                        int n = this.viewer.autoHbond(bitSet, bitSet3, null, -1.0f, -1.0f);
                        this.showString(n + " hydrogen bonds created");
                    }
                    return;
                }
                case 1104154627: {
                    BitSet bitSet;
                    BitSet bitSet4 = bitSet = this.statementLength == 2 ? null : this.expression(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (bitSet == null) {
                        bitSet = this.viewer.getAtomBitSet(null);
                    }
                    this.viewer.calculateStructures(bitSet);
                    this.viewer.addStateScript(this.thisCommand, false, true);
                    return;
                }
            }
        }
        this.error(53, "CALCULATE", "aromatic? hbonds? polymers? straightness? structure? strut? surfaceDistance FROM? surfaceDistance WITHIN? volume?");
    }

    private void pointGroup() throws ScriptException {
        switch (this.tokAt(0)) {
            case 4102: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.calculatePointGroup());
                }
                return;
            }
            case 4148: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getPointGroupAsString(false, null, 0, 0.0f));
                }
                return;
            }
        }
        int n = 2;
        String string = this.tokAt(n) == 1073741995 ? "" : this.optParameterAsString(n);
        float f = 1.0f;
        int n2 = 0;
        if (string.length() > 0 && this.isFloatParameter(++n)) {
            n2 = this.intParameter(n++);
        }
        if (this.tokAt(n) == 1073741995) {
            f = this.floatParameter(++n);
        }
        if (!this.isSyntaxCheck) {
            this.runScript(this.viewer.getPointGroupAsString(true, string, n2, f));
        }
    }

    private void dots(int n) throws ScriptException {
        RadiusData radiusData;
        if (!this.isSyntaxCheck) {
            this.viewer.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        float f = Float.NaN;
        int n2 = 0;
        int n3 = 1;
        switch (this.getToken((int)1).tok) {
            case 1073741958: {
                this.restrictSelected(false, false);
                f = 1.0f;
                n2 = 2;
                break;
            }
            case 0x10000D: {
                f = 1.0f;
                n2 = 2;
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 2: {
                int n4 = this.intParameter(n3++);
                if (this.tokAt(n3) != 1666189313) break;
                this.setShapeProperty(n, "atom", new Integer(n4));
                this.setShapeProperty(n, "radius", new Float(this.floatParameter(++n3)));
                if (this.tokAt(++n3) == 1632638983) {
                    this.setShapeProperty(n, "colorRGB", new Integer(this.getArgbParam(++n3)));
                    ++n3;
                }
                if (this.getToken((int)n3).tok != 9) {
                    this.error(22);
                }
                this.setShapeProperty(n, "dots", this.statement[n3].value);
                return;
            }
        }
        RadiusData radiusData2 = radiusData = Float.isNaN(f) ? this.encodeRadiusParameter(1) : new RadiusData(f, n2, 0);
        if (Float.isNaN(radiusData.value)) {
            this.error(22);
        }
        this.setShapeSize(n, radiusData);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 1073741958: {
                if (this.isSyntaxCheck) {
                    return;
                }
                this.restrictSelected(false, false);
                n2 = -1;
                break;
            }
            case 0x10000D: {
                n2 = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 1104154627: {
                n2 = -2;
                break;
            }
            case 1073741878: 
            case 1112541201: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameter(1, 0, 499) * 8;
                break;
            }
            case 3: {
                n2 = (int)(this.floatParameter(1, 0.0f, 4.0f) * 2000.0f);
                break;
            }
            case 9: {
                if (!this.isSyntaxCheck) {
                    this.viewer.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSize(n, n2);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                bl = true;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 4116: {
                this.frame(2);
                break;
            }
            case 1073741933: {
                this.animationMode();
                break;
            }
            case 0x40000034: {
                this.animationDirection();
                break;
            }
            case 1074790469: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1, true);
            }
        }
    }

    private void file() throws ScriptException {
        int n = this.intParameter(this.checkLast(1));
        if (this.isSyntaxCheck) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void frame(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = true;
        if (this.statementLength == 1 && n == 1) {
            int n4;
            int n5 = this.viewer.getCurrentModelIndex();
            if (!this.isSyntaxCheck && n5 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n5)) >= 0) {
                this.viewer.setCurrentModelIndex(n4 == n5 ? Integer.MIN_VALUE : n4);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 1073742010: {
                if (this.checkLength23() > 0 && !this.isSyntaxCheck) {
                    this.viewer.setFrameTitle(this.statementLength == 2 ? "@{_modelName}" : this.parameterAsString(2));
                }
                return;
            }
            case 0x40000004: {
                BitSet bitSet;
                BitSet bitSet2 = bitSet = this.statementLength == 2 || this.tokAt(2) == 0x10000B ? null : this.expression(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFrameOffsets(bitSet);
                }
                return;
            }
        }
        if (this.getToken((int)n).tok == 0x10100090) {
            if (this.getToken((int)this.checkLast((int)(++n))).tok != 2 || this.intParameter(n) != 1) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimation(1073741978);
            }
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = new int[]{-1, -1};
        int n6 = 0;
        block13: for (n3 = n; n3 < this.statementLength; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 0x100003: 
                case 0x101000A1: {
                    this.checkLength(n + (bl3 ? 2 : 1));
                    bl4 = true;
                    continue block13;
                }
                case 0x10100090: {
                    if (n6 != 1) {
                        this.error(22);
                    }
                    bl5 = true;
                    continue block13;
                }
                case 0x10000B: {
                    this.checkLength(n + 1);
                    continue block13;
                }
                case 3: {
                    bl = false;
                    if (this.floatParameter(n3) < 0.0f) {
                        bl5 = true;
                    }
                }
                case 2: {
                    if (n6 == 2) {
                        this.error(22);
                    }
                    if ((n2 = this.statement[n3].intValue) == -1) {
                        this.checkLength(n + 1);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setAnimation(1073741978);
                        }
                        return;
                    }
                    if (n2 >= 1000 && n2 < 1000000 && this.viewer.haveFileSet()) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl && n2 == 0) {
                        bl4 = true;
                    }
                    if (n2 >= 1000000) {
                        bl = false;
                    }
                    nArray[n6++] = n2;
                    continue block13;
                }
                case 1073741971: {
                    bl2 = true;
                    continue block13;
                }
                case 1073741982: {
                    bl3 = true;
                    continue block13;
                }
                default: {
                    this.frameControl(n, false);
                    return;
                }
            }
        }
        n3 = this.viewer.haveFileSet() ? 1 : 0;
        if (bl3 && n6 == 0) {
            bl4 = true;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl3) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n6 == 2 && !bl3) {
            bl5 = true;
        }
        if (n3 != 0) {
            bl = false;
        } else if (bl) {
            for (n2 = 0; n2 < n6; ++n2) {
                if (nArray[n2] < 0) continue;
                int n7 = n2;
                nArray[n7] = nArray[n7] % 1000000;
            }
        }
        n2 = this.viewer.getModelNumberIndex(nArray[0], bl, false);
        int n8 = -1;
        if (n3 != 0 && n6 == 1 && n2 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n2 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n2 >= 0) {
                    n8 = this.viewer.getModelNumberIndex(nArray[0] + 1000000, false, false);
                    if (n8 < 0) {
                        n8 = this.viewer.getModelCount();
                    }
                    --n8;
                    if (bl3) {
                        n6 = 2;
                    } else if (!bl5 && n8 != n2) {
                        bl5 = true;
                    }
                    bl3 = bl3 || n2 == n8;
                }
            } else {
                return;
            }
        }
        if (!bl2 && !bl3 || n2 >= 0) {
            this.viewer.setCurrentModelIndex(n2, false);
        }
        if (bl2 && n6 == 2 || bl3 || bl5) {
            if (n8 < 0) {
                n8 = this.viewer.getModelNumberIndex(nArray[1], bl, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n2, n8);
            this.viewer.setCurrentModelIndex(bl5 && !bl3 ? -1 : (n2 >= 0 ? n2 : 0), false);
        }
        if (bl2) {
            this.viewer.setAnimation(266286);
        }
    }

    BitSet bitSetForModelFileNumber(int n) {
        int n2;
        BitSet bitSet = new BitSet();
        if (this.isSyntaxCheck) {
            return bitSet;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bitSet;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bitSet.or(this.viewer.getModelAtomBitSet(i, false));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bitSet.or(this.viewer.getModelAtomBitSet(n7, false));
            }
        }
        return bitSet;
    }

    private void frameControl(int n, boolean bl) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 20486: 
            case 266286: 
            case 0x40000041: 
            case 1073741918: 
            case 1073741939: 
            case 1073741971: 
            case 0x40000094: 
            case 1073741978: 
            case 0x400000A4: {
                if (!this.isSyntaxCheck) {
                    this.viewer.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.error(22);
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JmolConstants.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(49);
        }
        return n2;
    }

    private void font(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.viewer.getZoomSetting() / f2 / this.viewer.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.error(22);
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.error(22);
                }
                string = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 5) {
                    f = 13.0f;
                    break;
                }
                this.error(2);
            }
        }
        if (n == 5) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
            }
            this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.isSyntaxCheck) {
            return;
        }
        Font3D font3D = this.viewer.getFont3D(string, string2, f);
        this.viewer.loadShape(n);
        this.setShapeProperty(n, "font", font3D);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", new Float(f2));
        }
    }

    private void set() throws ScriptException {
        boolean bl;
        int n;
        Object object;
        String string;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl2 = this.parameterAsString(0).equals("set");
        String string2 = this.optParameterAsString(1);
        if (bl2 && this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n2 = this.getToken((int)1).tok;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        boolean bl3 = !this.isSyntaxCheck && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.statement[0].value).equals("var");
        switch (n2) {
            case 1611272194: {
                this.axes(2);
                return;
            }
            case 1610616835: {
                this.background(2);
                return;
            }
            case 1679429641: {
                this.boundbox(2);
                return;
            }
            case 1611272213: {
                this.frank(2);
                return;
            }
            case 1610616858: {
                this.history(2);
                return;
            }
            case 1826248707: {
                this.label(2);
                return;
            }
            case 1614417984: {
                this.unitcell(2);
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.selectionHalo(2);
                return;
            }
            case 536875070: {
                this.timeout(2);
                return;
            }
        }
        switch (n2) {
            case 0x60000001: {
                this.setBondmode();
                return;
            }
            case 0x20000004: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n5 = this.tokAt(2) == 0x10000C || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(n5);
                this.setIntProperty("logLevel", n5);
                if (n5 == 4) {
                    this.viewer.setDebugScript(false);
                    if (bl3) {
                        this.viewer.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (bl3) {
                    this.viewer.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.setEcho();
                return;
            }
            case 0x60000002: {
                this.font(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1612189721: {
                this.setHbond();
                return;
            }
            case 537006111: 
            case 1746538503: {
                this.setMonitor();
                return;
            }
            case 1611141176: {
                this.setSsbond();
                return;
            }
            case 0x60000005: {
                this.setLabel("toggle");
                return;
            }
            case 0x20000010: {
                this.setUserColors();
                return;
            }
        }
        boolean bl4 = true;
        switch (n2) {
            case 0x22000002: {
                this.setFloatProperty("axesScale", this.floatSetting(2, -100.0f, 100.0f));
                break;
            }
            case 0x20000002: {
                int n6;
                if (this.statementLength <= 2) break;
                String string3 = this.stringSetting(2, false);
                boolean bl5 = false;
                if (string3.indexOf(".") < 0) {
                    n6 = Parser.parseInt(string3);
                    bl5 = true;
                } else {
                    n6 = JmolConstants.modelValue(string3);
                }
                if (this.isSyntaxCheck) {
                    return;
                }
                int n7 = this.viewer.getModelNumberIndex(n6, bl5, true);
                this.viewer.setBackgroundModelIndex(n7);
                return;
            }
            case 545259556: {
                if (this.statementLength <= 2) break;
                String string4 = string = this.statementLength == 3 && JmolConstants.getVdwType(this.parameterAsString(2)) == -1 ? this.stringSetting(2, false) : this.parameterAsString(2);
                if (JmolConstants.getVdwType(string) < 0) {
                    this.error(22);
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x20000006: {
                if (this.statementLength <= 2) break;
                object = (Vector)this.parameterExpression(2, 0, "XXX", true);
                if (object == null || ((Vector)object).size() == 0) {
                    this.error(22);
                }
                ScriptVariable scriptVariable = (ScriptVariable)((Vector)object).elementAt(0);
                Point3f point3f = scriptVariable.tok == 7 ? (Point3f)scriptVariable.value : ((n = ScriptVariable.iValue(scriptVariable)) < 555 ? new Point3f() : this.viewer.getSymmetry().ijkToPoint3f(n + 111));
                if (this.isSyntaxCheck) break;
                this.viewer.setDefaultLattice(point3f);
                break;
            }
            case 545259544: 
            case 0x20800020: {
                if (this.statementLength <= 2) break;
                this.theTok = this.tokAt(2);
                string = this.theTok == 1073741917 || this.theTok == 1073741983 ? this.parameterAsString(this.checkLast(2)).toLowerCase() : this.stringSetting(2, false).toLowerCase();
                if (!string.equals("jmol") && !string.equals("rasmol")) {
                    this.error(22);
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x2200000C: {
                this.setFloatProperty("dipoleScale", this.floatSetting(2, -10.0f, 10.0f));
                break;
            }
            case 1632634889: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n4);
                }
                return;
            }
            case 553648149: {
                n4 = this.intSetting(2);
                if (this.isSyntaxCheck) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.commandHistoryLevelMax = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 545259564: {
                if (this.statementLength <= 2) break;
                this.setStringProperty(string2, this.stringSetting(2, bl2));
                break;
            }
            case 545259568: {
                if (this.statementLength <= 2) break;
                this.setMeasurementUnits(this.stringSetting(2, bl2));
                break;
            }
            case 553648156: {
                this.setIntProperty(string2, this.intSetting(2, Integer.MAX_VALUE, 0, 1000));
                break;
            }
            case 545259569: {
                if (this.statementLength <= 2) break;
                this.setPicking();
                return;
            }
            case 545259570: {
                if (this.statementLength <= 2) break;
                this.setPickingStyle();
                return;
            }
            case 1716520973: {
                break;
            }
            case 553648168: {
                n4 = this.intSetting(2);
                if (this.isSyntaxCheck) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.scriptReportingLevel = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 0x22000032: {
                this.setFloatProperty(string2, this.floatSetting(2, 0.0f, 10.0f));
                break;
            }
            case 0x2000000A: 
            case 0x21000002: 
            case 553648142: 
            case 553648174: {
                n4 = this.intSetting(2);
                if (n2 == 0x2000000A) {
                    if (n4 == Integer.MIN_VALUE || n4 == 0 || n4 == 1) {
                        bl4 = false;
                        break;
                    }
                    n2 = 553648174;
                    string2 = "specularPercent";
                }
                this.setIntProperty(string2, this.intSetting(2, n4, 0, 100));
                break;
            }
            case 553648172: 
            case 553648176: {
                n4 = this.intSetting(2);
                if (n2 == 553648176) {
                    if (n4 >= 0) {
                        bl4 = false;
                        break;
                    }
                    n2 = 553648172;
                    string2 = "specularExponent";
                    if (n4 < -10 || n4 > -1) {
                        this.integerOutOfRange(-10, -1);
                    }
                    n4 = -n4;
                }
                this.setIntProperty(string2, this.intSetting(2, n4, 0, 10));
                break;
            }
            case 553648178: 
            case 553648180: 
            case 553648182: 
            case 1650071565: {
                if (n2 == 1650071565) {
                    n2 = 553648178;
                    string2 = "strandCount";
                }
                this.setIntProperty(string2, this.intSetting(2, Integer.MAX_VALUE, 0, 20));
                break;
            }
            default: {
                bl4 = false;
            }
        }
        if (bl4 && !bl3) {
            return;
        }
        boolean bl6 = bl = !bl4 && !bl2 && this.getContextVariableAsVariable(string2) != null;
        if (!bl4 && !bl) {
            switch (n2) {
                case 1678770178: {
                    n3 = 603979928;
                    break;
                }
                case 0x60300003: {
                    n3 = 603979908;
                    break;
                }
                case 1613758468: {
                    n3 = 603979910;
                    break;
                }
                case 0x60000003: {
                    n3 = 603979878;
                    break;
                }
                case 1666189313: {
                    n3 = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.floatSetting(2, 0.0f, 10.0f));
                    bl4 = true;
                    break;
                }
                case 0x60000004: {
                    n3 = 0x2200002E;
                    break;
                }
                case 1613758475: {
                    n3 = 603979948;
                    break;
                }
                case 1632638983: {
                    n3 = 545259544;
                    break;
                }
                case 1611141175: {
                    string = this.parameterAsString(2).toLowerCase();
                    switch ("x;y;z;fps".indexOf(string + ";")) {
                        case 0: {
                            n3 = 570425398;
                            break;
                        }
                        case 2: {
                            n3 = 570425400;
                            break;
                        }
                        case 4: {
                            n3 = 570425402;
                            break;
                        }
                        case 6: {
                            n3 = 570425396;
                            break;
                        }
                        default: {
                            this.error(50, "set SPIN ", string);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpin(string, (int)this.floatParameter(this.checkLast(3)));
                    }
                    bl4 = true;
                }
            }
        }
        if (n3 != 0) {
            n2 = n3;
            string2 = Token.nameOf(n2);
        } else if (!bl4 && !bl) {
            if (string2.charAt(0) == '_') {
                this.error(22);
            }
            if (((String)(object = string2.toLowerCase())).indexOf("label") == 0 && Parser.isOneOf(string2.substring(5).toLowerCase(), "front;group;atom;offset;offsetexact;pointer;alignment;toggle;scalereference") && this.setLabel(string2.substring(5))) {
                return;
            }
            if (((String)object).indexOf("callback") >= 0) {
                n2 = 0x20000000;
            }
        }
        if (bl2 && !Token.tokAttr(n2, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.error(50, "SET", string2);
            }
            this.warning(51, "SET", string2);
        }
        if (!bl4 && bl2) {
            switch (this.statementLength) {
                case 2: {
                    this.setBooleanProperty(string2, true);
                    bl4 = true;
                    break;
                }
                case 3: {
                    if (n4 == Integer.MAX_VALUE) break;
                    this.setIntProperty(string2, n4);
                    bl4 = true;
                }
            }
        }
        if (!bl4 && !bl2 && this.tokAt(2) == 0x10000B) {
            if (!this.isSyntaxCheck) {
                this.viewer.removeUserVariable(string2);
            }
            bl4 = true;
        }
        if (!bl4) {
            int n8 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            int n9 = this.statement[0].intValue;
            n = n8 == 269484420 ? 3 : (n9 == 61 && !string2.equals("return") && n8 != 269484420 ? 0 : 2);
            this.setVariable(n, 0, string2, n9);
            if (!bl2) {
                return;
            }
        }
        if (bl3) {
            this.viewer.showParameter(string2, true, 80);
        }
    }

    private void setBondmode() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)this.checkLast((int)2)).tok) {
            case 0x10100060: {
                break;
            }
            case 0x10100050: {
                bl = true;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void setEcho() throws ScriptException {
        int n;
        String string = "target";
        Object object = null;
        boolean bl = true;
        int n2 = 3;
        switch (this.getToken((int)2).tok) {
            case 0x10000C: {
                this.checkLength(3);
                bl = false;
                string = "allOff";
                break;
            }
            case 12293: 
            case 3145752: {
                string = "hidden";
                object = Boolean.TRUE;
                break;
            }
            case 0x10000D: 
            case 3145751: 
            case 1610625028: {
                string = "hidden";
                object = Boolean.FALSE;
                break;
            }
            case 0x10000B: {
                bl = false;
            }
            case 0x100003: {
                this.checkLength(3);
            }
            case 12289: 
            case 0x40000000: 
            case 1073741847: 
            case 1073741919: 
            case 1073741989: 
            case 1074790589: {
                object = this.parameterAsString(2);
                break;
            }
            case 1095766028: {
                n = this.modelNumberParameter(3);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (n >= this.viewer.getModelCount()) {
                    this.error(22);
                }
                string = "model";
                object = new Integer(n);
                n2 = 4;
                break;
            }
            case 0x40000055: {
                this.echo(3, true);
                return;
            }
            case 528397: {
                string = "%zpos";
                object = new Integer((int)this.floatParameter(3));
                n2 = 4;
                break;
            }
            case 4: {
                this.echo(2, false);
                return;
            }
            default: {
                if (!Token.tokAttr(this.theTok, 0x40000000)) {
                    this.error(22);
                }
                object = this.parameterAsString(2);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(bl);
            this.viewer.loadShape(28);
            this.setShapeProperty(28, string, object);
        }
        if (this.statementLength == n2) {
            return;
        }
        string = "align";
        object = null;
        if (this.statementLength == 4) {
            if (this.isCenterParameter(3)) {
                this.setShapeProperty(28, "xyz", this.centerParameter(3));
                return;
            }
            switch (this.getToken((int)3).tok) {
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 3145752: {
                    string = "hidden";
                    object = Boolean.TRUE;
                    break;
                }
                case 0x10000D: 
                case 3145751: {
                    string = "hidden";
                    object = Boolean.FALSE;
                    break;
                }
                case 1095766028: {
                    n = this.modelNumberParameter(4);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (n >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    string = "model";
                    object = new Integer(n);
                    break;
                }
                case 12289: 
                case 0x40000000: 
                case 1073741847: 
                case 1073741919: 
                case 1073741989: 
                case 1074790589: {
                    object = this.parameterAsString(3);
                    break;
                }
                default: {
                    if (!Token.tokAttr(this.theTok, 0x40000000)) {
                        this.error(22);
                    }
                    object = this.parameterAsString(3);
                }
            }
            this.setShapeProperty(28, string, object);
            return;
        }
        if (this.statementLength == 5) {
            switch (this.tokAt(3)) {
                case 135271428: {
                    string = "script";
                    object = this.parameterAsString(4);
                    break;
                }
                case 1095766028: {
                    n = this.modelNumberParameter(4);
                    if (!this.isSyntaxCheck && n >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    string = "model";
                    object = new Integer(n);
                    break;
                }
                case 0x40000055: {
                    this.echo(4, true);
                    return;
                }
                case 528397: {
                    string = "%zpos";
                    object = new Integer((int)this.floatParameter(4));
                }
            }
            if (object != null) {
                this.setShapeProperty(28, string, object);
                return;
            }
        }
        this.getToken(4);
        n = 3;
        if (this.isCenterParameter(n)) {
            if (!this.isSyntaxCheck) {
                this.setShapeProperty(28, "xyz", this.centerParameter(n));
            }
            return;
        }
        String string2 = "xypos";
        object = this.xypParameter(n);
        if (object == null) {
            int n3 = this.intParameter(n++);
            object = new Integer(n3);
            string2 = this.tokAt(n) == 269484194 ? "%xpos" : "xpos";
            this.setShapeProperty(28, string2, object);
            int n4 = ++n;
            n3 = this.intParameter(n4);
            object = new Integer(n3);
            if (this.tokAt(++n) == 269484194) {
                string2 = "%ypos";
                ++n;
            } else {
                string2 = "ypos";
            }
        }
        this.setShapeProperty(28, string2, object);
    }

    private boolean setLabel(String string) throws ScriptException {
        this.viewer.loadShape(5);
        Object object = null;
        this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.viewer.getZoomSetting() / f / this.viewer.getScalePixelsPerAngstrom(false);
            }
            object = new Float(f);
        } else if (string.equals("offset") || string.equals("offsetexact")) {
            int n = this.intParameter(2, -127, 127);
            int n2 = this.intParameter(3, -127, 127);
            object = new Integer(Object2d.getOffset(n, n2));
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 1073741919: 
                case 1073741989: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.error(22);
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            int n = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000B: 
                case 0x10000C: {
                    break;
                }
                case 1610616835: {
                    n |= 2;
                }
                case 0x10000D: {
                    n |= 1;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            object = new Integer(n);
        } else {
            boolean bl;
            if (string.equals("toggle")) {
                this.iToken = 1;
                BitSet bitSet = this.statementLength == 2 ? null : this.expression(2);
                this.checkLast(this.iToken);
                if (!this.isSyntaxCheck) {
                    this.viewer.togglePickingLabel(bitSet);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl2 = bl = this.statementLength == 2 || this.getToken((int)2).tok == 0x10000D;
            if (string.equals("front") || string.equals("group")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                if (!bl) {
                    string = "front";
                }
                object = bl ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                string = "front";
                object = bl ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.isSyntaxCheck) {
            return true;
        }
        if (bitSet == null) {
            this.setShapeProperty(5, string, object);
        } else {
            this.viewer.setShapeProperty(5, string, object, bitSet);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        int n = this.tokAt(this.checkLast(2));
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                this.setShapeProperty(6, "showMeasurementNumbers", n == 0x10000D ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 2: 
            case 3: 
            case 1073741880: {
                this.setShapeSize(6, this.getSetAxesTypeMad(2));
                return;
            }
        }
        this.setMeasurementUnits(this.parameterAsString(2));
    }

    private boolean setMeasurementUnits(String string) throws ScriptException {
        if (!StateManager.isMeasurementUnit(string)) {
            this.error(50, "set measurementUnits ", string);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setMeasureDistanceUnits(string);
        }
        return true;
    }

    private void setSsbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
                break;
            }
            case 0x30000C: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
            }
            case 0x30000C: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 1073742002: {
                bl = true;
            }
            case 1073741880: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135280129: 
            case 1611141175: 
            case 1746538503: {
                if (this.checkLength34() == 4) {
                    string = this.parameterAsString(2).toUpperCase();
                    if (string.equals("SPIN")) {
                        this.setIntProperty("pickingSpinRate", this.intParameter(3));
                        break;
                    }
                    n = 3;
                }
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1073741950: {
                string2 = "identify";
                break;
            }
            case 0x10000B: {
                string2 = "off";
                break;
            }
            case 135280129: {
                string2 = "atom";
                break;
            }
            case 1826248707: {
                string2 = "label";
                break;
            }
            case 1678770178: {
                string2 = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1678770178) {
                    this.error(22);
                }
                string2 = "deleteBond";
            }
        }
        int n2 = JmolConstants.getPickingMode(string2);
        if (n2 < 0) {
            this.error(50, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1746538503: {
                bl = true;
                string = "MEASURE";
            }
            case 135280129: {
                if (this.checkLength34() != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000B: 
            case 0x10000C: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 0x10000D: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (JmolConstants.getPickingStyle(string2) < 0) {
            this.error(50, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void timeout(int n) throws ScriptException {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (this.statementLength == n) {
            this.showString(this.viewer.showTimeout(null));
            return;
        }
        block6: for (int i = n; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1074790483: {
                    string = this.parameterAsString(++i);
                    continue block6;
                }
                case 0x10000C: {
                    continue block6;
                }
                case 2: {
                    n2 = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    n2 = (int)(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (string == null) {
                        string = this.parameterAsString(i);
                        continue block6;
                    }
                    if (string2 == null) {
                        string2 = this.parameterAsString(i);
                        continue block6;
                    }
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setTimeout(string, n2, string2);
        }
    }

    private void setUserColors() throws ScriptException {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 2; n < this.statementLength; ++n) {
            int n2 = this.getArgbParam(n);
            vector.addElement(new Integer(n2));
            n = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = vector.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)vector.elementAt(n3);
        }
        Viewer.setUserScale(nArray);
    }

    private void setVariable(int n, int n2, String string, int n3) throws ScriptException {
        boolean bl;
        Object object;
        boolean bl2;
        BitSet bitSet = null;
        String string2 = "";
        int n4 = 0;
        boolean bl3 = this.statement[0].intValue == 91;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = string.startsWith("property_");
        ScriptVariable scriptVariable = bl6 ? null : this.getContextVariableAsVariable(string);
        boolean bl7 = bl2 = scriptVariable != null;
        if (n > 0 && this.tokAt(n - 1) == 0x100001) {
            bitSet = this.expression(n - 1);
            n = this.iToken + 1;
            bl5 = true;
        }
        if (this.tokAt(n) == 0x100008) {
            bl4 = true;
            if ((object = this.getBitsetPropertySelector(++n, true)) == null) {
                this.error(22);
            }
            if (this.tokAt(++n) != 269484420) {
                this.error(22);
            }
            ++n;
            n4 = ((ScriptVariable)object).intValue;
            string2 = (String)((ScriptVariable)object).value;
        }
        if (bl5 && !bl4) {
            this.error(22);
        }
        if ((object = this.parameterExpression(n, n2, string, true, -1, bl3, null, null)) == null) {
            return;
        }
        int n5 = ((Vector)object).size();
        if (n5 == 0 || !bl3 && n5 > 1 || bl3 && n5 != 3) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        ScriptVariable scriptVariable2 = (ScriptVariable)((Vector)object).get(bl3 ? 2 : 0);
        boolean bl8 = bl = !bl2 && !bl5 && !bl6 && (bl3 || bl4 || !(scriptVariable2.value instanceof String) && scriptVariable2.tok != 2 && !(scriptVariable2.value instanceof Integer) && !(scriptVariable2.value instanceof Float) && !(scriptVariable2.value instanceof Boolean));
        if (bl) {
            scriptVariable = this.viewer.getOrSetNewVariable(string, true);
            if (scriptVariable == null) {
                this.error(22);
            }
            bl2 = true;
        }
        if (bl3) {
            int n6 = ScriptVariable.iValue((ScriptVariable)((Vector)object).get(0));
            scriptVariable.setSelectedValue(n6, scriptVariable2);
            return;
        }
        if (bl4) {
            if (!bl5) {
                if (!(scriptVariable.value instanceof BitSet)) {
                    this.error(22);
                }
                bitSet = (BitSet)scriptVariable.value;
            }
            if (string2.startsWith("property_")) {
                this.viewer.setData(string2, new Object[]{string2, ScriptVariable.sValue(scriptVariable2), BitSetUtil.copy(bitSet)}, this.viewer.getAtomCount(), 0, 0, scriptVariable2.tok == 6 ? Integer.MAX_VALUE : Integer.MIN_VALUE, 0);
                return;
            }
            this.setBitsetProperty(bitSet, n4, ScriptVariable.iValue(scriptVariable2), ScriptVariable.fValue(scriptVariable2), scriptVariable2);
            return;
        }
        if (bl2) {
            scriptVariable.set(scriptVariable2);
            return;
        }
        object = ScriptVariable.oValue(scriptVariable2);
        if (string.startsWith("property_")) {
            int n7 = this.viewer.getAtomCount();
            if (object instanceof String[]) {
                object = TextFormat.join((String[])object, '\n', 0);
            }
            this.viewer.setData(string, new Object[]{string, "" + object, BitSetUtil.copy(this.viewer.getSelectionSet())}, n7, 0, 0, Integer.MIN_VALUE, 0);
            return;
        }
        if (object instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object);
        } else if (object instanceof Integer) {
            this.setIntProperty(string, (Integer)object);
        } else if (object instanceof Float) {
            this.setFloatProperty(string, ((Float)object).floatValue());
        } else if (object instanceof String) {
            this.setStringProperty(string, (String)object);
        } else if (object instanceof Bond.BondSet) {
            this.setStringProperty(string, Escape.escape((BitSet)object, false));
        } else if (object instanceof BitSet) {
            this.setStringProperty(string, Escape.escape((BitSet)object));
        } else if (object instanceof Point3f) {
            String string3 = Escape.escape((Point3f)object);
            this.setStringProperty(string, string3);
        } else if (object instanceof Point4f) {
            String string4 = Escape.escape((Point4f)object);
            this.setStringProperty(string, string4);
        } else {
            Logger.error("ERROR -- return from propertyExpression was " + object);
        }
    }

    private void axes(int n) throws ScriptException {
        TickInfo tickInfo = this.checkTicks(n);
        n = this.iToken + 1;
        int n2 = this.tokAt(n);
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.statementLength == n + 1 && Parser.isOneOf(string, "window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        switch (n2) {
            case 1073741995: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++n)));
                return;
            }
            case 1826248707: {
                n2 = this.tokAt(n + 1);
                switch (n2) {
                    case 0x10000C: 
                    case 0x10000D: {
                        this.checkLength(n + 2);
                        this.setShapeProperty(29, "labels" + (n2 == 0x10000D ? "On" : "Off"), null);
                        return;
                    }
                }
                this.checkLength(n + 4);
                this.setShapeProperty(29, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                return;
            }
        }
        if (string.equals("position")) {
            Point3f point3f;
            if (this.tokAt(++n) == 0x10000C) {
                point3f = new Point3f();
            } else {
                point3f = this.xypParameter(n);
                if (point3f == null) {
                    this.error(22);
                }
                n = this.iToken;
            }
            this.setShapeProperty(29, "position", point3f);
            return;
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setObjectMad(29, "axes", n3);
        if (tickInfo != null) {
            this.setShapeProperty(29, "tickInfo", tickInfo);
        }
    }

    private void boundbox(int n) throws ScriptException {
        int n2;
        boolean bl;
        TickInfo tickInfo = this.checkTicks(n);
        n = this.iToken + 1;
        float f = 1.0f;
        if (this.tokAt(n) == 1073741995) {
            f = this.floatParameter(++n);
            if (!this.isSyntaxCheck && f == 0.0f) {
                this.error(22);
            }
            if (++n == this.statementLength) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(null, null, true, f);
                }
                return;
            }
        }
        boolean bl2 = bl = this.tokAt(n) == 1073741863;
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            n2 = n;
            Point3f point3f = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                Point3f point3f2 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(point3f, point3f2, bl, f);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BitSet) {
                if (!this.isSyntaxCheck) {
                    this.viewer.calcBoundBoxDimensions((BitSet)this.expressionResult, f);
                }
            } else if (this.expressionResult == null && this.tokAt(n2) == 0x100007) {
                Point3f[] point3fArray;
                if (this.isSyntaxCheck) {
                    return;
                }
                if ((point3fArray = this.getObjectBoundingBox(this.objectNameParameter(++n2))) == null) {
                    this.error(22);
                }
                this.viewer.setBoundBox(point3fArray[0], point3fArray[1], true, f);
                n = this.iToken + 1;
            } else {
                this.error(22);
            }
            if (n == this.statementLength) {
                return;
            }
        }
        n2 = this.getSetAxesTypeMad(n);
        if (this.isSyntaxCheck) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(30, "tickInfo", tickInfo);
        }
        this.viewer.setObjectMad(30, "boundbox", n2);
    }

    private TickInfo checkTicks(int n) throws ScriptException {
        this.iToken = n - 1;
        if (this.tokAt(n) != 1073742009) {
            return null;
        }
        String string = " ";
        switch (this.tokAt(n + 1)) {
            case 1112541210: 
            case 1112541211: 
            case 1112541212: {
                string = this.parameterAsString(++n).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.error(22);
            }
        }
        if (this.tokAt(++n) == 0x10000B) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = string;
            this.iToken = n;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo(this.getPoint3f(n, false));
        tickInfo.type = string;
        if (this.tokAt(this.iToken + 1) == 1288701954) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (this.tokAt(this.iToken + 1) == 1073741995) {
            if (this.isFloatParameter(this.iToken + 2)) {
                float f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = new Point3f(f, f, f);
            } else if (this.tokAt(this.iToken + 2) == 1614417984) {
                tickInfo.scale = new Point3f(1.0f / this.viewer.getUnitCellInfo(0), 1.0f / this.viewer.getUnitCellInfo(1), 1.0f / this.viewer.getUnitCellInfo(2));
                if (Float.isNaN(tickInfo.scale.x)) {
                    tickInfo.scale = null;
                }
                this.iToken += 2;
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true);
            }
        }
        if (this.tokAt(this.iToken + 1) == 0x40000041) {
            tickInfo.first = this.floatParameter(this.iToken + 2);
        }
        if (this.tokAt(this.iToken + 1) == 135266314) {
            tickInfo.reference = this.centerParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    private void unitcell(int n) throws ScriptException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        Point3f point3f = null;
        TickInfo tickInfo = this.checkTicks(n);
        n = this.iToken;
        if (this.statementLength == n + 2) {
            if (this.getToken((int)(n + 1)).tok == 2 && this.intParameter(n + 1) >= 111) {
                n2 = this.intParameter(++n);
            }
        } else if (this.statementLength > n + 1) {
            point3f = (Point3f)this.getPointOrPlane(++n, false, true, false, true, 3, 3);
            n = this.iToken;
        }
        n3 = this.getSetAxesTypeMad(++n);
        this.checkLast(this.iToken);
        if (this.isSyntaxCheck) {
            return;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.viewer.setCurrentUnitCellOffset(n2);
        }
        this.viewer.setObjectMad(31, "unitCell", n3);
        if (point3f != null) {
            this.viewer.setCurrentUnitCellOffset(point3f);
        }
        if (tickInfo != null) {
            this.setShapeProperty(31, "tickInfo", tickInfo);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void selectionHalo(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.statementLength ? 0x10000D : this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1114638350: {
                bl = true;
            }
            case 0x10000B: 
            case 0x10000C: 
            case 1073741950: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void save() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1073741991: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1073741961: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 1073742006: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 1104154627: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveCoordinates(string, this.viewer.getSelectionSet());
                    }
                    return;
                }
                case 1073741996: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(53, "SAVE", "bonds? coordinates? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 1073741961) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 1073741991: {
                    float f;
                    float f2 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreRotation(string, f);
                    }
                    return;
                }
                case 1073741961: {
                    float f;
                    float f3 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(string, f);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string2 = this.viewer.getSavedCoordinates(string);
                    if (string2 == null) {
                        this.error(22);
                    }
                    this.runScript(string2);
                    return;
                }
                case 1073742006: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string3 = this.viewer.getSavedState(string);
                    if (string3 == null) {
                        this.error(22);
                    }
                    this.runScript(string3);
                    return;
                }
                case 1104154627: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string4 = this.viewer.getSavedStructure(string);
                    if (string4 == null) {
                        this.error(22);
                    }
                    this.runScript(string4);
                    return;
                }
                case 1073741996: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(53, "RESTORE", "bonds? coords? orientation? selection? state? structure?");
    }

    String write(Token[] tokenArray) throws ScriptException {
        boolean bl;
        Object object;
        Token token;
        int n = 0;
        boolean bl2 = this.viewer.isApplet();
        boolean bl3 = false;
        String string = this.viewer.getExportDriverList();
        if (tokenArray == null) {
            tokenArray = this.statement;
            bl3 = true;
            ++n;
        }
        int n2 = bl3 ? this.statementLength : tokenArray.length;
        int n3 = bl3 && tokenArray.length == 1 ? 1073741853 : this.tokAt(n, tokenArray);
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        String string2 = "SPT";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        BitSet bitSet = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        int n7 = Integer.MIN_VALUE;
        if (n3 == 4 && (token = Token.getTokenFromName(ScriptVariable.sValue(tokenArray[n]))) != null) {
            n3 = token.tok;
        }
        switch (n3) {
            case 1073741974: {
                string2 = "PGRP";
                string4 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (!string4.equals("draw")) break;
                ++n;
                break;
            }
            case 135270411: {
                boolean bl7;
                string4 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (Parser.isOneOf(string4, "w;x;y;z;a;r")) {
                    ++n;
                } else {
                    string4 = "w";
                }
                string2 = ScriptVariable.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                boolean bl8 = bl7 = string2.indexOf("deriv") == 0 || string2.indexOf("diff") == 0;
                if (bl7 || string4.equals("a") || string4.equals("r")) {
                    string4 = string4 + " difference" + (string2.indexOf("2") >= 0 ? "2" : "");
                    if (bl7) {
                        string2 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                    }
                }
                if (string2.equals("draw")) {
                    string4 = string4 + " draw";
                    ++n;
                }
                string4 = "quaternion " + string4;
                string2 = "QUAT";
                break;
            }
            case 1052714: {
                string4 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (Parser.isOneOf(string4, "r;c;p")) {
                    ++n;
                } else {
                    string4 = "";
                }
                string2 = ScriptVariable.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                if (string2.equals("draw")) {
                    string4 = string4 + " draw";
                    ++n;
                }
                string4 = "ramachandran " + string4;
                string2 = "RAMA";
                break;
            }
            case 135368708: {
                string2 = "FUNCS";
                ++n;
                break;
            }
            case 0x100006: 
            case 0x8101008: {
                string2 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                string2 = "data";
                bl4 = true;
                break;
            }
            case 135271428: 
            case 1073742006: {
                string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                while (string8.equals("localpath") || string8.equals("remotepath")) {
                    if (string8.equals("localpath")) {
                        string6 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray));
                    } else {
                        string7 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray));
                    }
                    string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                }
                string2 = "SPT";
                break;
            }
            case 0x121021: {
                string2 = "MO";
                ++n;
                break;
            }
            case 135206: {
                string2 = "PMESH";
                ++n;
                break;
            }
            case 1073741931: {
                string2 = "MESH";
                ++n;
                break;
            }
            case 135197: {
                string2 = "ISO";
                ++n;
                break;
            }
            case 1610616858: {
                string2 = "HIS";
                ++n;
                break;
            }
            case 36868: {
                n += 2;
                string2 = "VAR";
                break;
            }
            case 1229984263: {
                string2 = "FILE";
                ++n;
                break;
            }
            case 4: 
            case 4116: 
            case 0x40000000: 
            case 0x40000055: {
                string2 = ScriptVariable.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                if (n3 == 0x40000055) {
                    ++n;
                } else if (n3 == 4116) {
                    if (n + 1 < n2 && tokenArray[++n].tok == 0x100001 || tokenArray[n].tok == 9) {
                        object = this.expression(tokenArray, n, 0, true, false, true, true);
                        n = this.iToken + 1;
                    } else {
                        object = this.viewer.getModelAtomBitSet(-1, false);
                    }
                    if (!this.isSyntaxCheck) {
                        bitSet = this.viewer.getModelBitSet((BitSet)object, true);
                    }
                } else if (Parser.isOneOf(string2, string.toLowerCase())) {
                    ++n;
                    string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                    bl6 = true;
                    string5 = "Jmol." + string2;
                } else if (string2.equals("menu")) {
                    ++n;
                    string2 = "MENU";
                } else if (string2.equals("zip")) {
                    string2 = "ZIP";
                    ++n;
                } else if (string2.equals("zipall")) {
                    string2 = "ZIPALL";
                    ++n;
                } else {
                    string2 = "(image)";
                }
                if (this.tokAt(n, tokenArray) != 2) break;
                n5 = ScriptVariable.iValue(this.tokenAt(n++, tokenArray));
                n6 = ScriptVariable.iValue(this.tokenAt(n++, tokenArray));
            }
        }
        string8 = ScriptVariable.sValue(this.tokenAt(n, tokenArray));
        if (string8.equalsIgnoreCase("clipboard")) {
            if (this.isSyntaxCheck) {
                return "";
            }
        } else if (Parser.isOneOf(string8.toLowerCase(), "png;jpg;jpeg;jpg64;jpeg64") && this.tokAt(n + 1, tokenArray) == 2) {
            n7 = ScriptVariable.iValue(this.tokenAt(++n, tokenArray));
        } else if (Parser.isOneOf(string8.toLowerCase(), "xyz;mol;pdb;cml")) {
            string2 = string8.toUpperCase();
            if (n + 1 == n2) {
                ++n;
            }
        }
        if (string2.equals("(image)") && Parser.isOneOf(string8.toUpperCase(), "GIF;JPG;JPG64;JPEG;JPEG64;PNG;PPM")) {
            string2 = string8.toUpperCase();
            ++n;
        }
        if (n + 2 == n2 && (string3 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray))).length() > 0 && string3.charAt(0) != '.') {
            string2 = string8.toUpperCase();
        }
        switch (this.tokAt(n, tokenArray)) {
            case 0: {
                bl5 = true;
                break;
            }
            case 4: 
            case 0x40000000: {
                string5 = ScriptVariable.sValue(this.tokenAt(n, tokenArray));
                if (n == n2 - 3 && this.tokAt(n + 1, tokenArray) == 0x100008) {
                    string5 = string5 + "." + ScriptVariable.sValue(this.tokenAt(n + 2, tokenArray));
                }
                if (string2 != "VAR" && n == 1) {
                    string2 = "image";
                } else if (string5.length() > 0 && string5.charAt(0) == '.' && (n == 2 || n == 3)) {
                    string5 = ScriptVariable.sValue(this.tokenAt(n - 1, tokenArray)) + string5;
                    if (string2 != "VAR" && n == 2) {
                        string2 = "image";
                    }
                }
                if (!string5.equalsIgnoreCase("clipboard")) break;
                string5 = null;
                break;
            }
            case 1073741853: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        if (string2.equals("image") || string2.equals("frame")) {
            string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "JPG";
            if (string2.equals("MNU")) {
                string2 = "MENU";
            } else if (string2.equals("WRL") || string2.equals("VRML")) {
                string2 = "Vrml";
                bl6 = true;
            } else if (string2.equals("X3D")) {
                string2 = "X3d";
                bl6 = true;
            } else if (string2.equals("IDTF")) {
                string2 = "Idtf";
                bl6 = true;
            } else if (string2.equals("MA")) {
                string2 = "Maya";
                bl6 = true;
            } else if (string2.equals("JVXL")) {
                string2 = "ISOX";
            } else if (string2.equals("XJVXL")) {
                string2 = "ISOX";
            } else if (string2.equals("MESH")) {
                string2 = "MESH";
            } else if (string2.equals("JMOL")) {
                string2 = "ZIPALL";
            }
        }
        if (string2.equals("data")) {
            string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
        }
        if ((bl = Parser.isOneOf(string2, "GIF;JPEG64;JPEG;JPG64;JPG;PPM;PNG")) && (bl2 && !this.viewer.isSignedApplet() || bl5)) {
            string2 = "JPG64";
        }
        if (!(bl || bl6 || Parser.isOneOf(string2, "ZIP;ZIPALL;SPT;HIS;MO;ISO;ISOX;MESH;PMESH;VAR;FILE;CML;XYZ;MENU;MOL;PDB;PGRP;QUAT;RAMA;FUNCS;"))) {
            this.error(54, "ALL|COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|ISOSURFACE|MENU|MO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|STATE|VAR x  CLIPBOARD", "JPG|JPG64|PNG|GIF|PPM|SPT|JVXL|XJVXL|MESH|PMESH|CML|XYZ|MOL|PDB|" + string.toUpperCase().replace(';', '|'));
        }
        if (this.isSyntaxCheck) {
            return "";
        }
        string3 = string2.intern();
        object = null;
        if (bl6) {
            boolean bl9 = string2.equals("Povray");
            if ((string3 = this.viewer.generateOutput(string3, bl9 ? string5 : null, n5, n6)) == null || string3.length() == 0) {
                return "";
            }
            if (bl9) {
                if (!bl3) {
                    return string3;
                }
                string5 = string3.substring(string3.indexOf("File created: ") + 14);
                string5 = string5.substring(0, string5.indexOf("\n"));
                String string9 = this.viewer.createImage((string5 = string5.substring(0, string5.lastIndexOf(" ("))) + ".ini", "ini", string3, Integer.MIN_VALUE, 0, 0, null);
                if (string9 != null) {
                    if (!string9.startsWith("OK")) {
                        this.evalError(string9, null);
                    }
                    this.scriptStatusOrBuffer("Created " + string5 + ".ini:\n\n" + string3);
                }
                return "";
            }
        } else if (string3 == "MENU") {
            string3 = this.viewer.getMenu("");
        } else if (string3 == "PGRP") {
            string3 = this.viewer.getPointGroupAsString(string4.equals("draw"), null, 0, 1.0f);
        } else if (string3 == "PDB") {
            string3 = this.viewer.getPdbData(null);
        } else if (string3 == "XYZ" || string3 == "MOL" || string3 == "CML") {
            string3 = this.viewer.getData("selected", string3);
        } else if (string3 == "QUAT" || string3 == "RAMA") {
            int n8 = this.viewer.getCurrentModelIndex();
            if (n8 < 0) {
                this.error(30, "write " + string4);
            }
            string3 = this.viewer.getPdbData(n8, string4);
            string2 = "PDB";
        } else if (string3 == "FUNCS") {
            string3 = this.viewer.getFunctionCalls(null);
            string2 = "TXT";
        } else if (string3 == "FILE") {
            if (bl5) {
                string3 = this.viewer.getCurrentFileAsString();
            } else {
                object = this.viewer.getCurrentFileAsBytes();
            }
            if ("?".equals(string5)) {
                string5 = "?Jmol." + this.viewer.getParameter("_fileType");
            }
            n7 = Integer.MIN_VALUE;
        } else if (string3 == "VAR") {
            string3 = ScriptVariable.sValue((ScriptVariable)this.getParameter(ScriptVariable.sValue(this.tokenAt(bl3 ? 2 : 1, tokenArray)), true));
            string2 = "TXT";
        } else if (string3 == "SPT") {
            if (bl4) {
                BitSet bitSet2 = this.viewer.getTaintedAtoms((byte)2);
                this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f), null);
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                this.viewer.setTaintedAtoms(bitSet2, (byte)2);
            } else {
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                if (string6 != null || string7 != null) {
                    string3 = FileManager.setScriptFileReferences(string3, string6, string7, null);
                }
            }
        } else if (string3 == "ZIP" || string3 == "ZIPALL") {
            string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
            object = this.viewer.createImage(string5, string2, string3, Integer.MIN_VALUE, -1, -1);
        } else if (string3 == "HIS") {
            string3 = this.viewer.getSetHistory(Integer.MAX_VALUE);
            string2 = "SPT";
        } else if (string3 == "MO") {
            string3 = this.getMoJvxl(Integer.MAX_VALUE);
            string2 = "XJVXL";
        } else if (string3 == "PMESH") {
            string3 = this.getIsosurfaceJvxl(true, 26);
            if (string3 == null) {
                this.error(31);
            }
            string2 = "XJVXL";
        } else if (string3 == "ISO" || string3 == "ISOX" || string3 == "MESH") {
            if ((string3 = this.getIsosurfaceJvxl(string3 == "MESH", 23)) == null) {
                this.error(31);
            }
            String string10 = string2 = string3.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
            if (!bl5) {
                this.showString((String)this.viewer.getShapeProperty(23, "jvxlFileInfo"));
            }
        } else {
            n4 = -1;
            if (n7 < 0) {
                n7 = -1;
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        if (n4 == 0) {
            int n9 = object == null ? string3.length() : (n4 = object instanceof String ? ((String)object).length() : ((byte[])object).length);
        }
        if (bl) {
            this.refresh();
            if (n5 < 0) {
                n5 = this.viewer.getScreenWidth();
            }
            if (n6 < 0) {
                n6 = this.viewer.getScreenHeight();
            }
        }
        if (!bl3) {
            return string3;
        }
        if (bl5) {
            this.showString(string3);
        } else if (object != null && object instanceof String) {
            this.scriptStatusOrBuffer((String)object);
        } else {
            String string11;
            if (!(object != null || bl && string5 == null)) {
                object = string3;
            }
            if ((string11 = this.viewer.createImage(string5, string2, object, n7, n5, n6, bitSet)) != null) {
                if (!string11.startsWith("OK")) {
                    this.evalError(string11, null);
                }
                this.scriptStatusOrBuffer(string11 + (bl ? "; width=" + n5 + "; height=" + n6 : ""));
            }
        }
        return "";
    }

    private void show() throws ScriptException {
        int n;
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        String string4 = null;
        int n2 = 2;
        Token token = this.getToken(1);
        int n3 = n = token instanceof ScriptVariable ? 0 : token.tok;
        if (n == 4 && (token = Token.getTokenFromName(string2)) != null) {
            n = token.tok;
        }
        if (n != 1297090050 || this.statementLength <= 3) {
            this.checkLength(-3);
        }
        if (this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        block0 : switch (n) {
            case 0: {
                string3 = Escape.escape(((ScriptVariable)this.theToken).value);
                break;
            }
            case 1297090050: {
                int n4;
                if (this.statementLength > 3) {
                    Point3f point3f = this.centerParameter(2);
                    Point3f point3f2 = this.centerParameter(++this.iToken);
                    if (!this.isSyntaxCheck) {
                        string3 = this.viewer.getSymmetryOperation(null, 0, point3f, point3f2);
                    }
                    n2 = ++this.iToken;
                    break;
                }
                int n5 = n4 = this.checkLength23() == 2 ? 0 : this.intParameter(2);
                if (!this.isSyntaxCheck) {
                    string3 = this.viewer.getSymmetryOperation(null, n4, null, null);
                }
                n2 = -3;
                break;
            }
            case 1112541205: {
                if (this.statementLength == 2) {
                    if (!this.isSyntaxCheck) {
                        this.showString(this.viewer.getDefaultVdwTypeNameOrData(-1));
                    }
                    return;
                }
                int n6 = JmolConstants.getVdwType(this.parameterAsString(2));
                if (n6 == -1) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getDefaultVdwTypeNameOrData(n6));
                }
                return;
            }
            case 135368708: {
                this.checkLength23();
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 1085443: {
                this.checkLength(2);
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 1074790598: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                string4 = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 1632638983: {
                string2 = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 1052714: 
            case 135270411: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n7 = this.viewer.getCurrentModelIndex();
                if (n7 < 0) {
                    this.error(30, "show " + this.theToken.value);
                }
                string3 = this.viewer.getPdbData(n7, this.theTok == 135270411 ? "quaternion w" : "ramachandran");
                break;
            }
            case 1113200654: {
                if (this.isSyntaxCheck) break;
                string3 = this.getContext(false);
                break;
            }
            case 0x40000020: {
                string4 = this.optParameterAsString(2);
                if (string4.length() > 0) {
                    n2 = 3;
                }
                if (this.isSyntaxCheck) break;
                string = this.viewer.getColorSchemeList(string4, true);
                break;
            }
            case 1073742026: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getTrajectoryInfo();
                break;
            }
            case 553648149: {
                string = "" + this.commandHistoryLevelMax;
                break;
            }
            case 553648150: {
                string = "" + Viewer.getLogLevel();
                break;
            }
            case 603979824: {
                string = "" + this.viewer.getDebugScript();
                break;
            }
            case 553648178: {
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 536875070: {
                n2 = this.statementLength;
                string3 = this.viewer.showTimeout(n2 == 2 ? null : this.parameterAsString(2));
                break;
            }
            case 0x20000006: {
                string = Escape.escape(this.viewer.getDefaultLattice());
                break;
            }
            case 4128: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.viewer.getAxesMode()) {
                    case 2: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case 0: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 0x60000001: {
                string3 = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 1650071565: {
                if (this.isSyntaxCheck) break;
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 1612189721: {
                string3 = "set hbondsBackbone " + this.viewer.getHbondsBackbone() + ";set hbondsSolid " + this.viewer.getHbondsSolid();
                break;
            }
            case 1611141175: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpinState();
                break;
            }
            case 1611141176: {
                string3 = "set ssbondsBackbone " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 1610625028: 
            case 1611141171: {
                string3 = "selectionHalos " + (this.viewer.getSelectionHaloEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x60300003: {
                string3 = "set selectHetero " + this.viewer.getRasmolSetting(n);
                break;
            }
            case 0x40000002: {
                string3 = Escape.escapeArray(this.viewer.getAdditionalHydrogens(null, true, true));
                break;
            }
            case 1613758468: {
                string3 = "set selectHydrogens " + this.viewer.getRasmolSetting(n);
                break;
            }
            case 0x2000000A: 
            case 0x21000002: 
            case 553648142: 
            case 553648172: 
            case 553648176: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 4146: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 1614417984: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 0x100006: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCoordinateState(this.viewer.getSelectionSet());
                    break;
                }
                String string5 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedCoordinates(string5);
                break;
            }
            case 1073742006: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                string4 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedState(string4);
                break;
            }
            case 1104154627: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getProteinStructureState();
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedStructure(string6);
                break;
            }
            case 0x8101008: {
                Object[] objectArray;
                String string7;
                n2 = this.statementLength;
                String string8 = string7 = n2 == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] objectArray2 = objectArray = string7 == null ? this.data : this.viewer.getData(string7);
                string3 = objectArray == null ? "no data" : "data \"" + objectArray[0] + "\"\n" + (objectArray[1] instanceof float[] ? Escape.escape((float[])objectArray[1], true) : (objectArray[1] instanceof float[][] ? Escape.escape((float[][])objectArray[1], false) : "" + objectArray[1])) + "\nend \"" + objectArray[0] + "\";";
                break;
            }
            case 1073742003: {
                Hashtable hashtable = null;
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (!this.isSyntaxCheck) {
                        hashtable = this.viewer.getSpaceGroupInfo(null);
                    }
                } else {
                    String string9 = this.parameterAsString(2);
                    if (!this.isSyntaxCheck) {
                        hashtable = this.viewer.getSpaceGroupInfo(TextFormat.simpleReplace(string9, "''", "\""));
                    }
                }
                if (hashtable == null) break;
                string3 = "" + hashtable.get("spaceGroupInfo") + hashtable.get("symmetryInfo");
                break;
            }
            case 0x100007: {
                n2 = 3;
                string3 = this.setObjectProperty();
                break;
            }
            case 1679429641: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.isSyntaxCheck) break;
                string3 = "center " + Escape.escape(this.viewer.getRotationCenter());
                break;
            }
            case 135184: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(22, "command");
                break;
            }
            case 1229984263: {
                if (this.statementLength == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCurrentFileAsString();
                    break;
                }
                n2 = 3;
                string = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 4116: {
                if (this.tokAt(2) == 0x100003) {
                    n2 = 3;
                    if (3 > 0) {
                        string3 = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                string3 = this.viewer.getModelFileInfo();
                break;
            }
            case 1610616858: {
                int n8;
                n2 = this.statementLength;
                int n9 = n8 = n2 == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n8 < 1) {
                    this.error(22);
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                string3 = this.viewer.getSetHistory(n8);
                break;
            }
            case 135197: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(23, "jvxlDataXml");
                break;
            }
            case 0x121021: {
                int n10;
                if (this.optParameterAsString(2).equalsIgnoreCase("list")) {
                    string3 = this.viewer.getMoInfo(-1);
                    n2 = 3;
                    break;
                }
                n2 = this.statementLength;
                int n11 = n10 = n2 == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                string3 = this.getMoJvxl(n10);
                break;
            }
            case 1095766028: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 537006111: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 4132: 
            case 1073741991: 
            case 1073742019: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getOrientationText(n, null);
                break;
            }
            case 1073741961: {
                n2 = 2;
                if (this.statementLength > 3) break;
                n = this.tokAt(2);
                switch (n) {
                    case 0: 
                    case 4132: 
                    case 1073741991: 
                    case 1073742019: {
                        if (this.isSyntaxCheck) break;
                        string3 = this.viewer.getOrientationText(n, null);
                        break;
                    }
                    default: {
                        string4 = this.optParameterAsString(2);
                        string3 = this.viewer.getOrientationText(0, string4);
                    }
                }
                n2 = this.statementLength;
                break;
            }
            case 1073741966: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 1073741974: {
                this.pointGroup();
                return;
            }
            case 1089470477: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 1073742018: {
                if (this.isSyntaxCheck) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 4168: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomSetting() : "off");
                break;
            }
            case 1611272213: {
                string3 = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1666189313: {
                string2 = "solventProbeRadius";
                break;
            }
            case 1073741911: 
            case 1073741985: 
            case 0x40D00004: 
            case 1087373318: 
            case 1087373320: 
            case 1114638350: 
            case 0x44100001: 
            case 1678770178: {
                string3 = this.viewer.getChimeInfo(n);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1613758475: 
            case 1716520973: {
                string = "?";
                break;
            }
            case 0x40000000: {
                String string10;
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (string2.equalsIgnoreCase("menu")) {
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getMenu("");
                    break;
                }
                if (!string2.equalsIgnoreCase("mouse")) break;
                n2 = this.statementLength;
                String string11 = string10 = n2 == 2 ? null : this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBindingInfo(string10);
            }
        }
        this.checkLength(n2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            if (string2.indexOf(" ") >= 0) {
                this.showString(string2);
            } else {
                this.showString(string2 + " = " + this.getParameterEscaped(string2));
            }
        }
    }

    private String getIsosurfaceJvxl(boolean bl, int n) {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.viewer.getShapeProperty(n, bl ? "jvxlMeshXml" : "jvxlDataXml");
    }

    private String getMoJvxl(int n) throws ScriptException {
        Integer n2;
        Hashtable hashtable;
        this.viewer.loadShape(25);
        int n3 = this.viewer.getCurrentModelIndex();
        if (n3 < 0) {
            this.error(30, "MO isosurfaces");
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n3, "moData")) == null) {
            this.error(27);
        }
        if ((n2 = (Integer)this.viewer.getShapeProperty(25, "moNumber")) == null || n2 == 0) {
            this.setShapeProperty(25, "init", new Integer(n3));
            this.setShapeProperty(25, "moData", hashtable);
        } else if (n == Integer.MAX_VALUE) {
            // empty if block
        }
        return (String)this.viewer.getShapeProperty(25, "showMO", n);
    }

    private String extractCommandOption(String string) {
        int n = this.fullCommand.indexOf(string + "=");
        return n < 0 ? null : Parser.getNextQuotedString(this.fullCommand, n);
    }

    private void draw() throws ScriptException {
        this.viewer.loadShape(22);
        switch (this.tokAt(1)) {
            case 6: {
                if (!this.listIsosurface(22)) break;
                return;
            }
            case 1073741974: {
                this.pointGroup();
                return;
            }
            case 135270411: {
                this.dataFrame(1);
                return;
            }
            case 137363471: {
                this.dataFrame(1);
                return;
            }
            case 1052714: {
                this.dataFrame(0);
                return;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        String string = "";
        int n4 = 0;
        Point3f point3f = null;
        String string2 = this.initIsosurface(22);
        boolean bl7 = string2 != null;
        boolean bl8 = bl7 && this.viewer.getShapeProperty(22, "ID") == null;
        block61: for (int i = this.iToken; i < this.statementLength; ++i) {
            String string3 = null;
            Vector<Object> vector = null;
            switch (this.getToken((int)i).tok) {
                case 1614417984: 
                case 1679429641: {
                    if (this.isSyntaxCheck) break;
                    Vector vector2 = this.viewer.getPlaneIntersection(this.theTok, null, (float)n3 / 100.0f, 0);
                    n3 = 0;
                    if (vector2 == null) continue block61;
                    string3 = "polygon";
                    vector = vector2;
                    bl = true;
                    break;
                }
                case 1073741915: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1614417984: 
                        case 1679429641: {
                            n = this.theTok;
                            bl5 = true;
                            continue block61;
                        }
                        case 0x100007: {
                            string3 = "intersect";
                            vector = this.objectNameParameter(++i);
                            i = this.iToken;
                            bl5 = true;
                            bl = true;
                            break;
                        }
                        default: {
                            this.error(22);
                            break;
                        }
                    }
                    break;
                }
                case 1073741976: {
                    int n5 = this.intParameter(++i);
                    Point3f[] point3fArray = new Point3f[n5];
                    for (int j = 0; j < n5; ++j) {
                        point3fArray[j] = this.getPoint3f(++this.iToken, true);
                        i = this.iToken;
                    }
                    Vector<Object> vector3 = new Vector<Object>();
                    vector3.add(point3fArray);
                    int n6 = this.intParameter(++i);
                    int[][] nArrayArray = new int[n6][];
                    for (int j = 0; j < n6; ++j) {
                        float[] fArray = this.floatParameterSet(++i, 3, 4);
                        nArrayArray[j] = new int[]{(int)fArray[0], (int)fArray[1], (int)fArray[2], fArray.length == 3 ? 7 : (int)fArray[3]};
                        i = this.iToken;
                    }
                    vector3.add(nArrayArray);
                    string3 = "polygon";
                    vector = vector3;
                    bl = true;
                    break;
                }
                case 1297090050: {
                    String string4 = null;
                    int n7 = 0;
                    Point4f point4f = null;
                    Point3f point3f2 = null;
                    switch (this.tokAt(++i)) {
                        case 4: {
                            string4 = this.stringParameter(i);
                            break;
                        }
                        case 11: {
                            string4 = ScriptVariable.sValue(this.getToken(i));
                            break;
                        }
                        default: {
                            if (!this.isCenterParameter(i)) {
                                n7 = this.intParameter(i++);
                            }
                            if (this.isCenterParameter(i)) {
                                point3f = this.centerParameter(i);
                            }
                            if (this.isCenterParameter(this.iToken + 1)) {
                                point3f2 = this.centerParameter(++this.iToken);
                            }
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            i = this.iToken;
                        }
                    }
                    BitSet bitSet = null;
                    if (point3f == null && i + 1 < this.statementLength) {
                        point3f = this.centerParameter(++i);
                        bitSet = this.tokAt(i) == 9 || this.tokAt(i) == 0x100001 ? this.expression(i) : null;
                        i = this.iToken + 1;
                    }
                    this.checkLast(this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.runScript((String)this.viewer.getSymmetryInfo(bitSet, string4, n7, point3f, point3f2, string2, 135184));
                    }
                    return;
                }
                case 4116: {
                    bl6 = true;
                    continue block61;
                }
                case 7: 
                case 8: 
                case 0x10000A: {
                    if (this.theTok == 8 || !this.isPoint3f(i)) {
                        vector = this.getPoint4f(i);
                        if (bl6) {
                            this.checkLast(this.iToken);
                            if (!this.isSyntaxCheck) {
                                this.runScript(new Quaternion((Point4f)((Object)vector)).draw(string2 == null ? "frame" : string2, " " + string, point3f == null ? new Point3f() : point3f, (float)n3 / 100.0f));
                            }
                            return;
                        }
                        string3 = "planedef";
                    } else {
                        point3f = this.getPoint3f(i, true);
                        vector = point3f;
                        string3 = "coord";
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 135266313: 
                case 135267842: {
                    Serializable serializable;
                    if (!bl && !bl5 && n == 0 && this.theTok != 135267842) {
                        string3 = "plane";
                        break;
                    }
                    Point4f point4f = this.theTok == 135266313 ? this.planeParameter(++i) : this.hklParameter(++i);
                    i = this.iToken;
                    if (n != 0) {
                        if (this.isSyntaxCheck) break;
                        serializable = this.viewer.getPlaneIntersection(n, point4f, (float)n3 / 100.0f, 0);
                        n3 = 0;
                        if (serializable == null) continue block61;
                        string3 = "polygon";
                        vector = serializable;
                    } else {
                        vector = point4f;
                        string3 = "planedef";
                    }
                    bl = true;
                    break;
                }
                case 1073741921: {
                    string3 = "lineData";
                    vector = (Vector<Object>)this.floatParameterSet(++i, 0, Integer.MAX_VALUE);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 9: 
                case 0x100001: {
                    string3 = "atomSet";
                    vector = this.expression(i);
                    if (bl6) {
                        point3f = this.centerParameter(i);
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 6: {
                    string3 = "modelBasedPoints";
                    vector = this.theToken.value;
                    bl = true;
                    break;
                }
                case 0x10100030: {
                    break;
                }
                case 0x10100040: {
                    vector = this.xypParameter(i);
                    if (vector != null) {
                        i = this.iToken;
                        string3 = "coord";
                        bl = true;
                        break;
                    }
                    if (bl3) {
                        this.error(22);
                    }
                    bl3 = true;
                    break;
                }
                case 0x10100041: {
                    if (!bl3) {
                        this.error(22);
                    }
                    bl3 = false;
                    break;
                }
                case 1141899269: {
                    string3 = "reverse";
                    break;
                }
                case 4: {
                    vector = this.stringParameter(i);
                    string3 = "title";
                    break;
                }
                case 135233: {
                    string3 = "vector";
                    break;
                }
                case 1141899267: {
                    vector = new Float(this.floatParameter(++i));
                    string3 = "length";
                    break;
                }
                case 3: {
                    vector = new Float(this.floatParameter(i));
                    string3 = "length";
                    break;
                }
                case 1095761933: {
                    string3 = "modelIndex";
                    vector = new Integer(this.intParameter(++i));
                    break;
                }
                case 2: {
                    if (bl3) {
                        string3 = "modelIndex";
                        vector = new Integer(this.intParameter(i));
                        break;
                    }
                    n3 = this.intParameter(i);
                    break;
                }
                case 1073741995: {
                    if (++i >= this.statementLength) {
                        this.error(34);
                    }
                    switch (this.getToken((int)i).tok) {
                        case 2: {
                            n3 = this.intParameter(i);
                            continue block61;
                        }
                        case 3: {
                            n3 = (int)(this.floatParameter(i) * 100.0f);
                            continue block61;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1074790483: {
                    string2 = this.setShapeId(22, ++i, bl7);
                    bl8 = this.viewer.getShapeProperty(22, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 0x40000070: {
                    string3 = "fixed";
                    vector = Boolean.FALSE;
                    break;
                }
                case 0x40000042: {
                    string3 = "fixed";
                    vector = Boolean.TRUE;
                    break;
                }
                case 1073741955: {
                    Serializable serializable = this.getPoint3f(++i, true);
                    i = this.iToken;
                    string3 = "offset";
                    vector = serializable;
                    break;
                }
                case 1073741865: {
                    string3 = "crossed";
                    break;
                }
                case 1073742030: {
                    vector = new Float(this.floatParameter(++i));
                    string3 = "width";
                    string = string3 + " " + vector;
                    break;
                }
                case 0x40000060: {
                    string3 = "line";
                    vector = Boolean.TRUE;
                    break;
                }
                case 1073741866: {
                    string3 = "curve";
                    break;
                }
                case 1074790409: {
                    string3 = "arc";
                    break;
                }
                case 0x4000000C: {
                    string3 = "arrow";
                    break;
                }
                case 1073741851: {
                    string3 = "circle";
                    break;
                }
                case 1073741868: {
                    string3 = "cylinder";
                    break;
                }
                case 1073742027: {
                    string3 = "vertices";
                    break;
                }
                case 1073741946: {
                    string3 = "nohead";
                    break;
                }
                case 1073741990: {
                    string3 = "rotate45";
                    break;
                }
                case 1073741969: {
                    string3 = "perp";
                    break;
                }
                case 1073741874: {
                    float f2 = this.floatParameter(++i);
                    vector = new Float(f2);
                    string3 = this.tokAt(i) == 3 ? "width" : "diameter";
                    string = string3 + (this.tokAt(i) == 3 ? " " + f2 : " " + (int)f2);
                    break;
                }
                case 0x100007: {
                    if (this.tokAt(i + 2) == 0x10100040 || bl6) {
                        Point3f point3f3 = point3f = this.centerParameter(i);
                        i = this.iToken;
                        string3 = "coord";
                        vector = point3f3;
                        bl = true;
                        break;
                    }
                    vector = this.objectNameParameter(++i);
                    string3 = "identifier";
                    bl = true;
                    break;
                }
                case 1073741959: 
                case 0x400000C4: 
                case 1632638983: {
                    if (this.theTok != 1632638983) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 0x400000C4) {
                        bl4 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073741959) {
                        ++i;
                        bl4 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(++i);
                        i = this.iToken;
                    } else if (!bl4) {
                        this.error(22);
                    }
                    bl7 = true;
                    continue block61;
                }
                default: {
                    if (!this.setMeshDisplayProperty(22, 0, this.theTok)) {
                        if (this.theTok == 0x101000A1 || Token.tokAttr(this.theTok, 0x40000000)) {
                            string2 = this.setShapeId(22, i, bl7);
                            i = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n4 == 0) {
                        n4 = i;
                    }
                    i = this.iToken;
                    continue block61;
                }
            }
            boolean bl9 = bl7 = this.theTok != 12291;
            if (bl && !bl2 && !bl6) {
                this.setShapeProperty(22, "points", new Integer(n3));
                bl2 = true;
                n3 = 0;
            }
            if (bl && bl8) {
                this.error(22);
            }
            if (string3 == null) continue;
            this.setShapeProperty(22, string3, vector);
        }
        if (bl) {
            this.setShapeProperty(22, "set", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(22, "color", new Integer(n2));
        }
        if (bl4) {
            this.setShapeTranslucency(22, "", "translucent", f, null);
        }
        if (n3 != 0) {
            this.setShapeProperty(22, "scale", new Integer(n3));
        }
        if (n4 > 0 && !this.setMeshDisplayProperty(22, n4, this.getToken((int)n4).tok)) {
            this.error(22);
        }
    }

    private void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        this.viewer.loadShape(21);
        this.setShapeProperty(21, "init", null);
        String string = "centers";
        String string2 = "radius_";
        boolean bl6 = false;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        block14: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                n2 = this.getArgbParam(i);
                i = this.iToken;
                continue;
            }
            String string3 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 12291: 
                case 0x10000C: 
                case 0x10000D: {
                    if (i + 1 != this.statementLength || bl || n > 1 || n == 0 && string == "to") {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl2 = true;
                    break;
                }
                case 0x10100030: 
                case 269484420: {
                    continue block14;
                }
                case 1678770178: {
                    if (n > 0) {
                        this.error(23);
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 1666189313: {
                    string2 = "radius";
                    continue block14;
                }
                case 2: 
                case 3: {
                    if (n > 0 && !bl5) {
                        this.error(23);
                    }
                    if (this.theTok == 2 && string2 == "radius_") {
                        string3 = "nVertices";
                        object = new Integer(this.intParameter(i));
                        bl = true;
                        break;
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = new Float(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 9: 
                case 0x100001: {
                    if (bl3) {
                        this.error(23);
                    }
                    if (++n > 2) {
                        this.error(2);
                    }
                    if (string == "to") {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.expression(i);
                    i = this.iToken;
                    break;
                }
                case 1074790588: {
                    if (n > 1) {
                        this.error(23);
                    }
                    if (this.getToken((int)(i + 1)).tok == 9) {
                        string3 = "toBitSet";
                        object = this.getToken((int)(++i)).value;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.error(19);
                    }
                    string = "to";
                    continue block14;
                }
                case 1073741886: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "faceCenterOffset";
                    bl5 = true;
                    continue block14;
                }
                case 1073741879: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "distanceFactor";
                    bl5 = true;
                    continue block14;
                }
                case 1073741959: 
                case 0x400000C4: 
                case 1632638983: {
                    bl6 = false;
                    if (this.theTok != 1632638983) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 0x400000C4) {
                        ++i;
                        bl6 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.getTranslucentLevel(i);
                        }
                    } else if (this.tokAt(i + 1) == 1073741959) {
                        ++i;
                        bl6 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(i);
                        i = this.iToken;
                        continue block14;
                    }
                    if (bl6) continue block14;
                    this.error(22);
                    continue block14;
                }
                case 1073741855: 
                case 0x40000044: {
                    string3 = "collapsed";
                    Object object2 = object = this.theTok == 1073741855 ? Boolean.TRUE : Boolean.FALSE;
                    if (bl3) {
                        this.error(18);
                    }
                    bl3 = true;
                    break;
                }
                case 1073741884: 
                case 0x40000048: 
                case 1073741944: {
                    if (bl4) {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl4 = true;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            this.setShapeProperty(21, string3, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4)) {
            this.error(19);
        }
        if (bl) {
            this.setShapeProperty(21, "generate", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", new Integer(n2));
        }
        if (bl6) {
            this.setShapeTranslucency(21, "", "translucent", f, null);
        }
    }

    private void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(24);
        if (this.tokAt(1) == 6 && this.listIsosurface(24)) {
            return;
        }
        this.setShapeProperty(24, "init", this.fullCommand);
        if (this.statementLength == 1) {
            this.setShapeProperty(24, "lcaoID", null);
            return;
        }
        boolean bl = false;
        String string = null;
        block25: for (int i = 1; i < this.statementLength; ++i) {
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 528437: 
                case 1074790424: {
                    string2 = (String)this.theToken.value;
                    if (this.tokAt(i + 1) == 0x10000C) {
                        this.iToken = i + 1;
                    } else {
                        object = this.getCapSlabObject(i);
                    }
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    this.isosurface(24);
                    return;
                }
                case 528432: {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541210: {
                            f = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541211: {
                            f2 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541212: {
                            f3 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    string2 = "rotationAxis";
                    object = new Vector3f(f, f2, f3);
                    break;
                }
                case 0x10000D: 
                case 3145751: 
                case 1610625028: {
                    string2 = "on";
                    break;
                }
                case 12293: 
                case 0x10000C: 
                case 3145752: {
                    string2 = "off";
                    break;
                }
                case 12291: {
                    string2 = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "scale";
                    object = new Float(this.floatParameter(++i));
                    break;
                }
                case 9: 
                case 0x100001: {
                    string2 = "select";
                    object = this.expression(i);
                    i = this.iToken;
                    break;
                }
                case 1632638983: {
                    string = this.setColorOptions(i + 1, 24, -2);
                    if (string != null) {
                        this.setShapeProperty(24, "settranslucency", string);
                    }
                    i = this.iToken;
                    bl = true;
                    continue block25;
                }
                case 1073741959: 
                case 0x400000C4: {
                    this.setMeshDisplayProperty(24, i, this.theTok);
                    i = this.iToken;
                    bl = true;
                    continue block25;
                }
                case 4: 
                case 1113200651: {
                    object = this.parameterAsString(i).toLowerCase();
                    if (object.equals("spacefill")) {
                        object = "cpk";
                    }
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 135280129: {
                    if (this.tokAt(i + 1) == 9 || this.tokAt(i + 1) == 0x100001) {
                        string2 = "select";
                        object = this.expression(i + 1);
                        i = this.iToken;
                        break;
                    }
                    string2 = "selectType";
                    if (!(object = this.parameterAsString(++i)).equals("spacefill")) break;
                    object = "cpk";
                    break;
                }
                case 1073741995: {
                    string2 = "scale";
                    object = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073741923: 
                case 0x40000064: {
                    string2 = "lonePair";
                    break;
                }
                case 1073741980: 
                case 1073741981: {
                    string2 = "radical";
                    break;
                }
                case 1073741937: {
                    string2 = "molecular";
                    break;
                }
                case 1073741864: {
                    object = this.parameterAsString(++i);
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 1074790483: {
                    object = this.getShapeNameParameter(++i);
                    i = this.iToken;
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                    break;
                }
                default: {
                    if (this.theTok != 0x101000A1 && !Token.tokAttr(this.theTok, 0x40000000)) break;
                    if (this.theTok != 0x101000A1) {
                        object = this.parameterAsString(i);
                    }
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                }
            }
            if (this.theTok != 12291) {
                bl = true;
            }
            if (string2 == null) {
                this.error(22);
            }
            this.setShapeProperty(24, string2, object);
        }
        this.setShapeProperty(24, "clear", null);
    }

    private Object getCapSlabObject(int n) throws ScriptException {
        Object object = null;
        if (this.tokAt(n + 1) == 1679429641) {
            object = BoxInfo.getCriticalPoints(this.viewer.getBoundBoxVertices(), null);
            this.iToken = n + 1;
        } else if (this.tokAt(n + 1) == 1614417984) {
            SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
            if (symmetryInterface == null) {
                this.error(22);
            }
            object = BoxInfo.getCriticalPoints(symmetryInterface.getUnitCellVertices(), symmetryInterface.getCartesianOffset());
            this.iToken = n + 1;
        } else {
            float f;
            Point4f point4f = this.planeParameter(++n);
            float f2 = f = this.isFloatParameter(this.iToken + 1) ? this.floatParameter(++this.iToken) : Float.NaN;
            if (!Float.isNaN(f)) {
                point4f.w -= f;
            }
            object = point4f;
        }
        return object;
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = Integer.MAX_VALUE;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        Vector vector = new Vector();
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            this.viewer.loadShape(25);
            if (this.tokAt(1) == 6 && this.listIsosurface(25)) {
                return true;
            }
            this.setShapeProperty(25, "init", new Integer(n2));
            String string = null;
            int n3 = (Integer)this.viewer.getShapeProperty(25, "moNumber");
            if (bl) {
                return true;
            }
            if (n3 == 0) {
                n3 = Integer.MAX_VALUE;
            }
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)1).tok) {
                case 2: {
                    n3 = this.intParameter(1);
                    break;
                }
                case 1073741939: {
                    n3 = 1073741939;
                    break;
                }
                case 1073741978: {
                    n3 = 1073741978;
                    break;
                }
                case 1632638983: {
                    this.setColorOptions(2, 25, 2);
                    break;
                }
                case 135266313: {
                    string2 = "plane";
                    object = this.planeParameter(2);
                    break;
                }
                case 1073741995: {
                    string2 = "scale";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                case 1073741867: {
                    if (this.tokAt(2) == 0x10100091) {
                        string2 = "cutoffPositive";
                        object = new Float(this.floatParameter(3));
                        break;
                    }
                    string2 = "cutoff";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                case 0x20000004: {
                    string2 = "debug";
                    break;
                }
                case 1073741949: {
                    string2 = "plane";
                    break;
                }
                case 1073741975: 
                case 1073741986: {
                    string2 = "resolution";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                case 1073742005: {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                case 0x400000BB: {
                    if (2 >= this.statementLength || this.tokAt(2) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(2);
                    break;
                }
                case 1073741906: 
                case 1073741925: {
                    n = this.moOffset(1);
                    if (n == Integer.MAX_VALUE) {
                        this.error(22);
                    }
                    n3 = 0;
                    break;
                }
                case 0x40000000: {
                    this.error(22);
                }
                default: {
                    int n4 = this.iToken;
                    if (!this.setMeshDisplayProperty(25, 0, this.theTok)) {
                        this.error(22);
                    }
                    this.setShapeProperty(25, "setProperties", vector);
                    this.setMeshDisplayProperty(25, n4, this.tokAt(n4));
                    return true;
                }
            }
            if (string2 != null) {
                this.addShapeProperty(vector, string2, object);
            }
            if (n3 != Integer.MAX_VALUE) {
                if (this.tokAt(2) == 4) {
                    string = this.parameterAsString(2);
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setCursor(4);
                }
                this.setMoData(vector, n3, n, n2, string);
                this.addShapeProperty(vector, "finalize", null);
                this.setShapeProperty(25, "setProperties", vector);
            }
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return true;
    }

    private String setColorOptions(int n, int n2, int n3) throws ScriptException {
        this.getToken(n);
        String string = "opaque";
        if (this.theTok == 0x400000C4) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.setShapeTranslucency(n2, null, "translucent", f, null);
            } else {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else if (this.theTok == 1073741959) {
            if (n3 >= 0) {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else {
            --this.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                this.setShapeProperty(n2, "colorRGB", new Integer(this.getArgbParam(++this.iToken)));
                continue;
            }
            if (this.iToken >= n) break;
            this.error(22);
        }
        return string;
    }

    private int moOffset(int n) throws ScriptException {
        int n2;
        boolean bl = this.getToken((int)n).tok == 1073741906;
        int n3 = Integer.MAX_VALUE;
        n3 = bl ? 0 : 1;
        if ((n2 = this.tokAt(++n)) == 2 && this.intParameter(n) < 0) {
            n3 += this.intParameter(n);
        } else if (n2 == 0x10100091) {
            n3 += this.intParameter(++n);
        } else if (n2 == 0x10100090) {
            n3 -= this.intParameter(++n);
        }
        return n3;
    }

    private void setMoData(Vector vector, int n, int n2, int n3, String string) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        if (n3 < 0 && (n3 = this.viewer.getCurrentModelIndex()) < 0) {
            this.error(30, "MO isosurfaces");
        }
        Hashtable hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n3, "jmolSurfaceInfo");
        int n4 = n;
        if (hashtable == null || !((String)hashtable.get("surfaceDataType")).equals("mo")) {
            int n5;
            int n6;
            hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n3, "moData");
            if (hashtable == null) {
                this.error(27);
            }
            int n7 = n6 = hashtable.containsKey("lastMoNumber") ? (Integer)hashtable.get("lastMoNumber") : 0;
            if (n == 1073741978) {
                n = n6 - 1;
            } else if (n == 1073741939) {
                n = n6 + 1;
            }
            Vector vector2 = (Vector)hashtable.get("mos");
            int n8 = n5 = vector2 == null ? 0 : vector2.size();
            if (n5 == 0) {
                this.error(25);
            }
            if (n5 == 1 && n > 1) {
                this.error(29);
            }
            if (n2 != Integer.MAX_VALUE) {
                if (hashtable.containsKey("HOMO")) {
                    n = (Integer)hashtable.get("HOMO") + n2;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        Hashtable hashtable2 = (Hashtable)vector2.get(i);
                        if (!hashtable2.containsKey("occupancy")) {
                            this.error(28);
                        }
                        if (((Float)hashtable2.get("occupancy")).floatValue() != 0.0f) continue;
                        n = i + n2;
                        break;
                    }
                }
                Logger.info("MO " + n);
            }
            if (n < 1 || n > n5) {
                this.error(26, "" + n5);
            }
        }
        hashtable.put("lastMoNumber", new Integer(n));
        this.addShapeProperty(vector, "moData", hashtable);
        if (string != null) {
            this.addShapeProperty(vector, "title", string);
        }
        if (n4 < 0) {
            this.addShapeProperty(vector, "charges", this.viewer.getAtomicCharges());
        }
        this.addShapeProperty(vector, "molecularOrbital", new Integer(n4 < 0 ? -n : n));
        this.addShapeProperty(vector, "clear", null);
    }

    private String initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.fullCommand);
        this.iToken = 0;
        if (this.tokAt(1) == 12291 || this.tokAt(2) == 12291 && this.tokAt(++this.iToken) == 0x100003) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(n, "init", this.fullCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return null;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, this.tokAt(1))) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 22) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
            if (this.tokAt(2) == 0x101000A1 && this.tokAt(1) != 1074790483) {
                String string = this.setShapeId(n, 1, false);
                ++this.iToken;
                return string;
            }
        }
        return null;
    }

    private String getNextComment() {
        String string = this.getCommand(this.pc + 1, false, true);
        return string.startsWith("#") ? string : "";
    }

    private boolean listIsosurface(int n) throws ScriptException {
        if (this.getToken((int)1).value instanceof String[]) {
            return false;
        }
        this.checkLength(2);
        if (!this.isSyntaxCheck) {
            this.showString((String)this.viewer.getShapeProperty(n, "list"));
        }
        return true;
    }

    private void isosurface(int n) throws ScriptException {
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        String string;
        int n2;
        this.viewer.loadShape(n);
        if (this.tokAt(1) == 6 && this.listIsosurface(n)) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = n == 23;
        boolean bl2 = n == 26;
        boolean bl3 = n == 27;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        float[] fArray = new float[5];
        float[] fArray2 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string2 = null;
        int n9 = n2 = this.isSyntaxCheck ? 0 : this.viewer.getCurrentModelIndex();
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(4);
        }
        boolean bl12 = this.initIsosurface(n) != null;
        boolean bl13 = bl12 && this.viewer.getShapeProperty(n, "ID") == null;
        boolean bl14 = false;
        String string3 = null;
        String string4 = null;
        short[] sArray = null;
        Vector vector = new Vector();
        if (bl2 || bl3) {
            this.addShapeProperty(vector, "fileType", "Pmesh");
        }
        block93: for (int i = this.iToken; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (i != n4) {
                    this.error(23);
                }
                this.addShapeProperty(vector, bl11 ? "colorMesh" : "colorRGB", new Integer(this.getArgbParam(i)));
                i = this.iToken;
                n4 = i + 1;
                bl12 = true;
                continue;
            }
            string = null;
            object3 = null;
            this.getToken(i);
            if (this.theTok == 0x40000000 && (string2 = this.parameterAsString(i)).equalsIgnoreCase("inline")) {
                this.theTok = 4;
            }
            block3 : switch (this.theTok) {
                case 1679429641: {
                    Point3f[] point3fArray;
                    if (this.isSyntaxCheck) continue block93;
                    if (this.fullCommand.indexOf("# BBOX=") >= 0) {
                        objectArray = TextFormat.split(this.extractCommandOption("# BBOX"), ',');
                        point3fArray = new Point3f[]{(Point3f)Escape.unescapePoint(objectArray[0]), (Point3f)Escape.unescapePoint(objectArray[1])};
                    } else {
                        point3fArray = this.viewer.getBoundBoxVertices();
                    }
                    this.addShapeProperty(vector, "commandOption", "BBOX=\"" + Escape.escape(point3fArray[0]) + "," + Escape.escape(point3fArray[point3fArray.length - 1]) + "\"");
                    this.addShapeProperty(vector, "boundingBox", point3fArray);
                    continue block93;
                }
                case 135206: {
                    bl2 = true;
                    this.addShapeProperty(vector, "fileType", "Pmesh");
                    continue block93;
                }
                case 135266317: {
                    Vector<Object> vector2;
                    BitSet bitSet;
                    Point3f[] point3fArray;
                    float f = this.floatParameter(++i);
                    string = "withinPoints";
                    object2 = this.centerParameter(++i);
                    BoxInfo boxInfo = null;
                    i = this.iToken;
                    if (this.fullCommand.indexOf("# WITHIN=") >= 0) {
                        bitSet = Escape.unescapeBitset(this.extractCommandOption("# WITHIN"));
                    } else {
                        BitSet bitSet2 = bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : null;
                    }
                    if (bitSet != null) {
                        boxInfo = this.viewer.getBoxInfo(bitSet, -f);
                        point3fArray = new Point3f[]{boxInfo.getBboxVertices()[0], boxInfo.getBboxVertices()[7]};
                        this.addShapeProperty(vector, "commandOption", "WITHIN=\"" + Escape.escape(bitSet) + "\"");
                        vector2 = new Vector();
                        if (bitSet.cardinality() == 1) {
                            vector2.add(this.viewer.getAtomPoint3f(bitSet.nextSetBit(0)));
                        }
                    } else {
                        object = new Point3f(f, f, f);
                        Point3f point3f = new Point3f((Point3f)object2);
                        point3f.sub((Tuple3f)object);
                        ((Tuple3f)object).add((Tuple3f)object2);
                        point3fArray = new Point3f[]{point3f, object};
                        vector2 = new Vector();
                        vector2.add(object2);
                    }
                    object3 = new Object[]{new Float(f), point3fArray, bitSet, vector2};
                    if (vector2.size() != 1) break;
                    this.addShapeProperty(vector, "withinDistance", new Float(f));
                    this.addShapeProperty(vector, "withinPoint", (Point3f)vector2.get(0));
                    break;
                }
                case 1716520973: {
                    Atom[] atomArray;
                    this.addShapeProperty(vector, "propertySmoothing", this.viewer.getIsosurfacePropertySmoothing() ? Boolean.TRUE : Boolean.FALSE);
                    string2 = this.parameterAsString(i);
                    string = "property";
                    if (!bl8 && string2.toLowerCase().indexOf("property_") == 0) {
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block93;
                        fArray2 = this.viewer.getDataFloat(string2);
                        if (fArray2 == null) {
                            this.error(22);
                        }
                        object3 = fArray2;
                        break;
                    }
                    int n10 = this.getToken((int)(++i)).tok;
                    int n11 = this.viewer.getAtomCount();
                    float[] fArray3 = fArray2 = bl8 ? new float[]{} : new float[n11];
                    if (bl8) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck && !bl8) {
                        atomArray = this.viewer.getModelSet().atoms;
                        this.viewer.autoCalculate(n10);
                        int n12 = n11;
                        while (--n12 >= 0) {
                            fArray2[n12] = Atom.atomPropertyFloat(this.viewer, atomArray[n12], n10);
                        }
                    }
                    if (n10 == 1632638983) {
                        string4 = "colorRGB";
                    }
                    object3 = fArray2;
                    break;
                }
                case 1095766028: {
                    if (bl4) {
                        this.error(22);
                    }
                    if ((n2 = this.modelNumberParameter(++i)) < 0) {
                        string = "fixed";
                        object3 = Boolean.TRUE;
                        break;
                    }
                    string = "modelIndex";
                    object3 = new Integer(n2);
                    break;
                }
                case 135280129: {
                    string = "select";
                    object3 = this.expression(++i);
                    i = this.iToken;
                    break;
                }
                case 1085443: {
                    n6 = this.intParameter(++i);
                    break;
                }
                case 1073741955: {
                    string = "offset";
                    object3 = this.centerParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    string = "center";
                    object3 = this.centerParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 1632638983: {
                    if (this.tokAt(i + 1) == 1073741870) {
                        ++i;
                        string = "colorDensity";
                        break;
                    }
                    n3 = 0;
                    if (this.getToken((int)(i + 1)).tok == 4) {
                        if ((string4 = this.parameterAsString(++i)).indexOf(" ") > 0 && (sArray = Graphics3D.getColixArray(string4)) == null) {
                            this.error(4);
                        }
                    } else if (this.theTok == 1073741931) {
                        bl11 = true;
                        ++i;
                    }
                    if ((this.theTok = this.tokAt(i + 1)) == 0x400000C4 || this.tokAt(i + 1) == 1073741959) {
                        string3 = this.setColorOptions(i + 1, 23, -2);
                        i = this.iToken;
                    }
                    switch (this.tokAt(i + 1)) {
                        case 0x40000001: 
                        case 1073741982: {
                            this.getToken(++i);
                            n3 = 1;
                            string = "rangeAll";
                            if (this.tokAt(i + 1) != 0x100003) break block3;
                            this.getToken(++i);
                            break block3;
                        }
                        default: {
                            n4 = i + 1;
                            break;
                        }
                    }
                    continue block93;
                }
                case 1229984263: {
                    continue block93;
                }
                case 0x10100091: {
                    if (n3 != 0) break;
                    string = "cutoffPositive";
                    object3 = new Float(this.floatParameter(++i));
                    break;
                }
                case 2: 
                case 3: {
                    string = n3 == 1 ? "red" : (n3 == 2 ? "blue" : "cutoff");
                    object3 = new Float(this.floatParameter(i));
                    if (n3 <= 0) break;
                    ++n3;
                    break;
                }
                case 1112541193: 
                case 1112541205: {
                    Atom[] atomArray = this.encodeRadiusParameter(i);
                    if (Float.isNaN(atomArray.value)) {
                        atomArray.value = 100.0f;
                    }
                    object3 = atomArray;
                    string = "radius";
                    bl9 = true;
                    i = this.iToken;
                    break;
                }
                case 135266313: {
                    bl5 = true;
                    string = "plane";
                    object3 = this.planeParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 0x60000004: {
                    string = "scale3d";
                    object3 = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073741995: {
                    string = "scale";
                    object3 = new Float(this.floatParameter(++i));
                    break;
                }
                case 0x100003: {
                    if (bl12) {
                        this.error(22);
                    }
                    string = "thisID";
                    break;
                }
                case 1113198596: {
                    BitSet bitSet;
                    bl4 = true;
                    ++i;
                    try {
                        object3 = this.getPoint4f(i);
                        string = "ellipsoid";
                        i = this.iToken;
                    }
                    catch (ScriptException scriptException) {
                        try {
                            string = "ellipsoid";
                            object3 = this.floatParameterSet(i, 6, 6);
                            i = this.iToken;
                        }
                        catch (ScriptException scriptException2) {
                            bitSet = this.expression(i);
                            int n13 = bitSet.nextSetBit(0);
                            Atom[] atomArray = this.viewer.getModelSet().atoms;
                            if (n13 >= 0) {
                                object3 = atomArray[n13].getEllipsoid();
                            }
                            if (object3 == null) {
                                return;
                            }
                            i = this.iToken;
                            string = "ellipsoid";
                            if (this.isSyntaxCheck) break;
                            this.addShapeProperty(vector, "center", this.viewer.getAtomPoint3f(n13));
                        }
                    }
                    break;
                }
                case 135267842: {
                    bl5 = true;
                    string = "plane";
                    object3 = this.hklParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 135198: {
                    Object[] objectArray2;
                    int n14;
                    BitSet bitSet;
                    bl4 = true;
                    String string5 = this.parameterAsString(++i);
                    this.addShapeProperty(vector, "lcaoType", string5);
                    switch (this.getToken((int)(++i)).tok) {
                        case 9: 
                        case 0x100001: {
                            Point3f point3f;
                            string = "lcaoCartoon";
                            bitSet = this.expression(i);
                            i = this.iToken;
                            n14 = bitSet.nextSetBit(0);
                            n2 = 0;
                            if (n14 < 0) {
                                if (!this.isSyntaxCheck) {
                                    this.error(14);
                                }
                                point3f = new Point3f();
                            } else {
                                n2 = this.viewer.getAtomModelIndex(n14);
                                point3f = this.viewer.getAtomPoint3f(n14);
                            }
                            this.addShapeProperty(vector, "modelIndex", new Integer(n2));
                            objectArray2 = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(point3f), new Vector3f()};
                            if (!this.isSyntaxCheck) {
                                this.viewer.getHybridizationAndAxes(n14, (Vector3f)objectArray2[0], (Vector3f)objectArray2[1], string5, false);
                            }
                            object3 = objectArray2;
                            break block3;
                        }
                    }
                    this.error(14);
                    break;
                }
                case 0x121021: {
                    int n14 = Integer.MAX_VALUE;
                    int n15 = Integer.MAX_VALUE;
                    switch (this.tokAt(++i)) {
                        case 0: {
                            this.error(2);
                        }
                        case 1073741906: 
                        case 1073741925: {
                            n15 = this.moOffset(i);
                            if (n15 == Integer.MAX_VALUE) break;
                            n14 = 0;
                            i = this.iToken;
                            break;
                        }
                        case 2: {
                            n14 = this.intParameter(i);
                        }
                    }
                    this.setMoData(vector, n14, n15, n2, null);
                    bl4 = true;
                    continue block93;
                }
                case 1074790506: {
                    Object[] objectArray2 = null;
                    try {
                        objectArray2 = this.viewer.getPartialCharges();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.isSyntaxCheck && objectArray2 == null) {
                        this.error(32);
                    }
                    bl4 = true;
                    string = "mep";
                    object3 = objectArray2;
                    break;
                }
                case 0x400000AA: 
                case 1613758475: {
                    bl4 = true;
                    this.addShapeProperty(vector, "bsSolvent", this.lookupIdentifierValue("solvent"));
                    string = this.theTok == 0x400000AA ? "sasurface" : "solvent";
                    float f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    object3 = new Float(f);
                    break;
                }
                case 1313866247: {
                    bl7 = !this.isSyntaxCheck;
                    break;
                }
                case 1074790483: {
                    this.setShapeId(n, ++i, bl12);
                    bl13 = this.viewer.getShapeProperty(n, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 0x40000020: {
                    if (this.tokAt(i + 1) == 0x400000C4) {
                        bl14 = true;
                        ++i;
                    }
                    string4 = this.parameterAsString(++i);
                    if (this.tokAt(i + 1) != 0x400000C4) break;
                    bl14 = true;
                    ++i;
                    break;
                }
                case 0x40000002: {
                    string = "addHydrogens";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 0x40000006: {
                    string = "angstroms";
                    break;
                }
                case 0x40000007: {
                    string = "anisotropy";
                    object3 = this.getPoint3f(++i, false);
                    i = this.iToken;
                    break;
                }
                case 0x4000000A: {
                    bl6 = !this.isSyntaxCheck;
                    break;
                }
                case 0x4000000D: 
                case 0x40000088: {
                    bl4 = true;
                    fArray[0] = this.intParameter(++i);
                    fArray[1] = this.intParameter(++i);
                    fArray[2] = this.intParameter(++i);
                    fArray[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                    string = "hydrogenOrbital";
                    object3 = fArray;
                    break;
                }
                case 0x40000014: {
                    continue block93;
                }
                case 1073741845: {
                    string = "blockData";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 528437: 
                case 1074790424: {
                    string = (String)this.theToken.value;
                    object3 = this.getCapSlabObject(i);
                    i = this.iToken;
                    break;
                }
                case 1073741849: {
                    float f;
                    if (!bl) {
                        this.error(22);
                    }
                    bl8 = true;
                    if (this.isSyntaxCheck) continue block93;
                    float f2 = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 1.2f;
                    float f3 = f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 10.0f;
                    if (f > 10.0f) {
                        this.integerOutOfRange(0, 10);
                    }
                    this.addShapeProperty(vector, "envelopeRadius", new Float(f));
                    this.addShapeProperty(vector, "cavityRadius", new Float(f2));
                    string = "cavity";
                    break;
                }
                case 0x40000024: 
                case 1073741862: {
                    Serializable serializable;
                    string = "contour";
                    switch (this.tokAt(i + 1)) {
                        case 1073741877: {
                            object3 = this.floatParameterSet(i + 2, 1, Integer.MAX_VALUE);
                            i = this.iToken;
                            break block3;
                        }
                        case 1073741910: {
                            serializable = this.getPoint3f(i + 2, false);
                            if (((Point3f)serializable).z <= 0.0f) {
                                this.error(22);
                            }
                            object3 = serializable;
                            i = this.iToken;
                            break block3;
                        }
                    }
                    object3 = new Integer(this.tokAt(i + 1) == 2 ? this.intParameter(++i) : 0);
                    break;
                }
                case 1073741867: {
                    if (++i < this.statementLength && this.getToken((int)i).tok == 0x10100091) {
                        string = "cutoffPositive";
                        object3 = new Float(this.floatParameter(++i));
                        break;
                    }
                    string = "cutoff";
                    object3 = new Float(this.floatParameter(i));
                    break;
                }
                case 1073741881: {
                    string = "downsample";
                    object3 = new Integer(this.intParameter(++i));
                    break;
                }
                case 1073741882: {
                    string = "eccentricity";
                    object3 = this.getPoint4f(++i);
                    i = this.iToken;
                    break;
                }
                case 1074790459: {
                    this.setMoData(vector, -1, 0, n2, null);
                    bl4 = true;
                    continue block93;
                }
                case 0x20000004: 
                case 1073741942: {
                    string = "debug";
                    object3 = this.theTok == 0x20000004 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 0x40000042: {
                    string = "fixed";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 0x4000004B: {
                    string = "fullPlane";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 0x4000004D: {
                    Object object4;
                    Serializable serializable = new Vector();
                    if (this.getToken((int)(++i)).tok != 4) {
                        this.error(53, "functionXY must be followed by a function name in quotes.");
                    }
                    String string6 = this.parameterAsString(i++);
                    String string7 = this.extractCommandOption("# DATA" + (bl10 ? "2" : ""));
                    if (string7 != null) {
                        string6 = string7;
                    }
                    boolean bl15 = string6.indexOf("data2d_") == 0;
                    ((Vector)serializable).addElement(string6);
                    ((Vector)serializable).addElement(this.getPoint3f(i, false));
                    int n16 = ++this.iToken;
                    Point4f point4f = this.getPoint4f(n16);
                    ((Vector)serializable).addElement(point4f);
                    int n17 = (int)point4f.x;
                    int n18 = ++this.iToken;
                    point4f = this.getPoint4f(n18);
                    ((Vector)serializable).addElement(point4f);
                    int n19 = (int)point4f.x;
                    ((Vector)serializable).addElement(this.getPoint4f(++this.iToken));
                    if (n17 == 0 || n19 == 0) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        object4 = bl15 ? this.viewer.getDataFloat2D(string6) : this.viewer.functionXY(string6, n17, n19);
                        if (bl15) {
                            n17 = object4 == null ? 0 : ((Object)object4).length;
                            n19 = 3;
                        } else {
                            n17 = Math.abs(n17);
                            n19 = Math.abs(n19);
                        }
                        if (object4 == null) {
                            this.iToken = n16;
                            this.error(53, "fdata is null.");
                        }
                        if (((Object)object4).length != n17 && !bl15) {
                            this.iToken = n16;
                            this.error(53, "fdata length is not correct: " + ((Object)object4).length + " " + n17 + ".");
                        }
                        for (int j = 0; j < n17; ++j) {
                            if (object4[j] == null) {
                                this.iToken = n18;
                                this.error(53, "fdata[" + j + "] is null.");
                            }
                            if (((Object)object4[j]).length == n19) continue;
                            this.iToken = n18;
                            this.error(53, "fdata[" + j + "] is not the right length: " + ((Object)object4[j]).length + " " + n19 + ".");
                        }
                        ((Vector)serializable).addElement(object4);
                    }
                    i = this.iToken;
                    string = "functionXY";
                    object3 = serializable;
                    bl4 = true;
                    bl10 = true;
                    break;
                }
                case 0x4000004E: {
                    Object object5;
                    boolean bl16;
                    Vector<Object> vector2 = new Vector<Object>();
                    if (this.getToken((int)(++i)).tok != 4) {
                        this.error(53, "functionXYZ must be followed by a function name in quotes.");
                    }
                    Object object4 = this.parameterAsString(i++);
                    String string8 = this.extractCommandOption("# DATA" + (bl10 ? "2" : ""));
                    if (string8 != null) {
                        object4 = string8;
                    }
                    boolean bl17 = bl16 = ((String)object4).indexOf("data3d_") == 0;
                    if (string8 != null) {
                        object4 = string8;
                    }
                    vector2.addElement(object4);
                    vector2.addElement(this.getPoint3f(i, false));
                    int n16 = ++this.iToken;
                    Point4f point4f = this.getPoint4f(n16);
                    vector2.addElement(point4f);
                    int n17 = (int)point4f.x;
                    int n18 = ++this.iToken;
                    point4f = this.getPoint4f(n18);
                    vector2.addElement(point4f);
                    int n19 = (int)point4f.x;
                    point4f = this.getPoint4f(++this.iToken);
                    vector2.addElement(point4f);
                    int n20 = (int)point4f.x;
                    if (n17 == 0 || n19 == 0) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        object5 = bl16 ? this.viewer.getDataFloat3D((String)object4) : this.viewer.functionXYZ((String)object4, n17, n19, n20);
                        n17 = Math.abs(n17);
                        n19 = Math.abs(n19);
                        if (object5 == null) {
                            this.iToken = n16;
                            this.error(53, "xyzdata is null.");
                        }
                        if (((Object)object5).length != n17 || ((Object)object5[0]).length != n19 || ((Object)object5[0][0]).length != n20) {
                            this.iToken = n16;
                            this.error(53, "xyzdata[" + ((Object)object5).length + "][" + ((Object)object5[0]).length + "][" + ((Object)object5[0][0]).length + "] is not of size [" + n17 + "][" + n19 + "][" + n20 + "]");
                        }
                        vector2.addElement(object5);
                    }
                    i = this.iToken;
                    string = "functionXYZ";
                    object3 = vector2;
                    bl4 = true;
                    bl10 = true;
                    break;
                }
                case 0x4000004F: {
                    string = "gridPoints";
                    break;
                }
                case 0x40000054: {
                    string = "ignore";
                    object3 = this.expression(++i);
                    i = this.iToken;
                    break;
                }
                case 1073741912: {
                    string = "insideOut";
                    break;
                }
                case 1073741913: 
                case 1073741914: {
                    string = "pocket";
                    object3 = Boolean.FALSE;
                    break;
                }
                case 1073741922: {
                    bl4 = true;
                    string = "lobe";
                    object3 = this.getPoint4f(++i);
                    i = this.iToken;
                    break;
                }
                case 1073741923: 
                case 0x40000064: {
                    bl4 = true;
                    string = "lp";
                    object3 = this.getPoint4f(++i);
                    i = this.iToken;
                    break;
                }
                case 1074790503: {
                    if (bl9 && !bl4) {
                        bl4 = true;
                        this.addShapeProperty(vector, "bsSolvent", this.lookupIdentifierValue("solvent"));
                        this.addShapeProperty(vector, "sasurface", new Float(0.0f));
                    }
                    bl4 = !bl8;
                    string = "map";
                    break;
                }
                case 1073741928: {
                    string = "maxset";
                    object3 = new Integer(this.intParameter(++i));
                    break;
                }
                case 1073741932: {
                    string = "minset";
                    object3 = new Integer(this.intParameter(++i));
                    break;
                }
                case 1073741981: {
                    bl4 = true;
                    string = "rad";
                    object3 = this.getPoint4f(++i);
                    i = this.iToken;
                    break;
                }
                case 0x40000070: {
                    string = "fixed";
                    object3 = Boolean.FALSE;
                    break;
                }
                case 1073741937: {
                    bl4 = true;
                    string = "molecular";
                    object3 = new Float(1.4);
                    break;
                }
                case 1073741953: 
                case 1073741954: {
                    this.addShapeProperty(vector, "fileType", "Obj");
                    continue block93;
                }
                case 1073741970: {
                    if (bl4) {
                        this.error(22);
                    }
                    string = "phase";
                    object3 = this.tokAt(i + 1) == 4 ? this.stringParameter(++i) : "_orb";
                    break;
                }
                case 1073741973: {
                    string = "pocket";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 1073741975: 
                case 1073741986: {
                    string = "resolution";
                    object3 = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073741987: {
                    string = "reverseColor";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 1073741999: {
                    n8 = i++;
                    string = "sigma";
                    object3 = new Float(this.floatParameter(i));
                    break;
                }
                case 1073742001: {
                    n4 = i + 1;
                    string = "sign";
                    object3 = Boolean.TRUE;
                    n3 = 1;
                    break;
                }
                case 0x400000B4: {
                    bl4 = true;
                    string = "sphere";
                    object3 = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073742005: {
                    string = "squareData";
                    object3 = Boolean.TRUE;
                    break;
                }
                case 1073742025: {
                    string = "property";
                    fArray2 = new float[this.viewer.getAtomCount()];
                    if (!this.isSyntaxCheck) {
                        Parser.parseFloatArray("" + this.getParameter(this.parameterAsString(++i), false), null, fArray2);
                    }
                    object3 = fArray2;
                    break;
                }
                case 4: {
                    String[] stringArray;
                    string = bl4 || bl5 ? "mapColor" : "readFile";
                    Object object5 = this.parameterAsString(i);
                    if (((String)object5).equals("TESTDATA") && Viewer.testData != null) {
                        object3 = Viewer.testData;
                        break;
                    }
                    if (((String)object5).equals("TESTDATA2") && Viewer.testData2 != null) {
                        object3 = Viewer.testData2;
                        break;
                    }
                    if (((String)object5).length() == 0) {
                        if (bl4 || bl5) {
                            object3 = this.viewer.getModelAuxiliaryInfo(n2, "jmolMappedDataInfo");
                        }
                        if (object3 == null) {
                            object3 = this.viewer.getModelAuxiliaryInfo(n2, "jmolSurfaceInfo");
                        }
                        bl4 = true;
                        if (object3 != null) break;
                        object5 = this.getFullPathName();
                    }
                    bl4 = true;
                    if (this.tokAt(i + 1) == 2) {
                        this.addShapeProperty(vector, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    if (((String)object5).equals("string")) {
                        object3 = this.isSyntaxCheck ? null : this.viewer.getFileInfo()[3];
                        this.addShapeProperty(vector, "fileName", "");
                        break;
                    }
                    if (((String)object5).equalsIgnoreCase("INLINE")) {
                        if (this.tokAt(i + 1) != 4) {
                            this.error(41);
                        }
                        stringArray = this.parameterAsString(++i);
                        if (bl2) {
                            stringArray = TextFormat.replaceAllCharacters((String)stringArray, "{,}|", ' ');
                        }
                        if (this.logMessages) {
                            Logger.debug("pmesh inline data:\n" + (String)stringArray);
                        }
                        object3 = this.isSyntaxCheck ? null : stringArray;
                        this.addShapeProperty(vector, "fileName", "");
                        break;
                    }
                    if (this.isSyntaxCheck) break;
                    String string9 = null;
                    if (this.fullCommand.indexOf("# FILE" + n7 + "=") >= 0) {
                        object5 = this.extractCommandOption("# FILE" + n7);
                        if (this.tokAt(i + 1) == 1073742125) {
                            i += 2;
                        }
                    } else if (this.tokAt(i + 1) == 1073742125) {
                        string9 = this.viewer.getFullPath(this.stringParameter(i += 2));
                        stringArray = this.viewer.getFullPathNameOrError(string9);
                        string9 = stringArray[0];
                        this.addShapeProperty(vector, "localName", string9);
                    }
                    stringArray = this.viewer.getFullPathNameOrError((String)object5);
                    object5 = stringArray[0];
                    if (stringArray[1] != null) {
                        this.error(17, (String)object5 + ":" + stringArray[1]);
                    }
                    Logger.info("reading isosurface data from " + (String)object5);
                    this.addShapeProperty(vector, "commandOption", "FILE" + n7++ + "=" + Escape.escape((String)(string9 == null ? object5 : string9)));
                    this.addShapeProperty(vector, "fileName", object5);
                    object3 = null;
                    break;
                }
                case 0x40000000: {
                    if (string2.equalsIgnoreCase("LINK")) {
                        string = "link";
                        break;
                    }
                    if (string2.equalsIgnoreCase("REMAPPABLE")) {
                        string = "remappable";
                        break;
                    }
                    string = "thisID";
                    object3 = string2;
                }
                default: {
                    if (bl5 && !bl4) {
                        this.addShapeProperty(vector, "nomap", new Float(0.0f));
                        bl4 = true;
                    }
                    if (!this.setMeshDisplayProperty(n, 0, this.theTok)) {
                        if (Token.tokAttr(this.theTok, 0x40000000) && !bl12) {
                            this.setShapeId(n, i, bl12);
                            i = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n5 == 0) {
                        n5 = i;
                    }
                    i = this.statementLength - 1;
                }
            }
            boolean bl18 = bl12 = this.theTok != 12291;
            if (string == "property" && !bl4) {
                bl4 = true;
                this.addShapeProperty(vector, "bsSolvent", this.lookupIdentifierValue("solvent"));
                string = "sasurface";
                object3 = new Float(0.0f);
            }
            if (bl13 && bl4) {
                this.error(22);
            }
            if (string == null) continue;
            this.addShapeProperty(vector, string, object3);
        }
        if ((bl8 || bl9) && !bl4) {
            bl4 = true;
            this.addShapeProperty(vector, "bsSolvent", this.lookupIdentifierValue("solvent"));
            this.addShapeProperty(vector, "sasurface", new Float(0.0f));
        }
        if (bl5 && !bl4) {
            this.addShapeProperty(vector, "nomap", new Float(0.0f));
            bl4 = true;
        }
        if (n6 > 0) {
            this.addShapeProperty(vector, "getSurfaceSets", new Integer(n6 - 1));
        }
        if (sArray != null) {
            this.addShapeProperty(vector, "colorDiscrete", sArray);
        } else if (string4 != null) {
            this.addShapeProperty(vector, "setColorScheme", new Object[]{string4, bl14 ? Boolean.TRUE : Boolean.FALSE});
        }
        this.setShapeProperty(n, "setProperties", vector);
        if (n5 > 0 && !this.setMeshDisplayProperty(n, n5, this.getToken((int)n5).tok)) {
            this.error(22);
        }
        Object object6 = null;
        string = null;
        if (bl6) {
            object6 = this.viewer.getShapeProperty(n, "area");
            if (object6 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceArea", ((Float)object6).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceArea", ScriptVariable.getVariable(object6));
            }
        }
        if (bl7) {
            String string10 = string = bl7 ? this.viewer.getShapeProperty(n, "volume") : null;
            if (string instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceVolume", ((Float)((Object)string)).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceVolume", ScriptVariable.getVariable(string));
            }
        }
        if (bl4 && bl && !this.isSyntaxCheck) {
            this.setShapeProperty(n, "finalize", null);
            object3 = (Integer)this.viewer.getShapeProperty(n, "count");
            objectArray = (float[])this.viewer.getShapeProperty(n, "dataRange");
            object2 = (String)this.viewer.getShapeProperty(n, "ID");
            if (object2 != null) {
                float f = ((Float)this.viewer.getShapeProperty(n, "cutoff")).floatValue();
                if (Float.isNaN(f) && n8 >= 0) {
                    this.iToken = n8;
                    this.error(22);
                }
                object2 = (String)object2 + " created with cutoff=" + f;
                object = (float[])this.viewer.getShapeProperty(n, "minMaxInfo");
                if (object[0] != Float.MAX_VALUE) {
                    object2 = (String)object2 + " min=" + (float)object[0] + " max=" + (float)object[1];
                }
                object2 = (String)object2 + "; number of isosurfaces = " + object3;
                if (objectArray != null && objectArray[0] != Float.MAX_VALUE && objectArray[0] != objectArray[1]) {
                    object2 = (String)object2 + "\ncolor range " + (float)objectArray[2] + " " + (float)objectArray[3] + "; mapped data range " + (float)objectArray[0] + " to " + (float)objectArray[1];
                }
                if (bl6) {
                    object2 = (String)object2 + "\nisosurfaceArea = " + Escape.escapeArray(object6);
                }
                if (bl7) {
                    object2 = (String)object2 + "\nisosurfaceVolume = " + Escape.escapeArray(string);
                }
                this.showString((String)object2);
            }
        } else if (bl6 || bl7) {
            if (bl6) {
                this.showString("isosurfaceArea = " + Escape.escapeArray(object6));
            }
            if (bl7) {
                this.showString("isosurfaceVolume = " + Escape.escapeArray(string));
            }
        }
        if (string3 != null) {
            this.setShapeProperty(n, "translucency", string3);
        }
        this.setShapeProperty(n, "clear", null);
    }

    private void addShapeProperty(Vector vector, String string, Object object) {
        if (!this.isSyntaxCheck) {
            vector.add(new Object[]{string, object});
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean setMeshDisplayProperty(int var1_1, int var2_2, int var3_3) throws ScriptException {
        var4_4 = null;
        var5_5 = null;
        v0 = var6_6 = var2_2 == 0;
        if (!var6_6) {
            this.iToken = var2_2;
        }
        switch (var3_3) {
            case 1073741959: 
            case 0x400000C4: {
                if (!var6_6) {
                    this.colorShape(var1_1, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12293: 
            case 0x10000C: 
            case 0x10000D: 
            case 3145751: 
            case 3145752: 
            case 1610625028: {
                if (this.iToken == 1) {
                    this.setShapeProperty(var1_1, "thisID", null);
                }
                if (var3_3 == 0) {
                    return this.iToken == 1;
                }
                if (var6_6) {
                    return true;
                }
                if (var3_3 == 12291) {
                    this.setShapeProperty(var1_1, "delete", null);
                    return true;
                }
                if (var3_3 != 3145752 && var3_3 != 12293) ** GOTO lbl24
                var3_3 = 0x10000C;
                ** GOTO lbl26
lbl24:
                // 1 sources

                if (var3_3 == 3145751 || var3_3 == 1610625028) {
                    var3_3 = 0x10000D;
                }
            }
lbl26:
            // 5 sources

            case 1073741843: 
            case 1073741861: 
            case 1073741887: 
            case 0x40000049: 
            case 0x4000004A: 
            case 0x4000004C: 
            case 1073741931: 
            case 0x40000074: 
            case 0x40000077: 
            case 1073741945: 
            case 1073741948: 
            case 1073741951: 
            case 0x40000080: 
            case 1073742021: 
            case 1113198595: {
                var4_4 = "token";
                var5_5 = new Integer(var3_3);
            }
        }
        if (var4_4 == null) {
            return false;
        }
        if (var6_6) {
            return true;
        }
        this.setShapeProperty(var1_1, var4_4, var5_5);
        var3_3 = this.tokAt(this.iToken + 1);
        if (var3_3 != 0 && !this.setMeshDisplayProperty(var1_1, ++this.iToken, var3_3)) {
            --this.iToken;
        }
        return true;
    }

    private void bind() throws ScriptException {
        String string = this.stringParameter(1);
        String string2 = this.parameterAsString(2);
        Point3f point3f = null;
        Point3f point3f2 = null;
        if (this.tokAt(3) == 1073741982) {
            point3f = this.xypParameter(4);
            point3f2 = this.xypParameter(++this.iToken);
            this.checkLast(this.iToken);
        } else {
            this.checkLength(3);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.bindAction(string, string2, point3f, point3f2);
        }
    }

    private void unbind() throws ScriptException {
        if (this.statementLength != 1) {
            this.checkLength23();
        }
        String string = this.optParameterAsString(1);
        String string2 = this.optParameterAsString(2);
        if (string.length() == 0 || this.tokAt(1) == 0x100003) {
            string = null;
        }
        if (string2.length() == 0 || this.tokAt(2) == 0x100003) {
            string2 = null;
        }
        if (string2 == null && string != null && ActionManager.getActionFromName(string) >= 0) {
            string2 = string;
            string = null;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.unBindAction(string, string2);
        }
    }

    class ScriptException
    extends Exception {
        private String message;
        private String untranslated;

        ScriptException(String string, String string2) {
            ScriptEvaluator.this.errorType = this.message = string;
            ScriptEvaluator.this.iCommandError = ScriptEvaluator.this.pc;
            String string3 = this.untranslated = string2 == null ? string : string2;
            if (this.message == null) {
                this.message = "";
                return;
            }
            String string4 = ScriptEvaluator.this.contextTrace();
            this.message = this.message + string4;
            this.untranslated = this.untranslated + string4;
            if (ScriptEvaluator.this.isSyntaxCheck || string.indexOf("file recognized as a script file:") >= 0) {
                return;
            }
            Logger.error("eval ERROR: " + this.toString());
            if (ScriptEvaluator.this.viewer.autoExit) {
                ScriptEvaluator.this.viewer.exitJmol();
            }
        }

        protected String getErrorMessageUntranslated() {
            return this.untranslated;
        }

        public String toString() {
            return this.message;
        }
    }
}

