// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_URSRA_2S_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_URSRA_2S_2OPIMM_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_ursra_2S_2OPIMM[] = {
  0x7fffffff, 0x7fffffff,
  0xbffffffe, 0xbfffffff,
  0xdffffffe, 0xdfffffff,
  0xeffffffe, 0xefffffff,
  0xf7fffffe, 0xf7ffffff,
  0xfbfffffe, 0xfbffffff,
  0xfdfffffe, 0xfdffffff,
  0xfefffffe, 0xfeffffff,
  0xff7ffffe, 0xff7fffff,
  0xffbffffe, 0xffbfffff,
  0xffdffffe, 0xffdfffff,
  0xffeffffe, 0xffefffff,
  0xfff7fffe, 0xfff7ffff,
  0xfffbfffe, 0xfffbffff,
  0xfffdfffe, 0xfffdffff,
  0xfffefffe, 0xfffeffff,
  0xffff7ffe, 0xffff7fff,
  0xffffbffe, 0xffffbfff,
  0xffffdffe, 0xffffdfff,
  0xffffeffe, 0xffffefff,
  0xfffff7fe, 0xfffff7ff,
  0xfffffbfe, 0xfffffbff,
  0xfffffdfe, 0xfffffdff,
  0xfffffefe, 0xfffffeff,
  0xffffff7e, 0xffffff7f,
  0xffffffbe, 0xffffffbf,
  0xffffffde, 0xffffffdf,
  0xffffffee, 0xffffffef,
  0xfffffff6, 0xfffffff7,
  0xfffffffa, 0xfffffffb,
  0xfffffffc, 0xfffffffd,
  0xfffffffd, 0xfffffffe,
  0x7fffffff, 0x80000000,
  0xbfffffff, 0xc0000000,
  0xdfffffff, 0xe0000000,
  0xefffffff, 0xf0000000,
  0xf7ffffff, 0xf8000000,
  0xfbffffff, 0xfc000000,
  0xfdffffff, 0xfe000000,
  0xfeffffff, 0xff000000,
  0xff7fffff, 0xff800000,
  0xffbfffff, 0xffc00000,
  0xffdfffff, 0xffe00000,
  0xffefffff, 0xfff00000,
  0xfff7ffff, 0xfff80000,
  0xfffbffff, 0xfffc0000,
  0xfffdffff, 0xfffe0000,
  0xfffeffff, 0xffff0000,
  0xffff7fff, 0xffff8000,
  0xffffbfff, 0xffffc000,
  0xffffdfff, 0xffffe000,
  0xffffefff, 0xfffff000,
  0xfffff7ff, 0xfffff800,
  0xfffffbff, 0xfffffc00,
  0xfffffdff, 0xfffffe00,
  0xfffffeff, 0xffffff00,
  0xffffff7f, 0xffffff80,
  0xffffffbf, 0xffffffc0,
  0xffffffdf, 0xffffffe0,
  0xffffffef, 0xfffffff0,
  0xfffffff7, 0xfffffff8,
  0xfffffffb, 0xfffffffc,
  0xfffffffd, 0xfffffffe,
  0xfffffffe, 0xffffffff,
  0x80000000, 0x00000000,
  0xc0000000, 0x00000000,
  0xe0000000, 0x00000000,
  0xf0000000, 0x00000000,
  0xf8000000, 0x00000000,
  0xfc000000, 0x00000000,
  0xfe000000, 0x00000000,
  0xff000000, 0x00000000,
  0xff800000, 0x00000000,
  0xffc00000, 0x00000000,
  0xffe00000, 0x00000000,
  0xfff00000, 0x00000000,
  0xfff80000, 0x00000000,
  0xfffc0000, 0x00000000,
  0xfffe0000, 0x00000000,
  0xffff0000, 0x00000000,
  0xffff8000, 0x00000000,
  0xffffc000, 0x00000000,
  0xffffe000, 0x00000000,
  0xfffff000, 0x00000000,
  0xfffff800, 0x00000000,
  0xfffffc00, 0x00000000,
  0xfffffe00, 0x00000000,
  0xffffff00, 0x00000000,
  0xffffff80, 0x00000000,
  0xffffffc0, 0x00000000,
  0xffffffe0, 0x00000000,
  0xfffffff0, 0x00000000,
  0xfffffff8, 0x00000000,
  0xfffffffc, 0x00000000,
  0xfffffffe, 0x00000000,
  0xffffffff, 0x00000000,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000000, 0x00000001,
  0x00000001, 0x00000001,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000002,
  0x00000001, 0x00000010,
  0x00000002, 0x00000018,
  0x00000002, 0x0000001c,
  0x00000002, 0x0000001e,
  0x00000002, 0x0000001f,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000002, 0x00000020,
  0x00000010, 0x0000003f,
  0x00000018, 0x0000005e,
  0x0000001c, 0x0000006e,
  0x0000001e, 0x00000076,
  0x0000001f, 0x0000007a,
  0x00000020, 0x0000007c,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x00000020, 0x0000007d,
  0x0000003f, 0x0000003f,
  0x0000005e, 0x0000005f,
  0x0000006e, 0x0000006f,
  0x00000076, 0x00000077,
  0x0000007a, 0x0000007b,
  0x0000007c, 0x0000007d,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000007d, 0x0000007e,
  0x0000003f, 0x00000040,
  0x0000005f, 0x00000060,
  0x0000006f, 0x00000070,
  0x00000077, 0x00000078,
  0x0000007b, 0x0000007c,
  0x0000007d, 0x0000007e,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x0000007e, 0x0000007f,
  0x00000040, 0x00003fff,
  0x00000060, 0x00005ffe,
  0x00000070, 0x00006ffe,
  0x00000078, 0x000077fe,
  0x0000007c, 0x00007bfe,
  0x0000007e, 0x00007dfe,
  0x0000007f, 0x00007efe,
  0x0000007f, 0x00007f7e,
  0x0000007f, 0x00007fbe,
  0x0000007f, 0x00007fde,
  0x0000007f, 0x00007fee,
  0x0000007f, 0x00007ff6,
  0x0000007f, 0x00007ffa,
  0x0000007f, 0x00007ffc,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x0000007f, 0x00007ffd,
  0x00003fff, 0x00003fff,
  0x00005ffe, 0x00005fff,
  0x00006ffe, 0x00006fff,
  0x000077fe, 0x000077ff,
  0x00007bfe, 0x00007bff,
  0x00007dfe, 0x00007dff,
  0x00007efe, 0x00007eff,
  0x00007f7e, 0x00007f7f,
  0x00007fbe, 0x00007fbf,
  0x00007fde, 0x00007fdf,
  0x00007fee, 0x00007fef,
  0x00007ff6, 0x00007ff7,
  0x00007ffa, 0x00007ffb,
  0x00007ffc, 0x00007ffd,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00007ffd, 0x00007ffe,
  0x00003fff, 0x00004000,
  0x00005fff, 0x00006000,
  0x00006fff, 0x00007000,
  0x000077ff, 0x00007800,
  0x00007bff, 0x00007c00,
  0x00007dff, 0x00007e00,
  0x00007eff, 0x00007f00,
  0x00007f7f, 0x00007f80,
  0x00007fbf, 0x00007fc0,
  0x00007fdf, 0x00007fe0,
  0x00007fef, 0x00007ff0,
  0x00007ff7, 0x00007ff8,
  0x00007ffb, 0x00007ffc,
  0x00007ffd, 0x00007ffe,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00007ffe, 0x00007fff,
  0x00004000, 0x1999999a,
  0x00006000, 0x26666667,
  0x00007000, 0x2ccccccd,
  0x00007800, 0x30000000,
  0x00007c00, 0x3199999a,
  0x00007e00, 0x32666667,
  0x00007f00, 0x32cccccd,
  0x00007f80, 0x33000000,
  0x00007fc0, 0x3319999a,
  0x00007fe0, 0x33266667,
  0x00007ff0, 0x332ccccd,
  0x00007ff8, 0x33300000,
  0x00007ffc, 0x3331999a,
  0x00007ffe, 0x33326667,
  0x00007fff, 0x3332cccd,
  0x00007fff, 0x33330000,
  0x00007fff, 0x3333199a,
  0x00007fff, 0x33332667,
  0x00007fff, 0x33332ccd,
  0x00007fff, 0x33333000,
  0x00007fff, 0x3333319a,
  0x00007fff, 0x33333267,
  0x00007fff, 0x333332cd,
  0x00007fff, 0x33333300,
  0x00007fff, 0x3333331a,
  0x00007fff, 0x33333327,
  0x00007fff, 0x3333332d,
  0x00007fff, 0x33333330,
  0x00007fff, 0x33333332,
  0x00007fff, 0x33333333,
  0x00007fff, 0x33333333,
  0x00007fff, 0x33333333,
  0x1999999a, 0x2aaaaaab,
  0x26666667, 0x40000000,
  0x2ccccccd, 0x4aaaaaab,
  0x30000000, 0x50000000,
  0x3199999a, 0x52aaaaab,
  0x32666667, 0x54000000,
  0x32cccccd, 0x54aaaaab,
  0x33000000, 0x55000000,
  0x3319999a, 0x552aaaab,
  0x33266667, 0x55400000,
  0x332ccccd, 0x554aaaab,
  0x33300000, 0x55500000,
  0x3331999a, 0x5552aaab,
  0x33326667, 0x55540000,
  0x3332cccd, 0x5554aaab,
  0x33330000, 0x55550000,
  0x3333199a, 0x55552aab,
  0x33332667, 0x55554000,
  0x33332ccd, 0x55554aab,
  0x33333000, 0x55555000,
  0x3333319a, 0x555552ab,
  0x33333267, 0x55555400,
  0x333332cd, 0x555554ab,
  0x33333300, 0x55555500,
  0x3333331a, 0x5555552b,
  0x33333327, 0x55555540,
  0x3333332d, 0x5555554b,
  0x33333330, 0x55555550,
  0x33333332, 0x55555553,
  0x33333333, 0x55555554,
  0x33333333, 0x55555555,
  0x33333333, 0x55555555,
  0x2aaaaaab, 0x3fffffff,
  0x40000000, 0x5ffffffe,
  0x4aaaaaab, 0x6ffffffe,
  0x50000000, 0x77fffffe,
  0x52aaaaab, 0x7bfffffe,
  0x54000000, 0x7dfffffe,
  0x54aaaaab, 0x7efffffe,
  0x55000000, 0x7f7ffffe,
  0x552aaaab, 0x7fbffffe,
  0x55400000, 0x7fdffffe,
  0x554aaaab, 0x7feffffe,
  0x55500000, 0x7ff7fffe,
  0x5552aaab, 0x7ffbfffe,
  0x55540000, 0x7ffdfffe,
  0x5554aaab, 0x7ffefffe,
  0x55550000, 0x7fff7ffe,
  0x55552aab, 0x7fffbffe,
  0x55554000, 0x7fffdffe,
  0x55554aab, 0x7fffeffe,
  0x55555000, 0x7ffff7fe,
  0x555552ab, 0x7ffffbfe,
  0x55555400, 0x7ffffdfe,
  0x555554ab, 0x7ffffefe,
  0x55555500, 0x7fffff7e,
  0x5555552b, 0x7fffffbe,
  0x55555540, 0x7fffffde,
  0x5555554b, 0x7fffffee,
  0x55555550, 0x7ffffff6,
  0x55555553, 0x7ffffffa,
  0x55555554, 0x7ffffffc,
  0x55555555, 0x7ffffffd,
  0x55555555, 0x7ffffffd,
  0x3fffffff, 0x3fffffff,
  0x5ffffffe, 0x5fffffff,
  0x6ffffffe, 0x6fffffff,
  0x77fffffe, 0x77ffffff,
  0x7bfffffe, 0x7bffffff,
  0x7dfffffe, 0x7dffffff,
  0x7efffffe, 0x7effffff,
  0x7f7ffffe, 0x7f7fffff,
  0x7fbffffe, 0x7fbfffff,
  0x7fdffffe, 0x7fdfffff,
  0x7feffffe, 0x7fefffff,
  0x7ff7fffe, 0x7ff7ffff,
  0x7ffbfffe, 0x7ffbffff,
  0x7ffdfffe, 0x7ffdffff,
  0x7ffefffe, 0x7ffeffff,
  0x7fff7ffe, 0x7fff7fff,
  0x7fffbffe, 0x7fffbfff,
  0x7fffdffe, 0x7fffdfff,
  0x7fffeffe, 0x7fffefff,
  0x7ffff7fe, 0x7ffff7ff,
  0x7ffffbfe, 0x7ffffbff,
  0x7ffffdfe, 0x7ffffdff,
  0x7ffffefe, 0x7ffffeff,
  0x7fffff7e, 0x7fffff7f,
  0x7fffffbe, 0x7fffffbf,
  0x7fffffde, 0x7fffffdf,
  0x7fffffee, 0x7fffffef,
  0x7ffffff6, 0x7ffffff7,
  0x7ffffffa, 0x7ffffffb,
  0x7ffffffc, 0x7ffffffd,
  0x7ffffffd, 0x7ffffffe,
  0x7ffffffd, 0x7ffffffe,
  0x3fffffff, 0x40000000,
  0x5fffffff, 0x60000000,
  0x6fffffff, 0x70000000,
  0x77ffffff, 0x78000000,
  0x7bffffff, 0x7c000000,
  0x7dffffff, 0x7e000000,
  0x7effffff, 0x7f000000,
  0x7f7fffff, 0x7f800000,
  0x7fbfffff, 0x7fc00000,
  0x7fdfffff, 0x7fe00000,
  0x7fefffff, 0x7ff00000,
  0x7ff7ffff, 0x7ff80000,
  0x7ffbffff, 0x7ffc0000,
  0x7ffdffff, 0x7ffe0000,
  0x7ffeffff, 0x7fff0000,
  0x7fff7fff, 0x7fff8000,
  0x7fffbfff, 0x7fffc000,
  0x7fffdfff, 0x7fffe000,
  0x7fffefff, 0x7ffff000,
  0x7ffff7ff, 0x7ffff800,
  0x7ffffbff, 0x7ffffc00,
  0x7ffffdff, 0x7ffffe00,
  0x7ffffeff, 0x7fffff00,
  0x7fffff7f, 0x7fffff80,
  0x7fffffbf, 0x7fffffc0,
  0x7fffffdf, 0x7fffffe0,
  0x7fffffef, 0x7ffffff0,
  0x7ffffff7, 0x7ffffff8,
  0x7ffffffb, 0x7ffffffc,
  0x7ffffffd, 0x7ffffffe,
  0x7ffffffe, 0x7fffffff,
  0x7ffffffe, 0x7fffffff,
  0x40000000, 0x40000000,
  0x60000000, 0x60000000,
  0x70000000, 0x70000000,
  0x78000000, 0x78000000,
  0x7c000000, 0x7c000000,
  0x7e000000, 0x7e000000,
  0x7f000000, 0x7f000000,
  0x7f800000, 0x7f800000,
  0x7fc00000, 0x7fc00000,
  0x7fe00000, 0x7fe00000,
  0x7ff00000, 0x7ff00000,
  0x7ff80000, 0x7ff80000,
  0x7ffc0000, 0x7ffc0000,
  0x7ffe0000, 0x7ffe0000,
  0x7fff0000, 0x7fff0000,
  0x7fff8000, 0x7fff8000,
  0x7fffc000, 0x7fffc000,
  0x7fffe000, 0x7fffe000,
  0x7ffff000, 0x7ffff000,
  0x7ffff800, 0x7ffff800,
  0x7ffffc00, 0x7ffffc00,
  0x7ffffe00, 0x7ffffe00,
  0x7fffff00, 0x7fffff00,
  0x7fffff80, 0x7fffff80,
  0x7fffffc0, 0x7fffffc0,
  0x7fffffe0, 0x7fffffe0,
  0x7ffffff0, 0x7ffffff0,
  0x7ffffff8, 0x7ffffff8,
  0x7ffffffc, 0x7ffffffc,
  0x7ffffffe, 0x7ffffffe,
  0x7fffffff, 0x7fffffff,
  0x7fffffff, 0x80000000,
  0x40000000, 0x40000001,
  0x60000000, 0x60000001,
  0x70000000, 0x70000001,
  0x78000000, 0x78000001,
  0x7c000000, 0x7c000001,
  0x7e000000, 0x7e000001,
  0x7f000000, 0x7f000001,
  0x7f800000, 0x7f800001,
  0x7fc00000, 0x7fc00001,
  0x7fe00000, 0x7fe00001,
  0x7ff00000, 0x7ff00001,
  0x7ff80000, 0x7ff80001,
  0x7ffc0000, 0x7ffc0001,
  0x7ffe0000, 0x7ffe0001,
  0x7fff0000, 0x7fff0001,
  0x7fff8000, 0x7fff8001,
  0x7fffc000, 0x7fffc001,
  0x7fffe000, 0x7fffe001,
  0x7ffff000, 0x7ffff001,
  0x7ffff800, 0x7ffff801,
  0x7ffffc00, 0x7ffffc01,
  0x7ffffe00, 0x7ffffe01,
  0x7fffff00, 0x7fffff01,
  0x7fffff80, 0x7fffff81,
  0x7fffffc0, 0x7fffffc1,
  0x7fffffe0, 0x7fffffe1,
  0x7ffffff0, 0x7ffffff1,
  0x7ffffff8, 0x7ffffff9,
  0x7ffffffc, 0x7ffffffd,
  0x7ffffffe, 0x7fffffff,
  0x7fffffff, 0x80000000,
  0x80000000, 0x80000001,
  0x40000001, 0x55555555,
  0x60000001, 0x80000000,
  0x70000001, 0x95555555,
  0x78000001, 0xa0000000,
  0x7c000001, 0xa5555555,
  0x7e000001, 0xa8000000,
  0x7f000001, 0xa9555555,
  0x7f800001, 0xaa000000,
  0x7fc00001, 0xaa555555,
  0x7fe00001, 0xaa800000,
  0x7ff00001, 0xaa955555,
  0x7ff80001, 0xaaa00000,
  0x7ffc0001, 0xaaa55555,
  0x7ffe0001, 0xaaa80000,
  0x7fff0001, 0xaaa95555,
  0x7fff8001, 0xaaaa0000,
  0x7fffc001, 0xaaaa5555,
  0x7fffe001, 0xaaaa8000,
  0x7ffff001, 0xaaaa9555,
  0x7ffff801, 0xaaaaa000,
  0x7ffffc01, 0xaaaaa555,
  0x7ffffe01, 0xaaaaa800,
  0x7fffff01, 0xaaaaa955,
  0x7fffff81, 0xaaaaaa00,
  0x7fffffc1, 0xaaaaaa55,
  0x7fffffe1, 0xaaaaaa80,
  0x7ffffff1, 0xaaaaaa95,
  0x7ffffff9, 0xaaaaaaa0,
  0x7ffffffd, 0xaaaaaaa5,
  0x7fffffff, 0xaaaaaaa8,
  0x80000000, 0xaaaaaaa9,
  0x80000001, 0xaaaaaaaa,
  0x55555555, 0x66666666,
  0x80000000, 0x99999999,
  0x95555555, 0xb3333333,
  0xa0000000, 0xc0000000,
  0xa5555555, 0xc6666666,
  0xa8000000, 0xc9999999,
  0xa9555555, 0xcb333333,
  0xaa000000, 0xcc000000,
  0xaa555555, 0xcc666666,
  0xaa800000, 0xcc999999,
  0xaa955555, 0xccb33333,
  0xaaa00000, 0xccc00000,
  0xaaa55555, 0xccc66666,
  0xaaa80000, 0xccc99999,
  0xaaa95555, 0xcccb3333,
  0xaaaa0000, 0xcccc0000,
  0xaaaa5555, 0xcccc6666,
  0xaaaa8000, 0xcccc9999,
  0xaaaa9555, 0xccccb333,
  0xaaaaa000, 0xccccc000,
  0xaaaaa555, 0xccccc666,
  0xaaaaa800, 0xccccc999,
  0xaaaaa955, 0xcccccb33,
  0xaaaaaa00, 0xcccccc00,
  0xaaaaaa55, 0xcccccc66,
  0xaaaaaa80, 0xcccccc99,
  0xaaaaaa95, 0xccccccb3,
  0xaaaaaaa0, 0xccccccc0,
  0xaaaaaaa5, 0xccccccc6,
  0xaaaaaaa8, 0xccccccc9,
  0xaaaaaaa9, 0xcccccccb,
  0xaaaaaaaa, 0xcccccccc,
  0x66666666, 0x7fffc000,
  0x99999999, 0xbfffa000,
  0xb3333333, 0xdfff9000,
  0xc0000000, 0xefff8800,
  0xc6666666, 0xf7ff8400,
  0xc9999999, 0xfbff8200,
  0xcb333333, 0xfdff8100,
  0xcc000000, 0xfeff8080,
  0xcc666666, 0xff7f8040,
  0xcc999999, 0xffbf8020,
  0xccb33333, 0xffdf8010,
  0xccc00000, 0xffef8008,
  0xccc66666, 0xfff78004,
  0xccc99999, 0xfffb8002,
  0xcccb3333, 0xfffd8001,
  0xcccc0000, 0xfffe8001,
  0xcccc6666, 0xffff0001,
  0xcccc9999, 0xffff4001,
  0xccccb333, 0xffff6001,
  0xccccc000, 0xffff7001,
  0xccccc666, 0xffff7801,
  0xccccc999, 0xffff7c01,
  0xcccccb33, 0xffff7e01,
  0xcccccc00, 0xffff7f01,
  0xcccccc66, 0xffff7f81,
  0xcccccc99, 0xffff7fc1,
  0xccccccb3, 0xffff7fe1,
  0xccccccc0, 0xffff7ff1,
  0xccccccc6, 0xffff7ff9,
  0xccccccc9, 0xffff7ffd,
  0xcccccccb, 0xffff7fff,
  0xcccccccc, 0xffff8000,
  0x7fffc000, 0x7fffc001,
  0xbfffa000, 0xbfffa001,
  0xdfff9000, 0xdfff9001,
  0xefff8800, 0xefff8801,
  0xf7ff8400, 0xf7ff8401,
  0xfbff8200, 0xfbff8201,
  0xfdff8100, 0xfdff8101,
  0xfeff8080, 0xfeff8081,
  0xff7f8040, 0xff7f8041,
  0xffbf8020, 0xffbf8021,
  0xffdf8010, 0xffdf8011,
  0xffef8008, 0xffef8009,
  0xfff78004, 0xfff78005,
  0xfffb8002, 0xfffb8003,
  0xfffd8001, 0xfffd8002,
  0xfffe8001, 0xfffe8002,
  0xffff0001, 0xffff0002,
  0xffff4001, 0xffff4002,
  0xffff6001, 0xffff6002,
  0xffff7001, 0xffff7002,
  0xffff7801, 0xffff7802,
  0xffff7c01, 0xffff7c02,
  0xffff7e01, 0xffff7e02,
  0xffff7f01, 0xffff7f02,
  0xffff7f81, 0xffff7f82,
  0xffff7fc1, 0xffff7fc2,
  0xffff7fe1, 0xffff7fe2,
  0xffff7ff1, 0xffff7ff2,
  0xffff7ff9, 0xffff7ffa,
  0xffff7ffd, 0xffff7ffe,
  0xffff7fff, 0xffff8000,
  0xffff8000, 0xffff8001,
  0x7fffc001, 0x7fffc001,
  0xbfffa001, 0xbfffa002,
  0xdfff9001, 0xdfff9002,
  0xefff8801, 0xefff8802,
  0xf7ff8401, 0xf7ff8402,
  0xfbff8201, 0xfbff8202,
  0xfdff8101, 0xfdff8102,
  0xfeff8081, 0xfeff8082,
  0xff7f8041, 0xff7f8042,
  0xffbf8021, 0xffbf8022,
  0xffdf8011, 0xffdf8012,
  0xffef8009, 0xffef800a,
  0xfff78005, 0xfff78006,
  0xfffb8003, 0xfffb8004,
  0xfffd8002, 0xfffd8003,
  0xfffe8002, 0xfffe8003,
  0xffff0002, 0xffff0003,
  0xffff4002, 0xffff4003,
  0xffff6002, 0xffff6003,
  0xffff7002, 0xffff7003,
  0xffff7802, 0xffff7803,
  0xffff7c02, 0xffff7c03,
  0xffff7e02, 0xffff7e03,
  0xffff7f02, 0xffff7f03,
  0xffff7f82, 0xffff7f83,
  0xffff7fc2, 0xffff7fc3,
  0xffff7fe2, 0xffff7fe3,
  0xffff7ff2, 0xffff7ff3,
  0xffff7ffa, 0xffff7ffb,
  0xffff7ffe, 0xffff7fff,
  0xffff8000, 0xffff8001,
  0xffff8001, 0xffff8002,
  0x7fffc001, 0x7fffc002,
  0xbfffa002, 0xbfffa003,
  0xdfff9002, 0xdfff9003,
  0xefff8802, 0xefff8803,
  0xf7ff8402, 0xf7ff8403,
  0xfbff8202, 0xfbff8203,
  0xfdff8102, 0xfdff8103,
  0xfeff8082, 0xfeff8083,
  0xff7f8042, 0xff7f8043,
  0xffbf8022, 0xffbf8023,
  0xffdf8012, 0xffdf8013,
  0xffef800a, 0xffef800b,
  0xfff78006, 0xfff78007,
  0xfffb8004, 0xfffb8005,
  0xfffd8003, 0xfffd8004,
  0xfffe8003, 0xfffe8004,
  0xffff0003, 0xffff0004,
  0xffff4003, 0xffff4004,
  0xffff6003, 0xffff6004,
  0xffff7003, 0xffff7004,
  0xffff7803, 0xffff7804,
  0xffff7c03, 0xffff7c04,
  0xffff7e03, 0xffff7e04,
  0xffff7f03, 0xffff7f04,
  0xffff7f83, 0xffff7f84,
  0xffff7fc3, 0xffff7fc4,
  0xffff7fe3, 0xffff7fe4,
  0xffff7ff3, 0xffff7ff4,
  0xffff7ffb, 0xffff7ffc,
  0xffff7fff, 0xffff8000,
  0xffff8001, 0xffff8002,
  0xffff8002, 0xffff8003,
  0x7fffc002, 0x7fffffc0,
  0xbfffa003, 0xbfffffa0,
  0xdfff9003, 0xdfffff90,
  0xefff8803, 0xefffff88,
  0xf7ff8403, 0xf7ffff84,
  0xfbff8203, 0xfbffff82,
  0xfdff8103, 0xfdffff81,
  0xfeff8083, 0xfeffff81,
  0xff7f8043, 0xff7fff81,
  0xffbf8023, 0xffbfff81,
  0xffdf8013, 0xffdfff81,
  0xffef800b, 0xffefff81,
  0xfff78007, 0xfff7ff81,
  0xfffb8005, 0xfffbff81,
  0xfffd8004, 0xfffdff81,
  0xfffe8004, 0xfffeff81,
  0xffff0004, 0xffff7f81,
  0xffff4004, 0xffffbf81,
  0xffff6004, 0xffffdf81,
  0xffff7004, 0xffffef81,
  0xffff7804, 0xfffff781,
  0xffff7c04, 0xfffffb81,
  0xffff7e04, 0xfffffd81,
  0xffff7f04, 0xfffffe81,
  0xffff7f84, 0xffffff01,
  0xffff7fc4, 0xffffff41,
  0xffff7fe4, 0xffffff61,
  0xffff7ff4, 0xffffff71,
  0xffff7ffc, 0xffffff79,
  0xffff8000, 0xffffff7d,
  0xffff8002, 0xffffff7f,
  0xffff8003, 0xffffff80,
  0x7fffffc0, 0x7fffffc1,
  0xbfffffa0, 0xbfffffa1,
  0xdfffff90, 0xdfffff91,
  0xefffff88, 0xefffff89,
  0xf7ffff84, 0xf7ffff85,
  0xfbffff82, 0xfbffff83,
  0xfdffff81, 0xfdffff82,
  0xfeffff81, 0xfeffff82,
  0xff7fff81, 0xff7fff82,
  0xffbfff81, 0xffbfff82,
  0xffdfff81, 0xffdfff82,
  0xffefff81, 0xffefff82,
  0xfff7ff81, 0xfff7ff82,
  0xfffbff81, 0xfffbff82,
  0xfffdff81, 0xfffdff82,
  0xfffeff81, 0xfffeff82,
  0xffff7f81, 0xffff7f82,
  0xffffbf81, 0xffffbf82,
  0xffffdf81, 0xffffdf82,
  0xffffef81, 0xffffef82,
  0xfffff781, 0xfffff782,
  0xfffffb81, 0xfffffb82,
  0xfffffd81, 0xfffffd82,
  0xfffffe81, 0xfffffe82,
  0xffffff01, 0xffffff02,
  0xffffff41, 0xffffff42,
  0xffffff61, 0xffffff62,
  0xffffff71, 0xffffff72,
  0xffffff79, 0xffffff7a,
  0xffffff7d, 0xffffff7e,
  0xffffff7f, 0xffffff80,
  0xffffff80, 0xffffff81,
  0x7fffffc1, 0x7fffffc1,
  0xbfffffa1, 0xbfffffa2,
  0xdfffff91, 0xdfffff92,
  0xefffff89, 0xefffff8a,
  0xf7ffff85, 0xf7ffff86,
  0xfbffff83, 0xfbffff84,
  0xfdffff82, 0xfdffff83,
  0xfeffff82, 0xfeffff83,
  0xff7fff82, 0xff7fff83,
  0xffbfff82, 0xffbfff83,
  0xffdfff82, 0xffdfff83,
  0xffefff82, 0xffefff83,
  0xfff7ff82, 0xfff7ff83,
  0xfffbff82, 0xfffbff83,
  0xfffdff82, 0xfffdff83,
  0xfffeff82, 0xfffeff83,
  0xffff7f82, 0xffff7f83,
  0xffffbf82, 0xffffbf83,
  0xffffdf82, 0xffffdf83,
  0xffffef82, 0xffffef83,
  0xfffff782, 0xfffff783,
  0xfffffb82, 0xfffffb83,
  0xfffffd82, 0xfffffd83,
  0xfffffe82, 0xfffffe83,
  0xffffff02, 0xffffff03,
  0xffffff42, 0xffffff43,
  0xffffff62, 0xffffff63,
  0xffffff72, 0xffffff73,
  0xffffff7a, 0xffffff7b,
  0xffffff7e, 0xffffff7f,
  0xffffff80, 0xffffff81,
  0xffffff81, 0xffffff82,
  0x7fffffc1, 0x7fffffc2,
  0xbfffffa2, 0xbfffffa3,
  0xdfffff92, 0xdfffff93,
  0xefffff8a, 0xefffff8b,
  0xf7ffff86, 0xf7ffff87,
  0xfbffff84, 0xfbffff85,
  0xfdffff83, 0xfdffff84,
  0xfeffff83, 0xfeffff84,
  0xff7fff83, 0xff7fff84,
  0xffbfff83, 0xffbfff84,
  0xffdfff83, 0xffdfff84,
  0xffefff83, 0xffefff84,
  0xfff7ff83, 0xfff7ff84,
  0xfffbff83, 0xfffbff84,
  0xfffdff83, 0xfffdff84,
  0xfffeff83, 0xfffeff84,
  0xffff7f83, 0xffff7f84,
  0xffffbf83, 0xffffbf84,
  0xffffdf83, 0xffffdf84,
  0xffffef83, 0xffffef84,
  0xfffff783, 0xfffff784,
  0xfffffb83, 0xfffffb84,
  0xfffffd83, 0xfffffd84,
  0xfffffe83, 0xfffffe84,
  0xffffff03, 0xffffff04,
  0xffffff43, 0xffffff44,
  0xffffff63, 0xffffff64,
  0xffffff73, 0xffffff74,
  0xffffff7b, 0xffffff7c,
  0xffffff7f, 0xffffff80,
  0xffffff81, 0xffffff82,
  0xffffff82, 0xffffff83,
  0x7fffffc2, 0x7ffffff0,
  0xbfffffa3, 0xbfffffe8,
  0xdfffff93, 0xdfffffe4,
  0xefffff8b, 0xefffffe2,
  0xf7ffff87, 0xf7ffffe1,
  0xfbffff85, 0xfbffffe1,
  0xfdffff84, 0xfdffffe1,
  0xfeffff84, 0xfeffffe1,
  0xff7fff84, 0xff7fffe1,
  0xffbfff84, 0xffbfffe1,
  0xffdfff84, 0xffdfffe1,
  0xffefff84, 0xffefffe1,
  0xfff7ff84, 0xfff7ffe1,
  0xfffbff84, 0xfffbffe1,
  0xfffdff84, 0xfffdffe1,
  0xfffeff84, 0xfffeffe1,
  0xffff7f84, 0xffff7fe1,
  0xffffbf84, 0xffffbfe1,
  0xffffdf84, 0xffffdfe1,
  0xffffef84, 0xffffefe1,
  0xfffff784, 0xfffff7e1,
  0xfffffb84, 0xfffffbe1,
  0xfffffd84, 0xfffffde1,
  0xfffffe84, 0xfffffee1,
  0xffffff04, 0xffffff61,
  0xffffff44, 0xffffffa1,
  0xffffff64, 0xffffffc1,
  0xffffff74, 0xffffffd1,
  0xffffff7c, 0xffffffd9,
  0xffffff80, 0xffffffdd,
  0xffffff82, 0xffffffdf,
  0xffffff83, 0xffffffe0,
  0x7ffffff0, 0x7fffffff,
  0xbfffffe8, 0xbffffffe,
  0xdfffffe4, 0xdffffffe,
  0xefffffe2, 0xeffffffe,
  0xf7ffffe1, 0xf7fffffe,
  0xfbffffe1, 0xfbfffffe,
  0xfdffffe1, 0xfdfffffe,
  0xfeffffe1, 0xfefffffe,
  0xff7fffe1, 0xff7ffffe,
  0xffbfffe1, 0xffbffffe,
  0xffdfffe1, 0xffdffffe,
  0xffefffe1, 0xffeffffe,
  0xfff7ffe1, 0xfff7fffe,
  0xfffbffe1, 0xfffbfffe,
  0xfffdffe1, 0xfffdfffe,
  0xfffeffe1, 0xfffefffe,
  0xffff7fe1, 0xffff7ffe,
  0xffffbfe1, 0xffffbffe,
  0xffffdfe1, 0xffffdffe,
  0xffffefe1, 0xffffeffe,
  0xfffff7e1, 0xfffff7fe,
  0xfffffbe1, 0xfffffbfe,
  0xfffffde1, 0xfffffdfe,
  0xfffffee1, 0xfffffefe,
  0xffffff61, 0xffffff7e,
  0xffffffa1, 0xffffffbe,
  0xffffffc1, 0xffffffde,
  0xffffffd1, 0xffffffee,
  0xffffffd9, 0xfffffff6,
  0xffffffdd, 0xfffffffa,
  0xffffffdf, 0xfffffffc,
  0xffffffe0, 0xfffffffd,
};
const unsigned kExpectedCount_NEON_ursra_2S_2OPIMM = 992;

#endif  // VIXL_SIM_URSRA_2S_2OPIMM_TRACE_AARCH64_H_
