/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tagStandard41h12_create()
{
   apriltag_family_t *tf = (apriltag_family_t *)calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tagStandard41h12");
   tf->h = 12;
   tf->ncodes = 2115;
   tf->codes = (uint64_t *)calloc(2115, sizeof(uint64_t));
   tf->codes[0] = 0x000001bd8a64ad10UL;
   tf->codes[1] = 0x000001bdc4f3b2d5UL;
   tf->codes[2] = 0x000001bdff82b89aUL;
   tf->codes[3] = 0x000001be3a11be5fUL;
   tf->codes[4] = 0x000001be74a0c424UL;
   tf->codes[5] = 0x000001beaf2fc9e9UL;
   tf->codes[6] = 0x000001bee9becfaeUL;
   tf->codes[7] = 0x000001bf244dd573UL;
   tf->codes[8] = 0x000001bf5edcdb38UL;
   tf->codes[9] = 0x000001bf996be0fdUL;
   tf->codes[10] = 0x000001bfd3fae6c2UL;
   tf->codes[11] = 0x000001c00e89ec87UL;
   tf->codes[12] = 0x000001c04918f24cUL;
   tf->codes[13] = 0x000001c0be36fdd6UL;
   tf->codes[14] = 0x000001c0f8c6039bUL;
   tf->codes[15] = 0x000001c133550960UL;
   tf->codes[16] = 0x000001c16de40f25UL;
   tf->codes[17] = 0x000001c21d912074UL;
   tf->codes[18] = 0x000001c258202639UL;
   tf->codes[19] = 0x000001c292af2bfeUL;
   tf->codes[20] = 0x000001c307cd3788UL;
   tf->codes[21] = 0x000001c37ceb4312UL;
   tf->codes[22] = 0x000001c3b77a48d7UL;
   tf->codes[23] = 0x000001c3f2094e9cUL;
   tf->codes[24] = 0x000001c42c985461UL;
   tf->codes[25] = 0x000001c4a1b65febUL;
   tf->codes[26] = 0x000001c4dc4565b0UL;
   tf->codes[27] = 0x000001c516d46b75UL;
   tf->codes[28] = 0x000001c55163713aUL;
   tf->codes[29] = 0x000001c63b9f884eUL;
   tf->codes[30] = 0x000001c6762e8e13UL;
   tf->codes[31] = 0x000001c6eb4c999dUL;
   tf->codes[32] = 0x000001c725db9f62UL;
   tf->codes[33] = 0x000001c7606aa527UL;
   tf->codes[34] = 0x000001c7d588b0b1UL;
   tf->codes[35] = 0x000001c81017b676UL;
   tf->codes[36] = 0x000001c84aa6bc3bUL;
   tf->codes[37] = 0x000001c88535c200UL;
   tf->codes[38] = 0x000001c8bfc4c7c5UL;
   tf->codes[39] = 0x000001c96f71d914UL;
   tf->codes[40] = 0x000001c9e48fe49eUL;
   tf->codes[41] = 0x000001ca1f1eea63UL;
   tf->codes[42] = 0x000001ca59adf028UL;
   tf->codes[43] = 0x000001cb095b0177UL;
   tf->codes[44] = 0x000001cb43ea073cUL;
   tf->codes[45] = 0x000001cbb90812c6UL;
   tf->codes[46] = 0x000001cc68b52415UL;
   tf->codes[47] = 0x000001cca34429daUL;
   tf->codes[48] = 0x000001ccddd32f9fUL;
   tf->codes[49] = 0x000001cd18623564UL;
   tf->codes[50] = 0x000001cd8d8040eeUL;
   tf->codes[51] = 0x000001cdc80f46b3UL;
   tf->codes[52] = 0x000001ce029e4c78UL;
   tf->codes[53] = 0x000001ce77bc5802UL;
   tf->codes[54] = 0x000001ceb24b5dc7UL;
   tf->codes[55] = 0x000001ceecda638cUL;
   tf->codes[56] = 0x000001cf27696951UL;
   tf->codes[57] = 0x000001cf9c8774dbUL;
   tf->codes[58] = 0x000001d086c38befUL;
   tf->codes[59] = 0x000001d136709d3eUL;
   tf->codes[60] = 0x000001d1ab8ea8c8UL;
   tf->codes[61] = 0x000001d25b3bba17UL;
   tf->codes[62] = 0x000001d295cabfdcUL;
   tf->codes[63] = 0x000001d30ae8cb66UL;
   tf->codes[64] = 0x000001d3f524e27aUL;
   tf->codes[65] = 0x000001d42fb3e83fUL;
   tf->codes[66] = 0x000001d46a42ee04UL;
   tf->codes[67] = 0x000001d4a4d1f3c9UL;
   tf->codes[68] = 0x000001d519efff53UL;
   tf->codes[69] = 0x000001d5547f0518UL;
   tf->codes[70] = 0x000001d5c99d10a2UL;
   tf->codes[71] = 0x000001d6042c1667UL;
   tf->codes[72] = 0x000001d6794a21f1UL;
   tf->codes[73] = 0x000001d6ee682d7bUL;
   tf->codes[74] = 0x000001d763863905UL;
   tf->codes[75] = 0x000001d7d8a4448fUL;
   tf->codes[76] = 0x000001d813334a54UL;
   tf->codes[77] = 0x000001d84dc25019UL;
   tf->codes[78] = 0x000001d8885155deUL;
   tf->codes[79] = 0x000001d8c2e05ba3UL;
   tf->codes[80] = 0x000001d8fd6f6168UL;
   tf->codes[81] = 0x000001d9e7ab787cUL;
   tf->codes[82] = 0x000001da5cc98406UL;
   tf->codes[83] = 0x000001da975889cbUL;
   tf->codes[84] = 0x000001db0c769555UL;
   tf->codes[85] = 0x000001db47059b1aUL;
   tf->codes[86] = 0x000001dbbc23a6a4UL;
   tf->codes[87] = 0x000001dbf6b2ac69UL;
   tf->codes[88] = 0x000001dca65fbdb8UL;
   tf->codes[89] = 0x000001dce0eec37dUL;
   tf->codes[90] = 0x000001ddcb2ada91UL;
   tf->codes[91] = 0x000001df651402f4UL;
   tf->codes[92] = 0x000001df9fa308b9UL;
   tf->codes[93] = 0x000001e014c11443UL;
   tf->codes[94] = 0x000001e223c84830UL;
   tf->codes[95] = 0x000001e25e574df5UL;
   tf->codes[96] = 0x000001e383226aceUL;
   tf->codes[97] = 0x000001e3bdb17093UL;
   tf->codes[98] = 0x000001e4a7ed87a7UL;
   tf->codes[99] = 0x000001e4e27c8d6cUL;
   tf->codes[100] = 0x000001e51d0b9331UL;
   tf->codes[101] = 0x000001e592299ebbUL;
   tf->codes[102] = 0x000001e60747aa45UL;
   tf->codes[103] = 0x000001e67c65b5cfUL;
   tf->codes[104] = 0x000001e6b6f4bb94UL;
   tf->codes[105] = 0x000001e766a1cce3UL;
   tf->codes[106] = 0x000001e9008af546UL;
   tf->codes[107] = 0x000001e9eac70c5aUL;
   tf->codes[108] = 0x000001ea2556121fUL;
   tf->codes[109] = 0x000001ead503236eUL;
   tf->codes[110] = 0x000001eb84b034bdUL;
   tf->codes[111] = 0x000001edce466e6fUL;
   tf->codes[112] = 0x000001eeb8828583UL;
   tf->codes[113] = 0x000001eef3118b48UL;
   tf->codes[114] = 0x000001ef2da0910dUL;
   tf->codes[115] = 0x000001f0526bade6UL;
   tf->codes[116] = 0x000001f10218bf35UL;
   tf->codes[117] = 0x000001f1b1c5d084UL;
   tf->codes[118] = 0x000001f226e3dc0eUL;
   tf->codes[119] = 0x000001f34baef8e7UL;
   tf->codes[120] = 0x000001f3c0cd0471UL;
   tf->codes[121] = 0x000001f435eb0ffbUL;
   tf->codes[122] = 0x000001f55ab62cd4UL;
   tf->codes[123] = 0x000001f5cfd4385eUL;
   tf->codes[124] = 0x000001f67f8149adUL;
   tf->codes[125] = 0x000001f7dedb6c4bUL;
   tf->codes[126] = 0x000001f88e887d9aUL;
   tf->codes[127] = 0x000001f8c917835fUL;
   tf->codes[128] = 0x000001f903a68924UL;
   tf->codes[129] = 0x000001f9b3539a73UL;
   tf->codes[130] = 0x000001fa9d8fb187UL;
   tf->codes[131] = 0x000001fd21b4f0feUL;
   tf->codes[132] = 0x000001fd5c43f6c3UL;
   tf->codes[133] = 0x000001fe0bf10812UL;
   tf->codes[134] = 0x00000000558741c4UL;
   tf->codes[135] = 0x00000000caa54d4eUL;
   tf->codes[136] = 0x000000013fc358d8UL;
   tf->codes[137] = 0x00000002d9ac813bUL;
   tf->codes[138] = 0x000000034eca8cc5UL;
   tf->codes[139] = 0x000000038959928aUL;
   tf->codes[140] = 0x000000043906a3d9UL;
   tf->codes[141] = 0x00000004ae24af63UL;
   tf->codes[142] = 0x00000004e8b3b528UL;
   tf->codes[143] = 0x000000052342baedUL;
   tf->codes[144] = 0x0000000857150bb3UL;
   tf->codes[145] = 0x00000009b66f2e51UL;
   tf->codes[146] = 0x0000000adb3a4b2aUL;
   tf->codes[147] = 0x0000000b8ae75c79UL;
   tf->codes[148] = 0x0000000e499ba1b5UL;
   tf->codes[149] = 0x0000000f6e66be8eUL;
   tf->codes[150] = 0x00000010cdc0e12cUL;
   tf->codes[151] = 0x0000001142deecb6UL;
   tf->codes[152] = 0x0000001351e620a3UL;
   tf->codes[153] = 0x000000143c2237b7UL;
   tf->codes[154] = 0x00000017356582b8UL;
   tf->codes[155] = 0x00000017aa838e42UL;
   tf->codes[156] = 0x000000181fa199ccUL;
   tf->codes[157] = 0x00000018cf4eab1bUL;
   tf->codes[158] = 0x00000019446cb6a5UL;
   tf->codes[159] = 0x0000001aa3c6d943UL;
   tf->codes[160] = 0x0000001b8e02f057UL;
   tf->codes[161] = 0x0000001bc891f61cUL;
   tf->codes[162] = 0x0000001e4cb73593UL;
   tf->codes[163] = 0x00000022303697a8UL;
   tf->codes[164] = 0x000000231a72aebcUL;
   tf->codes[165] = 0x00000023ca1fc00bUL;
   tf->codes[166] = 0x0000002688d40547UL;
   tf->codes[167] = 0x00000026c3630b0cUL;
   tf->codes[168] = 0x0000002738811696UL;
   tf->codes[169] = 0x00000027e82e27e5UL;
   tf->codes[170] = 0x000000290cf944beUL;
   tf->codes[171] = 0x0000002b568f7e70UL;
   tf->codes[172] = 0x0000002b911e8435UL;
   tf->codes[173] = 0x0000002c063c8fbfUL;
   tf->codes[174] = 0x0000002cb5e9a10eUL;
   tf->codes[175] = 0x0000002d2b07ac98UL;
   tf->codes[176] = 0x0000002e1543c3acUL;
   tf->codes[177] = 0x0000002e4fd2c971UL;
   tf->codes[178] = 0x0000002f3a0ee085UL;
   tf->codes[179] = 0x00000031f8c325c1UL;
   tf->codes[180] = 0x000000326de1314bUL;
   tf->codes[181] = 0x00000035a1b38211UL;
   tf->codes[182] = 0x0000003651609360UL;
   tf->codes[183] = 0x000000368bef9925UL;
   tf->codes[184] = 0x000000373b9caa74UL;
   tf->codes[185] = 0x00000037b0bab5feUL;
   tf->codes[186] = 0x0000003b1f1c0c89UL;
   tf->codes[187] = 0x0000003b59ab124eUL;
   tf->codes[188] = 0x0000003bcec91dd8UL;
   tf->codes[189] = 0x0000003c0958239dUL;
   tf->codes[190] = 0x0000003d68b2463bUL;
   tf->codes[191] = 0x0000003e185f578aUL;
   tf->codes[192] = 0x0000003e52ee5d4fUL;
   tf->codes[193] = 0x00000042366dbf64UL;
   tf->codes[194] = 0x0000004320a9d678UL;
   tf->codes[195] = 0x000000435b38dc3dUL;
   tf->codes[196] = 0x0000004395c7e202UL;
   tf->codes[197] = 0x000000444574f351UL;
   tf->codes[198] = 0x000000452fb10a65UL;
   tf->codes[199] = 0x00000045a4cf15efUL;
   tf->codes[200] = 0x0000004aad1994ddUL;
   tf->codes[201] = 0x0000004e5609f12dUL;
   tf->codes[202] = 0x000000506511251aUL;
   tf->codes[203] = 0x00000052e9366491UL;
   tf->codes[204] = 0x000000535e54701bUL;
   tf->codes[205] = 0x00000053d3727ba5UL;
   tf->codes[206] = 0x00000054831f8cf4UL;
   tf->codes[207] = 0x000000565797bb1cUL;
   tf->codes[208] = 0x0000005bd5004594UL;
   tf->codes[209] = 0x0000005c0f8f4b59UL;
   tf->codes[210] = 0x0000005de4077981UL;
   tf->codes[211] = 0x0000005f08d2965aUL;
   tf->codes[212] = 0x000000602d9db333UL;
   tf->codes[213] = 0x00000064c0ca2697UL;
   tf->codes[214] = 0x0000006535e83221UL;
   tf->codes[215] = 0x00000065e5954370UL;
   tf->codes[216] = 0x000000665ab34efaUL;
   tf->codes[217] = 0x00000066cfd15a84UL;
   tf->codes[218] = 0x00000067ba0d7198UL;
   tf->codes[219] = 0x000000682f2b7d22UL;
   tf->codes[220] = 0x0000006953f699fbUL;
   tf->codes[221] = 0x00000069c914a585UL;
   tf->codes[222] = 0x0000006a03a3ab4aUL;
   tf->codes[223] = 0x0000006b286ec823UL;
   tf->codes[224] = 0x0000006c87c8eac1UL;
   tf->codes[225] = 0x0000006d720501d5UL;
   tf->codes[226] = 0x0000006f810c35c2UL;
   tf->codes[227] = 0x0000006fbb9b3b87UL;
   tf->codes[228] = 0x00000071caa26f74UL;
   tf->codes[229] = 0x00000073648b97d7UL;
   tf->codes[230] = 0x000000741438a926UL;
   tf->codes[231] = 0x000000757392cbc4UL;
   tf->codes[232] = 0x0000007dea3ea13dUL;
   tf->codes[233] = 0x0000007ed47ab851UL;
   tf->codes[234] = 0x000000827d6b14a1UL;
   tf->codes[235] = 0x00000082f289202bUL;
   tf->codes[236] = 0x000000832d1825f0UL;
   tf->codes[237] = 0x0000008367a72bb5UL;
   tf->codes[238] = 0x00000083dcc5373fUL;
   tf->codes[239] = 0x000000886ff1aaa3UL;
   tf->codes[240] = 0x0000008a09dad306UL;
   tf->codes[241] = 0x0000008a4469d8cbUL;
   tf->codes[242] = 0x0000008cc88f1842UL;
   tf->codes[243] = 0x0000008d3dad23ccUL;
   tf->codes[244] = 0x0000008ded5a351bUL;
   tf->codes[245] = 0x0000008f87435d7eUL;
   tf->codes[246] = 0x00000090717f7492UL;
   tf->codes[247] = 0x000000915bbb8ba6UL;
   tf->codes[248] = 0x00000092f5a4b409UL;
   tf->codes[249] = 0x000000974e4221a8UL;
   tf->codes[250] = 0x0000009997d85b5aUL;
   tf->codes[251] = 0x0000009a47856ca9UL;
   tf->codes[252] = 0x0000009e2b04cebeUL;
   tf->codes[253] = 0x000000a0e9b913faUL;
   tf->codes[254] = 0x000000a36dde5371UL;
   tf->codes[255] = 0x000000a8b0b7d824UL;
   tf->codes[256] = 0x000000a8eb46dde9UL;
   tf->codes[257] = 0x000000aa1011fac2UL;
   tf->codes[258] = 0x000000ac59a83474UL;
   tf->codes[259] = 0x000000afc8098affUL;
   tf->codes[260] = 0x000000b24c2eca76UL;
   tf->codes[261] = 0x000000b2fbdbdbc5UL;
   tf->codes[262] = 0x000000b3e617f2d9UL;
   tf->codes[263] = 0x000000b545721577UL;
   tf->codes[264] = 0x000000ba132d8ea0UL;
   tf->codes[265] = 0x000000c005b424a2UL;
   tf->codes[266] = 0x000000c3e93386b7UL;
   tf->codes[267] = 0x000000c5488da955UL;
   tf->codes[268] = 0x000000c5f83abaa4UL;
   tf->codes[269] = 0x000000c9669c112fUL;
   tf->codes[270] = 0x000000cdbf397eceUL;
   tf->codes[271] = 0x000000ce34578a58UL;
   tf->codes[272] = 0x000000cea97595e2UL;
   tf->codes[273] = 0x000000d426de205aUL;
   tf->codes[274] = 0x000000dbeddce484UL;
   tf->codes[275] = 0x000000ddc25512acUL;
   tf->codes[276] = 0x000000e75dcc04feUL;
   tf->codes[277] = 0x000000ebb669729dUL;
   tf->codes[278] = 0x000000ef99e8d4b2UL;
   tf->codes[279] = 0x000000f0f942f750UL;
   tf->codes[280] = 0x000000f342d93102UL;
   tf->codes[281] = 0x000000f6ebc98d52UL;
   tf->codes[282] = 0x000000fa1f9bde18UL;
   tf->codes[283] = 0x000000fb09d7f52cUL;
   tf->codes[284] = 0x000000fbf4140c40UL;
   tf->codes[285] = 0x000000feed575741UL;
   tf->codes[286] = 0x0000010345f4c4e0UL;
   tf->codes[287] = 0x000001051a6cf308UL;
   tf->codes[288] = 0x000001084e3f43ceUL;
   tf->codes[289] = 0x00000109387b5ae2UL;
   tf->codes[290] = 0x00000109e8286c31UL;
   tf->codes[291] = 0x0000010a5d4677bbUL;
   tf->codes[292] = 0x0000010b0cf3890aUL;
   tf->codes[293] = 0x0000010c31bea5e3UL;
   tf->codes[294] = 0x0000010d5689c2bcUL;
   tf->codes[295] = 0x0000010e0636d40bUL;
   tf->codes[296] = 0x000001129963476fUL;
   tf->codes[297] = 0x00000113839f5e83UL;
   tf->codes[298] = 0x0000011a25d305d4UL;
   tf->codes[299] = 0x0000011b4a9e22adUL;
   tf->codes[300] = 0x0000011bbfbc2e37UL;
   tf->codes[301] = 0x0000011dcec36224UL;
   tf->codes[302] = 0x0000011ef38e7efdUL;
   tf->codes[303] = 0x0000011f68ac8a87UL;
   tf->codes[304] = 0x0000011fddca9611UL;
   tf->codes[305] = 0x0000012018599bd6UL;
   tf->codes[306] = 0x0000012052e8a19bUL;
   tf->codes[307] = 0x0000012a9e0ca53cUL;
   tf->codes[308] = 0x0000013056043579UL;
   tf->codes[309] = 0x0000013523bfaea2UL;
   tf->codes[310] = 0x00000140ce3dd4e1UL;
   tf->codes[311] = 0x00000142dd4508ceUL;
   tf->codes[312] = 0x0000014a2f25c16eUL;
   tf->codes[313] = 0x0000014aded2d2bdUL;
   tf->codes[314] = 0x0000014e12a52383UL;
   tf->codes[315] = 0x00000152a5d196e7UL;
   tf->codes[316] = 0x00000153557ea836UL;
   tf->codes[317] = 0x00000154052bb985UL;
   tf->codes[318] = 0x00000154b4d8cad4UL;
   tf->codes[319] = 0x00000154ef67d099UL;
   tf->codes[320] = 0x00000157ae1c15d5UL;
   tf->codes[321] = 0x00000157e8ab1b9aUL;
   tf->codes[322] = 0x0000015b1c7d6c60UL;
   tf->codes[323] = 0x00000162e37c308aUL;
   tf->codes[324] = 0x00000169c03edda0UL;
   tf->codes[325] = 0x0000016ec8895c8eUL;
   tf->codes[326] = 0x0000016f3da76818UL;
   tf->codes[327] = 0x00000171121f9640UL;
   tf->codes[328] = 0x00000182af245281UL;
   tf->codes[329] = 0x0000018aeb412235UL;
   tf->codes[330] = 0x0000018b9aee3384UL;
   tf->codes[331] = 0x000001920292d510UL;
   tf->codes[332] = 0x00000195e6123725UL;
   tf->codes[333] = 0x0000019ab3cdb04eUL;
   tf->codes[334] = 0x0000019bd898cd27UL;
   tf->codes[335] = 0x0000019d37f2efc5UL;
   tf->codes[336] = 0x000001a2b55b7a3dUL;
   tf->codes[337] = 0x000001a6d369e217UL;
   tf->codes[338] = 0x000001adeabb94f2UL;
   tf->codes[339] = 0x000001b3dd422af4UL;
   tf->codes[340] = 0x000001ba7f75d245UL;
   tf->codes[341] = 0x000001bb2f22e394UL;
   tf->codes[342] = 0x000001c15c387f5bUL;
   tf->codes[343] = 0x000001c6d9a109d3UL;
   tf->codes[344] = 0x000001cc91989a10UL;
   tf->codes[345] = 0x000001d83c16c04fUL;
   tf->codes[346] = 0x000001e127e0a152UL;
   tf->codes[347] = 0x000001e42123ec53UL;
   tf->codes[348] = 0x000001e6dfd8318fUL;
   tf->codes[349] = 0x000001e879c159f2UL;
   tf->codes[350] = 0x000001f75811d0f7UL;
   tf->codes[351] = 0x000001f87cdcedd0UL;
   tf->codes[352] = 0x000001f8f1faf95aUL;
   tf->codes[353] = 0x0000000168a6ced3UL;
   tf->codes[354] = 0x0000000a19e1aa11UL;
   tf->codes[355] = 0x0000000b3eacc6eaUL;
   tf->codes[356] = 0x0000000e37f011ebUL;
   tf->codes[357] = 0x0000001081864b9dUL;
   tf->codes[358] = 0x000000188314158cUL;
   tf->codes[359] = 0x0000001f5fd6c2a2UL;
   tf->codes[360] = 0x000000216eddf68fUL;
   tf->codes[361] = 0x00000038fe6948d2UL;
   tf->codes[362] = 0x0000003fa09cf023UL;
   tf->codes[363] = 0x00000041ea3329d5UL;
   tf->codes[364] = 0x0000004caa753900UL;
   tf->codes[365] = 0x0000004dcf4055d9UL;
   tf->codes[366] = 0x00000052d78ad4c7UL;
   tf->codes[367] = 0x00000056807b3117UL;
   tf->codes[368] = 0x00000058ca116ac9UL;
   tf->codes[369] = 0x0000005ebc9800cbUL;
   tf->codes[370] = 0x0000006265885d1bUL;
   tf->codes[371] = 0x00000070942bc2d1UL;
   tf->codes[372] = 0x000000738d6f0dd2UL;
   tf->codes[373] = 0x0000007adf4fc672UL;
   tf->codes[374] = 0x00000085da20db62UL;
   tf->codes[375] = 0x0000008a6d4d4ec6UL;
   tf->codes[376] = 0x0000008ae26b5a50UL;
   tf->codes[377] = 0x0000008b92186b9fUL;
   tf->codes[378] = 0x0000008ec5eabc65UL;
   tf->codes[379] = 0x00000096525a7acaUL;
   tf->codes[380] = 0x000000a0d80d8430UL;
   tf->codes[381] = 0x000000a5a5c8fd59UL;
   tf->codes[382] = 0x000000a9142a53e4UL;
   tf->codes[383] = 0x000000b48419745eUL;
   tf->codes[384] = 0x000000b86798d673UL;
   tf->codes[385] = 0x000000c6963c3c29UL;
   tf->codes[386] = 0x000000ca3f2c9879UL;
   tf->codes[387] = 0x000000f0e7976786UL;
   tf->codes[388] = 0x000000f41b69b84cUL;
   tf->codes[389] = 0x000000fe668dbbedUL;
   tf->codes[390] = 0x000000ff163acd3cUL;
   tf->codes[391] = 0x000001015fd106eeUL;
   tf->codes[392] = 0x0000010fc9037269UL;
   tf->codes[393] = 0x0000011e6cc4e3a9UL;
   tf->codes[394] = 0x00000136716e4176UL;
   tf->codes[395] = 0x0000013f97c7283eUL;
   tf->codes[396] = 0x00000142567b6d7aUL;
   tf->codes[397] = 0x00000148f8af14cbUL;
   tf->codes[398] = 0x0000014a92983d2eUL;
   tf->codes[399] = 0x0000014ca19f711bUL;
   tf->codes[400] = 0x0000014d16bd7ca5UL;
   tf->codes[401] = 0x00000157d6ff8bd0UL;
   tf->codes[402] = 0x0000015eee513eabUL;
   tf->codes[403] = 0x0000016ca7d698d7UL;
   tf->codes[404] = 0x00000174a96462c6UL;
   tf->codes[405] = 0x0000017593a079daUL;
   tf->codes[406] = 0x00000177a2a7adc7UL;
   tf->codes[407] = 0x000001808e718ecaUL;
   tf->codes[408] = 0x00000181038f9a54UL;
   tf->codes[409] = 0x00000190918d22a8UL;
   tf->codes[410] = 0x0000019e1083770fUL;
   tf->codes[411] = 0x000001ac3f26dcc5UL;
   tf->codes[412] = 0x000001b47b43ac79UL;
   tf->codes[413] = 0x000001b8d3e11a18UL;
   tf->codes[414] = 0x000001bbcd246519UL;
   tf->codes[415] = 0x000001efb9f682c8UL;
   tf->codes[416] = 0x00000005af98aca8UL;
   tf->codes[417] = 0x00000026a00beb78UL;
   tf->codes[418] = 0x0000005808b8c9b0UL;
   tf->codes[419] = 0x000000654d201852UL;
   tf->codes[420] = 0x0000007c2cfe5946UL;
   tf->codes[421] = 0x0000008d1a560438UL;
   tf->codes[422] = 0x000000a4e4705c40UL;
   tf->codes[423] = 0x000000a81842ad06UL;
   tf->codes[424] = 0x000000bce919ba0dUL;
   tf->codes[425] = 0x000000c5253689c1UL;
   tf->codes[426] = 0x000000d4edc317daUL;
   tf->codes[427] = 0x000000eaa8d63bf5UL;
   tf->codes[428] = 0x0000010fb757e29fUL;
   tf->codes[429] = 0x00000119c7ece07bUL;
   tf->codes[430] = 0x00000137bf1cd44aUL;
   tf->codes[431] = 0x00000141cfb1d226UL;
   tf->codes[432] = 0x0000015c58806f6aUL;
   tf->codes[433] = 0x00000165444a506dUL;
   tf->codes[434] = 0x0000016babeef1f9UL;
   tf->codes[435] = 0x0000016d0b491497UL;
   tf->codes[436] = 0x000001875988ac16UL;
   tf->codes[437] = 0x00000190f4ff9e68UL;
   tf->codes[438] = 0x00000198f68d6857UL;
   tf->codes[439] = 0x000001a60065b134UL;
   tf->codes[440] = 0x000001ad17b7640fUL;
   tf->codes[441] = 0x000001af26be97fcUL;
   tf->codes[442] = 0x000001b22001e2fdUL;
   tf->codes[443] = 0x000001b469981cafUL;
   tf->codes[444] = 0x000001b84d177ec4UL;
   tf->codes[445] = 0x000001b9ac71a162UL;
   tf->codes[446] = 0x000001ba5c1eb2b1UL;
   tf->codes[447] = 0x000001ce42b9a8a4UL;
   tf->codes[448] = 0x000001d13bfcf3a5UL;
   tf->codes[449] = 0x000001dad773e5f7UL;
   tf->codes[450] = 0x000001dcabec141fUL;
   tf->codes[451] = 0x000001e01a4d6aaaUL;
   tf->codes[452] = 0x000001e1048981beUL;
   tf->codes[453] = 0x000001e388aec135UL;
   tf->codes[454] = 0x000001e97b355737UL;
   tf->codes[455] = 0x000001fe4c0c643eUL;
   tf->codes[456] = 0x00000015db97b681UL;
   tf->codes[457] = 0x00000042eba7271aUL;
   tf->codes[458] = 0x000000444b0149b8UL;
   tf->codes[459] = 0x0000004bd771081dUL;
   tf->codes[460] = 0x0000007fc44325ccUL;
   tf->codes[461] = 0x000000992846a637UL;
   tf->codes[462] = 0x0000009b71dcdfe9UL;
   tf->codes[463] = 0x000000b71f769a06UL;
   tf->codes[464] = 0x000000c254d6b4bbUL;
   tf->codes[465] = 0x000000e5c96f3302UL;
   tf->codes[466] = 0x000000f8c5ce11e1UL;
   tf->codes[467] = 0x000000fe08a79694UL;
   tf->codes[468] = 0x000001090378ab84UL;
   tf->codes[469] = 0x000001093e07b149UL;
   tf->codes[470] = 0x0000010bc22cf0c0UL;
   tf->codes[471] = 0x0000010ef5ff4186UL;
   tf->codes[472] = 0x0000011b502a7914UL;
   tf->codes[473] = 0x00000126858a93c9UL;
   tf->codes[474] = 0x0000012b53460cf2UL;
   tf->codes[475] = 0x00000142a8425970UL;
   tf->codes[476] = 0x0000015f7aa73066UL;
   tf->codes[477] = 0x000001a0e66fa27cUL;
   tf->codes[478] = 0x000001d5bd7dd73fUL;
   tf->codes[479] = 0x000001ddf99aa6f3UL;
   tf->codes[480] = 0x00000010c1a1a7c9UL;
   tf->codes[481] = 0x0000001b81e3b6f4UL;
   tf->codes[482] = 0x00000021e9885880UL;
   tf->codes[483] = 0x000000259278b4d0UL;
   tf->codes[484] = 0x0000003ad86dcd61UL;
   tf->codes[485] = 0x0000003ef67c353bUL;
   tf->codes[486] = 0x00000099169b166dUL;
   tf->codes[487] = 0x000000a2eca10e84UL;
   tf->codes[488] = 0x000000b4fec3d64fUL;
   tf->codes[489] = 0x000000b70dcb0a3cUL;
   tf->codes[490] = 0x000000b832962715UL;
   tf->codes[491] = 0x000000cbdea21743UL;
   tf->codes[492] = 0x000000ced7e56244UL;
   tf->codes[493] = 0x000000de65e2ea98UL;
   tf->codes[494] = 0x000000f002e7a6d9UL;
   tf->codes[495] = 0x0000012589a2ecebUL;
   tf->codes[496] = 0x00000149e8778246UL;
   tf->codes[497] = 0x000001672ffa64c6UL;
   tf->codes[498] = 0x000001be56d5faf7UL;
   tf->codes[499] = 0x000001ec8bb08869UL;
   tf->codes[500] = 0x000001f5777a696cUL;
   tf->codes[501] = 0x00000017c747cadaUL;
   tf->codes[502] = 0x000000454c7546fdUL;
   tf->codes[503] = 0x0000007d91e4d24bUL;
   tf->codes[504] = 0x000000bb1a2de24cUL;
   tf->codes[505] = 0x000001070ba95dc8UL;
   tf->codes[506] = 0x000001274c6f8b49UL;
   tf->codes[507] = 0x0000012920e7b971UL;
   tf->codes[508] = 0x0000014a4be9fe06UL;
   tf->codes[509] = 0x0000015003e18e43UL;
   tf->codes[510] = 0x0000017f22f832c9UL;
   tf->codes[511] = 0x000001f3cbe5b13fUL;
   tf->codes[512] = 0x000001fd2ccd9dccUL;
   tf->codes[513] = 0x0000001cbde6b9feUL;
   tf->codes[514] = 0x0000001ff1b90ac4UL;
   tf->codes[515] = 0x0000002cfb9153a1UL;
   tf->codes[516] = 0x000000302f63a467UL;
   tf->codes[517] = 0x0000004e61229dfbUL;
   tf->codes[518] = 0x000000a00a95a9b4UL;
   tf->codes[519] = 0x000000b21cb8717fUL;
   tf->codes[520] = 0x000000dd584fb3f0UL;
   tf->codes[521] = 0x0000012615f8dea6UL;
   tf->codes[522] = 0x0000012f76e0cb33UL;
   tf->codes[523] = 0x0000013fb48b64d6UL;
   tf->codes[524] = 0x0000016e5e83fdd2UL;
   tf->codes[525] = 0x00000170a81a3784UL;
   tf->codes[526] = 0x0000019506eeccdfUL;
   tf->codes[527] = 0x000001aa4ce3e570UL;
   tf->codes[528] = 0x00000058257d0648UL;
   tf->codes[529] = 0x000000640a8a324cUL;
   tf->codes[530] = 0x0000007e9358cf90UL;
   tf->codes[531] = 0x0000008b28130ce3UL;
   tf->codes[532] = 0x000000c4ccdcbacfUL;
   tf->codes[533] = 0x000000c71672f481UL;
   tf->codes[534] = 0x000000d45ada4323UL;
   tf->codes[535] = 0x000001181038eeebUL;
   tf->codes[536] = 0x0000014dd1833ac2UL;
   tf->codes[537] = 0x00000163c72564a2UL;
   tf->codes[538] = 0x0000017ec5120d70UL;
   tf->codes[539] = 0x0000002dfd0550e6UL;
   tf->codes[540] = 0x000000484b44e865UL;
   tf->codes[541] = 0x00000079b3f1c69dUL;
   tf->codes[542] = 0x000000c6551a5368UL;
   tf->codes[543] = 0x000000ee976e4ad8UL;
   tf->codes[544] = 0x0000011f506e17c1UL;
   tf->codes[545] = 0x0000015636838071UL;
   tf->codes[546] = 0x0000017eedf5836bUL;
   tf->codes[547] = 0x000001a55bd14cb3UL;
   tf->codes[548] = 0x000001f8d9bc8694UL;
   tf->codes[549] = 0x00000033a3515159UL;
   tf->codes[550] = 0x000000580225e6b4UL;
   tf->codes[551] = 0x000000637215072eUL;
   tf->codes[552] = 0x000000c0c6063926UL;
   tf->codes[553] = 0x000001565f66f66cUL;
   tf->codes[554] = 0x0000015db147af0cUL;
   tf->codes[555] = 0x0000018cd05e5392UL;
   tf->codes[556] = 0x000001b2c91c1150UL;
   tf->codes[557] = 0x0000008cc7888badUL;
   tf->codes[558] = 0x00000136821344abUL;
   tf->codes[559] = 0x000001631d04a9baUL;
   tf->codes[560] = 0x000001b91f152312UL;
   tf->codes[561] = 0x000001cd403f1ecaUL;
   tf->codes[562] = 0x000001d1d36b922eUL;
   tf->codes[563] = 0x000001f129f5a89bUL;
   tf->codes[564] = 0x0000002bb8fb6d9bUL;
   tf->codes[565] = 0x0000006bc569bd13UL;
   tf->codes[566] = 0x00000113ab7c47e9UL;
   tf->codes[567] = 0x000001166a308d25UL;
   tf->codes[568] = 0x00000131a2ac3bb8UL;
   tf->codes[569] = 0x00000170c4de741cUL;
   tf->codes[570] = 0x000001cf7829c8b2UL;
   tf->codes[571] = 0x000001e39953c46aUL;
   tf->codes[572] = 0x0000000db01fea02UL;
   tf->codes[573] = 0x00000082ce2b7402UL;
   tf->codes[574] = 0x000000aa60d25a23UL;
   tf->codes[575] = 0x000000b645df8627UL;
   tf->codes[576] = 0x000000b6806e8becUL;
   tf->codes[577] = 0x000000cdd56ad86aUL;
   tf->codes[578] = 0x0000012954e3dc3aUL;
   tf->codes[579] = 0x0000013fbfa411a4UL;
   tf->codes[580] = 0x00000182c555ac1dUL;
   tf->codes[581] = 0x0000019e72ef663aUL;
   tf->codes[582] = 0x000001a4a0050201UL;
   tf->codes[583] = 0x000001af25b80b67UL;
   tf->codes[584] = 0x000001b552cda72eUL;
   tf->codes[585] = 0x000001bb0ac5376bUL;
   tf->codes[586] = 0x000001d43439b211UL;
   tf->codes[587] = 0x0000000e88b0714cUL;
   tf->codes[588] = 0x00000027ecb3f1b7UL;
   tf->codes[589] = 0x0000005cc3c2267aUL;
   tf->codes[590] = 0x000000bbec2b869aUL;
   tf->codes[591] = 0x000000fa993fb374UL;
   tf->codes[592] = 0x00000111ee3bfff2UL;
   tf->codes[593] = 0x0000016c0e5ae124UL;
   tf->codes[594] = 0x0000018e23993ccdUL;
   tf->codes[595] = 0x00000017d7ecce0fUL;
   tf->codes[596] = 0x00000072a7b8c090UL;
   tf->codes[597] = 0x0000007cf2dcc431UL;
   tf->codes[598] = 0x000000a9533f237bUL;
   tf->codes[599] = 0x000000e039548c2bUL;
   tf->codes[600] = 0x00000101d974dc4aUL;
   tf->codes[601] = 0x00000143f4ea5fafUL;
   tf->codes[602] = 0x00000147634bb63aUL;
   tf->codes[603] = 0x0000015f2d660e42UL;
   tf->codes[604] = 0x0000016386037be1UL;
   tf->codes[605] = 0x00000180cd865e61UL;
   tf->codes[606] = 0x000001b2e5e04de8UL;
   tf->codes[607] = 0x000001b4ba587c10UL;
   tf->codes[608] = 0x0000002127292ad2UL;
   tf->codes[609] = 0x00000071abd119b2UL;
   tf->codes[610] = 0x0000007220ef253cUL;
   tf->codes[611] = 0x0000008d93f9d994UL;
   tf->codes[612] = 0x000000c59eda5f1dUL;
   tf->codes[613] = 0x000000d7b0fd26e8UL;
   tf->codes[614] = 0x0000017dfd26895bUL;
   tf->codes[615] = 0x000001c177f62f5eUL;
   tf->codes[616] = 0x000001c854b8dc74UL;
   tf->codes[617] = 0x000001f6899369e6UL;
   tf->codes[618] = 0x000001035006e519UL;
   tf->codes[619] = 0x0000012b925adc89UL;
   tf->codes[620] = 0x0000015b9bad9823UL;
   tf->codes[621] = 0x000001a927123c02UL;
   tf->codes[622] = 0x000000155953e4ffUL;
   tf->codes[623] = 0x0000006ae64652cdUL;
   tf->codes[624] = 0x000000d4cef1c218UL;
   tf->codes[625] = 0x000000e3ad42391dUL;
   tf->codes[626] = 0x0000015c39af19a8UL;
   tf->codes[627] = 0x00000192aaa676ceUL;
   tf->codes[628] = 0x000001bb621879c8UL;
   tf->codes[629] = 0x000000a52911823eUL;
   tf->codes[630] = 0x000000ac05d42f54UL;
   tf->codes[631] = 0x000000dda9101351UL;
   tf->codes[632] = 0x000001842fc87b89UL;
   tf->codes[633] = 0x0000001f4691c347UL;
   tf->codes[634] = 0x000000bce1804a7cUL;
   tf->codes[635] = 0x0000010c06ce16beUL;
   tf->codes[636] = 0x0000014b638f54e7UL;
   tf->codes[637] = 0x000001f6b8033648UL;
   tf->codes[638] = 0x0000000f31ca9f9fUL;
   tf->codes[639] = 0x0000002c042f7695UL;
   tf->codes[640] = 0x000000f4659734b1UL;
   tf->codes[641] = 0x000000ff25d943dcUL;
   tf->codes[642] = 0x000001ade8ae7bc8UL;
   tf->codes[643] = 0x000001c836ee1347UL;
   tf->codes[644] = 0x0000002a1e0bb8a3UL;
   tf->codes[645] = 0x0000003eb453bfe5UL;
   tf->codes[646] = 0x000000fdb4d39174UL;
   tf->codes[647] = 0x000001843554d1f0UL;
   tf->codes[648] = 0x000001c68b595b1aUL;
   tf->codes[649] = 0x00000051d99614bfUL;
   tf->codes[650] = 0x0000018dbf203478UL;
   tf->codes[651] = 0x000001f76d3c9dfeUL;
   tf->codes[652] = 0x0000007f1288fb53UL;
   tf->codes[653] = 0x000000aa139137ffUL;
   tf->codes[654] = 0x000000b5be0f5e3eUL;
   tf->codes[655] = 0x0000015c7f56cc3bUL;
   tf->codes[656] = 0x000001a11ef18f17UL;
   tf->codes[657] = 0x000001cfc8ea2813UL;
   tf->codes[658] = 0x000000eba83d2010UL;
   tf->codes[659] = 0x00000181f14aeea5UL;
   tf->codes[660] = 0x00000000aacd6af7UL;
   tf->codes[661] = 0x0000004bec9bd524UL;
   tf->codes[662] = 0x00000054d865b627UL;
   tf->codes[663] = 0x000001758574274dUL;
   tf->codes[664] = 0x0000006e654cac8dUL;
   tf->codes[665] = 0x000001156123204fUL;
   tf->codes[666] = 0x00000122a58a6ef1UL;
   tf->codes[667] = 0x000001d07e238fc9UL;
   tf->codes[668] = 0x000001f3b82d084bUL;
   tf->codes[669] = 0x0000007f0669c1f0UL;
   tf->codes[670] = 0x0000009a3ee57083UL;
   tf->codes[671] = 0x0000011cdbe74eeaUL;
   tf->codes[672] = 0x000001717e9da5a4UL;
   tf->codes[673] = 0x00000174b26ff66aUL;
   tf->codes[674] = 0x000000158130ce65UL;
   tf->codes[675] = 0x000000acef09b9d3UL;
   tf->codes[676] = 0x00000178f961d43fUL;
   tf->codes[677] = 0x000001a6097144d8UL;
   tf->codes[678] = 0x000001d145088749UL;
   tf->codes[679] = 0x0000001b620bd49dUL;
   tf->codes[680] = 0x0000016d77c723fbUL;
   tf->codes[681] = 0x000000f046824042UL;
   tf->codes[682] = 0x0000013d5cc8d897UL;
   tf->codes[683] = 0x0000006d5d45cc4cUL;
   tf->codes[684] = 0x000001407eef9993UL;
   tf->codes[685] = 0x0000016552e23a78UL;
   tf->codes[686] = 0x000001d18523e375UL;
   tf->codes[687] = 0x0000000d38f4c54eUL;
   tf->codes[688] = 0x000001996897ce22UL;
   tf->codes[689] = 0x0000019bdb117dcfUL;
   tf->codes[690] = 0x000001d19c5bc9a6UL;
   tf->codes[691] = 0x000001d6df354e59UL;
   tf->codes[692] = 0x0000007898323d68UL;
   tf->codes[693] = 0x0000010545c919abUL;
   tf->codes[694] = 0x0000015938d25f16UL;
   tf->codes[695] = 0x00000194b2143b2aUL;
   tf->codes[696] = 0x000000387a185e26UL;
   tf->codes[697] = 0x000000d4408eb733UL;
   tf->codes[698] = 0x0000011ed2b01011UL;
   tf->codes[699] = 0x000001436c13ab31UL;
   tf->codes[700] = 0x0000016840064c16UL;
   tf->codes[701] = 0x000001d81b385163UL;
   tf->codes[702] = 0x00000097cb653441UL;
   tf->codes[703] = 0x000001c791532231UL;
   tf->codes[704] = 0x000001e8f6e46c8bUL;
   tf->codes[705] = 0x0000007654285a1dUL;
   tf->codes[706] = 0x000000fe6e92c2fcUL;
   tf->codes[707] = 0x0000019dddf97859UL;
   tf->codes[708] = 0x0000008d225b0b47UL;
   tf->codes[709] = 0x0000010623e5f75cUL;
   tf->codes[710] = 0x000001bdd285104bUL;
   tf->codes[711] = 0x0000004ffd847706UL;
   tf->codes[712] = 0x000001bc617f5de3UL;
   tf->codes[713] = 0x0000004e1760b914UL;
   tf->codes[714] = 0x00000157aa01e381UL;
   tf->codes[715] = 0x000000a9fa4c38a4UL;
   tf->codes[716] = 0x0000010617c6bdf9UL;
   tf->codes[717] = 0x0000010826cdf1e6UL;
   tf->codes[718] = 0x000001386aafb345UL;
   tf->codes[719] = 0x000000f3329fc54bUL;
   tf->codes[720] = 0x000001caace70031UL;
   tf->codes[721] = 0x000000032ce59144UL;
   tf->codes[722] = 0x0000000f11f2bd48UL;
   tf->codes[723] = 0x0000009557e4f7ffUL;
   tf->codes[724] = 0x00000106cd0025afUL;
   tf->codes[725] = 0x0000007f8b26441aUL;
   tf->codes[726] = 0x000000a499a7eac4UL;
   tf->codes[727] = 0x00000151b0e86a83UL;
   tf->codes[728] = 0x000000354acbd732UL;
   tf->codes[729] = 0x000000a7aa231bf6UL;
   tf->codes[730] = 0x0000003748277b55UL;
   tf->codes[731] = 0x0000005ccbc72d89UL;
   tf->codes[732] = 0x00000139c376f2e7UL;
   tf->codes[733] = 0x00000008b566c88aUL;
   tf->codes[734] = 0x000000ba36f045b2UL;
   tf->codes[735] = 0x0000017be478ccb3UL;
   tf->codes[736] = 0x000001f7930c6e3aUL;
   tf->codes[737] = 0x0000005b4ea241beUL;
   tf->codes[738] = 0x0000002abe85ead0UL;
   tf->codes[739] = 0x0000010aaf78fb2fUL;
   tf->codes[740] = 0x00000079227b15f9UL;
   tf->codes[741] = 0x0000015e1bb8a546UL;
   tf->codes[742] = 0x00000194c73f0831UL;
   tf->codes[743] = 0x000001e1686794fcUL;
   tf->codes[744] = 0x000001e252a3ac10UL;
   tf->codes[745] = 0x000000a86a75307aUL;
   tf->codes[746] = 0x000001701c2fdd47UL;
   tf->codes[747] = 0x000001728ea98cf4UL;
   tf->codes[748] = 0x000001aca891466aUL;
   tf->codes[749] = 0x00000107e4a57c90UL;
   tf->codes[750] = 0x000001409f331368UL;
   tf->codes[751] = 0x0000019666b486fbUL;
   tf->codes[752] = 0x00000042304673e6UL;
   tf->codes[753] = 0x000001873c297a67UL;
   tf->codes[754] = 0x0000007645fc0790UL;
   tf->codes[755] = 0x00000148084bb239UL;
   tf->codes[756] = 0x00000160bca22155UL;
   tf->codes[757] = 0x0000002d01894186UL;
   tf->codes[758] = 0x0000009c2d0e3584UL;
   tf->codes[759] = 0x00000152b6e2319aUL;
   tf->codes[760] = 0x000001f818cf7cf9UL;
   tf->codes[761] = 0x0000000891091c61UL;
   tf->codes[762] = 0x0000002095b27a2eUL;
   tf->codes[763] = 0x0000004912957763UL;
   tf->codes[764] = 0x000000a027c57dcaUL;
   tf->codes[765] = 0x000001d68fe7130bUL;
   tf->codes[766] = 0x00000047f356b0f1UL;
   tf->codes[767] = 0x00000176f7ebfdc8UL;
   tf->codes[768] = 0x000001a8d5b6e78aUL;
   tf->codes[769] = 0x000000fe0d98f7e4UL;
   tf->codes[770] = 0x0000006c0b7d0724UL;
   tf->codes[771] = 0x000001b6f83b13ddUL;
   tf->codes[772] = 0x0000019b38f5c9f6UL;
   tf->codes[773] = 0x000001d886afd432UL;
   tf->codes[774] = 0x000001f93c940d3dUL;
   tf->codes[775] = 0x0000001fe4fedc4aUL;
   tf->codes[776] = 0x0000006ecfbda2c7UL;
   tf->codes[777] = 0x0000019f4558a206UL;
   tf->codes[778] = 0x00000004d566a3b2UL;
   tf->codes[779] = 0x000001071627157fUL;
   tf->codes[780] = 0x000001e81a39b2edUL;
   tf->codes[781] = 0x0000010f0b95a60bUL;
   tf->codes[782] = 0x0000013db58e3f07UL;
   tf->codes[783] = 0x000001c3fb8079beUL;
   tf->codes[784] = 0x000001294829adc0UL;
   tf->codes[785] = 0x000000fe3575e14aUL;
   tf->codes[786] = 0x0000018a6deeb203UL;
   tf->codes[787] = 0x00000095fdeb8093UL;
   tf->codes[788] = 0x0000019d75663db0UL;
   tf->codes[789] = 0x000000053d5ee944UL;
   tf->codes[790] = 0x0000018f236bb866UL;
   tf->codes[791] = 0x000001fb1b1e5b9eUL;
   tf->codes[792] = 0x0000008f7e086c41UL;
   tf->codes[793] = 0x000000a782b1ca0eUL;
   tf->codes[794] = 0x0000009d9b00422dUL;
   tf->codes[795] = 0x000000bfeacda39bUL;
   tf->codes[796] = 0x00000031cc3114f0UL;
   tf->codes[797] = 0x000000f9b87ac782UL;
   tf->codes[798] = 0x000001c80c691ba0UL;
   tf->codes[799] = 0x000000067eee42b5UL;
   tf->codes[800] = 0x000000d2a07e4352UL;
   tf->codes[801] = 0x00000134c22aee73UL;
   tf->codes[802] = 0x0000013bd97ca14eUL;
   tf->codes[803] = 0x0000006fbd78f718UL;
   tf->codes[804] = 0x000000e6004f9df1UL;
   tf->codes[805] = 0x0000018c755c765fUL;
   tf->codes[806] = 0x0000010f441792a6UL;
   tf->codes[807] = 0x0000016359716b10UL;
   tf->codes[808] = 0x000001f2dcf472c0UL;
   tf->codes[809] = 0x0000002c0ca01522UL;
   tf->codes[810] = 0x00000199f8d89498UL;
   tf->codes[811] = 0x0000016843f120d1UL;
   tf->codes[812] = 0x00000075ba11ad53UL;
   tf->codes[813] = 0x000001df24c9492fUL;
   tf->codes[814] = 0x00000019ee5e13f4UL;
   tf->codes[815] = 0x000000566913ed4dUL;
   tf->codes[816] = 0x00000064c09ac8feUL;
   tf->codes[817] = 0x000001be511a46f7UL;
   tf->codes[818] = 0x000000be48447f12UL;
   tf->codes[819] = 0x000001061bb192b4UL;
   tf->codes[820] = 0x000000b0b7a29ae1UL;
   tf->codes[821] = 0x000001473b3f6f3bUL;
   tf->codes[822] = 0x00000016044bcee3UL;
   tf->codes[823] = 0x000001c065add14bUL;
   tf->codes[824] = 0x000001d068c96529UL;
   tf->codes[825] = 0x0000008ad61cc354UL;
   tf->codes[826] = 0x00000045b544bb8bUL;
   tf->codes[827] = 0x0000011c9716cb53UL;
   tf->codes[828] = 0x0000004a136e7f91UL;
   tf->codes[829] = 0x00000104a9a553b7UL;
   tf->codes[830] = 0x00000049f0175ffdUL;
   tf->codes[831] = 0x000000114cc1af56UL;
   tf->codes[832] = 0x00000103b34a0340UL;
   tf->codes[833] = 0x0000015ed4dce1b7UL;
   tf->codes[834] = 0x0000014f86fab58fUL;
   tf->codes[835] = 0x000001e6f4d3a0fdUL;
   tf->codes[836] = 0x000000109681bb0bUL;
   tf->codes[837] = 0x0000014a95e81cd2UL;
   tf->codes[838] = 0x000001320a7523b1UL;
   tf->codes[839] = 0x000000306d4289d0UL;
   tf->codes[840] = 0x000000d429277369UL;
   tf->codes[841] = 0x00000015ba89e9fcUL;
   tf->codes[842] = 0x000001900679f767UL;
   tf->codes[843] = 0x00000185113538deUL;
   tf->codes[844] = 0x000001b6b4711cdbUL;
   tf->codes[845] = 0x000001f6fb6e7218UL;
   tf->codes[846] = 0x000001221c845cdaUL;
   tf->codes[847] = 0x000001dde29efaa7UL;
   tf->codes[848] = 0x0000003633d20418UL;
   tf->codes[849] = 0x000001dcf1d00097UL;
   tf->codes[850] = 0x000000eefb1d007dUL;
   tf->codes[851] = 0x00000077bc5eb2c6UL;
   tf->codes[852] = 0x000000c1529864c6UL;
   tf->codes[853] = 0x00000026f10884beUL;
   tf->codes[854] = 0x000000b18f982d14UL;
   tf->codes[855] = 0x0000005d7937c815UL;
   tf->codes[856] = 0x0000002b89c14e89UL;
   tf->codes[857] = 0x0000000d80e5caf0UL;
   tf->codes[858] = 0x00000163101b1da7UL;
   tf->codes[859] = 0x0000018c3cab2c2bUL;
   tf->codes[860] = 0x000000eee1d80122UL;
   tf->codes[861] = 0x000001ea45d5c5d9UL;
   tf->codes[862] = 0x000000cfdd14d6abUL;
   tf->codes[863] = 0x00000090a9370e7dUL;
   tf->codes[864] = 0x000000c8dcfb0a01UL;
   tf->codes[865] = 0x000001024735b228UL;
   tf->codes[866] = 0x000001c2cff31c50UL;
   tf->codes[867] = 0x000001156058cd9fUL;
   tf->codes[868] = 0x000000dc5990a138UL;
   tf->codes[869] = 0x000001e21fea4fc1UL;
   tf->codes[870] = 0x0000008b5937c3d2UL;
   tf->codes[871] = 0x00000145b4df9233UL;
   tf->codes[872] = 0x0000014fcb00e676UL;
   tf->codes[873] = 0x0000009d4170890dUL;
   tf->codes[874] = 0x0000006a2d2ef2a8UL;
   tf->codes[875] = 0x0000003e59228519UL;
   tf->codes[876] = 0x0000004a1ad89189UL;
   tf->codes[877] = 0x00000062abd7e111UL;
   tf->codes[878] = 0x0000019c3bac8db5UL;
   tf->codes[879] = 0x0000018abb6c0e0cUL;
   tf->codes[880] = 0x000001d959f03efaUL;
   tf->codes[881] = 0x000000a3cfeb876aUL;
   tf->codes[882] = 0x000001e8b8776e57UL;
   tf->codes[883] = 0x000001787f5f43b1UL;
   tf->codes[884] = 0x000001ec5ad4e7abUL;
   tf->codes[885] = 0x000000c2b05105b8UL;
   tf->codes[886] = 0x00000096a1b59264UL;
   tf->codes[887] = 0x0000012999264706UL;
   tf->codes[888] = 0x00000081ca4ba261UL;
   tf->codes[889] = 0x0000009134f20b21UL;
   tf->codes[890] = 0x00000179d71ff6beUL;
   tf->codes[891] = 0x000001243881f926UL;
   tf->codes[892] = 0x000000c8f9245182UL;
   tf->codes[893] = 0x000000cba62d06f4UL;
   tf->codes[894] = 0x000000176b7b9af7UL;
   tf->codes[895] = 0x000001108b6f7c63UL;
   tf->codes[896] = 0x000001880a492646UL;
   tf->codes[897] = 0x000001e3fee035a0UL;
   tf->codes[898] = 0x000001668160bc58UL;
   tf->codes[899] = 0x0000002733019c7bUL;
   tf->codes[900] = 0x000000b9de37bb8eUL;
   tf->codes[901] = 0x0000012ed8ec25faUL;
   tf->codes[902] = 0x0000004f62a3778cUL;
   tf->codes[903] = 0x0000017360487610UL;
   tf->codes[904] = 0x0000014e33fc0639UL;
   tf->codes[905] = 0x000000a0a10a97f4UL;
   tf->codes[906] = 0x000001763aba6b4fUL;
   tf->codes[907] = 0x000001dc7a757e4aUL;
   tf->codes[908] = 0x0000017abc3b4ee9UL;
   tf->codes[909] = 0x000001eaaea53a67UL;
   tf->codes[910] = 0x00000145007d5979UL;
   tf->codes[911] = 0x000001dce3745071UL;
   tf->codes[912] = 0x000001f1b44b5d78UL;
   tf->codes[913] = 0x0000003b73688573UL;
   tf->codes[914] = 0x0000005cd8f9cfcdUL;
   tf->codes[915] = 0x000001785a66a271UL;
   tf->codes[916] = 0x0000008f0e17fbecUL;
   tf->codes[917] = 0x000000f9488a572dUL;
   tf->codes[918] = 0x000000e860bf02a2UL;
   tf->codes[919] = 0x000001fdd86d5913UL;
   tf->codes[920] = 0x0000006a3eab24d9UL;
   tf->codes[921] = 0x000001f45f46f9c0UL;
   tf->codes[922] = 0x0000001f1414a0ddUL;
   tf->codes[923] = 0x000000922e31a3beUL;
   tf->codes[924] = 0x00000106c46d05d5UL;
   tf->codes[925] = 0x00000079a744746fUL;
   tf->codes[926] = 0x00000005ffcaf33eUL;
   tf->codes[927] = 0x000000b44162e63dUL;
   tf->codes[928] = 0x000000eaf2759f8fUL;
   tf->codes[929] = 0x0000006a28e562bbUL;
   tf->codes[930] = 0x000001746a2d11e2UL;
   tf->codes[931] = 0x000000edae163f0cUL;
   tf->codes[932] = 0x00000031890eef51UL;
   tf->codes[933] = 0x000000837829ad9dUL;
   tf->codes[934] = 0x00000082698fea60UL;
   tf->codes[935] = 0x000000dac5dba09fUL;
   tf->codes[936] = 0x000001b83dc21e55UL;
   tf->codes[937] = 0x000000fdad17a096UL;
   tf->codes[938] = 0x000001042bf42853UL;
   tf->codes[939] = 0x000000379ad27293UL;
   tf->codes[940] = 0x0000008ade2ea6afUL;
   tf->codes[941] = 0x0000002492545a51UL;
   tf->codes[942] = 0x00000128bcb7c74dUL;
   tf->codes[943] = 0x0000016f9336a77cUL;
   tf->codes[944] = 0x0000011c2c8353ccUL;
   tf->codes[945] = 0x00000110643a6460UL;
   tf->codes[946] = 0x000001dd0b8d73bcUL;
   tf->codes[947] = 0x0000008650fa2130UL;
   tf->codes[948] = 0x0000018ba7c21a96UL;
   tf->codes[949] = 0x00000028c1735cdeUL;
   tf->codes[950] = 0x00000126fb5d4d02UL;
   tf->codes[951] = 0x0000018a939c00f2UL;
   tf->codes[952] = 0x0000003717f3abfaUL;
   tf->codes[953] = 0x0000004f797ca28bUL;
   tf->codes[954] = 0x00000054875377e0UL;
   tf->codes[955] = 0x000001dda46e3658UL;
   tf->codes[956] = 0x000001f4fef6d93dUL;
   tf->codes[957] = 0x000000ef43b5d782UL;
   tf->codes[958] = 0x00000154eafbbf5fUL;
   tf->codes[959] = 0x00000185512e13bdUL;
   tf->codes[960] = 0x00000085bd765762UL;
   tf->codes[961] = 0x000001638db6a40aUL;
   tf->codes[962] = 0x0000007070ee5bd5UL;
   tf->codes[963] = 0x0000018ba62098eaUL;
   tf->codes[964] = 0x000001a300a93bcfUL;
   tf->codes[965] = 0x0000018db9ad96a9UL;
   tf->codes[966] = 0x000000095c21fecdUL;
   tf->codes[967] = 0x0000003df20e4acfUL;
   tf->codes[968] = 0x0000007b05394f46UL;
   tf->codes[969] = 0x00000072b0de0cccUL;
   tf->codes[970] = 0x000000f8c759ee8cUL;
   tf->codes[971] = 0x000000a12fe616a3UL;
   tf->codes[972] = 0x000001ad5de466b8UL;
   tf->codes[973] = 0x0000001bd329666bUL;
   tf->codes[974] = 0x000000cc98e698e1UL;
   tf->codes[975] = 0x000001593a5e3bc1UL;
   tf->codes[976] = 0x000001b09bc8d7b7UL;
   tf->codes[977] = 0x000000d7d95f6064UL;
   tf->codes[978] = 0x00000146d56dfb6bUL;
   tf->codes[979] = 0x00000151ace7f0c7UL;
   tf->codes[980] = 0x0000005235f47104UL;
   tf->codes[981] = 0x00000160552f2bd9UL;
   tf->codes[982] = 0x000000b85d711139UL;
   tf->codes[983] = 0x000001b9909e4c5eUL;
   tf->codes[984] = 0x000001e9fd6383b8UL;
   tf->codes[985] = 0x00000013aa2a4a94UL;
   tf->codes[986] = 0x000001cd28f19398UL;
   tf->codes[987] = 0x000001328cd2adcbUL;
   tf->codes[988] = 0x00000036f95e901dUL;
   tf->codes[989] = 0x000001ff1761808fUL;
   tf->codes[990] = 0x000001bf5cba1d0dUL;
   tf->codes[991] = 0x00000152fb021b19UL;
   tf->codes[992] = 0x000000f9ecfc3a61UL;
   tf->codes[993] = 0x000000ac948d2cb6UL;
   tf->codes[994] = 0x0000000b7e1788feUL;
   tf->codes[995] = 0x00000121f739dcb4UL;
   tf->codes[996] = 0x000001c85a9b2558UL;
   tf->codes[997] = 0x0000005e91fd6423UL;
   tf->codes[998] = 0x000001986779c35aUL;
   tf->codes[999] = 0x000000146247fa70UL;
   tf->codes[1000] = 0x0000019160cd13b4UL;
   tf->codes[1001] = 0x000000e990ebe27aUL;
   tf->codes[1002] = 0x00000121ff3ee3c3UL;
   tf->codes[1003] = 0x00000103173ff5e4UL;
   tf->codes[1004] = 0x000000999d1faf27UL;
   tf->codes[1005] = 0x000001bed034cdb9UL;
   tf->codes[1006] = 0x00000129c2237599UL;
   tf->codes[1007] = 0x000000b73e6e84acUL;
   tf->codes[1008] = 0x0000014fedd6c98bUL;
   tf->codes[1009] = 0x00000032fddcf527UL;
   tf->codes[1010] = 0x00000112f9e8b254UL;
   tf->codes[1011] = 0x000001c2b79f0489UL;
   tf->codes[1012] = 0x000000c92da5c461UL;
   tf->codes[1013] = 0x000001eb749d5deaUL;
   tf->codes[1014] = 0x00000146d88e7d76UL;
   tf->codes[1015] = 0x0000012775e52da6UL;
   tf->codes[1016] = 0x0000019c87d17e43UL;
   tf->codes[1017] = 0x0000007c8ffc74d3UL;
   tf->codes[1018] = 0x00000015f7e792e6UL;
   tf->codes[1019] = 0x00000028d0ef5231UL;
   tf->codes[1020] = 0x000000748148e4ecUL;
   tf->codes[1021] = 0x0000009fd9a463f5UL;
   tf->codes[1022] = 0x00000159974ab0d1UL;
   tf->codes[1023] = 0x0000007b2e95390bUL;
   tf->codes[1024] = 0x000001ff14f5ac33UL;
   tf->codes[1025] = 0x0000001f655a5054UL;
   tf->codes[1026] = 0x000000acf593d41aUL;
   tf->codes[1027] = 0x000000898c1402a1UL;
   tf->codes[1028] = 0x00000093b3e0e6aeUL;
   tf->codes[1029] = 0x0000018d45df2de5UL;
   tf->codes[1030] = 0x0000011ee6cb87ceUL;
   tf->codes[1031] = 0x0000010936d11081UL;
   tf->codes[1032] = 0x000001cae4599782UL;
   tf->codes[1033] = 0x00000188e5a850b5UL;
   tf->codes[1034] = 0x000000cd074f4022UL;
   tf->codes[1035] = 0x000001dfca5b7190UL;
   tf->codes[1036] = 0x000000b68e62b82bUL;
   tf->codes[1037] = 0x0000016e8dc2307bUL;
   tf->codes[1038] = 0x0000017c57ec8ddcUL;
   tf->codes[1039] = 0x0000002826044499UL;
   tf->codes[1040] = 0x00000106bc22fc2cUL;
   tf->codes[1041] = 0x000000c14f105ed4UL;
   tf->codes[1042] = 0x0000015af4d3f42aUL;
   tf->codes[1043] = 0x00000137e93a480aUL;
   tf->codes[1044] = 0x000001849474f50eUL;
   tf->codes[1045] = 0x0000016dba230a81UL;
   tf->codes[1046] = 0x0000001739183125UL;
   tf->codes[1047] = 0x00000135fefc57c4UL;
   tf->codes[1048] = 0x000000b3f2d634eaUL;
   tf->codes[1049] = 0x00000029710ac92cUL;
   tf->codes[1050] = 0x00000148cf641ae9UL;
   tf->codes[1051] = 0x0000006708f24fcdUL;
   tf->codes[1052] = 0x000000f94815f6faUL;
   tf->codes[1053] = 0x00000121607febdaUL;
   tf->codes[1054] = 0x000000805bb5d7ecUL;
   tf->codes[1055] = 0x000001c39320b045UL;
   tf->codes[1056] = 0x00000062000cdbc8UL;
   tf->codes[1057] = 0x0000014ac177b4a5UL;
   tf->codes[1058] = 0x000000063a51304eUL;
   tf->codes[1059] = 0x0000012443627fa6UL;
   tf->codes[1060] = 0x000001acd66a314cUL;
   tf->codes[1061] = 0x000000f3b5bed960UL;
   tf->codes[1062] = 0x000001517dc78a4dUL;
   tf->codes[1063] = 0x0000016839481f18UL;
   tf->codes[1064] = 0x0000007aa6079abeUL;
   tf->codes[1065] = 0x000001f6e9c6f5e5UL;
   tf->codes[1066] = 0x000000942c5bae28UL;
   tf->codes[1067] = 0x000000458cd0f0a5UL;
   tf->codes[1068] = 0x000001432717dd98UL;
   tf->codes[1069] = 0x000000e39ebb3ef5UL;
   tf->codes[1070] = 0x000001f0115ab508UL;
   tf->codes[1071] = 0x000001662d90cacfUL;
   tf->codes[1072] = 0x0000004d1177e1e0UL;
   tf->codes[1073] = 0x00000092137e93e7UL;
   tf->codes[1074] = 0x000000bf5c0ff11bUL;
   tf->codes[1075] = 0x000001a81e81568dUL;
   tf->codes[1076] = 0x0000011aaf91d931UL;
   tf->codes[1077] = 0x0000018922c9bfbaUL;
   tf->codes[1078] = 0x000001d68ad74405UL;
   tf->codes[1079] = 0x000000a78bce4d95UL;
   tf->codes[1080] = 0x0000010edea8ed9fUL;
   tf->codes[1081] = 0x0000002f6bdf7c6eUL;
   tf->codes[1082] = 0x000001460858efb8UL;
   tf->codes[1083] = 0x000000628b39bfa1UL;
   tf->codes[1084] = 0x000001c3215f60abUL;
   tf->codes[1085] = 0x0000018ea1a46e45UL;
   tf->codes[1086] = 0x00000019bf64425eUL;
   tf->codes[1087] = 0x000000d310f81754UL;
   tf->codes[1088] = 0x000001710d4c011fUL;
   tf->codes[1089] = 0x0000018a69b611f9UL;
   tf->codes[1090] = 0x000000debbe1d511UL;
   tf->codes[1091] = 0x0000002fbfefbb73UL;
   tf->codes[1092] = 0x00000097f0e7392eUL;
   tf->codes[1093] = 0x000000ea0d6b3747UL;
   tf->codes[1094] = 0x000000ee85459226UL;
   tf->codes[1095] = 0x0000019f66c0749fUL;
   tf->codes[1096] = 0x000001db94352bd4UL;
   tf->codes[1097] = 0x00000171dd78c628UL;
   tf->codes[1098] = 0x000000cbba32d9b0UL;
   tf->codes[1099] = 0x000000d5e371e1d0UL;
   tf->codes[1100] = 0x00000137c3fca430UL;
   tf->codes[1101] = 0x0000006ad97a92e9UL;
   tf->codes[1102] = 0x0000012f79b381efUL;
   tf->codes[1103] = 0x00000059b998e941UL;
   tf->codes[1104] = 0x000000b2e255ed67UL;
   tf->codes[1105] = 0x00000013354c8c86UL;
   tf->codes[1106] = 0x000001aa40ef5488UL;
   tf->codes[1107] = 0x000000b95adbcc0dUL;
   tf->codes[1108] = 0x000001d4897b2626UL;
   tf->codes[1109] = 0x000001166b9dfc1aUL;
   tf->codes[1110] = 0x000001784c28be7aUL;
   tf->codes[1111] = 0x0000001015dab617UL;
   tf->codes[1112] = 0x0000005ecb96cd36UL;
   tf->codes[1113] = 0x00000081600554a2UL;
   tf->codes[1114] = 0x000001f48f1758cbUL;
   tf->codes[1115] = 0x000001102cad72f0UL;
   tf->codes[1116] = 0x0000010f94a3df50UL;
   tf->codes[1117] = 0x000000db38400c7eUL;
   tf->codes[1118] = 0x000001d29e72e330UL;
   tf->codes[1119] = 0x00000059698d378fUL;
   tf->codes[1120] = 0x00000167078aad77UL;
   tf->codes[1121] = 0x00000048a99ecc6aUL;
   tf->codes[1122] = 0x0000014c574abe4bUL;
   tf->codes[1123] = 0x0000006fe03d48c3UL;
   tf->codes[1124] = 0x000001baf5decb77UL;
   tf->codes[1125] = 0x0000012fdb9e349bUL;
   tf->codes[1126] = 0x00000103664d422fUL;
   tf->codes[1127] = 0x0000007599779f7aUL;
   tf->codes[1128] = 0x000001ee922cc3aaUL;
   tf->codes[1129] = 0x0000016276782f89UL;
   tf->codes[1130] = 0x00000037c979c3bcUL;
   tf->codes[1131] = 0x000000cdba2dc35fUL;
   tf->codes[1132] = 0x00000052f84ee994UL;
   tf->codes[1133] = 0x000001efe6aa735fUL;
   tf->codes[1134] = 0x0000015a1639ed91UL;
   tf->codes[1135] = 0x0000009e3a598da6UL;
   tf->codes[1136] = 0x00000019a86ca9a9UL;
   tf->codes[1137] = 0x000000970dadb02bUL;
   tf->codes[1138] = 0x000000d2d2239539UL;
   tf->codes[1139] = 0x000001b5a9a7d43aUL;
   tf->codes[1140] = 0x000001a28d711304UL;
   tf->codes[1141] = 0x00000073027dc257UL;
   tf->codes[1142] = 0x0000008697226ebbUL;
   tf->codes[1143] = 0x00000091ab09256dUL;
   tf->codes[1144] = 0x000000be79f6ad45UL;
   tf->codes[1145] = 0x0000001f077c5229UL;
   tf->codes[1146] = 0x0000007854970278UL;
   tf->codes[1147] = 0x000000d39af32496UL;
   tf->codes[1148] = 0x00000195054ca9acUL;
   tf->codes[1149] = 0x000001c1a949a25fUL;
   tf->codes[1150] = 0x00000199873924c4UL;
   tf->codes[1151] = 0x000001847acc8563UL;
   tf->codes[1152] = 0x0000004acd98a710UL;
   tf->codes[1153] = 0x0000000f04020319UL;
   tf->codes[1154] = 0x0000014de092f710UL;
   tf->codes[1155] = 0x000000305e1be573UL;
   tf->codes[1156] = 0x0000015bd8fdc33aUL;
   tf->codes[1157] = 0x0000015d07db004cUL;
   tf->codes[1158] = 0x000000abd7e91181UL;
   tf->codes[1159] = 0x0000008f5bd0f053UL;
   tf->codes[1160] = 0x000000cbe19f767aUL;
   tf->codes[1161] = 0x0000010be8ed0709UL;
   tf->codes[1162] = 0x00000134b8d9b6aeUL;
   tf->codes[1163] = 0x00000190e4ec260eUL;
   tf->codes[1164] = 0x0000003bdcbca890UL;
   tf->codes[1165] = 0x00000112372a27edUL;
   tf->codes[1166] = 0x0000001feb58f771UL;
   tf->codes[1167] = 0x000001c4cfbe06dfUL;
   tf->codes[1168] = 0x000000dee5b17d82UL;
   tf->codes[1169] = 0x000001871a774e8fUL;
   tf->codes[1170] = 0x000000fd5def58a5UL;
   tf->codes[1171] = 0x0000012ec074eb5fUL;
   tf->codes[1172] = 0x0000006b55ac1c67UL;
   tf->codes[1173] = 0x000000c5ffe47891UL;
   tf->codes[1174] = 0x00000073b6ce69a7UL;
   tf->codes[1175] = 0x00000066b0e0f585UL;
   tf->codes[1176] = 0x00000100248623a3UL;
   tf->codes[1177] = 0x00000016392f6f04UL;
   tf->codes[1178] = 0x0000007d50747cb4UL;
   tf->codes[1179] = 0x000001e19f28f0aeUL;
   tf->codes[1180] = 0x0000014f8084fd3bUL;
   tf->codes[1181] = 0x0000018f1b547e66UL;
   tf->codes[1182] = 0x000000d28e258b80UL;
   tf->codes[1183] = 0x00000174de911918UL;
   tf->codes[1184] = 0x000000cf50acb1ffUL;
   tf->codes[1185] = 0x000000c8ee9466daUL;
   tf->codes[1186] = 0x000000d633674cfaUL;
   tf->codes[1187] = 0x000000323c586885UL;
   tf->codes[1188] = 0x000001285f5a641aUL;
   tf->codes[1189] = 0x000001f6d00cf4d0UL;
   tf->codes[1190] = 0x00000106da5ccee7UL;
   tf->codes[1191] = 0x0000008020beacb9UL;
   tf->codes[1192] = 0x000001af2bb77ef3UL;
   tf->codes[1193] = 0x00000007a2f69285UL;
   tf->codes[1194] = 0x000000eab509d74bUL;
   tf->codes[1195] = 0x00000170b3474645UL;
   tf->codes[1196] = 0x0000005a4dae3deaUL;
   tf->codes[1197] = 0x0000002c433626d2UL;
   tf->codes[1198] = 0x0000019d15ffd4eaUL;
   tf->codes[1199] = 0x000001147744815fUL;
   tf->codes[1200] = 0x0000015ddaf434a9UL;
   tf->codes[1201] = 0x0000009025076210UL;
   tf->codes[1202] = 0x000000939368b89bUL;
   tf->codes[1203] = 0x000001859a3a07e7UL;
   tf->codes[1204] = 0x00000159db2909c6UL;
   tf->codes[1205] = 0x0000016d8f3a0103UL;
   tf->codes[1206] = 0x000001905ea325b2UL;
   tf->codes[1207] = 0x0000019381a115aaUL;
   tf->codes[1208] = 0x000001f9ea104107UL;
   tf->codes[1209] = 0x0000001e79cd536cUL;
   tf->codes[1210] = 0x000000a9a3ac60e8UL;
   tf->codes[1211] = 0x00000070d66cadb1UL;
   tf->codes[1212] = 0x000000bc17a022c7UL;
   tf->codes[1213] = 0x00000116da464f50UL;
   tf->codes[1214] = 0x000000d83ca13b7dUL;
   tf->codes[1215] = 0x0000009dcfec097cUL;
   tf->codes[1216] = 0x000001a3240bf4a1UL;
   tf->codes[1217] = 0x0000011426b7932eUL;
   tf->codes[1218] = 0x000001acdf2b6bb1UL;
   tf->codes[1219] = 0x000000c10683210dUL;
   tf->codes[1220] = 0x0000007d7a7382beUL;
   tf->codes[1221] = 0x0000005a6740670dUL;
   tf->codes[1222] = 0x0000015b4c25f379UL;
   tf->codes[1223] = 0x000000f3cb471e8bUL;
   tf->codes[1224] = 0x000001714233b4d7UL;
   tf->codes[1225] = 0x000000b328dc549dUL;
   tf->codes[1226] = 0x00000123e124ab06UL;
   tf->codes[1227] = 0x000000c8d2af806cUL;
   tf->codes[1228] = 0x0000019b6c8925caUL;
   tf->codes[1229] = 0x00000064f327983dUL;
   tf->codes[1230] = 0x000000dc5a2e66d8UL;
   tf->codes[1231] = 0x000001df61d3d025UL;
   tf->codes[1232] = 0x00000070fac19125UL;
   tf->codes[1233] = 0x0000006617ff9162UL;
   tf->codes[1234] = 0x000001da1d9503abUL;
   tf->codes[1235] = 0x000001ee6af25502UL;
   tf->codes[1236] = 0x000000329c6d86ceUL;
   tf->codes[1237] = 0x00000157e5f038e1UL;
   tf->codes[1238] = 0x000000cc6dc97cacUL;
   tf->codes[1239] = 0x00000024778a626bUL;
   tf->codes[1240] = 0x00000138894bb342UL;
   tf->codes[1241] = 0x0000007d6f002e55UL;
   tf->codes[1242] = 0x0000004b9b4764ccUL;
   tf->codes[1243] = 0x000000a0cbc5d154UL;
   tf->codes[1244] = 0x0000012aff498e59UL;
   tf->codes[1245] = 0x00000001653b5202UL;
   tf->codes[1246] = 0x00000149b66cdb7aUL;
   tf->codes[1247] = 0x0000004cffaca152UL;
   tf->codes[1248] = 0x0000002f69b2b280UL;
   tf->codes[1249] = 0x000000aed4bffbb2UL;
   tf->codes[1250] = 0x000001dcf40a92c5UL;
   tf->codes[1251] = 0x000001d5606cfc4dUL;
   tf->codes[1252] = 0x000001d288445a1dUL;
   tf->codes[1253] = 0x000000a9a40a7a93UL;
   tf->codes[1254] = 0x0000016c34dd7a7aUL;
   tf->codes[1255] = 0x000000e30c44e5dcUL;
   tf->codes[1256] = 0x000000e7596aeb7bUL;
   tf->codes[1257] = 0x000000d8ec1e4dacUL;
   tf->codes[1258] = 0x0000019acb07c581UL;
   tf->codes[1259] = 0x000001c59956a5deUL;
   tf->codes[1260] = 0x0000005eb32fe0f7UL;
   tf->codes[1261] = 0x000000d4f39ab374UL;
   tf->codes[1262] = 0x00000041c0946c78UL;
   tf->codes[1263] = 0x000001a8ca1f2d3fUL;
   tf->codes[1264] = 0x0000001aebd3c67fUL;
   tf->codes[1265] = 0x000000ed6dda9095UL;
   tf->codes[1266] = 0x0000000d4eb3edb9UL;
   tf->codes[1267] = 0x0000007819d2a6eeUL;
   tf->codes[1268] = 0x00000045b8f998faUL;
   tf->codes[1269] = 0x0000003c0201308aUL;
   tf->codes[1270] = 0x000001e0ffab3f53UL;
   tf->codes[1271] = 0x000001e6cc32a780UL;
   tf->codes[1272] = 0x000001045e550c09UL;
   tf->codes[1273] = 0x00000083c4a6bfaaUL;
   tf->codes[1274] = 0x00000022b798a1f7UL;
   tf->codes[1275] = 0x000000f42f1fdb24UL;
   tf->codes[1276] = 0x000001bbfc9837f4UL;
   tf->codes[1277] = 0x000000ce03a8c117UL;
   tf->codes[1278] = 0x00000066b8746ceaUL;
   tf->codes[1279] = 0x000000534be8e3d1UL;
   tf->codes[1280] = 0x00000037c5258685UL;
   tf->codes[1281] = 0x000000ed86dea0edUL;
   tf->codes[1282] = 0x0000015ecb7ce911UL;
   tf->codes[1283] = 0x000001245834d414UL;
   tf->codes[1284] = 0x000000c6ec052f56UL;
   tf->codes[1285] = 0x0000009df26ab706UL;
   tf->codes[1286] = 0x000001e5d6eed381UL;
   tf->codes[1287] = 0x000000675416f65fUL;
   tf->codes[1288] = 0x0000007ee172ae2bUL;
   tf->codes[1289] = 0x00000053bff79a11UL;
   tf->codes[1290] = 0x000001bfa2b53c01UL;
   tf->codes[1291] = 0x000001169abbdc78UL;
   tf->codes[1292] = 0x000001127893424aUL;
   tf->codes[1293] = 0x00000128bd3ea4deUL;
   tf->codes[1294] = 0x00000147e8cf6371UL;
   tf->codes[1295] = 0x000000444d0b3b3fUL;
   tf->codes[1296] = 0x0000005d2e9b8c8fUL;
   tf->codes[1297] = 0x0000014ec21faf96UL;
   tf->codes[1298] = 0x0000002a021b8364UL;
   tf->codes[1299] = 0x00000188855bf812UL;
   tf->codes[1300] = 0x00000168438f3dfcUL;
   tf->codes[1301] = 0x000001b3a7ea750dUL;
   tf->codes[1302] = 0x000001ff1a134379UL;
   tf->codes[1303] = 0x0000010c8c199da7UL;
   tf->codes[1304] = 0x000000ec9a724ddbUL;
   tf->codes[1305] = 0x00000011f6a71c4dUL;
   tf->codes[1306] = 0x000000ad5318169eUL;
   tf->codes[1307] = 0x000001b156466b97UL;
   tf->codes[1308] = 0x000001846159b5eaUL;
   tf->codes[1309] = 0x0000006d0af1b37fUL;
   tf->codes[1310] = 0x000000b7d5659b5fUL;
   tf->codes[1311] = 0x00000163fadd70c5UL;
   tf->codes[1312] = 0x000001287c7ad5c8UL;
   tf->codes[1313] = 0x000000f6df36dfb0UL;
   tf->codes[1314] = 0x00000188bbbf3a19UL;
   tf->codes[1315] = 0x0000014162619351UL;
   tf->codes[1316] = 0x00000186af9c4e52UL;
   tf->codes[1317] = 0x0000000958ca4268UL;
   tf->codes[1318] = 0x0000008044bb1794UL;
   tf->codes[1319] = 0x00000071113e2ff4UL;
   tf->codes[1320] = 0x000001fc66211707UL;
   tf->codes[1321] = 0x000001827c740954UL;
   tf->codes[1322] = 0x000001ff95d06cc4UL;
   tf->codes[1323] = 0x000001b54ff685c1UL;
   tf->codes[1324] = 0x0000006d88de7741UL;
   tf->codes[1325] = 0x000001c927e3eca8UL;
   tf->codes[1326] = 0x00000042c6d5652bUL;
   tf->codes[1327] = 0x000001c28d92cb19UL;
   tf->codes[1328] = 0x000001b5779b48d9UL;
   tf->codes[1329] = 0x000001344e24a9ceUL;
   tf->codes[1330] = 0x00000031b6b8c707UL;
   tf->codes[1331] = 0x0000011c4a8eb4e2UL;
   tf->codes[1332] = 0x000001995b6d9d79UL;
   tf->codes[1333] = 0x000001193ac8315fUL;
   tf->codes[1334] = 0x0000017f611bc3b2UL;
   tf->codes[1335] = 0x0000009902c85dc7UL;
   tf->codes[1336] = 0x0000010ca1728539UL;
   tf->codes[1337] = 0x00000009a5bcf7b6UL;
   tf->codes[1338] = 0x000000c875bfe3b9UL;
   tf->codes[1339] = 0x000001c80ee1752eUL;
   tf->codes[1340] = 0x0000000b61b1b07eUL;
   tf->codes[1341] = 0x000001e4f7552473UL;
   tf->codes[1342] = 0x00000141ae812d3aUL;
   tf->codes[1343] = 0x000000992bdf44f2UL;
   tf->codes[1344] = 0x00000177cb8203f3UL;
   tf->codes[1345] = 0x0000000cc54c9a54UL;
   tf->codes[1346] = 0x0000012b5f0a47a0UL;
   tf->codes[1347] = 0x00000117884a0232UL;
   tf->codes[1348] = 0x000000bf7d50d7b6UL;
   tf->codes[1349] = 0x0000004c6c3f6879UL;
   tf->codes[1350] = 0x00000037a66b633fUL;
   tf->codes[1351] = 0x0000010fd1a275eeUL;
   tf->codes[1352] = 0x0000011e5790554cUL;
   tf->codes[1353] = 0x0000015c168a72a3UL;
   tf->codes[1354] = 0x0000013c7537eabaUL;
   tf->codes[1355] = 0x000000ca23dd9aeaUL;
   tf->codes[1356] = 0x0000012dbb51fc2aUL;
   tf->codes[1357] = 0x0000014ae352eed0UL;
   tf->codes[1358] = 0x00000020e166257fUL;
   tf->codes[1359] = 0x0000011ce40d3d1eUL;
   tf->codes[1360] = 0x0000010f4929db1bUL;
   tf->codes[1361] = 0x0000019fd90a2f45UL;
   tf->codes[1362] = 0x0000004ee5bb04b0UL;
   tf->codes[1363] = 0x00000060b378e062UL;
   tf->codes[1364] = 0x000001c86c08e115UL;
   tf->codes[1365] = 0x0000000849e4e2deUL;
   tf->codes[1366] = 0x000001161e70e4cfUL;
   tf->codes[1367] = 0x00000087d52000e4UL;
   tf->codes[1368] = 0x000001c0acc158abUL;
   tf->codes[1369] = 0x00000136f7d2d252UL;
   tf->codes[1370] = 0x00000158c0d6986cUL;
   tf->codes[1371] = 0x000001174bd33519UL;
   tf->codes[1372] = 0x0000005a72318656UL;
   tf->codes[1373] = 0x000000d6e9d0f11fUL;
   tf->codes[1374] = 0x00000188b6005e76UL;
   tf->codes[1375] = 0x000000ecbb0ca621UL;
   tf->codes[1376] = 0x000001131eb3cde3UL;
   tf->codes[1377] = 0x000001de6369b749UL;
   tf->codes[1378] = 0x00000153d9ccb5acUL;
   tf->codes[1379] = 0x0000006022a8be13UL;
   tf->codes[1380] = 0x000000368ec83b60UL;
   tf->codes[1381] = 0x000001345506440dUL;
   tf->codes[1382] = 0x000000ae9863319eUL;
   tf->codes[1383] = 0x000000d963623257UL;
   tf->codes[1384] = 0x00000097fe23da88UL;
   tf->codes[1385] = 0x000001cb23403fe1UL;
   tf->codes[1386] = 0x00000190a0c54bc2UL;
   tf->codes[1387] = 0x000000585f248208UL;
   tf->codes[1388] = 0x000001be4b974e1fUL;
   tf->codes[1389] = 0x000000571a78ba23UL;
   tf->codes[1390] = 0x00000113f244d483UL;
   tf->codes[1391] = 0x000000f8780c4818UL;
   tf->codes[1392] = 0x000000db51a82200UL;
   tf->codes[1393] = 0x0000016c49ec533aUL;
   tf->codes[1394] = 0x000001585317f190UL;
   tf->codes[1395] = 0x000001fc70105ed9UL;
   tf->codes[1396] = 0x000001ae4053905eUL;
   tf->codes[1397] = 0x000001dda20b1e04UL;
   tf->codes[1398] = 0x0000014e06567fdaUL;
   tf->codes[1399] = 0x000001fcf73cc8f6UL;
   tf->codes[1400] = 0x000000ab374cf2e1UL;
   tf->codes[1401] = 0x000000752720033aUL;
   tf->codes[1402] = 0x0000004a6432e5dcUL;
   tf->codes[1403] = 0x000001c0f08cdd28UL;
   tf->codes[1404] = 0x0000005eb87043f7UL;
   tf->codes[1405] = 0x000001ec38067d90UL;
   tf->codes[1406] = 0x000001fef4cf5059UL;
   tf->codes[1407] = 0x000001700dac4882UL;
   tf->codes[1408] = 0x0000000cdd792496UL;
   tf->codes[1409] = 0x0000001994ef8c66UL;
   tf->codes[1410] = 0x000001669a978facUL;
   tf->codes[1411] = 0x00000093695c2811UL;
   tf->codes[1412] = 0x0000008c84651653UL;
   tf->codes[1413] = 0x000001305144f59eUL;
   tf->codes[1414] = 0x000001e5597b1863UL;
   tf->codes[1415] = 0x00000154d2615543UL;
   tf->codes[1416] = 0x000001e5a8c08afcUL;
   tf->codes[1417] = 0x000000841f1b18ecUL;
   tf->codes[1418] = 0x000001476b7e29a0UL;
   tf->codes[1419] = 0x0000010731c052f3UL;
   tf->codes[1420] = 0x0000008744107d0dUL;
   tf->codes[1421] = 0x000000c61901934dUL;
   tf->codes[1422] = 0x000000ec347b7b88UL;
   tf->codes[1423] = 0x000000e7476d701eUL;
   tf->codes[1424] = 0x00000006e867aafbUL;
   tf->codes[1425] = 0x000000e1d03044bbUL;
   tf->codes[1426] = 0x000000658319e530UL;
   tf->codes[1427] = 0x0000014336373a0eUL;
   tf->codes[1428] = 0x0000016cb93a933eUL;
   tf->codes[1429] = 0x000001b8b6d95bb4UL;
   tf->codes[1430] = 0x00000004a5413171UL;
   tf->codes[1431] = 0x00000010ff862197UL;
   tf->codes[1432] = 0x000001115f3202f1UL;
   tf->codes[1433] = 0x000001d6f7ed1430UL;
   tf->codes[1434] = 0x000001b373d7ff0fUL;
   tf->codes[1435] = 0x00000025cfa73de1UL;
   tf->codes[1436] = 0x000000cc6b38943aUL;
   tf->codes[1437] = 0x000000759f924c6cUL;
   tf->codes[1438] = 0x0000014862200a2cUL;
   tf->codes[1439] = 0x000001b74c7a4cb4UL;
   tf->codes[1440] = 0x0000012d44b5851bUL;
   tf->codes[1441] = 0x000000ca97f5aeb9UL;
   tf->codes[1442] = 0x0000004d36701f59UL;
   tf->codes[1443] = 0x000001de88f2493cUL;
   tf->codes[1444] = 0x000000420abaa0f6UL;
   tf->codes[1445] = 0x000000d892babdd5UL;
   tf->codes[1446] = 0x00000062fe9b8b99UL;
   tf->codes[1447] = 0x0000006a1c54d76eUL;
   tf->codes[1448] = 0x000000b87dde2e3bUL;
   tf->codes[1449] = 0x000000c77657afe3UL;
   tf->codes[1450] = 0x0000006b72f09030UL;
   tf->codes[1451] = 0x00000184b68bbaeaUL;
   tf->codes[1452] = 0x00000022a6cd479eUL;
   tf->codes[1453] = 0x000000166f0c5ba7UL;
   tf->codes[1454] = 0x000001809f47bad3UL;
   tf->codes[1455] = 0x0000018ed0cf68afUL;
   tf->codes[1456] = 0x000001ae1368afdaUL;
   tf->codes[1457] = 0x000000ca2d646634UL;
   tf->codes[1458] = 0x000001320f49e286UL;
   tf->codes[1459] = 0x000000d56c0385bdUL;
   tf->codes[1460] = 0x0000006b6f80ffc8UL;
   tf->codes[1461] = 0x000000b0615b2264UL;
   tf->codes[1462] = 0x00000125287f0185UL;
   tf->codes[1463] = 0x000000110b2bee8fUL;
   tf->codes[1464] = 0x000001e9004a8e70UL;
   tf->codes[1465] = 0x0000015dde15e068UL;
   tf->codes[1466] = 0x0000010438693ad9UL;
   tf->codes[1467] = 0x0000015baa26fb1eUL;
   tf->codes[1468] = 0x00000183bfc66070UL;
   tf->codes[1469] = 0x000000804a41b38fUL;
   tf->codes[1470] = 0x0000005dbd4a1a67UL;
   tf->codes[1471] = 0x000000b10be90245UL;
   tf->codes[1472] = 0x00000050b250494fUL;
   tf->codes[1473] = 0x0000001dac323cc2UL;
   tf->codes[1474] = 0x00000175a189df75UL;
   tf->codes[1475] = 0x0000012ddf98fe04UL;
   tf->codes[1476] = 0x0000010862cc7c48UL;
   tf->codes[1477] = 0x0000001dc90b7cd4UL;
   tf->codes[1478] = 0x0000011dbf851ad7UL;
   tf->codes[1479] = 0x000001a87ae5dc11UL;
   tf->codes[1480] = 0x0000017f7fa9e215UL;
   tf->codes[1481] = 0x0000013038ead8feUL;
   tf->codes[1482] = 0x000001181bd7be69UL;
   tf->codes[1483] = 0x00000119086a04d8UL;
   tf->codes[1484] = 0x000001589d569b98UL;
   tf->codes[1485] = 0x000001e9b00424f1UL;
   tf->codes[1486] = 0x00000080ff1896e9UL;
   tf->codes[1487] = 0x00000090d4c22245UL;
   tf->codes[1488] = 0x0000001eaf9672f6UL;
   tf->codes[1489] = 0x0000004afcdf31faUL;
   tf->codes[1490] = 0x00000145d412a4c3UL;
   tf->codes[1491] = 0x000000ab19785bb1UL;
   tf->codes[1492] = 0x000001d96d082bbeUL;
   tf->codes[1493] = 0x0000014286dce6ecUL;
   tf->codes[1494] = 0x00000160fd92f8fbUL;
   tf->codes[1495] = 0x0000012fdcb8b2afUL;
   tf->codes[1496] = 0x000001a01a3425daUL;
   tf->codes[1497] = 0x00000133162849bfUL;
   tf->codes[1498] = 0x0000017f312a577bUL;
   tf->codes[1499] = 0x000000a28b92bb72UL;
   tf->codes[1500] = 0x0000018e5fbd6372UL;
   tf->codes[1501] = 0x000001df71ceaceeUL;
   tf->codes[1502] = 0x0000012c5bdf9515UL;
   tf->codes[1503] = 0x000000e6c1acce21UL;
   tf->codes[1504] = 0x0000009d25699cd2UL;
   tf->codes[1505] = 0x0000015270b91c81UL;
   tf->codes[1506] = 0x00000126e0bb0707UL;
   tf->codes[1507] = 0x000000fdfae613f7UL;
   tf->codes[1508] = 0x0000016e8679d842UL;
   tf->codes[1509] = 0x000001d2c9b489adUL;
   tf->codes[1510] = 0x000001abd33e45ccUL;
   tf->codes[1511] = 0x00000192f2c15d5dUL;
   tf->codes[1512] = 0x000001713ce8276cUL;
   tf->codes[1513] = 0x0000010e56516b04UL;
   tf->codes[1514] = 0x0000013739a4e4b7UL;
   tf->codes[1515] = 0x00000076c27d6558UL;
   tf->codes[1516] = 0x000001eee4c41ee2UL;
   tf->codes[1517] = 0x00000064d3c6c09bUL;
   tf->codes[1518] = 0x0000015d2944dbe0UL;
   tf->codes[1519] = 0x000000c61d6ba698UL;
   tf->codes[1520] = 0x00000180dffc6541UL;
   tf->codes[1521] = 0x0000015061fb4932UL;
   tf->codes[1522] = 0x000000df6e885666UL;
   tf->codes[1523] = 0x00000127eec246c8UL;
   tf->codes[1524] = 0x0000019b51fd70c4UL;
   tf->codes[1525] = 0x000001187e4df717UL;
   tf->codes[1526] = 0x0000006a8b0a8f1dUL;
   tf->codes[1527] = 0x0000011942390170UL;
   tf->codes[1528] = 0x000000a421965912UL;
   tf->codes[1529] = 0x000001f726d51351UL;
   tf->codes[1530] = 0x000000317c4daa03UL;
   tf->codes[1531] = 0x000001acdc1ece78UL;
   tf->codes[1532] = 0x0000003fd243f3ebUL;
   tf->codes[1533] = 0x000000fdc16c4efbUL;
   tf->codes[1534] = 0x0000002f12371b10UL;
   tf->codes[1535] = 0x00000039b6e20f1cUL;
   tf->codes[1536] = 0x00000169ab733a9eUL;
   tf->codes[1537] = 0x000000fb398f0a72UL;
   tf->codes[1538] = 0x0000002761cbddc4UL;
   tf->codes[1539] = 0x000000d6a06bbcceUL;
   tf->codes[1540] = 0x00000056f4927d58UL;
   tf->codes[1541] = 0x000000c5a4372537UL;
   tf->codes[1542] = 0x000001b90381e8d6UL;
   tf->codes[1543] = 0x00000091b9fae2d8UL;
   tf->codes[1544] = 0x0000016ee910633bUL;
   tf->codes[1545] = 0x000000a7bc7dd016UL;
   tf->codes[1546] = 0x000000e725ab716aUL;
   tf->codes[1547] = 0x0000018227cf3c37UL;
   tf->codes[1548] = 0x000000dba6f91ce3UL;
   tf->codes[1549] = 0x000001fedfb8bf3eUL;
   tf->codes[1550] = 0x0000015de02922d1UL;
   tf->codes[1551] = 0x000000d11529aaa3UL;
   tf->codes[1552] = 0x000001a162d5f7f1UL;
   tf->codes[1553] = 0x0000004b0b4d9d3eUL;
   tf->codes[1554] = 0x0000006f50397572UL;
   tf->codes[1555] = 0x000001348ebcfc2eUL;
   tf->codes[1556] = 0x0000009df43157d4UL;
   tf->codes[1557] = 0x000001999827f76aUL;
   tf->codes[1558] = 0x000001467f2570f3UL;
   tf->codes[1559] = 0x000001eba5dff8c1UL;
   tf->codes[1560] = 0x0000010ee96b1e22UL;
   tf->codes[1561] = 0x00000107be5eddbeUL;
   tf->codes[1562] = 0x000001411df497c3UL;
   tf->codes[1563] = 0x000000d226a166c0UL;
   tf->codes[1564] = 0x000000f3d092e815UL;
   tf->codes[1565] = 0x00000058e2ed63ceUL;
   tf->codes[1566] = 0x0000013bd7ba8df6UL;
   tf->codes[1567] = 0x000001298e4f35ceUL;
   tf->codes[1568] = 0x0000011be9845c0dUL;
   tf->codes[1569] = 0x000000b53afc8ffaUL;
   tf->codes[1570] = 0x00000067af688e82UL;
   tf->codes[1571] = 0x0000010a41cd33d7UL;
   tf->codes[1572] = 0x000000f6838baeabUL;
   tf->codes[1573] = 0x0000000777ac0858UL;
   tf->codes[1574] = 0x000001dfcd3f233bUL;
   tf->codes[1575] = 0x00000034944e7100UL;
   tf->codes[1576] = 0x0000012487a3b270UL;
   tf->codes[1577] = 0x000000ec12b9190dUL;
   tf->codes[1578] = 0x000001bbc01a91c7UL;
   tf->codes[1579] = 0x000000656b8c243bUL;
   tf->codes[1580] = 0x0000004dbb62b088UL;
   tf->codes[1581] = 0x0000013ab915c3faUL;
   tf->codes[1582] = 0x000001f8a3d62167UL;
   tf->codes[1583] = 0x000000009a46896aUL;
   tf->codes[1584] = 0x000000fb5f4d2feaUL;
   tf->codes[1585] = 0x000001116bc7e342UL;
   tf->codes[1586] = 0x00000183e9fd5a14UL;
   tf->codes[1587] = 0x000001d0c98a1c5eUL;
   tf->codes[1588] = 0x0000015d459676d3UL;
   tf->codes[1589] = 0x000000f760f6f9a3UL;
   tf->codes[1590] = 0x0000012c66e40456UL;
   tf->codes[1591] = 0x00000173ddc771b1UL;
   tf->codes[1592] = 0x00000007db0a1578UL;
   tf->codes[1593] = 0x000001f3ce6f5029UL;
   tf->codes[1594] = 0x00000077d9f5679bUL;
   tf->codes[1595] = 0x0000001ac5f85b64UL;
   tf->codes[1596] = 0x00000004c672cd5dUL;
   tf->codes[1597] = 0x0000015680655ee8UL;
   tf->codes[1598] = 0x00000186876a1255UL;
   tf->codes[1599] = 0x000000774469842eUL;
   tf->codes[1600] = 0x0000013271af9a24UL;
   tf->codes[1601] = 0x0000006e89c9fb2cUL;
   tf->codes[1602] = 0x0000006c1d9e2be1UL;
   tf->codes[1603] = 0x000000f0741acf5aUL;
   tf->codes[1604] = 0x0000002aa8d88feeUL;
   tf->codes[1605] = 0x000000038b16ed82UL;
   tf->codes[1606] = 0x000000e9cba39dd7UL;
   tf->codes[1607] = 0x000000912e6005cbUL;
   tf->codes[1608] = 0x000001251d6608a9UL;
   tf->codes[1609] = 0x000000e0b6ff59fbUL;
   tf->codes[1610] = 0x000000e08ea95b44UL;
   tf->codes[1611] = 0x0000014573ade1a2UL;
   tf->codes[1612] = 0x0000015b7c8a4880UL;
   tf->codes[1613] = 0x00000030578d9c9aUL;
   tf->codes[1614] = 0x000001fd9016e391UL;
   tf->codes[1615] = 0x000000a0f6219300UL;
   tf->codes[1616] = 0x000000d6556f9ac1UL;
   tf->codes[1617] = 0x0000001c1012de94UL;
   tf->codes[1618] = 0x000000b971893af5UL;
   tf->codes[1619] = 0x0000011ca283b57bUL;
   tf->codes[1620] = 0x0000010c64cb9e05UL;
   tf->codes[1621] = 0x000001aa714b75b4UL;
   tf->codes[1622] = 0x0000014aca141713UL;
   tf->codes[1623] = 0x00000125c7fabffdUL;
   tf->codes[1624] = 0x000000a981632be8UL;
   tf->codes[1625] = 0x00000113c56a7e7aUL;
   tf->codes[1626] = 0x000000d2ba1957efUL;
   tf->codes[1627] = 0x00000160d918b563UL;
   tf->codes[1628] = 0x000000fb8ce18705UL;
   tf->codes[1629] = 0x0000007127d3be2cUL;
   tf->codes[1630] = 0x0000012a325812acUL;
   tf->codes[1631] = 0x000000a0ae4e4033UL;
   tf->codes[1632] = 0x0000007a50e36769UL;
   tf->codes[1633] = 0x0000000c0f50d2c7UL;
   tf->codes[1634] = 0x0000000890ba241cUL;
   tf->codes[1635] = 0x0000010b3a091b74UL;
   tf->codes[1636] = 0x0000001dfa797966UL;
   tf->codes[1637] = 0x000001952caa9badUL;
   tf->codes[1638] = 0x0000009d825284d7UL;
   tf->codes[1639] = 0x0000004ba9437737UL;
   tf->codes[1640] = 0x000001f33933c933UL;
   tf->codes[1641] = 0x0000006d53c810e2UL;
   tf->codes[1642] = 0x000000e4a1f020fbUL;
   tf->codes[1643] = 0x00000152a41fc39dUL;
   tf->codes[1644] = 0x000001e6f1b3bd37UL;
   tf->codes[1645] = 0x00000091ea70722fUL;
   tf->codes[1646] = 0x00000028924a2a6dUL;
   tf->codes[1647] = 0x000001ec4fbfa9abUL;
   tf->codes[1648] = 0x000000a989d49062UL;
   tf->codes[1649] = 0x00000079387b2a25UL;
   tf->codes[1650] = 0x00000054b2e53b73UL;
   tf->codes[1651] = 0x0000014dc3868cf9UL;
   tf->codes[1652] = 0x0000014b9d290525UL;
   tf->codes[1653] = 0x000000b777ff6c35UL;
   tf->codes[1654] = 0x0000009774746651UL;
   tf->codes[1655] = 0x0000014c55cb6390UL;
   tf->codes[1656] = 0x000000571a4688bfUL;
   tf->codes[1657] = 0x000000312aa0996aUL;
   tf->codes[1658] = 0x000001532efa1a5cUL;
   tf->codes[1659] = 0x000000dfec4adedfUL;
   tf->codes[1660] = 0x0000009681870c1aUL;
   tf->codes[1661] = 0x000000c30efd0321UL;
   tf->codes[1662] = 0x0000001e872eec40UL;
   tf->codes[1663] = 0x00000010aee5189eUL;
   tf->codes[1664] = 0x000001b54c11e3b0UL;
   tf->codes[1665] = 0x000001054076b18bUL;
   tf->codes[1666] = 0x0000012009bab10fUL;
   tf->codes[1667] = 0x000001f5de648026UL;
   tf->codes[1668] = 0x000001fec2d089f6UL;
   tf->codes[1669] = 0x000001ae79a3d351UL;
   tf->codes[1670] = 0x0000016055846033UL;
   tf->codes[1671] = 0x0000014a18cf43cdUL;
   tf->codes[1672] = 0x0000002b4868b059UL;
   tf->codes[1673] = 0x000000f39d118addUL;
   tf->codes[1674] = 0x00000184fa8a563bUL;
   tf->codes[1675] = 0x0000005dcd75adefUL;
   tf->codes[1676] = 0x000001f867bca4caUL;
   tf->codes[1677] = 0x000000722f8230e0UL;
   tf->codes[1678] = 0x000001c7739a0b92UL;
   tf->codes[1679] = 0x0000014d27afcac6UL;
   tf->codes[1680] = 0x000001ff4483a337UL;
   tf->codes[1681] = 0x000001ee3e7ec65eUL;
   tf->codes[1682] = 0x0000015bdf9cf572UL;
   tf->codes[1683] = 0x000000ac55b183d8UL;
   tf->codes[1684] = 0x000001bd7ba5eb7eUL;
   tf->codes[1685] = 0x0000013d6f28d36dUL;
   tf->codes[1686] = 0x00000094483a59c7UL;
   tf->codes[1687] = 0x000001971a6811fcUL;
   tf->codes[1688] = 0x000001d01f6dc8e5UL;
   tf->codes[1689] = 0x000001d7041a8164UL;
   tf->codes[1690] = 0x000000cd4bb66307UL;
   tf->codes[1691] = 0x0000003cc8bae5d2UL;
   tf->codes[1692] = 0x00000040a28f0a0eUL;
   tf->codes[1693] = 0x00000028ff942508UL;
   tf->codes[1694] = 0x0000010f7db14df0UL;
   tf->codes[1695] = 0x000000970a05aa25UL;
   tf->codes[1696] = 0x0000004a714b291eUL;
   tf->codes[1697] = 0x000000c701e4e2e9UL;
   tf->codes[1698] = 0x0000000c3311c809UL;
   tf->codes[1699] = 0x00000085c5af52ebUL;
   tf->codes[1700] = 0x000000d2a0ddcc3bUL;
   tf->codes[1701] = 0x000001b86f410788UL;
   tf->codes[1702] = 0x000001ede3484ca6UL;
   tf->codes[1703] = 0x0000004074091b8aUL;
   tf->codes[1704] = 0x000000cdace8c340UL;
   tf->codes[1705] = 0x000000964a817ec7UL;
   tf->codes[1706] = 0x00000053c4b1e08aUL;
   tf->codes[1707] = 0x00000071f3cfaffdUL;
   tf->codes[1708] = 0x000001c847b0f581UL;
   tf->codes[1709] = 0x000001f95bfc003bUL;
   tf->codes[1710] = 0x0000001c86666096UL;
   tf->codes[1711] = 0x000000448e6a5cafUL;
   tf->codes[1712] = 0x0000017d9562fe30UL;
   tf->codes[1713] = 0x0000014b11e2c939UL;
   tf->codes[1714] = 0x00000146ba94fe60UL;
   tf->codes[1715] = 0x0000013917b4bc7cUL;
   tf->codes[1716] = 0x000001bfab5951e7UL;
   tf->codes[1717] = 0x0000019279b20f95UL;
   tf->codes[1718] = 0x000000216bd36a1bUL;
   tf->codes[1719] = 0x0000017888e39bb5UL;
   tf->codes[1720] = 0x000000ae80792a03UL;
   tf->codes[1721] = 0x0000008298ab4acbUL;
   tf->codes[1722] = 0x0000010dfed49850UL;
   tf->codes[1723] = 0x000000cb166c8a85UL;
   tf->codes[1724] = 0x00000101beba4048UL;
   tf->codes[1725] = 0x000000855cff4fc0UL;
   tf->codes[1726] = 0x000001849168c1c5UL;
   tf->codes[1727] = 0x0000010a38f62987UL;
   tf->codes[1728] = 0x00000049cf1f189bUL;
   tf->codes[1729] = 0x0000016a2876af49UL;
   tf->codes[1730] = 0x00000087fa6e2a56UL;
   tf->codes[1731] = 0x00000062c7b015c2UL;
   tf->codes[1732] = 0x000000d5c29bc4a1UL;
   tf->codes[1733] = 0x00000062091756edUL;
   tf->codes[1734] = 0x000000518e01968dUL;
   tf->codes[1735] = 0x0000003d09d83c3aUL;
   tf->codes[1736] = 0x00000054f111c2e2UL;
   tf->codes[1737] = 0x000001555bb741cdUL;
   tf->codes[1738] = 0x0000009dbccd3073UL;
   tf->codes[1739] = 0x000001ec92ece825UL;
   tf->codes[1740] = 0x0000000112998bc8UL;
   tf->codes[1741] = 0x000000e02379d7c8UL;
   tf->codes[1742] = 0x00000149f696fd0fUL;
   tf->codes[1743] = 0x000001b7137d7768UL;
   tf->codes[1744] = 0x000001a3b030519cUL;
   tf->codes[1745] = 0x000001e1d806bfcdUL;
   tf->codes[1746] = 0x0000000bc65b06e8UL;
   tf->codes[1747] = 0x000001983059408aUL;
   tf->codes[1748] = 0x000001e9fe1feca9UL;
   tf->codes[1749] = 0x000000132c0a95aaUL;
   tf->codes[1750] = 0x000000a6dc5119e7UL;
   tf->codes[1751] = 0x000000fd58b2db10UL;
   tf->codes[1752] = 0x00000137e20c98e5UL;
   tf->codes[1753] = 0x000000968688531cUL;
   tf->codes[1754] = 0x000000a81dc892a8UL;
   tf->codes[1755] = 0x000000f861cd9997UL;
   tf->codes[1756] = 0x000001b0d2b12efbUL;
   tf->codes[1757] = 0x00000000bea34e27UL;
   tf->codes[1758] = 0x000000db665c24f9UL;
   tf->codes[1759] = 0x000000e90e722940UL;
   tf->codes[1760] = 0x000000106d989a38UL;
   tf->codes[1761] = 0x0000002e84aac68eUL;
   tf->codes[1762] = 0x000000f3e4a70319UL;
   tf->codes[1763] = 0x000001d9d002369bUL;
   tf->codes[1764] = 0x0000001c31c31105UL;
   tf->codes[1765] = 0x00000091514c5856UL;
   tf->codes[1766] = 0x000001c49b1c053bUL;
   tf->codes[1767] = 0x000001ebef82c4a5UL;
   tf->codes[1768] = 0x000001ec86920675UL;
   tf->codes[1769] = 0x000001253eb1b8cfUL;
   tf->codes[1770] = 0x0000019c293afdd8UL;
   tf->codes[1771] = 0x000001e6a30fc496UL;
   tf->codes[1772] = 0x0000001cf75469e1UL;
   tf->codes[1773] = 0x000001216b1b956cUL;
   tf->codes[1774] = 0x0000006dc53cf47cUL;
   tf->codes[1775] = 0x0000016b338cb908UL;
   tf->codes[1776] = 0x0000007bc89831bbUL;
   tf->codes[1777] = 0x0000012bfceaee52UL;
   tf->codes[1778] = 0x000000602827afa6UL;
   tf->codes[1779] = 0x00000129bef4e086UL;
   tf->codes[1780] = 0x0000019ade8a837bUL;
   tf->codes[1781] = 0x0000008f365a39dcUL;
   tf->codes[1782] = 0x0000013331a3ed5dUL;
   tf->codes[1783] = 0x00000167bf567e12UL;
   tf->codes[1784] = 0x000001817eb5403dUL;
   tf->codes[1785] = 0x00000116a0ac445bUL;
   tf->codes[1786] = 0x00000151f5a1ae96UL;
   tf->codes[1787] = 0x000000355fbafed3UL;
   tf->codes[1788] = 0x000001721a856f18UL;
   tf->codes[1789] = 0x000000398c5fb690UL;
   tf->codes[1790] = 0x0000018fde252209UL;
   tf->codes[1791] = 0x0000009bc1effd8dUL;
   tf->codes[1792] = 0x0000015e058368cbUL;
   tf->codes[1793] = 0x000001ef19f8672dUL;
   tf->codes[1794] = 0x000000efeb28bcb5UL;
   tf->codes[1795] = 0x0000008597fe8243UL;
   tf->codes[1796] = 0x000001e3558b7241UL;
   tf->codes[1797] = 0x000001f06d2b5a4dUL;
   tf->codes[1798] = 0x0000006753166ca7UL;
   tf->codes[1799] = 0x0000019d05252f87UL;
   tf->codes[1800] = 0x0000007ece8719c7UL;
   tf->codes[1801] = 0x000000abada7be10UL;
   tf->codes[1802] = 0x0000003b7bae0915UL;
   tf->codes[1803] = 0x000000b920dbfa1eUL;
   tf->codes[1804] = 0x00000077c3d750efUL;
   tf->codes[1805] = 0x000000c8a77b91e5UL;
   tf->codes[1806] = 0x0000013c12511766UL;
   tf->codes[1807] = 0x000001bd655e970dUL;
   tf->codes[1808] = 0x000000d5f0a10e67UL;
   tf->codes[1809] = 0x0000005c151f0386UL;
   tf->codes[1810] = 0x000000f36c123216UL;
   tf->codes[1811] = 0x000000733590bd56UL;
   tf->codes[1812] = 0x000000134800baf0UL;
   tf->codes[1813] = 0x00000166cf1de51fUL;
   tf->codes[1814] = 0x00000117dd06e881UL;
   tf->codes[1815] = 0x00000129a0921efbUL;
   tf->codes[1816] = 0x000000a6ff0ca5c4UL;
   tf->codes[1817] = 0x0000008ea200b050UL;
   tf->codes[1818] = 0x00000034f9387b94UL;
   tf->codes[1819] = 0x000001d3723ad2deUL;
   tf->codes[1820] = 0x0000018e5af2b62eUL;
   tf->codes[1821] = 0x0000010bd979c6dfUL;
   tf->codes[1822] = 0x0000014d339607a4UL;
   tf->codes[1823] = 0x000001b88544514aUL;
   tf->codes[1824] = 0x0000003a4450d2d8UL;
   tf->codes[1825] = 0x000001a61117a18fUL;
   tf->codes[1826] = 0x000001e21725e539UL;
   tf->codes[1827] = 0x00000123cf7364fdUL;
   tf->codes[1828] = 0x00000179908b5b01UL;
   tf->codes[1829] = 0x00000069ec91a349UL;
   tf->codes[1830] = 0x000000945679ec02UL;
   tf->codes[1831] = 0x000000e6a4ca1b53UL;
   tf->codes[1832] = 0x0000007e2c612da0UL;
   tf->codes[1833] = 0x000001f568f32763UL;
   tf->codes[1834] = 0x000001b564f98a0fUL;
   tf->codes[1835] = 0x00000020e11f4d89UL;
   tf->codes[1836] = 0x00000090c3ea1433UL;
   tf->codes[1837] = 0x0000014c7e71acd3UL;
   tf->codes[1838] = 0x000000dc4e4b061fUL;
   tf->codes[1839] = 0x000001c813886671UL;
   tf->codes[1840] = 0x000000998741f58bUL;
   tf->codes[1841] = 0x000000fe30e80a8fUL;
   tf->codes[1842] = 0x000000607de6a503UL;
   tf->codes[1843] = 0x000001484657259dUL;
   tf->codes[1844] = 0x000000e53c335255UL;
   tf->codes[1845] = 0x00000174d9bd2dc8UL;
   tf->codes[1846] = 0x0000007d39cfa317UL;
   tf->codes[1847] = 0x000001c0992c6850UL;
   tf->codes[1848] = 0x00000112351c0a60UL;
   tf->codes[1849] = 0x000001e0d5e6cd44UL;
   tf->codes[1850] = 0x000000667998400cUL;
   tf->codes[1851] = 0x00000042dfaef259UL;
   tf->codes[1852] = 0x0000019abbd3ed08UL;
   tf->codes[1853] = 0x0000014ad9c7ab72UL;
   tf->codes[1854] = 0x00000056389ff426UL;
   tf->codes[1855] = 0x0000019427c1236cUL;
   tf->codes[1856] = 0x000001a4063a9d61UL;
   tf->codes[1857] = 0x000000af87f97b4dUL;
   tf->codes[1858] = 0x000001666612b513UL;
   tf->codes[1859] = 0x000001f23ac539e4UL;
   tf->codes[1860] = 0x000001e873a1cf84UL;
   tf->codes[1861] = 0x000001701f1aeddcUL;
   tf->codes[1862] = 0x0000018b22a98565UL;
   tf->codes[1863] = 0x000001ddc760ab43UL;
   tf->codes[1864] = 0x00000022da169d55UL;
   tf->codes[1865] = 0x000000f1416893deUL;
   tf->codes[1866] = 0x000000ee14c0e6dbUL;
   tf->codes[1867] = 0x0000019252aae1f5UL;
   tf->codes[1868] = 0x0000000b4fb6141dUL;
   tf->codes[1869] = 0x000000c2b99da72cUL;
   tf->codes[1870] = 0x0000019ec587f23aUL;
   tf->codes[1871] = 0x000001f44dc5cd77UL;
   tf->codes[1872] = 0x00000101573c5f0cUL;
   tf->codes[1873] = 0x000000c8590ac48fUL;
   tf->codes[1874] = 0x000001f1d4b1d98dUL;
   tf->codes[1875] = 0x0000012ae39c0c1eUL;
   tf->codes[1876] = 0x0000016e46996bb3UL;
   tf->codes[1877] = 0x000000d907071ae1UL;
   tf->codes[1878] = 0x000000ee89247a5bUL;
   tf->codes[1879] = 0x0000012753bfdbceUL;
   tf->codes[1880] = 0x0000007906c2f180UL;
   tf->codes[1881] = 0x0000006632db9a04UL;
   tf->codes[1882] = 0x0000006dd60d443fUL;
   tf->codes[1883] = 0x0000006b859327f2UL;
   tf->codes[1884] = 0x0000018f08bb0ad5UL;
   tf->codes[1885] = 0x00000100dd9d760aUL;
   tf->codes[1886] = 0x0000001e8c644d0dUL;
   tf->codes[1887] = 0x000001e8edb740dcUL;
   tf->codes[1888] = 0x0000016ba7ffa32eUL;
   tf->codes[1889] = 0x000000bfbda5d84cUL;
   tf->codes[1890] = 0x0000017fdf137ad8UL;
   tf->codes[1891] = 0x000000777ffe01dbUL;
   tf->codes[1892] = 0x0000013b9a93d0a6UL;
   tf->codes[1893] = 0x00000032bde748a4UL;
   tf->codes[1894] = 0x00000104f87c4ba8UL;
   tf->codes[1895] = 0x000001102e5438a0UL;
   tf->codes[1896] = 0x000001790599f8b8UL;
   tf->codes[1897] = 0x0000006e0e97a55cUL;
   tf->codes[1898] = 0x000000980d898e6bUL;
   tf->codes[1899] = 0x0000014035825c86UL;
   tf->codes[1900] = 0x00000199ded7a4bfUL;
   tf->codes[1901] = 0x00000138ab0050f4UL;
   tf->codes[1902] = 0x000000f8c1940ddaUL;
   tf->codes[1903] = 0x00000129ad4d2a65UL;
   tf->codes[1904] = 0x00000076a9aca541UL;
   tf->codes[1905] = 0x000001332c5d323cUL;
   tf->codes[1906] = 0x000001dba5113a26UL;
   tf->codes[1907] = 0x000001c66d9f5293UL;
   tf->codes[1908] = 0x0000017e232d0d9aUL;
   tf->codes[1909] = 0x0000009976915862UL;
   tf->codes[1910] = 0x000001913b2a7244UL;
   tf->codes[1911] = 0x000000b2ba534e99UL;
   tf->codes[1912] = 0x00000160d1bf0cf7UL;
   tf->codes[1913] = 0x0000000eb9922d30UL;
   tf->codes[1914] = 0x0000002e3f788035UL;
   tf->codes[1915] = 0x000001d158a6dfbeUL;
   tf->codes[1916] = 0x0000014e9413f1feUL;
   tf->codes[1917] = 0x00000132d8c19753UL;
   tf->codes[1918] = 0x0000014b4f73c0c3UL;
   tf->codes[1919] = 0x0000001f33b28cfdUL;
   tf->codes[1920] = 0x00000072a8fad428UL;
   tf->codes[1921] = 0x000001514364455cUL;
   tf->codes[1922] = 0x0000002d98ab517fUL;
   tf->codes[1923] = 0x00000167cedc2d26UL;
   tf->codes[1924] = 0x000001bb3c039f02UL;
   tf->codes[1925] = 0x00000144f9f06518UL;
   tf->codes[1926] = 0x00000086d324dd1cUL;
   tf->codes[1927] = 0x0000012c4eb26f57UL;
   tf->codes[1928] = 0x00000078ea843219UL;
   tf->codes[1929] = 0x0000006a55f7e6b6UL;
   tf->codes[1930] = 0x0000006d7b34c6e0UL;
   tf->codes[1931] = 0x000001016cfeb2ecUL;
   tf->codes[1932] = 0x0000004215676871UL;
   tf->codes[1933] = 0x00000156b12b4c31UL;
   tf->codes[1934] = 0x000000586fdbe5d9UL;
   tf->codes[1935] = 0x00000030212d8b7bUL;
   tf->codes[1936] = 0x000001cc7382e8cdUL;
   tf->codes[1937] = 0x0000006ca5a2d1ecUL;
   tf->codes[1938] = 0x000000875c7a96f2UL;
   tf->codes[1939] = 0x000001710b90c031UL;
   tf->codes[1940] = 0x00000010d1d8c47aUL;
   tf->codes[1941] = 0x000001bf01e51bb9UL;
   tf->codes[1942] = 0x000000c1793e8778UL;
   tf->codes[1943] = 0x000001b326c2d7e2UL;
   tf->codes[1944] = 0x000000c5310a5aabUL;
   tf->codes[1945] = 0x0000011cd7b3c8e5UL;
   tf->codes[1946] = 0x0000018d5912ebaaUL;
   tf->codes[1947] = 0x0000017450d723c4UL;
   tf->codes[1948] = 0x000000ab2fa34dcdUL;
   tf->codes[1949] = 0x0000012c7246a7bcUL;
   tf->codes[1950] = 0x000001b365296a34UL;
   tf->codes[1951] = 0x000000c47f954743UL;
   tf->codes[1952] = 0x00000050467ba354UL;
   tf->codes[1953] = 0x0000002cc0b816e1UL;
   tf->codes[1954] = 0x0000017598c4f17dUL;
   tf->codes[1955] = 0x000001af4283647bUL;
   tf->codes[1956] = 0x0000005a5d5379ecUL;
   tf->codes[1957] = 0x000001aaecddc00dUL;
   tf->codes[1958] = 0x000001325e99894fUL;
   tf->codes[1959] = 0x0000003935af6226UL;
   tf->codes[1960] = 0x0000018450e1eebeUL;
   tf->codes[1961] = 0x0000009adfe3a3d0UL;
   tf->codes[1962] = 0x00000079383c9291UL;
   tf->codes[1963] = 0x0000002212102d63UL;
   tf->codes[1964] = 0x00000153d2be7427UL;
   tf->codes[1965] = 0x000000fb53f1bb55UL;
   tf->codes[1966] = 0x000000918bed2982UL;
   tf->codes[1967] = 0x0000010f53f0d799UL;
   tf->codes[1968] = 0x000000526ff4d1b3UL;
   tf->codes[1969] = 0x000000bc90635acdUL;
   tf->codes[1970] = 0x000001453b55ba1dUL;
   tf->codes[1971] = 0x000001079d69bec4UL;
   tf->codes[1972] = 0x000001af3934bd83UL;
   tf->codes[1973] = 0x000000b29697fc3fUL;
   tf->codes[1974] = 0x00000108533de8ddUL;
   tf->codes[1975] = 0x0000012968f67594UL;
   tf->codes[1976] = 0x0000011cbe9cb3edUL;
   tf->codes[1977] = 0x0000000bac4e20c3UL;
   tf->codes[1978] = 0x00000134251aba54UL;
   tf->codes[1979] = 0x0000014eaaa20df5UL;
   tf->codes[1980] = 0x000001528aec9718UL;
   tf->codes[1981] = 0x00000170983cc1ecUL;
   tf->codes[1982] = 0x0000002f097e68c8UL;
   tf->codes[1983] = 0x0000005f746b9d5cUL;
   tf->codes[1984] = 0x000001ca56b310f3UL;
   tf->codes[1985] = 0x0000003972530948UL;
   tf->codes[1986] = 0x0000009ba80f3bceUL;
   tf->codes[1987] = 0x0000016c5f86f30dUL;
   tf->codes[1988] = 0x00000119664abd83UL;
   tf->codes[1989] = 0x0000016fdda25a23UL;
   tf->codes[1990] = 0x0000017631d1a1d3UL;
   tf->codes[1991] = 0x0000003d72d2b20dUL;
   tf->codes[1992] = 0x0000011f52f5697bUL;
   tf->codes[1993] = 0x0000001d6b6d864fUL;
   tf->codes[1994] = 0x00000043d6422f0aUL;
   tf->codes[1995] = 0x0000016ef1aa2e0cUL;
   tf->codes[1996] = 0x000000e1a3790b11UL;
   tf->codes[1997] = 0x000000f1667a531dUL;
   tf->codes[1998] = 0x0000011cc7bbbcdaUL;
   tf->codes[1999] = 0x000001ace1b03f19UL;
   tf->codes[2000] = 0x0000018bd83b1d52UL;
   tf->codes[2001] = 0x0000008a5de68db4UL;
   tf->codes[2002] = 0x0000018fbf08cfefUL;
   tf->codes[2003] = 0x00000082019639ccUL;
   tf->codes[2004] = 0x000000ab6b9a8d3bUL;
   tf->codes[2005] = 0x000001fc4a838fbaUL;
   tf->codes[2006] = 0x00000104f0d67db1UL;
   tf->codes[2007] = 0x000001e4bd144895UL;
   tf->codes[2008] = 0x0000010493faac76UL;
   tf->codes[2009] = 0x0000006f1ac45d00UL;
   tf->codes[2010] = 0x0000001b845ac503UL;
   tf->codes[2011] = 0x000001a071baaaefUL;
   tf->codes[2012] = 0x0000017ce5822109UL;
   tf->codes[2013] = 0x000001a7b9992debUL;
   tf->codes[2014] = 0x000001641ad2afd1UL;
   tf->codes[2015] = 0x000001983f74b6eeUL;
   tf->codes[2016] = 0x0000011dd4491184UL;
   tf->codes[2017] = 0x000001597809c70cUL;
   tf->codes[2018] = 0x000001c9ee207a02UL;
   tf->codes[2019] = 0x000001fb967dbcceUL;
   tf->codes[2020] = 0x00000013dd5d0740UL;
   tf->codes[2021] = 0x000001f04a7cf90aUL;
   tf->codes[2022] = 0x000000bda526f2c0UL;
   tf->codes[2023] = 0x0000000a290afad5UL;
   tf->codes[2024] = 0x000001f74ef5e0edUL;
   tf->codes[2025] = 0x000000ad155bc8deUL;
   tf->codes[2026] = 0x00000008a74e0d64UL;
   tf->codes[2027] = 0x000001e26d6d2095UL;
   tf->codes[2028] = 0x000001efe9d3f3feUL;
   tf->codes[2029] = 0x000000b7bb790080UL;
   tf->codes[2030] = 0x000000e83eb7940bUL;
   tf->codes[2031] = 0x000000195a6721deUL;
   tf->codes[2032] = 0x000001697162ecc6UL;
   tf->codes[2033] = 0x000001a822424eccUL;
   tf->codes[2034] = 0x000000bb9409ef14UL;
   tf->codes[2035] = 0x00000088dc8af7deUL;
   tf->codes[2036] = 0x0000001a109fbdf8UL;
   tf->codes[2037] = 0x000001263a6224e1UL;
   tf->codes[2038] = 0x0000019762451a46UL;
   tf->codes[2039] = 0x00000123f8087a5dUL;
   tf->codes[2040] = 0x000001ee61da2ff8UL;
   tf->codes[2041] = 0x000001050f8b67b3UL;
   tf->codes[2042] = 0x0000005bd05e0ad3UL;
   tf->codes[2043] = 0x0000017f3054510bUL;
   tf->codes[2044] = 0x000001f0a65cbe49UL;
   tf->codes[2045] = 0x000000c38f39ecfbUL;
   tf->codes[2046] = 0x000001b186adf1caUL;
   tf->codes[2047] = 0x00000003c9d6cb25UL;
   tf->codes[2048] = 0x000000b0d33343b8UL;
   tf->codes[2049] = 0x0000008cb15b5077UL;
   tf->codes[2050] = 0x00000083960895ddUL;
   tf->codes[2051] = 0x000000a4f544f26cUL;
   tf->codes[2052] = 0x0000014637fba5b5UL;
   tf->codes[2053] = 0x000000c8a7c5184dUL;
   tf->codes[2054] = 0x00000109ef503b91UL;
   tf->codes[2055] = 0x00000110cc27f58cUL;
   tf->codes[2056] = 0x000001dd15e9f124UL;
   tf->codes[2057] = 0x000001eddb2ca0d9UL;
   tf->codes[2058] = 0x000000aafbfcea5bUL;
   tf->codes[2059] = 0x0000003f14f93014UL;
   tf->codes[2060] = 0x000001c8249b99d9UL;
   tf->codes[2061] = 0x0000007c3667f5b3UL;
   tf->codes[2062] = 0x000001a62b640f70UL;
   tf->codes[2063] = 0x000001eec6a22d2aUL;
   tf->codes[2064] = 0x000000855be93f97UL;
   tf->codes[2065] = 0x000000c7af091027UL;
   tf->codes[2066] = 0x0000010a7ffe2790UL;
   tf->codes[2067] = 0x000001042e09ea4cUL;
   tf->codes[2068] = 0x00000076db25a8e1UL;
   tf->codes[2069] = 0x000001654d706d3fUL;
   tf->codes[2070] = 0x000000260b3a5e33UL;
   tf->codes[2071] = 0x00000088f9419e9eUL;
   tf->codes[2072] = 0x000001d68917df54UL;
   tf->codes[2073] = 0x000001188549820dUL;
   tf->codes[2074] = 0x00000158d48169b9UL;
   tf->codes[2075] = 0x0000019e93fcdd73UL;
   tf->codes[2076] = 0x0000016b91a47690UL;
   tf->codes[2077] = 0x000001fba468bd65UL;
   tf->codes[2078] = 0x000000bb64a6d60fUL;
   tf->codes[2079] = 0x00000157432e4097UL;
   tf->codes[2080] = 0x00000088a4f70f06UL;
   tf->codes[2081] = 0x000000f091d83cf0UL;
   tf->codes[2082] = 0x000001c4a6fbc192UL;
   tf->codes[2083] = 0x000000ada88c3e7dUL;
   tf->codes[2084] = 0x000000e531e141b5UL;
   tf->codes[2085] = 0x000001237b66171cUL;
   tf->codes[2086] = 0x0000012749c7c2f4UL;
   tf->codes[2087] = 0x000000e2cee269f9UL;
   tf->codes[2088] = 0x000000260340689fUL;
   tf->codes[2089] = 0x0000019500504a28UL;
   tf->codes[2090] = 0x0000014432099794UL;
   tf->codes[2091] = 0x00000047cbdd04d3UL;
   tf->codes[2092] = 0x0000001af023fdbeUL;
   tf->codes[2093] = 0x000001eee99e354eUL;
   tf->codes[2094] = 0x00000012649e3affUL;
   tf->codes[2095] = 0x000001a7f7a49cbfUL;
   tf->codes[2096] = 0x000000e43793e465UL;
   tf->codes[2097] = 0x0000006209ca0402UL;
   tf->codes[2098] = 0x000001eadfe92cffUL;
   tf->codes[2099] = 0x0000003dacced0bcUL;
   tf->codes[2100] = 0x00000097a15758c0UL;
   tf->codes[2101] = 0x000001fcd58aeaaeUL;
   tf->codes[2102] = 0x000000ff774c923fUL;
   tf->codes[2103] = 0x0000007a5654482cUL;
   tf->codes[2104] = 0x000001b492028846UL;
   tf->codes[2105] = 0x0000015c12bf403fUL;
   tf->codes[2106] = 0x000001e7575219b9UL;
   tf->codes[2107] = 0x000000342bb31b5cUL;
   tf->codes[2108] = 0x000001a8052db35eUL;
   tf->codes[2109] = 0x000000e8274ad0dbUL;
   tf->codes[2110] = 0x0000000f1a937c8aUL;
   tf->codes[2111] = 0x00000094b5e48ed7UL;
   tf->codes[2112] = 0x000000352cb6ab16UL;
   tf->codes[2113] = 0x0000015cff6a6f12UL;
   tf->codes[2114] = 0x000001ee40155a64UL;
   tf->nbits = 41;
   tf->bit_x = (uint32_t *)calloc(41, sizeof(uint32_t));
   tf->bit_y = (uint32_t *)calloc(41, sizeof(uint32_t));
   tf->bit_x[0] = -2;
   tf->bit_y[0] = -2;
   tf->bit_x[1] = -1;
   tf->bit_y[1] = -2;
   tf->bit_x[2] = 0;
   tf->bit_y[2] = -2;
   tf->bit_x[3] = 1;
   tf->bit_y[3] = -2;
   tf->bit_x[4] = 2;
   tf->bit_y[4] = -2;
   tf->bit_x[5] = 3;
   tf->bit_y[5] = -2;
   tf->bit_x[6] = 4;
   tf->bit_y[6] = -2;
   tf->bit_x[7] = 5;
   tf->bit_y[7] = -2;
   tf->bit_x[8] = 1;
   tf->bit_y[8] = 1;
   tf->bit_x[9] = 2;
   tf->bit_y[9] = 1;
   tf->bit_x[10] = 6;
   tf->bit_y[10] = -2;
   tf->bit_x[11] = 6;
   tf->bit_y[11] = -1;
   tf->bit_x[12] = 6;
   tf->bit_y[12] = 0;
   tf->bit_x[13] = 6;
   tf->bit_y[13] = 1;
   tf->bit_x[14] = 6;
   tf->bit_y[14] = 2;
   tf->bit_x[15] = 6;
   tf->bit_y[15] = 3;
   tf->bit_x[16] = 6;
   tf->bit_y[16] = 4;
   tf->bit_x[17] = 6;
   tf->bit_y[17] = 5;
   tf->bit_x[18] = 3;
   tf->bit_y[18] = 1;
   tf->bit_x[19] = 3;
   tf->bit_y[19] = 2;
   tf->bit_x[20] = 6;
   tf->bit_y[20] = 6;
   tf->bit_x[21] = 5;
   tf->bit_y[21] = 6;
   tf->bit_x[22] = 4;
   tf->bit_y[22] = 6;
   tf->bit_x[23] = 3;
   tf->bit_y[23] = 6;
   tf->bit_x[24] = 2;
   tf->bit_y[24] = 6;
   tf->bit_x[25] = 1;
   tf->bit_y[25] = 6;
   tf->bit_x[26] = 0;
   tf->bit_y[26] = 6;
   tf->bit_x[27] = -1;
   tf->bit_y[27] = 6;
   tf->bit_x[28] = 3;
   tf->bit_y[28] = 3;
   tf->bit_x[29] = 2;
   tf->bit_y[29] = 3;
   tf->bit_x[30] = -2;
   tf->bit_y[30] = 6;
   tf->bit_x[31] = -2;
   tf->bit_y[31] = 5;
   tf->bit_x[32] = -2;
   tf->bit_y[32] = 4;
   tf->bit_x[33] = -2;
   tf->bit_y[33] = 3;
   tf->bit_x[34] = -2;
   tf->bit_y[34] = 2;
   tf->bit_x[35] = -2;
   tf->bit_y[35] = 1;
   tf->bit_x[36] = -2;
   tf->bit_y[36] = 0;
   tf->bit_x[37] = -2;
   tf->bit_y[37] = -1;
   tf->bit_x[38] = 1;
   tf->bit_y[38] = 3;
   tf->bit_x[39] = 1;
   tf->bit_y[39] = 2;
   tf->bit_x[40] = 2;
   tf->bit_y[40] = 2;
   tf->width_at_border = 5;
   tf->total_width = 9;
   tf->reversed_border = true;
   return tf;
}

void tagStandard41h12_destroy(apriltag_family_t *tf)
{
   free(tf->codes);
   free(tf->bit_x);
   free(tf->bit_y);
   free(tf->name);
   free(tf);
}
