/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _treeviewcompo_h
#define _treeviewcompo_h
#include <vdk/vdk.h>
class TreeViewComponent: public VDKBox
{
  VDKTreeView *tree; 
  VDKTextView* textview;
  VDKCustomButton *remove,*view,*clear;
  VDKCustomButton *addrow,*addchild,*expand,*trasverse;
  VDKTreeView* MakeTree(VDKScrolled* scrolled);
  void PrintRow(GtkTreeIter* iter);
  void recurse(GtkTreeIter* iter);
  void SetData (VDKTreeViewModel* model, GtkTreeIter* iter,  int t);
 public:
  TreeViewComponent(VDKForm* owner):
    VDKBox(owner)  { }
  ~TreeViewComponent() { }
  void Setup();
  bool OnTreeRealized(VDKObject* sender);
  bool OnColumnClicked (VDKObject* sender);
  bool OnRowSelected(VDKObject* sender);
  bool OnRemoveClicked(VDKObject* sender);
  bool OnViewClicked(VDKObject* sender);
  bool OnClearClicked(VDKObject* sender);
  bool OnAddrowClicked(VDKObject* sender);
  bool OnAddchildClicked(VDKObject* sender);
  bool OnExpandClicked(VDKObject* sender);
  bool OnTrasverseClicked(VDKObject* sender);
#ifdef USE_SIGCPLUSPLUS
  void OnCellEdited(VDKObject* sender,
		    GtkTreeIter* iter, int col, char* new_text);
  void OnCellToggled(VDKObject* sender,
		    GtkTreeIter* iter, int col, bool toggled);
#endif
  DECLARE_SIGNAL_LIST(TreeViewComponent);
  DECLARE_EVENT_LIST(TreeViewComponent);
  DECLARE_SIGNAL_MAP(TreeViewComponent);
};
#endif
