#! /bin/sh -e
# tup - A file-based build system
#
# Copyright (C) 2013-2018  Mike Shal <marfey@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# Remove a normal dir and make it generated in one update.

. ./tup.sh

tmkdir foo
cat > foo/Tupfile << HERE
: |> touch %o |> ok.txt
HERE
tup touch Tupfile
update

# Remove the dir and also try to make it generated
rm -rf foo
cat > Tupfile << HERE
: |> touch %o |> foo/bar.txt
HERE
tup touch Tupfile
update

check_exist foo/bar.txt
tup_object_exist . foo

# Check that it's generated by removing the rule, and seeing that the directory
# goes away.
cat > Tupfile << HERE
HERE
tup touch Tupfile
update

check_not_exist foo
tup_object_no_exist . foo

eotup
