# Color Schemes in Terminology

Terminology uses color schemes to define the usual colors used by terminal
applications, and a bit more: color schemes can also have an impact on the
theme used.


# Configuration file

The colorschemes are stored in EET format for speed up and ease of
development.
This format being a bit cumbersome to edit, color schemes can be edit in an
easy INI format described below.

One can have a look at `data/color_schemes/Default.ini` for an example.

## Organisation of the file

The INI format is made of sections, where the name appears in square brackets
(`[` and `]`), that contain keys. Every key has a name and a value, delimited
by an equals sign (`=`).

Those value have 3 types:
 * integers, mostly used to describe versions,
 * strings, surrounded by double quotes (`"`) or not,
 * colors, described as hex color codes, with or without alpha channels, like
   `#00ffcc` or `#00ff00aa`.

Semicolons (`;`) at the beginning of the line indicate a comment.

The color scheme file contains the following sections that are mandatory:
`Main`, `Metadata`, `Colors`, `Normal`, `Bright`, `Faint` and `BrightFaint`.

## `Main`

This section has only one field `version` with a default of `1`.
In case the format has to change, this value will change.

## `Metadata`

This describes everything that is related to the color scheme but is not
actually a color!
The fields are the following:

* `version`: an integer, this is the version of the color scheme itself
* `name` is the name of the color scheme. It is expected to be the same as the
  file name without the `.ini` extension
* `author`: who made this color scheme
* `website`
* `license`: the short code of an opensource-approved license as listed on
  https://spdx.org/licenses/

## `Colors`

This section describes colors used in the UI.  The fields are:

* `bg`: the background color of the terminal
* `main`: this color is used as the main color for cursor and various effects
  on the terminal, like change of border on focus …
* `hl`: a color used for an object or text when being highlighted. Usually
  surrounded by the `main` color.
* `end_sel`: on selections, the color of the handles used to expand or shrink
  the area of the selection
* `tab_missed_1`, `tab_missed_2`, `tab_missed_3`: the main color, the outline
  color and the shadow color of the number of tabs where a bell has rung, tabs
  that need attention.
* `tab_missed_over_1`, `tab_missed_over_2`, `tab_missed_over_3`: same as
  before but when the mouse is over that number
* `tab_title_2`: the outline color of the active tab title. The foreground
  used is `Normal.def` and the shadow is `bg`.


## `Normal`, `Bright`, `Faint`, `BrightFaint`

All those sections offer the same set of colors.
`Normal` are the base colors. `Bright` are a brighter version of the `Normal`
colors, while `Faint` are a dimer version of the `Normal` colors. Finally,
`BrightFaint` are a dimer version of the `Bright` colors.

They all have those fields:

* `def`: the default foreground color
* `black`, `red`, `green`, `yellow`, `blue`, `magenta`, `cyan` and `white` are
  self-explanatory
* `inverse_fg` and `inverse_fg` are the colors used when espace codes are used
  to reverse background and foreground. Sometimes used to display selections
  by the terminal applications


# How to add a new color scheme

First, one has to write a color scheme file as described above.  Let's say we
are creating the color scheme `FooBar` stored in file `FooBar.ini`.

The `Faint` and `BrightFaint` version can be generated by using the
`gen_faint.py` script stored in `data/color_schemes/` as seen below:
`gen_faint.py FooBar.ini`

What this script does is to pick the colors from `Normal` and `Bright` and
merge them with the background color (`Colors.bg`) in a 70/30 proportion. This
proportion is configurable, like this for a 80/20 proportion:
`gen_faint.py FooBar.ini 80`

Now that we are happy with the content of `FooBar.ini`, we can call
the script `add_color_scheme.sh` stored in `data/color_schemes/` as seen
below:
`add_color_scheme.sh eet ~/.config/terminology/colorschemes/FooBar.eet FooBar.ini`

Now you should be able to select your color scheme in Terminology!
