use lang:bs:macro;

/**
 * Value for thread-id:s.
 *
 * This is special-cased in the visualization to show up like just an integer (in the form of a
 * ThreadId to manage it properly). We don't use the ThreadId class here, since Progvis will not
 * track reads/writes to it (it excludes everything inside itself).
 */
value tid_t {
	Nat id;

	init() { init { id = 0; } }

	Bool ==(tid_t o) {
		id == o.id;
	}
	Bool !=(tid_t o) {
		id != o.id;
	}
}

// Get the current thread.
tid_t thread_current() {
	tid_t id;
	id.id = progvis:program:findThisThreadId();
	return id;
}

// Yield the current thread. No-op in Progvis.
void thread_yield() {}
