// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef _CONSTELLATIONS_H
#define _CONSTELLATIONS_H

// The 88 constellation abbreviations.  Stars use these in the data files.
const int NUM_CONSTELLATIONS = 88;
static const char * constellations[NUM_CONSTELLATIONS] = {
  "And", "Ant", "Aps", "Aqr", "Aql", "Ara", "Ari", "Aur", "Boo", "Cae",
  "Cam", "Cnc", "CVn", "CMa", "CMi", "Cap", "Car", "Cas", "Cen", "Cep",
  "Cet", "Cha", "Cir", "Col", "Com", "CrA", "CrB", "Crv", "Crt", "Cru",
  "Cyg", "Del", "Dor", "Dra", "Equ", "Eri", "For", "Gem", "Gru", "Her",
  "Hor", "Hya", "Hyi", "Ind", "Lac", "LMi", "Leo", "Lep", "Lib", "Lup",
  "Lyn", "Lyr", "Men", "Mic", "Mon", "Mus", "Nor", "Oct", "Oph", "Ori",
  "Pav", "Peg", "Per", "Phe", "Pic", "Psc", "PsA", "Pup", "Pyx", "Ret",
  "Sge", "Sgr", "Sco", "Scl", "Sct", "Ser", "Sex", "Tau", "Tel", "TrA",
  "Tri", "Tuc", "UMa", "UMi", "Vel", "Vir", "Vol", "Vul"
};

static const char * uc_constellations[NUM_CONSTELLATIONS] = {
  "AND", "ANT", "APS", "AQR", "AQL", "ARA", "ARI", "AUR", "BOO", "CAE",
  "CAM", "CNC", "CVN", "CMA", "CMI", "CAP", "CAR", "CAS", "CEN", "CEP",
  "CET", "CHA", "CIR", "COL", "COM", "CRA", "CRB", "CRV", "CRT", "CRU",
  "CYG", "DEL", "DOR", "DRA", "EQU", "ERI", "FOR", "GEM", "GRU", "HER",
  "HOR", "HYA", "HYI", "IND", "LAC", "LMI", "LEO", "LEP", "LIB", "LUP",
  "LYN", "LYR", "MEN", "MIC", "MON", "MUS", "NOR", "OCT", "OPH", "ORI",
  "PAV", "PEG", "PER", "PHE", "PIC", "PSC", "PSA", "PUP", "PYX", "RET",
  "SGE", "SGR", "SCO", "SCL", "SCT", "SER", "SEX", "TAU", "TEL", "TRA",
  "TRI", "TUC", "UMA", "UMI", "VEL", "VIR", "VOL", "VUL"
};

#ifdef NEED_FULL_NAMES
// Genitive forms of the constellation names.  Constellation abbrevs. are
// translated to these in memory when the data file is loaded.
static const char * constelnames[NUM_CONSTELLATIONS] = {
	"Andromedae", "Antliae", "Apodis", "Aquarii", "Aquilae", "Arae",
	"Arietis", "Aurigae", "Bootis", "Caeli", "Camelopardalis", "Cancri",
	"Canum Venaticorum", "Canis Majoris", "Canis Minoris", "Capricorni",
	"Carinae", "Cassiopeiae", "Centauri", "Cephei", "Ceti", "Chamaleontis",
	"Circini", "Columbae", "Comae Berenices", "Coronae Australis",
	"Coronae Borealis", "Corvi", "Crateris", "Crucis", "Cygni",
	"Delphini", "Doradus", "Draconis", "Equulei", "Eridani", "Fornacis",
	"Geminorum", "Gruis", "Herculis", "Horologii", "Hydrae", "Hydri",
	"Indi", "Lacertae", "Leonis Minoris", "Leonis", "Leporis", "Librae",
	"Lupi", "Lyncis", "Lyrae", "Mensae", "Microscopii", "Monocerotis",
	"Muscae", "Normae", "Octantis", "Ophiuchi", "Orionis", "Pavonis",
	"Pegasi", "Persei", "Phoenicis", "Pictoris", "Piscium",
	"Pisces Austrini", "Puppis", "Pyxidis", "Reticuli", "Sagittae",
	"Sagittarii", "Scorpii", "Sculptoris", "Scuti", "Serpentis",
	"Sextantis", "Tauri", "Telescopii", "Trianguli Australis", "Trianguli",
	"Tucanae", "Ursae Majoris", "Ursae Minoris", "Velorum", "Virginis",
	"Volantis", "Vulpeculae"
};
#endif // #ifdef NEED_FULL_NAMES

#endif // #ifndef _CONSTELLATIONS_H
