#include "compat.h"
#include <ctype.h>

#if ! HAVE_STRTOD

static double pow10(int power)
{
  int i;
  double result = 1.0, multiplier = 10.0;

  if (power < 0) { multiplier = 0.1; power *= -1; }
  for (i = 0; i < power; i++) { result *= multiplier; }

  return result;
}
	
double
strtod(const char *nptr, char **endptr)
{
  int i = 0, neg = 0;
  double result = 0;
  
  if (nptr == 0) return 0.0;

  while (isspace(nptr[i])) i++;
  if (nptr[i] == '-') neg = 1;
  else if (! isdigit(nptr[i]) && nptr[i] != '+') {
    /* "If no conversion is performed, zero is returned and the value
     * of nptr is stored in the location referenced by endptr." */
    if (endptr) *endptr = nptr;
    return result;
  }

  if (nptr[i] == '-' || nptr[i] == '+') i++;
  while (isdigit(nptr[i])) {
    result *= 10;
    result += (nptr[i] - '0');
    i++;
  }

  /* check for decimal places */
  if (nptr[i] == ',' || nptr[i] == '.') {
    double fractional = 0.0;
    int decimal_pt = i;
    i++;
    while (isdigit(nptr[i])) {
      fractional += (nptr[i] - '0') * pow10(decimal_pt - i);
      i++;
    }
    result += fractional;
  }
  
  /* check for exponent */
  if (nptr[i] == 'e' || nptr[i] == 'E') {
    int exponent = 0, expneg = 0;
    i++;
    if (nptr[i] == '-') { expneg = 1; i++; }
    if (nptr[i] == '+') i++;
    while (isdigit(nptr[i])) {
      exponent *= 10;
      exponent += (nptr[i] - '0');
      i++;
    }
    if (expneg) exponent *= -1;
    result *= pow10(exponent);
  }
  
  if (neg) result *= -1;
  if (endptr) *endptr = nptr + i;
  return result;
}

#endif

