#include "compat.h"

#if ! HAVE_POW
#include <math.h>
#include <stdio.h>

double
pow(double x, double y)
{
  int i;
  double result = 1.0, frac_y;
  
  if (x == 0 && y <= 0) {
    fprintf(stderr, _("Sorry, division by zero was encountered.\n"));
    exit(EXIT_FAILURE);
  }
  if (x == 0) return 0;
  if (y < 0) x = 1.0/x, y *= -1.0;
  frac_y = y - (int)y;
  
  for (i = 0; i < (int)y; i++) result *= x;

  /* if y is integer, avoid calling expensive exp(), log() functions */
  if (frac_y != 0) {
    if (x >= 0) result *= exp(frac_y * log(x));
    else {
      fprintf(stderr,
	_("Sorry, fractional power of a negative number was attempted.\n"));
      exit(EXIT_FAILURE);
    }
  }
  return result;
}
#endif

