#!/bin/sh -e

# Script to recreate autotools files, in preparation for making a new
# release of StarPlot or in case you want to build StarPlot from the
# Subversion repository.

# NOTE: If you have downloaded a tarball of starplot from the web site,
# YOU DO NOT NEED TO RUN THIS SCRIPT -- a simple "./configure && make" will
# suffice.  See the INSTALL file.

if [ "x$1" = x--help ] || [ "x$1" = x-h ] ; then
	echo "$0: Generate autotools files for StarPlot."
	echo
	cat << EOF
NOTE: If you have downloaded a tarball of starplot from the web site,
YOU DO NOT NEED TO RUN THIS SCRIPT -- a simple "./configure && make" will
suffice.  See the INSTALL file.
EOF
	exit 0
fi

# Run this first in order to get the files in m4 subdirectory
[ -n "$AUTOPOINT" ] || AUTOPOINT=autopoint
"$AUTOPOINT" --force

if [ -d m4 ] && [ -n "$(ls -1 m4/*.m4 2> /dev/null)" ] ; then
	echo "Creating file m4/Makefile.am"
	printf "EXTRA_DIST = " > m4/Makefile.am
	( cd m4 && echo *.m4 >> Makefile.am )
fi

# This is a locally modified version of the file; keep it:
if [ -e INSTALL ] && [ ! -e INSTALL.local ] ; then
	mv INSTALL INSTALL.local
fi

# The following is needed, otherwise automake 1.10 will no longer create
# mkinstalldirs by default.
# Make it do something reasonable in case automake stops creating it
# at all sometime in the future:
rm -f mkinstalldirs
echo > mkinstalldirs << EOF
#!/bin/sh -e
mkdir -p "$@"
EOF
chmod a+x mkinstalldirs

set +e
autoreconf --force --install --warnings=all --warnings=no-obsolete "$@"
result="$?"
if [ -e INSTALL ] ; then
	mv INSTALL INSTALL.generic
fi
if [ -e INSTALL.local ] ; then
	mv INSTALL.local INSTALL
fi

exit $result
