# ===========================================================================
#
#                            PUBLIC DOMAIN NOTICE
#               National Center for Biotechnology Information
#
#  This software/database is a "United States Government Work" under the
#  terms of the United States Copyright Act.  It was written as part of
#  the author's official duties as a United States Government employee and
#  thus cannot be copyrighted.  This software/database is freely available
#  to the public for use. The National Library of Medicine and the U.S.
#  Government have not placed any restriction on its use or reproduction.
#
#  Although all reasonable efforts have been taken to ensure the accuracy
#  and reliability of the software and data, the NLM and the U.S.
#  Government do not and cannot warrant the performance or results that
#  may be obtained by using this software or data. The NLM and the U.S.
#  Government disclaim all warranties, express or implied, including
#  warranties of performance, merchantability or fitness for any particular
#  purpose.
#
#  Please cite the author in any work or product based on this material.
#
# ===========================================================================


# compilers
CC = @ $(TOP)/build/$(OS)-cc.sh $(OS) 'cc -c' \
	 $(CHECKSUM) --objx $(OBJX) --cflags "$(CFLAGS)" -MD
CP = @ $(TOP)/build/$(OS)-c++.sh $(OS) 'c++ -c' \
	 $(CHECKSUM) --objx $(OBJX) --cflags "$(CPFLAGS)" -MD

# C preprocessor
PP = cc -E $(CFLAGS)

# linkers
LD = @ $(TOP)/build/ld.sh $(OS) $(ARCH) cc \
	--build $(BUILD) --ldflags "$(LDFLAGS)" $(STATIC) \
	$(STATICSYSLIBS) $(CHECKSUM) --objx $(OBJX) --shlx $(SHLX) --libx $(LIBX) \
	-MD --srcdir $(SRCDIR) --bindir $(BINDIR) -L$(LIBDIR):$(ILIBDIR)

LP = @ $(TOP)/build/ld.sh $(OS) $(ARCH) c++ \
	--build $(BUILD) --ldflags "$(LDFLAGS)" $(STATIC) \
	$(STATICSYSLIBS) $(CHECKSUM) --objx $(OBJX) --shlx $(SHLX) --libx $(LIBX) \
	-MD --srcdir $(SRCDIR) --bindir $(BINDIR) -L$(LIBDIR):$(ILIBDIR)

# tool options
WARN =

ifeq (64,$(BITS))
	CARCH = -m64
else
	CARCH = -m32
endif

ifeq (prof, $(BUILD))
	PROF = -xpg
endif

ifeq (dbg, $(BUILD))
	DBG = -g
	OPT = $(WARN)
	NOPT = $(WARN)
	PED = -xc99=all -Xc -v
else
	OPT = -xO3
	PED = -xc99=all # -Xc -v
endif
