/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_63 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 32545, "epsg", 32545,
        "WGS 72BE / UTM zone 45S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 45S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",87");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32545\"]]");
    p = add_epsg_def_ex (filter, first, last, 32546, "epsg", 32546,
        "WGS 72BE / UTM zone 46S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 46S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",93");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32546\"]]");
    p = add_epsg_def_ex (filter, first, last, 32547, "epsg", 32547,
        "WGS 72BE / UTM zone 47S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 47S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",99");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",10000000],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"32547\"]]");
    p = add_epsg_def_ex (filter, first, last, 32548, "epsg", 32548,
        "WGS 72BE / UTM zone 48S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 48S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",10");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32548\"]]");
    p = add_epsg_def_ex (filter, first, last, 32549, "epsg", 32549,
        "WGS 72BE / UTM zone 49S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 49S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",11");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32549\"]]");
    p = add_epsg_def_ex (filter, first, last, 32550, "epsg", 32550,
        "WGS 72BE / UTM zone 50S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 50S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",11");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32550\"]]");
    p = add_epsg_def_ex (filter, first, last, 32551, "epsg", 32551,
        "WGS 72BE / UTM zone 51S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 51S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32551\"]]");
    p = add_epsg_def_ex (filter, first, last, 32552, "epsg", 32552,
        "WGS 72BE / UTM zone 52S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 52S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32552\"]]");
    p = add_epsg_def_ex (filter, first, last, 32553, "epsg", 32553,
        "WGS 72BE / UTM zone 53S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 53S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32553\"]]");
    p = add_epsg_def_ex (filter, first, last, 32554, "epsg", 32554,
        "WGS 72BE / UTM zone 54S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 54S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32554\"]]");
    p = add_epsg_def_ex (filter, first, last, 32555, "epsg", 32555,
        "WGS 72BE / UTM zone 55S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 55S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32555\"]]");
    p = add_epsg_def_ex (filter, first, last, 32556, "epsg", 32556,
        "WGS 72BE / UTM zone 56S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 56S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32556\"]]");
    p = add_epsg_def_ex (filter, first, last, 32557, "epsg", 32557,
        "WGS 72BE / UTM zone 57S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 57S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",15");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32557\"]]");
    p = add_epsg_def_ex (filter, first, last, 32558, "epsg", 32558,
        "WGS 72BE / UTM zone 58S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 58S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",16");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32558\"]]");
    p = add_epsg_def_ex (filter, first, last, 32559, "epsg", 32559,
        "WGS 72BE / UTM zone 59S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 59S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",17");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32559\"]]");
    p = add_epsg_def_ex (filter, first, last, 32560, "epsg", 32560,
        "WGS 72BE / UTM zone 60S", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=WGS72 +towgs84=0,0,1.9,");
    add_proj4text (p, 1,
        "0,0,0.814,-0.38 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / UTM zone 60S\",GEOGCS[\"WGS 72BE\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"43");
    add_srs_wkt (p, 6,
        "24\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",17");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"32560\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

