/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_34 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6633, "epsg", 6633,
        "NAD83(PA11) / Hawaii zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_PA11", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / Hawaii zone 3 (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(PA11)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_PA11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",21.1");
    add_srs_wkt (p, 8,
        "666666666667],PARAMETER[\"central_meridian\",-158],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.99999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",1640416.6667],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6633\"]]");
    p = add_epsg_def_ex (filter, first, last, 6634, "epsg", 6634,
        "NAD83(PA11) / UTM zone 4N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_PA11", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / UTM zone 4N\",GEOGCS[\"NAD83(PA11");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_PA11");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-159],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6634\"]]");
    p = add_epsg_def_ex (filter, first, last, 6635, "epsg", 6635,
        "NAD83(PA11) / UTM zone 5N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_PA11", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / UTM zone 5N\",GEOGCS[\"NAD83(PA11");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_PA11");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-153],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6635\"]]");
    p = add_epsg_def_ex (filter, first, last, 6636, "epsg", 6636,
        "NAD83(PA11) / UTM zone 2S", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_PA11", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(PA11) / UTM zone 2S\",GEOGCS[\"NAD83(PA11");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_National_Spatial_Reference_System_PA11");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1117\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-171],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"6636\"]]");
    p = add_epsg_def_ex (filter, first, last, 6637, "epsg", 6637,
        "NAD83(MA11) / Guam Map Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_MA11", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.5 +lon_0=144.75 +k=1 +x_0=100000 +");
    add_proj4text (p, 1,
        "y_0=200000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(MA11) / Guam Map Grid\",GEOGCS[\"NAD83(MA");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_MA");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1118\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6325\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",13.5],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",144.75],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",1],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"6637\"]]");
    p = add_epsg_def_ex (filter, first, last, 6646, "epsg", 6646,
        "Karbala 1979 / Iraq National Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Karbala_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.02626833333333 +lon_0=46.5 +k=0.99");
    add_proj4text (p, 1,
        "94 +x_0=800000 +y_0=0 +ellps=clrk80 +towgs84=70.995,-335");
    add_proj4text (p, 2,
        ".916,262.898,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Karbala 1979 / Iraq National Grid\",GEOGCS[\"Ka");
    add_srs_wkt (p, 1,
        "rbala 1979\",DATUM[\"Karbala_1979\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6743\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4743\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",29.0262683333333],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",46.5],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9994],PARAMETER[\"false_easting\",800000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"6646\"]]");
    p = add_epsg_def_ex (filter, first, last, 6649, "epsg", 6649,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) + CGVD2013 height\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4617\"]],VERT_CS[\"CGVD2013(CGG2013) he");
    add_srs_wkt (p, 8,
        "ight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of ");
    add_srs_wkt (p, 9,
        "2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 11,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"6649\"]]");
    p = add_epsg_def_ex (filter, first, last, 6650, "epsg", 6650,
        "NAD83(CSRS) / UTM zone 7N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 7N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 7N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 2,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 3,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-141],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3154\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6650\"]]");
    p = add_epsg_def_ex (filter, first, last, 6651, "epsg", 6651,
        "NAD83(CSRS) / UTM zone 8N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 8N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 8N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 2,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 3,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-135],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3155\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6651\"]]");
    p = add_epsg_def_ex (filter, first, last, 6652, "epsg", 6652,
        "NAD83(CSRS) / UTM zone 9N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 9N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 9N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 2,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 3,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-129],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3156\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6652\"]]");
    p = add_epsg_def_ex (filter, first, last, 6653, "epsg", 6653,
        "NAD83(CSRS) / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 10N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 10N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-123],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3157\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6653\"]]");
    p = add_epsg_def_ex (filter, first, last, 6654, "epsg", 6654,
        "NAD83(CSRS) / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 11N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 11N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-117],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"2955\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6654\"]]");
    p = add_epsg_def_ex (filter, first, last, 6655, "epsg", 6655,
        "NAD83(CSRS) / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 12N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 12N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-111],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"2956\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6655\"]]");
    p = add_epsg_def_ex (filter, first, last, 6656, "epsg", 6656,
        "NAD83(CSRS) / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 13N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 13N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-105],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"2957\"]],VERT_CS[\"CGVD2013(CGG2013) ");
    add_srs_wkt (p, 14,
        "height\",VERT_DATUM[\"Canadian Geodetic Vertical Datum o");
    add_srs_wkt (p, 15,
        "f 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UN");
    add_srs_wkt (p, 16,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Grav");
    add_srs_wkt (p, 17,
        "ity-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"6656\"]]");
    p = add_epsg_def_ex (filter, first, last, 6657, "epsg", 6657,
        "NAD83(CSRS) / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 14N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 14N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-99],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3158\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6657\"]]");
    p = add_epsg_def_ex (filter, first, last, 6658, "epsg", 6658,
        "NAD83(CSRS) / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 15N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 15N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3159\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6658\"]]");
    p = add_epsg_def_ex (filter, first, last, 6659, "epsg", 6659,
        "NAD83(CSRS) / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 16N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 16N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-87],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3160\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6659\"]]");
    p = add_epsg_def_ex (filter, first, last, 6660, "epsg", 6660,
        "NAD83(CSRS) / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 17N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 17N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2958\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6660\"]]");
    p = add_epsg_def_ex (filter, first, last, 6661, "epsg", 6661,
        "NAD83(CSRS) / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 18N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 18N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2959\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6661\"]]");
    p = add_epsg_def_ex (filter, first, last, 6662, "epsg", 6662,
        "NAD83(CSRS) / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 19N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 19N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2960\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6662\"]]");
    p = add_epsg_def_ex (filter, first, last, 6663, "epsg", 6663,
        "NAD83(CSRS) / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 20N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 20N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2961\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6663\"]]");
    p = add_epsg_def_ex (filter, first, last, 6664, "epsg", 6664,
        "NAD83(CSRS) / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 21N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 21N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-57],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"2962\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6664\"]]");
    p = add_epsg_def_ex (filter, first, last, 6665, "epsg", 6665,
        "NAD83(CSRS) / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 22N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 22N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4617\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-51],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"3761\"]],VERT_CS[\"CGVD2013(CGG2013) h");
    add_srs_wkt (p, 14,
        "eight\",VERT_DATUM[\"Canadian Geodetic Vertical Datum of");
    add_srs_wkt (p, 15,
        " 2013 (CGG2013)\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNI");
    add_srs_wkt (p, 16,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 17,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"6647\"]],AU");
    add_srs_wkt (p, 18,
        "THORITY[\"EPSG\",\"6665\"]]");
    p = add_epsg_def_ex (filter, first, last, 6667, "epsg", 6667,
        "JGD2011", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"JGD2011\",DATUM[\"Japanese Geodetic Datum 2011");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Japan - ons");
    add_srs_wkt (p, 9,
        "hore and offshore.\"],BBOX[17.09,122.38,46.05,157.65]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",6667]]");
    p = add_epsg_def_ex (filter, first, last, 6668, "epsg", 6668,
        "JGD2011", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"6668\"]]");
    p = add_epsg_def_ex (filter, first, last, 6669, "epsg", 6669,
        "JGD2011 / Japan Plane Rectangular CS I", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS I\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",129.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"6669\"]]");
    p = add_epsg_def_ex (filter, first, last, 6670, "epsg", 6670,
        "JGD2011 / Japan Plane Rectangular CS II", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS II\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",131],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"6670\"]]");
    p = add_epsg_def_ex (filter, first, last, 6671, "epsg", 6671,
        "JGD2011 / Japan Plane Rectangular CS III", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS III\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",132.166666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"6671\"]]");
    p = add_epsg_def_ex (filter, first, last, 6672, "epsg", 6672,
        "JGD2011 / Japan Plane Rectangular CS IV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",133.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"6672\"]]");
    p = add_epsg_def_ex (filter, first, last, 6673, "epsg", 6673,
        "JGD2011 / Japan Plane Rectangular CS V", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS V\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",134.333333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"6673\"]]");
    p = add_epsg_def_ex (filter, first, last, 6674, "epsg", 6674,
        "JGD2011 / Japan Plane Rectangular CS VI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",136],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"6674\"]]");
    p = add_epsg_def_ex (filter, first, last, 6675, "epsg", 6675,
        "JGD2011 / Japan Plane Rectangular CS VII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",137.166666666667],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"6675\"]]");
    p = add_epsg_def_ex (filter, first, last, 6676, "epsg", 6676,
        "JGD2011 / Japan Plane Rectangular CS VIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",138.5],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"6676\"]]");
    p = add_epsg_def_ex (filter, first, last, 6677, "epsg", 6677,
        "JGD2011 / Japan Plane Rectangular CS IX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IX\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",139.833333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"6677\"]]");
    p = add_epsg_def_ex (filter, first, last, 6678, "epsg", 6678,
        "JGD2011 / Japan Plane Rectangular CS X", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS X\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",140.833333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AUTHORITY[\"EPSG\",\"6678\"]]");
    p = add_epsg_def_ex (filter, first, last, 6679, "epsg", 6679,
        "JGD2011 / Japan Plane Rectangular CS XI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",140.25],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"6679\"]]");
    p = add_epsg_def_ex (filter, first, last, 6680, "epsg", 6680,
        "JGD2011 / Japan Plane Rectangular CS XII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",142.25],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_no");
    add_srs_wkt (p, 10,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"6680\"]]");
    p = add_epsg_def_ex (filter, first, last, 6681, "epsg", 6681,
        "JGD2011 / Japan Plane Rectangular CS XIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",144.25],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"6681\"]]");
    p = add_epsg_def_ex (filter, first, last, 6682, "epsg", 6682,
        "JGD2011 / Japan Plane Rectangular CS XIV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIV\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",142],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"6682\"]]");
    p = add_epsg_def_ex (filter, first, last, 6683, "epsg", 6683,
        "JGD2011 / Japan Plane Rectangular CS XV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",127.5],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"6683\"]]");
    p = add_epsg_def_ex (filter, first, last, 6684, "epsg", 6684,
        "JGD2011 / Japan Plane Rectangular CS XVI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVI\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",124],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"6684\"]]");
    p = add_epsg_def_ex (filter, first, last, 6685, "epsg", 6685,
        "JGD2011 / Japan Plane Rectangular CS XVII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",131],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"6685\"]]");
    p = add_epsg_def_ex (filter, first, last, 6686, "epsg", 6686,
        "JGD2011 / Japan Plane Rectangular CS XVIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVIII\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",20],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",136],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"6686\"]]");
    p = add_epsg_def_ex (filter, first, last, 6687, "epsg", 6687,
        "JGD2011 / Japan Plane Rectangular CS XIX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIX\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",154],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"6687\"]]");
    p = add_epsg_def_ex (filter, first, last, 6688, "epsg", 6688,
        "JGD2011 / UTM zone 51N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 51N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 6689, "epsg", 6689,
        "JGD2011 / UTM zone 52N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 52N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 6690, "epsg", 6690,
        "JGD2011 / UTM zone 53N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 53N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"669");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 6691, "epsg", 6691,
        "JGD2011 / UTM zone 54N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 54N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"669");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 6692, "epsg", 6692,
        "JGD2011 / UTM zone 55N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 55N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 6,
        "68\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",14");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"669");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 6696, "epsg", 6696,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"JGD2000 + JGD2000 (vertical) height\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6612\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4612\"]],VERT_CS[\"JGD2000 (vertical) height\",VE");
    add_srs_wkt (p, 8,
        "RT_DATUM[\"Japanese Geodetic Datum 2000 (vertical)\",200");
    add_srs_wkt (p, 9,
        "5,AUTHORITY[\"EPSG\",\"1130\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 10,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 11,
        "P],AUTHORITY[\"EPSG\",\"6694\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 12,
        "96\"]]");
    p = add_epsg_def_ex (filter, first, last, 6697, "epsg", 6697,
        "JGD2011", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"JGD2011 + JGD2011 (vertical) height\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"6668\"]],VERT_CS[\"JGD2011 (vertical) height\",VE");
    add_srs_wkt (p, 8,
        "RT_DATUM[\"Japanese Geodetic Datum 2011 (vertical)\",200");
    add_srs_wkt (p, 9,
        "5,AUTHORITY[\"EPSG\",\"1131\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 10,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 11,
        "P],AUTHORITY[\"EPSG\",\"6695\"]],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 12,
        "97\"]]");
    p = add_epsg_def_ex (filter, first, last, 6700, "epsg", 6700,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Tokyo + JSLD72 height\",GEOGCS[\"Tokyo\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],VERT_CS[\"JSLD72 ");
    add_srs_wkt (p, 7,
        "height\",VERT_DATUM[\"Japanese Standard Levelling Datum ");
    add_srs_wkt (p, 8,
        "1972\",2005,AUTHORITY[\"EPSG\",\"1129\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 9,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 10,
        "height\",UP],AUTHORITY[\"EPSG\",\"6693\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"6700\"]]");
    p = add_epsg_def_ex (filter, first, last, 6703, "epsg", 6703,
        "WGS 84 / TM 60 SW", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-60 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 60 SW\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 6,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 7,
        "METER[\"central_meridian\",-60],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"6703\"]]");
    p = add_epsg_def_ex (filter, first, last, 6705, "epsg", 6705,
        "RDN2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RDN2008\",DATUM[\"Rete Dinamica Nazionale 2008");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Italy - ons");
    add_srs_wkt (p, 9,
        "hore and offshore; San Marino, Vatican City State.\"],BB");
    add_srs_wkt (p, 10,
        "OX[34.76,5.93,47.1,18.99]],ID[\"EPSG\",6705]]");
    p = add_epsg_def_ex (filter, first, last, 6706, "epsg", 6706,
        "RDN2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RDN2008\",DATUM[\"Rete_Dinamica_Nazionale_2008\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"6706\"]]");
    p = add_epsg_def_ex (filter, first, last, 6707, "epsg", 6707,
        "RDN2008 / UTM zone 32N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 32N (N-E)\",GEOGCS[\"RDN2008");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "6707\"]]");
    p = add_epsg_def_ex (filter, first, last, 6708, "epsg", 6708,
        "RDN2008 / UTM zone 33N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 33N (N-E)\",GEOGCS[\"RDN2008");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"6708\"]]");
    p = add_epsg_def_ex (filter, first, last, 6709, "epsg", 6709,
        "RDN2008 / UTM zone 34N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 34N (N-E)\",GEOGCS[\"RDN2008");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1132\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"6706\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"6709\"]]");
    p = add_epsg_def_ex (filter, first, last, 6720, "epsg", 6720,
        "WGS 84 / CIG92", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.000024 +x_0=500");
    add_proj4text (p, 1,
        "00 +y_0=1300000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / CIG92\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 6,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"central_meridian\",105.625],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",1.000024],PARAMETER[\"false_easting\",50000],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_northing\",1300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"6720\"]]");
    p = add_epsg_def_ex (filter, first, last, 6721, "epsg", 6721,
        "GDA94 / CIG94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.00002514 +x_0=5");
    add_proj4text (p, 1,
        "0000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / CIG94\",GEOGCS[\"GDA94\",DATUM[\"Geocen");
    add_srs_wkt (p, 1,
        "tric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4283\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",105.62");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1.00002514],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",50000],PARAMETER[\"false_northing\",130000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"6721\"]]");
    p = add_epsg_def_ex (filter, first, last, 6722, "epsg", 6722,
        "WGS 84 / CKIG92", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=1 +x_0=50000 +y_0=");
    add_proj4text (p, 1,
        "1400000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / CKIG92\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 6,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"central_meridian\",96.875],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 8,
        "\",1],PARAMETER[\"false_easting\",50000],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_northing\",1400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 10,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AUTHORITY[\"EPSG\",\"6722\"]]");
    p = add_epsg_def_ex (filter, first, last, 6723, "epsg", 6723,
        "GDA94 / CKIG94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=0.99999387 +x_0=50");
    add_proj4text (p, 1,
        "000 +y_0=1500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / CKIG94\",GEOGCS[\"GDA94\",DATUM[\"Geoce");
    add_srs_wkt (p, 1,
        "ntric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4283\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",96.875");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.99999387],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",50000],PARAMETER[\"false_northing\",1500000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"6723\"]]");
    p = add_epsg_def_ex (filter, first, last, 6732, "epsg", 6732,
        "GDA94 / MGA zone 41 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 41 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",63],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"6732\"]]");
    p = add_epsg_def_ex (filter, first, last, 6733, "epsg", 6733,
        "GDA94 / MGA zone 42 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 42 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",69],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"6733\"]]");
    p = add_epsg_def_ex (filter, first, last, 6734, "epsg", 6734,
        "GDA94 / MGA zone 43 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 43 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",75],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"6734\"]]");
    p = add_epsg_def_ex (filter, first, last, 6735, "epsg", 6735,
        "GDA94 / MGA zone 44 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 44 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",81],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"6735\"]]");
    p = add_epsg_def_ex (filter, first, last, 6736, "epsg", 6736,
        "GDA94 / MGA zone 46", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 46\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"6736\"]]");
    p = add_epsg_def_ex (filter, first, last, 6737, "epsg", 6737,
        "GDA94 / MGA zone 47", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 47\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"6737\"]]");
    p = add_epsg_def_ex (filter, first, last, 6738, "epsg", 6738,
        "GDA94 / MGA zone 59", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 59\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4283\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"6738\"]]");
    p = add_epsg_def_ex (filter, first, last, 6782, "epsg", 6782,
        "NAD83(CORS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CORS96)\",DATUM[\"NAD83 (Continuously Op");
    add_srs_wkt (p, 1,
        "erating Reference Station 1996)\",ELLIPSOID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[");
    add_srs_wkt (p, 3,
        "\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 4,
        "],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\",nor");
    add_srs_wkt (p, 5,
        "th,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AX");
    add_srs_wkt (p, 6,
        "IS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[");
    add_srs_wkt (p, 7,
        "\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal heigh");
    add_srs_wkt (p, 8,
        "t (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE");
    add_srs_wkt (p, 9,
        "[\"Geodesy.\"],AREA[\"Puerto Rico - onshore and offshore");
    add_srs_wkt (p, 10,
        ". United States (USA) onshore and offshore - Alabama; Al");
    add_srs_wkt (p, 11,
        "aska; Arizona; Arkansas; California; Colorado; Connectic");
    add_srs_wkt (p, 12,
        "ut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana");
    add_srs_wkt (p, 13,
        "; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Ma");
    add_srs_wkt (p, 14,
        "ssachusetts; Michigan; Minnesota; Mississippi; Missouri;");
    add_srs_wkt (p, 15,
        " Montana; Nebraska; Nevada; New Hampshire; New Jersey; N");
    add_srs_wkt (p, 16,
        "ew Mexico; New York; North Carolina; North Dakota; Ohio;");
    add_srs_wkt (p, 17,
        " Oklahoma; Oregon; Pennsylvania; Rhode Island; South Car");
    add_srs_wkt (p, 18,
        "olina; South Dakota; Tennessee; Texas; Utah; Vermont; Vi");
    add_srs_wkt (p, 19,
        "rginia; Washington; West Virginia; Wisconsin; Wyoming. U");
    add_srs_wkt (p, 20,
        "S Virgin Islands - onshore and offshore.\"],BBOX[14.92,1");
    add_srs_wkt (p, 21,
        "67.65,74.71,-63.88]],ID[\"EPSG\",6782]]");
    p = add_epsg_def_ex (filter, first, last, 6783, "epsg", 6783,
        "NAD83(CORS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 1,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]]");
    p = add_epsg_def_ex (filter, first, last, 6784, "epsg", 6784,
        "NAD83(CORS96) / Oregon Baker zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Baker zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_R");
    add_srs_wkt (p, 2,
        "eference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",44.5],PARAMETER[\"central_meridian\",-117.833333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"scale_factor\",1.00016],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",40000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6784\"]]");
    p = add_epsg_def_ex (filter, first, last, 6785, "epsg", 6785,
        "NAD83(CORS96) / Oregon Baker zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Baker zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",44.5],PARAMETER[\"central_meridian\",-117.8333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.00016],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",131233.5958],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"6785\"]]");
    p = add_epsg_def_ex (filter, first, last, 6786, "epsg", 6786,
        "NAD83(2011) / Oregon Baker zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Baker zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"central_meridian\",-117.833333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.00016],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",40000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6786\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6787, "epsg", 6787,
        "NAD83(2011) / Oregon Baker zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Baker zone (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"central_meridian\",-117.833333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.00016],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",131233.5958],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"6787\"]]");
    p = add_epsg_def_ex (filter, first, last, 6788, "epsg", 6788,
        "NAD83(CORS96) / Oregon Bend-Klamath Falls zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=8");
    add_proj4text (p, 1,
        "0000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Klamath Falls zone ");
    add_srs_wkt (p, 1,
        "(m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuousl");
    add_srs_wkt (p, 2,
        "y_Operating_Reference_Station_1996\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",41.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-121.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",80000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6788\"]]");
    p = add_epsg_def_ex (filter, first, last, 6789, "epsg", 6789,
        "NAD83(CORS96) / Oregon Bend-Klamath Falls zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=7");
    add_proj4text (p, 1,
        "9999.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Klamath Falls zone ");
    add_srs_wkt (p, 1,
        "(ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",41.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-121.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",262467.1916],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"6789\"]]");
    p = add_epsg_def_ex (filter, first, last, 6790, "epsg", 6790,
        "NAD83(2011) / Oregon Bend-Klamath Falls zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=8");
    add_proj4text (p, 1,
        "0000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Klamath Falls zone (m");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",41.75],PARAMETER[\"central_meridian\",-121.75");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0002],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",80000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6790");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 6791, "epsg", 6791,
        "NAD83(2011) / Oregon Bend-Klamath Falls zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=7");
    add_proj4text (p, 1,
        "9999.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Klamath Falls zone (f");
    add_srs_wkt (p, 1,
        "t)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",41.75],PARAMETER[\"central_meridian\",-121.75");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0002],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",262467.1916],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"6791\"]]");
    p = add_epsg_def_ex (filter, first, last, 6792, "epsg", 6792,
        "NAD83(CORS96) / Oregon Bend-Redmond-Prineville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=80000 +y_0=130000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Redmond-Prineville ");
    add_srs_wkt (p, 1,
        "zone (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Contin");
    add_srs_wkt (p, 2,
        "uously_Operating_Reference_Station_1996\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"6783\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",44.6666666666667],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-121.25],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1.00012],PARAMETER[\"false_easting\",80000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",130000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"6792\"]]");
    p = add_epsg_def_ex (filter, first, last, 6793, "epsg", 6793,
        "NAD83(CORS96) / Oregon Bend-Redmond-Prineville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=79999.99999968 +y_0");
    add_proj4text (p, 2,
        "=130000.00001472 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Redmond-Prineville ");
    add_srs_wkt (p, 1,
        "zone (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Conti");
    add_srs_wkt (p, 2,
        "nuously_Operating_Reference_Station_1996\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"6783\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",44.6666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-121.25],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.00012],PARAMETER[\"false_easting\",262467.1916");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",426509.1864],UNIT[\"foot\"");
    add_srs_wkt (p, 12,
        ",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6793\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6794, "epsg", 6794,
        "NAD83(2011) / Oregon Bend-Redmond-Prineville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=80000 +y_0=130000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Redmond-Prineville zo");
    add_srs_wkt (p, 1,
        "ne (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",44.6666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-121.25],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "0012],PARAMETER[\"false_easting\",80000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",130000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"6794\"]]");
    p = add_epsg_def_ex (filter, first, last, 6795, "epsg", 6795,
        "NAD83(2011) / Oregon Bend-Redmond-Prineville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=79999.99999968 +y_0");
    add_proj4text (p, 2,
        "=130000.00001472 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Redmond-Prineville zo");
    add_srs_wkt (p, 1,
        "ne (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",44.6666666666667],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-121.25],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 10,
        "0012],PARAMETER[\"false_easting\",262467.1916],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",426509.1864],UNIT[\"foot\",0.3048,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6795\"]]");
    p = add_epsg_def_ex (filter, first, last, 6796, "epsg", 6796,
        "NAD83(CORS96) / Oregon Bend-Burns zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=120000 +y_0=60000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Burns zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operat");
    add_srs_wkt (p, 2,
        "ing_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-119.75],PARAMETER[\"scale_factor\",1.0002");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",120000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",60000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6796\"]]");
    p = add_epsg_def_ex (filter, first, last, 6797, "epsg", 6797,
        "NAD83(CORS96) / Oregon Bend-Burns zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=119999.99999952 +y_0");
    add_proj4text (p, 2,
        "=59999.99999976 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Burns zone (ft)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Opera");
    add_srs_wkt (p, 2,
        "ting_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6783\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",43.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-119.75],PARAMETER[\"scale_factor\",1.0002");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",393700.7874],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",196850.3937],UNIT[\"foot\",0.3048,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6797\"]]");
    p = add_epsg_def_ex (filter, first, last, 6798, "epsg", 6798,
        "NAD83(2011) / Oregon Bend-Burns zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=120000 +y_0=60000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Burns zone (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",43.6666666666667],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-119.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",120000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "60000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"6798\"]]");
    p = add_epsg_def_ex (filter, first, last, 6799, "epsg", 6799,
        "NAD83(2011) / Oregon Bend-Burns zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=119999.99999952 +y_0");
    add_proj4text (p, 2,
        "=59999.99999976 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Burns zone (ft)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_origin\",43.6666666666667],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-119.75],PARAMETER[\"scale_factor\",1.0002],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",393700.7874],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",196850.3937],UNIT[\"foot\",0.3048,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"6799\"]]");
    p = add_epsg_def_ex (filter, first, last, 6800, "epsg", 6800,
        "NAD83(CORS96) / Oregon Canyonville-Grants Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Canyonville-Grants Pass ");
    add_srs_wkt (p, 1,
        "zone (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Contin");
    add_srs_wkt (p, 2,
        "uously_Operating_Reference_Station_1996\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",42.5],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-123.333333333333],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "007],PARAMETER[\"false_easting\",40000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6800\"]]");
    p = add_epsg_def_ex (filter, first, last, 6801, "epsg", 6801,
        "NAD83(CORS96) / Oregon Canyonville-Grants Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Canyonville-Grants Pass ");
    add_srs_wkt (p, 1,
        "zone (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Conti");
    add_srs_wkt (p, 2,
        "nuously_Operating_Reference_Station_1996\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",42.5],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-123.333333333333],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".00007],PARAMETER[\"false_easting\",131233.5958],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"6801\"]]");
    p = add_epsg_def_ex (filter, first, last, 6802, "epsg", 6802,
        "NAD83(2011) / Oregon Canyonville-Grants Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Canyonville-Grants Pass zo");
    add_srs_wkt (p, 1,
        "ne (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",42.5],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 9,
        "3.333333333333],PARAMETER[\"scale_factor\",1.00007],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",40000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"6802\"]]");
    p = add_epsg_def_ex (filter, first, last, 6803, "epsg", 6803,
        "NAD83(2011) / Oregon Canyonville-Grants Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Canyonville-Grants Pass zo");
    add_srs_wkt (p, 1,
        "ne (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",42.5],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 9,
        "3.333333333333],PARAMETER[\"scale_factor\",1.00007],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",131233.5958],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "002\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"6803\"]]");
    p = add_epsg_def_ex (filter, first, last, 6804, "epsg", 6804,
        "NAD83(CORS96) / Oregon Columbia River East zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000 +y_0=30000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River East zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "6783\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",45.6666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-120.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000008],PARAMETER[\"false_easting\",150000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",30000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6804\"]]");
    p = add_epsg_def_ex (filter, first, last, 6805, "epsg", 6805,
        "NAD83(CORS96) / Oregon Columbia River East zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000.00001464 +y_");
    add_proj4text (p, 2,
        "0=30000.00001512 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River East zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"6783\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"latitude_of_origin\",45.6666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-120.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.000008],PARAMETER[\"false_easting\",492125.9843],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",98425.1969],UNIT[\"foot\",0.");
    add_srs_wkt (p, 12,
        "3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6805\"]]");
    p = add_epsg_def_ex (filter, first, last, 6806, "epsg", 6806,
        "NAD83(2011) / Oregon Columbia River East zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000 +y_0=30000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River East zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",45.6666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-120.5],PARAMETER[\"scale_factor\",1.000008]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",150000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",30000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"6806\"]]");
    p = add_epsg_def_ex (filter, first, last, 6807, "epsg", 6807,
        "NAD83(2011) / Oregon Columbia River East zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000.00001464 +y_");
    add_proj4text (p, 2,
        "0=30000.00001512 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River East zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",45.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-120.5],PARAMETER[\"scale_factor\",1.00000");
    add_srs_wkt (p, 10,
        "8],PARAMETER[\"false_easting\",492125.9843],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",98425.1969],UNIT[\"foot\",0.3048,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6807\"]]");
    p = add_epsg_def_ex (filter, first, last, 6808, "epsg", 6808,
        "NAD83(CORS96) / Oregon Columbia River West zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000 +y_0=-3000000 +no_uoff +gamma=295 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River West zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "6783\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"latitude_of_center\",45.9166666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "longitude_of_center\",-123],PARAMETER[\"azimuth\",295],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"rectified_grid_angle\",295],PARAMETER[\"scale");
    add_srs_wkt (p, 11,
        "_factor\",1],PARAMETER[\"false_easting\",7000000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",-3000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6808\"]]");
    p = add_epsg_def_ex (filter, first, last, 6809, "epsg", 6809,
        "NAD83(CORS96) / Oregon Columbia River West zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000.00000248 +y_0=-2999999.999988 +no_u");
    add_proj4text (p, 2,
        "off +gamma=295 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River West zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"6783\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_center\",45.9166666666667],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"longitude_of_center\",-123],PARAMETER[\"azimuth\",295]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"rectified_grid_angle\",295],PARAMETER[\"sca");
    add_srs_wkt (p, 11,
        "le_factor\",1],PARAMETER[\"false_easting\",22965879.2651");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",-9842519.685],UNIT[\"foot");
    add_srs_wkt (p, 13,
        "\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"680");
    add_srs_wkt (p, 15,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 6810, "epsg", 6810,
        "NAD83(2011) / Oregon Columbia River West zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000 +y_0=-3000000 +no_uoff +gamma=295 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River West zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_center\",45.9166666666667],PARAMETER[\"longitude_o");
    add_srs_wkt (p, 9,
        "f_center\",-123],PARAMETER[\"azimuth\",295],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "rectified_grid_angle\",295],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",7000000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",-3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"6810\"]]");
    p = add_epsg_def_ex (filter, first, last, 6811, "epsg", 6811,
        "NAD83(2011) / Oregon Columbia River West zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000.00000248 +y_0=-2999999.999988 +no_u");
    add_proj4text (p, 2,
        "off +gamma=295 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River West zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"lati");
    add_srs_wkt (p, 8,
        "tude_of_center\",45.9166666666667],PARAMETER[\"longitude");
    add_srs_wkt (p, 9,
        "_of_center\",-123],PARAMETER[\"azimuth\",295],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"rectified_grid_angle\",295],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",22965879.2651],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",-9842519.685],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6811\"]]");
    p = add_epsg_def_ex (filter, first, last, 6812, "epsg", 6812,
        "NAD83(CORS96) / Oregon Cottage Grove-Canyonville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Cottage Grove-Canyonvill");
    add_srs_wkt (p, 1,
        "e zone (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Cont");
    add_srs_wkt (p, 2,
        "inuously_Operating_Reference_Station_1996\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",42.8333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-123.333333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000023],PARAMETER[\"false_easting\",50000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"6812\"]]");
    p = add_epsg_def_ex (filter, first, last, 6813, "epsg", 6813,
        "NAD83(CORS96) / Oregon Cottage Grove-Canyonville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000.00001504 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Cottage Grove-Canyonvill");
    add_srs_wkt (p, 1,
        "e zone (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Con");
    add_srs_wkt (p, 2,
        "tinuously_Operating_Reference_Station_1996\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"6783\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",42.8333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-123.333333333333],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000023],PARAMETER[\"false_easting\",164041");
    add_srs_wkt (p, 11,
        ".9948],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3");
    add_srs_wkt (p, 12,
        "048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6813\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

