# Call for testing Silkaj v0.11.0rc0

Hey fellow testers and early-adopters!

We are pleased to announce Silkaj v0.11.0 release candidate, and we would be happy to receive feedback before releasing it as stable.

It is planned to be the latest release with Duniter v1/BMA support and the release to enter Debian 12 Bookworm.

## Pre-release installation

You can install this pre-release version from PyPI or from a Docker image.
To install the Python package, run following command:

Install `pipx` from the [pipx installation documentation](doc/install_pipx.md):

```bash
sudo apt install pipx
pipx install --pip-args "\--pre" silkaj
```

To [install and run Silkaj from the Docker image](doc/docker.md):

```bash
sudo docker pull registry.duniter.org/clients/python/silkaj/release/pip:v0.11.0rc0
```

Run Silkaj from outside the image:

```bash
sudo docker run -it registry.duniter.org/clients/python/silkaj/release/pip:v0.11.0rc0 silkaj
```

## Tests

Please check [v0.11.0 milestone short summary](https://git.duniter.org/clients/python/silkaj/-/milestones/15) as well as the [changelog](CHANGELOG.md) containing the changes which did happen during this development cycle.

Structural changes were made, so please check Silkaj is still working in its entirety.
Manual tests help us making sure everything works fine in different cases.
Make sure you test it on Ğ1-Test network to avoid a revocation or any money loss to happen.

## Pipx installation

Test that the newly introduced [`pipx` method installation documentation](doc/install_pipx.md) works fine in your case, with your particular Unix system.
Tell us how can the documentation be improved, if a non-obvious step for you is missing or if a necessary package isn't listed for Silkaj to work on your system.

## New CLI design

Silkaj commands have been reorganized into following groups: `blockchain`, `money`, `wot`.
Some commands not related to these contexts have been kept in the top-level group.
Tell us if the new CLI design with sub-sub-commands compared to the previous one with all the commands at the top-level instead fits best, is less convenient, is following a more structured logic.

```bash
Commands:
  about           Display program information
  authentication  Generate authentication file
  blockchain      Blockchain related commands
  checksum        Generate checksum out of a passed pubkey or an...
  license         Display Ğ1 monetary license
  money           Money management related commands
  wot             Web-of-Trust related commands
```

## Table generation

The underlying table generation library has been changed.
Tell us if the tables are displaying content correctly, or if any improvement can be done, or if a regression got introduced.

### Others

Feel free to play and look for hidden bugs and/or UI/UX improvements!
We are looking forward for your feedback!

______________________________________________________________________

The stable release is planned on November 26th 2022, which will be released with a detailed announcement explaining the changes.

Silkaj team
