/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFStk -- Attribute Filesystem Toolkit Library
 *
 * atfstk.h -- definitions for the AtFS toolkit library
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: atfstk.h[7.0] Tue Jun 29 16:16:10 1993 andy@cs.tu-berlin.de frozen $
 */

#ifndef _ATFSTKHDR_
#define _ATFSTKHDR_

#ifdef __STDC__
#define A(alist) alist
#else
#define A(alist) ()
#endif

/*=====================================
 * exported Functions and Macros
 *=====================================*/

extern int  atErrno, atExpand;
extern char *atErrMsg;

/*** atfstk_lib.c ***/
void	atError		A((int code, char *msg));

/*** attrs.c ***/
char*	atFileClassExt	A((Af_key *aso));
int	atScanStatus	A((char *statusStr));
char*	atWriteStatus	A((Af_key *aso, int verbose));
int	atIsDerived	A((Af_key *aso));
char*	atWriteMode	A((Af_key *aso));
char*	atWriteDate	A((Af_key *aso, char *dateAttr));
char*	atWriteName	A((Af_key *aso, char *path));

/*** version.c ***/
int	atVno		A((Af_key *aso));
#define atGen(x) (((x) >> 16) & 0x0000FFFF)
#define	atRev(x) ((x) & 0x0000FFFF)
int	atSetVersAlias	A((Af_key *aso, char *alias));
int	atDelVersAlias	A((Af_key *aso, char *alias));

/*** user.c ***/
int	atUserValid	A((Af_user *user));
void    atScanUser	A((char *userName, Af_user *resultUser));
char*	atUserName	A((Af_user *user));
uid_t	atUserUid	A((Af_user *user));

/*** uda.c ***/
struct atAttrTab {
  int  code;
  char *name;
  char *atfsName;
};
extern struct atAttrTab atStdAttrTab[];
char*	atRetAttr	A((Af_key *aso, char *attrName));
/* mode: AF_ADD, AF_DELETE, AF_REPLACE */
int	atSetAttr	A((Af_key *aso, char *attr, int mode));
int	atSetAttrFile	A((Af_key *aso, char *fileName));
char*	atAttrName	A((char *attr));
char*	atAttrValue	A((char *attr));
int	atMatchAttr	A((Af_key *aso, char *attr));
void	atFreeAttr	A((char *attrValue));

/*** citeattr.c */
#define AT_EXPAND_STRING 0
#define AT_EXPAND_FILE   1
int	atExpandAttrs	A((Af_key *aso, char *buf, size_t bufSize, void *dest, size_t destSize, int mode));

/*** read.c ***/
int	atOpenExpand	A((char *version, int expand_busy)) ;
void	atCloseExpand	A((int desc)) ;
int	atReadExpand	A((int desc, char *bufp, int size)) ;
char	*atGetWriteName	A((int desc)) ;

/*** network.c ***/
char*	atNetworkPath	A((Af_key *aso));
char*	atLocalPath	A((char *networkPath));

/*** lock.c ***/
#define AT_COMMENT_INTENT 1	/* comment type */
#define AT_COMMENT_DESCR  2	/* comment type */
#define AT_COMMENT_LOG    3	/* comment type */
#define AT_FROMSTDIN	01	/* mode */
#define AT_REUSE	02	/* mode */
#define AT_CONFIRM	04	/* mode */
int	atSetComment	A((Af_key *aso, int commentType, char *commentText, int mode));
int	atUnlock	A((Af_key *aso));

/*** cache.c ***/
char*	atCacheKey	A((Af_key *aso));
int	atSaveCache	A((Af_key *aso, Af_key *cachedAso, char *uniqAttr, int storeType));

/*** bind.c ***/
int	atScanBinding	A((char *binding, char **resultStr, int *resultGen, int *resultRev, time_t *resultDate));
int	atBindOptions	A((int argc, char **argv, int *newArgc, char *(*newArgv[])));
extern int atBindModeOption;
int	atBindSetArgv	A((int *argc, char *(*argv[])));
void	atBindUsage	A((char *extraText));
Af_key*	atBindVersion	A((char *name, char *binding));
Af_set*	atBindSet	A((char *pattern, char *binding, int bindMode));
Af_set*	atBindCache	A((char *pattern, char *binding));

int	atBindShowRules	A((void));
char**	atBindListRules	A((void));
int	atBindAddRule	A((char *name, char *body, char *source, int srcLine));
int	atBindTestRule	A((char *name));
int	atBindDelRule	A((char *name));
int	atBindRuleFile	A((char *filename));

extern char *(*atBindExpandMacro)();
extern int  atBindDisplayErrors;
extern int  atBindTrace;
extern int  atBindNoMsg;

extern int  atBindError;
extern char atBindErrorMsg[];

/*** atfstk_version.c ***/
char*	atVersion	();

/*==============
 * constants
 *==============*/

/*** bind modes (for atBindSet) ***/
#define AT_BIND_UNIQUE	1
#define AT_BIND_SET	2
#define AT_BIND_LAST	3
#define AT_BIND_LASTSAVED 4

/*** bind types (returned by atScanBinding) ***/
#define AT_BIND_DEFAULT	 1
#define AT_BIND_VNUM	 2
#define AT_BIND_RULE	 3
#define AT_BIND_ALIAS	 4
#define AT_BIND_DATE	 5
#define AT_BIND_CACHEKEY 6

#define AT_OK		0
#define AT_ERROR	1
#define AT_WARNING	2
#define AT_MSG		3
#define AT_NOSHELL	127

#define AT_ATTALIAS	"__SymbolicName__"
#define AT_ATTCLEAD	"__Clead__"
#define AT_ATTINTENT	"__Intent__"
#define AT_ATTLOG	"__Log__"
#define AT_ATTDESCR	"__Description__"
#define AT_ATTCACHEKEY	"__CacheKey__"

#define AT_STARTINTENT	" Intention for change:\n"
#define AT_EMPTYINTENT	"--- no intent expressed ---"
#define AT_STARTLOG	" Change log:\n"
#define AT_EMPTYLOG	"--- empty log message ---"
#define AT_STARTDESCR	" Module description:\n"
#define AT_EMPTYDESCR	"--- empty description ---"

#define AT_MAXATTRSIZE	10240
#define AT_MAXALIASLEN	1024
#define AT_CLEADMAXLEN	32
#define AT_CACHEKEYLEN	64

#define AT_DEFAULT_EDITOR "vi"

/*** codes for predefined attributes ***/
#define AT_CODE_DESCRIPTION	0
#define AT_CODE_HEADER		1
#define AT_CODE_INTENT		2
#define AT_CODE_LOG		3
#define AT_CODE_ALIAS		4
#define AT_CODE_ATIME		5
#define AT_CODE_AUTHOR		6
#define AT_CODE_CACHEKEY	7
#define AT_CODE_CLEAD		8
#define AT_CODE_CTIME		9
#define AT_CODE_DSIZE		10
#define AT_CODE_GENERATION	11
#define AT_CODE_HOST		12
#define AT_CODE_LOCK		13
#define AT_CODE_LTIME		14
#define AT_CODE_MODE		15
#define AT_CODE_MTIME		16
#define AT_CODE_NAME		17
#define AT_CODE_NOTE		18
#define AT_CODE_OWNER		19
#define AT_CODE_PRED		20
#define AT_CODE_REVISION	21
#define AT_CODE_RTIME		22
#define AT_CODE_SELF		23
#define AT_CODE_SELFPATH	24
#define AT_CODE_SIZE		25
#define AT_CODE_STATE		26
#define AT_CODE_STIME		27
#define AT_CODE_SUCC		28
#define AT_CODE_SYSPATH		29
#define AT_CODE_TYPE		30
#define AT_CODE_UNIXNAME	31
#define AT_CODE_UNIXPATH	32
#define AT_CODE_VERSION		33
#define AT_CODE_VTIME		34
#define AT_CODE_XPOFF		35
#define AT_CODE_XPON		36

#endif /* _ATFSTKHDR_ */
