"""
This is a setup.py script partly generated by py2applet

Usage:
    python setup.py py2app


NOTES:
   12/01/2011: When seeing an error related to pytz.zoneinfo not being found,
               change the following line in py2app/recipes/matplotlib.py
               mf.import_hook('pytz.tzinfo', m, ['UTC'])
   12/05/2011: Needs macholib >= 1.4.3 and py2app >= 0.6.4 to create a 64-bit app
"""
from __future__ import print_function

import os
import sys
import string

from distutils.util import get_platform
from distutils.filelist import findall
from distutils.sysconfig import get_python_lib

from setuptools import setup

# Need the installer dir on the python path to find helper modules
installer_dir = os.path.abspath(os.path.dirname(__file__))
if installer_dir != os.path.abspath(os.getcwd()):
    raise RuntimeError("Must run setup_exe from the installers directory")
sys.path.append(installer_dir)

# put the build directory at the front of the path
root = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
platform = '%s-%s'%(get_platform(), sys.version[:3])
doc_path = os.path.join(root, 'build', 'lib.'+platform, 'doc')
build_path = os.path.join(root, 'sasview-install', 'lib', 'python2.7', 'site-packages')
#sys.path.insert(0, build_path)

#Extending recursion limit
sys.setrecursionlimit(10000)

if len(sys.argv) == 1:
    sys.argv.append('py2app')

import macholib_patch

from sas import get_local_config
local_config = get_local_config()

ICON = local_config.SetupIconFile_mac
data_files = []

# Include data for supporting packages
import periodictable
data_files += periodictable.data_files()

import sasmodels
data_files += sasmodels.data_files()

# Data files for the different perspectives
from sas.sasgui.perspectives import fitting
data_files += fitting.data_files()

from sas.sasgui.perspectives import calculator
data_files += calculator.data_files()

from sas.sasgui.perspectives import invariant
data_files += invariant.data_files()

from sas.sasgui import guiframe
data_files += guiframe.data_files()

# Copy the config files
sasview_path = os.path.join('..', 'src', 'sas', 'sasview')
data_files.append(('.', [os.path.join(sasview_path, 'custom_config.py')]))
data_files.append(('config', [os.path.join(sasview_path, 'custom_config.py')]))
data_files.append(('.', [os.path.join(sasview_path, 'local_config.py')]))

# Copy the logging config
sas_path = os.path.join('..', 'src', 'sas')
data_files.append(('.', [os.path.join(sas_path, 'logging.ini')]))

if os.path.isfile("BUILD_NUMBER"):
    data_files.append(('.', ["BUILD_NUMBER"]))

# Copying the images directory to the distribution directory.
data_files.append(("images", findall(local_config.icon_path)))

# Copying the HTML help docs
data_files.append(("media", findall(local_config.media_path)))

# Copying the sample data user data
test_dir = local_config.test_path
for dirpath, dirnames, filenames in os.walk(test_dir):
    target_dir = os.path.join("test", os.path.relpath(dirpath, test_dir))
    source_files = [os.path.join(dirpath, f) for f in filenames]
    data_files.append((target_dir, source_files))

# See if the documentation has been built, and if so include it.
if os.path.exists(doc_path):
    for dirpath, dirnames, filenames in os.walk(doc_path):
        target_dir = os.path.join("doc", os.path.relpath(dirpath, doc_path))
        source_files = [os.path.join(dirpath, f) for f in filenames]
        data_files.append((target_dir, source_files))
else:
    raise Exception("You must first build the documentation before creating an installer.")

# Copying opencl include files
opencl_source = os.path.join(get_python_lib(), "pyopencl", "cl")
opencl_target = os.path.join("includes", "pyopencl")
data_files.append((opencl_target, findall(opencl_source)))

# Locate libxml2 library
lib_locs = ['/usr/local/lib', '/usr/lib']
libxml_path = None
for item in lib_locs:
    libxml_path_test = '%s/libxml2.2.dylib' % item
    if os.path.isfile(libxml_path_test):
        libxml_path = libxml_path_test
if libxml_path is None:
    raise RuntimeError("Could not find libxml2 on the system")

# locate file extensions
def find_extension():
    """
    Describe the extensions that can be read by the current application
    """
    try:
        extensions = []
        EXCEPTION_LIST = ['*', '.', '']
        from sas.sascalc.dataloader.loader import Loader
        wild_cards = Loader().get_wildcards()
        for item in wild_cards:
            #['All (*.*)|*.*']
            file_type, ext = string.split(item, "|*.", 1)
            if ext.strip() not in EXCEPTION_LIST and ext.strip() not in extensions:
                extensions.append(ext)
    except Exception:
        pass
    try:
        file_type, ext = string.split(local_config.APPLICATION_WLIST, "|*.", 1)
        if ext.strip() not in EXCEPTION_LIST and ext.strip() not in extensions:
            extensions.append(ext)
    except Exception:
        pass
    try:
        for item in local_config.PLUGINS_WLIST:
            file_type, ext = string.split(item, "|*.", 1)
            if ext.strip() not in EXCEPTION_LIST and ext.strip() not in extensions:
                extensions.append(ext)
    except Exception:
        pass

    return extensions

EXTENSIONS_LIST = find_extension()

plist = dict(CFBundleDocumentTypes=[dict(CFBundleTypeExtensions=EXTENSIONS_LIST,
                                         CFBundleTypeIconFile=ICON,
                                         CFBundleTypeName="sasview file",
                                         CFBundleTypeRole="Shell")],)

#Get version - NB nasty hack. Need to find correct way to give path to installed sasview (AJJ)
#h5py has been added to packages. It requires hdf5 to be installed separetly
#

from sas.sasview import __version__ as VERSION
APPNAME = "SasView "+VERSION
DMGNAME = "SasView-"+VERSION+"-MacOSX"
APP = ['sasview_gui.py']

EXCLUDES = ['PyQt4', 'sip', 'QtGui']

OPTIONS = {'argv_emulation': True,
           'packages': ['lxml', 'numpy', 'scipy', 'pytz', 'encodings',
                        'encodings', 'matplotlib', 'periodictable',
                        'reportlab', 'sasmodels', 'pyopencl', 'h5py',
                       ],
           'iconfile': ICON,
           'frameworks': [libxml_path],
           'plist': plist,
           'excludes' : EXCLUDES,
          }

#import pprint; pprint.pprint(data_files); sys.exit()
setup(
    name=APPNAME,
    app=APP,
    data_files=data_files,
    include_package_data=True,
    options={'py2app': OPTIONS},
    setup_requires=['py2app'],
)

#Build dmg
DMG = "dist/%s.dmg"%DMGNAME
if os.path.exists(DMG):
    os.unlink(DMG)
os.system('cd dist && ../../build_tools/dmgpack.sh "%s" "%s.app"'%(DMGNAME, APPNAME))
os.system('chmod a+r "%s"'%DMG)
