---
title: linescroll
section: 1
header: User Manual
footer: linescroll 0.2.0
author: Ed Neville (ed-linescroll@s5h.net)
date: 04 September 2023
---

# NAME

linescroll - a tool to monitor log files

# SYNOPSIS

linescroll [OPTION] [FILE]...

# DESCRIPTION

shows line flow rate in **file(s)** or **stdin**.

**-c**/**--combine** all input sources into a single source

**-l**/**--limit** **ITERATIONS** exit after **ITERATIONS** cycles

**-s**/**--speedonly** don't print graphs

**-p**/**--print** **ITERATIONS** print only every **ITERATIONS**'th stats

**-f**/**--filename** print filename headings

**-a**/**--noaxislimit** do not print the axis limits

**-n**/**--noclear** do not clear the screen between prints

**-r**/**--raw** treat input lines as values to add to counter

**-h**/**--help** print help

# USAGE

linescroll can be used to show how much activity happens in log files or program output.

Bash can be used in conjunction to capture several programs as arguments for linescroll.

**stdin** can be used as a pipe if no other files are given as arguments, or if the special filename **-** is used.

# EXAMPLE

Show relative difference of (un-)cached traffic:

```
linescroll \
    <( varnishncsa -F '"%{Varnish:hitmiss}x"' | grep    '"hit"$' ) \
    <( varnishncsa -F '"%{Varnish:hitmiss}x"' | grep -v '"hit"$' )
```

Or just rate of traffic through the cache via stdin:

```
varnishncsa -F '%h %l %u %t "%r" %s %b "%{Referer}i" "%{User-agent}i" "%{Varnish:hitmiss}x"' | linescroll
```

Build a graph of stats for email:

```
( printf "From: cache@darkstar\nTo: super@webmasters\nSubject: cache effectiveness snapshot\n\n";
linescroll --limit 60 --print 60 \
    <( varnishncsa -F '"%{Varnish:hitmiss}x"' | grep    '"hit"$' ) \
    <( varnishncsa -F '"%{Varnish:hitmiss}x"' | grep -v '"hit"$' )
) | /usr/sbin/sendmail -fcache super@webmasters
```

# OPTIONS

```
    -c, --combine       combine all file source metrics
    -l, --limit ITERATIONS
                        stop after number of iterations (default never)
    -s, --speedonly     no graph, speed only
    -p, --print ITERATIONS
                        print only every Nth iteration
    -f, --filename      print filename headings
    -h, --help          print usage help
    -n, --noclear       do not clear screen between draws
        --nofollow      do not follow file renames
    -v, --version       display version number
    -r, --raw           input is metric

```

