---
layout: post
title:  Rotary engine
date:   2016-11-22 19:16:49 +0100
categories: wikipedia
---

_From Wikipedia, the free encyclopedia_

The rotary engine was an early type of internal-combustion engine, usually designed with an odd number of cylinders per row in a radial configuration, in which the crankshaft remained stationary in operation, with the entire crankcase and its attached cylinders rotating around it as a unit. Its main application was in aviation, although it also saw use before its primary aviation role, in a few early motorcycles and automobiles.

This type of engine was widely used as an alternative to conventional inline engines (straight or V) during World War I and the years immediately preceding that conflict. It has been described as "a very efficient solution to the problems of power output, weight, and reliability".[1]

By the early 1920s, however, the inherent limitations of this type of engine had rendered it obsolete, with the power output increasingly going into overcoming the air-resistance of the spinning engine itself. The rotating mass of the engine also caused significant gyroscopic precession: depending on the type of aircraft, this produced stability and control problems, especially for inexperienced pilots. Another factor in the demise of the rotary was the fundamentally inefficient total-loss oiling system, caused by the need to aspirate the fuel/air mixture through the hollow crankshaft and crankcase along with the lubricating medium, as in a two-stroke engine.

## Description
A rotary engine is essentially a standard Otto cycle engine, but instead of having a fixed cylinder block with rotating crankshaft as with a conventional radial engine, the crankshaft remains stationary and the entire cylinder block rotates around it. In the most common form, the crankshaft was fixed solidly to the airframe, and the propeller was simply bolted to the front of the crankcase.

Three key factors contributed to the rotary engine's success at the time:[2]

* Smooth running: Rotaries delivered power very smoothly because (relative to the engine mounting point) there are no reciprocating parts, and the relatively large rotating mass of the crankcase/cylinders (as a unit) acted as a flywheel.
* Improved cooling: when the engine was running the rotating crankcase/cylinder assembly created its own fast-moving cooling airflow, even with the aircraft at rest.
* Weight advantage: many conventional engines had to have heavy flywheels added to smooth out power impulses and reduce vibration. Rotary engines gained a substantial power-to-weight ratio advantage by having no need for an added flywheel. They shared with other radial configuration engines the advantage of a small, flat crankcase, and because of their efficient air-cooling system cylinders could be made with thinner walls and shallower cooling fins, which further reduced their weight.

Most rotary engines were arranged with the cylinders pointing outwards from a single crankshaft, in the same general form as a radial, but there were also rotary boxer engines[3] and even one-cylinder rotaries.

Like radial engines, rotaries were generally built with an odd number of cylinders (usually either 7 or 9), so that a consistent every-other-piston firing order could be maintained, to provide smooth running. Rotary engines with an even number of cylinders were mostly of the "two row" type.