/*
 * Copyright (c) 2021
 * NDE Netzdesign und -entwicklung AG, Hamburg, Germany
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program (see the file LICENSE.txt for more
 * details); if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package org.acplt.oncrpc.apps.jrpcgen;

/**
 * An item represents a part of an RPC/XDR specification. Characteristic
 * to an item is an identifier. For example a constant, an enumeration, an enumeration
 * element as well as a structure and a union are items. Within the context of
 * an RPC/XDR specification no two items within the same scope share the same
 * identifier.
 * 
 * @author Harald Wirths {@literal <hwirths@nde.ag>}
 *
 */
public interface JrpcgenItem {

	/**
	 * Delivers the identifier of this item. This value must not be {@code null}.
	 * 
	 * @return The idnetifier of this item.
	 */
	String getIdentifier();
	
}
