% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcloud.R
\name{pcloud}
\alias{pcloud}
\alias{pcloud_crypto}
\title{Create the path to a file in the p-Cloud drive}
\usage{
pcloud(...)

pcloud_crypto(...)
}
\arguments{
\item{...}{The folder, subfolder and file to form the path, starting to the
root of the p-Cloud drive, or the \verb{Crypto Folder}.}
}
\value{
A character string with the absolute path to the file or folder.
}
\description{
Similar to \code{\link[=file.path]{file.path()}} but creates a path to a file located
somewhere in a p-Cloud drive. \href{https://www.pcloud.com/eu.html}{p-Cloud} is a
cloud storage system that comes with an application for Windows, MacOS or
Linux. It creates a virtual drive on the PC where files can be managed as if
they were local. However, the path to these files differ between OSes. This
function abstracts out the first part of the path for you. So, you just have
to provide the folders and files and it constructs a valid absolute path, no
matter which OS you are using. The \code{\link[=pcloud_crypto]{pcloud_crypto()}} function does the same
for the special \verb{Crypo Folder} that p-Cloud creates if you subscribe to the
encryption option.
}
\examples{
\dontrun{
pcloud("subfolder", "file.txt")
# Only valid with the encryption option and the Crypto Folder is unlocked
pcloud_crypto("subfolder1", "subfolder2", "crypted_file.txt")
}
}
\seealso{
\code{\link[=system_file]{system_file()}}, \code{\link[=source_clipboard]{source_clipboard()}}, \code{\link[=file.path]{file.path()}}
}
\concept{file path}
\keyword{utilities}
