% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{igraph-vs-attributes}
\alias{igraph-vs-attributes}
\alias{[[<-.igraph.vs}
\alias{[<-.igraph.vs}
\alias{$.igraph.vs}
\alias{$<-.igraph.vs}
\alias{V<-}
\title{Query or set attributes of the vertices in a vertex sequence}
\usage{
\method{[[}{igraph.vs}(x, i) <- value

\method{[}{igraph.vs}(x, i) <- value

\method{$}{igraph.vs}(x, name)

\method{$}{igraph.vs}(x, name) <- value

V(x) <- value
}
\arguments{
\item{x}{A vertex sequence. For \verb{V<-} it is a graph.}

\item{i}{Index.}

\item{value}{New value of the attribute, for the vertices in the
vertex sequence.}

\item{name}{Name of the vertex attribute to query or set.}
}
\value{
A vector or list, containing the values of
attribute \code{name} for the vertices in the vertex sequence.
For numeric, character or logical attributes, it is a vector of the
appropriate type, otherwise it is a list.
}
\description{
The \code{$} operator is a syntactic sugar to query and set the
attributes of the vertices in a vertex sequence.
}
\details{
The query form of \code{$} is a shortcut for
\code{\link[=vertex_attr]{vertex_attr()}}, e.g. \code{V(g)[idx]$attr} is equivalent
to \code{vertex_attr(g, attr, V(g)[idx])}.

The assignment form of \code{$} is a shortcut for
\code{\link[=set_vertex_attr]{set_vertex_attr()}}, e.g. \code{V(g)[idx]$attr <- value} is
equivalent to \code{g <- set_vertex_attr(g, attr, V(g)[idx], value)}.
}
\examples{
g <- make_(
  ring(10),
  with_vertex_(
    name = LETTERS[1:10],
    color = sample(1:2, 10, replace = TRUE)
  )
)
V(g)$name
V(g)$color
V(g)$frame.color <- V(g)$color

# color vertices of the largest component
largest_comp <- function(graph) {
  cl <- components(graph)
  V(graph)[which.max(cl$csize) == cl$membership]
}
g <- sample_(
  gnp(100, 2 / 100),
  with_vertex_(size = 3, label = ""),
  with_graph_(layout = layout_with_fr)
)
giant_v <- largest_comp(g)
V(g)$color <- "blue"
V(g)[giant_v]$color <- "orange"
plot(g)
}
\seealso{
Other vertex and edge sequences: 
\code{\link{E}()},
\code{\link{V}()},
\code{\link{as_ids}()},
\code{\link{igraph-es-attributes}},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-es-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{igraph-vs-indexing2}},
\code{\link{print.igraph.es}()},
\code{\link{print.igraph.vs}()}

Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
\concept{vertex and edge sequences}
