\name{plot.profile2d.evd}
\alias{plot.profile2d.evd}

\title{Plot Joint Profile Log-likelihoods}
\description{
  Displays an image plot of the joint profile log-likelihood
  from a model profiled with \code{\link{profile.evd}} and
  \code{\link{profile2d.evd}}.
}
\usage{
\method{plot}{profile2d.evd}(x, main = NULL,
    ci = c(0.5, 0.8, 0.9, 0.95, 0.975, 0.99, 0.995),
    col = heat.colors(8), intpts = 75, xaxs = "r", yaxs = "r", \dots)
}
\arguments{
  \item{x}{An object of class \code{"profile2d.evd"}.}
  \item{main}{Title of plot; a character string.}
  \item{ci}{A numeric vector whose length is one less than the
    length of \code{col}. The colours of the image plot,
    excluding the background colour, represent confidence sets
    with confidence coefficients \code{ci} (but see \bold{Warning}).}
  \item{col}{A list of colors such as that generated by
    \code{rainbow}, \code{heat.colors}, \code{topo.colors},
    \code{terrain.colors} or similar functions.}
  \item{intpts}{If the package \CRANpkg{interp} is available,
    interpolation is performed using \code{intpts} points
    for each parameter. The function is interpolated at
    \code{intpts^2} points in total.}
  \item{xaxs,yaxs}{Graphics parameters (see \code{\link{par}}).
    The default, \code{"r"}, overrides the default set by
    \code{image}.}
  \item{\dots}{Other parameters to be passed to \code{image}.}
}
\section{Warning}{
  The sets represented by different colours may not be
  confidence sets with confidence coefficients \code{ci}, because
  the usual asymptotic properties of maximum likelihood estimators
  may not hold.
  For the GEV model, the usual asymptotic properties hold when the
  shape parameter is greater than \eqn{-0.5} (Smith, 1985).
}
\references{
  Smith, R. L. (1985)
  Maximum likelihood estimation in a class of non-regular cases.
  \emph{Biometrika}, \bold{72}, 67--90.
}

\seealso{\code{\link{plot.profile.evd}}, \code{\link{profile.evd}},
  \code{\link{profile2d.evd}}}

\examples{
uvdata <- rgev(100, loc = 0.13, scale = 1.1, shape = 0.2)
M1 <- fgev(uvdata)
\dontrun{M1P <- profile(M1)}
\dontrun{M1JP <- profile2d(M1, M1P, which = c("scale", "shape"))}
\dontrun{plot(M1JP)}
}
\keyword{hplot}
