% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colTabulates,xgCMatrix-method}
\alias{colTabulates,xgCMatrix-method}
\alias{rowTabulates,xgCMatrix-method}
\title{Tabulates the values in a matrix-like object by row (column)}
\usage{
\S4method{colTabulates}{xgCMatrix}(x, rows = NULL, cols = NULL, values = NULL)

\S4method{rowTabulates}{xgCMatrix}(x, rows = NULL, cols = NULL, values = NULL)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{values}{the values to search for.}
}
\value{
a \code{\link{numeric}} \code{NxJ} (\code{KxJ})
\code{\link{matrix}}, where N (K) is the number of rows (columns) for
which the J values are calculated.
}
\description{
Tabulates the values in a matrix-like object by row (column).
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowTabulates}
/ \code{matrixStats::colTabulates}.
}
\examples{
mat <- matrix(rpois(15, lambda = 3), nrow = 5, ncol = 3)
  mat[2, 1] <- NA_integer_
  mat[3, 3] <- 0L
  mat[4, 1] <- 0L
  
  print(mat)
  
  rowTabulates(mat)
  colTabulates(mat)
  
  rowTabulates(mat, values = 0)
  colTabulates(mat, values = 0)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowTabulates}()} and
\code{matrixStats::\link[matrixStats:rowTabulates]{colTabulates}()} which
are used when the input is a \code{matrix} or \code{numeric} vector.
\item \code{base::\link{table}()}
}
}
