# CHANGELOG



## v3.3.0 (2023-12-14)

### Chore

* chore: migrate pytest.ini and setup.cfg to pyproject.toml ([`7b15d02`](https://github.com/Toilal/rebulk/commit/7b15d022b2656bf2095630901fea24bd1aafb91b))

* chore: add python 3.12 in classifiers ([`c17192c`](https://github.com/Toilal/rebulk/commit/c17192c9db4ffa7a394a1d127c46a4320635ca90))

### Ci

* ci: fix semantic release commit message ([`498ced1`](https://github.com/Toilal/rebulk/commit/498ced19ae0fae66817e99bf15978aa984a817d1))

* ci: fix semantic release after upgrade ([`af4c390`](https://github.com/Toilal/rebulk/commit/af4c390d5fabb9bd95319b28b07933f48d3b5e25))

* ci: remove verbose flag from semantic-release command ([`03d3f94`](https://github.com/Toilal/rebulk/commit/03d3f944c917d5eb38c0f3e72f39b8485f9fc16b))

### Feature

* feat(dependencies): add python 3.12 support ([`f6f8927`](https://github.com/Toilal/rebulk/commit/f6f892727e51b44e2ed14d2e2c47fe36c70b7920))


## v3.2.0 (2023-02-18)

### Chore

* chore(release): release v3.2.0

Automatically generated by python-semantic-release ([`ee938ca`](https://github.com/Toilal/rebulk/commit/ee938ca3c1ce9981a171f8f124271424d6774da9))

### Feature

* feat(dependencies): add python 3.11 support and drop python 3.6 support ([`e4cb0d8`](https://github.com/Toilal/rebulk/commit/e4cb0d854cd8ea80da9abe46d2b3405a873e2020))

### Fix

* fix: remove pytest-runner from setup_requires

Close #26 ([`4483d17`](https://github.com/Toilal/rebulk/commit/4483d1777f6a61d20ed83da760663aec67e22042))


## v3.1.0 (2021-11-04)

### Chore

* chore(release): release v3.1.0

Automatically generated by python-semantic-release ([`0377c73`](https://github.com/Toilal/rebulk/commit/0377c730022749bf9ad21e06f346c32590938432))

### Feature

* feat(defaults): add overrides support (#25)

Close #25 ([`f79e5ea`](https://github.com/Toilal/rebulk/commit/f79e5eab0806787ff19a4c668bf9f88413b67288))

* feat(python): add python 3.10 support, drop python 3.5 support ([`a5e6eb7`](https://github.com/Toilal/rebulk/commit/a5e6eb7bba979ee51e1c6c1e186bd224c989dfdc))


## v3.0.1 (2020-12-25)

### Chore

* chore(release): release v3.0.1

Automatically generated by python-semantic-release ([`9b9d9ea`](https://github.com/Toilal/rebulk/commit/9b9d9eaea68c5ef5609fa0c0f5cd14fb53fad528))

* chore(semantic-release): change release commit message for commitlint concistency ([`03d4dfd`](https://github.com/Toilal/rebulk/commit/03d4dfd26079d5e8a8eda24874565aeebdcf44a6))

### Ci

* ci(build): install regex only if matrix.regex is 1 ([`ab43183`](https://github.com/Toilal/rebulk/commit/ab43183708bb8bfa5819cb852e09130d1e048a69))

* ci(commitlint): add run condition for commitlint job ([`821eb4a`](https://github.com/Toilal/rebulk/commit/821eb4ae088e2109249d771fc13b9b937bbae605))

### Documentation

* docs(readme): add semantic release badge ([`78baca0`](https://github.com/Toilal/rebulk/commit/78baca0c529083d7f583ffec58aeb23734d67ce5))

* docs(readme): fix title ([`d5d4db5`](https://github.com/Toilal/rebulk/commit/d5d4db5cd7f6e2cb1308acd26bfb98838815fad4))

### Fix

* fix(package): fix broken package `No such file or directory: &#39;CHANGELOG.md&#39;` (#24)

Close #24 ([`33895ff`](https://github.com/Toilal/rebulk/commit/33895ff358ff5051768fb98d4e840691e7af9bdf))


## v3.0.0 (2020-12-23)

### Breaking

* feat(regex): replace REGEX_DISABLED environment variable with REBULK_REGEX_ENABLED

BREAKING CHANGE: regex module is now disabled by default, even if it&#39;s available
in the python interpreter. You have to set REBULK_REGEX_ENABLED=1 in your environment
to enable it, as this module may cause some issues. ([`d5a8cad`](https://github.com/Toilal/rebulk/commit/d5a8cad6281533ee549a46ca70e1a25e5777eda3))

* feat: add python 3.8/3.9 support, drop python 2.7/3.4 support

BREAKING CHANGE: Python 2.7 and 3.4 support have been dropped ([`048a15f`](https://github.com/Toilal/rebulk/commit/048a15f90833ba8d33ea84d56e9955d31b514dc3))

### Chore

* chore(release): Release v3.0.0

Automatically generated by python-semantic-release ([`a548c3a`](https://github.com/Toilal/rebulk/commit/a548c3a9cc105b842169d0c1f26c3ef80b4d03c9))

### Ci

* ci(commitlint): add commitlint to github actions ([`928557e`](https://github.com/Toilal/rebulk/commit/928557e5c80b7992bf0659a11e60b47a97083215))

### Unknown

* Merge pull request #22 from nagesh4193/master

Add Power Support ppc64le ([`d758077`](https://github.com/Toilal/rebulk/commit/d75807730f4701807e3ba2258b5998c751e0b427))

* Add Power Support ppc64le ([`8e28238`](https://github.com/Toilal/rebulk/commit/8e28238a581be36e8eb8707799eb204c3f9b86bf))

* Back to development: 2.0.2 ([`52b7759`](https://github.com/Toilal/rebulk/commit/52b7759330d10138d1c886f09fbc106f64bfe64d))

* Preparing release 2.0.1 ([`50fbb45`](https://github.com/Toilal/rebulk/commit/50fbb4542f287a5ea9cfc5060a447663782493fd))

* Drop python 3.4 support ([`3e615cd`](https://github.com/Toilal/rebulk/commit/3e615cdde398e9cf11055a90b14c9fa7107a75c3))

* Fix errors when regex module is available (thx @singron)

Close #20

Co-authored-by: singron &lt;eculperic@gmail.com&gt; ([`65e9ddf`](https://github.com/Toilal/rebulk/commit/65e9ddfb9d1a56c168bdc13defe1fe74333f482f))

* Cleanup chain matching code ([`6adb3ab`](https://github.com/Toilal/rebulk/commit/6adb3ab5ebdbcfe0c5c469095241a55084ed50fa))

* Back to development: 2.0.1 ([`eb0a783`](https://github.com/Toilal/rebulk/commit/eb0a783a03fe823c579e60394bb3362fe1ce6d1f))

* Preparing release 2.0.0 ([`a1fbdb3`](https://github.com/Toilal/rebulk/commit/a1fbdb33bb6b790a1700d29405d7c76dc4eda088))

* Add named method to Match class ([`5a6ab44`](https://github.com/Toilal/rebulk/commit/5a6ab44bdfa82e8649427474ac857d6714176c92))

* Add tagged method to Match class ([`fd937a2`](https://github.com/Toilal/rebulk/commit/fd937a2c8f2dfd201e0f45b07f62e82651f07a73))

* Back to development: 2.0.0 ([`23e55ca`](https://github.com/Toilal/rebulk/commit/23e55ca472771f96b6ab16616d09e7e7423fa75a))

* Preparing release 2.0.0b1 ([`f9e6c1e`](https://github.com/Toilal/rebulk/commit/f9e6c1ecf25e0723ce1df9884e2cee12838d52b4))

* Fix child name shadowing on Python 2 ([`9243267`](https://github.com/Toilal/rebulk/commit/9243267c9f6d5b8808784a3b1ceabfda8237d539))

* Add match processor parameters (pre/post) ([`8641083`](https://github.com/Toilal/rebulk/commit/8641083a3d3e38ad03e4b7324beec6e97874b7fb))

* Refactor match processing ([`f43b0f6`](https://github.com/Toilal/rebulk/commit/f43b0f6bdc56494f8a3648a3df8ee328803bf997))

* Fix pylint issues ([`98dac0e`](https://github.com/Toilal/rebulk/commit/98dac0e06251078f3d4d5d2f630fe8b2bac75dac))

* Remove useless check ([`54e8ecb`](https://github.com/Toilal/rebulk/commit/54e8ecb86d1515400271a4dd5173ff6fa46c1eb3))

* Internal refactoring of chain pattern matches ([`6c2fe34`](https://github.com/Toilal/rebulk/commit/6c2fe3447144f3c0400f9008f3a2ae5c96994f86))

* Internal refactoring to better understand Pattern matches generation logic ([`dc608ce`](https://github.com/Toilal/rebulk/commit/dc608ce7084a9fa834ac534e8a86cc4cb0627edb))

* Fix imports for python 2.7 ([`6e5182a`](https://github.com/Toilal/rebulk/commit/6e5182a633866423c077a72a40b4367e2f20cfc3))

* Enhance defaults feature ([`c6f442c`](https://github.com/Toilal/rebulk/commit/c6f442c47a68c7a1a95ae46ec2014e6c793bd52f))

* Fix child formatter being overriden by chain formatter ([`f439f42`](https://github.com/Toilal/rebulk/commit/f439f4268079cefd29f81105f8ad28e782c617e9))

* Add match_index property on match.children earlier ([`7ebb280`](https://github.com/Toilal/rebulk/commit/7ebb2806433f3debc4b6640cc1f23997d11c1aca))

* Extract common code from Rebulk/Chain into Builder

This brings more consistency between Chain pattern and other
patterns, and between Chain and Rebulk classes also.

BREAKING CHANGE: This change how chain **kwargs and .defaults() is
transmitted to chained patterns, so upgrades should be performed
with care.

Chain **kwargs are now only used inside chain pattern itself,
and doesn&#39;t implicitly set chain .defaults() anymore. You
may have to repeat some chain **kwargs to its own .defaults()
for Rebulk to behave as before, or set them accordingly to
chained patterns. ([`6b42d5d`](https://github.com/Toilal/rebulk/commit/6b42d5d0d417be36e817911641fcc3615b973166))

* Back to development: 1.0.2 ([`1aa3c5f`](https://github.com/Toilal/rebulk/commit/1aa3c5f50bd806706d818772c7922ebe7d1501ce))

* Preparing release 1.0.1 ([`2a99605`](https://github.com/Toilal/rebulk/commit/2a99605f28f095e10406bd281e3d820e616ee100))

* Add python 3.8-dev support and make debug tests asserts less strict

Close #16
Close #18
Close #19 ([`e9e8956`](https://github.com/Toilal/rebulk/commit/e9e8956a280a9e4b98413130a8c9c26523491806))

* Back to development: 1.0.1 ([`7511a46`](https://github.com/Toilal/rebulk/commit/7511a4671f2fd9493e3df1e5177b7656789069e8))

* Preparing release 1.0.0 ([`1a19491`](https://github.com/Toilal/rebulk/commit/1a19491e946600b265f87613254b6c69533ebae3))

* Add python 3.7 support
Drop python 2.6/3.3 support
Fix deprecation warnings

Close #11
Close #17 ([`dd831ef`](https://github.com/Toilal/rebulk/commit/dd831ef7cfa74c343038aa2d9a0e112891a6d4f1))

* Back to development: 0.9.1 ([`3590e3e`](https://github.com/Toilal/rebulk/commit/3590e3e8d3becafa9678e45991a687542ba72614))

* Preparing release 0.9.0 ([`70c8e7c`](https://github.com/Toilal/rebulk/commit/70c8e7ce4f473be17e8bb293c845820e02801055))

* Merge pull request #15 from Toilal/to_dict_refactoring

Refactor Matches to_dict() method for better API ([`8738849`](https://github.com/Toilal/rebulk/commit/873884973607db1ccc3cf583b01d735f6c2f545a))

* Refactor Matches to_dict() method for better API ([`4fbd124`](https://github.com/Toilal/rebulk/commit/4fbd12469ce0a4b0f0360bfdc84245953434a968))

* Fix pylint issues ([`375fcb4`](https://github.com/Toilal/rebulk/commit/375fcb4178c6fd780903be4c2128b7df2fcf8193))

* Add python 3.6 support ([`d11bfaa`](https://github.com/Toilal/rebulk/commit/d11bfaaa9eea97162f4c70a5b80424b0b4075fff))

* Back to development: 0.8.3 ([`b06b3ee`](https://github.com/Toilal/rebulk/commit/b06b3eed24263950444a5d76278440e75512f936))

* Preparing release 0.8.2 ([`f849102`](https://github.com/Toilal/rebulk/commit/f849102bc269add95d42cef09f427f77904709c9))

* Remove fake usage of kwargs, in favor of pylint local ignore ([`99ef49b`](https://github.com/Toilal/rebulk/commit/99ef49b2f6570aaa6deaf795afebd73a5fd81039))

* Merge pull request #8 from ratoaq2/feature/performance-improvements

Performance analysis and improvements ([`abb5d51`](https://github.com/Toilal/rebulk/commit/abb5d51174ee4639efdac32de055812be5d5bf19))

* Handle unused kwargs ([`f0f4bdf`](https://github.com/Toilal/rebulk/commit/f0f4bdf487d6e4b9f500271fe255d5c294565444))

* Performance improvements ([`09f866f`](https://github.com/Toilal/rebulk/commit/09f866f0094a37542ffae17888a2ac7ce41e9413))

* Back to development: 0.8.2 ([`e4e058c`](https://github.com/Toilal/rebulk/commit/e4e058c5cff26382687e87cf9f41095b357c5dc8))

* Preparing release 0.8.1 ([`1545f63`](https://github.com/Toilal/rebulk/commit/1545f63d865c58f057b81e53e7f25e4a2ecafe9b))

* Avoid dict comprehension (unsupported in Python 2.6) ([`acef1c5`](https://github.com/Toilal/rebulk/commit/acef1c59dee7b3d23164b2b380a504a49f0b1c70))

* Fix unit tests ([`c85a37b`](https://github.com/Toilal/rebulk/commit/c85a37b169a7ad3ead4b37ef6d8a5f7627afc872))

* Back to development: 0.8.1 ([`cc51b73`](https://github.com/Toilal/rebulk/commit/cc51b73a380a4a6b6f0d7a51ab7832fc1b7fdea1))

* Preparing release 0.8.0 ([`86f723e`](https://github.com/Toilal/rebulk/commit/86f723e7fb0f08d9e97cf4dd3e9eb5146c673446))

* Add chain_breaker option to implement dynamic breaking of chain patterns ([`dd5bc5a`](https://github.com/Toilal/rebulk/commit/dd5bc5aacf41cbd2db85d0648b1f029f252f4119))

* Add pattern post processor ([`fb01523`](https://github.com/Toilal/rebulk/commit/fb01523988a66f3c3be1508d576829dbd92c7c1e))

* Back to development: 0.7.8 ([`4df4696`](https://github.com/Toilal/rebulk/commit/4df46960b69d1dbaac3b1b81bca1affec7555af0))

* Preparing release 0.7.7 ([`4c85833`](https://github.com/Toilal/rebulk/commit/4c85833328912113bb8a6f176a9454d0dc9170a9))

* Remove twine workaround for zest releaser ([`f3a1e99`](https://github.com/Toilal/rebulk/commit/f3a1e99ad30b7600ede545d0366354dd5d762112))

* Fix chain patterns not properly detected in certain scenarios

Close #7 ([`8b84357`](https://github.com/Toilal/rebulk/commit/8b84357b03586636db72e173be72f36f322590e5))

* Back to development: 0.7.7 ([`42d0a58`](https://github.com/Toilal/rebulk/commit/42d0a58af9d793334616a6582f2a83b0fae0dd5f))

* Preparing release 0.7.6 ([`1041741`](https://github.com/Toilal/rebulk/commit/1041741b3be3ad70f41c44252b4556862296e0a9))

* Use raw matches for chain evaluation ([`0ae68c4`](https://github.com/Toilal/rebulk/commit/0ae68c4d449e7479917066217be58174b02c05c6))

* Fix chain to generates Match with children as Matches object instead of list ([`0f0910a`](https://github.com/Toilal/rebulk/commit/0f0910ab650a9a6b9c51c6cf9cc383998f8fbe63))

* Back to development: 0.7.6 ([`d2769e1`](https://github.com/Toilal/rebulk/commit/d2769e1bce7ac158f0ec7cc8d191f8bc6994554f))

* Preparing release 0.7.5 ([`3c2474a`](https://github.com/Toilal/rebulk/commit/3c2474a06978c9f4a427420f2c07d3111bfade02))

* Add ignore_names pattern property ([`7a265a1`](https://github.com/Toilal/rebulk/commit/7a265a106c525a3e20ad233f951c89ab8198d10e))

* Match children is now a Matches list ([`29dbfab`](https://github.com/Toilal/rebulk/commit/29dbfab074a6d8fe9b76a9ac433f0479fc344503))

* Add support for dict on value property (like validator and formatter) ([`53f141a`](https://github.com/Toilal/rebulk/commit/53f141adff54a23840ec0fb720f70e5ccd5cbdc4))

* Back to development: 0.7.5 ([`10bea48`](https://github.com/Toilal/rebulk/commit/10bea4827093bf8666dc4f40dd16c4bd05b49196))

* Preparing release 0.7.4 ([`7a80bfa`](https://github.com/Toilal/rebulk/commit/7a80bfa5dac216a9d177902a1c05e54a07ea7162))

* Fix repeating support in Chain Patterns containing children. ([`0f1854a`](https://github.com/Toilal/rebulk/commit/0f1854a368baf7679e4ba5b8888721dc5c822f83))

* Add support for dict inheritence in Chain parameters. ([`61e96f9`](https://github.com/Toilal/rebulk/commit/61e96f9b0a3a0eb9e4e32a6ba33697e0599d52bf))

* Add workaround for zest.releaser twine issue

See https://github.com/zestsoftware/zest.releaser/issues/183 ([`1948b06`](https://github.com/Toilal/rebulk/commit/1948b06d9dbe4e063b142043920fb5fa2d33cdc0))

* Remove unused platform import

Close #4 ([`84f6919`](https://github.com/Toilal/rebulk/commit/84f69194ee6b022747a0b08e9870936b34542743))

* Back to development: 0.7.4 ([`a20ebac`](https://github.com/Toilal/rebulk/commit/a20ebac0c76f8f042181935eb5898afb7e1ac2b3))

* Preparing release 0.7.3 ([`ab965b2`](https://github.com/Toilal/rebulk/commit/ab965b2ac160025771a794be9d393a1be5c85d4a))

* Fix pylint issues (again) ([`f3fbea4`](https://github.com/Toilal/rebulk/commit/f3fbea4a80a92141b93c49b614cdffa52671ff40))

* Fix pylint issue ([`d5b2b09`](https://github.com/Toilal/rebulk/commit/d5b2b09f22eefc6a088848ed30c24ffab61ccecc))

* Add initiator value in matches logs ([`46d09d8`](https://github.com/Toilal/rebulk/commit/46d09d8fd9b932904ad4e16a94aac24fc737c7d4))

* Use string representation for Regexp Pattern ([`f70db5c`](https://github.com/Toilal/rebulk/commit/f70db5ccdec1d5be784b1d3aaafe7b111a2d5d73))

* Fix missing parent on matches generated by chain() ([`2c15ed4`](https://github.com/Toilal/rebulk/commit/2c15ed47e9821bfd237ca7a04ab6b0dcf1c622ec))

* Add more logs for conflict solving ([`afb8994`](https://github.com/Toilal/rebulk/commit/afb89940693fdbbf9030911a8818a47537656ade))

* Back to development: 0.7.3 ([`15728b2`](https://github.com/Toilal/rebulk/commit/15728b2f77b25d5de947f1ce69df3fcc3d8b2e34))

* Preparing release 0.7.2 ([`e06c78e`](https://github.com/Toilal/rebulk/commit/e06c78e7a45c9d1ad1c47750e70c4e8dd664a289))

* Avoid usage of six.text_type (could cause UnicodeDecodeError) ([`a69b009`](https://github.com/Toilal/rebulk/commit/a69b0094ea09601d5571fdc240aa73e1c901b199))

* Back to development: 0.7.2 ([`68a4588`](https://github.com/Toilal/rebulk/commit/68a4588dd927b973ab35a70d8c815a5b5268a148))

* Preparing release 0.7.1 ([`23e0f90`](https://github.com/Toilal/rebulk/commit/23e0f904989521075aee1e4120d6fac79b739ca4))

* Filter blank matches out ([`da38bb7`](https://github.com/Toilal/rebulk/commit/da38bb7e51134435263eeaa3dc89ea3a4ce9494d))

* Back to development: 0.7.1 ([`c9c1ebe`](https://github.com/Toilal/rebulk/commit/c9c1ebe74ff9724570f6301d6d89a263ff6ac1e8))

* Preparing release 0.7.0 ([`8e0ea2c`](https://github.com/Toilal/rebulk/commit/8e0ea2c1e957e06abec68ed0af4cb67636458a9f))

* Add chain feature to emulate repeated capture groups ([`6f7abd5`](https://github.com/Toilal/rebulk/commit/6f7abd52d9e2498a985c0144edf405c057562fb5))

* Add remodule to allow forcing of default re module ([`e380229`](https://github.com/Toilal/rebulk/commit/e38022966b3df13bc09ab8e3ac7a8edc44505a47))

* Back to development: 0.6.6 ([`90105be`](https://github.com/Toilal/rebulk/commit/90105be829358eb2192b7e6b8f3c43d98457dd85))

* Preparing release 0.6.5 ([`9359e5a`](https://github.com/Toilal/rebulk/commit/9359e5a61832024515481c9480f75cc4f4718dc5))

* Remove regex to optional dependency ([`86b00d8`](https://github.com/Toilal/rebulk/commit/86b00d8d215c98aeecde899dde6e04df8c7bd81d))

* Better setup.py and requirements configuration ([`d43e9c3`](https://github.com/Toilal/rebulk/commit/d43e9c3e3845d3c8859e62bc4c42e30c14b3c48e))

* Enhance setup.py ([`4e14aea`](https://github.com/Toilal/rebulk/commit/4e14aeaaff14a0057587329e2372bc1620a18af0))

* Upgrade to pylint 1.5.0 ([`91b27cc`](https://github.com/Toilal/rebulk/commit/91b27cc9d849f6b198b84fa9b43e902925a05f02))

* Back to development: 0.6.5 ([`0da8e48`](https://github.com/Toilal/rebulk/commit/0da8e48827435af8184d88fc02a109526b088cab))

* Preparing release 0.6.4 ([`af41c85`](https://github.com/Toilal/rebulk/commit/af41c85b7fe8b554353928fff011f727a4f8824b))

* Set default LOG_LEVEL to logging.DEBUG ([`36bb560`](https://github.com/Toilal/rebulk/commit/36bb5605b4ec7a062190e8f5ef755023c0b2f6e4))

* Update Development Status classifier ([`050105a`](https://github.com/Toilal/rebulk/commit/050105ac49b52a299115407f05b9e44de7598304))

* Back to development: 0.6.4 ([`26add94`](https://github.com/Toilal/rebulk/commit/26add94a85399ab31266b4dd32bffcca6668ca4d))

* Preparing release 0.6.3 ([`96915e2`](https://github.com/Toilal/rebulk/commit/96915e25d95778ec28abff7342e7b97190e4dde6))

* Add implicit option in Matches.to_dict method ([`ef51d8e`](https://github.com/Toilal/rebulk/commit/ef51d8e11b77489dca31fc35234479554b9e6810))

* Remove pep8 section from tox configuration ([`c21c9b2`](https://github.com/Toilal/rebulk/commit/c21c9b225636cbc162c5ab07db7b16cc342a90ec))

* Fix tox and travisCI configuration ([`c05a5d5`](https://github.com/Toilal/rebulk/commit/c05a5d5bb731602d2697625a6d13c902b5397ec7))

* Back to development: 0.6.3 ([`e6f6bfb`](https://github.com/Toilal/rebulk/commit/e6f6bfb72f3a1fe14bb4610d8de1e1a4ae2015b7))

* Preparing release 0.6.2 ([`d49b00d`](https://github.com/Toilal/rebulk/commit/d49b00d3b97a5970ea7338bfad34dbc44d5c3d29))

* Add python 2.6 support ([`bd5f9ab`](https://github.com/Toilal/rebulk/commit/bd5f9ab25dc6fa29c7b976517506e84211b11924))

* Back to development: 0.6.2 ([`5faa117`](https://github.com/Toilal/rebulk/commit/5faa117fc3eb62942b1445532e9274a9f9bd299e))

* Preparing release 0.6.1 ([`32a2002`](https://github.com/Toilal/rebulk/commit/32a2002ab83b30b0cf50e97fd7da408b17e18548))

* Use deep copy instead of shallow copy for match methods. ([`897a49c`](https://github.com/Toilal/rebulk/commit/897a49c02d6c8c83708a061db1560fe08e7e1d56))

* Add AppendTags and RemoveTags consequences ([`42812b3`](https://github.com/Toilal/rebulk/commit/42812b3c57a5263b5954c6fd8da1fc1386810d45))

* Add more unit tests on introspect module ([`cda3bca`](https://github.com/Toilal/rebulk/commit/cda3bcad977e57c16888242ec8bb4996a1640217))

* Back to development: 0.6.1 ([`69b958e`](https://github.com/Toilal/rebulk/commit/69b958ea2f9264f98f8c88747d90e392964bf0ed))

* Finish 0.6.0 ([`5e54809`](https://github.com/Toilal/rebulk/commit/5e548097023482ccb2a4eb661d5fd4cbb84a2565))

* Preparing release 0.6.0 ([`4b730cc`](https://github.com/Toilal/rebulk/commit/4b730cc860fc144dc5d8caeeb7cfcfd841851ed1))

* Fix introspector for patterns having a name defined ([`757ff7a`](https://github.com/Toilal/rebulk/commit/757ff7aaba78a00e599b9a6bb40c56be21099045))

* Remove processor and post_processor in favor of rules ([`fc8a4fc`](https://github.com/Toilal/rebulk/commit/fc8a4fc0474a228a96ef6e84e56d3c73fa6b0da6))

* Add introspector module to extract information from defined Rebulk objects ([`b620129`](https://github.com/Toilal/rebulk/commit/b620129d5c997705775829775ddbac4f7d89b61a))

* Implement matches composition like processors and rules ([`34ff5b0`](https://github.com/Toilal/rebulk/commit/34ff5b04d3908575d2620456715368425227a46e))

* Back to development: 0.5.1 ([`8ac3196`](https://github.com/Toilal/rebulk/commit/8ac3196b115b47a661f6f2c229f5b88b45a1fda6))

* Finish 0.5.0 ([`32143ec`](https://github.com/Toilal/rebulk/commit/32143ecaf73ed2f9eef1e7044068a6e807c57efd))

* Preparing release 0.5.0 ([`91e2086`](https://github.com/Toilal/rebulk/commit/91e2086f0f93b6d8ca77b7c74a6d29b9729e4d7d))

* Add rebulk composition ([`853acf6`](https://github.com/Toilal/rebulk/commit/853acf674b056d2fae5e11b6ae230ae99f1c6c83))

* Fix a minor issue with rules and increase code coverage ([`4bb105f`](https://github.com/Toilal/rebulk/commit/4bb105f981346be63525017c2f0ab356ee559ee3))

* Add zest.releaser configuration ([`f07e0ab`](https://github.com/Toilal/rebulk/commit/f07e0ab789086f0076af6569cebfc65c5f6a4700))

* Back to development ([`ed30cab`](https://github.com/Toilal/rebulk/commit/ed30cab37d28b502c428a3eea3dc35e2fef7b1ee))

* Release v0.4.2 ([`a831435`](https://github.com/Toilal/rebulk/commit/a831435c728fd193457b187ef16abcccda8f3ca9))

* Add some features in README ([`49ef2c9`](https://github.com/Toilal/rebulk/commit/49ef2c953cb2646951d6719158f1227035f327e7))

* Add more tests ([`b671bed`](https://github.com/Toilal/rebulk/commit/b671beddbb020ed1e594eac569e450523de6a334))

* Make python setup.py test works on an new environment ([`b178235`](https://github.com/Toilal/rebulk/commit/b178235f2bb7365c56cf12c8f93ea4024372cecc))

* Back to development ([`40d3f28`](https://github.com/Toilal/rebulk/commit/40d3f28c1e88d888f20b6b42b99686da2054ce0d))

* Release v0.4.1 ([`8cdd367`](https://github.com/Toilal/rebulk/commit/8cdd3673f50257738569fefb232190256cd36435))

* Some fixes in Matches methods ([`9c0fe70`](https://github.com/Toilal/rebulk/commit/9c0fe70a4aad9be783538c21d90e05d034c82288))

* Fix chain_after method when no predicate is used ([`cb287fd`](https://github.com/Toilal/rebulk/commit/cb287fde0d6e14b84fcb06f4e3d93f94cdcffb04))

* Fix possible offset in Matches at_span/at_match methods ([`02d033c`](https://github.com/Toilal/rebulk/commit/02d033c36a165733ca8995700fd38b81a902f2c6))

* Use better implementation for Matches conflicting method ([`19473eb`](https://github.com/Toilal/rebulk/commit/19473ebb288d835943b719d440d1a3aaec53df3b))

* Add names property to Match object ([`e9a5dd1`](https://github.com/Toilal/rebulk/commit/e9a5dd152fbf795b013f239e7b56238f6df43ffd))

* Back to development ([`3795cfc`](https://github.com/Toilal/rebulk/commit/3795cfcdd4cd7accfb565b054280e8f5df924139))

* Release v0.4.0 ([`b9c9fc3`](https://github.com/Toilal/rebulk/commit/b9c9fc3594d9dcba4c502552ebaa7aa546bc6706))

* Add dependency support for rules using toposort ([`7a87aee`](https://github.com/Toilal/rebulk/commit/7a87aeee6bb45c8a03753251e3a0b81a0b4eaad7))

* Refactor Rule in Consequence and Condition classes. ([`e1e05f9`](https://github.com/Toilal/rebulk/commit/e1e05f9a7596e0ba17194393ff32b4336c908748))

* Fix pylint issue ([`b09166f`](https://github.com/Toilal/rebulk/commit/b09166fc7c4a0704c5ad43886c9c49a5981bb7cf))

* Make sure objects returned by Match methods are new instances ([`46dc01c`](https://github.com/Toilal/rebulk/commit/46dc01c528c316548e9cd3d987fec271a68e23a2))

* Remove support for Match object returned by functionnal patterns ([`8637618`](https://github.com/Toilal/rebulk/commit/86376189bf3894f767c7423f592592100c8983d7))

* Add split method to Match object ([`71bec35`](https://github.com/Toilal/rebulk/commit/71bec3574cf5d774958c8fae19b61f46055b304d))

* Add seps parameter to split holes with given separators

This also fix issue in holes method where last hole was missing. ([`a061517`](https://github.com/Toilal/rebulk/commit/a061517862d4056d6c38a1df44d0359c6fd751ad))

* Add debug and logging features ([`a402dcf`](https://github.com/Toilal/rebulk/commit/a402dcf1a3151fd8aacc4504d0d3bc28db01afad))

* Add more information in Match __repr__ ([`fe7bce2`](https://github.com/Toilal/rebulk/commit/fe7bce24d9b8671ffca2b43d8eebcdf14ce5d6fa))

* Add formatters and validators to chain functions ([`c30165c`](https://github.com/Toilal/rebulk/commit/c30165c1205b7a57139999675761f008bc64d390))

* Split conflict_solver tests ([`7ab037b`](https://github.com/Toilal/rebulk/commit/7ab037bbce086025c7be3371f6f01f6caf4806a7))

* When a conflict_solver returns __default__ call the opposite one before calling default one. ([`4d3e1fa`](https://github.com/Toilal/rebulk/commit/4d3e1fadabac5d2c6404e1616ded99788c5d4d15))

* Fix an issue in Rule classes (iterate on changing iterable) ([`94dbc33`](https://github.com/Toilal/rebulk/commit/94dbc330aced0040a84a08f4d9cbb5d26159a31f))

* Add AppendRemoveMatchRule class ([`6a95ad6`](https://github.com/Toilal/rebulk/commit/6a95ad63059ecff2225854d7e997b5a9b4a1c676))

* Fix issue in conflict_solver and add __default__ magic support ([`af983e2`](https://github.com/Toilal/rebulk/commit/af983e25e7e601e11bdf4b6c5d5638cd03168887))

* Fix Match object equality ([`3b972cd`](https://github.com/Toilal/rebulk/commit/3b972cdaf6556e4b2b4b2bc4c871edb59c7f08c5))

* Add conflicting method to Matches object ([`d86f648`](https://github.com/Toilal/rebulk/commit/d86f648a8ae9dcb5ccc50993abcd5b59ee409cf3))

* Add better conflict_solver support and refactor Matches class ([`edea7e3`](https://github.com/Toilal/rebulk/commit/edea7e337860c9eafe8012b26b3011be6c141c5f))

* Add __parent__ and __children__ magic keys for validator and formatters ([`e52920b`](https://github.com/Toilal/rebulk/commit/e52920b4af94147485bbe2892e9719901c8361b4))

* Add ignore to Match.holes method ([`b7ed583`](https://github.com/Toilal/rebulk/commit/b7ed583839a4a985339865db3f1db1fabdcae722))

* Add conflict_solver function in Match object ([`e734151`](https://github.com/Toilal/rebulk/commit/e734151172a2aaddf2b3eb2307329483bcf6db48))

* Prefer longuer is now based on initiator parent ([`aa9f579`](https://github.com/Toilal/rebulk/commit/aa9f57911395ffde18c091069201c7eefed12c27))

* Use OrderedDict and sorted matches for to_dict conversion ([`6562fc9`](https://github.com/Toilal/rebulk/commit/6562fc996197f6f4c9bdd87f87c77fb295849c66))

* Fix a typo on Match value ([`25e5451`](https://github.com/Toilal/rebulk/commit/25e5451c67a16be043a6455c7edb8834721776f6))

* Add disabled property on pattern and give context to functional patterns ([`867cbf1`](https://github.com/Toilal/rebulk/commit/867cbf137703d2e7a786ffbb907fce63a331c41a))

* Add test for unicode support

Close #1 ([`d863c8e`](https://github.com/Toilal/rebulk/commit/d863c8e9968d299595ee5bad20504d09436cb9d5))

* Add global imports for rules classes ([`2f6c82d`](https://github.com/Toilal/rebulk/commit/2f6c82d74592c80b5042c0b808a658650896cbec))

* Fix issue on prefer_longuer processor when matches are not separated ([`8bd4c3c`](https://github.com/Toilal/rebulk/commit/8bd4c3c85c7e4af202bc9c54bcc408e8f34195d5))

* Back to development ([`d449ba6`](https://github.com/Toilal/rebulk/commit/d449ba6d4743313d96670ed70de4244ce428a54b))

* Release v0.3.0 ([`fc7094a`](https://github.com/Toilal/rebulk/commit/fc7094a8a984cc30d2dac1219c8e81575cfaa08b))

* Add RemoveMatchRule and AppendMatchRule classes ([`80dd929`](https://github.com/Toilal/rebulk/commit/80dd9297a5602a31b5d94d10fecf9c5c6d600dac))

* Fix an issue when invalid pattern from a list could skip next ones ([`f0383ba`](https://github.com/Toilal/rebulk/commit/f0383ba32c75728fa00c3b86fdf496a058a3892d))

* Fix issue in Match previous and next methods ([`29ea713`](https://github.com/Toilal/rebulk/commit/29ea713ae79a371005830479922d83dbc6481c40))

* Fix crop signature for python2 ([`1918fca`](https://github.com/Toilal/rebulk/commit/1918fca4e7bd5e8a17b845990ffe5e1b2b071b10))

* Add ignore_case option to String pattern ([`7a9a7b8`](https://github.com/Toilal/rebulk/commit/7a9a7b851bcb0e62005c428dc24d5025e30e2d40))

* Add raw_end and raw_start in Match class ([`d214392`](https://github.com/Toilal/rebulk/commit/d214392f29d7203c32377ca947d09b483d580ba5))

* Add crop method to Match class ([`66ad914`](https://github.com/Toilal/rebulk/commit/66ad91436fe1a3d4b0cba7621a3f7c0898df25f1))

* Match.range now returns sorted matches ([`dd011fe`](https://github.com/Toilal/rebulk/commit/dd011fe895045cf1a3dba82b699606a7e1ace75a))

* Refactor formatter from pattern to match (Match.value is now a dynamic property) ([`e269a16`](https://github.com/Toilal/rebulk/commit/e269a164b7d256c213251e0f7d0a76465e3f6762))

* Fix holes method to always return matche contained between (start, end) range ([`9f44ad7`](https://github.com/Toilal/rebulk/commit/9f44ad74d62162e1f6dc7c4c455ce4c6892b538c))

* Fix issue when a private match is found multiple times ([`fd819ff`](https://github.com/Toilal/rebulk/commit/fd819ff0ff1a7d73dd58f152d2c4be8aea18e2d3))

* Allow functional pattern to return dict as kwargs in last element of return value ([`849e86a`](https://github.com/Toilal/rebulk/commit/849e86ac69340b47293726989dddcac7f5ba3f0f))

* Execute then action after all when condition from same priority is called. ([`a0225fc`](https://github.com/Toilal/rebulk/commit/a0225fcc34c72289fbe5d4a40685f57e7e4c6108))

* Exclude private matches from conflict_prefer_longer post processor ([`0f3066d`](https://github.com/Toilal/rebulk/commit/0f3066dbe794649f1766514858065174cb14425f))

* Add more options to Pattern to customize yielding and private value ([`16b5879`](https://github.com/Toilal/rebulk/commit/16b58798f8b53acd1409a2abd55333388e6e36a2))

* Add private property to Match object ([`75f4ff4`](https://github.com/Toilal/rebulk/commit/75f4ff4bb1186e9722b9af8f7c68b898f77b0f42))

* Add holes method on Matches object ([`30d2e0a`](https://github.com/Toilal/rebulk/commit/30d2e0afd373fd151cb9b4c14b991093ffa8d963))

* Add range method to Matches object ([`b7c8566`](https://github.com/Toilal/rebulk/commit/b7c85662a8c3f3c7811afbd494085aff970703a9))

* Allow processors to return no value ([`927c2da`](https://github.com/Toilal/rebulk/commit/927c2da1fcd1b4013bd9394d0dc7d48efef9212f))

* Add names and tags properties to Matches ([`d9a27e1`](https://github.com/Toilal/rebulk/commit/d9a27e1b6fab53cffbb13c7047f85155be1d96b0))

* Add generator support in functional matches ([`5159b55`](https://github.com/Toilal/rebulk/commit/5159b5587341251d66ab3bd7c6190660a5469647))

* Refactor Match class to enable Match object support in functional patterns ([`bddcd36`](https://github.com/Toilal/rebulk/commit/bddcd36abbf5bb0012694d369a749c03f4da26e6))

* Add input_string to Match object and validators module ([`d8d76d6`](https://github.com/Toilal/rebulk/commit/d8d76d616789877b1a3f28fd82402da74bea18a2))

* Use name property for default regex group name ([`9438d4e`](https://github.com/Toilal/rebulk/commit/9438d4e8e6e3a58be1f683fd8752d42351e60f35))

* Fix loose.call function when input unction has varargs or keywords ([`75d78c9`](https://github.com/Toilal/rebulk/commit/75d78c9f6145d4cee99b6b5eeae08521c3f49ae0))

* Add format_all and validate_all option in patterns ([`3e7d134`](https://github.com/Toilal/rebulk/commit/3e7d134ee00f94bebb9fa00f94c555c884e0e90d))

* Add fixme to pylint ignore ([`bfefac6`](https://github.com/Toilal/rebulk/commit/bfefac69f35076524a39d0d13e0fc85b6bde3a19))

* Add a matches dict into Matches.to_dict return value ([`93c29d0`](https://github.com/Toilal/rebulk/commit/93c29d0cd41d7de3c6821968c76cc34f71121ee8))

* Add abbreviations support to regex patterns ([`8de859c`](https://github.com/Toilal/rebulk/commit/8de859c2a7e6a9b12ccbff92a55a6e42d93acd63))

* Add default parameters option for all patterns types ([`cbe9678`](https://github.com/Toilal/rebulk/commit/cbe9678b46e214642f32a0e60fe4db8912dc4388))

* Add details option to Matches.to_dict method ([`a0d3d73`](https://github.com/Toilal/rebulk/commit/a0d3d73319969c0fdfeb3509d2e0e3949d021841))

* Add more ignore rules for pylint ([`90b73c7`](https://github.com/Toilal/rebulk/commit/90b73c7968d5bdc16407462844dedac9e3f5baac))

* Add to_dict method on Matches ([`7c17f29`](https://github.com/Toilal/rebulk/commit/7c17f29d1f90ef56ccea5cadaae91b7c62130b90))

* Add children option to patterns ([`87f3d77`](https://github.com/Toilal/rebulk/commit/87f3d773ff029d7ad60fbdeddeed15ffc7143e1c))

* Add rebulk method on Rebulk class ([`276de4c`](https://github.com/Toilal/rebulk/commit/276de4c700b0a249544a37c6692221b5a83aef7f))

* Back to development ([`91f6b2b`](https://github.com/Toilal/rebulk/commit/91f6b2b4ba716360eab077a12f25a7c226da233c))

* Release v0.2.1 ([`29b8f08`](https://github.com/Toilal/rebulk/commit/29b8f08c6a103c26f17b6a70a9d8a5669317611a))

* Add marker feature ([`4a5eb7d`](https://github.com/Toilal/rebulk/commit/4a5eb7d7289f04167baf17387c992f517ab52cfd))

* Back to development ([`235fdba`](https://github.com/Toilal/rebulk/commit/235fdbaafc9a947b4b6100ae3173428550874d76))

* Release v0.2.0 ([`5d7cf3b`](https://github.com/Toilal/rebulk/commit/5d7cf3b48dc9257a83b9911304fecbc3209bc83b))

* Add rules module

This also replace OrderedSet with list in Match object (benchmark shows it&#39;s faster). ([`e34ef36`](https://github.com/Toilal/rebulk/commit/e34ef36104d5c7c71c8f7103cbde58500cc26c62))

* Add support of regex module and repeated_captures option ([`5bb1dfe`](https://github.com/Toilal/rebulk/commit/5bb1dfe9128f1e3df556b03234ce71bb3cd92176))

* Fix rebulk docs ([`91dc462`](https://github.com/Toilal/rebulk/commit/91dc4620591e78a2290be74d1c8ff6c2a705c3b2))

* Add name and tags support on patterns and matches

Note that ordering of Match class constructor parameters was changed (value is now defined before name).

It also include small refactoring using loose module. ([`c19b9af`](https://github.com/Toilal/rebulk/commit/c19b9af190632583534cdd5d21f722613445b359))

* Add validator kwarg option on Pattern ([`694cf8d`](https://github.com/Toilal/rebulk/commit/694cf8d6cb62dc9bb29d4dbabe1f86973c20d884))

* Fix code coverage for python2 ([`d959916`](https://github.com/Toilal/rebulk/commit/d95991685c782182aafd5191174dc192599792be))

* Remove useless dict from README ([`a679807`](https://github.com/Toilal/rebulk/commit/a6798075d5c1e5f80030eb2e4f98d6e980a1dccd))

* Back to development ([`c7d7023`](https://github.com/Toilal/rebulk/commit/c7d702313b8ddb37657aa955eb431542d00cb451))

* Release v0.1.0 ([`2a5e21b`](https://github.com/Toilal/rebulk/commit/2a5e21bca6a916b3fb92edc607715650c83339d3))

* Add docs in README.rst ([`20db297`](https://github.com/Toilal/rebulk/commit/20db29715b0dfba96e100ae3ae9775ce91331987))

* Add more test cases for conflict_prefer_longer processor ([`1256a60`](https://github.com/Toilal/rebulk/commit/1256a608a9d792dd1b0286e80dc1ae46256fbdab))

* Pass keyword arguments from Pattern to Match objects ([`dbaf208`](https://github.com/Toilal/rebulk/commit/dbaf20801b8c494ccdb1a72bdd0d3dac300e0394))

* Fix pylint Wrong continued indentation ([`a1254a3`](https://github.com/Toilal/rebulk/commit/a1254a3c9cfe30d3cafc345f296752fa4e7f6759))

* Rename formatters pattern option to formatter ([`e0cb5f7`](https://github.com/Toilal/rebulk/commit/e0cb5f7e197aef6277b8dbbb48492eb53b1de23e))

* Fix pylint issues ([`e6402fb`](https://github.com/Toilal/rebulk/commit/e6402fb335f7d019cf5ed0f57ced055e464b3339))

* Refactor filter into processor ([`88cbc21`](https://github.com/Toilal/rebulk/commit/88cbc2176d4f3833eefb1a2c9e8b5f58e2597569))

* Refactor Bucket into Rebulk class ([`f4efef1`](https://github.com/Toilal/rebulk/commit/f4efef1574bb8faab632bc1a66c1d9aabe094f09))

* Back to development ([`4fe2d82`](https://github.com/Toilal/rebulk/commit/4fe2d8276972d4d2c3756fa6104c9e5bdd689eb2))

* Release v0.0.1 ([`80398ce`](https://github.com/Toilal/rebulk/commit/80398ce5065930c31703f1212ee4cdde3fe9b0f1))

* Add pylint and fix related issues ([`676af68`](https://github.com/Toilal/rebulk/commit/676af6887ac99aa11be0a89d81d9ea7f258580a8))

* Add python 3.5 support ([`7815c3f`](https://github.com/Toilal/rebulk/commit/7815c3f7714ec926806d7dd4e0c8ce6b80269073))

* Fix PEP8 issues ([`412ea88`](https://github.com/Toilal/rebulk/commit/412ea886fdadfac5e1489f13fa0c9b069c53f7b8))

* Add Matches MutableSequence to compute span dict automatically ([`21ae4da`](https://github.com/Toilal/rebulk/commit/21ae4da2ea24f3321336a59ea3b8fb8af1bcdfda))

* Add pep8 checking ([`91d7fab`](https://github.com/Toilal/rebulk/commit/91d7fabdde371c13dc8d1db6fd1c9d0efc77141f))

* Refactor for codebase to be simpler ([`9255a4f`](https://github.com/Toilal/rebulk/commit/9255a4f49cb968d33897166d3c7084b0afbf79b9))

* Fix tests for python2 ([`d6cf2b0`](https://github.com/Toilal/rebulk/commit/d6cf2b0f9f6dcecd499b0961b78ddedc7763484e))

* Remove branch coverage ([`b4519bb`](https://github.com/Toilal/rebulk/commit/b4519bbc2a05e41616d5d524b7634a359731f653))

* Increase code coverage of Match class ([`306f196`](https://github.com/Toilal/rebulk/commit/306f19666d0242a1a0ca5a58c889ab3e4f49c84d))

* Add group_neighbors function ([`eb2933a`](https://github.com/Toilal/rebulk/commit/eb2933abcef2d6e427c31c415dc8614e347ec3ad))

* Add more operators support on Match objects ([`4c57a6a`](https://github.com/Toilal/rebulk/commit/4c57a6a86ff77dce15ae5e63e9633b13c09cb347))

* Add bucket and filters ([`0416970`](https://github.com/Toilal/rebulk/commit/041697031137951dc6eb5cb9bab282f8fcd6b2a0))

* Yield parent matches instead of children ([`18233e2`](https://github.com/Toilal/rebulk/commit/18233e2ed91550c602f736b15dfd23b2b9ac139f))

* Add value and formatters ([`4a8820f`](https://github.com/Toilal/rebulk/commit/4a8820fde768b2c7e36c2d37b5ded10d41bcb879))

* Initial commit ([`4b1141d`](https://github.com/Toilal/rebulk/commit/4b1141dd2dd04f1bc2172e3d87c96d4dd3509adf))
