# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import CredentialType, EndpointType

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    """


class Agent(ProxyResource):
    """The Agent resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar properties: Required.
    :vartype properties: ~azure.mgmt.storagemover.models.AgentProperties
    """

    properties: "_models.AgentProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    __flattened_items = [
        "description",
        "agent_version",
        "arc_resource_id",
        "arc_vm_uuid",
        "agent_status",
        "last_status_update",
        "local_ip_address",
        "memory_in_mb",
        "number_of_cores",
        "uptime_in_seconds",
        "time_zone",
        "upload_limit_schedule",
        "error_details",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.AgentProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AgentProperties(_Model):
    """AgentProperties.

    :ivar description: A description for the Agent.
    :vartype description: str
    :ivar agent_version: The Agent version.
    :vartype agent_version: str
    :ivar arc_resource_id: The fully qualified resource ID of the Hybrid Compute resource for the
     Agent. Required.
    :vartype arc_resource_id: str
    :ivar arc_vm_uuid: The VM UUID of the Hybrid Compute resource for the Agent. Required.
    :vartype arc_vm_uuid: str
    :ivar agent_status: The Agent status. Known values are: "Registering", "Offline", "Online",
     "Executing", "RequiresAttention", and "Unregistering".
    :vartype agent_status: str or ~azure.mgmt.storagemover.models.AgentStatus
    :ivar last_status_update: The last updated time of the Agent status.
    :vartype last_status_update: ~datetime.datetime
    :ivar local_ip_address: Local IP address reported by the Agent.
    :vartype local_ip_address: str
    :ivar memory_in_mb: Available memory reported by the Agent, in MB.
    :vartype memory_in_mb: int
    :ivar number_of_cores: Available compute cores reported by the Agent.
    :vartype number_of_cores: int
    :ivar uptime_in_seconds: Uptime of the Agent in seconds.
    :vartype uptime_in_seconds: int
    :ivar time_zone: The agent's local time zone represented in Windows format.
    :vartype time_zone: str
    :ivar upload_limit_schedule: The WAN-link upload limit schedule that applies to any Job Run the
     agent executes. Data plane operations (migrating files) are affected. Control plane operations
     ensure seamless migration functionality and are not limited by this schedule. The schedule is
     interpreted with the agent's local time.
    :vartype upload_limit_schedule: ~azure.mgmt.storagemover.models.UploadLimitSchedule
    :ivar error_details:
    :vartype error_details: ~azure.mgmt.storagemover.models.AgentPropertiesErrorDetails
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Agent."""
    agent_version: Optional[str] = rest_field(name="agentVersion", visibility=["read"])
    """The Agent version."""
    arc_resource_id: str = rest_field(name="arcResourceId", visibility=["read", "create"])
    """The fully qualified resource ID of the Hybrid Compute resource for the Agent. Required."""
    arc_vm_uuid: str = rest_field(name="arcVmUuid", visibility=["read", "create"])
    """The VM UUID of the Hybrid Compute resource for the Agent. Required."""
    agent_status: Optional[Union[str, "_models.AgentStatus"]] = rest_field(name="agentStatus", visibility=["read"])
    """The Agent status. Known values are: \"Registering\", \"Offline\", \"Online\", \"Executing\",
     \"RequiresAttention\", and \"Unregistering\"."""
    last_status_update: Optional[datetime.datetime] = rest_field(
        name="lastStatusUpdate", visibility=["read"], format="rfc3339"
    )
    """The last updated time of the Agent status."""
    local_ip_address: Optional[str] = rest_field(name="localIPAddress", visibility=["read"])
    """Local IP address reported by the Agent."""
    memory_in_mb: Optional[int] = rest_field(name="memoryInMB", visibility=["read"])
    """Available memory reported by the Agent, in MB."""
    number_of_cores: Optional[int] = rest_field(name="numberOfCores", visibility=["read"])
    """Available compute cores reported by the Agent."""
    uptime_in_seconds: Optional[int] = rest_field(name="uptimeInSeconds", visibility=["read"])
    """Uptime of the Agent in seconds."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read"])
    """The agent's local time zone represented in Windows format."""
    upload_limit_schedule: Optional["_models.UploadLimitSchedule"] = rest_field(
        name="uploadLimitSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """The WAN-link upload limit schedule that applies to any Job Run the agent executes. Data plane
     operations (migrating files) are affected. Control plane operations ensure seamless migration
     functionality and are not limited by this schedule. The schedule is interpreted with the
     agent's local time."""
    error_details: Optional["_models.AgentPropertiesErrorDetails"] = rest_field(
        name="errorDetails", visibility=["read"]
    )
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this resource. Known values are: \"Succeeded\", \"Canceled\",
     \"Failed\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        arc_resource_id: str,
        arc_vm_uuid: str,
        description: Optional[str] = None,
        upload_limit_schedule: Optional["_models.UploadLimitSchedule"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentPropertiesErrorDetails(_Model):
    """AgentPropertiesErrorDetails.

    :ivar code: Error code reported by Agent.
    :vartype code: str
    :ivar message: Expanded description of reported error code.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code reported by Agent."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Expanded description of reported error code."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentUpdateParameters(_Model):
    """The Agent resource.

    :ivar properties:
    :vartype properties: ~azure.mgmt.storagemover.models.AgentUpdateProperties
    """

    properties: Optional["_models.AgentUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    __flattened_items = ["description", "upload_limit_schedule"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AgentUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AgentUpdateProperties(_Model):
    """AgentUpdateProperties.

    :ivar description: A description for the Agent.
    :vartype description: str
    :ivar upload_limit_schedule: The WAN-link upload limit schedule that applies to any Job Run the
     agent executes. Data plane operations (migrating files) are affected. Control plane operations
     ensure seamless migration functionality and are not limited by this schedule. The schedule is
     interpreted with the agent's local time.
    :vartype upload_limit_schedule: ~azure.mgmt.storagemover.models.UploadLimitSchedule
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Agent."""
    upload_limit_schedule: Optional["_models.UploadLimitSchedule"] = rest_field(
        name="uploadLimitSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """The WAN-link upload limit schedule that applies to any Job Run the agent executes. Data plane
     operations (migrating files) are affected. Control plane operations ensure seamless migration
     functionality and are not limited by this schedule. The schedule is interpreted with the
     agent's local time."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        upload_limit_schedule: Optional["_models.UploadLimitSchedule"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Credentials(_Model):
    """The Credentials.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureKeyVaultSmbCredentials

    :ivar type: The Credentials type. Required. "AzureKeyVaultSmb"
    :vartype type: str or ~azure.mgmt.storagemover.models.CredentialType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create"])
    """The Credentials type. Required. \"AzureKeyVaultSmb\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureKeyVaultSmbCredentials(Credentials, discriminator="AzureKeyVaultSmb"):
    """The Azure Key Vault secret URIs which store the credentials.

    :ivar username_uri: The Azure Key Vault secret URI which stores the username. Use empty string
     to clean-up existing value.
    :vartype username_uri: str
    :ivar password_uri: The Azure Key Vault secret URI which stores the password. Use empty string
     to clean-up existing value.
    :vartype password_uri: str
    :ivar type: The Credentials type. Required.
    :vartype type: str or ~azure.mgmt.storagemover.models.AZURE_KEY_VAULT_SMB
    """

    username_uri: Optional[str] = rest_field(
        name="usernameUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Key Vault secret URI which stores the username. Use empty string to clean-up existing
     value."""
    password_uri: Optional[str] = rest_field(
        name="passwordUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Key Vault secret URI which stores the password. Use empty string to clean-up existing
     value."""
    type: Literal[CredentialType.AZURE_KEY_VAULT_SMB] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Credentials type. Required."""

    @overload
    def __init__(
        self,
        *,
        username_uri: Optional[str] = None,
        password_uri: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=CredentialType.AZURE_KEY_VAULT_SMB, **kwargs)


class EndpointBaseProperties(_Model):
    """The resource specific properties for the Storage Mover resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureMultiCloudConnectorEndpointProperties, AzureStorageBlobContainerEndpointProperties,
    AzureStorageNfsFileShareEndpointProperties, AzureStorageSmbFileShareEndpointProperties,
    NfsMountEndpointProperties, SmbMountEndpointProperties

    :ivar endpoint_type: The Endpoint resource type. Required. Known values are:
     "AzureStorageBlobContainer", "NfsMount", "AzureStorageSmbFileShare", "SmbMount",
     "AzureMultiCloudConnector", and "AzureStorageNfsFileShare".
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.EndpointType
    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    __mapping__: dict[str, _Model] = {}
    endpoint_type: str = rest_discriminator(name="endpointType", visibility=["read", "create"])
    """The Endpoint resource type. Required. Known values are: \"AzureStorageBlobContainer\",
     \"NfsMount\", \"AzureStorageSmbFileShare\", \"SmbMount\", \"AzureMultiCloudConnector\", and
     \"AzureStorageNfsFileShare\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Endpoint."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this resource. Known values are: \"Succeeded\", \"Canceled\",
     \"Failed\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        endpoint_type: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMultiCloudConnectorEndpointProperties(
    EndpointBaseProperties, discriminator="AzureMultiCloudConnector"
):  # pylint: disable=name-too-long
    """The properties of Azure MultiCloudConnector endpoint.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar multi_cloud_connector_id: The Azure Resource ID of the MultiCloud Connector resource.
     Required.
    :vartype multi_cloud_connector_id: str
    :ivar aws_s3_bucket_id: The AWS S3 bucket ARM resource Id. Required.
    :vartype aws_s3_bucket_id: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_MULTI_CLOUD_CONNECTOR
    """

    multi_cloud_connector_id: str = rest_field(name="multiCloudConnectorId", visibility=["read", "create"])
    """The Azure Resource ID of the MultiCloud Connector resource. Required."""
    aws_s3_bucket_id: str = rest_field(name="awsS3BucketId", visibility=["read", "create", "update", "delete", "query"])
    """The AWS S3 bucket ARM resource Id. Required."""
    endpoint_type: Literal[EndpointType.AZURE_MULTI_CLOUD_CONNECTOR] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        multi_cloud_connector_id: str,
        aws_s3_bucket_id: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_MULTI_CLOUD_CONNECTOR, **kwargs)


class EndpointBaseUpdateProperties(_Model):
    """The Endpoint resource, which contains information about file sources and targets.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureMultiCloudConnectorEndpointUpdateProperties,
    AzureStorageBlobContainerEndpointUpdateProperties,
    AzureStorageNfsFileShareEndpointUpdateProperties,
    AzureStorageSmbFileShareEndpointUpdateProperties, NfsMountEndpointUpdateProperties,
    SmbMountEndpointUpdateProperties

    :ivar endpoint_type: The Endpoint resource type. Required. Known values are:
     "AzureStorageBlobContainer", "NfsMount", "AzureStorageSmbFileShare", "SmbMount",
     "AzureMultiCloudConnector", and "AzureStorageNfsFileShare".
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.EndpointType
    :ivar description: A description for the Endpoint.
    :vartype description: str
    """

    __mapping__: dict[str, _Model] = {}
    endpoint_type: str = rest_discriminator(name="endpointType", visibility=["read", "create"])
    """The Endpoint resource type. Required. Known values are: \"AzureStorageBlobContainer\",
     \"NfsMount\", \"AzureStorageSmbFileShare\", \"SmbMount\", \"AzureMultiCloudConnector\", and
     \"AzureStorageNfsFileShare\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Endpoint."""

    @overload
    def __init__(
        self,
        *,
        endpoint_type: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMultiCloudConnectorEndpointUpdateProperties(
    EndpointBaseUpdateProperties, discriminator="AzureMultiCloudConnector"
):  # pylint: disable=name-too-long
    """The properties of Azure Storage NFS file share endpoint to update.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_MULTI_CLOUD_CONNECTOR
    """

    endpoint_type: Literal[EndpointType.AZURE_MULTI_CLOUD_CONNECTOR] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_MULTI_CLOUD_CONNECTOR, **kwargs)


class AzureStorageBlobContainerEndpointProperties(
    EndpointBaseProperties, discriminator="AzureStorageBlobContainer"
):  # pylint: disable=name-too-long
    """The properties of Azure Storage blob container endpoint.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar storage_account_resource_id: The Azure Resource ID of the storage account that is the
     target destination. Required.
    :vartype storage_account_resource_id: str
    :ivar blob_container_name: The name of the Storage blob container that is the target
     destination. Required.
    :vartype blob_container_name: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_STORAGE_BLOB_CONTAINER
    """

    storage_account_resource_id: str = rest_field(name="storageAccountResourceId", visibility=["read", "create"])
    """The Azure Resource ID of the storage account that is the target destination. Required."""
    blob_container_name: str = rest_field(name="blobContainerName", visibility=["read", "create"])
    """The name of the Storage blob container that is the target destination. Required."""
    endpoint_type: Literal[EndpointType.AZURE_STORAGE_BLOB_CONTAINER] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_account_resource_id: str,
        blob_container_name: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_STORAGE_BLOB_CONTAINER, **kwargs)


class AzureStorageBlobContainerEndpointUpdateProperties(
    EndpointBaseUpdateProperties, discriminator="AzureStorageBlobContainer"
):  # pylint: disable=name-too-long
    """AzureStorageBlobContainerEndpointUpdateProperties.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_STORAGE_BLOB_CONTAINER
    """

    endpoint_type: Literal[EndpointType.AZURE_STORAGE_BLOB_CONTAINER] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_STORAGE_BLOB_CONTAINER, **kwargs)


class AzureStorageNfsFileShareEndpointProperties(
    EndpointBaseProperties, discriminator="AzureStorageNfsFileShare"
):  # pylint: disable=name-too-long
    """The properties of Azure Storage NFS file share endpoint.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar storage_account_resource_id: The Azure Resource ID of the storage account. Required.
    :vartype storage_account_resource_id: str
    :ivar file_share_name: The name of the Azure Storage NFS file share. Required.
    :vartype file_share_name: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_STORAGE_NFS_FILE_SHARE
    """

    storage_account_resource_id: str = rest_field(name="storageAccountResourceId", visibility=["read", "create"])
    """The Azure Resource ID of the storage account. Required."""
    file_share_name: str = rest_field(name="fileShareName", visibility=["read", "create"])
    """The name of the Azure Storage NFS file share. Required."""
    endpoint_type: Literal[EndpointType.AZURE_STORAGE_NFS_FILE_SHARE] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_account_resource_id: str,
        file_share_name: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_STORAGE_NFS_FILE_SHARE, **kwargs)


class AzureStorageNfsFileShareEndpointUpdateProperties(
    EndpointBaseUpdateProperties, discriminator="AzureStorageNfsFileShare"
):  # pylint: disable=name-too-long
    """The properties of Azure Storage NFS file share endpoint to update.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_STORAGE_NFS_FILE_SHARE
    """

    endpoint_type: Literal[EndpointType.AZURE_STORAGE_NFS_FILE_SHARE] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_STORAGE_NFS_FILE_SHARE, **kwargs)


class AzureStorageSmbFileShareEndpointProperties(
    EndpointBaseProperties, discriminator="AzureStorageSmbFileShare"
):  # pylint: disable=name-too-long
    """The properties of Azure Storage SMB file share endpoint.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar storage_account_resource_id: The Azure Resource ID of the storage account. Required.
    :vartype storage_account_resource_id: str
    :ivar file_share_name: The name of the Azure Storage file share. Required.
    :vartype file_share_name: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_STORAGE_SMB_FILE_SHARE
    """

    storage_account_resource_id: str = rest_field(name="storageAccountResourceId", visibility=["read", "create"])
    """The Azure Resource ID of the storage account. Required."""
    file_share_name: str = rest_field(name="fileShareName", visibility=["read", "create"])
    """The name of the Azure Storage file share. Required."""
    endpoint_type: Literal[EndpointType.AZURE_STORAGE_SMB_FILE_SHARE] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_account_resource_id: str,
        file_share_name: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_STORAGE_SMB_FILE_SHARE, **kwargs)


class AzureStorageSmbFileShareEndpointUpdateProperties(
    EndpointBaseUpdateProperties, discriminator="AzureStorageSmbFileShare"
):  # pylint: disable=name-too-long
    """The properties of Azure Storage SMB file share endpoint to update.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.AZURE_STORAGE_SMB_FILE_SHARE
    """

    endpoint_type: Literal[EndpointType.AZURE_STORAGE_SMB_FILE_SHARE] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.AZURE_STORAGE_SMB_FILE_SHARE, **kwargs)


class Endpoint(ProxyResource):
    """The Endpoint resource, which contains information about file sources and targets.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar properties: The resource specific properties for the Storage Mover resource. Required.
    :vartype properties: ~azure.mgmt.storagemover.models.EndpointBaseProperties
    :ivar identity: The managed service identity of the resource. This property is only available
     on the latest version.
    :vartype identity: ~azure.mgmt.storagemover.models.ManagedServiceIdentity
    """

    properties: "_models.EndpointBaseProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource specific properties for the Storage Mover resource. Required."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identity of the resource. This property is only available on the latest
     version."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.EndpointBaseProperties",
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointBaseUpdateParameters(_Model):
    """The Endpoint resource.

    :ivar properties: The Endpoint resource, which contains information about file sources and
     targets.
    :vartype properties: ~azure.mgmt.storagemover.models.EndpointBaseUpdateProperties
    :ivar identity: The managed system identity assigned to this resource.
    :vartype identity: ~azure.mgmt.storagemover.models.ManagedServiceIdentity
    """

    properties: Optional["_models.EndpointBaseUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Endpoint resource, which contains information about file sources and targets."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed system identity assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EndpointBaseUpdateProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.storagemover.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.storagemover.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.storagemover.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobDefinition(ProxyResource):
    """The Job Definition resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar properties: Job definition properties. Required.
    :vartype properties: ~azure.mgmt.storagemover.models.JobDefinitionProperties
    """

    properties: "_models.JobDefinitionProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Job definition properties. Required."""

    __flattened_items = [
        "description",
        "job_type",
        "copy_mode",
        "source_name",
        "source_resource_id",
        "source_subpath",
        "target_name",
        "target_resource_id",
        "target_subpath",
        "latest_job_run_name",
        "latest_job_run_resource_id",
        "latest_job_run_status",
        "agent_name",
        "agent_resource_id",
        "source_target_map",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: "_models.JobDefinitionProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class JobDefinitionProperties(_Model):
    """Job definition properties.

    :ivar description: A description for the Job Definition. OnPremToCloud is for migrating data
     from on-premises to cloud. CloudToCloud is for migrating data between cloud to cloud.
    :vartype description: str
    :ivar job_type: The type of the Job. Known values are: "OnPremToCloud" and "CloudToCloud".
    :vartype job_type: str or ~azure.mgmt.storagemover.models.JobType
    :ivar copy_mode: Strategy to use for copy. Required. Known values are: "Additive" and "Mirror".
    :vartype copy_mode: str or ~azure.mgmt.storagemover.models.CopyMode
    :ivar source_name: The name of the source Endpoint. Required.
    :vartype source_name: str
    :ivar source_resource_id: Fully qualified resource ID of the source Endpoint.
    :vartype source_resource_id: str
    :ivar source_subpath: The subpath to use when reading from the source Endpoint.
    :vartype source_subpath: str
    :ivar target_name: The name of the target Endpoint. Required.
    :vartype target_name: str
    :ivar target_resource_id: Fully qualified resource ID of the target Endpoint.
    :vartype target_resource_id: str
    :ivar target_subpath: The subpath to use when writing to the target Endpoint.
    :vartype target_subpath: str
    :ivar latest_job_run_name: The name of the Job Run in a non-terminal state, if exists.
    :vartype latest_job_run_name: str
    :ivar latest_job_run_resource_id: The fully qualified resource ID of the Job Run in a
     non-terminal state, if exists.
    :vartype latest_job_run_resource_id: str
    :ivar latest_job_run_status: The current status of the Job Run in a non-terminal state, if
     exists. Known values are: "Queued", "Started", "Running", "CancelRequested", "Canceling",
     "Canceled", "Failed", "Succeeded", and "PausedByBandwidthManagement".
    :vartype latest_job_run_status: str or ~azure.mgmt.storagemover.models.JobRunStatus
    :ivar agent_name: Name of the Agent to assign for new Job Runs of this Job Definition.
    :vartype agent_name: str
    :ivar agent_resource_id: Fully qualified resource id of the Agent to assign for new Job Runs of
     this Job Definition.
    :vartype agent_resource_id: str
    :ivar source_target_map: The list of cloud endpoints to migrate.
    :vartype source_target_map:
     ~azure.mgmt.storagemover.models.JobDefinitionPropertiesSourceTargetMap
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Job Definition. OnPremToCloud is for migrating data from on-premises to
     cloud. CloudToCloud is for migrating data between cloud to cloud."""
    job_type: Optional[Union[str, "_models.JobType"]] = rest_field(
        name="jobType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the Job. Known values are: \"OnPremToCloud\" and \"CloudToCloud\"."""
    copy_mode: Union[str, "_models.CopyMode"] = rest_field(
        name="copyMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Strategy to use for copy. Required. Known values are: \"Additive\" and \"Mirror\"."""
    source_name: str = rest_field(name="sourceName", visibility=["read", "create"])
    """The name of the source Endpoint. Required."""
    source_resource_id: Optional[str] = rest_field(name="sourceResourceId", visibility=["read"])
    """Fully qualified resource ID of the source Endpoint."""
    source_subpath: Optional[str] = rest_field(name="sourceSubpath", visibility=["read", "create"])
    """The subpath to use when reading from the source Endpoint."""
    target_name: str = rest_field(name="targetName", visibility=["read", "create"])
    """The name of the target Endpoint. Required."""
    target_resource_id: Optional[str] = rest_field(name="targetResourceId", visibility=["read"])
    """Fully qualified resource ID of the target Endpoint."""
    target_subpath: Optional[str] = rest_field(name="targetSubpath", visibility=["read", "create"])
    """The subpath to use when writing to the target Endpoint."""
    latest_job_run_name: Optional[str] = rest_field(name="latestJobRunName", visibility=["read"])
    """The name of the Job Run in a non-terminal state, if exists."""
    latest_job_run_resource_id: Optional[str] = rest_field(name="latestJobRunResourceId", visibility=["read"])
    """The fully qualified resource ID of the Job Run in a non-terminal state, if exists."""
    latest_job_run_status: Optional[Union[str, "_models.JobRunStatus"]] = rest_field(
        name="latestJobRunStatus", visibility=["read"]
    )
    """The current status of the Job Run in a non-terminal state, if exists. Known values are:
     \"Queued\", \"Started\", \"Running\", \"CancelRequested\", \"Canceling\", \"Canceled\",
     \"Failed\", \"Succeeded\", and \"PausedByBandwidthManagement\"."""
    agent_name: Optional[str] = rest_field(name="agentName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the Agent to assign for new Job Runs of this Job Definition."""
    agent_resource_id: Optional[str] = rest_field(name="agentResourceId", visibility=["read"])
    """Fully qualified resource id of the Agent to assign for new Job Runs of this Job Definition."""
    source_target_map: Optional["_models.JobDefinitionPropertiesSourceTargetMap"] = rest_field(
        name="sourceTargetMap", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of cloud endpoints to migrate."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this resource. Known values are: \"Succeeded\", \"Canceled\",
     \"Failed\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        copy_mode: Union[str, "_models.CopyMode"],
        source_name: str,
        target_name: str,
        description: Optional[str] = None,
        job_type: Optional[Union[str, "_models.JobType"]] = None,
        source_subpath: Optional[str] = None,
        target_subpath: Optional[str] = None,
        agent_name: Optional[str] = None,
        source_target_map: Optional["_models.JobDefinitionPropertiesSourceTargetMap"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobDefinitionPropertiesSourceTargetMap(_Model):
    """JobDefinitionPropertiesSourceTargetMap.

    :ivar value:
    :vartype value: list[~azure.mgmt.storagemover.models.SourceTargetMap]
    """

    value: Optional[list["_models.SourceTargetMap"]] = rest_field(visibility=["read"])


class JobDefinitionUpdateParameters(_Model):
    """The Job Definition resource.

    :ivar properties: Job definition properties.
    :vartype properties: ~azure.mgmt.storagemover.models.JobDefinitionUpdateProperties
    """

    properties: Optional["_models.JobDefinitionUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Job definition properties."""

    __flattened_items = ["description", "copy_mode", "agent_name"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.JobDefinitionUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class JobDefinitionUpdateProperties(_Model):
    """Job definition properties.

    :ivar description: A description for the Job Definition.
    :vartype description: str
    :ivar copy_mode: Strategy to use for copy. Known values are: "Additive" and "Mirror".
    :vartype copy_mode: str or ~azure.mgmt.storagemover.models.CopyMode
    :ivar agent_name: Name of the Agent to assign for new Job Runs of this Job Definition.
    :vartype agent_name: str
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Job Definition."""
    copy_mode: Optional[Union[str, "_models.CopyMode"]] = rest_field(
        name="copyMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Strategy to use for copy. Known values are: \"Additive\" and \"Mirror\"."""
    agent_name: Optional[str] = rest_field(name="agentName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the Agent to assign for new Job Runs of this Job Definition."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        copy_mode: Optional[Union[str, "_models.CopyMode"]] = None,
        agent_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobRun(ProxyResource):
    """The Job Run resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar properties: Job run properties.
    :vartype properties: ~azure.mgmt.storagemover.models.JobRunProperties
    """

    properties: Optional["_models.JobRunProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Job run properties."""

    __flattened_items = [
        "status",
        "scan_status",
        "agent_name",
        "agent_resource_id",
        "execution_start_time",
        "execution_end_time",
        "last_status_update",
        "items_scanned",
        "items_excluded",
        "items_unsupported",
        "items_no_transfer_needed",
        "items_failed",
        "items_transferred",
        "bytes_scanned",
        "bytes_excluded",
        "bytes_unsupported",
        "bytes_no_transfer_needed",
        "bytes_failed",
        "bytes_transferred",
        "source_name",
        "source_resource_id",
        "source_properties",
        "target_name",
        "target_resource_id",
        "target_properties",
        "job_definition_properties",
        "error",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.JobRunProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class JobRunError(_Model):
    """Error type.

    :ivar code: Error code of the given entry.
    :vartype code: str
    :ivar message: Error message of the given entry.
    :vartype message: str
    :ivar target: Target of the given error entry.
    :vartype target: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code of the given entry."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message of the given entry."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target of the given error entry."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class JobRunProperties(_Model):
    """Job run properties.

    :ivar status: The state of the job execution. Known values are: "Queued", "Started", "Running",
     "CancelRequested", "Canceling", "Canceled", "Failed", "Succeeded", and
     "PausedByBandwidthManagement".
    :vartype status: str or ~azure.mgmt.storagemover.models.JobRunStatus
    :ivar scan_status: The status of Agent's scanning of source. Known values are: "NotStarted",
     "Scanning", and "Completed".
    :vartype scan_status: str or ~azure.mgmt.storagemover.models.JobRunScanStatus
    :ivar agent_name: Name of the Agent assigned to this run.
    :vartype agent_name: str
    :ivar agent_resource_id: Fully qualified resource id of the Agent assigned to this run.
    :vartype agent_resource_id: str
    :ivar execution_start_time: Start time of the run. Null if no Agent reported that the job has
     started.
    :vartype execution_start_time: ~datetime.datetime
    :ivar execution_end_time: End time of the run. Null if Agent has not reported that the job has
     ended.
    :vartype execution_end_time: ~datetime.datetime
    :ivar last_status_update: The last updated time of the Job Run.
    :vartype last_status_update: ~datetime.datetime
    :ivar items_scanned: Number of items scanned so far in source.
    :vartype items_scanned: int
    :ivar items_excluded: Number of items that will not be transferred, as they are excluded by
     user configuration.
    :vartype items_excluded: int
    :ivar items_unsupported: Number of items that will not be transferred, as they are unsupported
     on target.
    :vartype items_unsupported: int
    :ivar items_no_transfer_needed: Number of items that will not be transferred, as they are
     already found on target (e.g. mirror mode).
    :vartype items_no_transfer_needed: int
    :ivar items_failed: Number of items that were attempted to transfer and failed.
    :vartype items_failed: int
    :ivar items_transferred: Number of items successfully transferred to target.
    :vartype items_transferred: int
    :ivar bytes_scanned: Bytes of data scanned so far in source.
    :vartype bytes_scanned: int
    :ivar bytes_excluded: Bytes of data that will not be transferred, as they are excluded by user
     configuration.
    :vartype bytes_excluded: int
    :ivar bytes_unsupported: Bytes of data that will not be transferred, as they are unsupported on
     target.
    :vartype bytes_unsupported: int
    :ivar bytes_no_transfer_needed: Bytes of data that will not be transferred, as they are already
     found on target (e.g. mirror mode).
    :vartype bytes_no_transfer_needed: int
    :ivar bytes_failed: Bytes of data that were attempted to transfer and failed.
    :vartype bytes_failed: int
    :ivar bytes_transferred: Bytes of data successfully transferred to target.
    :vartype bytes_transferred: int
    :ivar source_name: Name of source Endpoint resource. This resource may no longer exist.
    :vartype source_name: str
    :ivar source_resource_id: Fully qualified resource id of source Endpoint. This id may no longer
     exist.
    :vartype source_resource_id: str
    :ivar source_properties: Copy of source Endpoint resource's properties at time of Job Run
     creation.
    :vartype source_properties: any
    :ivar target_name: Name of target Endpoint resource. This resource may no longer exist.
    :vartype target_name: str
    :ivar target_resource_id: Fully qualified resource id of of Endpoint. This id may no longer
     exist.
    :vartype target_resource_id: str
    :ivar target_properties: Copy of Endpoint resource's properties at time of Job Run creation.
    :vartype target_properties: any
    :ivar job_definition_properties: Copy of parent Job Definition's properties at time of Job Run
     creation.
    :vartype job_definition_properties: any
    :ivar error: Error details.
    :vartype error: ~azure.mgmt.storagemover.models.JobRunError
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    status: Optional[Union[str, "_models.JobRunStatus"]] = rest_field(visibility=["read"])
    """The state of the job execution. Known values are: \"Queued\", \"Started\", \"Running\",
     \"CancelRequested\", \"Canceling\", \"Canceled\", \"Failed\", \"Succeeded\", and
     \"PausedByBandwidthManagement\"."""
    scan_status: Optional[Union[str, "_models.JobRunScanStatus"]] = rest_field(name="scanStatus", visibility=["read"])
    """The status of Agent's scanning of source. Known values are: \"NotStarted\", \"Scanning\", and
     \"Completed\"."""
    agent_name: Optional[str] = rest_field(name="agentName", visibility=["read"])
    """Name of the Agent assigned to this run."""
    agent_resource_id: Optional[str] = rest_field(name="agentResourceId", visibility=["read"])
    """Fully qualified resource id of the Agent assigned to this run."""
    execution_start_time: Optional[datetime.datetime] = rest_field(
        name="executionStartTime", visibility=["read"], format="rfc3339"
    )
    """Start time of the run. Null if no Agent reported that the job has started."""
    execution_end_time: Optional[datetime.datetime] = rest_field(
        name="executionEndTime", visibility=["read"], format="rfc3339"
    )
    """End time of the run. Null if Agent has not reported that the job has ended."""
    last_status_update: Optional[datetime.datetime] = rest_field(
        name="lastStatusUpdate", visibility=["read"], format="rfc3339"
    )
    """The last updated time of the Job Run."""
    items_scanned: Optional[int] = rest_field(name="itemsScanned", visibility=["read"])
    """Number of items scanned so far in source."""
    items_excluded: Optional[int] = rest_field(name="itemsExcluded", visibility=["read"])
    """Number of items that will not be transferred, as they are excluded by user configuration."""
    items_unsupported: Optional[int] = rest_field(name="itemsUnsupported", visibility=["read"])
    """Number of items that will not be transferred, as they are unsupported on target."""
    items_no_transfer_needed: Optional[int] = rest_field(name="itemsNoTransferNeeded", visibility=["read"])
    """Number of items that will not be transferred, as they are already found on target (e.g. mirror
     mode)."""
    items_failed: Optional[int] = rest_field(name="itemsFailed", visibility=["read"])
    """Number of items that were attempted to transfer and failed."""
    items_transferred: Optional[int] = rest_field(name="itemsTransferred", visibility=["read"])
    """Number of items successfully transferred to target."""
    bytes_scanned: Optional[int] = rest_field(name="bytesScanned", visibility=["read"])
    """Bytes of data scanned so far in source."""
    bytes_excluded: Optional[int] = rest_field(name="bytesExcluded", visibility=["read"])
    """Bytes of data that will not be transferred, as they are excluded by user configuration."""
    bytes_unsupported: Optional[int] = rest_field(name="bytesUnsupported", visibility=["read"])
    """Bytes of data that will not be transferred, as they are unsupported on target."""
    bytes_no_transfer_needed: Optional[int] = rest_field(name="bytesNoTransferNeeded", visibility=["read"])
    """Bytes of data that will not be transferred, as they are already found on target (e.g. mirror
     mode)."""
    bytes_failed: Optional[int] = rest_field(name="bytesFailed", visibility=["read"])
    """Bytes of data that were attempted to transfer and failed."""
    bytes_transferred: Optional[int] = rest_field(name="bytesTransferred", visibility=["read"])
    """Bytes of data successfully transferred to target."""
    source_name: Optional[str] = rest_field(name="sourceName", visibility=["read"])
    """Name of source Endpoint resource. This resource may no longer exist."""
    source_resource_id: Optional[str] = rest_field(name="sourceResourceId", visibility=["read"])
    """Fully qualified resource id of source Endpoint. This id may no longer exist."""
    source_properties: Optional[Any] = rest_field(name="sourceProperties", visibility=["read"])
    """Copy of source Endpoint resource's properties at time of Job Run creation."""
    target_name: Optional[str] = rest_field(name="targetName", visibility=["read"])
    """Name of target Endpoint resource. This resource may no longer exist."""
    target_resource_id: Optional[str] = rest_field(name="targetResourceId", visibility=["read"])
    """Fully qualified resource id of of Endpoint. This id may no longer exist."""
    target_properties: Optional[Any] = rest_field(name="targetProperties", visibility=["read"])
    """Copy of Endpoint resource's properties at time of Job Run creation."""
    job_definition_properties: Optional[Any] = rest_field(name="jobDefinitionProperties", visibility=["read"])
    """Copy of parent Job Definition's properties at time of Job Run creation."""
    error: Optional["_models.JobRunError"] = rest_field(visibility=["read"])
    """Error details."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this resource. Known values are: \"Succeeded\", \"Canceled\",
     \"Failed\", and \"Deleting\"."""


class JobRunResourceId(_Model):
    """Response that identifies a Job Run.

    :ivar job_run_resource_id: Fully qualified resource id of the Job Run.
    :vartype job_run_resource_id: str
    """

    job_run_resource_id: Optional[str] = rest_field(name="jobRunResourceId", visibility=["read"])
    """Fully qualified resource id of the Job Run."""


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.storagemover.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.storagemover.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NfsMountEndpointProperties(EndpointBaseProperties, discriminator="NfsMount"):
    """The properties of NFS share endpoint.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar host: The host name or IP address of the server exporting the file system. Required.
    :vartype host: str
    :ivar nfs_version: The NFS protocol version. Known values are: "NFSauto", "NFSv3", and "NFSv4".
    :vartype nfs_version: str or ~azure.mgmt.storagemover.models.NfsVersion
    :ivar export: The directory being exported from the server. Required.
    :vartype export: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.NFS_MOUNT
    """

    host: str = rest_field(visibility=["read", "create"])
    """The host name or IP address of the server exporting the file system. Required."""
    nfs_version: Optional[Union[str, "_models.NfsVersion"]] = rest_field(
        name="nfsVersion", visibility=["read", "create"]
    )
    """The NFS protocol version. Known values are: \"NFSauto\", \"NFSv3\", and \"NFSv4\"."""
    export: str = rest_field(visibility=["read", "create"])
    """The directory being exported from the server. Required."""
    endpoint_type: Literal[EndpointType.NFS_MOUNT] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        host: str,
        export: str,
        description: Optional[str] = None,
        nfs_version: Optional[Union[str, "_models.NfsVersion"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.NFS_MOUNT, **kwargs)


class NfsMountEndpointUpdateProperties(EndpointBaseUpdateProperties, discriminator="NfsMount"):
    """NfsMountEndpointUpdateProperties.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.NFS_MOUNT
    """

    endpoint_type: Literal[EndpointType.NFS_MOUNT] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.NFS_MOUNT, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.storagemover.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.storagemover.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.storagemover.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Project(ProxyResource):
    """The Project resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar properties: Project properties.
    :vartype properties: ~azure.mgmt.storagemover.models.ProjectProperties
    """

    properties: Optional["_models.ProjectProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Project properties."""

    __flattened_items = ["description", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ProjectProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ProjectProperties(_Model):
    """Project properties.

    :ivar description: A description for the Project.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Project."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this resource. Known values are: \"Succeeded\", \"Canceled\",
     \"Failed\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProjectUpdateParameters(_Model):
    """The Project resource.

    :ivar properties: Project properties.
    :vartype properties: ~azure.mgmt.storagemover.models.ProjectUpdateProperties
    """

    properties: Optional["_models.ProjectUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Project properties."""

    __flattened_items = ["description"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ProjectUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ProjectUpdateProperties(_Model):
    """Project properties.

    :ivar description: A description for the Project.
    :vartype description: str
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Project."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Recurrence(_Model):
    """The schedule recurrence.

    :ivar start_time: The start time of the schedule recurrence. Full hour and 30-minute intervals
     are supported. Required.
    :vartype start_time: ~azure.mgmt.storagemover.models.Time
    :ivar end_time: The end time of the schedule recurrence. Full hour and 30-minute intervals are
     supported. Required.
    :vartype end_time: ~azure.mgmt.storagemover.models.Time
    """

    start_time: "_models.Time" = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The start time of the schedule recurrence. Full hour and 30-minute intervals are supported.
     Required."""
    end_time: "_models.Time" = rest_field(name="endTime", visibility=["read", "create", "update", "delete", "query"])
    """The end time of the schedule recurrence. Full hour and 30-minute intervals are supported.
     Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: "_models.Time",
        end_time: "_models.Time",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SmbMountEndpointProperties(EndpointBaseProperties, discriminator="SmbMount"):
    """The properties of SMB share endpoint.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    :ivar host: The host name or IP address of the server exporting the file system. Required.
    :vartype host: str
    :ivar share_name: The name of the SMB share being exported from the server. Required.
    :vartype share_name: str
    :ivar credentials: The Azure Key Vault secret URIs which store the required credentials to
     access the SMB share.
    :vartype credentials: ~azure.mgmt.storagemover.models.AzureKeyVaultSmbCredentials
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.SMB_MOUNT
    """

    host: str = rest_field(visibility=["read", "create"])
    """The host name or IP address of the server exporting the file system. Required."""
    share_name: str = rest_field(name="shareName", visibility=["read", "create"])
    """The name of the SMB share being exported from the server. Required."""
    credentials: Optional["_models.AzureKeyVaultSmbCredentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Key Vault secret URIs which store the required credentials to access the SMB share."""
    endpoint_type: Literal[EndpointType.SMB_MOUNT] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        host: str,
        share_name: str,
        description: Optional[str] = None,
        credentials: Optional["_models.AzureKeyVaultSmbCredentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.SMB_MOUNT, **kwargs)


class SmbMountEndpointUpdateProperties(EndpointBaseUpdateProperties, discriminator="SmbMount"):
    """The properties of SMB share endpoint to update.

    :ivar description: A description for the Endpoint.
    :vartype description: str
    :ivar credentials: The Azure Key Vault secret URIs which store the required credentials to
     access the SMB share.
    :vartype credentials: ~azure.mgmt.storagemover.models.AzureKeyVaultSmbCredentials
    :ivar endpoint_type: The Endpoint resource type. Required.
    :vartype endpoint_type: str or ~azure.mgmt.storagemover.models.SMB_MOUNT
    """

    credentials: Optional["_models.AzureKeyVaultSmbCredentials"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Key Vault secret URIs which store the required credentials to access the SMB share."""
    endpoint_type: Literal[EndpointType.SMB_MOUNT] = rest_discriminator(name="endpointType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Endpoint resource type. Required."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        credentials: Optional["_models.AzureKeyVaultSmbCredentials"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, endpoint_type=EndpointType.SMB_MOUNT, **kwargs)


class SourceEndpoint(_Model):
    """The source endpoint resource for source and target mapping.

    :ivar properties: The properties of the cloud source endpoint to migrate.
    :vartype properties: ~azure.mgmt.storagemover.models.SourceEndpointProperties
    """

    properties: Optional["_models.SourceEndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the cloud source endpoint to migrate."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SourceEndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceEndpointProperties(_Model):
    """The properties of the cloud source endpoint to migrate.

    :ivar name: The name of the cloud source endpoint to migrate.
    :vartype name: str
    :ivar source_endpoint_resource_id: The fully qualified ARM resource ID of the cloud source
     endpoint to migrate.
    :vartype source_endpoint_resource_id: str
    :ivar aws_s3_bucket_id: The fully qualified ARM resource ID of the AWS S3 bucket to migrate.
    :vartype aws_s3_bucket_id: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the cloud source endpoint to migrate."""
    source_endpoint_resource_id: Optional[str] = rest_field(
        name="sourceEndpointResourceId", visibility=["read", "create"]
    )
    """The fully qualified ARM resource ID of the cloud source endpoint to migrate."""
    aws_s3_bucket_id: Optional[str] = rest_field(name="awsS3BucketId", visibility=["read", "create"])
    """The fully qualified ARM resource ID of the AWS S3 bucket to migrate."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        source_endpoint_resource_id: Optional[str] = None,
        aws_s3_bucket_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceTargetMap(_Model):
    """The properties of cloud endpoints to migrate.

    :ivar source_endpoint: Required.
    :vartype source_endpoint: ~azure.mgmt.storagemover.models.SourceEndpoint
    :ivar target_endpoint: Required.
    :vartype target_endpoint: ~azure.mgmt.storagemover.models.TargetEndpoint
    """

    source_endpoint: "_models.SourceEndpoint" = rest_field(
        name="sourceEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    target_endpoint: "_models.TargetEndpoint" = rest_field(
        name="targetEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        source_endpoint: "_models.SourceEndpoint",
        target_endpoint: "_models.TargetEndpoint",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageMover(TrackedResource):
    """The Storage Mover resource, which is a container for a group of Agents, Projects, and
    Endpoints.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.storagemover.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource specific properties for the Storage Mover resource.
    :vartype properties: ~azure.mgmt.storagemover.models.StorageMoverProperties
    """

    properties: Optional["_models.StorageMoverProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource specific properties for the Storage Mover resource."""

    __flattened_items = ["description", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.StorageMoverProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class StorageMoverProperties(_Model):
    """The resource specific properties for the Storage Mover resource.

    :ivar description: A description for the Storage Mover.
    :vartype description: str
    :ivar provisioning_state: The provisioning state of this resource. Known values are:
     "Succeeded", "Canceled", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.storagemover.models.ProvisioningState
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Storage Mover."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of this resource. Known values are: \"Succeeded\", \"Canceled\",
     \"Failed\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageMoverUpdateParameters(_Model):
    """The Storage Mover resource.

    :ivar properties: The resource specific properties for the Storage Mover resource.
    :vartype properties: ~azure.mgmt.storagemover.models.StorageMoverUpdateProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.StorageMoverUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource specific properties for the Storage Mover resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    __flattened_items = ["description"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StorageMoverUpdateProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class StorageMoverUpdateProperties(_Model):
    """The resource specific properties for the Storage Mover resource.

    :ivar description: A description for the Storage Mover.
    :vartype description: str
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description for the Storage Mover."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storagemover.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storagemover.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetEndpoint(_Model):
    """The target endpoint resource for source and target mapping.

    :ivar properties: The properties of the cloud target endpoint to migrate.
    :vartype properties: ~azure.mgmt.storagemover.models.TargetEndpointProperties
    """

    properties: Optional["_models.TargetEndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the cloud target endpoint to migrate."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.TargetEndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetEndpointProperties(_Model):
    """The properties of the cloud target endpoint to migrate.

    :ivar name: The name of the cloud target endpoint to migrate.
    :vartype name: str
    :ivar target_endpoint_resource_id: The fully qualified ARM resource ID of the cloud target
     endpoint to migrate.
    :vartype target_endpoint_resource_id: str
    :ivar azure_storage_account_resource_id: The fully qualified ARM resource ID of the Azure
     Storage account.
    :vartype azure_storage_account_resource_id: str
    :ivar azure_storage_blob_container_name: The name of the Azure Storage blob container.
    :vartype azure_storage_blob_container_name: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the cloud target endpoint to migrate."""
    target_endpoint_resource_id: Optional[str] = rest_field(
        name="targetEndpointResourceId", visibility=["read", "create"]
    )
    """The fully qualified ARM resource ID of the cloud target endpoint to migrate."""
    azure_storage_account_resource_id: Optional[str] = rest_field(
        name="azureStorageAccountResourceId", visibility=["read", "create"]
    )
    """The fully qualified ARM resource ID of the Azure Storage account."""
    azure_storage_blob_container_name: Optional[str] = rest_field(
        name="azureStorageBlobContainerName", visibility=["read", "create"]
    )
    """The name of the Azure Storage blob container."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        target_endpoint_resource_id: Optional[str] = None,
        azure_storage_account_resource_id: Optional[str] = None,
        azure_storage_blob_container_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Time(_Model):
    """The time of day.

    :ivar hour: The hour element of the time. Allowed values range from 0 (start of the selected
     day) to 24 (end of the selected day). Hour value 24 cannot be combined with any other minute
     value but 0. Required.
    :vartype hour: int
    :ivar minute: The minute element of the time. Allowed values are 0 and 30. If not specified,
     its value defaults to 0. Known values are: 0 and 30.
    :vartype minute: int or ~azure.mgmt.storagemover.models.Minute
    """

    hour: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The hour element of the time. Allowed values range from 0 (start of the selected day) to 24
     (end of the selected day). Hour value 24 cannot be combined with any other minute value but 0.
     Required."""
    minute: Optional[Union[int, "_models.Minute"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The minute element of the time. Allowed values are 0 and 30. If not specified, its value
     defaults to 0. Known values are: 0 and 30."""

    @overload
    def __init__(
        self,
        *,
        hour: int,
        minute: Optional[Union[int, "_models.Minute"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UploadLimitSchedule(_Model):
    """The WAN-link upload limit schedule. Overlapping recurrences are not allowed.

    :ivar weekly_recurrences: The set of weekly repeating recurrences of the WAN-link upload limit
     schedule.
    :vartype weekly_recurrences: list[~azure.mgmt.storagemover.models.UploadLimitWeeklyRecurrence]
    """

    weekly_recurrences: Optional[list["_models.UploadLimitWeeklyRecurrence"]] = rest_field(
        name="weeklyRecurrences", visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of weekly repeating recurrences of the WAN-link upload limit schedule."""

    @overload
    def __init__(
        self,
        *,
        weekly_recurrences: Optional[list["_models.UploadLimitWeeklyRecurrence"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WeeklyRecurrence(Recurrence):
    """The weekly recurrence of the schedule.

    :ivar start_time: The start time of the schedule recurrence. Full hour and 30-minute intervals
     are supported. Required.
    :vartype start_time: ~azure.mgmt.storagemover.models.Time
    :ivar end_time: The end time of the schedule recurrence. Full hour and 30-minute intervals are
     supported. Required.
    :vartype end_time: ~azure.mgmt.storagemover.models.Time
    :ivar days: The set of days of week for the schedule recurrence. A day must not be specified
     more than once in a recurrence. Required.
    :vartype days: list[str or ~azure.mgmt.storagemover.models.DayOfWeek]
    """

    days: list[Union[str, "_models.DayOfWeek"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The set of days of week for the schedule recurrence. A day must not be specified more than once
     in a recurrence. Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: "_models.Time",
        end_time: "_models.Time",
        days: list[Union[str, "_models.DayOfWeek"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UploadLimitWeeklyRecurrence(WeeklyRecurrence):
    """The weekly recurrence of the WAN-link upload limit schedule. The start time must be earlier in
    the day than the end time. The recurrence must not span across multiple days.

    :ivar start_time: The start time of the schedule recurrence. Full hour and 30-minute intervals
     are supported. Required.
    :vartype start_time: ~azure.mgmt.storagemover.models.Time
    :ivar end_time: The end time of the schedule recurrence. Full hour and 30-minute intervals are
     supported. Required.
    :vartype end_time: ~azure.mgmt.storagemover.models.Time
    :ivar days: The set of days of week for the schedule recurrence. A day must not be specified
     more than once in a recurrence. Required.
    :vartype days: list[str or ~azure.mgmt.storagemover.models.DayOfWeek]
    :ivar limit_in_mbps: The WAN-link upload bandwidth (maximum data transfer rate) in megabits per
     second. Value of 0 indicates no throughput is allowed and any running migration job is
     effectively paused for the duration of this recurrence. Only data plane operations are governed
     by this limit. Control plane operations ensure seamless functionality. The agent may exceed
     this limit with control messages, if necessary. Required.
    :vartype limit_in_mbps: int
    """

    limit_in_mbps: int = rest_field(name="limitInMbps", visibility=["read", "create", "update", "delete", "query"])
    """The WAN-link upload bandwidth (maximum data transfer rate) in megabits per second. Value of 0
     indicates no throughput is allowed and any running migration job is effectively paused for the
     duration of this recurrence. Only data plane operations are governed by this limit. Control
     plane operations ensure seamless functionality. The agent may exceed this limit with control
     messages, if necessary. Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: "_models.Time",
        end_time: "_models.Time",
        days: list[Union[str, "_models.DayOfWeek"]],
        limit_in_mbps: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
