# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python update_io_tsecurity_solution.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="20ff7fc3-e762-44dd-bd96-b71116dcdc23",
    )

    response = client.iot_security_solution.update(
        resource_group_name="myRg",
        solution_name="default",
        update_iot_security_solution_data={
            "properties": {
                "recommendationsConfiguration": [
                    {"recommendationType": "IoT_OpenPorts", "status": "Disabled"},
                    {"recommendationType": "IoT_SharedCredentials", "status": "Disabled"},
                ],
                "userDefinedResources": {
                    "query": 'where type != "microsoft.devices/iothubs" | where name contains "v2"',
                    "querySubscriptions": ["075423e9-7d33-4166-8bdf-3920b04e3735"],
                },
            },
            "tags": {"foo": "bar"},
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/UpdateIoTSecuritySolution.json
if __name__ == "__main__":
    main()
