# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery.aio import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationJobsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_jobs_list(self, resource_group):
        response = self.client.replication_jobs.list(
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_jobs_get(self, resource_group):
        response = await self.client.replication_jobs.get(
            job_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_jobs_begin_cancel(self, resource_group):
        response = await (
            await self.client.replication_jobs.begin_cancel(
                job_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_jobs_begin_restart(self, resource_group):
        response = await (
            await self.client.replication_jobs.begin_restart(
                job_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_jobs_begin_resume(self, resource_group):
        response = await (
            await self.client.replication_jobs.begin_resume(
                job_name="str",
                resume_job_params={"properties": {"comments": "str"}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_jobs_begin_export(self, resource_group):
        response = await (
            await self.client.replication_jobs.begin_export(
                job_query_parameter={
                    "affectedObjectTypes": "str",
                    "endTime": "str",
                    "fabricId": "str",
                    "jobName": "str",
                    "jobOutputType": "str",
                    "jobStatus": "str",
                    "startTime": "str",
                    "timezoneOffset": 0.0,
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
