# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
import datetime
from typing import Any, Callable, Dict, Literal, Optional, TypeVar, Union

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._configuration import PolicyInsightsClientConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_query_results_for_management_group_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    management_group_name: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
        "management_groups_namespace", "Microsoft.Management"
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "managementGroupsNamespace": _SERIALIZER.url("management_groups_namespace", management_groups_namespace, "str"),
        "managementGroupName": _SERIALIZER.url("management_group_name", management_group_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_subscription_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    subscription_id: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_resource_group_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    subscription_id: str,
    resource_group_name: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_resource_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    resource_id: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    expand: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{resourceId}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "resourceId": _SERIALIZER.url("resource_id", resource_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_policy_set_definition_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    subscription_id: str,
    policy_set_definition_name: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
        "authorization_namespace", "Microsoft.Authorization"
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "authorizationNamespace": _SERIALIZER.url("authorization_namespace", authorization_namespace, "str"),
        "policySetDefinitionName": _SERIALIZER.url("policy_set_definition_name", policy_set_definition_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_policy_definition_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    subscription_id: str,
    policy_definition_name: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
        "authorization_namespace", "Microsoft.Authorization"
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "authorizationNamespace": _SERIALIZER.url("authorization_namespace", authorization_namespace, "str"),
        "policyDefinitionName": _SERIALIZER.url("policy_definition_name", policy_definition_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_subscription_level_policy_assignment_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    subscription_id: str,
    policy_assignment_name: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
        "authorization_namespace", "Microsoft.Authorization"
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "authorizationNamespace": _SERIALIZER.url("authorization_namespace", authorization_namespace, "str"),
        "policyAssignmentName": _SERIALIZER.url("policy_assignment_name", policy_assignment_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_query_results_for_resource_group_level_policy_assignment_request(  # pylint: disable=name-too-long
    policy_events_resource: Union[str, _models.PolicyEventsResourceType],
    subscription_id: str,
    resource_group_name: str,
    policy_assignment_name: str,
    *,
    top: Optional[int] = None,
    order_by: Optional[str] = None,
    select: Optional[str] = None,
    from_property: Optional[datetime.datetime] = None,
    to: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    apply: Optional[str] = None,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
        "authorization_namespace", "Microsoft.Authorization"
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyEvents/{policyEventsResource}/queryResults",
    )
    path_format_arguments = {
        "policyEventsResource": _SERIALIZER.url("policy_events_resource", policy_events_resource, "str"),
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "authorizationNamespace": _SERIALIZER.url("authorization_namespace", authorization_namespace, "str"),
        "policyAssignmentName": _SERIALIZER.url("policy_assignment_name", policy_assignment_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int", minimum=0)
    if order_by is not None:
        _params["$orderby"] = _SERIALIZER.query("order_by", order_by, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")
    if from_property is not None:
        _params["$from"] = _SERIALIZER.query("from_property", from_property, "iso-8601")
    if to is not None:
        _params["$to"] = _SERIALIZER.query("to", to, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if apply is not None:
        _params["$apply"] = _SERIALIZER.query("apply", apply, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_next_link_request(next_link: str, *, skip_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{nextLink}")
    path_format_arguments = {
        "nextLink": _SERIALIZER.url("next_link", next_link, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skiptoken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class PolicyEventsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.policyinsights.PolicyInsightsClient`'s
        :attr:`policy_events` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PolicyInsightsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_query_results_for_management_group(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        management_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resources under the management group.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param management_group_name: Management group name. Required.
        :type management_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
            "management_groups_namespace", "Microsoft.Management"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_management_group_request(
                    policy_events_resource=policy_events_resource,
                    management_group_name=management_group_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    management_groups_namespace=management_groups_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_subscription(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resources under the subscription.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource_group(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        resource_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resources under the resource group.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        resource_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resource.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param resource_id: Resource ID. Required.
        :type resource_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _expand = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _expand = query_options.expand
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_request(
                    policy_events_resource=policy_events_resource,
                    resource_id=resource_id,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    expand=_expand,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _expand = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _expand = query_options.expand
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_policy_set_definition(  # pylint: disable=name-too-long
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        policy_set_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the subscription level policy set definition.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name. Required.
        :type policy_set_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_policy_set_definition_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    policy_set_definition_name=policy_set_definition_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_policy_definition(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        policy_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the subscription level policy definition.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name. Required.
        :type policy_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_policy_definition_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    policy_definition_name=policy_definition_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_subscription_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the subscription level policy assignment.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_level_policy_assignment_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    policy_assignment_name=policy_assignment_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource_group_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        resource_group_name: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resource group level policy assignment.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_level_policy_assignment_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    policy_assignment_name=policy_assignment_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
