# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtOracleSubscriptionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_list_by_subscription(self, resource_group):
        response = self.client.oracle_subscriptions.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_create_or_update(self, resource_group):
        response = self.client.oracle_subscriptions.begin_create_or_update(
            resource={
                "id": "str",
                "name": "str",
                "plan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str", "version": "str"},
                "properties": {
                    "addSubscriptionOperationState": "str",
                    "azureSubscriptionIds": ["str"],
                    "cloudAccountId": "str",
                    "cloudAccountState": "str",
                    "intent": "str",
                    "lastOperationStatusDetail": "str",
                    "productCode": "str",
                    "provisioningState": "str",
                    "saasSubscriptionId": "str",
                    "termUnit": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_get(self, resource_group):
        response = self.client.oracle_subscriptions.get()

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_update(self, resource_group):
        response = self.client.oracle_subscriptions.begin_update(
            properties={
                "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str", "version": "str"},
                "properties": {"intent": "str", "productCode": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_delete(self, resource_group):
        response = (
            self.client.oracle_subscriptions.begin_delete().result()
        )  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_list_cloud_account_details(self, resource_group):
        response = (
            self.client.oracle_subscriptions.begin_list_cloud_account_details().result()
        )  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_list_saas_subscription_details(self, resource_group):
        response = (
            self.client.oracle_subscriptions.begin_list_saas_subscription_details().result()
        )  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_list_activation_links(self, resource_group):
        response = (
            self.client.oracle_subscriptions.begin_list_activation_links().result()
        )  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_oracle_subscriptions_begin_add_azure_subscriptions(self, resource_group):
        response = self.client.oracle_subscriptions.begin_add_azure_subscriptions(
            body={"azureSubscriptionIds": ["str"]},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
