# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.networkcloud import NetworkCloudMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkCloudMgmtBareMetalMachineKeySetsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkCloudMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bare_metal_machine_key_sets_list_by_cluster(self, resource_group):
        response = self.client.bare_metal_machine_key_sets.list_by_cluster(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2025-07-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bare_metal_machine_key_sets_get(self, resource_group):
        response = self.client.bare_metal_machine_key_sets.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            bare_metal_machine_key_set_name="str",
            api_version="2025-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bare_metal_machine_key_sets_begin_create_or_update(self, resource_group):
        response = self.client.bare_metal_machine_key_sets.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            bare_metal_machine_key_set_name="str",
            bare_metal_machine_key_set_parameters={
                "azureGroupId": "str",
                "expiration": "2020-02-20 00:00:00",
                "extendedLocation": {"name": "str", "type": "str"},
                "jumpHostsAllowed": ["str"],
                "location": "str",
                "privilegeLevel": "str",
                "userList": [
                    {
                        "azureUserName": "str",
                        "sshPublicKey": {"keyData": "str"},
                        "description": "str",
                        "userPrincipalName": "str",
                    }
                ],
                "detailedStatus": "str",
                "detailedStatusMessage": "str",
                "etag": "str",
                "id": "str",
                "lastValidation": "2020-02-20 00:00:00",
                "name": "str",
                "osGroupName": "str",
                "privilegeLevelName": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "userListStatus": [{"azureUserName": "str", "status": "str", "statusMessage": "str"}],
            },
            api_version="2025-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bare_metal_machine_key_sets_begin_delete(self, resource_group):
        response = self.client.bare_metal_machine_key_sets.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            bare_metal_machine_key_set_name="str",
            api_version="2025-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_bare_metal_machine_key_sets_begin_update(self, resource_group):
        response = self.client.bare_metal_machine_key_sets.begin_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            bare_metal_machine_key_set_name="str",
            api_version="2025-07-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
