# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementVpnConnectionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vpn_connections_get(self, resource_group):
        response = await self.client.vpn_connections.get(
            resource_group_name=resource_group.name,
            gateway_name="str",
            connection_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vpn_connections_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.vpn_connections.begin_create_or_update(
                resource_group_name=resource_group.name,
                gateway_name="str",
                connection_name="str",
                vpn_connection_parameters={
                    "connectionBandwidth": 0,
                    "connectionStatus": "str",
                    "dpdTimeoutSeconds": 0,
                    "egressBytesTransferred": 0,
                    "enableBgp": bool,
                    "enableInternetSecurity": bool,
                    "enableRateLimiting": bool,
                    "etag": "str",
                    "id": "str",
                    "ingressBytesTransferred": 0,
                    "ipsecPolicies": [
                        {
                            "dhGroup": "str",
                            "ikeEncryption": "str",
                            "ikeIntegrity": "str",
                            "ipsecEncryption": "str",
                            "ipsecIntegrity": "str",
                            "pfsGroup": "str",
                            "saDataSizeKilobytes": 0,
                            "saLifeTimeSeconds": 0,
                        }
                    ],
                    "name": "str",
                    "provisioningState": "str",
                    "remoteVpnSite": {"id": "str"},
                    "routingConfiguration": {
                        "associatedRouteTable": {"id": "str"},
                        "inboundRouteMap": {"id": "str"},
                        "outboundRouteMap": {"id": "str"},
                        "propagatedRouteTables": {"ids": [{"id": "str"}], "labels": ["str"]},
                        "vnetRoutes": {
                            "bgpConnections": [{"id": "str"}],
                            "staticRoutes": [{"addressPrefixes": ["str"], "name": "str", "nextHopIpAddress": "str"}],
                            "staticRoutesConfig": {
                                "propagateStaticRoutes": bool,
                                "vnetLocalRouteOverrideCriteria": "str",
                            },
                        },
                    },
                    "routingWeight": 0,
                    "sharedKey": "str",
                    "trafficSelectorPolicies": [{"localAddressRanges": ["str"], "remoteAddressRanges": ["str"]}],
                    "useLocalAzureIpAddress": bool,
                    "usePolicyBasedTrafficSelectors": bool,
                    "vpnConnectionProtocolType": "str",
                    "vpnLinkConnections": [
                        {
                            "connectionBandwidth": 0,
                            "connectionStatus": "str",
                            "dpdTimeoutSeconds": 0,
                            "egressBytesTransferred": 0,
                            "egressNatRules": [{"id": "str"}],
                            "enableBgp": bool,
                            "enableRateLimiting": bool,
                            "etag": "str",
                            "id": "str",
                            "ingressBytesTransferred": 0,
                            "ingressNatRules": [{"id": "str"}],
                            "ipsecPolicies": [
                                {
                                    "dhGroup": "str",
                                    "ikeEncryption": "str",
                                    "ikeIntegrity": "str",
                                    "ipsecEncryption": "str",
                                    "ipsecIntegrity": "str",
                                    "pfsGroup": "str",
                                    "saDataSizeKilobytes": 0,
                                    "saLifeTimeSeconds": 0,
                                }
                            ],
                            "name": "str",
                            "provisioningState": "str",
                            "routingWeight": 0,
                            "sharedKey": "str",
                            "type": "str",
                            "useLocalAzureIpAddress": bool,
                            "usePolicyBasedTrafficSelectors": bool,
                            "vpnConnectionProtocolType": "str",
                            "vpnGatewayCustomBgpAddresses": [{"customBgpIpAddress": "str", "ipConfigurationId": "str"}],
                            "vpnLinkConnectionMode": "str",
                            "vpnSiteLink": {"id": "str"},
                        }
                    ],
                },
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vpn_connections_begin_delete(self, resource_group):
        response = await (
            await self.client.vpn_connections.begin_delete(
                resource_group_name=resource_group.name,
                gateway_name="str",
                connection_name="str",
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vpn_connections_begin_start_packet_capture(self, resource_group):
        response = await (
            await self.client.vpn_connections.begin_start_packet_capture(
                resource_group_name=resource_group.name,
                gateway_name="str",
                vpn_connection_name="str",
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vpn_connections_begin_stop_packet_capture(self, resource_group):
        response = await (
            await self.client.vpn_connections.begin_stop_packet_capture(
                resource_group_name=resource_group.name,
                gateway_name="str",
                vpn_connection_name="str",
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vpn_connections_list_by_vpn_gateway(self, resource_group):
        response = self.client.vpn_connections.list_by_vpn_gateway(
            resource_group_name=resource_group.name,
            gateway_name="str",
            api_version="2025-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
