# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import RadiologyInsightsInferenceType

if TYPE_CHECKING:
    from .. import models as _models


class RadiologyInsightsInference(_Model):
    """An inference made by the Radiology Insights model regarding a patient.

    * AgeMismatch
    * SexMismatch
    * LateralityDiscrepancy
    * CompleteOrderDiscrepancy
    * LimitedOrderDiscrepancy
    * Finding
    * CriticalResult
    * FollowupRecommendation
    * RadiologyProcedure
    * FollowupCommunication.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgeMismatchInference, CompleteOrderDiscrepancyInference, CriticalResultInference,
    FindingInference, FollowupCommunicationInference, FollowupRecommendationInference,
    GuidanceInference, LateralityDiscrepancyInference, LimitedOrderDiscrepancyInference,
    QualityMeasureInference, RadiologyProcedureInference, ScoringAndAssessmentInference,
    SexMismatchInference

    :ivar kind: Discriminator property for RadiologyInsightsInference. Required. Known values are:
     "ageMismatch", "lateralityDiscrepancy", "sexMismatch", "completeOrderDiscrepancy",
     "limitedOrderDiscrepancy", "finding", "criticalResult", "followupRecommendation",
     "followupCommunication", "radiologyProcedure", "scoringAndAssessment", "guidance", and
     "qualityMeasure".
    :vartype kind: str or
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceType
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    __mapping__: Dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Discriminator property for RadiologyInsightsInference. Required. Known values are:
     \"ageMismatch\", \"lateralityDiscrepancy\", \"sexMismatch\", \"completeOrderDiscrepancy\",
     \"limitedOrderDiscrepancy\", \"finding\", \"criticalResult\", \"followupRecommendation\",
     \"followupCommunication\", \"radiologyProcedure\", \"scoringAndAssessment\", \"guidance\", and
     \"qualityMeasure\"."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgeMismatchInference(RadiologyInsightsInference, discriminator="ageMismatch"):
    """A notification for age mismatch is displayed when the age mentioned in a document for a
    specific patient does not match the age specified in the patient information.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Age mismatch inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.AGE_MISMATCH
    """

    kind: Literal[RadiologyInsightsInferenceType.AGE_MISMATCH] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Age mismatch inference type"""

    @overload
    def __init__(
        self,
        *,
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.AGE_MISMATCH, **kwargs)


class Element(_Model):
    """The base definition for all elements contained inside a resource.
    Based on `FHIR Element <https://www.hl7.org/fhir/R4/element.html>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique id for inter-element referencing."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Annotation(Element):
    """A text note which also  contains information about who made the statement and when
    Based on `FHIR Annotation <https://www.hl7.org/fhir/R4/datatypes.html#Annotation>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar author_string: Individual responsible for the annotation.
    :vartype author_string: str
    :ivar time: When the annotation was made.
    :vartype time: str
    :ivar text: The annotation - text content (as markdown). Required.
    :vartype text: str
    """

    author_string: Optional[str] = rest_field(
        name="authorString", visibility=["read", "create", "update", "delete", "query"]
    )
    """Individual responsible for the annotation."""
    time: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """When the annotation was made."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The annotation - text content (as markdown). Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        author_string: Optional[str] = None,
        time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AssessmentValueRange(_Model):
    """A range of values.

    :ivar minimum: The minimum value. Required.
    :vartype minimum: str
    :ivar maximum: The maximum value. Required.
    :vartype maximum: str
    """

    minimum: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The minimum value. Required."""
    maximum: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The maximum value. Required."""

    @overload
    def __init__(
        self,
        *,
        minimum: str,
        maximum: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeableConcept(Element):
    """Concept - reference to a terminology or just text
    Based on `FHIR CodeableConcept <https://www.hl7.org/fhir/R4/datatypes.html#CodeableConcept>`_.

    :ivar coding: Code defined by a terminology system.
    :vartype coding: list[~azure.healthinsights.radiologyinsights.models.Coding]
    :ivar text: Plain text representation of the concept.
    :vartype text: str
    """

    coding: Optional[List["_models.Coding"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Code defined by a terminology system."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Plain text representation of the concept."""

    @overload
    def __init__(
        self,
        *,
        coding: Optional[List["_models.Coding"]] = None,
        text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Coding(Element):
    """A Coding is a representation of a defined concept using a symbol from a defined "code system".
    Based on `FHIR Coding <https://www.hl7.org/fhir/R4/datatypes.html#Coding>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar system: Identity of the terminology system.
    :vartype system: str
    :ivar version: Version of the system - if relevant.
    :vartype version: str
    :ivar code: Symbol in syntax defined by the system.
    :vartype code: str
    :ivar display: Representation defined by the system.
    :vartype display: str
    """

    system: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Identity of the terminology system."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of the system - if relevant."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Symbol in syntax defined by the system."""
    display: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Representation defined by the system."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        system: Optional[str] = None,
        version: Optional[str] = None,
        code: Optional[str] = None,
        display: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CompleteOrderDiscrepancyInference(RadiologyInsightsInference, discriminator="completeOrderDiscrepancy"):
    """A complete order discrepancy is shown when one or more body parts and/or measurements that
    should be in the document (because there is a complete order) are not present.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Complete order discrepancy inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.COMPLETE_ORDER_DISCREPANCY
    :ivar order_type: Order type : CPT ultrasound complete code for abdomen, retroperitoneal,
     pelvis or breast. Required.
    :vartype order_type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar missing_body_parts: List of missing body parts required by a complete order : SNOMED CT
     codes.
    :vartype missing_body_parts:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar missing_body_part_measurements: List of missing body parts that require measurement by a
     complete order : SNOMED CT codes.
    :vartype missing_body_part_measurements:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    """

    kind: Literal[RadiologyInsightsInferenceType.COMPLETE_ORDER_DISCREPANCY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Complete order discrepancy inference type"""
    order_type: "_models.CodeableConcept" = rest_field(
        name="orderType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Order type : CPT ultrasound complete code for abdomen, retroperitoneal, pelvis or breast.
     Required."""
    missing_body_parts: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="missingBodyParts", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of missing body parts required by a complete order : SNOMED CT codes."""
    missing_body_part_measurements: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="missingBodyPartMeasurements", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of missing body parts that require measurement by a complete order : SNOMED CT codes."""

    @overload
    def __init__(
        self,
        *,
        order_type: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
        missing_body_parts: Optional[List["_models.CodeableConcept"]] = None,
        missing_body_part_measurements: Optional[List["_models.CodeableConcept"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.COMPLETE_ORDER_DISCREPANCY, **kwargs)


class CriticalResult(_Model):
    """Critical Result consists of two properties.

    :ivar description: Description : medical problem. Required.
    :vartype description: str
    :ivar finding: Finding linked to the critical result.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.Observation
    """

    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description : medical problem. Required."""
    finding: Optional["_models.Observation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Finding linked to the critical result."""

    @overload
    def __init__(
        self,
        *,
        description: str,
        finding: Optional["_models.Observation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CriticalResultInference(RadiologyInsightsInference, discriminator="criticalResult"):
    """Critical results refer to findings of utmost importance that may require timely attention due
    to their potential impact on patient care.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Critical finding inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.CRITICAL_RESULT
    :ivar result: The complete Critical Result, as outlined below, will be reused for the
     recommendation. Required.
    :vartype result: ~azure.healthinsights.radiologyinsights.models.CriticalResult
    """

    kind: Literal[RadiologyInsightsInferenceType.CRITICAL_RESULT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Critical finding inference type"""
    result: "_models.CriticalResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The complete Critical Result, as outlined below, will be reused for the recommendation.
     Required."""

    @overload
    def __init__(
        self,
        *,
        result: "_models.CriticalResult",
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.CRITICAL_RESULT, **kwargs)


class DocumentAdministrativeMetadata(_Model):
    """Document administrative metadata.

    :ivar ordered_procedures: List of procedure information associated with the document.
    :vartype ordered_procedures:
     list[~azure.healthinsights.radiologyinsights.models.OrderedProcedure]
    :ivar encounter_id: Reference to the encounter associated with the document.
    :vartype encounter_id: str
    """

    ordered_procedures: Optional[List["_models.OrderedProcedure"]] = rest_field(
        name="orderedProcedures", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of procedure information associated with the document."""
    encounter_id: Optional[str] = rest_field(
        name="encounterId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference to the encounter associated with the document."""

    @overload
    def __init__(
        self,
        *,
        ordered_procedures: Optional[List["_models.OrderedProcedure"]] = None,
        encounter_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentAuthor(_Model):
    """Document author.

    :ivar id: author id.
    :vartype id: str
    :ivar full_name: Text representation of the full name.
    :vartype full_name: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """author id."""
    full_name: Optional[str] = rest_field(name="fullName", visibility=["read", "create", "update", "delete", "query"])
    """Text representation of the full name."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        full_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentContent(_Model):
    """The content of the patient document.

    :ivar source_type: The type of the content's source.
     In case the source type is 'inline', the content is given as a string (for instance, text).
     In case the source type is 'reference', the content is given as a URI. Required. Known values
     are: "inline" and "reference".
    :vartype source_type: str or
     ~azure.healthinsights.radiologyinsights.models.DocumentContentSourceType
    :ivar value: The content of the document, given either inline (as a string) or as a reference
     (URI). Required.
    :vartype value: str
    """

    source_type: Union[str, "_models.DocumentContentSourceType"] = rest_field(
        name="sourceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the content's source.
     In case the source type is 'inline', the content is given as a string (for instance, text).
     In case the source type is 'reference', the content is given as a URI. Required. Known values
     are: \"inline\" and \"reference\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content of the document, given either inline (as a string) or as a reference (URI).
     Required."""

    @overload
    def __init__(
        self,
        *,
        source_type: Union[str, "_models.DocumentContentSourceType"],
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource is the ancestor of DomainResource from which most resources are derived. Bundle,
    Parameters, and Binary extend Resource directly.
    Based on [FHIR Resource](`https://www.hl7.org/fhir/r4/resource.html
    <https://www.hl7.org/fhir/r4/resource.html>`_.

    :ivar resource_type: The type of resource. Required.
    :vartype resource_type: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    """

    resource_type: str = rest_field(name="resourceType", visibility=["read", "create", "update", "delete", "query"])
    """The type of resource. Required."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource Id."""
    meta: Optional["_models.Meta"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata about the resource."""
    implicit_rules: Optional[str] = rest_field(
        name="implicitRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """A set of rules under which this content was created."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Language of the resource content."""

    @overload
    def __init__(
        self,
        *,
        resource_type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DomainResource(Resource):
    """A resource with narrative, extensions, and contained resources
    Based on `FHIR DomainResource <https://www.hl7.org/fhir/domainresource.html>`_.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Condition, Observation, ResearchStudy

    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    :ivar resource_type: Discriminator property for DomainResource. Required. Default value is
     None.
    :vartype resource_type: str
    :ivar text: Text summary of the resource, for human interpretation.
    :vartype text: ~azure.healthinsights.radiologyinsights.models.Narrative
    :ivar contained: Contained, inline Resources.
    :vartype contained: list[~azure.healthinsights.radiologyinsights.models.Resource]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar modifier_extension: Extensions that cannot be ignored.
    :vartype modifier_extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    __mapping__: Dict[str, _Model] = {}
    resource_type: str = rest_discriminator(name="resourceType")
    """Discriminator property for DomainResource. Required. Default value is None."""
    text: Optional["_models.Narrative"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text summary of the resource, for human interpretation."""
    contained: Optional[List["_models.Resource"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contained, inline Resources."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""
    modifier_extension: Optional[List["_models.Extension"]] = rest_field(
        name="modifierExtension", visibility=["read", "create", "update", "delete", "query"]
    )
    """Extensions that cannot be ignored."""

    @overload
    def __init__(
        self,
        *,
        resource_type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
        text: Optional["_models.Narrative"] = None,
        contained: Optional[List["_models.Resource"]] = None,
        extension: Optional[List["_models.Extension"]] = None,
        modifier_extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Extension(Element):
    """Base for all elements
    Based on `FHIR Element <https://www.hl7.org/fhir/R4/element.html>`_.

    :ivar url: Source of the definition for the extension code - a logical name or a URL. Required.
    :vartype url: str
    :ivar value_quantity: Value as Quantity.
    :vartype value_quantity: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar value_codeable_concept: Value as CodeableConcept.
    :vartype value_codeable_concept: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_string: Value as string.
    :vartype value_string: str
    :ivar value_boolean: Value as boolean.
    :vartype value_boolean: bool
    :ivar value_integer: Value as integer.
    :vartype value_integer: int
    :ivar value_range: Value as Range.
    :vartype value_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar value_ratio: Value as Ratio.
    :vartype value_ratio: ~azure.healthinsights.radiologyinsights.models.Ratio
    :ivar value_sampled_data: Value as SampledData.
    :vartype value_sampled_data: ~azure.healthinsights.radiologyinsights.models.SampledData
    :ivar value_time: Value as time (hh:mm:ss).
    :vartype value_time: ~datetime.time
    :ivar value_date_time: Value as dateTime.
    :vartype value_date_time: str
    :ivar value_period: Value as Period.
    :vartype value_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar value_reference: Value as reference.
    :vartype value_reference: ~azure.healthinsights.radiologyinsights.models.Reference
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source of the definition for the extension code - a logical name or a URL. Required."""
    value_quantity: Optional["_models.Quantity"] = rest_field(
        name="valueQuantity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Quantity."""
    value_codeable_concept: Optional["_models.CodeableConcept"] = rest_field(
        name="valueCodeableConcept", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as CodeableConcept."""
    value_string: Optional[str] = rest_field(
        name="valueString", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as string."""
    value_boolean: Optional[bool] = rest_field(
        name="valueBoolean", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as boolean."""
    value_integer: Optional[int] = rest_field(
        name="valueInteger", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as integer."""
    value_range: Optional["_models.Range"] = rest_field(
        name="valueRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Range."""
    value_ratio: Optional["_models.Ratio"] = rest_field(
        name="valueRatio", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Ratio."""
    value_sampled_data: Optional["_models.SampledData"] = rest_field(
        name="valueSampledData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as SampledData."""
    value_time: Optional[datetime.time] = rest_field(
        name="valueTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as time (hh:mm:ss)."""
    value_date_time: Optional[str] = rest_field(
        name="valueDateTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as dateTime."""
    value_period: Optional["_models.Period"] = rest_field(
        name="valuePeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Period."""
    value_reference: Optional["_models.Reference"] = rest_field(
        name="valueReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as reference."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        value_quantity: Optional["_models.Quantity"] = None,
        value_codeable_concept: Optional["_models.CodeableConcept"] = None,
        value_string: Optional[str] = None,
        value_boolean: Optional[bool] = None,
        value_integer: Optional[int] = None,
        value_range: Optional["_models.Range"] = None,
        value_ratio: Optional["_models.Ratio"] = None,
        value_sampled_data: Optional["_models.SampledData"] = None,
        value_time: Optional[datetime.time] = None,
        value_date_time: Optional[str] = None,
        value_period: Optional["_models.Period"] = None,
        value_reference: Optional["_models.Reference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FindingInference(RadiologyInsightsInference, discriminator="finding"):
    """Findings in a radiology report typically describe abnormalities, lesions, or other notable
    observations related to the anatomy or pathology of the imaged area.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Finding inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.FINDING
    :ivar finding: Finding data : contains extensions, fields and components linked with the
     finding. Required.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.Observation
    """

    kind: Literal[RadiologyInsightsInferenceType.FINDING] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Finding inference type"""
    finding: "_models.Observation" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Finding data : contains extensions, fields and components linked with the finding. Required."""

    @overload
    def __init__(
        self,
        *,
        finding: "_models.Observation",
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.FINDING, **kwargs)


class FindingOptions(_Model):
    """Finding options.

    :ivar provide_focused_sentence_evidence: If this is true, provide the sentence that contains
     the first token of the finding's clinical indicator (i.e. the medical problem), if there is
     one. This sentence is provided as an extension with url 'ci_sentence', next to the token
     evidence. Default is false.
    :vartype provide_focused_sentence_evidence: bool
    """

    provide_focused_sentence_evidence: Optional[bool] = rest_field(
        name="provideFocusedSentenceEvidence", visibility=["read", "create", "update", "delete", "query"]
    )
    """If this is true, provide the sentence that contains the first token of the finding's clinical
     indicator (i.e. the medical problem), if there is one. This sentence is provided as an
     extension with url 'ci_sentence', next to the token evidence. Default is false."""

    @overload
    def __init__(
        self,
        *,
        provide_focused_sentence_evidence: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FollowupCommunicationInference(RadiologyInsightsInference, discriminator="followupCommunication"):
    """Follow-up communication involves the exchange of important information, recommendations, or
    updates between radiologists and other healthcare professionals involved in a patient's care.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Followup Communication inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.FOLLOWUP_COMMUNICATION
    :ivar communicated_at: Communication date and time.
    :vartype communicated_at: list[~datetime.datetime]
    :ivar recipient: Recipient of the communication.
    :vartype recipient: list[str or
     ~azure.healthinsights.radiologyinsights.models.MedicalProfessionalType]
    :ivar was_acknowledged: Communication was acknowledged. Required.
    :vartype was_acknowledged: bool
    """

    kind: Literal[RadiologyInsightsInferenceType.FOLLOWUP_COMMUNICATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Followup Communication inference type"""
    communicated_at: Optional[List[datetime.datetime]] = rest_field(
        name="communicatedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Communication date and time."""
    recipient: Optional[List[Union[str, "_models.MedicalProfessionalType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Recipient of the communication."""
    was_acknowledged: bool = rest_field(
        name="wasAcknowledged", visibility=["read", "create", "update", "delete", "query"]
    )
    """Communication was acknowledged. Required."""

    @overload
    def __init__(
        self,
        *,
        was_acknowledged: bool,
        extension: Optional[List["_models.Extension"]] = None,
        communicated_at: Optional[List[datetime.datetime]] = None,
        recipient: Optional[List[Union[str, "_models.MedicalProfessionalType"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.FOLLOWUP_COMMUNICATION, **kwargs)


class FollowupRecommendationInference(RadiologyInsightsInference, discriminator="followupRecommendation"):
    """Follow-up recommendations offer guidance to healthcare providers on managing and monitoring
    patients based on the findings of imaging studies.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Recommendation inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.FOLLOWUP_RECOMMENDATION
    :ivar effective_at: Date and time are displayed when the procedure is recommended to be done at
     a specific point in time.
    :vartype effective_at: str
    :ivar effective_period: The period is shown if a specific period is mentioned, with a start and
     end date-time.
    :vartype effective_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar findings: Findings related to the recommendation.
    :vartype findings: list[~azure.healthinsights.radiologyinsights.models.RecommendationFinding]
    :ivar is_conditional: The conditional value indicates whether or not the sentence containing
     the recommendation includes a conditional statement. Keywords for conditional statements
     include 'if', 'when', 'unless', and so on. Required.
    :vartype is_conditional: bool
    :ivar is_option: The option value indicates whether or not the sentence containing the
     recommendation includes an optional statement. Keywords for optional statements include
     'recommend', 'consider', and so on. Required.
    :vartype is_option: bool
    :ivar is_guideline: The guideline value indicates whether or not the recommendation is part of
     a guideline section that compiles all recommendations applicable to various findings. Required.
    :vartype is_guideline: bool
    :ivar is_hedging: Hedging refers to ambiguous, vague or imprecise language within the sentence
     of the recommendation. Keywords for hedging are 'can be','may be',and so on. Required.
    :vartype is_hedging: bool
    :ivar recommended_procedure: The procedure recommendation can be a generic procedure or an
     imaging procedure. Required.
    :vartype recommended_procedure:
     ~azure.healthinsights.radiologyinsights.models.ProcedureRecommendation
    """

    kind: Literal[RadiologyInsightsInferenceType.FOLLOWUP_RECOMMENDATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Recommendation inference type"""
    effective_at: Optional[str] = rest_field(
        name="effectiveAt", visibility=["read", "create", "update", "delete", "query"]
    )
    """Date and time are displayed when the procedure is recommended to be done at a specific point in
     time."""
    effective_period: Optional["_models.Period"] = rest_field(
        name="effectivePeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """The period is shown if a specific period is mentioned, with a start and end date-time."""
    findings: Optional[List["_models.RecommendationFinding"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Findings related to the recommendation."""
    is_conditional: bool = rest_field(name="isConditional", visibility=["read", "create", "update", "delete", "query"])
    """The conditional value indicates whether or not the sentence containing the recommendation
     includes a conditional statement. Keywords for conditional statements include 'if', 'when',
     'unless', and so on. Required."""
    is_option: bool = rest_field(name="isOption", visibility=["read", "create", "update", "delete", "query"])
    """The option value indicates whether or not the sentence containing the recommendation includes
     an optional statement. Keywords for optional statements include 'recommend', 'consider', and so
     on. Required."""
    is_guideline: bool = rest_field(name="isGuideline", visibility=["read", "create", "update", "delete", "query"])
    """The guideline value indicates whether or not the recommendation is part of a guideline section
     that compiles all recommendations applicable to various findings. Required."""
    is_hedging: bool = rest_field(name="isHedging", visibility=["read", "create", "update", "delete", "query"])
    """Hedging refers to ambiguous, vague or imprecise language within the sentence of the
     recommendation. Keywords for hedging are 'can be','may be',and so on. Required."""
    recommended_procedure: "_models.ProcedureRecommendation" = rest_field(
        name="recommendedProcedure", visibility=["read", "create", "update", "delete", "query"]
    )
    """The procedure recommendation can be a generic procedure or an imaging procedure. Required."""

    @overload
    def __init__(
        self,
        *,
        is_conditional: bool,
        is_option: bool,
        is_guideline: bool,
        is_hedging: bool,
        recommended_procedure: "_models.ProcedureRecommendation",
        extension: Optional[List["_models.Extension"]] = None,
        effective_at: Optional[str] = None,
        effective_period: Optional["_models.Period"] = None,
        findings: Optional[List["_models.RecommendationFinding"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.FOLLOWUP_RECOMMENDATION, **kwargs)


class FollowupRecommendationOptions(_Model):
    """Follow-up recommendation options.

    :ivar include_recommendations_with_no_specified_modality: Include/Exclude follow-up
     recommendations without a specific radiology procedure. Default is false.
    :vartype include_recommendations_with_no_specified_modality: bool
    :ivar include_recommendations_in_references: Include/Exclude follow-up recommendations in
     references to a guideline or article. Default is false.
    :vartype include_recommendations_in_references: bool
    :ivar provide_focused_sentence_evidence: If this is true, provide one or more sentences as
     evidence for the recommendation, next to the token evidence. The start and end positions of
     these sentences will be put in an extension with url 'modality_sentences'. Default is false.
    :vartype provide_focused_sentence_evidence: bool
    """

    include_recommendations_with_no_specified_modality: Optional[bool] = rest_field(
        name="includeRecommendationsWithNoSpecifiedModality", visibility=["read", "create", "update", "delete", "query"]
    )
    """Include/Exclude follow-up recommendations without a specific radiology procedure. Default is
     false."""
    include_recommendations_in_references: Optional[bool] = rest_field(
        name="includeRecommendationsInReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """Include/Exclude follow-up recommendations in references to a guideline or article. Default is
     false."""
    provide_focused_sentence_evidence: Optional[bool] = rest_field(
        name="provideFocusedSentenceEvidence", visibility=["read", "create", "update", "delete", "query"]
    )
    """If this is true, provide one or more sentences as evidence for the recommendation, next to the
     token evidence. The start and end positions of these sentences will be put in an extension with
     url 'modality_sentences'. Default is false."""

    @overload
    def __init__(
        self,
        *,
        include_recommendations_with_no_specified_modality: Optional[bool] = None,
        include_recommendations_in_references: Optional[bool] = None,
        provide_focused_sentence_evidence: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProcedureRecommendation(_Model):
    """The procedure recommendation can be a generic procedure or an imaging procedure.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GenericProcedureRecommendation, ImagingProcedureRecommendation

    :ivar kind: Discriminator property for ProcedureRecommendation. Required. Default value is
     None.
    :vartype kind: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    __mapping__: Dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind")
    """Discriminator property for ProcedureRecommendation. Required. Default value is None."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GenericProcedureRecommendation(ProcedureRecommendation, discriminator="genericProcedureRecommendation"):
    """Generic procedure information.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Procedure type : generic. Required. Default value is
     "genericProcedureRecommendation".
    :vartype kind: str
    :ivar code: Procedure modality : SNOMED CT code. Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar description: Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION
     (PROCEDURE) based on SNOMED CT.
    :vartype description: str
    """

    kind: Literal["genericProcedureRecommendation"] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Procedure type : generic. Required. Default value is \"genericProcedureRecommendation\"."""
    code: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Procedure modality : SNOMED CT code. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION (PROCEDURE) based on
     SNOMED CT."""

    @overload
    def __init__(
        self,
        *,
        code: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind="genericProcedureRecommendation", **kwargs)


class GuidanceInference(RadiologyInsightsInference, discriminator="guidance"):
    """A guidance inference collects structured information about a specific finding in the report and
    can possibly propose appropriate follow-up recommendations, based upon established,
    evidence-based best practices i.e. ACR guidelines.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Guidance inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.GUIDANCE
    :ivar finding: The finding associated with the guidance. Required.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.FindingInference
    :ivar identifier: The guidance identifier, as a concept. Required.
    :vartype identifier: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar present_guidance_information: presentGuidanceInformation lists each item of the
     structured information (e.g. laterality) and corresponding details (left, right, bilateral)
     that is present in the document.
    :vartype present_guidance_information:
     list[~azure.healthinsights.radiologyinsights.models.PresentGuidanceInformation]
    :ivar ranking: See doc of GuidanceRankingType. Required. Known values are: "high" and "low".
    :vartype ranking: str or ~azure.healthinsights.radiologyinsights.models.GuidanceRankingType
    :ivar recommendation_proposals: The proposed follow-up recommendations, if any. If this is
     filled, missingGuidanceInformation cannot be filled (and vice versa).
    :vartype recommendation_proposals:
     list[~azure.healthinsights.radiologyinsights.models.FollowupRecommendationInference]
    :ivar missing_guidance_information: Contains all missing items that are needed to determine
     follow-up.
    :vartype missing_guidance_information: list[str]
    """

    kind: Literal[RadiologyInsightsInferenceType.GUIDANCE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Guidance inference type"""
    finding: "_models.FindingInference" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The finding associated with the guidance. Required."""
    identifier: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The guidance identifier, as a concept. Required."""
    present_guidance_information: Optional[List["_models.PresentGuidanceInformation"]] = rest_field(
        name="presentGuidanceInformation", visibility=["read", "create", "update", "delete", "query"]
    )
    """presentGuidanceInformation lists each item of the structured information (e.g. laterality) and
     corresponding details (left, right, bilateral) that is present in the document."""
    ranking: Union[str, "_models.GuidanceRankingType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """See doc of GuidanceRankingType. Required. Known values are: \"high\" and \"low\"."""
    recommendation_proposals: Optional[List["_models.FollowupRecommendationInference"]] = rest_field(
        name="recommendationProposals", visibility=["read", "create", "update", "delete", "query"]
    )
    """The proposed follow-up recommendations, if any. If this is filled, missingGuidanceInformation
     cannot be filled (and vice versa)."""
    missing_guidance_information: Optional[List[str]] = rest_field(
        name="missingGuidanceInformation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains all missing items that are needed to determine follow-up."""

    @overload
    def __init__(
        self,
        *,
        finding: "_models.FindingInference",
        identifier: "_models.CodeableConcept",
        ranking: Union[str, "_models.GuidanceRankingType"],
        extension: Optional[List["_models.Extension"]] = None,
        present_guidance_information: Optional[List["_models.PresentGuidanceInformation"]] = None,
        recommendation_proposals: Optional[List["_models.FollowupRecommendationInference"]] = None,
        missing_guidance_information: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.GUIDANCE, **kwargs)


class GuidanceOptions(_Model):
    """Guidance options.

    :ivar show_guidance_in_history: If this is true, also show guidances from a clinical history
     section i.e. if the first token of the associated finding's clinical indicator is in this
     section. Default is false. Required.
    :vartype show_guidance_in_history: bool
    """

    show_guidance_in_history: bool = rest_field(
        name="showGuidanceInHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """If this is true, also show guidances from a clinical history section i.e. if the first token of
     the associated finding's clinical indicator is in this section. Default is false. Required."""

    @overload
    def __init__(
        self,
        *,
        show_guidance_in_history: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthInsightsErrorResponse(_Model):
    """A response containing error details.

    :ivar error: The error object. Required.
    :vartype error: ~azure.core.ODataV4Format
    """

    error: ODataV4Format = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object. Required."""

    @overload
    def __init__(
        self,
        *,
        error: ODataV4Format,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Identifier(Element):
    """An identifier intended for computation
    Based on `FHIR Identifier <https://www.hl7.org/fhir/R4/identifier.html>`_.

    :ivar use: usual | official | temp | secondary | old (If known).
    :vartype use: str
    :ivar type: Description of identifier.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar system: The namespace for the identifier value.
    :vartype system: str
    :ivar value: The value that is unique.
    :vartype value: str
    :ivar period: Time period when id is/was valid for use.
    :vartype period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar assigner: Organization that issued id (may be just text).
    :vartype assigner: ~azure.healthinsights.radiologyinsights.models.Reference
    """

    use: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """usual | official | temp | secondary | old (If known)."""
    type: Optional["_models.CodeableConcept"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of identifier."""
    system: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The namespace for the identifier value."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value that is unique."""
    period: Optional["_models.Period"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Time period when id is/was valid for use."""
    assigner: Optional["_models.Reference"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Organization that issued id (may be just text)."""

    @overload
    def __init__(
        self,
        *,
        use: Optional[str] = None,
        type: Optional["_models.CodeableConcept"] = None,
        system: Optional[str] = None,
        value: Optional[str] = None,
        period: Optional["_models.Period"] = None,
        assigner: Optional["_models.Reference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImagingProcedure(_Model):
    """Imaging procedure.

    :ivar modality: Modality : SNOMED CT code. Required.
    :vartype modality: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar anatomy: Anatomy : SNOMED CT code. Required.
    :vartype anatomy: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar laterality: Laterality : SNOMED CT code.
    :vartype laterality: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar contrast: Contrast : see RadiologyCodeWithTypes (below).
    :vartype contrast: ~azure.healthinsights.radiologyinsights.models.RadiologyCodeWithTypes
    :ivar view: View : see RadiologyCodeWithTypes (below).
    :vartype view: ~azure.healthinsights.radiologyinsights.models.RadiologyCodeWithTypes
    """

    modality: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Modality : SNOMED CT code. Required."""
    anatomy: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Anatomy : SNOMED CT code. Required."""
    laterality: Optional["_models.CodeableConcept"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Laterality : SNOMED CT code."""
    contrast: Optional["_models.RadiologyCodeWithTypes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contrast : see RadiologyCodeWithTypes (below)."""
    view: Optional["_models.RadiologyCodeWithTypes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """View : see RadiologyCodeWithTypes (below)."""

    @overload
    def __init__(
        self,
        *,
        modality: "_models.CodeableConcept",
        anatomy: "_models.CodeableConcept",
        laterality: Optional["_models.CodeableConcept"] = None,
        contrast: Optional["_models.RadiologyCodeWithTypes"] = None,
        view: Optional["_models.RadiologyCodeWithTypes"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImagingProcedureRecommendation(ProcedureRecommendation, discriminator="imagingProcedureRecommendation"):
    """Imaging procedures.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Procedure type : imaging. Required. Default value is
     "imagingProcedureRecommendation".
    :vartype kind: str
    :ivar procedure_codes: LOINC codes for the procedure.
    :vartype procedure_codes: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar imaging_procedures: Imaging procedures. Required.
    :vartype imaging_procedures:
     list[~azure.healthinsights.radiologyinsights.models.ImagingProcedure]
    """

    kind: Literal["imagingProcedureRecommendation"] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Procedure type : imaging. Required. Default value is \"imagingProcedureRecommendation\"."""
    procedure_codes: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="procedureCodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """LOINC codes for the procedure."""
    imaging_procedures: List["_models.ImagingProcedure"] = rest_field(
        name="imagingProcedures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Imaging procedures. Required."""

    @overload
    def __init__(
        self,
        *,
        imaging_procedures: List["_models.ImagingProcedure"],
        extension: Optional[List["_models.Extension"]] = None,
        procedure_codes: Optional[List["_models.CodeableConcept"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind="imagingProcedureRecommendation", **kwargs)


class LateralityDiscrepancyInference(RadiologyInsightsInference, discriminator="lateralityDiscrepancy"):
    """A laterality mismatch occurs when there is a discrepancy between the clinical documentation and
    the ordered procedure (orderLateralityMismatch), a contradiction within the clinical document
    (textLateralityContradiction), or when no laterality is mentioned (textLateralityMissing).

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Laterality discrepancy inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.LATERALITY_DISCREPANCY
    :ivar laterality_indication: Laterality indication : SNOMED CT code for laterality qualifier
     value.
    :vartype laterality_indication: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar discrepancy_type: Mismatch type : orderLateralityMismatch, textLateralityContradiction,
     textLateralityMissing. Required. Known values are: "orderLateralityMismatch",
     "textLateralityContradiction", and "textLateralityMissing".
    :vartype discrepancy_type: str or
     ~azure.healthinsights.radiologyinsights.models.LateralityDiscrepancyType
    """

    kind: Literal[RadiologyInsightsInferenceType.LATERALITY_DISCREPANCY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Laterality discrepancy inference type"""
    laterality_indication: Optional["_models.CodeableConcept"] = rest_field(
        name="lateralityIndication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Laterality indication : SNOMED CT code for laterality qualifier value."""
    discrepancy_type: Union[str, "_models.LateralityDiscrepancyType"] = rest_field(
        name="discrepancyType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mismatch type : orderLateralityMismatch, textLateralityContradiction, textLateralityMissing.
     Required. Known values are: \"orderLateralityMismatch\", \"textLateralityContradiction\", and
     \"textLateralityMissing\"."""

    @overload
    def __init__(
        self,
        *,
        discrepancy_type: Union[str, "_models.LateralityDiscrepancyType"],
        extension: Optional[List["_models.Extension"]] = None,
        laterality_indication: Optional["_models.CodeableConcept"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.LATERALITY_DISCREPANCY, **kwargs)


class LimitedOrderDiscrepancyInference(RadiologyInsightsInference, discriminator="limitedOrderDiscrepancy"):
    """A limited order discrepancy occurs when there is a limited order, but all body parts and
    measurements that are needed for a complete order are present in the document.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Limited order discrepancy inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.LIMITED_ORDER_DISCREPANCY
    :ivar order_type: Order type : CPT ultrasound complete code for abdomen, retroperitoneal,
     pelvis or breast. Required.
    :vartype order_type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar present_body_parts: List of body parts found in the document : SNOMED CT codes.
    :vartype present_body_parts:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar present_body_part_measurements: List of body parts that are measured according to the
     document : SNOMED CT codes.
    :vartype present_body_part_measurements:
     list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    """

    kind: Literal[RadiologyInsightsInferenceType.LIMITED_ORDER_DISCREPANCY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Limited order discrepancy inference type"""
    order_type: "_models.CodeableConcept" = rest_field(
        name="orderType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Order type : CPT ultrasound complete code for abdomen, retroperitoneal, pelvis or breast.
     Required."""
    present_body_parts: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="presentBodyParts", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of body parts found in the document : SNOMED CT codes."""
    present_body_part_measurements: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="presentBodyPartMeasurements", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of body parts that are measured according to the document : SNOMED CT codes."""

    @overload
    def __init__(
        self,
        *,
        order_type: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
        present_body_parts: Optional[List["_models.CodeableConcept"]] = None,
        present_body_part_measurements: Optional[List["_models.CodeableConcept"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.LIMITED_ORDER_DISCREPANCY, **kwargs)


class Meta(_Model):
    """Metadata about a resource
    Based on `FHIR Meta <https://www.hl7.org/fhir/R4/resource.html#Meta>`_.

    :ivar version_id: The version specific identifier, as it appears in the version portion of the
     URL. This value changes when the resource is created, updated, or deleted.
    :vartype version_id: str
    :ivar last_updated: When the resource last changed - e.g. when the version changed.
    :vartype last_updated: str
    :ivar source: A uri that identifies the source system of the resource. This provides a minimal
     amount of Provenance information that can be used to track or differentiate the source of
     information in the resource. The source may identify another FHIR server, document, message,
     database, etc.
    :vartype source: str
    :ivar profile: A list of profiles (references to `StructureDefinition
     <https://www.hl7.org/fhir/structuredefinition.html>`_ resources) that this resource claims to
     conform to. The URL is a reference to `StructureDefinition.url
     <https://www.hl7.org/fhir/structuredefinition-definitions.html#StructureDefinition.url>`_.
    :vartype profile: list[str]
    :ivar security: Security labels applied to this resource. These tags connect specific resources
     to the overall security policy and infrastructure.
    :vartype security: list[~azure.healthinsights.radiologyinsights.models.Coding]
    :ivar tag: Tags applied to this resource. Tags are intended to be used to identify and relate
     resources to process and workflow, and applications are not required to consider the tags when
     interpreting the meaning of a resource.
    :vartype tag: list[~azure.healthinsights.radiologyinsights.models.Coding]
    """

    version_id: Optional[str] = rest_field(name="versionId", visibility=["read", "create", "update", "delete", "query"])
    """The version specific identifier, as it appears in the version portion of the URL. This value
     changes when the resource is created, updated, or deleted."""
    last_updated: Optional[str] = rest_field(
        name="lastUpdated", visibility=["read", "create", "update", "delete", "query"]
    )
    """When the resource last changed - e.g. when the version changed."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A uri that identifies the source system of the resource. This provides a minimal amount of
     Provenance information that can be used to track or differentiate the source of information in
     the resource. The source may identify another FHIR server, document, message, database, etc."""
    profile: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of profiles (references to `StructureDefinition
     <https://www.hl7.org/fhir/structuredefinition.html>`_ resources) that this resource claims to
     conform to. The URL is a reference to `StructureDefinition.url
     <https://www.hl7.org/fhir/structuredefinition-definitions.html#StructureDefinition.url>`_."""
    security: Optional[List["_models.Coding"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Security labels applied to this resource. These tags connect specific resources to the overall
     security policy and infrastructure."""
    tag: Optional[List["_models.Coding"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tags applied to this resource. Tags are intended to be used to identify and relate resources to
     process and workflow, and applications are not required to consider the tags when interpreting
     the meaning of a resource."""

    @overload
    def __init__(
        self,
        *,
        version_id: Optional[str] = None,
        last_updated: Optional[str] = None,
        source: Optional[str] = None,
        profile: Optional[List[str]] = None,
        security: Optional[List["_models.Coding"]] = None,
        tag: Optional[List["_models.Coding"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Narrative(Element):
    """Any resource that is a `DomainResource <https://www.hl7.org/fhir/domainresource.html>`_ may
    include a human-readable narrative that contains a summary of the resource and may be used to
    represent the content of the resource to a human.
    Based on `FHIR Narrative <https://www.hl7.org/fhir/R4/narrative.html#Narrative>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar status: generated, extensions, additional, empty. Required.
    :vartype status: str
    :ivar div: xhtml. Required.
    :vartype div: str
    """

    status: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """generated, extensions, additional, empty. Required."""
    div: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """xhtml. Required."""

    @overload
    def __init__(
        self,
        *,
        status: str,
        div: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Observation(DomainResource, discriminator="Observation"):
    """Detailed information about observations
    Based on `FHIR Observation <https://www.hl7.org/fhir/R4/observation.html>`_.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar meta: Metadata about the resource.
    :vartype meta: ~azure.healthinsights.radiologyinsights.models.Meta
    :ivar implicit_rules: A set of rules under which this content was created.
    :vartype implicit_rules: str
    :ivar language: Language of the resource content.
    :vartype language: str
    :ivar text: Text summary of the resource, for human interpretation.
    :vartype text: ~azure.healthinsights.radiologyinsights.models.Narrative
    :ivar contained: Contained, inline Resources.
    :vartype contained: list[~azure.healthinsights.radiologyinsights.models.Resource]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar modifier_extension: Extensions that cannot be ignored.
    :vartype modifier_extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar resource_type: resourceType. Required. Default value is "Observation".
    :vartype resource_type: str
    :ivar identifier: Business Identifier for observation.
    :vartype identifier: list[~azure.healthinsights.radiologyinsights.models.Identifier]
    :ivar status: registered | preliminary | final | amended +. Required. Known values are:
     "registered", "preliminary", "final", "amended", "corrected", "cancelled", "entered-in-error",
     and "unknown".
    :vartype status: str or
     ~azure.healthinsights.radiologyinsights.models.ObservationStatusCodeType
    :ivar category: Classification of  type of observation.
    :vartype category: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar code: Type of observation (code / type). Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar subject: Who and/or what the observation is about.
    :vartype subject: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar encounter: Healthcare event during which this observation is made.
    :vartype encounter: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar effective_date_time: Clinically relevant time/time-period for observation.
    :vartype effective_date_time: str
    :ivar effective_period: Clinically relevant time/time-period for observation.
    :vartype effective_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar effective_instant: Clinically relevant time/time-period for observation.
    :vartype effective_instant: str
    :ivar issued: Date/Time this version was made available.
    :vartype issued: str
    :ivar value_quantity: Actual result.
    :vartype value_quantity: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar value_codeable_concept: Actual result.
    :vartype value_codeable_concept: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_string: Actual result.
    :vartype value_string: str
    :ivar value_boolean: Actual result.
    :vartype value_boolean: bool
    :ivar value_integer: Actual result.
    :vartype value_integer: int
    :ivar value_range: Actual result.
    :vartype value_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar value_ratio: Actual result.
    :vartype value_ratio: ~azure.healthinsights.radiologyinsights.models.Ratio
    :ivar value_sampled_data: Actual result.
    :vartype value_sampled_data: ~azure.healthinsights.radiologyinsights.models.SampledData
    :ivar value_time: Actual result.
    :vartype value_time: ~datetime.time
    :ivar value_date_time: Actual result.
    :vartype value_date_time: str
    :ivar value_period: Actual result.
    :vartype value_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar data_absent_reason: Why the result is missing.
    :vartype data_absent_reason: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar interpretation: High, low, normal, etc.
    :vartype interpretation: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar note: Comments about the observation.
    :vartype note: list[~azure.healthinsights.radiologyinsights.models.Annotation]
    :ivar body_site: Observed body part.
    :vartype body_site: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar method: How it was done.
    :vartype method: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar reference_range: Provides guide for interpretation.
    :vartype reference_range:
     list[~azure.healthinsights.radiologyinsights.models.ObservationReferenceRange]
    :ivar has_member: Related resource that belongs to the Observation group.
    :vartype has_member: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar derived_from: Related measurements the observation is made from.
    :vartype derived_from: list[~azure.healthinsights.radiologyinsights.models.Reference]
    :ivar component: Component results.
    :vartype component: list[~azure.healthinsights.radiologyinsights.models.ObservationComponent]
    """

    resource_type: Literal["Observation"] = rest_discriminator(name="resourceType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """resourceType. Required. Default value is \"Observation\"."""
    identifier: Optional[List["_models.Identifier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Business Identifier for observation."""
    status: Union[str, "_models.ObservationStatusCodeType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """registered | preliminary | final | amended +. Required. Known values are: \"registered\",
     \"preliminary\", \"final\", \"amended\", \"corrected\", \"cancelled\", \"entered-in-error\",
     and \"unknown\"."""
    category: Optional[List["_models.CodeableConcept"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Classification of  type of observation."""
    code: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of observation (code / type). Required."""
    subject: Optional["_models.Reference"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Who and/or what the observation is about."""
    encounter: Optional["_models.Reference"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Healthcare event during which this observation is made."""
    effective_date_time: Optional[str] = rest_field(
        name="effectiveDateTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Clinically relevant time/time-period for observation."""
    effective_period: Optional["_models.Period"] = rest_field(
        name="effectivePeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Clinically relevant time/time-period for observation."""
    effective_instant: Optional[str] = rest_field(
        name="effectiveInstant", visibility=["read", "create", "update", "delete", "query"]
    )
    """Clinically relevant time/time-period for observation."""
    issued: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Date/Time this version was made available."""
    value_quantity: Optional["_models.Quantity"] = rest_field(
        name="valueQuantity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_codeable_concept: Optional["_models.CodeableConcept"] = rest_field(
        name="valueCodeableConcept", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_string: Optional[str] = rest_field(
        name="valueString", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_boolean: Optional[bool] = rest_field(
        name="valueBoolean", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_integer: Optional[int] = rest_field(
        name="valueInteger", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_range: Optional["_models.Range"] = rest_field(
        name="valueRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_ratio: Optional["_models.Ratio"] = rest_field(
        name="valueRatio", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_sampled_data: Optional["_models.SampledData"] = rest_field(
        name="valueSampledData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_time: Optional[datetime.time] = rest_field(
        name="valueTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_date_time: Optional[str] = rest_field(
        name="valueDateTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    value_period: Optional["_models.Period"] = rest_field(
        name="valuePeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Actual result."""
    data_absent_reason: Optional["_models.CodeableConcept"] = rest_field(
        name="dataAbsentReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """Why the result is missing."""
    interpretation: Optional[List["_models.CodeableConcept"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """High, low, normal, etc."""
    note: Optional[List["_models.Annotation"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Comments about the observation."""
    body_site: Optional["_models.CodeableConcept"] = rest_field(
        name="bodySite", visibility=["read", "create", "update", "delete", "query"]
    )
    """Observed body part."""
    method: Optional["_models.CodeableConcept"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """How it was done."""
    reference_range: Optional[List["_models.ObservationReferenceRange"]] = rest_field(
        name="referenceRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provides guide for interpretation."""
    has_member: Optional[List["_models.Reference"]] = rest_field(
        name="hasMember", visibility=["read", "create", "update", "delete", "query"]
    )
    """Related resource that belongs to the Observation group."""
    derived_from: Optional[List["_models.Reference"]] = rest_field(
        name="derivedFrom", visibility=["read", "create", "update", "delete", "query"]
    )
    """Related measurements the observation is made from."""
    component: Optional[List["_models.ObservationComponent"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Component results."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        status: Union[str, "_models.ObservationStatusCodeType"],
        code: "_models.CodeableConcept",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        meta: Optional["_models.Meta"] = None,
        implicit_rules: Optional[str] = None,
        language: Optional[str] = None,
        text: Optional["_models.Narrative"] = None,
        contained: Optional[List["_models.Resource"]] = None,
        extension: Optional[List["_models.Extension"]] = None,
        modifier_extension: Optional[List["_models.Extension"]] = None,
        identifier: Optional[List["_models.Identifier"]] = None,
        category: Optional[List["_models.CodeableConcept"]] = None,
        subject: Optional["_models.Reference"] = None,
        encounter: Optional["_models.Reference"] = None,
        effective_date_time: Optional[str] = None,
        effective_period: Optional["_models.Period"] = None,
        effective_instant: Optional[str] = None,
        issued: Optional[str] = None,
        value_quantity: Optional["_models.Quantity"] = None,
        value_codeable_concept: Optional["_models.CodeableConcept"] = None,
        value_string: Optional[str] = None,
        value_boolean: Optional[bool] = None,
        value_integer: Optional[int] = None,
        value_range: Optional["_models.Range"] = None,
        value_ratio: Optional["_models.Ratio"] = None,
        value_sampled_data: Optional["_models.SampledData"] = None,
        value_time: Optional[datetime.time] = None,
        value_date_time: Optional[str] = None,
        value_period: Optional["_models.Period"] = None,
        data_absent_reason: Optional["_models.CodeableConcept"] = None,
        interpretation: Optional[List["_models.CodeableConcept"]] = None,
        note: Optional[List["_models.Annotation"]] = None,
        body_site: Optional["_models.CodeableConcept"] = None,
        method: Optional["_models.CodeableConcept"] = None,
        reference_range: Optional[List["_models.ObservationReferenceRange"]] = None,
        has_member: Optional[List["_models.Reference"]] = None,
        derived_from: Optional[List["_models.Reference"]] = None,
        component: Optional[List["_models.ObservationComponent"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resource_type="Observation", **kwargs)


class ObservationComponent(Element):
    """Component results
    Based on `FHIR Observation.component <https://www.hl7.org/fhir/R4/observation.html>`_.

    :ivar id: Unique id for inter-element referencing.
    :vartype id: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar code: Type of component observation (code / type). Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_quantity: Value as Quantity.
    :vartype value_quantity: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar value_codeable_concept: Value as CodeableConcept.
    :vartype value_codeable_concept: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar value_string: Value as string.
    :vartype value_string: str
    :ivar value_boolean: Value as boolean.
    :vartype value_boolean: bool
    :ivar value_integer: Value as integer.
    :vartype value_integer: int
    :ivar value_range: Value as Range.
    :vartype value_range: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar value_ratio: Value as Ratio.
    :vartype value_ratio: ~azure.healthinsights.radiologyinsights.models.Ratio
    :ivar value_sampled_data: Value as SampledData.
    :vartype value_sampled_data: ~azure.healthinsights.radiologyinsights.models.SampledData
    :ivar value_time: Value as time (hh:mm:ss).
    :vartype value_time: ~datetime.time
    :ivar value_date_time: Value as dateTime.
    :vartype value_date_time: str
    :ivar value_period: Value as Period.
    :vartype value_period: ~azure.healthinsights.radiologyinsights.models.Period
    :ivar value_reference: Value as reference.
    :vartype value_reference: ~azure.healthinsights.radiologyinsights.models.Reference
    :ivar data_absent_reason: Why the component result is missing.
    :vartype data_absent_reason: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar interpretation: High, low, normal, etc.
    :vartype interpretation: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar reference_range: Provides guide for interpretation of component result.
    :vartype reference_range:
     list[~azure.healthinsights.radiologyinsights.models.ObservationReferenceRange]
    """

    code: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of component observation (code / type). Required."""
    value_quantity: Optional["_models.Quantity"] = rest_field(
        name="valueQuantity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Quantity."""
    value_codeable_concept: Optional["_models.CodeableConcept"] = rest_field(
        name="valueCodeableConcept", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as CodeableConcept."""
    value_string: Optional[str] = rest_field(
        name="valueString", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as string."""
    value_boolean: Optional[bool] = rest_field(
        name="valueBoolean", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as boolean."""
    value_integer: Optional[int] = rest_field(
        name="valueInteger", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as integer."""
    value_range: Optional["_models.Range"] = rest_field(
        name="valueRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Range."""
    value_ratio: Optional["_models.Ratio"] = rest_field(
        name="valueRatio", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Ratio."""
    value_sampled_data: Optional["_models.SampledData"] = rest_field(
        name="valueSampledData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as SampledData."""
    value_time: Optional[datetime.time] = rest_field(
        name="valueTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as time (hh:mm:ss)."""
    value_date_time: Optional[str] = rest_field(
        name="valueDateTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as dateTime."""
    value_period: Optional["_models.Period"] = rest_field(
        name="valuePeriod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as Period."""
    value_reference: Optional["_models.Reference"] = rest_field(
        name="valueReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Value as reference."""
    data_absent_reason: Optional["_models.CodeableConcept"] = rest_field(
        name="dataAbsentReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """Why the component result is missing."""
    interpretation: Optional[List["_models.CodeableConcept"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """High, low, normal, etc."""
    reference_range: Optional[List["_models.ObservationReferenceRange"]] = rest_field(
        name="referenceRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """Provides guide for interpretation of component result."""

    @overload
    def __init__(
        self,
        *,
        code: "_models.CodeableConcept",
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        extension: Optional[List["_models.Extension"]] = None,
        value_quantity: Optional["_models.Quantity"] = None,
        value_codeable_concept: Optional["_models.CodeableConcept"] = None,
        value_string: Optional[str] = None,
        value_boolean: Optional[bool] = None,
        value_integer: Optional[int] = None,
        value_range: Optional["_models.Range"] = None,
        value_ratio: Optional["_models.Ratio"] = None,
        value_sampled_data: Optional["_models.SampledData"] = None,
        value_time: Optional[datetime.time] = None,
        value_date_time: Optional[str] = None,
        value_period: Optional["_models.Period"] = None,
        value_reference: Optional["_models.Reference"] = None,
        data_absent_reason: Optional["_models.CodeableConcept"] = None,
        interpretation: Optional[List["_models.CodeableConcept"]] = None,
        reference_range: Optional[List["_models.ObservationReferenceRange"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ObservationReferenceRange(_Model):
    """Provides guide for interpretation of component result
    Based on `FHIR Observation.referenceRange <https://www.hl7.org/fhir/R4/observation.html>`_.

    :ivar low: Low Range, if relevant.
    :vartype low: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar high: High Range, if relevant.
    :vartype high: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar type: Reference range qualifier.
    :vartype type: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar applies_to: Reference range population.
    :vartype applies_to: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar age: Applicable age range, if relevant.
    :vartype age: ~azure.healthinsights.radiologyinsights.models.Range
    :ivar text: Text based reference range in an observation.
    :vartype text: str
    """

    low: Optional["_models.Quantity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Low Range, if relevant."""
    high: Optional["_models.Quantity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """High Range, if relevant."""
    type: Optional["_models.CodeableConcept"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Reference range qualifier."""
    applies_to: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="appliesTo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference range population."""
    age: Optional["_models.Range"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Applicable age range, if relevant."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text based reference range in an observation."""

    @overload
    def __init__(
        self,
        *,
        low: Optional["_models.Quantity"] = None,
        high: Optional["_models.Quantity"] = None,
        type: Optional["_models.CodeableConcept"] = None,
        applies_to: Optional[List["_models.CodeableConcept"]] = None,
        age: Optional["_models.Range"] = None,
        text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OrderedProcedure(_Model):
    """Procedure information.

    :ivar code: Procedure code.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar description: Procedure description.
    :vartype description: str
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    code: Optional["_models.CodeableConcept"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Procedure code."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Procedure description."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        code: Optional["_models.CodeableConcept"] = None,
        description: Optional[str] = None,
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatientDetails(_Model):
    """Patient structured information, including demographics and known structured clinical
    information.

    :ivar sex: The patient's sex. Known values are: "female", "male", and "unspecified".
    :vartype sex: str or ~azure.healthinsights.radiologyinsights.models.PatientSex
    :ivar birth_date: The patient's date of birth.
    :vartype birth_date: ~datetime.date
    :ivar clinical_info: Known clinical information for the patient, structured.
    :vartype clinical_info: list[~azure.healthinsights.radiologyinsights.models.Resource]
    """

    sex: Optional[Union[str, "_models.PatientSex"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The patient's sex. Known values are: \"female\", \"male\", and \"unspecified\"."""
    birth_date: Optional[datetime.date] = rest_field(
        name="birthDate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The patient's date of birth."""
    clinical_info: Optional[List["_models.Resource"]] = rest_field(
        name="clinicalInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Known clinical information for the patient, structured."""

    @overload
    def __init__(
        self,
        *,
        sex: Optional[Union[str, "_models.PatientSex"]] = None,
        birth_date: Optional[datetime.date] = None,
        clinical_info: Optional[List["_models.Resource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatientDocument(_Model):
    """A clinical document related to a patient. Document here is in the wide sense - not just a text
    document (note).

    :ivar type: The type of the patient document, such as 'note' (text document) or 'fhirBundle'
     (FHIR JSON document). Required. Known values are: "note", "fhirBundle", "dicom", and
     "genomicSequencing".
    :vartype type: str or ~azure.healthinsights.radiologyinsights.models.DocumentType
    :ivar clinical_type: The type of the clinical document. Known values are: "consultation",
     "dischargeSummary", "historyAndPhysical", "radiologyReport", "procedure", "progress",
     "laboratory", and "pathologyReport".
    :vartype clinical_type: str or
     ~azure.healthinsights.radiologyinsights.models.ClinicalDocumentType
    :ivar id: A given identifier for the document. Has to be unique across all documents for a
     single patient. Required.
    :vartype id: str
    :ivar language: A 2 letter ISO 639-1 representation of the language of the document.
    :vartype language: str
    :ivar created_at: The date and time when the document was created.
    :vartype created_at: ~datetime.datetime
    :ivar authors: Document author(s).
    :vartype authors: list[~azure.healthinsights.radiologyinsights.models.DocumentAuthor]
    :ivar specialty_type: specialty type the document. Known values are: "pathology" and
     "radiology".
    :vartype specialty_type: str or ~azure.healthinsights.radiologyinsights.models.SpecialtyType
    :ivar administrative_metadata: Administrative metadata for the document.
    :vartype administrative_metadata:
     ~azure.healthinsights.radiologyinsights.models.DocumentAdministrativeMetadata
    :ivar content: The content of the patient document. Required.
    :vartype content: ~azure.healthinsights.radiologyinsights.models.DocumentContent
    """

    type: Union[str, "_models.DocumentType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON
     document). Required. Known values are: \"note\", \"fhirBundle\", \"dicom\", and
     \"genomicSequencing\"."""
    clinical_type: Optional[Union[str, "_models.ClinicalDocumentType"]] = rest_field(
        name="clinicalType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the clinical document. Known values are: \"consultation\", \"dischargeSummary\",
     \"historyAndPhysical\", \"radiologyReport\", \"procedure\", \"progress\", \"laboratory\", and
     \"pathologyReport\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A given identifier for the document. Has to be unique across all documents for a single
     patient. Required."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A 2 letter ISO 639-1 representation of the language of the document."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date and time when the document was created."""
    authors: Optional[List["_models.DocumentAuthor"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Document author(s)."""
    specialty_type: Optional[Union[str, "_models.SpecialtyType"]] = rest_field(
        name="specialtyType", visibility=["read", "create", "update", "delete", "query"]
    )
    """specialty type the document. Known values are: \"pathology\" and \"radiology\"."""
    administrative_metadata: Optional["_models.DocumentAdministrativeMetadata"] = rest_field(
        name="administrativeMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """Administrative metadata for the document."""
    content: "_models.DocumentContent" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content of the patient document. Required."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.DocumentType"],
        id: str,  # pylint: disable=redefined-builtin
        content: "_models.DocumentContent",
        clinical_type: Optional[Union[str, "_models.ClinicalDocumentType"]] = None,
        language: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        authors: Optional[List["_models.DocumentAuthor"]] = None,
        specialty_type: Optional[Union[str, "_models.SpecialtyType"]] = None,
        administrative_metadata: Optional["_models.DocumentAdministrativeMetadata"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatientEncounter(_Model):
    """visit/encounter information.

    :ivar id: The id of the visit. Required.
    :vartype id: str
    :ivar period: Time period of the visit.
     In case of admission, use timePeriod.start to indicate the admission time and timePeriod.end to
     indicate the discharge time.
    :vartype period: ~azure.healthinsights.radiologyinsights.models.TimePeriod
    :ivar class_property: The class of the encounter. Known values are: "inpatient", "ambulatory",
     "observation", "emergency", "virtual", and "healthHome".
    :vartype class_property: str or ~azure.healthinsights.radiologyinsights.models.EncounterClass
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The id of the visit. Required."""
    period: Optional["_models.TimePeriod"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Time period of the visit.
     In case of admission, use timePeriod.start to indicate the admission time and timePeriod.end to
     indicate the discharge time."""
    class_property: Optional[Union[str, "_models.EncounterClass"]] = rest_field(
        name="class", visibility=["read", "create", "update", "delete", "query"]
    )
    """The class of the encounter. Known values are: \"inpatient\", \"ambulatory\", \"observation\",
     \"emergency\", \"virtual\", and \"healthHome\"."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        period: Optional["_models.TimePeriod"] = None,
        class_property: Optional[Union[str, "_models.EncounterClass"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PatientRecord(_Model):
    """A patient record, including their clinical information and data.

    :ivar id: A given identifier for the patient. Has to be unique across all patients in a single
     request. Required.
    :vartype id: str
    :ivar details: Patient structured information, including demographics and known structured
     clinical information.
    :vartype details: ~azure.healthinsights.radiologyinsights.models.PatientDetails
    :ivar encounters: Patient encounters/visits.
    :vartype encounters: list[~azure.healthinsights.radiologyinsights.models.PatientEncounter]
    :ivar patient_documents: Patient unstructured clinical data, given as documents.
    :vartype patient_documents:
     list[~azure.healthinsights.radiologyinsights.models.PatientDocument]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A given identifier for the patient. Has to be unique across all patients in a single request.
     Required."""
    details: Optional["_models.PatientDetails"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Patient structured information, including demographics and known structured clinical
     information."""
    encounters: Optional[List["_models.PatientEncounter"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Patient encounters/visits."""
    patient_documents: Optional[List["_models.PatientDocument"]] = rest_field(
        name="patientDocuments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Patient unstructured clinical data, given as documents."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        details: Optional["_models.PatientDetails"] = None,
        encounters: Optional[List["_models.PatientEncounter"]] = None,
        patient_documents: Optional[List["_models.PatientDocument"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Period(Element):
    """A time period defined by a start and end date and optionally time
    Based on `FHIR Period <https://www.hl7.org/fhir/R4/datatypes.html#Period>`_.

    :ivar start: Starting time with inclusive boundary.
    :vartype start: str
    :ivar end: End time with inclusive boundary, if not ongoing.
    :vartype end: str
    """

    start: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Starting time with inclusive boundary."""
    end: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """End time with inclusive boundary, if not ongoing."""

    @overload
    def __init__(
        self,
        *,
        start: Optional[str] = None,
        end: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PresentGuidanceInformation(_Model):
    """An item of the structured information (e.g. laterality or size) and one or more corresponding
    details (e.g. left or size-value).

    :ivar present_guidance_item: The item of the structured information. Required.
    :vartype present_guidance_item: str
    :ivar sizes: A list of size values, if the item is about size.
    :vartype sizes: list[~azure.healthinsights.radiologyinsights.models.Observation]
    :ivar maximum_diameter_as_in_text: The maximum diameter value, if the item is about the maximum
     diameter.
    :vartype maximum_diameter_as_in_text: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar present_guidance_values: The list of item values that are mentioned in the report.
    :vartype present_guidance_values: list[str]
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    present_guidance_item: str = rest_field(
        name="presentGuidanceItem", visibility=["read", "create", "update", "delete", "query"]
    )
    """The item of the structured information. Required."""
    sizes: Optional[List["_models.Observation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of size values, if the item is about size."""
    maximum_diameter_as_in_text: Optional["_models.Quantity"] = rest_field(
        name="maximumDiameterAsInText", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum diameter value, if the item is about the maximum diameter."""
    present_guidance_values: Optional[List[str]] = rest_field(
        name="presentGuidanceValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of item values that are mentioned in the report."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        present_guidance_item: str,
        sizes: Optional[List["_models.Observation"]] = None,
        maximum_diameter_as_in_text: Optional["_models.Quantity"] = None,
        present_guidance_values: Optional[List[str]] = None,
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QualityMeasureInference(RadiologyInsightsInference, discriminator="qualityMeasure"):
    """A QualityMeasure inference captures the  MIPS ('measure based incentive payment system')
    quality measure criteria in the document that are used to measure the data completeness.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Guidance measure inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.QUALITY_MEASURE
    :ivar quality_measure_denominator: The denominator, which identifies the QualityMeasure kind.
     Required.
    :vartype quality_measure_denominator: str
    :ivar compliance_type: The ComplianceType indicates whether the document is compliant for the
     specified QualityMeasure or not, or if exceptions apply. Required. Known values are:
     "notEligible", "performanceNotMet", "performanceMet", and "denominatorException".
    :vartype compliance_type: str or
     ~azure.healthinsights.radiologyinsights.models.QualityMeasureComplianceType
    :ivar quality_criteria: List of quality criteria identified in the document, if any.
    :vartype quality_criteria: list[str]
    """

    kind: Literal[RadiologyInsightsInferenceType.QUALITY_MEASURE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Guidance measure inference type"""
    quality_measure_denominator: str = rest_field(
        name="qualityMeasureDenominator", visibility=["read", "create", "update", "delete", "query"]
    )
    """The denominator, which identifies the QualityMeasure kind. Required."""
    compliance_type: Union[str, "_models.QualityMeasureComplianceType"] = rest_field(
        name="complianceType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ComplianceType indicates whether the document is compliant for the specified QualityMeasure
     or not, or if exceptions apply. Required. Known values are: \"notEligible\",
     \"performanceNotMet\", \"performanceMet\", and \"denominatorException\"."""
    quality_criteria: Optional[List[str]] = rest_field(
        name="qualityCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of quality criteria identified in the document, if any."""

    @overload
    def __init__(
        self,
        *,
        quality_measure_denominator: str,
        compliance_type: Union[str, "_models.QualityMeasureComplianceType"],
        extension: Optional[List["_models.Extension"]] = None,
        quality_criteria: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.QUALITY_MEASURE, **kwargs)


class QualityMeasureOptions(_Model):
    """Quality Measure Options.

    :ivar measure_types: Id(s) of the MIPS measures that need to be evaluated in the document.
     Required.
    :vartype measure_types: list[str or
     ~azure.healthinsights.radiologyinsights.models.QualityMeasureType]
    """

    measure_types: List[Union[str, "_models.QualityMeasureType"]] = rest_field(
        name="measureTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Id(s) of the MIPS measures that need to be evaluated in the document. Required."""

    @overload
    def __init__(
        self,
        *,
        measure_types: List[Union[str, "_models.QualityMeasureType"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Quantity(Element):
    """A measured or measurable amount
    Based on `FHIR Quantity <https://www.hl7.org/fhir/R4/datatypes.html#Quantity>`_.

    :ivar value: Numerical value (with implicit precision).
    :vartype value: float
    :ivar comparator: < | <= | >= | > - how to understand the value.
    :vartype comparator: str
    :ivar unit: Unit representation.
    :vartype unit: str
    :ivar system: System that defines coded unit form.
    :vartype system: str
    :ivar code: Coded form of the unit.
    :vartype code: str
    """

    value: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Numerical value (with implicit precision)."""
    comparator: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """< | <= | >= | > - how to understand the value."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit representation."""
    system: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """System that defines coded unit form."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Coded form of the unit."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[float] = None,
        comparator: Optional[str] = None,
        unit: Optional[str] = None,
        system: Optional[str] = None,
        code: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyCodeWithTypes(_Model):
    """Radiology code with types : used in imaging procedure recommendation for contrast and view.

    :ivar code: The SNOMED CT code indicates whether imaging was conducted with or without contrast
     in the case of contrast, and in the case of views, it denotes the number of views. Required.
    :vartype code: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    :ivar types: The collection of types will indicate the contrast substance used in the case of
     contrast and, in the case of views, it will specify the types of views, such as lateral and
     frontal, etc. Required.
    :vartype types: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    """

    code: "_models.CodeableConcept" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SNOMED CT code indicates whether imaging was conducted with or without contrast in the case
     of contrast, and in the case of views, it denotes the number of views. Required."""
    types: List["_models.CodeableConcept"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The collection of types will indicate the contrast substance used in the case of contrast and,
     in the case of views, it will specify the types of views, such as lateral and frontal, etc.
     Required."""

    @overload
    def __init__(
        self,
        *,
        code: "_models.CodeableConcept",
        types: List["_models.CodeableConcept"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyInsightsData(_Model):
    """Contains the list of patients, and configuration data.

    :ivar patients: The list of patients, including their clinical information and data. Required.
    :vartype patients: list[~azure.healthinsights.radiologyinsights.models.PatientRecord]
    :ivar configuration: Configuration affecting the Radiology Insights model's inference.
    :vartype configuration:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsModelConfiguration
    """

    patients: List["_models.PatientRecord"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of patients, including their clinical information and data. Required."""
    configuration: Optional["_models.RadiologyInsightsModelConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration affecting the Radiology Insights model's inference."""

    @overload
    def __init__(
        self,
        *,
        patients: List["_models.PatientRecord"],
        configuration: Optional["_models.RadiologyInsightsModelConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyInsightsInferenceOptions(_Model):
    """Options regarding follow up recommendation inferences and finding inferences.

    :ivar followup_recommendation_options: Follow-up recommendation options.
    :vartype followup_recommendation_options:
     ~azure.healthinsights.radiologyinsights.models.FollowupRecommendationOptions
    :ivar finding_options: Finding options.
    :vartype finding_options: ~azure.healthinsights.radiologyinsights.models.FindingOptions
    :ivar guidance_options: Guidance options.
    :vartype guidance_options: ~azure.healthinsights.radiologyinsights.models.GuidanceOptions
    :ivar quality_measure_options: QualityMeasureOptions.
    :vartype quality_measure_options:
     ~azure.healthinsights.radiologyinsights.models.QualityMeasureOptions
    """

    followup_recommendation_options: Optional["_models.FollowupRecommendationOptions"] = rest_field(
        name="followupRecommendationOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Follow-up recommendation options."""
    finding_options: Optional["_models.FindingOptions"] = rest_field(
        name="findingOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Finding options."""
    guidance_options: Optional["_models.GuidanceOptions"] = rest_field(
        name="guidanceOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Guidance options."""
    quality_measure_options: Optional["_models.QualityMeasureOptions"] = rest_field(
        name="qualityMeasureOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """QualityMeasureOptions."""

    @overload
    def __init__(
        self,
        *,
        followup_recommendation_options: Optional["_models.FollowupRecommendationOptions"] = None,
        finding_options: Optional["_models.FindingOptions"] = None,
        guidance_options: Optional["_models.GuidanceOptions"] = None,
        quality_measure_options: Optional["_models.QualityMeasureOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyInsightsInferenceResult(_Model):
    """The inference results for the Radiology Insights request. If field 'status' has value
    'succeeded', then field 'result' will contain an instance of RadiologyInsightsInferenceResult.

    :ivar patient_results: Results for the patients given in the request. Required.
    :vartype patient_results:
     list[~azure.healthinsights.radiologyinsights.models.RadiologyInsightsPatientResult]
    :ivar model_version: The version of the model used for inference, expressed as the model date.
     Required.
    :vartype model_version: str
    """

    patient_results: List["_models.RadiologyInsightsPatientResult"] = rest_field(
        name="patientResults", visibility=["read", "create", "update", "delete", "query"]
    )
    """Results for the patients given in the request. Required."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """The version of the model used for inference, expressed as the model date. Required."""

    @overload
    def __init__(
        self,
        *,
        patient_results: List["_models.RadiologyInsightsPatientResult"],
        model_version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyInsightsJob(_Model):
    """Response for the Radiology Insights request.

    :ivar job_data: The request data for the operation.
    :vartype job_data: ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsData
    :ivar result: The result of the operation.
    :vartype result:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceResult
    :ivar id: The unique ID of the job. Required.
    :vartype id: str
    :ivar status: The status of the job. Required. Known values are: "notStarted", "running",
     "succeeded", "failed", and "canceled".
    :vartype status: str or ~azure.healthinsights.radiologyinsights.models.JobStatus
    :ivar created_at: The date and time when the processing job was created.
    :vartype created_at: ~datetime.datetime
    :ivar expires_at: The date and time when the processing job is set to expire.
    :vartype expires_at: ~datetime.datetime
    :ivar updated_at: The date and time when the processing job was last updated.
    :vartype updated_at: ~datetime.datetime
    :ivar error: Error object that describes the error when status is "Failed".
    :vartype error: ~azure.core.ODataV4Format
    """

    job_data: Optional["_models.RadiologyInsightsData"] = rest_field(name="jobData", visibility=["read", "create"])
    """The request data for the operation."""
    result: Optional["_models.RadiologyInsightsInferenceResult"] = rest_field(visibility=["read"])
    """The result of the operation."""
    id: str = rest_field(visibility=["read"])
    """The unique ID of the job. Required."""
    status: Union[str, "_models.JobStatus"] = rest_field(visibility=["read"])
    """The status of the job. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"failed\", and \"canceled\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", visibility=["read"], format="rfc3339")
    """The date and time when the processing job was created."""
    expires_at: Optional[datetime.datetime] = rest_field(name="expiresAt", visibility=["read"], format="rfc3339")
    """The date and time when the processing job is set to expire."""
    updated_at: Optional[datetime.datetime] = rest_field(name="updatedAt", visibility=["read"], format="rfc3339")
    """The date and time when the processing job was last updated."""
    error: Optional[ODataV4Format] = rest_field(visibility=["read"])
    """Error object that describes the error when status is \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        job_data: Optional["_models.RadiologyInsightsData"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyInsightsModelConfiguration(_Model):
    """Configuration affecting the Radiology Insights model's inference.

    :ivar verbose: An indication whether the model should produce verbose output.
    :vartype verbose: bool
    :ivar include_evidence: An indication whether the model's output should include evidence for
     the inferences.
    :vartype include_evidence: bool
    :ivar inference_types: This is a list of inference types to be inferred for the current
     request. It could be used if only part of the Radiology Insights inferences are required. If
     this list is omitted or empty, the model will return all the inference types.
    :vartype inference_types: list[str or
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceType]
    :ivar inference_options: Options regarding follow up recommendation inferences and finding
     inferences.
    :vartype inference_options:
     ~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInferenceOptions
    :ivar locale: Local for the model to use. If not specified, the model will use the default
     locale.
    :vartype locale: str
    """

    verbose: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An indication whether the model should produce verbose output."""
    include_evidence: Optional[bool] = rest_field(
        name="includeEvidence", visibility=["read", "create", "update", "delete", "query"]
    )
    """An indication whether the model's output should include evidence for the inferences."""
    inference_types: Optional[List[Union[str, "_models.RadiologyInsightsInferenceType"]]] = rest_field(
        name="inferenceTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is a list of inference types to be inferred for the current request. It could be used if
     only part of the Radiology Insights inferences are required. If this list is omitted or empty,
     the model will return all the inference types."""
    inference_options: Optional["_models.RadiologyInsightsInferenceOptions"] = rest_field(
        name="inferenceOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Options regarding follow up recommendation inferences and finding inferences."""
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Local for the model to use. If not specified, the model will use the default locale."""

    @overload
    def __init__(
        self,
        *,
        verbose: Optional[bool] = None,
        include_evidence: Optional[bool] = None,
        inference_types: Optional[List[Union[str, "_models.RadiologyInsightsInferenceType"]]] = None,
        inference_options: Optional["_models.RadiologyInsightsInferenceOptions"] = None,
        locale: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyInsightsPatientResult(_Model):
    """Results of the model's work for a single patient.

    :ivar patient_id: Identifier given for the patient in the request. Required.
    :vartype patient_id: str
    :ivar inferences: The model's inferences for the given patient. Required.
    :vartype inferences:
     list[~azure.healthinsights.radiologyinsights.models.RadiologyInsightsInference]
    """

    patient_id: str = rest_field(name="patientId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier given for the patient in the request. Required."""
    inferences: List["_models.RadiologyInsightsInference"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The model's inferences for the given patient. Required."""

    @overload
    def __init__(
        self,
        *,
        patient_id: str,
        inferences: List["_models.RadiologyInsightsInference"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RadiologyProcedureInference(RadiologyInsightsInference, discriminator="radiologyProcedure"):
    """Radiology procedures are the specific imaging studies or examinations ordered for the patient,
    extracted from the document information and text.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Radiology Procedure inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.RADIOLOGY_PROCEDURE
    :ivar procedure_codes: LOINC codes for the procedure.
    :vartype procedure_codes: list[~azure.healthinsights.radiologyinsights.models.CodeableConcept]
    :ivar imaging_procedures: Imaging procedures. Required.
    :vartype imaging_procedures:
     list[~azure.healthinsights.radiologyinsights.models.ImagingProcedure]
    :ivar ordered_procedure: Ordered procedure information from the document information or text.
     Required.
    :vartype ordered_procedure: ~azure.healthinsights.radiologyinsights.models.OrderedProcedure
    """

    kind: Literal[RadiologyInsightsInferenceType.RADIOLOGY_PROCEDURE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Radiology Procedure inference type"""
    procedure_codes: Optional[List["_models.CodeableConcept"]] = rest_field(
        name="procedureCodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """LOINC codes for the procedure."""
    imaging_procedures: List["_models.ImagingProcedure"] = rest_field(
        name="imagingProcedures", visibility=["read", "create", "update", "delete", "query"]
    )
    """Imaging procedures. Required."""
    ordered_procedure: "_models.OrderedProcedure" = rest_field(
        name="orderedProcedure", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ordered procedure information from the document information or text. Required."""

    @overload
    def __init__(
        self,
        *,
        imaging_procedures: List["_models.ImagingProcedure"],
        ordered_procedure: "_models.OrderedProcedure",
        extension: Optional[List["_models.Extension"]] = None,
        procedure_codes: Optional[List["_models.CodeableConcept"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.RADIOLOGY_PROCEDURE, **kwargs)


class Range(Element):
    """A set of ordered Quantities defined by a low and high limit
    Based on `FHIR Range <https://www.hl7.org/fhir/R4/datatypes.html#Range>`_.

    :ivar low: Low limit.
    :vartype low: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar high: High limit.
    :vartype high: ~azure.healthinsights.radiologyinsights.models.Quantity
    """

    low: Optional["_models.Quantity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Low limit."""
    high: Optional["_models.Quantity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """High limit."""

    @overload
    def __init__(
        self,
        *,
        low: Optional["_models.Quantity"] = None,
        high: Optional["_models.Quantity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Ratio(Element):
    """A ratio of two Quantity values - a numerator and a denominator
    Based on `FHIR Ratio <https://www.hl7.org/fhir/R4/datatypes.html#Ratio>`_.

    :ivar numerator: Numerator value.
    :vartype numerator: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar denominator: Denominator value.
    :vartype denominator: ~azure.healthinsights.radiologyinsights.models.Quantity
    """

    numerator: Optional["_models.Quantity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Numerator value."""
    denominator: Optional["_models.Quantity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Denominator value."""

    @overload
    def __init__(
        self,
        *,
        numerator: Optional["_models.Quantity"] = None,
        denominator: Optional["_models.Quantity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RecommendationFinding(_Model):
    """Finding reference for recommendation.

    :ivar finding: Finding linked to a recommendation.
    :vartype finding: ~azure.healthinsights.radiologyinsights.models.Observation
    :ivar critical_finding: Critical result linked to a recommendation.
    :vartype critical_finding: ~azure.healthinsights.radiologyinsights.models.CriticalResult
    :ivar recommendation_finding_status: Recommendation finding status. Required. Known values are:
     "present", "differential", "ruleOut", and "conditional".
    :vartype recommendation_finding_status: str or
     ~azure.healthinsights.radiologyinsights.models.RecommendationFindingStatusType
    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    """

    finding: Optional["_models.Observation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Finding linked to a recommendation."""
    critical_finding: Optional["_models.CriticalResult"] = rest_field(
        name="criticalFinding", visibility=["read", "create", "update", "delete", "query"]
    )
    """Critical result linked to a recommendation."""
    recommendation_finding_status: Union[str, "_models.RecommendationFindingStatusType"] = rest_field(
        name="recommendationFindingStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Recommendation finding status. Required. Known values are: \"present\", \"differential\",
     \"ruleOut\", and \"conditional\"."""
    extension: Optional[List["_models.Extension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional Content defined by implementations."""

    @overload
    def __init__(
        self,
        *,
        recommendation_finding_status: Union[str, "_models.RecommendationFindingStatusType"],
        finding: Optional["_models.Observation"] = None,
        critical_finding: Optional["_models.CriticalResult"] = None,
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Reference(Element):
    """A reference from one resource to another
    Based on `FHIR Reference <https://www.hl7.org/fhir/R4/references.html>`_.

    :ivar reference: Literal reference, Relative, internal or absolute URL.
    :vartype reference: str
    :ivar type: Type the reference refers to (e.g. "Patient").
    :vartype type: str
    :ivar identifier: Logical reference, when literal reference is not known.
    :vartype identifier: ~azure.healthinsights.radiologyinsights.models.Identifier
    :ivar display: Text alternative for the resource.
    :vartype display: str
    """

    reference: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Literal reference, Relative, internal or absolute URL."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type the reference refers to (e.g. \"Patient\")."""
    identifier: Optional["_models.Identifier"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Logical reference, when literal reference is not known."""
    display: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text alternative for the resource."""

    @overload
    def __init__(
        self,
        *,
        reference: Optional[str] = None,
        type: Optional[str] = None,
        identifier: Optional["_models.Identifier"] = None,
        display: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SampledData(Element):
    """A series of measurements taken by a device
    Based on `FHIR SampledData <https://www.hl7.org/fhir/R4/datatypes.html#SampledData>`_.

    :ivar origin: Zero value and units. Required.
    :vartype origin: ~azure.healthinsights.radiologyinsights.models.Quantity
    :ivar period: Number of milliseconds between samples. Required.
    :vartype period: float
    :ivar factor: Multiply data by this before adding to origin.
    :vartype factor: float
    :ivar lower_limit: Lower limit of detection.
    :vartype lower_limit: float
    :ivar upper_limit: Upper limit of detection.
    :vartype upper_limit: float
    :ivar dimensions: Number of sample points at each time point. Required.
    :vartype dimensions: int
    :ivar data: Decimal values with spaces, or "E" | "U" | "L".
    :vartype data: str
    """

    origin: "_models.Quantity" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Zero value and units. Required."""
    period: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of milliseconds between samples. Required."""
    factor: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Multiply data by this before adding to origin."""
    lower_limit: Optional[float] = rest_field(
        name="lowerLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """Lower limit of detection."""
    upper_limit: Optional[float] = rest_field(
        name="upperLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """Upper limit of detection."""
    dimensions: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of sample points at each time point. Required."""
    data: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Decimal values with spaces, or \"E\" | \"U\" | \"L\"."""

    @overload
    def __init__(
        self,
        *,
        origin: "_models.Quantity",
        period: float,
        dimensions: int,
        factor: Optional[float] = None,
        lower_limit: Optional[float] = None,
        upper_limit: Optional[float] = None,
        data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScoringAndAssessmentInference(RadiologyInsightsInference, discriminator="scoringAndAssessment"):
    """Identifies and highlights Risk, Scoring, Assessment and Classifications and correspondent
    values dictated in a report, e.g. 'BIRADS 5'.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Scoring and assessment inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.SCORING_AND_ASSESSMENT
    :ivar category: Category, e.g. BIRADS. Required. Known values are: "BIRADS", "C-RADS COLONIC
     FINDINGS", "CAD-RADS", "LI-RADS", "LUNG-RADS", "NI-RADS", "O-RADS", "PI-RADS", "TI-RADS",
     "C-RADS EXTRACOLONIC FINDINGS", "LIFETIME BREAST CANCER RISK", "ASCVD RISK", "MODIFIED GAIL
     MODEL RISK", "TYRER CUSICK MODEL RISK", "AGATSTON SCORE", "10 YEAR CHD RISK", "Z-SCORE",
     "T-SCORE", "CALCIUM VOLUME SCORE", "US LI-RADS VISUALIZATION SCORE", "US LI-RADS", "CEUS
     LI-RADS", "TREATMENT RESPONSE LI-RADS", "O-RADS MRI", "CALCIUM MASS SCORE", "RISK OF MALIGNANCY
     INDEX", "HNPCC MUTATION RISK", "ALBERTA STROKE PROGRAM EARLY CT SCORE", "KELLGREN-LAWRENCE
     GRADING SCALE", "TONNIS CLASSIFICATION", "CALCIUM SCORE (UNSPECIFIED)", "10 YEAR CHD RISK
     (OBSERVED AGE)", "10 YEAR CHD RISK (ARTERIAL AGE)", and "FRAX SCORE".
    :vartype category: str or
     ~azure.healthinsights.radiologyinsights.models.ScoringAndAssessmentCategoryType
    :ivar category_description: The expansion of the category (which is an abbreviation.).
     Required.
    :vartype category_description: str
    :ivar single_value: The value. If the value is a range, use field rangeValue.
    :vartype single_value: str
    :ivar range_value: The range.
    :vartype range_value: ~azure.healthinsights.radiologyinsights.models.AssessmentValueRange
    """

    kind: Literal[RadiologyInsightsInferenceType.SCORING_AND_ASSESSMENT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Scoring and assessment inference type"""
    category: Union[str, "_models.ScoringAndAssessmentCategoryType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Category, e.g. BIRADS. Required. Known values are: \"BIRADS\", \"C-RADS COLONIC FINDINGS\",
     \"CAD-RADS\", \"LI-RADS\", \"LUNG-RADS\", \"NI-RADS\", \"O-RADS\", \"PI-RADS\", \"TI-RADS\",
     \"C-RADS EXTRACOLONIC FINDINGS\", \"LIFETIME BREAST CANCER RISK\", \"ASCVD RISK\", \"MODIFIED
     GAIL MODEL RISK\", \"TYRER CUSICK MODEL RISK\", \"AGATSTON SCORE\", \"10 YEAR CHD RISK\",
     \"Z-SCORE\", \"T-SCORE\", \"CALCIUM VOLUME SCORE\", \"US LI-RADS VISUALIZATION SCORE\", \"US
     LI-RADS\", \"CEUS LI-RADS\", \"TREATMENT RESPONSE LI-RADS\", \"O-RADS MRI\", \"CALCIUM MASS
     SCORE\", \"RISK OF MALIGNANCY INDEX\", \"HNPCC MUTATION RISK\", \"ALBERTA STROKE PROGRAM EARLY
     CT SCORE\", \"KELLGREN-LAWRENCE GRADING SCALE\", \"TONNIS CLASSIFICATION\", \"CALCIUM SCORE
     (UNSPECIFIED)\", \"10 YEAR CHD RISK (OBSERVED AGE)\", \"10 YEAR CHD RISK (ARTERIAL AGE)\", and
     \"FRAX SCORE\"."""
    category_description: str = rest_field(
        name="categoryDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """The expansion of the category (which is an abbreviation.). Required."""
    single_value: Optional[str] = rest_field(
        name="singleValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """The value. If the value is a range, use field rangeValue."""
    range_value: Optional["_models.AssessmentValueRange"] = rest_field(
        name="rangeValue", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.ScoringAndAssessmentCategoryType"],
        category_description: str,
        extension: Optional[List["_models.Extension"]] = None,
        single_value: Optional[str] = None,
        range_value: Optional["_models.AssessmentValueRange"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.SCORING_AND_ASSESSMENT, **kwargs)


class SexMismatchInference(RadiologyInsightsInference, discriminator="sexMismatch"):
    """A notification for a sex mismatch is displayed when the gender, personal pronouns,
    gender-related body parts, or gender-related procedures mentioned in a patient's clinical
    document are either inconsistent or do not match the gender specified in the patient
    information.

    :ivar extension: Additional Content defined by implementations.
    :vartype extension: list[~azure.healthinsights.radiologyinsights.models.Extension]
    :ivar kind: Inference type. Required. Sex mismatch inference type
    :vartype kind: str or ~azure.healthinsights.radiologyinsights.models.SEX_MISMATCH
    :ivar sex_indication: Sex indication : SNOMED CT code for gender finding. Required.
    :vartype sex_indication: ~azure.healthinsights.radiologyinsights.models.CodeableConcept
    """

    kind: Literal[RadiologyInsightsInferenceType.SEX_MISMATCH] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Inference type. Required. Sex mismatch inference type"""
    sex_indication: "_models.CodeableConcept" = rest_field(
        name="sexIndication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Sex indication : SNOMED CT code for gender finding. Required."""

    @overload
    def __init__(
        self,
        *,
        sex_indication: "_models.CodeableConcept",
        extension: Optional[List["_models.Extension"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=RadiologyInsightsInferenceType.SEX_MISMATCH, **kwargs)


class TimePeriod(_Model):
    """A duration of time during which an event is happening.

    :ivar start: Starting time with inclusive boundary.
    :vartype start: ~datetime.datetime
    :ivar end: End time with inclusive boundary, if not ongoing.
    :vartype end: ~datetime.datetime
    """

    start: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Starting time with inclusive boundary."""
    end: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """End time with inclusive boundary, if not ongoing."""

    @overload
    def __init__(
        self,
        *,
        start: Optional[datetime.datetime] = None,
        end: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
