# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ApiEntityReference(_Model):
    """The API entity reference.

    :ivar resource_id: The Azure resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/..."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupRestoreRequestBaseProperties(_Model):
    """Backup and Restore Common properties.

    :ivar azure_storage_blob_container_uri: The Azure blob storage container Uri which contains the
     backup. Required.
    :vartype azure_storage_blob_container_uri: str
    :ivar token: The SAS token pointing to an Azure blob storage container. This property is
     reserved for Azure Backup Service.
    :vartype token: str
    """

    azure_storage_blob_container_uri: str = rest_field(
        name="azureStorageBlobContainerUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure blob storage container Uri which contains the backup. Required."""
    token: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SAS token pointing to an Azure blob storage container. This property is reserved for Azure
     Backup Service."""

    @overload
    def __init__(
        self,
        *,
        azure_storage_blob_container_uri: str,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupRequestProperties(BackupRestoreRequestBaseProperties):
    """Backup properties.

    :ivar azure_storage_blob_container_uri: The Azure blob storage container Uri which contains the
     backup. Required.
    :vartype azure_storage_blob_container_uri: str
    :ivar token: The SAS token pointing to an Azure blob storage container. This property is
     reserved for Azure Backup Service.
    :vartype token: str
    """

    @overload
    def __init__(
        self,
        *,
        azure_storage_blob_container_uri: str,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupRestoreBaseResultProperties(_Model):
    """Backup and Restore operation common properties.

    :ivar status: Status of the backup/restore operation. Known values are: "InProgress",
     "Succeeded", "Failed", and "Cancelled".
    :vartype status: str or ~azure.mgmt.hardwaresecuritymodules.models.BackupRestoreOperationStatus
    :ivar status_details: The status details of backup/restore operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the backup/restore operation.
    :vartype error: ~azure.mgmt.hardwaresecuritymodules.models.ErrorDetail
    :ivar start_time: The start time of the backup/restore operation in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the backup/restore operation in UTC.
    :vartype end_time: ~datetime.datetime
    :ivar job_id: Identifier for the backup/restore operation.
    :vartype job_id: str
    """

    status: Optional[Union[str, "_models.BackupRestoreOperationStatus"]] = rest_field(visibility=["read"])
    """Status of the backup/restore operation. Known values are: \"InProgress\", \"Succeeded\",
     \"Failed\", and \"Cancelled\"."""
    status_details: Optional[str] = rest_field(
        name="statusDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """The status details of backup/restore operation."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error encountered, if any, during the backup/restore operation."""
    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """The start time of the backup/restore operation in UTC."""
    end_time: Optional[datetime.datetime] = rest_field(name="endTime", visibility=["read"], format="rfc3339")
    """The end time of the backup/restore operation in UTC."""
    job_id: Optional[str] = rest_field(name="jobId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier for the backup/restore operation."""

    @overload
    def __init__(
        self,
        *,
        status_details: Optional[str] = None,
        error: Optional["_models.ErrorDetail"] = None,
        job_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupResult(_Model):
    """Backup operation Result.

    :ivar properties: Properties of the Cloud HSM Cluster.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.BackupResultProperties
    """

    properties: Optional["_models.BackupResultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the Cloud HSM Cluster."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BackupResultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupResultProperties(BackupRestoreBaseResultProperties):
    """Properties of the Cloud HSM Cluster.

    :ivar status: Status of the backup/restore operation. Known values are: "InProgress",
     "Succeeded", "Failed", and "Cancelled".
    :vartype status: str or ~azure.mgmt.hardwaresecuritymodules.models.BackupRestoreOperationStatus
    :ivar status_details: The status details of backup/restore operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the backup/restore operation.
    :vartype error: ~azure.mgmt.hardwaresecuritymodules.models.ErrorDetail
    :ivar start_time: The start time of the backup/restore operation in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the backup/restore operation in UTC.
    :vartype end_time: ~datetime.datetime
    :ivar job_id: Identifier for the backup/restore operation.
    :vartype job_id: str
    :ivar azure_storage_blob_container_uri: The Azure blob storage container Uri which contains the
     backup.
    :vartype azure_storage_blob_container_uri: str
    :ivar backup_id: The ID of the backup.
    :vartype backup_id: str
    """

    azure_storage_blob_container_uri: Optional[str] = rest_field(
        name="azureStorageBlobContainerUri", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure blob storage container Uri which contains the backup."""
    backup_id: Optional[str] = rest_field(name="backupId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the backup."""

    @overload
    def __init__(
        self,
        *,
        status_details: Optional[str] = None,
        error: Optional["_models.ErrorDetail"] = None,
        job_id: Optional[str] = None,
        azure_storage_blob_container_uri: Optional[str] = None,
        backup_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudHsmCluster(TrackedResource):
    """Resource information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the Cloud HSM Cluster.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterProperties
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
    :ivar sku: SKU details.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSku
    """

    properties: Optional["_models.CloudHsmClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the Cloud HSM Cluster."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed service identity (system assigned and/or user assigned identities)."""
    sku: Optional["_models.CloudHsmClusterSku"] = rest_field(visibility=["read", "create"])
    """SKU details."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudHsmClusterProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        sku: Optional["_models.CloudHsmClusterSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudHsmClusterPatchParameters(_Model):
    """Patchable properties of the Cloud HSM Cluster.

    :ivar tags: The Cloud HSM Cluster's tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity (system assigned and/or user assigned identities).
    :vartype identity: ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentity
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Cloud HSM Cluster's tags."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed service identity (system assigned and/or user assigned identities)."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudHsmClusterProperties(_Model):
    """Properties of a Cloud HSM Cluster.

    :ivar activation_state: State of security domain activation. Known values are: "NotDefined",
     "NotActivated", "Active", "Failed", and "Unknown".
    :vartype activation_state: str or ~azure.mgmt.hardwaresecuritymodules.models.ActivationState
    :ivar auto_generated_domain_name_label_scope: The Cloud HSM Cluster's auto-generated Domain
     Name Label Scope. Known values are: "TenantReuse", "SubscriptionReuse", "ResourceGroupReuse",
     and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.hardwaresecuritymodules.models.AutoGeneratedDomainNameLabelScope
    :ivar hsms: An array of Cloud HSM Cluster's HSMs.
    :vartype hsms: list[~azure.mgmt.hardwaresecuritymodules.models.CloudHsmProperties]
    :ivar private_endpoint_connections: List of private endpoint connection resources.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnection]
    :ivar provisioning_state: The Cloud HSM Cluster's provisioningState. Known values are:
     "Provisioning", "Succeeded", "Updating", "Failed", "Deleting", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hardwaresecuritymodules.models.ProvisioningState
    :ivar public_network_access: The Cloud HSM Cluster public network access. "Disabled"
    :vartype public_network_access: str or
     ~azure.mgmt.hardwaresecuritymodules.models.PublicNetworkAccess
    :ivar status_message: Cloud HSM Cluster status message.
    :vartype status_message: str
    """

    activation_state: Optional[Union[str, "_models.ActivationState"]] = rest_field(
        name="activationState", visibility=["read"]
    )
    """State of security domain activation. Known values are: \"NotDefined\", \"NotActivated\",
     \"Active\", \"Failed\", and \"Unknown\"."""
    auto_generated_domain_name_label_scope: Optional[Union[str, "_models.AutoGeneratedDomainNameLabelScope"]] = (
        rest_field(name="autoGeneratedDomainNameLabelScope", visibility=["read", "create", "update", "delete", "query"])
    )
    """The Cloud HSM Cluster's auto-generated Domain Name Label Scope. Known values are:
     \"TenantReuse\", \"SubscriptionReuse\", \"ResourceGroupReuse\", and \"NoReuse\"."""
    hsms: Optional[List["_models.CloudHsmProperties"]] = rest_field(visibility=["read"])
    """An array of Cloud HSM Cluster's HSMs."""
    private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connection resources."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The Cloud HSM Cluster's provisioningState. Known values are: \"Provisioning\", \"Succeeded\",
     \"Updating\", \"Failed\", \"Deleting\", and \"Canceled\"."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Cloud HSM Cluster public network access. \"Disabled\""""
    status_message: Optional[str] = rest_field(name="statusMessage", visibility=["read"])
    """Cloud HSM Cluster status message."""

    @overload
    def __init__(
        self,
        *,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudHsmClusterSku(_Model):
    """Cloud Hsm Cluster SKU information.

    :ivar family: Sku family of the Cloud HSM Cluster. Required. "B"
    :vartype family: str or ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSkuFamily
    :ivar name: Sku name of the Cloud HSM Cluster. Required. Known values are: "Standard_B1" and
     "Standard B10".
    :vartype name: str or ~azure.mgmt.hardwaresecuritymodules.models.CloudHsmClusterSkuName
    :ivar capacity: Sku capacity.
    :vartype capacity: int
    """

    family: Union[str, "_models.CloudHsmClusterSkuFamily"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Sku family of the Cloud HSM Cluster. Required. \"B\""""
    name: Union[str, "_models.CloudHsmClusterSkuName"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Sku name of the Cloud HSM Cluster. Required. Known values are: \"Standard_B1\" and \"Standard
     B10\"."""
    capacity: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku capacity."""

    @overload
    def __init__(
        self,
        *,
        family: Union[str, "_models.CloudHsmClusterSkuFamily"],
        name: Union[str, "_models.CloudHsmClusterSkuName"],
        capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CloudHsmProperties(_Model):
    """The Cloud HSM Properties.

    :ivar fqdn: FQDN of the Cloud HSM.
    :vartype fqdn: str
    :ivar state: The Cloud HSM State. Values are: Deploying, ConfiguringSlb, Starting, Starting,
     Failed, Failed, Deleting, DeletingSlbEntry, InitialProvisioning, Updating.
    :vartype state: str
    :ivar state_message: The Cloud HSM State message.
    :vartype state_message: str
    """

    fqdn: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """FQDN of the Cloud HSM."""
    state: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Cloud HSM State. Values are: Deploying, ConfiguringSlb, Starting, Starting, Failed, Failed,
     Deleting, DeletingSlbEntry, InitialProvisioning, Updating."""
    state_message: Optional[str] = rest_field(
        name="stateMessage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Cloud HSM State message."""

    @overload
    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        state: Optional[str] = None,
        state_message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DedicatedHsm(TrackedResource):
    """Resource information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: SKU details. Required.
    :vartype sku: ~azure.mgmt.hardwaresecuritymodules.models.Sku
    :ivar zones: The availability zones.
    :vartype zones: list[str]
    :ivar properties: Properties of the dedicated HSM. Required.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.DedicatedHsmProperties
    """

    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SKU details. Required."""
    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The availability zones."""
    properties: "_models.DedicatedHsmProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the dedicated HSM. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        properties: "_models.DedicatedHsmProperties",
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DedicatedHsmError(_Model):
    """The error exception.

    :ivar error: The error detail of the operation if any.
    :vartype error: ~azure.mgmt.hardwaresecuritymodules.models.Error
    """

    error: Optional["_models.Error"] = rest_field(visibility=["read"])
    """The error detail of the operation if any."""


class DedicatedHsmPatchParameters(_Model):
    """Patchable properties of the dedicated HSM.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DedicatedHsmProperties(_Model):
    """Properties of the dedicated hsm.

    :ivar network_profile: Specifies the network interfaces of the dedicated hsm.
    :vartype network_profile: ~azure.mgmt.hardwaresecuritymodules.models.NetworkProfile
    :ivar management_network_profile: Specifies the management network interfaces of the dedicated
     hsm.
    :vartype management_network_profile: ~azure.mgmt.hardwaresecuritymodules.models.NetworkProfile
    :ivar stamp_id: This field will be used when RP does not support Availability zones.
    :vartype stamp_id: str
    :ivar status_message: Resource Status Message.
    :vartype status_message: str
    :ivar provisioning_state: Provisioning state. Known values are: "Succeeded", "Provisioning",
     "Allocating", "Connecting", "Failed", "CheckingQuota", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.hardwaresecuritymodules.models.JsonWebKeyType
    """

    network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="networkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the network interfaces of the dedicated hsm."""
    management_network_profile: Optional["_models.NetworkProfile"] = rest_field(
        name="managementNetworkProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the management network interfaces of the dedicated hsm."""
    stamp_id: Optional[str] = rest_field(name="stampId", visibility=["read", "create", "update", "delete", "query"])
    """This field will be used when RP does not support Availability zones."""
    status_message: Optional[str] = rest_field(name="statusMessage", visibility=["read"])
    """Resource Status Message."""
    provisioning_state: Optional[Union[str, "_models.JsonWebKeyType"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state. Known values are: \"Succeeded\", \"Provisioning\", \"Allocating\",
     \"Connecting\", \"Failed\", \"CheckingQuota\", and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        network_profile: Optional["_models.NetworkProfile"] = None,
        management_network_profile: Optional["_models.NetworkProfile"] = None,
        stamp_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointDependency(_Model):
    """A domain name that dedicated hsm services are reaching at.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The Ports and Protocols used when connecting to domainName.
    :vartype endpoint_details: list[~azure.mgmt.hardwaresecuritymodules.models.EndpointDetail]
    """

    domain_name: Optional[str] = rest_field(
        name="domainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The domain name of the dependency."""
    endpoint_details: Optional[List["_models.EndpointDetail"]] = rest_field(
        name="endpointDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Ports and Protocols used when connecting to domainName."""

    @overload
    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointDetail(_Model):
    """Connect information from the dedicated hsm service to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar protocol: The protocol used for connection.
    :vartype protocol: str
    :ivar description: Description of the detail.
    :vartype description: str
    """

    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read", "create", "update", "delete", "query"])
    """An IP Address that Domain Name currently resolves to."""
    port: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The port an endpoint is connected to."""
    protocol: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The protocol used for connection."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the detail."""

    @overload
    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The key vault server error.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: Contains more specific error that narrows down the cause. May be null.
    :vartype inner_error: ~azure.mgmt.hardwaresecuritymodules.models.Error
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    inner_error: Optional["_models.Error"] = rest_field(name="innererror", visibility=["read"])
    """Contains more specific error that narrows down the cause. May be null."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hardwaresecuritymodules.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hardwaresecuritymodules.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hardwaresecuritymodules.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.hardwaresecuritymodules.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.hardwaresecuritymodules.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkInterface(_Model):
    """The network interface definition.

    :ivar resource_id: The Azure resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype resource_id: str
    :ivar private_ip_address: Private Ip address of the interface.
    :vartype private_ip_address: str
    """

    resource_id: Optional[str] = rest_field(name="resourceId", visibility=["read"])
    """The Azure resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/..."""
    private_ip_address: Optional[str] = rest_field(
        name="privateIpAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private Ip address of the interface."""

    @overload
    def __init__(
        self,
        *,
        private_ip_address: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkProfile(_Model):
    """The network profile definition.

    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.hardwaresecuritymodules.models.ApiEntityReference
    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the dedicated HSM.
    :vartype network_interfaces: list[~azure.mgmt.hardwaresecuritymodules.models.NetworkInterface]
    """

    subnet: Optional["_models.ApiEntityReference"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the identifier of the subnet."""
    network_interfaces: Optional[List["_models.NetworkInterface"]] = rest_field(
        name="networkInterfaces", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the list of resource Ids for the network interfaces associated with the dedicated
     HSM."""

    @overload
    def __init__(
        self,
        *,
        subnet: Optional["_models.ApiEntityReference"] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.hardwaresecuritymodules.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.hardwaresecuritymodules.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.hardwaresecuritymodules.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OutboundEnvironmentEndpoint(_Model):
    """Egress endpoints which dedicated hsm service connects to for common purpose.

    :ivar category: The category of endpoints accessed by the dedicated hsm service, e.g.
     azure-resource-management, apiserver, etc.
    :vartype category: str
    :ivar endpoints: The endpoints that dedicated hsm service connects to.
    :vartype endpoints: list[~azure.mgmt.hardwaresecuritymodules.models.EndpointDependency]
    """

    category: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The category of endpoints accessed by the dedicated hsm service, e.g.
     azure-resource-management, apiserver, etc."""
    endpoints: Optional[List["_models.EndpointDependency"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The endpoints that dedicated hsm service connects to."""

    @overload
    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """The private endpoint resource.

    :ivar id: The resource identifier of the private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier of the private endpoint."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    """


class PrivateEndpointConnection(ProxyResource):
    """The private endpoint connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties:
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnectionProperties
    :ivar etag: Modified whenever there is a change in the state of private endpoint connection.
    :vartype etag: str
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""
    etag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Modified whenever there is a change in the state of private endpoint connection."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
        etag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProperties(_Model):
    """Properties of the private endpoint connection.

    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", "Failed", "Updating", "InternalError",
     and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointConnectionProvisioningState
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    """

    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint resource."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection resource. Known values are:
     \"Succeeded\", \"Creating\", \"Deleting\", \"Failed\", \"Updating\", \"InternalError\", and
     \"Canceled\"."""
    group_ids: Optional[List[str]] = rest_field(name="groupIds", visibility=["read"])
    """The group ids for the private endpoint resource."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(Resource):
    """A private link resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hardwaresecuritymodules.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.hardwaresecuritymodules.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[List[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[List[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link resource private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.hardwaresecuritymodules.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", and \"Rejected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreRequestProperties(BackupRestoreRequestBaseProperties):
    """Cloud Hsm Cluster restore information.

    :ivar azure_storage_blob_container_uri: The Azure blob storage container Uri which contains the
     backup. Required.
    :vartype azure_storage_blob_container_uri: str
    :ivar token: The SAS token pointing to an Azure blob storage container. This property is
     reserved for Azure Backup Service.
    :vartype token: str
    :ivar backup_id: An autogenerated unique string ID for labeling the backup. It contains both a
     UUID and a date timestamp. Required.
    :vartype backup_id: str
    """

    backup_id: str = rest_field(name="backupId", visibility=["read", "create", "update", "delete", "query"])
    """An autogenerated unique string ID for labeling the backup. It contains both a UUID and a date
     timestamp. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_storage_blob_container_uri: str,
        backup_id: str,
        token: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestoreResult(_Model):
    """Restore operation properties.

    :ivar properties: Backup and Restore operation common properties.
    :vartype properties:
     ~azure.mgmt.hardwaresecuritymodules.models.BackupRestoreBaseResultProperties
    """

    properties: Optional["_models.BackupRestoreBaseResultProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Backup and Restore operation common properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BackupRestoreBaseResultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Sku(_Model):
    """SKU of the dedicated HSM.

    :ivar name: SKU of the dedicated HSM. Known values are: "SafeNet Luna Network HSM A790",
     "payShield10K_LMK1_CPS60", "payShield10K_LMK1_CPS250", "payShield10K_LMK1_CPS2500",
     "payShield10K_LMK2_CPS60", "payShield10K_LMK2_CPS250", and "payShield10K_LMK2_CPS2500".
    :vartype name: str or ~azure.mgmt.hardwaresecuritymodules.models.SkuName
    """

    name: Optional[Union[str, "_models.SkuName"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """SKU of the dedicated HSM. Known values are: \"SafeNet Luna Network HSM A790\",
     \"payShield10K_LMK1_CPS60\", \"payShield10K_LMK1_CPS250\", \"payShield10K_LMK1_CPS2500\",
     \"payShield10K_LMK2_CPS60\", \"payShield10K_LMK2_CPS250\", and \"payShield10K_LMK2_CPS2500\"."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.SkuName"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hardwaresecuritymodules.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
