# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class EncryptionIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity type of ManagedIdentity Associated with Dell FileSystem resource."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    """System Assigned Managed identity"""
    USER_ASSIGNED = "UserAssigned"
    """User Assigned managed identity"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class MarketplaceSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Marketplace subscription status of the file system resource."""

    PENDING_FULFILLMENT_START = "PendingFulfillmentStart"
    """Fulfillment has not started"""
    SUBSCRIBED = "Subscribed"
    """Marketplace offer is subscribed"""
    SUSPENDED = "Suspended"
    """Marketplace offer is suspended because of non payment"""
    UNSUBSCRIBED = "Unsubscribed"
    """Marketplace offer is unsubscribed"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning State of the File system resource."""

    ACCEPTED = "Accepted"
    """File system resource creation request accepted"""
    CREATING = "Creating"
    """File system resource creation started"""
    UPDATING = "Updating"
    """File system resource is being updated"""
    DELETING = "Deleting"
    """File system resource deletion started"""
    SUCCEEDED = "Succeeded"
    """File system resource creation successful"""
    FAILED = "Failed"
    """File system resource creation failed"""
    CANCELED = "Canceled"
    """File system resource creation canceled"""
    DELETED = "Deleted"
    """File system resource is deleted"""
    NOT_SPECIFIED = "NotSpecified"
    """File system resource state is unknown"""


class ResourceEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity type of ManagedIdentity Associated with Dell FileSystem resource."""

    MICROSOFT_MANAGED_KEYS_MMK_ = "Microsoft-managed keys (MMK)"
    """Microsoft managed keys (Default)"""
    CUSTOMER_MANAGED_KEYS_CMK_ = "Customer-managed keys (CMK)"
    """Customer managed keys
    (CMK) - Only UserAssigned identity is supported"""
