# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._alert_processing_rules_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_by_name_request,
    build_list_by_resource_group_request,
    build_list_by_subscription_request,
    build_update_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AlertProcessingRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.alertsmanagement.aio.AlertsManagementClient`'s
        :attr:`alert_processing_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncIterable["_models.AlertProcessingRule"]:
        """List all alert processing rules in a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AlertProcessingRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.alertsmanagement.models.AlertProcessingRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-08-08"] = kwargs.pop("api_version", _params.pop("api-version", "2021-08-08"))
        cls: ClsType[_models.AlertProcessingRulesList] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_subscription.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AlertProcessingRulesList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_subscription.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.AlertsManagement/actionRules"
    }

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.AlertProcessingRule"]:
        """List all alert processing rules in a resource group.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AlertProcessingRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.alertsmanagement.models.AlertProcessingRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-08-08"] = kwargs.pop("api_version", _params.pop("api-version", "2021-08-08"))
        cls: ClsType[_models.AlertProcessingRulesList] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AlertProcessingRulesList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules"
    }

    @distributed_trace_async
    async def get_by_name(
        self, resource_group_name: str, alert_processing_rule_name: str, **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Get an alert processing rule by name.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name of the alert processing rule that needs to be
         fetched. Required.
        :type alert_processing_rule_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-08-08"] = kwargs.pop("api_version", _params.pop("api-version", "2021-08-08"))
        cls: ClsType[_models.AlertProcessingRule] = kwargs.pop("cls", None)

        request = build_get_by_name_request(
            resource_group_name=resource_group_name,
            alert_processing_rule_name=alert_processing_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_by_name.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        deserialized = self._deserialize("AlertProcessingRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_by_name.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}"
    }

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        alert_processing_rule_name: str,
        alert_processing_rule: _models.AlertProcessingRule,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Create or update an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name of the alert processing rule that needs to be
         created/updated. Required.
        :type alert_processing_rule_name: str
        :param alert_processing_rule: Alert processing rule to be created/updated. Required.
        :type alert_processing_rule: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        alert_processing_rule_name: str,
        alert_processing_rule: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Create or update an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name of the alert processing rule that needs to be
         created/updated. Required.
        :type alert_processing_rule_name: str
        :param alert_processing_rule: Alert processing rule to be created/updated. Required.
        :type alert_processing_rule: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        alert_processing_rule_name: str,
        alert_processing_rule: Union[_models.AlertProcessingRule, IO],
        **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Create or update an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name of the alert processing rule that needs to be
         created/updated. Required.
        :type alert_processing_rule_name: str
        :param alert_processing_rule: Alert processing rule to be created/updated. Is either a model
         type or a IO type. Required.
        :type alert_processing_rule: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-08-08"] = kwargs.pop("api_version", _params.pop("api-version", "2021-08-08"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AlertProcessingRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(alert_processing_rule, (IO, bytes)):
            _content = alert_processing_rule
        else:
            _json = self._serialize.body(alert_processing_rule, "AlertProcessingRule")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            alert_processing_rule_name=alert_processing_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

            deserialized = self._deserialize("AlertProcessingRule", pipeline_response)

        if response.status_code == 201:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

            deserialized = self._deserialize("AlertProcessingRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, alert_processing_rule_name: str, **kwargs: Any
    ) -> None:
        """Delete an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name of the alert processing rule that needs to be
         deleted. Required.
        :type alert_processing_rule_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-08-08"] = kwargs.pop("api_version", _params.pop("api-version", "2021-08-08"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            alert_processing_rule_name=alert_processing_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if response.status_code == 204:
            response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}"
    }

    @overload
    async def update(
        self,
        resource_group_name: str,
        alert_processing_rule_name: str,
        alert_processing_rule_patch: _models.PatchObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Enable, disable, or update tags for an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name that needs to be updated. Required.
        :type alert_processing_rule_name: str
        :param alert_processing_rule_patch: Parameters supplied to the operation. Required.
        :type alert_processing_rule_patch: ~azure.mgmt.alertsmanagement.models.PatchObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        alert_processing_rule_name: str,
        alert_processing_rule_patch: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Enable, disable, or update tags for an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name that needs to be updated. Required.
        :type alert_processing_rule_name: str
        :param alert_processing_rule_patch: Parameters supplied to the operation. Required.
        :type alert_processing_rule_patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        alert_processing_rule_name: str,
        alert_processing_rule_patch: Union[_models.PatchObject, IO],
        **kwargs: Any
    ) -> _models.AlertProcessingRule:
        """Enable, disable, or update tags for an alert processing rule.

        :param resource_group_name: Resource group name where the resource is created. Required.
        :type resource_group_name: str
        :param alert_processing_rule_name: The name that needs to be updated. Required.
        :type alert_processing_rule_name: str
        :param alert_processing_rule_patch: Parameters supplied to the operation. Is either a model
         type or a IO type. Required.
        :type alert_processing_rule_patch: ~azure.mgmt.alertsmanagement.models.PatchObject or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AlertProcessingRule or the result of cls(response)
        :rtype: ~azure.mgmt.alertsmanagement.models.AlertProcessingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-08-08"] = kwargs.pop("api_version", _params.pop("api-version", "2021-08-08"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AlertProcessingRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(alert_processing_rule_patch, (IO, bytes)):
            _content = alert_processing_rule_patch
        else:
            _json = self._serialize.body(alert_processing_rule_patch, "PatchObject")

        request = build_update_request(
            resource_group_name=resource_group_name,
            alert_processing_rule_name=alert_processing_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))

        deserialized = self._deserialize("AlertProcessingRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AlertsManagement/actionRules/{alertProcessingRuleName}"
    }
