# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AlertLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity level of the alert."""

    INFO = "info"
    """Information level"""
    WARNING = "warning"
    """Warning level"""
    ERROR = "error"
    """Error level"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class MarketplaceSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Marketplace subscription status."""

    PENDING_FULFILLMENT_START = "PendingFulfillmentStart"
    """Marketplace subscription purchased but not yet activated"""
    SUBSCRIBED = "Subscribed"
    """Marketplace subscription activated"""
    SUSPENDED = "Suspended"
    """Marketplace subscription suspended due to missing customer payment"""
    UNSUBSCRIBED = "Unsubscribed"
    """Marketplace subscription cancelled"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    DELETING = "Deleting"
    """Deletion in progress"""
    ACCEPTED = "Accepted"
    """Change accepted for processing"""


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource type."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class UsageSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity levels for billing usage properties."""

    ALERT = "alert"
    """Indicates an alert condition"""
    INFORMATION = "information"
    """Provides informational details"""
    WARNING = "warning"
    """Indicates a warning condition"""
    NONE = "none"
    """Indicates no severity"""


class VmType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AVS VM storage types."""

    V_VOL = "vvol"
    """VM using vVols as underlying storage"""


class VolumeContainerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify which control plane handles the lifecycle of the volume container."""

    AVS = "avs"
    """AVS/VMware"""


class VolumeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify which control plane handles the lifecycle of the volume."""

    AVS = "avs"
    """AVS/VMware"""
