# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry.v2025_04_01 import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementCacheRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cache_rules_list(self, resource_group):
        response = self.client.cache_rules.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cache_rules_get(self, resource_group):
        response = self.client.cache_rules.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            cache_rule_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cache_rules_begin_create(self, resource_group):
        response = self.client.cache_rules.begin_create(
            resource_group_name=resource_group.name,
            registry_name="str",
            cache_rule_name="str",
            cache_rule_create_parameters={
                "creationDate": "2020-02-20 00:00:00",
                "credentialSetResourceId": "str",
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "sourceRepository": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "targetRepository": "str",
                "type": "str",
            },
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cache_rules_begin_delete(self, resource_group):
        response = self.client.cache_rules.begin_delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            cache_rule_name="str",
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cache_rules_begin_update(self, resource_group):
        response = self.client.cache_rules.begin_update(
            resource_group_name=resource_group.name,
            registry_name="str",
            cache_rule_name="str",
            cache_rule_update_parameters={"credentialSetResourceId": "str"},
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
