# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.automation import AutomationClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAutomationDscCompilationJobOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AutomationClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.dsc_compilation_job.begin_create(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            compilation_job_name="str",
            parameters={
                "configuration": {"name": "str"},
                "incrementNodeConfigurationBuild": bool,
                "location": "str",
                "name": "str",
                "parameters": {"str": "str"},
                "tags": {"str": "str"},
            },
            api_version="2020-01-13-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.dsc_compilation_job.get(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            compilation_job_name="str",
            api_version="2020-01-13-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_automation_account(self, resource_group):
        response = self.client.dsc_compilation_job.list_by_automation_account(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            api_version="2020-01-13-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_stream(self, resource_group):
        response = self.client.dsc_compilation_job.get_stream(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            job_id="str",
            job_stream_id="str",
            api_version="2020-01-13-preview",
        )

        # please add some check logic here by yourself
        # ...
