# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessPolicyRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A role defining the data plane operations that a principal can perform on a Time Series
    Insights client.
    """

    READER = "Reader"
    CONTRIBUTOR = "Contributor"


class DataStringComparisonBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference data set key comparison behavior can be set using this property. By default, the
    value is 'Ordinal' - which means case sensitive key comparison will be performed while joining
    reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set,
    case insensitive comparison will be used.
    """

    ORDINAL = "Ordinal"
    ORDINAL_IGNORE_CASE = "OrdinalIgnoreCase"


class EnvironmentKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the environment."""

    GEN1 = "Gen1"
    GEN2 = "Gen2"


class EnvironmentResourceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the environment."""

    GEN1 = "Gen1"
    GEN2 = "Gen2"


class EventSourceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the event source."""

    MICROSOFT_EVENT_HUB = "Microsoft.EventHub"
    MICROSOFT_IO_T_HUB = "Microsoft.IoTHub"


class EventSourceResourceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the event source."""

    MICROSOFT_EVENT_HUB = "Microsoft.EventHub"
    MICROSOFT_IO_T_HUB = "Microsoft.IoTHub"


class IngressStartAtType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime",
    "CustomEnqueuedTime".
    """

    EARLIEST_AVAILABLE = "EarliestAvailable"
    EVENT_SOURCE_CREATION_TIME = "EventSourceCreationTime"
    CUSTOM_ENQUEUED_TIME = "CustomEnqueuedTime"


class IngressState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This string represents the state of ingress operations on an environment. It can be "Disabled",
    "Ready", "Running", "Paused" or "Unknown".
    """

    DISABLED = "Disabled"
    READY = "Ready"
    RUNNING = "Running"
    PAUSED = "Paused"
    UNKNOWN = "Unknown"


class LocalTimestampFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An enum that represents the format of the local timestamp property that needs to be set."""

    EMBEDDED = "Embedded"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class PropertyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the property."""

    STRING = "String"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    DELETING = "Deleting"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This value can be set to 'enabled' to avoid breaking changes on existing customer resources and
    templates. If set to 'disabled', traffic over public interface is not allowed, and private
    endpoint connections would be the exclusive access method.
    """

    ENABLED = "enabled"
    DISABLED = "disabled"


class ReferenceDataKeyPropertyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the key property."""

    STRING = "String"
    DOUBLE = "Double"
    BOOL = "Bool"
    DATE_TIME = "DateTime"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of this SKU."""

    S1 = "S1"
    S2 = "S2"
    P1 = "P1"
    L1 = "L1"


class StorageLimitExceededBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The behavior the Time Series Insights service should take when the environment's capacity has
    been exceeded. If "PauseIngress" is specified, new events will not be read from the event
    source. If "PurgeOldData" is specified, new events will continue to be read and old events will
    be deleted from the environment. The default behavior is PurgeOldData.
    """

    PURGE_OLD_DATA = "PurgeOldData"
    PAUSE_INGRESS = "PauseIngress"


class WarmStoragePropertiesState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This string represents the state of warm storage properties usage. It can be "Ok", "Error",
    "Unknown".
    """

    OK = "Ok"
    ERROR = "Error"
    UNKNOWN = "Unknown"
