# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python managed_cluster_put_operation_example_max.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.managed_clusters.begin_create_or_update(
        resource_group_name="resRg",
        cluster_name="myCluster",
        parameters={
            "location": "eastus",
            "properties": {
                "addonFeatures": ["DnsService", "BackupRestoreService", "ResourceMonitorService"],
                "adminPassword": "{vm-password}",
                "adminUserName": "vmadmin",
                "allowRdpAccess": True,
                "applicationTypeVersionsCleanupPolicy": {"maxUnusedVersionsToKeep": 3},
                "clientConnectionPort": 19000,
                "clusterCodeVersion": "7.1.168.9494",
                "clusterUpgradeMode": "Manual",
                "dnsName": "myCluster",
                "enableAutoOSUpgrade": True,
                "enableIpv6": True,
                "fabricSettings": [
                    {"name": "ManagedIdentityTokenService", "parameters": [{"name": "IsEnabled", "value": "true"}]}
                ],
                "httpGatewayConnectionPort": 19080,
                "ipTags": [{"ipTagType": "FirstPartyUsage", "tag": "SQL"}],
                "loadBalancingRules": [
                    {
                        "backendPort": 80,
                        "frontendPort": 80,
                        "probePort": 80,
                        "probeProtocol": "http",
                        "protocol": "http",
                    },
                    {
                        "backendPort": 443,
                        "frontendPort": 443,
                        "probePort": 443,
                        "probeProtocol": "http",
                        "protocol": "http",
                    },
                    {
                        "backendPort": 10000,
                        "frontendPort": 10000,
                        "loadDistribution": "Default",
                        "probePort": 10000,
                        "probeProtocol": "http",
                        "protocol": "tcp",
                    },
                ],
                "networkSecurityRules": [
                    {
                        "access": "allow",
                        "description": "Test description",
                        "destinationAddressPrefixes": ["*"],
                        "destinationPortRanges": ["*"],
                        "direction": "inbound",
                        "name": "TestName",
                        "priority": 1010,
                        "protocol": "tcp",
                        "sourceAddressPrefixes": ["*"],
                        "sourcePortRanges": ["*"],
                    },
                    {
                        "access": "allow",
                        "destinationAddressPrefix": "*",
                        "destinationPortRange": "33500-33699",
                        "direction": "inbound",
                        "name": "AllowARM",
                        "priority": 2002,
                        "protocol": "*",
                        "sourceAddressPrefix": "AzureResourceManager",
                        "sourcePortRange": "*",
                    },
                ],
                "zonalResiliency": True,
            },
            "sku": {"name": "Basic"},
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/servicefabricmanagedclusters/resource-manager/Microsoft.ServiceFabric/preview/2022-08-01-preview/examples/ManagedClusterPutOperation_example_max.json
if __name__ == "__main__":
    main()
