# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import abc
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, cast

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import build_collection_create_or_update_bulk_request, build_collection_create_or_update_request, build_collection_move_entities_to_collection_request, build_discovery_auto_complete_request, build_discovery_browse_request, build_discovery_query_request, build_discovery_suggest_request, build_entity_add_classification_request, build_entity_add_classifications_by_unique_attribute_request, build_entity_add_classifications_request, build_entity_add_label_request, build_entity_add_labels_by_unique_attribute_request, build_entity_add_or_update_business_metadata_attributes_request, build_entity_add_or_update_business_metadata_request, build_entity_create_or_update_entities_request, build_entity_create_or_update_request, build_entity_delete_business_metadata_attributes_request, build_entity_delete_business_metadata_request, build_entity_delete_by_guid_request, build_entity_delete_by_guids_request, build_entity_delete_by_unique_attribute_request, build_entity_delete_classification_by_unique_attribute_request, build_entity_delete_classification_request, build_entity_delete_labels_by_unique_attribute_request, build_entity_delete_labels_request, build_entity_get_by_guid_request, build_entity_get_by_unique_attributes_request, build_entity_get_classification_request, build_entity_get_classifications_request, build_entity_get_entities_by_unique_attributes_request, build_entity_get_header_request, build_entity_get_sample_business_metadata_template_request, build_entity_list_by_guids_request, build_entity_partial_update_entity_attribute_by_guid_request, build_entity_partial_update_entity_by_unique_attributes_request, build_entity_set_classifications_request, build_entity_set_labels_by_unique_attribute_request, build_entity_set_labels_request, build_entity_update_classifications_by_unique_attribute_request, build_entity_update_classifications_request, build_glossary_assign_term_to_entities_request, build_glossary_create_glossary_categories_request, build_glossary_create_glossary_category_request, build_glossary_create_glossary_request, build_glossary_create_glossary_term_request, build_glossary_create_glossary_terms_request, build_glossary_delete_glossary_category_request, build_glossary_delete_glossary_request, build_glossary_delete_glossary_term_request, build_glossary_delete_term_assignment_from_entities_request, build_glossary_export_glossary_terms_as_csv_request, build_glossary_get_detailed_glossary_request, build_glossary_get_entities_assigned_with_term_request, build_glossary_get_glossary_category_request, build_glossary_get_glossary_request, build_glossary_get_glossary_term_request, build_glossary_get_import_csv_operation_status_request, build_glossary_list_category_terms_request, build_glossary_list_glossaries_request, build_glossary_list_glossary_categories_headers_request, build_glossary_list_glossary_categories_request, build_glossary_list_glossary_term_headers_request, build_glossary_list_glossary_terms_request, build_glossary_list_related_categories_request, build_glossary_list_related_terms_request, build_glossary_list_terms_by_glossary_name_request, build_glossary_partial_update_glossary_category_request, build_glossary_partial_update_glossary_request, build_glossary_partial_update_glossary_term_request, build_glossary_remove_term_assignment_from_entities_request, build_glossary_update_glossary_category_request, build_glossary_update_glossary_request, build_glossary_update_glossary_term_request, build_lineage_get_lineage_by_unique_attribute_request, build_lineage_get_lineage_graph_request, build_lineage_next_page_lineage_request, build_relationship_create_request, build_relationship_delete_request, build_relationship_get_request, build_relationship_update_request, build_types_create_type_definitions_request, build_types_delete_type_by_name_request, build_types_delete_type_definitions_request, build_types_get_all_type_definitions_request, build_types_get_business_metadata_def_by_guid_request, build_types_get_business_metadata_def_by_name_request, build_types_get_classification_def_by_guid_request, build_types_get_classification_def_by_name_request, build_types_get_entity_definition_by_guid_request, build_types_get_entity_definition_by_name_request, build_types_get_enum_def_by_guid_request, build_types_get_enum_def_by_name_request, build_types_get_relationship_def_by_guid_request, build_types_get_relationship_def_by_name_request, build_types_get_struct_def_by_guid_request, build_types_get_struct_def_by_name_request, build_types_get_term_template_def_by_guid_request, build_types_get_term_template_def_by_name_request, build_types_get_type_definition_by_guid_request, build_types_get_type_definition_by_name_request, build_types_list_type_definition_headers_request, build_types_update_atlas_type_definitions_request
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any] # pylint: disable=unsubscriptable-object
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class EntityOperations(abc.ABC):  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.catalog.aio.PurviewCatalogClient`'s
        :attr:`entity` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def create_or_update(
        self,
        entity: JSON,
        **kwargs: Any
    ) -> JSON:
        """Create or update an entity in Atlas.
        Existing entity is matched using its unique guid if supplied or by its unique attributes eg:
        qualifiedName.
        Map and array of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.

        :param entity: Atlas entity with extended information.
        :type entity: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entity = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business Attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of
                          an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed from Atlas store. Known values are:
                          "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed from Atlas store. Known values are:
                                          "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "source": "str",  # Optional.
                                          indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more
                                              detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "source": "str",  # Optional. The
                                          source of the term.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed from Atlas
                                  store. Known values are: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = entity

        request = build_entity_create_or_update_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def list_by_guids(
        self,
        *,
        guids: List[str],
        min_ext_info: Optional[bool] = False,
        ignore_relationships: Optional[bool] = False,
        exclude_relationship_types: Optional[List[str]] = None,
        **kwargs: Any
    ) -> JSON:
        """List entities in bulk identified by its GUIDs.

        :keyword guids: An array of GUIDs of entities to list.
        :paramtype guids: list[str]
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is False.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         False.
        :paramtype ignore_relationships: bool
        :keyword exclude_relationship_types: An array of the relationship types need to be excluded
         from the response. Default value is None.
        :paramtype exclude_relationship_types: list[str]
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_list_by_guids_request(
            guids=guids,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            exclude_relationship_types=exclude_relationship_types,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def create_or_update_entities(
        self,
        entities: JSON,
        **kwargs: Any
    ) -> JSON:
        """Create or update entities in Atlas in bulk.
        Existing entity is matched using its unique guid if supplied or by its unique attributes eg:
        qualifiedName.
        Map and array of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.

        :param entities: An array of entities to create or update.
        :type entities: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entities = {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed from Atlas store. Known values are:
                                          "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "source": "str",  # Optional.
                                          indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more
                                              detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "source": "str",  # Optional. The
                                          source of the term.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed from Atlas
                                  store. Known values are: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = entities

        request = build_entity_create_or_update_entities_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_by_guids(
        self,
        *,
        guids: List[str],
        **kwargs: Any
    ) -> JSON:
        """Delete a list of entities in bulk identified by their GUIDs or unique attributes.

        :keyword guids: An array of GUIDs of entities to delete.
        :paramtype guids: list[str]
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed from Atlas store. Known values are:
                                          "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "source": "str",  # Optional.
                                          indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more
                                              detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "source": "str",  # Optional. The
                                          source of the term.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed from Atlas
                                  store. Known values are: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_delete_by_guids_request(
            guids=guids,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def add_classification(  # pylint: disable=inconsistent-return-statements
        self,
        request: JSON,
        **kwargs: Any
    ) -> None:
        """Associate a classification to multiple entities in bulk.

        :param request: The request to associate a classification to multiple entities.
        :type request: JSON
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                request = {
                    "classification": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    },
                    "entityGuids": [
                        "str"  # Optional. The GUID of the entity.
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = request

        request = build_entity_add_classification_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def get_by_guid(
        self,
        guid: str,
        *,
        min_ext_info: Optional[bool] = False,
        ignore_relationships: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        """Get complete definition of an entity given its GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is False.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         False.
        :paramtype ignore_relationships: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business Attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of
                          an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed from Atlas store. Known values are:
                          "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_get_by_guid_request(
            guid=guid,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def partial_update_entity_attribute_by_guid(
        self,
        guid: str,
        body: Any,
        *,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Update entity partially - create or update entity attribute identified by its GUID.
        Supports only primitive attribute type and entity references.
        It does not support updating complex types like arrays, and maps.
        Null updates are not possible.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: The value of the attribute.
        :type body: any
        :keyword name: The name of the attribute.
        :paramtype name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = body

        request = build_entity_partial_update_entity_attribute_by_guid_request(
            guid=guid,
            content_type=content_type,
            name=name,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Delete an entity identified by its GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed from Atlas store. Known values are:
                                          "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "source": "str",  # Optional.
                                          indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more
                                              detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "source": "str",  # Optional. The
                                          source of the term.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed from Atlas
                                  store. Known values are: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_delete_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_classification(
        self,
        guid: str,
        classification_name: str,
        **kwargs: Any
    ) -> JSON:
        """List classifications for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classification_name: The name of the classification.
        :type classification_name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "entityGuid": "str",  # Optional. The GUID of the entity.
                    "entityStatus": "str",  # Optional. Status of the entity - can be active or
                      deleted. Deleted entities are not removed from Atlas store. Known values are:
                      "ACTIVE", "DELETED".
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                      propagations will be removed on entity deletion.
                    "source": "str",  # Optional. indicate the source who create the
                      classification detail.
                    "sourceDetails": {
                        "str": {}  # Optional. more detail on source information.
                    },
                    "typeName": "str",  # Optional. The name of the type.
                    "validityPeriods": [
                        {
                            "endTime": "str",  # Optional. The end of the time boundary.
                            "startTime": "str",  # Optional. The start of the time
                              boundary.
                            "timeZone": "str"  # Optional. The timezone of the time
                              boundary.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_get_classification_request(
            guid=guid,
            classification_name=classification_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_classification(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        classification_name: str,
        **kwargs: Any
    ) -> None:
        """Delete a given classification from an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classification_name: The name of the classification.
        :type classification_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_entity_delete_classification_request(
            guid=guid,
            classification_name=classification_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def get_classifications(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """List classifications for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "list": [
                        {}  # Optional. An array of objects.
                    ],
                    "pageSize": 0,  # Optional. The size of the page.
                    "sortBy": "str",  # Optional. The sorted by field.
                    "sortType": "str",  # Optional. to specify whether the result should be
                      sorted? If yes, whether asc or desc. Known values are: "NONE", "ASC", "DESC".
                    "startIndex": 0.0,  # Optional. The start index of the page.
                    "totalCount": 0.0  # Optional. The total count of items.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_get_classifications_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def add_classifications(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        classifications: List[JSON],
        **kwargs: Any
    ) -> None:
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classifications: An array of classifications to be added.
        :type classifications: list[JSON]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                classifications = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = classifications

        request = build_entity_add_classifications_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def update_classifications(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        classifications: List[JSON],
        **kwargs: Any
    ) -> None:
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param classifications: An array of classifications to be updated.
        :type classifications: list[JSON]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                classifications = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = classifications

        request = build_entity_update_classifications_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def get_by_unique_attributes(
        self,
        type_name: str,
        *,
        min_ext_info: Optional[bool] = False,
        ignore_relationships: Optional[bool] = False,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Get complete definition of an entity given its type and unique attribute.
        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr:\:code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
        The REST request would look something like this:
        GET /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is False.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         False.
        :paramtype ignore_relationships: bool
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business Attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of
                          an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed from Atlas store. Known values are:
                          "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_get_by_unique_attributes_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def partial_update_entity_by_unique_attributes(
        self,
        type_name: str,
        atlas_entity_with_ext_info: JSON,
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Update entity partially - Allow a subset of attributes to be updated on
        an entity which is identified by its type and unique attribute  eg:
        Referenceable.qualifiedName.
        Null updates are not possible.
        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr::code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
        The REST request would look something like this:
        PUT /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :param atlas_entity_with_ext_info: Atlas entity with extended information.
        :type atlas_entity_with_ext_info: JSON
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_entity_with_ext_info = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business Attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of
                          an instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed from Atlas store. Known values are:
                          "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed from Atlas store. Known values are:
                                          "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "source": "str",  # Optional.
                                          indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more
                                              detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "source": "str",  # Optional. The
                                          source of the term.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed from Atlas
                                  store. Known values are: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = atlas_entity_with_ext_info

        request = build_entity_partial_update_entity_by_unique_attributes_request(
            type_name=type_name,
            content_type=content_type,
            json=_json,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_by_unique_attribute(
        self,
        type_name: str,
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Delete an entity identified by its type and unique attributes.
        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr:\:code:`<attrName>`=\:code:`<attrValue>`.
        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.
        The REST request would look something like this:
        DELETE /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed from Atlas store. Known values are:
                                          "ACTIVE", "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "source": "str",  # Optional.
                                          indicate the source who create the classification detail.
                                        "sourceDetails": {
                                            "str": {}  # Optional. more
                                              detail on source information.
                                        },
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "source": "str",  # Optional. The
                                          source of the term.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed from Atlas
                                  store. Known values are: "ACTIVE", "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_delete_by_unique_attribute_request(
            type_name=type_name,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_classification_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        classification_name: str,
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Delete a given classification from an entity identified by its type and unique attributes.

        :param type_name: The name of the type.
        :type type_name: str
        :param classification_name: The name of the classification.
        :type classification_name: str
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_entity_delete_classification_by_unique_attribute_request(
            type_name=type_name,
            classification_name=classification_name,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def add_classifications_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        atlas_classification_array: List[JSON],
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type.
        :type type_name: str
        :param atlas_classification_array: An array of classification to be added.
        :type atlas_classification_array: list[JSON]
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_classification_array = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = atlas_classification_array

        request = build_entity_add_classifications_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            json=_json,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def update_classifications_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        atlas_classification_array: List[JSON],
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type.
        :type type_name: str
        :param atlas_classification_array: An array of classification to be updated.
        :type atlas_classification_array: list[JSON]
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_classification_array = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "source": "str",  # Optional. indicate the source who create the
                          classification detail.
                        "sourceDetails": {
                            "str": {}  # Optional. more detail on source information.
                        },
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = atlas_classification_array

        request = build_entity_update_classifications_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            json=_json,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def set_classifications(
        self,
        entity_headers: JSON,
        **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param entity_headers: Atlas entity headers.
        :type entity_headers: JSON
        :return: list of str
        :rtype: list[str]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                entity_headers = {
                    "guidHeaderMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[List[str]]

        _json = entity_headers

        request = build_entity_set_classifications_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[str], deserialized), {})

        return cast(List[str], deserialized)



    @distributed_trace_async
    async def get_entities_by_unique_attributes(
        self,
        type_name: str,
        *,
        min_ext_info: Optional[bool] = False,
        ignore_relationships: Optional[bool] = False,
        attr_n_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Bulk API to retrieve list of entities identified by its unique attributes.

        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format

        typeName=\:code:`<typeName>`&attr_1:\:code:`<attrName>`=\:code:`<attrValue>`&attr_2:\:code:`<attrName>`=\:code:`<attrValue>`&attr_3:\:code:`<attrName>`=\:code:`<attrValue>`

        NOTE: The attrName should be an unique attribute for the given entity-type

        The REST request would look something like this

        GET
        /v2/entity/bulk/uniqueAttribute/type/hive_db?attr_0:qualifiedName=db1@cl1&attr_2:qualifiedName=db2@cl1.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is False.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         False.
        :paramtype ignore_relationships: bool
        :keyword attr_n_qualified_name: Qualified name of an entity. E.g. to find 2 entities you can
         set attrs_0:qualifiedName=db1@cl1&attrs_2:qualifiedName=db2@cl1. Default value is None.
        :paramtype attr_n_qualified_name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business Attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0.0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_get_entities_by_unique_attributes_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attr_n_qualified_name=attr_n_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_header(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get entity header given its GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "classificationNames": [
                        "str"  # Optional. An array of classification names.
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "displayText": "str",  # Optional. The display text.
                    "guid": "str",  # Optional. The GUID of the record.
                    "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                    "labels": [
                        "str"  # Optional. labels.
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "meaningNames": [
                        "str"  # Optional. An array of meanings.
                    ],
                    "meanings": [
                        {
                            "confidence": 0,  # Optional. The confidence of the term
                              assignment.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "description": "str",  # Optional. The description of the
                              term assignment.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term
                              assignment.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of terms assignment.
                              Known values are: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED",
                              "DEPRECATED", "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "status": "str",  # Optional. Status of the entity - can be active or
                      deleted. Deleted entities are not removed from Atlas store. Known values are:
                      "ACTIVE", "DELETED".
                    "typeName": "str"  # Optional. The name of the type.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_entity_get_header_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_business_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: BusinessMetadata. Default value is None.
        :type body: dict[str, any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {}  # Optional.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_delete_business_metadata_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def add_or_update_business_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Optional[Dict[str, Any]] = None,
        *,
        is_overwrite: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: Business Metadata. Default value is None.
        :type body: dict[str, any]
        :keyword is_overwrite: Whether to overwrite the existing business metadata on the entity or
         not, default is false.
        :paramtype is_overwrite: bool
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {}  # Optional.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_add_or_update_business_metadata_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            is_overwrite=is_overwrite,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def delete_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements
        self,
        bm_name: str,
        guid: str,
        body: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param bm_name: BusinessMetadata name.
        :type bm_name: str
        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: BusinessMetadataAttributes. Default value is None.
        :type body: dict[str, any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {}  # Optional.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_delete_business_metadata_attributes_request(
            bm_name=bm_name,
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def add_or_update_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements
        self,
        bm_name: str,
        guid: str,
        body: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param bm_name: BusinessMetadata name.
        :type bm_name: str
        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: BusinessMetadataAttributes. Default value is None.
        :type body: dict[str, any]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {}  # Optional.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_add_or_update_business_metadata_attributes_request(
            bm_name=bm_name,
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def get_sample_business_metadata_template(
        self,
        **kwargs: Any
    ) -> IO:
        """Get the sample Template for uploading/creating bulk BusinessMetaData.

        :return: IO
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[IO]

        
        request = build_entity_get_sample_business_metadata_template_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=True,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = response

        if cls:
            return cls(pipeline_response, cast(IO, deserialized), {})

        return cast(IO, deserialized)



    @distributed_trace_async
    @abc.abstractmethod
    async def import_business_metadata(
        self,
        *args,
        **kwargs
    ) -> JSON:
        """You need to write a custom operation for "import_business_metadata". Please refer to
        https://aka.ms/azsdk/python/dpcodegen/python/customize to learn how to customize.

        """


    @distributed_trace_async
    async def delete_labels(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: list[str]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_delete_labels_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def set_labels(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: set of labels to be set to the entity. Default value is None.
        :type body: list[str]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_set_labels_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def add_label(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """add given labels to a given entity.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :param body: set of labels to be added. Default value is None.
        :type body: list[str]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_add_label_request(
            guid=guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def delete_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique attributes, if labels
        is null/empty, no labels will be removed. If any labels in labels set are non-existing labels,
        they will be ignored, only existing labels will be removed. In addition to the typeName path
        parameter, attribute key-value pair(s) can be provided in the following format:
        attr::code:`<attrName>`=:code:`<attrValue>`. NOTE: The attrName and attrValue should be unique
        across entities, eg. qualifiedName. The REST request would look something like this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: list[str]
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_delete_labels_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            json=_json,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def set_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes, if labels is
        null/empty, existing labels will all be removed. In addition to the typeName path parameter,
        attribute key-value pair(s) can be provided in the following format:
        attr::code:`<attrName>`=:code:`<attrValue>`. NOTE: The attrName and attrValue should be unique
        across entities, eg. qualifiedName. The REST request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :param body: set of labels to be set. Default value is None.
        :type body: list[str]
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_set_labels_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            json=_json,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def add_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attr_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique attributes, if labels is
        null/empty, no labels will be added. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr::code:`<attrName>`=:code:`<attrValue>`. NOTE: The attrName and attrValue should be unique
        across entities, eg. qualifiedName. The REST request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type.
        :type type_name: str
        :param body: set of labels to be added. Default value is None.
        :type body: list[str]
        :keyword attr_qualified_name: The qualified name of the entity. Default value is None.
        :paramtype attr_qualified_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        if body is not None:
            _json = body
        else:
            _json = None

        request = build_entity_add_labels_by_unique_attribute_request(
            type_name=type_name,
            content_type=content_type,
            json=_json,
            attr_qualified_name=attr_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class GlossaryOperations(abc.ABC):  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.catalog.aio.PurviewCatalogClient`'s
        :attr:`glossary` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def list_glossaries(
        self,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        ignore_terms_and_categories: Optional[bool] = False,
        **kwargs: Any
    ) -> List[JSON]:
        """Get all glossaries registered with Atlas.

        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         False.
        :paramtype ignore_terms_and_categories: bool
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "language": "str",  # Optional. The language of the glossary.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "usage": "str"  # Optional. The usage of the glossary.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_glossaries_request(
            limit=limit,
            offset=offset,
            sort=sort,
            ignore_terms_and_categories=ignore_terms_and_categories,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def create_glossary(
        self,
        atlas_glossary: JSON,
        **kwargs: Any
    ) -> JSON:
        """Create a glossary.

        :param atlas_glossary: Glossary definition, terms & categories can be anchored to a glossary.
         Using the anchor attribute when creating the Term/Category.
        :type atlas_glossary: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                atlas_glossary = {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = atlas_glossary

        request = build_glossary_create_glossary_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def create_glossary_categories(
        self,
        glossary_category: List[JSON],
        **kwargs: Any
    ) -> List[JSON]:
        """Create glossary category in bulk.

        :param glossary_category: An array of glossary category definitions to be created.
        :type glossary_category: list[JSON]
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_category = [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]

                # response body for status code(s): 200
                response.json() == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        _json = glossary_category

        request = build_glossary_create_glossary_categories_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def create_glossary_category(
        self,
        glossary_category: JSON,
        **kwargs: Any
    ) -> JSON:
        """Create a glossary category.

        :param glossary_category: The glossary category definition. A category must be anchored to a
         Glossary when creating.
         Optionally, terms belonging to the category and the hierarchy can also be defined during
         creation.
        :type glossary_category: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_category = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = glossary_category

        request = build_glossary_create_glossary_category_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_glossary_category(
        self,
        category_guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get specific glossary category by its GUID.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_get_glossary_category_request(
            category_guid=category_guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def update_glossary_category(
        self,
        category_guid: str,
        glossary_category: JSON,
        **kwargs: Any
    ) -> JSON:
        """Update the given glossary category by its GUID.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :param glossary_category: The glossary category to be updated.
        :type glossary_category: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_category = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = glossary_category

        request = build_glossary_update_glossary_category_request(
            category_guid=category_guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_glossary_category(  # pylint: disable=inconsistent-return-statements
        self,
        category_guid: str,
        **kwargs: Any
    ) -> None:
        """Delete a glossary category.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_glossary_delete_glossary_category_request(
            category_guid=category_guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def partial_update_glossary_category(
        self,
        category_guid: str,
        partial_updates: Dict[str, str],
        **kwargs: Any
    ) -> JSON:
        """Update the glossary category partially.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :param partial_updates: A map containing keys as attribute names and values as corresponding
         attribute values for partial update.
        :type partial_updates: dict[str, str]
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                partial_updates = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response.json() == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = partial_updates

        request = build_glossary_partial_update_glossary_category_request(
            category_guid=category_guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def list_related_categories(
        self,
        category_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> Dict[str, List[JSON]]:
        """Get all related categories (parent and children). Limit, offset, and sort parameters are
        currently not being enabled and won't work even they are passed.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: dict mapping str to list of JSON object
        :rtype: dict[str, list[JSON]]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "str": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[Dict[str, List[JSON]]]

        
        request = build_glossary_list_related_categories_request(
            category_guid=category_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Dict[str, List[JSON]], deserialized), {})

        return cast(Dict[str, List[JSON]], deserialized)



    @distributed_trace_async
    async def list_category_terms(
        self,
        category_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> List[JSON]:
        """Get all terms associated with the specific category.

        :param category_guid: The globally unique identifier of the category.
        :type category_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "description": "str",  # Optional. The description of the related
                          term.
                        "displayText": "str",  # Optional. The display text.
                        "expression": "str",  # Optional. The expression of the term.
                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                        "source": "str",  # Optional. The source of the term.
                        "status": "str",  # Optional. The status of term relationship. Known
                          values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        "steward": "str",  # Optional. The steward of the term.
                        "termGuid": "str"  # Optional. The GUID of the term.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_category_terms_request(
            category_guid=category_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def create_glossary_term(
        self,
        glossary_term: JSON,
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        """Create a glossary term.

        :param glossary_term: The glossary term definition. A term must be anchored to a Glossary at
         the time of creation.
         Optionally it can be categorized as well.
        :type glossary_term: JSON
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_term = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related
                              object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>."nThe key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related
                              object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>."nThe key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = glossary_term

        request = build_glossary_create_glossary_term_request(
            content_type=content_type,
            json=_json,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_glossary_term(
        self,
        term_guid: str,
        *,
        include_term_hierarchy: Optional[bool] = False,
        exclude_relationship_type_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> JSON:
        """Get a specific glossary term by its GUID.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :keyword exclude_relationship_type_list: An array of relationship types which need to be
         excluded. Default value is None.
        :paramtype exclude_relationship_type_list: list[str]
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related
                              object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>."nThe key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_get_glossary_term_request(
            term_guid=term_guid,
            include_term_hierarchy=include_term_hierarchy,
            exclude_relationship_type_list=exclude_relationship_type_list,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def update_glossary_term(
        self,
        term_guid: str,
        glossary_term: JSON,
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        """Update the given glossary term by its GUID.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param glossary_term: The glossary term to be updated.
        :type glossary_term: JSON
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_term = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related
                              object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>."nThe key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related
                              object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>."nThe key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = glossary_term

        request = build_glossary_update_glossary_term_request(
            term_guid=term_guid,
            content_type=content_type,
            json=_json,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_glossary_term(  # pylint: disable=inconsistent-return-statements
        self,
        term_guid: str,
        **kwargs: Any
    ) -> None:
        """Delete a glossary term.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_glossary_delete_glossary_term_request(
            term_guid=term_guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def partial_update_glossary_term(
        self,
        term_guid: str,
        partial_updates: Dict[str, str],
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        """Update the glossary term partially.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param partial_updates: A map containing keys as attribute names and values as corresponding
         attribute values to be updated.
        :type partial_updates: dict[str, str]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                partial_updates = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response.json() == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE", "DELETED".
                            "relationshipType": "str",  # Optional. An array of related
                              object IDs.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>."nThe key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = partial_updates

        request = build_glossary_partial_update_glossary_term_request(
            term_guid=term_guid,
            content_type=content_type,
            json=_json,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def create_glossary_terms(
        self,
        glossary_term: List[JSON],
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> List[JSON]:
        """Create glossary terms in bulk.

        :param glossary_term: An array of glossary term definitions to be created in bulk.
        :type glossary_term: list[JSON]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                glossary_term = [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "typeName": "str"  # Optional. The name of
                                      the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of
                                  the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of
                                  relationship status. Known values are: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of
                                  related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes
                                      of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the
                                  term, which is map<string,map<string,object>>."nThe key of the first
                                  layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str"  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for
                                  url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known
                          values are: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]

                # response body for status code(s): 200
                response.json() == [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "typeName": "str"  # Optional. The name of
                                      the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of
                                  the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of
                                  relationship status. Known values are: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of
                                  related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes
                                      of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the
                                  term, which is map<string,map<string,object>>."nThe key of the first
                                  layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str"  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for
                                  url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known
                          values are: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        _json = glossary_term

        request = build_glossary_create_glossary_terms_request(
            content_type=content_type,
            json=_json,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def get_entities_assigned_with_term(
        self,
        term_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> List[JSON]:
        """Get all related objects assigned with the specified term.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship
                          status. Known values are: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_get_entities_assigned_with_term_request(
            term_guid=term_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def assign_term_to_entities(  # pylint: disable=inconsistent-return-statements
        self,
        term_guid: str,
        related_object_ids: List[JSON],
        **kwargs: Any
    ) -> None:
        """Assign the given term to the provided list of related objects.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param related_object_ids: An array of related object IDs to which the term has to be
         associated.
        :type related_object_ids: list[JSON]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                related_object_ids = [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship
                          status. Known values are: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = related_object_ids

        request = build_glossary_assign_term_to_entities_request(
            term_guid=term_guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def remove_term_assignment_from_entities(  # pylint: disable=inconsistent-return-statements
        self,
        term_guid: str,
        related_object_ids: List[JSON],
        **kwargs: Any
    ) -> None:
        """Delete the term assignment for the given list of related objects.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param related_object_ids: An array of related object IDs from which the term has to be
         dissociated.
        :type related_object_ids: list[JSON]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                related_object_ids = [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship
                          status. Known values are: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = related_object_ids

        request = build_glossary_remove_term_assignment_from_entities_request(
            term_guid=term_guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def delete_term_assignment_from_entities(  # pylint: disable=inconsistent-return-statements
        self,
        term_guid: str,
        related_object_ids: List[JSON],
        **kwargs: Any
    ) -> None:
        """Delete the term assignment for the given list of related objects.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :param related_object_ids: An array of related object IDs from which the term has to be
         dissociated.
        :type related_object_ids: list[JSON]
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                related_object_ids = [
                    {
                        "displayText": "str",  # Optional. The display text.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed from Atlas store. Known
                          values are: "ACTIVE", "DELETED".
                        "guid": "str",  # Optional. The GUID of the object.
                        "relationshipAttributes": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "typeName": "str"  # Optional. The name of the type.
                        },
                        "relationshipGuid": "str",  # Optional. The GUID of the relationship.
                        "relationshipStatus": "str",  # Optional. The enum of relationship
                          status. Known values are: "ACTIVE", "DELETED".
                        "relationshipType": "str",  # Optional.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        _json = related_object_ids

        request = build_glossary_delete_term_assignment_from_entities_request(
            term_guid=term_guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def list_related_terms(
        self,
        term_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> Dict[str, List[JSON]]:
        """Get all related terms for a specific term by its GUID. Limit, offset, and sort parameters are
        currently not being enabled and won't work even they are passed.

        :param term_guid: The globally unique identifier for glossary term.
        :type term_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: dict mapping str to list of JSON object
        :rtype: dict[str, list[JSON]]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "str": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[Dict[str, List[JSON]]]

        
        request = build_glossary_list_related_terms_request(
            term_guid=term_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(Dict[str, List[JSON]], deserialized), {})

        return cast(Dict[str, List[JSON]], deserialized)



    @distributed_trace_async
    async def get_glossary(
        self,
        glossary_guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get a specific Glossary by its GUID.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_get_glossary_request(
            glossary_guid=glossary_guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def update_glossary(
        self,
        glossary_guid: str,
        updated_glossary: JSON,
        **kwargs: Any
    ) -> JSON:
        """Update the given glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param updated_glossary: The glossary definition to be updated.
        :type updated_glossary: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                updated_glossary = {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = updated_glossary

        request = build_glossary_update_glossary_request(
            glossary_guid=glossary_guid,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_glossary(  # pylint: disable=inconsistent-return-statements
        self,
        glossary_guid: str,
        **kwargs: Any
    ) -> None:
        """Delete a glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_glossary_delete_glossary_request(
            glossary_guid=glossary_guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def list_glossary_categories(
        self,
        glossary_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> List[JSON]:
        """Get the categories belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_glossary_categories_request(
            glossary_guid=glossary_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def list_glossary_categories_headers(
        self,
        glossary_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> List[JSON]:
        """Get the category headers belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_glossary_categories_headers_request(
            glossary_guid=glossary_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def get_detailed_glossary(
        self,
        glossary_guid: str,
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        """Get a specific glossary with detailed information.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "categoryInfo": {
                        "str": {
                            "anchor": {
                                "displayText": "str",  # Optional. The display text.
                                "glossaryGuid": "str",  # Optional. The GUID of the
                                  glossary.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            },
                            "childrenCategories": [
                                {
                                    "categoryGuid": "str",  # Optional. The GUID
                                      of the category.
                                    "description": "str",  # Optional. The
                                      description of the category header.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "parentCategoryGuid": "str",  # Optional. The
                                      GUID of the parent category.
                                    "relationGuid": "str"  # Optional. The GUID
                                      of the relationship.
                                }
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "guid": "str",  # Optional. The GUID of the object.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "longDescription": "str",  # Optional. The long version
                              description.
                            "name": "str",  # Optional. The name of the glossary object.
                            "parentCategory": {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            },
                            "qualifiedName": "str",  # Optional. The qualified name of
                              the glossary object.
                            "shortDescription": "str",  # Optional. The short version of
                              description.
                            "terms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ]
                        }
                    },
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "termInfo": {
                        "str": {
                            "abbreviation": "str",  # Optional. The abbreviation of the
                              term.
                            "anchor": {
                                "displayText": "str",  # Optional. The display text.
                                "glossaryGuid": "str",  # Optional. The GUID of the
                                  glossary.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            },
                            "antonyms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "assignedEntities": [
                                {
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "guid": "str",  # Optional. The GUID of the
                                      object.
                                    "relationshipAttributes": {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "typeName": "str"  # Optional. The
                                          name of the type.
                                    },
                                    "relationshipGuid": "str",  # Optional. The
                                      GUID of the relationship.
                                    "relationshipStatus": "str",  # Optional. The
                                      enum of relationship status. Known values are: "ACTIVE",
                                      "DELETED".
                                    "relationshipType": "str",  # Optional. An
                                      array of related object IDs.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "uniqueAttributes": {
                                        "str": {}  # Optional. The unique
                                          attributes of the object.
                                    }
                                }
                            ],
                            "attributes": {
                                "str": {
                                    "str": {}  # Optional. The custom attributes
                                      of the term, which is map<string,map<string,object>>."nThe key of
                                      the first layer map is term template name.
                                }
                            },
                            "categories": [
                                {
                                    "categoryGuid": "str",  # Optional. The GUID
                                      of the category.
                                    "description": "str",  # Optional. The
                                      description of the record.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str"  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                }
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "classifies": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "examples": [
                                "str"  # Optional. An array of examples.
                            ],
                            "guid": "str",  # Optional. The GUID of the object.
                            "isA": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "longDescription": "str",  # Optional. The long version
                              description.
                            "name": "str",  # Optional. The name of the glossary object.
                            "preferredTerms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "preferredToTerms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "qualifiedName": "str",  # Optional. The qualified name of
                              the glossary object.
                            "replacedBy": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "replacementTerms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "resources": [
                                {
                                    "displayName": "str",  # Optional. Display
                                      name for url.
                                    "url": "str"  # Optional. web url. http or
                                      https.
                                }
                            ],
                            "seeAlso": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "shortDescription": "str",  # Optional. The short version of
                              description.
                            "status": "str",  # Optional. Status of the
                              AtlasGlossaryTerm. Known values are: "Draft", "Approved", "Alert",
                              "Expired".
                            "synonyms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "templateName": [
                                {}  # Optional. The glossary term information.
                            ],
                            "translatedTerms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "translationTerms": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "usage": "str",  # Optional. The usage of the term.
                            "validValues": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "validValuesFor": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the related term.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      term relationship. Known values are: "DRAFT", "ACTIVE",
                                      "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ]
                        }
                    },
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_get_detailed_glossary_request(
            glossary_guid=glossary_guid,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def partial_update_glossary(
        self,
        glossary_guid: str,
        partial_updates: Dict[str, str],
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        """Update the glossary partially. Some properties such as qualifiedName are not allowed to be
        updated.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param partial_updates: A map containing keys as attribute names and values as corresponding
         attribute values.
        :type partial_updates: dict[str, str]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                partial_updates = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response.json() == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed from Atlas
                              store. Known values are: "ACTIVE", "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "source": "str",  # Optional. indicate the source who create
                              the classification detail.
                            "sourceDetails": {
                                "str": {}  # Optional. more detail on source
                                  information.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "source": "str",  # Optional. The source of the term.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = partial_updates

        request = build_glossary_partial_update_glossary_request(
            glossary_guid=glossary_guid,
            content_type=content_type,
            json=_json,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def list_glossary_terms(
        self,
        glossary_guid: str,
        *,
        include_term_hierarchy: Optional[bool] = False,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> List[JSON]:
        """Get terms belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "typeName": "str"  # Optional. The name of
                                      the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of
                                  the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of
                                  relationship status. Known values are: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of
                                  related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes
                                      of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the
                                  term, which is map<string,map<string,object>>."nThe key of the first
                                  layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str"  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for
                                  url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known
                          values are: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_glossary_terms_request(
            glossary_guid=glossary_guid,
            include_term_hierarchy=include_term_hierarchy,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    @distributed_trace_async
    async def list_glossary_term_headers(
        self,
        glossary_guid: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = "ASC",
        **kwargs: Any
    ) -> List[JSON]:
        """Get term headers belonging to a specific glossary.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is "ASC".
        :paramtype sort: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "description": "str",  # Optional. The description of the related
                          term.
                        "displayText": "str",  # Optional. The display text.
                        "expression": "str",  # Optional. The expression of the term.
                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                        "source": "str",  # Optional. The source of the term.
                        "status": "str",  # Optional. The status of term relationship. Known
                          values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", "OTHER".
                        "steward": "str",  # Optional. The steward of the term.
                        "termGuid": "str"  # Optional. The GUID of the term.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_glossary_term_headers_request(
            glossary_guid=glossary_guid,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)



    async def _import_glossary_terms_via_csv_initial(
        self,
        glossary_guid: str,
        file: IO,
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_import_glossary_terms_via_csv_request_initial(
            glossary_guid=glossary_guid,
            api_version=api_version,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    @abc.abstractmethod
    async def begin_import_glossary_terms_via_csv(
        self,
        *args,
        **kwargs
    ) -> AsyncLROPoller[JSON]:
        """You need to write a custom operation for "begin_import_glossary_terms_via_csv". Please refer to
        https://aka.ms/azsdk/python/dpcodegen/python/customize to learn how to customize.

        """


    async def _import_glossary_terms_via_csv_by_glossary_name_initial(
        self,
        glossary_name: str,
        file: IO,
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_import_glossary_terms_via_csv_by_glossary_name_request_initial(
            glossary_name=glossary_name,
            api_version=api_version,
            content_type=content_type,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    @abc.abstractmethod
    async def begin_import_glossary_terms_via_csv_by_glossary_name(
        self,
        *args,
        **kwargs
    ) -> AsyncLROPoller[JSON]:
        """You need to write a custom operation for
        "begin_import_glossary_terms_via_csv_by_glossary_name". Please refer to
        https://aka.ms/azsdk/python/dpcodegen/python/customize to learn how to customize.

        """


    @distributed_trace_async
    async def get_import_csv_operation_status(
        self,
        operation_guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the status of import csv operation.

        :param operation_guid: The globally unique identifier for async operation/job.
        :type operation_guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "createTime": "str",  # Optional. The created time of the record.
                    "error": {
                        "errorCode": 0,  # Optional. Error code from async import job if
                          fail.
                        "errorMessage": "str"  # Optional. Error message from async import
                          job if fail.
                    },
                    "id": "str",  # Optional. guid string.
                    "lastUpdateTime": "str",  # Optional. The last updated time of the record.
                    "properties": {
                        "importedTerms": "str",  # Optional. Term numbers that already
                          imported successfully.
                        "totalTermsDetected": "str"  # Optional. Total term numbers that
                          detected in csv.
                    },
                    "status": "str"  # Optional. Enum of the status of import csv operation.
                      Known values are: "NotStarted", "Succeeded", "Failed", "Running".
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_glossary_get_import_csv_operation_status_request(
            operation_guid=operation_guid,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def export_glossary_terms_as_csv(
        self,
        glossary_guid: str,
        term_guids: List[str],
        *,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> IO:
        """Export Glossary Terms as csv file.

        :param glossary_guid: The globally unique identifier for glossary.
        :type glossary_guid: str
        :param term_guids: An array of term guids.
        :type term_guids: list[str]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: IO
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                term_guids = [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]

        _json = term_guids

        request = build_glossary_export_glossary_terms_as_csv_request(
            glossary_guid=glossary_guid,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(IO, deserialized), {})

        return cast(IO, deserialized)



    @distributed_trace_async
    async def list_terms_by_glossary_name(
        self,
        glossary_name: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        include_term_hierarchy: Optional[bool] = False,
        **kwargs: Any
    ) -> List[JSON]:
        """Get terms by glossary name.

        :param glossary_name: The name of the glossary.
        :type glossary_name: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is False.
        :paramtype include_term_hierarchy: bool
        :return: list of JSON object
        :rtype: list[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == [
                    {
                        "abbreviation": "str",  # Optional. The abbreviation of the term.
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "antonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "assignedEntities": [
                            {
                                "displayText": "str",  # Optional. The display text.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "guid": "str",  # Optional. The GUID of the object.
                                "relationshipAttributes": {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "typeName": "str"  # Optional. The name of
                                      the type.
                                },
                                "relationshipGuid": "str",  # Optional. The GUID of
                                  the relationship.
                                "relationshipStatus": "str",  # Optional. The enum of
                                  relationship status. Known values are: "ACTIVE", "DELETED".
                                "relationshipType": "str",  # Optional. An array of
                                  related object IDs.
                                "typeName": "str",  # Optional. The name of the type.
                                "uniqueAttributes": {
                                    "str": {}  # Optional. The unique attributes
                                      of the object.
                                }
                            }
                        ],
                        "attributes": {
                            "str": {
                                "str": {}  # Optional. The custom attributes of the
                                  term, which is map<string,map<string,object>>."nThe key of the first
                                  layer map is term template name.
                            }
                        },
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the record.
                                "displayText": "str",  # Optional. The display text.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str"  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed
                                  from Atlas store. Known values are: "ACTIVE", "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "source": "str",  # Optional. indicate the source who
                                  create the classification detail.
                                "sourceDetails": {
                                    "str": {}  # Optional. more detail on source
                                      information.
                                },
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "classifies": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "examples": [
                            "str"  # Optional. An array of examples.
                        ],
                        "guid": "str",  # Optional. The GUID of the object.
                        "isA": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "preferredTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "preferredToTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "replacedBy": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "replacementTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "resources": [
                            {
                                "displayName": "str",  # Optional. Display name for
                                  url.
                                "url": "str"  # Optional. web url. http or https.
                            }
                        ],
                        "seeAlso": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known
                          values are: "Draft", "Approved", "Alert", "Expired".
                        "synonyms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "templateName": [
                            {}  # Optional.
                        ],
                        "translatedTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "translationTerms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str",  # Optional. The usage of the term.
                        "validValues": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "validValuesFor": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "source": "str",  # Optional. The source of the term.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ]
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[List[JSON]]

        
        request = build_glossary_list_terms_by_glossary_name_request(
            glossary_name=glossary_name,
            api_version=api_version,
            limit=limit,
            offset=offset,
            include_term_hierarchy=include_term_hierarchy,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})

        return cast(List[JSON], deserialized)


class DiscoveryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.catalog.aio.PurviewCatalogClient`'s
        :attr:`discovery` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def query(
        self,
        search_request: JSON,
        **kwargs: Any
    ) -> JSON:
        """Gets data using search.

        :param search_request: An object specifying the search criteria.
        :type search_request: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                search_request = {
                    "facets": [
                        {
                            "count": 0,  # Optional. The count of the facet item.
                            "facet": "str",  # Optional. The name of the facet item.
                            "sort": {}  # Optional. Any object.
                        }
                    ],
                    "filter": {},  # Optional. The filter for the search. See examples for the
                      usage of supported filters.
                    "keywords": "str",  # Optional. The keywords applied to all searchable
                      fields.
                    "limit": 0,  # Optional. The limit of the number of the search result.
                      default value is 50; maximum value is 1000.
                    "offset": 0,  # Optional. The offset. The default value is 0. The maximum
                      value is 100000.
                    "taxonomySetting": {
                        "assetTypes": [
                            "str"  # Optional.
                        ],
                        "facet": {
                            "count": 0,  # Optional. The count of the facet item.
                            "facet": "str",  # Optional. The name of the facet item.
                            "sort": {}  # Optional. Any object.
                        }
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "@search.count": 0,  # Optional. The total number of search results (not the
                      number of documents in a single page).
                    "@search.facets": {
                        "assetType": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ],
                        "classification": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ],
                        "classificationCategory": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ],
                        "contactId": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ],
                        "fileExtension": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ],
                        "label": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ],
                        "term": [
                            {
                                "count": 0,  # Optional. The count of the facet item.
                                "value": "str"  # Optional. The name of the facet
                                  item.
                            }
                        ]
                    },
                    "value": [
                        {
                            "@search.highlights": {
                                "description": [
                                    "str"  # Optional. A highlight list that
                                      consists of index fields id ,qualifiedName, name, description,
                                      entityType. When the keyword appears in those fields, the value
                                      of the field, attached with emphasis mark, is returned as an
                                      element of @search.highlights.
                                ],
                                "entityType": [
                                    "str"  # Optional. A highlight list that
                                      consists of index fields id ,qualifiedName, name, description,
                                      entityType. When the keyword appears in those fields, the value
                                      of the field, attached with emphasis mark, is returned as an
                                      element of @search.highlights.
                                ],
                                "id": [
                                    "str"  # Optional. A highlight list that
                                      consists of index fields id ,qualifiedName, name, description,
                                      entityType. When the keyword appears in those fields, the value
                                      of the field, attached with emphasis mark, is returned as an
                                      element of @search.highlights.
                                ],
                                "name": [
                                    "str"  # Optional. A highlight list that
                                      consists of index fields id ,qualifiedName, name, description,
                                      entityType. When the keyword appears in those fields, the value
                                      of the field, attached with emphasis mark, is returned as an
                                      element of @search.highlights.
                                ],
                                "qualifiedName": [
                                    "str"  # Optional. A highlight list that
                                      consists of index fields id ,qualifiedName, name, description,
                                      entityType. When the keyword appears in those fields, the value
                                      of the field, attached with emphasis mark, is returned as an
                                      element of @search.highlights.
                                ]
                            },
                            "@search.score": 0.0,  # Optional. The search score
                              calculated by the search engine. The results are ordered by search score
                              by default.
                            "@search.text": "str",  # Optional. The target text that
                              contains the keyword as prefix. The keyword is wrapped with emphasis
                              mark.
                            "assetType": [
                                "str"  # Optional. The asset types of the record.
                            ],
                            "classification": [
                                "str"  # Optional. The classifications of the record.
                            ],
                            "contact": [
                                {
                                    "contactType": "str",  # Optional. The type
                                      of the contact. It can be Expert or Owner for an entity. It can
                                      be Expert or Steward for a glossary term.
                                    "id": "str",  # Optional. The GUID of the
                                      contact.
                                    "info": "str"  # Optional. The description of
                                      the contact.
                                }
                            ],
                            "description": "str",  # Optional. The description of the
                              record.
                            "entityType": "str",  # Optional. The type name of the
                              record.
                            "id": "str",  # Optional. The GUID of the record.
                            "label": [
                                "str"  # Optional. The labels of the record.
                            ],
                            "name": "str",  # Optional. The name of the record.
                            "owner": "str",  # Optional. The owner of the record. This is
                              an Atlas native attribute.
                            "qualifiedName": "str",  # Optional. The qualified name of
                              the record.
                            "term": [
                                {
                                    "glossaryName": "str",  # Optional. The name
                                      of the glossary which contains the term.
                                    "guid": "str",  # Optional. The GUID of the
                                      term.
                                    "name": "str"  # Optional. The name of the
                                      term.
                                }
                            ]
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = search_request

        request = build_discovery_query_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def suggest(
        self,
        suggest_request: JSON,
        **kwargs: Any
    ) -> JSON:
        """Get search suggestions by query criteria.

        :param suggest_request: An object specifying the suggest criteria.
        :type suggest_request: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                suggest_request = {
                    "filter": {},  # Optional. The filter for the search.
                    "keywords": "str",  # Optional. The keywords applied to all fields that
                      support suggest operation. It must be at least 1 character, and no more than 100
                      characters. In the index schema we defined a default suggester which lists all
                      the supported fields and specifies a search mode.
                    "limit": 0  # Optional. The number of suggestions we hope to return. The
                      default value is 5. The value must be a number between 1 and 100.
                }

                # response body for status code(s): 200
                response.json() == {
                    "value": [
                        {
                            "@search.score": 0.0,  # Optional. The search score
                              calculated by the search engine. The results are ordered by search score
                              by default.
                            "@search.text": "str",  # Optional. The target text that
                              contains the keyword as prefix. The keyword is wrapped with emphasis
                              mark.
                            "assetType": [
                                "str"  # Optional. The asset types of the record.
                            ],
                            "classification": [
                                "str"  # Optional. The classifications of the record.
                            ],
                            "contact": [
                                {
                                    "contactType": "str",  # Optional. The type
                                      of the contact. It can be Expert or Owner for an entity. It can
                                      be Expert or Steward for a glossary term.
                                    "id": "str",  # Optional. The GUID of the
                                      contact.
                                    "info": "str"  # Optional. The description of
                                      the contact.
                                }
                            ],
                            "description": "str",  # Optional. The description of the
                              record.
                            "entityType": "str",  # Optional. The type name of the
                              record.
                            "id": "str",  # Optional. The GUID of the record.
                            "label": [
                                "str"  # Optional. The labels of the record.
                            ],
                            "name": "str",  # Optional. The name of the record.
                            "owner": "str",  # Optional. The owner of the record. This is
                              an Atlas native attribute.
                            "qualifiedName": "str",  # Optional. The qualified name of
                              the record.
                            "term": [
                                {
                                    "glossaryName": "str",  # Optional. The name
                                      of the glossary which contains the term.
                                    "guid": "str",  # Optional. The GUID of the
                                      term.
                                    "name": "str"  # Optional. The name of the
                                      term.
                                }
                            ]
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = suggest_request

        request = build_discovery_suggest_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def browse(
        self,
        browse_request: JSON,
        **kwargs: Any
    ) -> JSON:
        """Browse entities by path or entity type.

        :param browse_request: An object specifying the browse criteria.
        :type browse_request: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                browse_request = {
                    "entityType": "str",  # Optional. The entity type to browse as the root level
                      entry point.
                    "limit": 0,  # Optional. The number of browse items we hope to return. The
                      maximum value is 10000.
                    "offset": 0,  # Optional. The offset. The default value is 0. The maximum
                      value is 100000.
                    "path": "str"  # Optional. The path to browse the next level child entities.
                }

                # response body for status code(s): 200
                response.json() == {
                    "@search.count": 0,  # Optional. The total number of browse results.
                    "value": [
                        {
                            "entityType": "str",  # Optional. The type name of the
                              record.
                            "id": "str",  # Optional. The GUID of the record.
                            "isLeaf": bool,  # Optional. If the record is a leaf entity.
                            "name": "str",  # Optional. The name of the record.
                            "owner": [
                                {
                                    "contactType": "str",  # Optional. The
                                      contact type of the owner. The value will be Owner.
                                    "displayName": "str",  # Optional. The
                                      display name of the owner.
                                    "id": "str",  # Optional. The GUID of the
                                      owner.
                                    "mail": "str"  # Optional. The mail of the
                                      owner.
                                }
                            ],
                            "path": "str",  # Optional. The path of the record.
                            "qualifiedName": "str"  # Optional. The qualified name of the
                              record.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = browse_request

        request = build_discovery_browse_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def auto_complete(
        self,
        auto_complete_request: JSON,
        **kwargs: Any
    ) -> JSON:
        """Get auto complete options.

        :param auto_complete_request: An object specifying the autocomplete criteria.
        :type auto_complete_request: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                auto_complete_request = {
                    "filter": {},  # Optional. The filter for the autocomplete request.
                    "keywords": "str",  # Optional. The keywords applied to all fields that
                      support autocomplete operation. It must be at least 1 character, and no more than
                      100 characters.
                    "limit": 0  # Optional. The number of autocomplete results we hope to return.
                      The default value is 50. The value must be a number between 1 and 100.
                }

                # response body for status code(s): 200
                response.json() == {
                    "value": [
                        {
                            "queryPlusText": "str",  # Optional. The completed search
                              query text.
                            "text": "str"  # Optional. The completed term or phrase.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = auto_complete_request

        request = build_discovery_auto_complete_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class LineageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.catalog.aio.PurviewCatalogClient`'s
        :attr:`lineage` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def get_lineage_graph(
        self,
        guid: str,
        *,
        direction: str,
        depth: Optional[int] = 3,
        width: Optional[int] = 10,
        include_parent: Optional[bool] = None,
        get_derived_lineage: Optional[bool] = None,
        **kwargs: Any
    ) -> JSON:
        """Get lineage info of the entity specified by GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Known
         values are: "BOTH", "INPUT", and "OUTPUT".
        :paramtype direction: str
        :keyword depth: The number of hops for lineage. Default value is 3.
        :paramtype depth: int
        :keyword width: The number of max expanding width in lineage. Default value is 10.
        :paramtype width: int
        :keyword include_parent: True to include the parent chain in the response. Default value is
         None.
        :paramtype include_parent: bool
        :keyword get_derived_lineage: True to include derived lineage in the response. Default value is
         None.
        :paramtype get_derived_lineage: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "baseEntityGuid": "str",  # Optional. The GUID of the base entity.
                    "childrenCount": 0,  # Optional. The number of children node.
                    "guidEntityMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "includeParent": bool,  # Optional. True to return the parent of the base
                      entity.
                    "lineageDepth": 0,  # Optional. The depth of lineage.
                    "lineageDirection": "str",  # Optional. The enum of lineage direction. Known
                      values are: "INPUT", "OUTPUT", "BOTH".
                    "lineageWidth": 0,  # Optional. The width of lineage.
                    "parentRelations": [
                        {
                            "childEntityId": "str",  # Optional. The GUID of child
                              entity.
                            "parentEntityId": "str",  # Optional. The GUID of parent
                              entity.
                            "relationshipId": "str"  # Optional. The GUID of
                              relationship.
                        }
                    ],
                    "relations": [
                        {
                            "fromEntityId": "str",  # Optional. The GUID of from-entity.
                            "relationshipId": "str",  # Optional. The GUID of
                              relationship.
                            "toEntityId": "str"  # Optional. The GUID of to-entity.
                        }
                    ],
                    "widthCounts": {
                        "str": {
                            "str": {}  # Optional. The entity count in specific
                              direction.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_lineage_get_lineage_graph_request(
            guid=guid,
            direction=direction,
            depth=depth,
            width=width,
            include_parent=include_parent,
            get_derived_lineage=get_derived_lineage,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def next_page_lineage(
        self,
        guid: str,
        *,
        direction: str,
        get_derived_lineage: Optional[bool] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Return immediate next page lineage info about entity with pagination.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Known
         values are: "BOTH", "INPUT", and "OUTPUT".
        :paramtype direction: str
        :keyword get_derived_lineage: True to include derived lineage in the response. Default value is
         None.
        :paramtype get_derived_lineage: bool
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "baseEntityGuid": "str",  # Optional. The GUID of the base entity.
                    "childrenCount": 0,  # Optional. The number of children node.
                    "guidEntityMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "includeParent": bool,  # Optional. True to return the parent of the base
                      entity.
                    "lineageDepth": 0,  # Optional. The depth of lineage.
                    "lineageDirection": "str",  # Optional. The enum of lineage direction. Known
                      values are: "INPUT", "OUTPUT", "BOTH".
                    "lineageWidth": 0,  # Optional. The width of lineage.
                    "parentRelations": [
                        {
                            "childEntityId": "str",  # Optional. The GUID of child
                              entity.
                            "parentEntityId": "str",  # Optional. The GUID of parent
                              entity.
                            "relationshipId": "str"  # Optional. The GUID of
                              relationship.
                        }
                    ],
                    "relations": [
                        {
                            "fromEntityId": "str",  # Optional. The GUID of from-entity.
                            "relationshipId": "str",  # Optional. The GUID of
                              relationship.
                            "toEntityId": "str"  # Optional. The GUID of to-entity.
                        }
                    ],
                    "widthCounts": {
                        "str": {
                            "str": {}  # Optional. The entity count in specific
                              direction.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-03-01-preview"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_lineage_next_page_lineage_request(
            guid=guid,
            api_version=api_version,
            direction=direction,
            get_derived_lineage=get_derived_lineage,
            offset=offset,
            limit=limit,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_lineage_by_unique_attribute(
        self,
        type_name: str,
        *,
        direction: str,
        depth: Optional[int] = 3,
        width: Optional[int] = 10,
        include_parent: Optional[bool] = None,
        get_derived_lineage: Optional[bool] = None,
        **kwargs: Any
    ) -> JSON:
        """Returns lineage info about entity.

        In addition to the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format

        attr:[attrName]=[attrValue]

        NOTE: The attrName and attrValue should be unique across entities, eg. qualifiedName.

        :param type_name: The name of the type.
        :type type_name: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Known
         values are: "BOTH", "INPUT", and "OUTPUT".
        :paramtype direction: str
        :keyword depth: The number of hops for lineage. Default value is 3.
        :paramtype depth: int
        :keyword width: The number of max expanding width in lineage. Default value is 10.
        :paramtype width: int
        :keyword include_parent: True to include the parent chain in the response. Default value is
         None.
        :paramtype include_parent: bool
        :keyword get_derived_lineage: True to include derived lineage in the response. Default value is
         None.
        :paramtype get_derived_lineage: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "baseEntityGuid": "str",  # Optional. The GUID of the base entity.
                    "childrenCount": 0,  # Optional. The number of children node.
                    "guidEntityMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "includeParent": bool,  # Optional. True to return the parent of the base
                      entity.
                    "lineageDepth": 0,  # Optional. The depth of lineage.
                    "lineageDirection": "str",  # Optional. The enum of lineage direction. Known
                      values are: "INPUT", "OUTPUT", "BOTH".
                    "lineageWidth": 0,  # Optional. The width of lineage.
                    "parentRelations": [
                        {
                            "childEntityId": "str",  # Optional. The GUID of child
                              entity.
                            "parentEntityId": "str",  # Optional. The GUID of parent
                              entity.
                            "relationshipId": "str"  # Optional. The GUID of
                              relationship.
                        }
                    ],
                    "relations": [
                        {
                            "fromEntityId": "str",  # Optional. The GUID of from-entity.
                            "relationshipId": "str",  # Optional. The GUID of
                              relationship.
                            "toEntityId": "str"  # Optional. The GUID of to-entity.
                        }
                    ],
                    "widthCounts": {
                        "str": {
                            "str": {}  # Optional. The entity count in specific
                              direction.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_lineage_get_lineage_by_unique_attribute_request(
            type_name=type_name,
            direction=direction,
            depth=depth,
            width=width,
            include_parent=include_parent,
            get_derived_lineage=get_derived_lineage,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class RelationshipOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.catalog.aio.PurviewCatalogClient`'s
        :attr:`relationship` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def create(
        self,
        relationship: JSON,
        **kwargs: Any
    ) -> JSON:
        """Create a new relationship between entities.

        :param relationship: The AtlasRelationship object containing the information for the
         relationship to be created.
        :type relationship: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                relationship = {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an
                      instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Known values
                      are: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an
                      instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Known values
                      are: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = relationship

        request = build_relationship_create_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def update(
        self,
        relationship: JSON,
        **kwargs: Any
    ) -> JSON:
        """Update an existing relationship between entities.

        :param relationship: The AtlasRelationship object containing the information for the
         relationship to be created.
        :type relationship: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                relationship = {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an
                      instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Known values
                      are: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }

                # response body for status code(s): 200
                response.json() == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "end1": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "end2": {
                        "guid": "str",  # Optional. The GUID of the object.
                        "typeName": "str",  # Optional. The name of the type.
                        "uniqueAttributes": {
                            "str": {}  # Optional. The unique attributes of the object.
                        }
                    },
                    "guid": "str",  # Optional. The GUID of the relationship.
                    "homeId": "str",  # Optional. The home ID of the relationship.
                    "label": "str",  # Optional. The label of the relationship.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "provenanceType": 0.0,  # Optional. Used to record the provenance of an
                      instance of an entity or relationship.
                    "status": "str",  # Optional. The enum of relationship status. Known values
                      are: "ACTIVE", "DELETED".
                    "typeName": "str",  # Optional. The name of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the relationship.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = relationship

        request = build_relationship_update_request(
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get(
        self,
        guid: str,
        *,
        extended_info: Optional[bool] = None,
        **kwargs: Any
    ) -> JSON:
        """Get relationship information between entities by its GUID.

        :param guid: The globally unique identifier of the relationship.
        :type guid: str
        :keyword extended_info: Limits whether includes extended information. Default value is None.
        :paramtype extended_info: bool
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed from Atlas store. Known values are: "ACTIVE", "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "source": "str",  # Optional. indicate the
                                      source who create the classification detail.
                                    "sourceDetails": {
                                        "str": {}  # Optional. more detail on
                                          source information.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "source": "str",  # Optional. The source of
                                      the term.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed from Atlas store.
                              Known values are: "ACTIVE", "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    },
                    "relationship": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "createTime": 0.0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "end1": {
                            "guid": "str",  # Optional. The GUID of the object.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        },
                        "end2": {
                            "guid": "str",  # Optional. The GUID of the object.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        },
                        "guid": "str",  # Optional. The GUID of the relationship.
                        "homeId": "str",  # Optional. The home ID of the relationship.
                        "label": "str",  # Optional. The label of the relationship.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "provenanceType": 0.0,  # Optional. Used to record the provenance of
                          an instance of an entity or relationship.
                        "status": "str",  # Optional. The enum of relationship status. Known
                          values are: "ACTIVE", "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0.0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0.0  # Optional. The version of the relationship.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_relationship_get_request(
            guid=guid,
            extended_info=extended_info,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        **kwargs: Any
    ) -> None:
        """Delete a relationship between entities by its GUID.

        :param guid: The globally unique identifier of the relationship.
        :type guid: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_relationship_delete_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})


class TypesOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.catalog.aio.PurviewCatalogClient`'s
        :attr:`types` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def get_business_metadata_def_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the businessMetadata definition for the given guid.

        :param guid: businessMetadata guid.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_business_metadata_def_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_business_metadata_def_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the businessMetadata definition by it's name (unique).

        :param name: businessMetadata name.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_business_metadata_def_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_classification_def_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the classification definition for the given GUID.

        :param guid: The globally unique identifier of the classification.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the
                          classificationDef, ensures that classifications can"nonly be applied to those
                          entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity
                          types inherit the restriction</li>"n   <li>Any classificationDef subtypes
                          inherit the parents entityTypes restrictions</li>"n   <li>Any
                          classificationDef subtypes can further restrict the parents entityTypes
                          restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty
                          entityTypes list when there are no parent restrictions means there are no
                          restrictions</li>"n   <li>An empty entityTypes list when there are parent
                          restrictions means that the subtype picks up the parents restrictions</li>"n
                          <li>If a list of entityTypes are supplied, where one inherits from another,
                          this will be rejected. This should encourage cleaner
                          classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_classification_def_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_classification_def_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the classification definition by its name (unique).

        :param name: The name of the classification.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the
                          classificationDef, ensures that classifications can"nonly be applied to those
                          entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity
                          types inherit the restriction</li>"n   <li>Any classificationDef subtypes
                          inherit the parents entityTypes restrictions</li>"n   <li>Any
                          classificationDef subtypes can further restrict the parents entityTypes
                          restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty
                          entityTypes list when there are no parent restrictions means there are no
                          restrictions</li>"n   <li>An empty entityTypes list when there are parent
                          restrictions means that the subtype picks up the parents restrictions</li>"n
                          <li>If a list of entityTypes are supplied, where one inherits from another,
                          this will be rejected. This should encourage cleaner
                          classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_classification_def_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_entity_definition_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the Entity definition for the given GUID.

        :param guid: The globally unique identifier of the entity.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a
                              legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the
                              relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_entity_definition_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_entity_definition_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the entity definition by its name (unique).

        :param name: The name of the entity.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a
                              legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the
                              relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_entity_definition_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_enum_def_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the enum definition for the given GUID.

        :param guid: The globally unique identifier of the enum.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the
                              enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element
                              definition.
                            "value": "str"  # Optional. The value of the enum element
                              definition.
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_enum_def_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_enum_def_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the enum definition by its name (unique).

        :param name: The name of the enum.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the
                              enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element
                              definition.
                            "value": "str"  # Optional. The value of the enum element
                              definition.
                        }
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_enum_def_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_relationship_def_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the relationship definition for the given GUID.

        :param guid: The globally unique identifier of the relationship.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipCategory": "str",  # Optional. The Relationship category
                      determines the style of relationship around containment and lifecycle."nUML
                      terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship
                      with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment
                      relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the
                      container and its children. In the COMPOSITION case,"nthe children cannot exist
                      without the container. For AGGREGATION, the life cycles"nof the container and
                      children are totally independent. Known values are: "ASSOCIATION", "AGGREGATION",
                      "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_relationship_def_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_relationship_def_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the relationship definition by its name (unique).

        :param name: The name of the relationship.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipCategory": "str",  # Optional. The Relationship category
                      determines the style of relationship around containment and lifecycle."nUML
                      terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship
                      with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment
                      relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the
                      container and its children. In the COMPOSITION case,"nthe children cannot exist
                      without the container. For AGGREGATION, the life cycles"nof the container and
                      children are totally independent. Known values are: "ASSOCIATION", "AGGREGATION",
                      "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_relationship_def_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_struct_def_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the struct definition for the given GUID.

        :param guid: The globally unique identifier of the struct.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_struct_def_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_struct_def_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the struct definition by its name (unique).

        :param name: The name of the struct.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "description": "str",  # Optional. The description of the type definition.
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "serviceType": "str",  # Optional. The service type.
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_struct_def_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_type_definition_by_guid(
        self,
        guid: str,
        **kwargs: Any
    ) -> JSON:
        """Get the type definition for the given GUID.

        :param guid: The globally unique identifier of the type.
        :type guid: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the
                              enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element
                              definition.
                            "value": "str"  # Optional. The value of the enum element
                              definition.
                        }
                    ],
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the
                          classificationDef, ensures that classifications can"nonly be applied to those
                          entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity
                          types inherit the restriction</li>"n   <li>Any classificationDef subtypes
                          inherit the parents entityTypes restrictions</li>"n   <li>Any
                          classificationDef subtypes can further restrict the parents entityTypes
                          restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty
                          entityTypes list when there are no parent restrictions means there are no
                          restrictions</li>"n   <li>An empty entityTypes list when there are parent
                          restrictions means that the subtype picks up the parents restrictions</li>"n
                          <li>If a list of entityTypes are supplied, where one inherits from another,
                          this will be rejected. This should encourage cleaner
                          classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a
                              legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the
                              relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "relationshipCategory": "str",  # Optional. The Relationship category
                      determines the style of relationship around containment and lifecycle."nUML
                      terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship
                      with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment
                      relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the
                      container and its children. In the COMPOSITION case,"nthe children cannot exist
                      without the container. For AGGREGATION, the life cycles"nof the container and
                      children are totally independent. Known values are: "ASSOCIATION", "AGGREGATION",
                      "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_type_definition_by_guid_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def get_type_definition_by_name(
        self,
        name: str,
        **kwargs: Any
    ) -> JSON:
        """Get the type definition by its name (unique).

        :param name: The name of the type.
        :type name: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "attributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "category": "str",  # Optional. The enum of type category. Known values are:
                      "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY",
                      "ARRAY", "MAP", "RELATIONSHIP", "TERM_TEMPLATE".
                    "createTime": 0.0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "dateFormatter": {
                        "availableLocales": [
                            "str"  # Optional. An array of available locales.
                        ],
                        "calendar": 0.0,  # Optional. The date format.
                        "dateInstance": ...,
                        "dateTimeInstance": ...,
                        "instance": ...,
                        "lenient": bool,  # Optional. Determines the leniency of the date
                          format.
                        "numberFormat": {
                            "availableLocales": [
                                "str"  # Optional. The number format.
                            ],
                            "currency": "str",  # Optional. The currency.
                            "currencyInstance": ...,
                            "groupingUsed": bool,  # Optional. Determines if grouping is
                              used.
                            "instance": ...,
                            "integerInstance": ...,
                            "maximumFractionDigits": 0,  # Optional. The maximum of
                              fraction digits.
                            "maximumIntegerDigits": 0,  # Optional. The maximum of
                              integer digits.
                            "minimumFractionDigits": 0,  # Optional. The minimum of
                              fraction digits.
                            "minimumIntegerDigits": 0,  # Optional. The minimum of
                              integer digits.
                            "numberInstance": ...,
                            "parseIntegerOnly": bool,  # Optional. Determines if only
                              integer is parsed.
                            "percentInstance": ...,
                            "roundingMode": "str"  # Optional. The enum of rounding mode.
                              Known values are: "UP", "DOWN", "CEILING", "FLOOR", "HALF_UP",
                              "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                        },
                        "timeInstance": ...,
                        "timeZone": {
                            "availableIds": [
                                "str"  # Optional. An array of available IDs.
                            ],
                            "default": ...,
                            "displayName": "str",  # Optional. The display name of the
                              timezone.
                            "dstSavings": 0,  # Optional. The value of the daylight
                              saving time.
                            "id": "str",  # Optional. The ID of the timezone.
                            "rawOffset": 0  # Optional. The raw offset of the timezone.
                        }
                    },
                    "defaultValue": "str",  # Optional. The default value.
                    "description": "str",  # Optional. The description of the type definition.
                    "elementDefs": [
                        {
                            "description": "str",  # Optional. The description of the
                              enum element definition.
                            "ordinal": 0.0,  # Optional. The ordinal of the enum element
                              definition.
                            "value": "str"  # Optional. The value of the enum element
                              definition.
                        }
                    ],
                    "endDef1": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "endDef2": {
                        "cardinality": "str",  # Optional. single-valued attribute or
                          multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                        "description": "str",  # Optional. The description of the
                          relationship end definition.
                        "isContainer": bool,  # Optional. Determines if it is container.
                        "isLegacyAttribute": bool,  # Optional. Determines if it is a legacy
                          attribute.
                        "name": "str",  # Optional. The name of the relationship end
                          definition.
                        "type": "str"  # Optional. The type of the relationship end.
                    },
                    "entityTypes": [
                        "str"  # Optional. Specifying a list of entityType names in the
                          classificationDef, ensures that classifications can"nonly be applied to those
                          entityTypes."n"n"n.. raw:: html"n"n   <ul>"n   <li>Any subtypes of the entity
                          types inherit the restriction</li>"n   <li>Any classificationDef subtypes
                          inherit the parents entityTypes restrictions</li>"n   <li>Any
                          classificationDef subtypes can further restrict the parents entityTypes
                          restrictions by specifying a subset of the entityTypes</li>"n   <li>An empty
                          entityTypes list when there are no parent restrictions means there are no
                          restrictions</li>"n   <li>An empty entityTypes list when there are parent
                          restrictions means that the subtype picks up the parents restrictions</li>"n
                          <li>If a list of entityTypes are supplied, where one inherits from another,
                          this will be rejected. This should encourage cleaner
                          classificationsDefs</li>"n   </ul>.
                    ],
                    "guid": "str",  # Optional. The GUID of the type definition.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "name": "str",  # Optional. The name of the type definition.
                    "options": {
                        "str": "str"  # Optional. The options for the type definition.
                    },
                    "relationshipAttributeDefs": [
                        {
                            "cardinality": "str",  # Optional. single-valued attribute or
                              multi-valued attribute. Known values are: "SINGLE", "LIST", "SET".
                            "constraints": [
                                {
                                    "params": {
                                        "str": {}  # Optional. The parameters
                                          of the constraint definition.
                                    },
                                    "type": "str"  # Optional. The type of the
                                      constraint.
                                }
                            ],
                            "defaultValue": "str",  # Optional. The default value of the
                              attribute.
                            "description": "str",  # Optional. The description of the
                              attribute.
                            "includeInNotification": bool,  # Optional. Determines if it
                              is included in notification.
                            "isIndexable": bool,  # Optional. Determines if it is
                              indexable.
                            "isLegacyAttribute": bool,  # Optional. Determines if it is a
                              legacy attribute.
                            "isOptional": bool,  # Optional. Determines if it is
                              optional.
                            "isUnique": bool,  # Optional. Determines if it unique.
                            "name": "str",  # Optional. The name of the attribute.
                            "options": {
                                "str": "str"  # Optional. The options for the
                                  attribute.
                            },
                            "relationshipTypeName": "str",  # Optional. The name of the
                              relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "valuesMaxCount": 0,  # Optional. The maximum count of the
                              values.
                            "valuesMinCount": 0  # Optional. The minimum count of the
                              values.
                        }
                    ],
                    "relationshipCategory": "str",  # Optional. The Relationship category
                      determines the style of relationship around containment and lifecycle."nUML
                      terminology is used for the values."n"n:code:`<p>`"nASSOCIATION is a relationship
                      with no containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment
                      relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of the
                      container and its children. In the COMPOSITION case,"nthe children cannot exist
                      without the container. For AGGREGATION, the life cycles"nof the container and
                      children are totally independent. Known values are: "ASSOCIATION", "AGGREGATION",
                      "COMPOSITION".
                    "relationshipLabel": "str",  # Optional. The label of the relationship.
                    "serviceType": "str",  # Optional. The service type.
                    "subTypes": [
                        "str"  # Optional. An array of sub types.
                    ],
                    "superTypes": [
                        "str"  # Optional. An array of super types.
                    ],
                    "typeVersion": "str",  # Optional. The version of the type.
                    "updateTime": 0.0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "version": 0.0  # Optional. The version of the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        
        request = build_types_get_type_definition_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    @distributed_trace_async
    async def delete_type_by_name(  # pylint: disable=inconsistent-return-statements
        self,
        name: str,
        **kwargs: Any
    ) -> None:
        """Delete API for type identified by its name.

        :param name: The name of the type.
        :type name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_types_delete_type_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})



    @distributed_trace_async
    async def get_all_type_definitions(
        self,
        *,
        include_term_template: Optional[bool] = False,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> JSON:
        """Get all type definitions in Atlas in bulk.

        :keyword include_term_template: Whether include termtemplatedef when return all typedefs.
         This is always true when search filter type=term_template. Default value is False.
        :paramtype include_term_template: bool
        :keyword type: Typedef name as search filter when get typedefs. Known values are: "enum",
         "entity", "classification", "relationship", "struct", and "term_template". Default value is
         None.
        :paramtype type: str
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "businessMetadataDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of
                                      the daylight saving time.
                                    "id": "str",  # Optional. The ID of the
                                      timezone.
                                    "rawOffset": 0  # Optional. The raw offset of
                                      the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the
                              type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type
                                  definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "classificationDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of
                                      the daylight saving time.
                                    "id": "str",  # Optional. The ID of the
                                      timezone.
                                    "rawOffset": 0  # Optional. The raw offset of
                                      the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the
                              type definition.
                            "entityTypes": [
                                "str"  # Optional. Specifying a list of entityType
                                  names in the classificationDef, ensures that classifications
                                  can"nonly be applied to those entityTypes."n"n"n.. raw:: html"n"n
                                  <ul>"n   <li>Any subtypes of the entity types inherit the
                                  restriction</li>"n   <li>Any classificationDef subtypes inherit the
                                  parents entityTypes restrictions</li>"n   <li>Any classificationDef
                                  subtypes can further restrict the parents entityTypes restrictions by
                                  specifying a subset of the entityTypes</li>"n   <li>An empty
                                  entityTypes list when there are no parent restrictions means there
                                  are no restrictions</li>"n   <li>An empty entityTypes list when there
                                  are parent restrictions means that the subtype picks up the parents
                                  restrictions</li>"n   <li>If a list of entityTypes are supplied,
                                  where one inherits from another, this will be rejected. This should
                                  encourage cleaner classificationsDefs</li>"n   </ul>.
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type
                                  definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "entityDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of
                                      the daylight saving time.
                                    "id": "str",  # Optional. The ID of the
                                      timezone.
                                    "rawOffset": 0  # Optional. The raw offset of
                                      the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the
                              type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type
                                  definition.
                            },
                            "relationshipAttributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isLegacyAttribute": bool,  # Optional.
                                      Determines if it is a legacy attribute.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "relationshipTypeName": "str",  # Optional.
                                      The name of the relationship type.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "serviceType": "str",  # Optional. The service type.
                            "subTypes": [
                                "str"  # Optional. An array of sub types.
                            ],
                            "superTypes": [
                                "str"  # Optional. An array of super types.
                            ],
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "enumDefs": [
                        {
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of
                                      the daylight saving time.
                                    "id": "str",  # Optional. The ID of the
                                      timezone.
                                    "rawOffset": 0  # Optional. The raw offset of
                                      the timezone.
                                }
                            },
                            "defaultValue": "str",  # Optional. The default value.
                            "description": "str",  # Optional. The description of the
                              type definition.
                            "elementDefs": [
                                {
                                    "description": "str",  # Optional. The
                                      description of the enum element definition.
                                    "ordinal": 0.0,  # Optional. The ordinal of
                                      the enum element definition.
                                    "value": "str"  # Optional. The value of the
                                      enum element definition.
                                }
                            ],
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type
                                  definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "relationshipDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of
                                      the daylight saving time.
                                    "id": "str",  # Optional. The ID of the
                                      timezone.
                                    "rawOffset": 0  # Optional. The raw offset of
                                      the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the
                              type definition.
                            "endDef1": {
                                "cardinality": "str",  # Optional. single-valued
                                  attribute or multi-valued attribute. Known values are: "SINGLE",
                                  "LIST", "SET".
                                "description": "str",  # Optional. The description of
                                  the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is
                                  container.
                                "isLegacyAttribute": bool,  # Optional. Determines if
                                  it is a legacy attribute.
                                "name": "str",  # Optional. The name of the
                                  relationship end definition.
                                "type": "str"  # Optional. The type of the
                                  relationship end.
                            },
                            "endDef2": {
                                "cardinality": "str",  # Optional. single-valued
                                  attribute or multi-valued attribute. Known values are: "SINGLE",
                                  "LIST", "SET".
                                "description": "str",  # Optional. The description of
                                  the relationship end definition.
                                "isContainer": bool,  # Optional. Determines if it is
                                  container.
                                "isLegacyAttribute": bool,  # Optional. Determines if
                                  it is a legacy attribute.
                                "name": "str",  # Optional. The name of the
                                  relationship end definition.
                                "type": "str"  # Optional. The type of the
                                  relationship end.
                            },
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type
                                  definition.
                            },
                            "relationshipCategory": "str",  # Optional. The Relationship
                              category determines the style of relationship around containment and
                              lifecycle."nUML terminology is used for the
                              values."n"n:code:`<p>`"nASSOCIATION is a relationship with no
                              containment. :code:`<br>`"nCOMPOSITION and AGGREGATION are containment
                              relationships."n"n:code:`<p>`"nThe difference being in the lifecycles of
                              the container and its children. In the COMPOSITION case,"nthe children
                              cannot exist without the container. For AGGREGATION, the life cycles"nof
                              the container and children are totally independent. Known values are:
                              "ASSOCIATION", "AGGREGATION", "COMPOSITION".
                            "relationshipLabel": "str",  # Optional. The label of the
                              relationship.
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "structDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                                    "dstSavings": 0,  # Optional. The value of
                                      the daylight saving time.
                                    "id": "str",  # Optional. The ID of the
                                      timezone.
                                    "rawOffset": 0  # Optional. The raw offset of
                                      the timezone.
                                }
                            },
                            "description": "str",  # Optional. The description of the
                              type definition.
                            "guid": "str",  # Optional. The GUID of the type definition.
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "name": "str",  # Optional. The name of the type definition.
                            "options": {
                                "str": "str"  # Optional. The options for the type
                                  definition.
                            },
                            "serviceType": "str",  # Optional. The service type.
                            "typeVersion": "str",  # Optional. The version of the type.
                            "updateTime": 0.0,  # Optional. The update time of the
                              record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0.0  # Optional. The version of the record.
                        }
                    ],
                    "termTemplateDefs": [
                        {
                            "attributeDefs": [
                                {
                                    "cardinality": "str",  # Optional.
                                      single-valued attribute or multi-valued attribute. Known values
                                      are: "SINGLE", "LIST", "SET".
                                    "constraints": [
                                        {
                                            "params": {
                                                "str": {}  #
                                                  Optional. The parameters of the constraint
                                                  definition.
                                            },
                                            "type": "str"  # Optional.
                                              The type of the constraint.
                                        }
                                    ],
                                    "defaultValue": "str",  # Optional. The
                                      default value of the attribute.
                                    "description": "str",  # Optional. The
                                      description of the attribute.
                                    "includeInNotification": bool,  # Optional.
                                      Determines if it is included in notification.
                                    "isIndexable": bool,  # Optional. Determines
                                      if it is indexable.
                                    "isOptional": bool,  # Optional. Determines
                                      if it is optional.
                                    "isUnique": bool,  # Optional. Determines if
                                      it unique.
                                    "name": "str",  # Optional. The name of the
                                      attribute.
                                    "options": {
                                        "str": "str"  # Optional. The options
                                          for the attribute.
                                    },
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "valuesMaxCount": 0,  # Optional. The maximum
                                      count of the values.
                                    "valuesMinCount": 0  # Optional. The minimum
                                      count of the values.
                                }
                            ],
                            "category": "str",  # Optional. The enum of type category.
                              Known values are: "PRIMITIVE", "OBJECT_ID_TYPE", "ENUM", "STRUCT",
                              "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
                              "TERM_TEMPLATE".
                            "createTime": 0.0,  # Optional. The created time of the
                              record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "dateFormatter": {
                                "availableLocales": [
                                    "str"  # Optional. An array of available
                                      locales.
                                ],
                                "calendar": 0.0,  # Optional. The date format.
                                "dateInstance": ...,
                                "dateTimeInstance": ...,
                                "instance": ...,
                                "lenient": bool,  # Optional. Determines the leniency
                                  of the date format.
                                "numberFormat": {
                                    "availableLocales": [
                                        "str"  # Optional. The number format.
                                    ],
                                    "currency": "str",  # Optional. The currency.
                                    "currencyInstance": ...,
                                    "groupingUsed": bool,  # Optional. Determines
                                      if grouping is used.
                                    "instance": ...,
                                    "integerInstance": ...,
                                    "maximumFractionDigits": 0,  # Optional. The
                                      maximum of fraction digits.
                                    "maximumIntegerDigits": 0,  # Optional. The
                                      maximum of integer digits.
                                    "minimumFractionDigits": 0,  # Optional. The
                                      minimum of fraction digits.
                                    "minimumIntegerDigits": 0,  # Optional. The
                                      minimum of integer digits.
                                    "numberInstance": ...,
                                    "parseIntegerOnly": bool,  # Optional.
                                      Determines if only integer is parsed.
                                    "percentInstance": ...,
                                    "roundingMode": "str"  # Optional. The enum
                                      of rounding mode. Known values are: "UP", "DOWN", "CEILING",
                                      "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN", "UNNECESSARY".
                                },
                                "timeInstance": ...,
                                "timeZone": {
                                    "availableIds": [
                                        "str"  # Optional. An array of
                                          available IDs.
                                    ],
                                    "default": ...,
                                    "displayName": "str",  # Optional. The
                                      display name of the timezone.
                          