# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AlertSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity Level of Alert."""

    ZERO = "0"
    ONE = "1"
    TWO = "2"
    THREE = "3"
    FOUR = "4"


class ConditionalOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Result Condition Evaluation criteria."""

    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    LESS_THAN = "LessThan"
    EQUAL = "Equal"


class Enabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The flag which indicates whether the Log Search rule is enabled. Value should be true or false."""

    TRUE = "true"
    FALSE = "false"


class MetricTriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric Trigger Evaluation Type."""

    CONSECUTIVE = "Consecutive"
    TOTAL = "Total"


class Operator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operator for dimension values."""

    INCLUDE = "Include"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the scheduled query rule."""

    SUCCEEDED = "Succeeded"
    DEPLOYING = "Deploying"
    CANCELED = "Canceled"
    FAILED = "Failed"


class QueryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Set value to 'ResultAccount'."""

    RESULT_COUNT = "ResultCount"
