# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.hybridnetwork import HybridNetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hybridnetwork
# USAGE
    python vendor_nf_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HybridNetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.vendor_network_functions.begin_create_or_update(
        location_name="eastus",
        vendor_name="testVendor",
        service_key="testServiceKey",
        parameters={
            "properties": {
                "networkFunctionVendorConfigurations": [
                    {
                        "networkInterfaces": [
                            {
                                "ipConfigurations": [
                                    {
                                        "dnsServers": None,
                                        "gateway": "",
                                        "ipAddress": "",
                                        "ipAllocationMethod": "Dynamic",
                                        "ipVersion": "IPv4",
                                        "subnet": "",
                                    }
                                ],
                                "macAddress": "",
                                "networkInterfaceName": "nic1",
                                "vmSwitchType": "Management",
                            },
                            {
                                "ipConfigurations": [
                                    {
                                        "dnsServers": None,
                                        "gateway": "",
                                        "ipAddress": "",
                                        "ipAllocationMethod": "Dynamic",
                                        "ipVersion": "IPv4",
                                        "subnet": "",
                                    }
                                ],
                                "macAddress": "DC-97-F8-79-16-7D",
                                "networkInterfaceName": "nic2",
                                "vmSwitchType": "Wan",
                            },
                        ],
                        "osProfile": {
                            "adminUsername": "dummyuser",
                            "customData": "base-64 encoded string of custom data",
                            "linuxConfiguration": {
                                "ssh": {
                                    "publicKeys": [
                                        {
                                            "keyData": "ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAgEAwrr66r8n6B8Y0zMF3dOpXEapIQD9DiYQ6D6/zwor9o39jSkHNiMMER/GETBbzP83LOcekm02aRjo55ArO7gPPVvCXbrirJu9pkm4AC4BBre5xSLS= user@constoso-DSH",
                                            "path": "home/user/.ssh/authorized_keys",
                                        }
                                    ]
                                }
                            },
                        },
                        "roleName": "testRole",
                        "userDataParameters": {},
                    }
                ],
                "skuType": "SDWAN",
                "vendorProvisioningState": "Provisioning",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/preview/2022-01-01-preview/examples/VendorNfCreate.json
if __name__ == "__main__":
    main()
