# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionStatusEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes whether the order item is deletable or not.
    """

    #: Allowed flag.
    ALLOWED = "Allowed"
    #: Not Allowed flag.
    NOT_ALLOWED = "NotAllowed"

class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
    """

    INTERNAL = "Internal"

class AddressType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of address.
    """

    #: Address type not known.
    NONE = "None"
    #: Residential Address.
    RESIDENTIAL = "Residential"
    #: Commercial Address.
    COMMERCIAL = "Commercial"

class AddressValidationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of address validation
    """

    #: Address provided is valid.
    VALID = "Valid"
    #: Address provided is invalid or not supported.
    INVALID = "Invalid"
    #: Address provided is ambiguous, please choose one of the alternate addresses returned.
    AMBIGUOUS = "Ambiguous"

class AvailabilityStage(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Current availability stage of the product. Availability stage
    """

    #: Product is available.
    AVAILABLE = "Available"
    #: Product is coming soon.
    COMING_SOON = "ComingSoon"
    #: Product is in preview.
    PREVIEW = "Preview"
    #: Product is deprecated.
    DEPRECATED = "Deprecated"
    #: Product is available only on signup.
    SIGNUP = "Signup"
    #: Product is not available.
    UNAVAILABLE = "Unavailable"

class BillingType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Represents billing type.
    """

    #: PaV2 billing.
    PAV2 = "Pav2"
    #: Purchase billing.
    PURCHASE = "Purchase"

class ChargingType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Charging type.
    """

    #: Per order charging type.
    PER_ORDER = "PerOrder"
    #: Per device charging type.
    PER_DEVICE = "PerDevice"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DescriptionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of description.
    """

    #: Base description.
    BASE = "Base"

class DisabledReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Reason why the product is disabled.
    """

    #: Not disabled.
    NONE = "None"
    #: Not available in the requested country.
    COUNTRY = "Country"
    #: Not available to push data to the requested Azure region.
    REGION = "Region"
    #: Required features are not enabled.
    FEATURE = "Feature"
    #: Subscription does not have required offer types.
    OFFER_TYPE = "OfferType"
    #: Subscription has not registered to Microsoft.DataBox and Service does not have the subscription
    #: notification.
    NO_SUBSCRIPTION_INFO = "NoSubscriptionInfo"
    #: The product is not yet available.
    NOT_AVAILABLE = "NotAvailable"
    #: The product is out of stock.
    OUT_OF_STOCK = "OutOfStock"

class DoubleEncryptionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Double encryption status as entered by the customer. It is compulsory to give this parameter if
    the 'Deny' or 'Disabled' policy is configured.
    """

    #: Double encryption is disabled.
    DISABLED = "Disabled"
    #: Double encryption is enabled.
    ENABLED = "Enabled"

class ImageType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the image
    """

    #: Main image.
    MAIN_IMAGE = "MainImage"
    #: Bullet image.
    BULLET_IMAGE = "BulletImage"
    #: Generic image.
    GENERIC_IMAGE = "GenericImage"

class LengthHeightUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Unit for the dimensions of length, height and width.
    """

    #: Inch, applicable for West US.
    IN_ENUM = "IN"
    #: Centimeter.
    CM = "CM"

class LinkType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of link
    """

    #: Generic link.
    GENERIC = "Generic"
    #: Terms and conditions link.
    TERMS_AND_CONDITIONS = "TermsAndConditions"
    #: Link to product specification.
    SPECIFICATION = "Specification"
    #: Link to product documentation.
    DOCUMENTATION = "Documentation"
    #: Link to know more.
    KNOW_MORE = "KnowMore"
    #: Link to sign up for products.
    SIGN_UP = "SignUp"

class MeteringType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Represents Metering type (eg one-time or recurrent)
    """

    #: One time billing.
    ONE_TIME = "OneTime"
    #: Recurring billing.
    RECURRING = "Recurring"
    #: Adhoc billing.
    ADHOC = "Adhoc"

class NotificationStageName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the stage.
    """

    #: Notification at order item shipped from microsoft datacenter.
    SHIPPED = "Shipped"
    #: Notification at order item delivered to customer.
    DELIVERED = "Delivered"

class OrderItemCancellationEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes whether the order item is cancellable or not.
    """

    #: Order item can be cancelled without fee.
    CANCELLABLE = "Cancellable"
    #: Order item can be cancelled with fee.
    CANCELLABLE_WITH_FEE = "CancellableWithFee"
    #: Order item not cancellable.
    NOT_CANCELLABLE = "NotCancellable"

class OrderItemReturnEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes whether the order item is returnable or not.
    """

    #: Order item can be returned without fee.
    RETURNABLE = "Returnable"
    #: Order item can be returned with fee.
    RETURNABLE_WITH_FEE = "ReturnableWithFee"
    #: Order item not returnable.
    NOT_RETURNABLE = "NotReturnable"

class OrderItemType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Order item type.
    """

    #: Purchase OrderItem.
    PURCHASE = "Purchase"
    #: Rental OrderItem.
    RENTAL = "Rental"

class Origin(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system"
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"

class StageName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Stage name
    """

    #: Currently in draft mode and can still be cancelled.
    PLACED = "Placed"
    #: Order is currently in draft mode and can still be cancelled.
    IN_REVIEW = "InReview"
    #: Order is confirmed.
    CONFIRMED = "Confirmed"
    #: Order is ready to ship.
    READY_TO_SHIP = "ReadyToShip"
    #: Order is in transit to customer.
    SHIPPED = "Shipped"
    #: Order is delivered to customer.
    DELIVERED = "Delivered"
    #: Order is in use at customer site.
    IN_USE = "InUse"
    #: Return has been initiated by customer.
    RETURN_INITIATED = "ReturnInitiated"
    #: Order is in transit from customer to microsoft.
    RETURN_PICKED_UP = "ReturnPickedUp"
    #: Order has been received back to microsoft.
    RETURNED_TO_MICROSOFT = "ReturnedToMicrosoft"
    #: Return has now completed.
    RETURN_COMPLETED = "ReturnCompleted"
    #: Order has been cancelled.
    CANCELLED = "Cancelled"

class StageStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Stage status.
    """

    #: No status available yet.
    NONE = "None"
    #: Stage is in progress.
    IN_PROGRESS = "InProgress"
    #: Stage has succeeded.
    SUCCEEDED = "Succeeded"
    #: Stage has failed.
    FAILED = "Failed"
    #: Stage has been cancelled.
    CANCELLED = "Cancelled"
    #: Stage is cancelling.
    CANCELLING = "Cancelling"

class SupportedFilterTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of product filter.
    """

    #: Ship to country.
    SHIP_TO_COUNTRIES = "ShipToCountries"
    #: Double encryption status.
    DOUBLE_ENCRYPTION_STATUS = "DoubleEncryptionStatus"

class TransportShipmentTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates Shipment Logistics type that the customer preferred.
    """

    #: Shipment Logistics is handled by the customer.
    CUSTOMER_MANAGED = "CustomerManaged"
    #: Shipment Logistics is handled by Microsoft.
    MICROSOFT_MANAGED = "MicrosoftManaged"

class WeightMeasurementUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Unit for the dimensions of weight.
    """

    #: Pounds.
    LBS = "LBS"
    #: Kilograms.
    KGS = "KGS"
